/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.sys.domain.FileServer;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.FileDownloadMeta;
import com.geoway.ns.sys.dto.FilePart;
import com.geoway.ns.sys.dto.FileStoreMeta;
import com.geoway.ns.sys.dto.FileUploadResponse;
import com.geoway.ns.sys.dto.FileUploadTask;
import com.geoway.ns.sys.dto.UploadingFileInfo;
import com.geoway.ns.sys.service.RedisLockService;
import com.geoway.ns.sys.service.ShareFileService;
import com.geoway.ns.sys.utils.ObjectKeyUtil;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ShareFileServiceImpl
implements ShareFileService {
    private static final Logger log = LoggerFactory.getLogger(ShareFileServiceImpl.class);
    @Value(value="${project.workDir:cache}")
    protected String workDir;
    @Autowired
    RedisLockService redisLockService;
    @Autowired
    private RedisTemplate redisTemplate;

    @Override
    public FileStoreMeta sendFile(FileServer fileServer, MultipartFile file, String objectName) throws IOException {
        String storeFilePath;
        File storeFile;
        File dir;
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        String fileName = file.getOriginalFilename();
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        String storePath = fileServer.getEndpoint();
        String bucket = fileServer.getBucket();
        if (StrUtil.isBlank((CharSequence)objectName)) {
            objectName = ObjectKeyUtil.formatObjectName(fileName);
        }
        if (!(dir = (storeFile = new File(storeFilePath = storePath + File.separator + bucket + File.separator + objectName)).getParentFile()).exists()) {
            if (dir.mkdirs()) {
                log.info("----\u521b\u5efa\u5171\u4eab\u6587\u4ef6\u5939\u76ee\u5f55\u6210\u529f----");
            } else {
                log.error("----\u521b\u5efa\u5171\u4eab\u6587\u4ef6\u5939\u76ee\u5f55\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01----");
            }
        }
        file.transferTo(storeFile);
        fileStoreMeta.setAbsolutePath(fileServer.getUrl() + "/" + objectName);
        fileStoreMeta.setRelPath(objectName);
        fileStoreMeta.setName(fileName);
        fileStoreMeta.setFileSize(storeFile.length());
        fileStoreMeta.setFileType(fileType);
        return fileStoreMeta;
    }

    @Override
    public FileStoreMeta buildThumbnailFile(FileServer fileServer, String objectName) throws IOException {
        String[] videoTypes;
        boolean videoFlag;
        String[] officeTypes;
        boolean officeFlag;
        boolean pdfFlag;
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        String storePath = fileServer.getEndpoint();
        String bucket = fileServer.getBucket();
        String storeFilePath = storePath + File.separator + bucket + File.separator + objectName;
        File file = new File(storeFilePath);
        String fileType = objectName.substring(objectName.lastIndexOf(".") + 1).toLowerCase();
        String[] photoTypes = new String[]{"png", "jpg", "jpeg", "bmp"};
        boolean photoflag = Arrays.stream(photoTypes).anyMatch(type -> type.equalsIgnoreCase(fileType));
        if (photoflag) {
            String minObjectName = objectName.replace("." + fileType, "-min." + fileType);
            String minFilePath = storePath + File.separator + bucket + File.separator + minObjectName;
            File thunmailFile = new File(minFilePath);
            Thumbnails.of((File[])new File[]{file}).scale(0.1).toFile(thunmailFile);
            fileStoreMeta.setAbsolutePath(fileServer.getUrl() + "/" + minObjectName);
            fileStoreMeta.setName(thunmailFile.getName());
            fileStoreMeta.setFileSize(thunmailFile.length());
            fileStoreMeta.setFileType(fileType);
            fileStoreMeta.setRelPath(minObjectName);
        }
        if (pdfFlag = "pdf".equalsIgnoreCase(fileType)) {
            // empty if block
        }
        if (officeFlag = Arrays.stream(officeTypes = new String[]{"doc", "docx", "xls", "xlsx", "ppt", "pptx"}).anyMatch(type -> type.equalsIgnoreCase(fileType))) {
            // empty if block
        }
        if (videoFlag = Arrays.stream(videoTypes = new String[]{"mp4", "avi"}).anyMatch(type -> type.equalsIgnoreCase(fileType))) {
            // empty if block
        }
        return fileStoreMeta;
    }

    @Override
    public void deleteFile(FileServer fileServer, String objectName) throws IOException {
        String storePath = fileServer.getEndpoint();
        String bucket = fileServer.getBucket();
        String storeFilePath = storePath + File.separator + bucket + File.separator + objectName;
        File file = new File(storeFilePath);
        file.delete();
    }

    @Override
    public String buildPreviewURL(FileServer fileServer, String objectName, Integer expires) throws Exception {
        String url = fileServer.getUrl() + "/" + objectName;
        return url;
    }

    @Override
    public byte[] createThumbnail(FileServer fileServer, String objectName) throws Exception {
        String storePath = fileServer.getEndpoint();
        String bucket = fileServer.getBucket();
        String storeFilePath = storePath + File.separator + bucket + File.separator + objectName;
        File file = new File(storeFilePath);
        String minFilePath = this.workDir + File.separator + objectName;
        File thunmailFile = new File(minFilePath);
        File pParentFile = thunmailFile.getParentFile();
        if (!pParentFile.exists()) {
            pParentFile.mkdirs();
        }
        Thumbnails.of((File[])new File[]{file}).scale(0.1).toFile(thunmailFile);
        byte[] thumnailBytes = FileUtil.readBytes((File)thunmailFile);
        thunmailFile.delete();
        return thumnailBytes;
    }

    @Override
    public FileDownloadMeta downLoadFile(FileServer fileServer, String objectName) throws Exception {
        FileDownloadMeta fileDownloadMeta = new FileDownloadMeta();
        String storePath = fileServer.getEndpoint();
        String bucket = fileServer.getBucket();
        String storeFilePath = storePath + File.separator + bucket + File.separator + objectName;
        File file = new File(storeFilePath);
        FileInputStream inputStream = new FileInputStream(file);
        fileDownloadMeta.setFileSize(file.length());
        fileDownloadMeta.setInputStream(inputStream);
        return fileDownloadMeta;
    }

    @Override
    public FileStoreMeta sendFile(FileServer fileServer, InputStream stream, String objectName, String contentType) throws Exception {
        String storeFilePath;
        File storeFile;
        File dir;
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        String bucket = fileServer.getBucket();
        String tempFileName = objectName;
        String fileType = null;
        String storePath = fileServer.getEndpoint();
        if (StrUtil.isBlank((CharSequence)objectName)) {
            fileType = ObjectKeyUtil.getFileSuffixByContentType(contentType);
            tempFileName = UUID.randomUUID().toString() + ObjectKeyUtil.getFileSuffixByContentType(contentType);
            objectName = ObjectKeyUtil.formatObjectName(tempFileName);
        }
        if (!(dir = (storeFile = new File(storeFilePath = storePath + File.separator + bucket + File.separator + objectName)).getParentFile()).exists()) {
            if (dir.mkdirs()) {
                log.info("----\u521b\u5efa\u5171\u4eab\u6587\u4ef6\u5939\u76ee\u5f55\u6210\u529f----");
            } else {
                log.error("----\u521b\u5efa\u5171\u4eab\u6587\u4ef6\u5939\u76ee\u5f55\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01----");
            }
        }
        try (FileOutputStream outputStream = new FileOutputStream(storeFile);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = stream.read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, length);
            }
        }
        fileStoreMeta.setAbsolutePath(fileServer.getUrl() + "/" + objectName);
        fileStoreMeta.setRelPath(objectName);
        fileStoreMeta.setName(tempFileName);
        fileStoreMeta.setFileSize(storeFile.length());
        fileStoreMeta.setFileType(fileType);
        return fileStoreMeta;
    }

    @Override
    public UploadingFileInfo upLoadFileByChunk(FileServer fileServer, String code, String originalFileName, MultipartFile chunk, UploadingFileInfo uploadInfo, Boolean isParallel) throws Exception {
        if (uploadInfo == null) {
            uploadInfo = new UploadingFileInfo();
        }
        String fileName = uploadInfo.getFileName();
        String md5 = uploadInfo.getMd5();
        Integer chunkIndex = uploadInfo.getChunkIndex();
        String bucket = fileServer.getBucket();
        String storePath = fileServer.getEndpoint();
        String directoryPath = storePath + File.separator + bucket + File.separator + "fileResource" + File.separator + fileName.replaceAll("_" + chunkIndex, "");
        File file = new File(directoryPath);
        if (!file.exists()) {
            if (file.mkdirs()) {
                log.info("----\u521b\u5efa\u5171\u4eab\u6587\u4ef6\u5939\u76ee\u5f55\u6210\u529f----");
            } else {
                log.error("----\u521b\u5efa\u5171\u4eab\u6587\u4ef6\u5939\u76ee\u5f55\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01----");
            }
        }
        String filePath = directoryPath + File.separator + fileName;
        File saveFile = new File(filePath);
        chunk.transferTo(saveFile);
        if (isParallel.booleanValue()) {
            Long start = System.currentTimeMillis();
            if (this.redisLockService.lock("UploadingFilesMD5" + md5, chunkIndex + "", true, false)) {
                Gson gson;
                JSONObject uploadInfoOld;
                String uploadInfoOldStr = (String)this.redisTemplate.opsForHash().get((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName));
                List chunkIndexs = null;
                if (StringUtils.isNotEmpty((CharSequence)uploadInfoOldStr) && (uploadInfoOld = (JSONObject)(gson = new Gson()).fromJson(uploadInfoOldStr, JSONObject.class)) != null) {
                    chunkIndexs = (List)uploadInfoOld.get((Object)"chunkIndexs");
                }
                if (chunkIndexs == null) {
                    chunkIndexs = Collections.synchronizedList(new ArrayList());
                }
                chunkIndexs.add(chunkIndex);
                uploadInfo.setChunkIndexs(chunkIndexs);
                this.redisTemplate.opsForHash().put((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName), (Object)JSON.toJSONString((Object)uploadInfo));
                this.redisLockService.unlock("UploadingFilesMD5" + md5, chunkIndex + "");
            }
            Long end = System.currentTimeMillis();
            System.out.println("chunk\uff1a" + chunkIndex + "\uff0c\u8017\u65f6\uff1a" + (end - start));
        } else {
            this.redisTemplate.opsForHash().put((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName), (Object)JSON.toJSONString((Object)uploadInfo));
        }
        return uploadInfo;
    }

    @Override
    public FileUploadResponse upLoadFileCompleteWithMerge(FileServer fileServer, UploadingFileInfo uploadInfo) throws Exception {
        String fileName = uploadInfo.getFileName();
        Integer chunkIndex = uploadInfo.getChunkIndex();
        String md5 = uploadInfo.getMd5();
        String originalFileName = uploadInfo.getOriginalFileName();
        String preName = fileName.substring(0, fileName.lastIndexOf("_"));
        String bucket = fileServer.getBucket();
        String storePath = fileServer.getEndpoint();
        String chunkFileFolderPath = storePath + File.separator + bucket + File.separator + "fileResource" + File.separator + fileName.replaceAll("_" + chunkIndex, "");
        final File chunkFileFolder = new File(chunkFileFolderPath);
        if (!chunkFileFolder.exists()) {
            if (chunkFileFolder.mkdirs()) {
                log.info("----\u521b\u5efa\u5171\u4eab\u6587\u4ef6\u5939\u76ee\u5f55\u6210\u529f----");
            } else {
                log.error("----\u521b\u5efa\u5171\u4eab\u6587\u4ef6\u5939\u76ee\u5f55\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01----");
            }
        }
        String mergeFilePath = null;
        mergeFilePath = StringUtils.isNotEmpty((CharSequence)originalFileName) ? storePath + File.separator + bucket + File.separator + "fileResource" + File.separator + originalFileName : storePath + File.separator + bucket + File.separator + "fileResource" + File.separator + fileName;
        final File mergeFile = new File(mergeFilePath);
        File[] chunks = chunkFileFolder.listFiles();
        System.out.println(chunks.length);
        assert (chunks != null);
        List findchunkFiles = Arrays.stream(chunks).filter(file -> file.getName().startsWith(preName)).collect(Collectors.toList());
        final File[] files = (File[])findchunkFiles.stream().sorted(Comparator.comparing(o -> Integer.valueOf(o.getName().split("\\.")[0].split("_")[1]))).toArray(File[]::new);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    RandomAccessFile randomAccessFileWriter = new RandomAccessFile(mergeFile, "rw");
                    byte[] bytes = new byte[1024];
                    for (File chunk : files) {
                        int len;
                        RandomAccessFile randomAccessFileReader = new RandomAccessFile(chunk, "r");
                        while ((len = randomAccessFileReader.read(bytes)) != -1) {
                            randomAccessFileWriter.write(bytes, 0, len);
                        }
                        randomAccessFileReader.close();
                        System.out.println(chunk.getName());
                        chunk.delete();
                    }
                    randomAccessFileWriter.close();
                    chunkFileFolder.delete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
        String url = fileServer.getUrl();
        return FileUploadResponse.builder().absolutePath(mergeFile.getAbsolutePath()).relativePath(storePath + File.separator + bucket + mergeFile.getAbsolutePath().substring(mergeFile.getAbsolutePath().lastIndexOf("fileResource") + 13)).build();
    }

    @Override
    public List<FilePart> listUpLoadFileParts(FileServer fileServer, UploadingFileInfo uploadInfo) throws Exception {
        return null;
    }

    @Override
    public List<FileUploadTask> listUpLoadFileTasks(FileServer fileServer) throws Exception {
        Set keys = this.redisTemplate.opsForHash().keys((Object)"UploadingFilesMD5");
        ArrayList<FileUploadTask> fileParts = new ArrayList<FileUploadTask>();
        for (String upload : keys) {
            FileUploadTask fileUploadTask = new FileUploadTask();
            fileUploadTask.setUploadId(upload);
            String mdr = upload.substring(0, upload.indexOf("="));
            String originalFileName = upload.substring(upload.indexOf("=") + 1);
            fileUploadTask.setObjectKey(mdr);
            fileUploadTask.setBucketName(originalFileName);
            BeanUtils.copyProperties((Object)upload, (Object)fileUploadTask);
            fileParts.add(fileUploadTask);
        }
        return fileParts;
    }

    @Override
    public BaseResponse abortMultipartUpload(FileServer fileServer, UploadingFileInfo uploadInfo) {
        String fileName = uploadInfo.getFileName();
        Integer chunkIndex = uploadInfo.getChunkIndex();
        String md5 = uploadInfo.getMd5();
        String originalFileName = uploadInfo.getOriginalFileName();
        String preName = fileName.substring(0, fileName.lastIndexOf("_"));
        String bucket = fileServer.getBucket();
        String storePath = fileServer.getEndpoint();
        String chunkFileFolderPath = storePath + File.separator + bucket + File.separator + "fileResource" + File.separator + fileName.replaceAll("_" + chunkIndex, "");
        File chunkFileFolder = new File(chunkFileFolderPath);
        if (chunkFileFolder.exists()) {
            File[] chunks = chunkFileFolder.listFiles();
            Arrays.stream(chunks).forEach(t -> {
                if (t.exists()) {
                    t.delete();
                }
            });
        }
        this.redisTemplate.opsForHash().delete((Object)"UploadingFilesMD5", new Object[]{md5 + "=" + originalFileName});
        return BaseResponse.success("\u53d6\u6d88\u5206\u6bb5\u4e0a\u4f20\u4efb\u52a1\u6210\u529f");
    }

    @Override
    public BaseResponse abortMultipartUpload(FileServer fileServer, String objectKey, String uploadId) {
        throw new RuntimeException("ShareFileService\u4e0d\u652f\u6301\u6b64\u7c7b\u64cd\u4f5c\uff01");
    }

    @Override
    public FileStoreMeta sendObject2OssByMultiPart(FileServer fileServer, File file, String sendObjectName) {
        String storeFilePath;
        File storeFile;
        File dir;
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        String fileName = file.getName();
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        String storePath = fileServer.getEndpoint();
        String bucket = fileServer.getBucket();
        if (StrUtil.isBlank((CharSequence)sendObjectName)) {
            sendObjectName = ObjectKeyUtil.formatObjectName(fileName);
        }
        if (!(dir = (storeFile = new File(storeFilePath = storePath + File.separator + bucket + File.separator + sendObjectName)).getParentFile()).exists()) {
            if (dir.mkdirs()) {
                log.info("----\u521b\u5efa\u5171\u4eab\u6587\u4ef6\u5939\u76ee\u5f55\u6210\u529f----");
            } else {
                log.error("----\u521b\u5efa\u5171\u4eab\u6587\u4ef6\u5939\u76ee\u5f55\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01----");
            }
        }
        try {
            Files.copy(Paths.get(file.getAbsolutePath(), new String[0]), Paths.get(storeFilePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        fileStoreMeta.setAbsolutePath(fileServer.getUrl() + "/" + sendObjectName);
        fileStoreMeta.setRelPath(sendObjectName);
        fileStoreMeta.setName(fileName);
        fileStoreMeta.setFileSize(storeFile.length());
        fileStoreMeta.setFileType(fileType);
        return fileStoreMeta;
    }
}

