/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.config;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
public class OneMapThreadExecutorConfig {
    @Value(value="${threadPool.corePoolSize:40}")
    private int corePoolSize;
    @Value(value="${threadPool.maxPoolSize:40}")
    private int maxPoolSize;
    @Value(value="${threadPool.keepAliveSeconds:60}")
    private int keepAliveSeconds;
    @Value(value="${threadPool.queueCapacity:800000}")
    private int queueCapacity;
    @Value(value="${threadPool.allowCoreThreadTimeOut:false}")
    private boolean allowCoreThreadTimeOut;

    @Bean(name={"oneMapThreadPoolTaskExecutor"})
    public ThreadPoolTaskExecutor executor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.corePoolSize);
        executor.setKeepAliveSeconds(this.keepAliveSeconds);
        executor.setMaxPoolSize(this.maxPoolSize);
        executor.setQueueCapacity(this.queueCapacity);
        executor.setAllowCoreThreadTimeOut(this.allowCoreThreadTimeOut);
        executor.setThreadNamePrefix("yzfxExecutor-");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.initialize();
        return executor;
    }
}

