/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.sys.dto.SimpleRole;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.exception.TokenInvalidException;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.service.IUISConfigService;
import com.geoway.ns.sys.support.ServletUtils;
import com.geoway.ns.sys.utils.MyRequestUtil;
import com.geoway.ns.sys.utils.TokenUtil;
import com.geoway.sso.client.client.UserClient;
import com.geoway.sso.client.rpc.RpcSysRole;
import com.geoway.sso.client.rpc.RpcSysUser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TokenServiceImpl
implements ITokenService {
    @Autowired
    IUISConfigService uisConfigService;
    @Value(value="${security.token-prefix:'Geoway'}")
    private String guestTokenPrefix;
    @Value(value="${security.guest-userid:'guest'}")
    private String guestUserid;
    @Value(value="${security.guest-visit:false}")
    private Boolean guestVisit;
    @Autowired
    UserClient userClient;

    @Override
    public SysUserDTO queryCurrentSysUser() throws Exception {
        String token = ServletUtils.getHeaderValues("access_token");
        if (StrUtil.isBlank((CharSequence)token)) {
            token = ServletUtils.getHeaderValues("access-token");
        }
        if (StrUtil.isBlank((CharSequence)token)) {
            token = ServletUtils.getParameter("token");
        }
        return this.querySysUserByToken(token, true);
    }

    @Override
    public SysUserDTO queryCurrentSysUserWithNull() throws Exception {
        String token = ServletUtils.getHeaderValues("access_token");
        if (StrUtil.isBlank((CharSequence)token)) {
            token = ServletUtils.getHeaderValues("access-token");
        }
        if (StrUtil.isBlank((CharSequence)token)) {
            token = ServletUtils.getParameter("token");
        }
        if (StrUtil.isBlank((CharSequence)token)) {
            return null;
        }
        return this.querySysUserByToken(token, false);
    }

    @Override
    public String queryCurrentSysUserId() throws Exception {
        String token = ServletUtils.getHeaderValues("access_token");
        if (StrUtil.isBlank((CharSequence)token)) {
            token = ServletUtils.getHeaderValues("access-token");
        }
        if (StrUtil.isBlank((CharSequence)token)) {
            token = ServletUtils.getParameter("token");
        }
        if (StrUtil.isBlank((CharSequence)token)) {
            return null;
        }
        SysUserDTO userDTO = this.querySysUserByToken(token);
        return userDTO == null ? null : userDTO.getId();
    }

    @Override
    public SysUserDTO querySysUserByUserId(String token, String userId) throws Exception {
        if (token == null) {
            throw new TokenInvalidException();
        }
        SysUserDTO sysUser = this.queryUISSysUserByUserId(userId);
        return sysUser;
    }

    @Override
    public SysUserDTO querySysUserByToken(String token) throws Exception {
        return this.querySysUserByToken(token, false);
    }

    @Override
    public SysUserDTO querySysUserByToken(String token, Boolean isThrowException) throws Exception {
        if (token == null) {
            if (isThrowException.booleanValue()) {
                throw new TokenInvalidException();
            }
            return null;
        }
        SysUserDTO sysUser = this.queryUISSysUserByToken();
        return sysUser;
    }

    @Override
    public String getRoleIdsByToken(String token) throws Exception {
        String roleIds = "";
        if (StrUtil.isNotBlank((CharSequence)token)) {
            SysUserDTO sysUser = this.queryUISSysUserByToken();
            if (ObjectUtil.isEmpty((Object)sysUser) && StrUtil.isBlank((CharSequence)sysUser.getId())) {
                throw new Exception("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728,\u6216\u8005\u662ftoken\u6709\u8bef\u3001\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5165\u6216\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
            if ("admin".equals(sysUser.getUsername()) || "sysadmin".equals(sysUser.getUsername())) {
                return "all";
            }
            if (CollectionUtil.isEmpty(sysUser.getRoles())) {
                throw new Exception("\u7528\u6237\u65e0\u5bf9\u5e94\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
            ArrayList<SimpleRole> simpleRoles = new ArrayList<SimpleRole>(sysUser.getRoles());
            long count = simpleRoles.stream().filter(simpleRole -> simpleRole.getLevel() == 0).count();
            if (count > 0L) {
                return "all";
            }
            roleIds = simpleRoles.stream().map(SimpleRole::getId).collect(Collectors.joining(","));
        }
        return roleIds;
    }

    @Override
    public List<SysUserDTO> getUserList(String token) throws Exception {
        List userList = this.userClient.getUserList(null);
        ArrayList<SysUserDTO> users = new ArrayList<SysUserDTO>();
        if (userList != null && userList.size() > 0) {
            userList.forEach(user -> users.add(TokenServiceImpl.convertToSysUser(user)));
        }
        return users;
    }

    @Override
    public boolean isAdminRole(String role) {
        return role.equals("all");
    }

    @Override
    public String queryUserIdByRequest(HttpServletRequest request) throws Exception {
        SysUserDTO sysUser;
        String token = MyRequestUtil.queryAccessTokenInHeader(request);
        String userId = null;
        if (StrUtil.isNotBlank((CharSequence)token) && !"gtest".equals(token) && (sysUser = this.querySysUserByToken(token)) != null) {
            userId = sysUser.getId();
        }
        return userId;
    }

    @Override
    public Boolean isCheckerByToken(String token) throws Exception {
        SysUserDTO sysUserDTO = this.querySysUserByToken(token, true);
        return this.isChecker(sysUserDTO);
    }

    @Override
    public Boolean isChecker(SysUserDTO sysUser) throws Exception {
        if (sysUser == null || sysUser.getRoles() == null || sysUser.getRoles().size() == 0 || sysUser.getRoles().stream().filter(item -> item.getRolename().indexOf("\u5ba1\u6838\u5458") > -1).findFirst() == null) {
            return false;
        }
        return true;
    }

    @Override
    public SysUserDTO queryGuestUserByGuestToken(String guestToken, Boolean isThrowException) throws Exception {
        if (guestToken == null || !TokenUtil.validate(guestToken, this.guestTokenPrefix)) {
            throw new TokenInvalidException();
        }
        return TokenServiceImpl.convertToSysUser(this.userClient.getUserInfo(this.guestUserid));
    }

    private SysUserDTO queryUISSysUserByToken() throws Exception {
        RpcSysUser rpcSimpleUserDTO = this.userClient.getCurrentUserInfo();
        return TokenServiceImpl.convertToSysUser(rpcSimpleUserDTO);
    }

    private SysUserDTO queryUISSysUserByUserId(String userId) throws Exception {
        return TokenServiceImpl.convertToSysUser(this.userClient.getUserInfo(userId));
    }

    private JSONArray getLeafOrg(JSONArray data, int mLevel) {
        JSONArray result = new JSONArray();
        if (mLevel < 1) {
            return result;
        }
        for (int i = 0; i < data.size(); ++i) {
            JSONObject item = data.getJSONObject(i);
            if (item.getInteger("level") != mLevel) continue;
            result.add((Object)data.getJSONObject(i));
        }
        if (result.size() == 0) {
            return this.getLeafOrg(data, mLevel - 1);
        }
        return result;
    }

    public static SysUserDTO convertToSysUser(RpcSysUser source) {
        if (source == null) {
            return null;
        }
        SysUserDTO target = new SysUserDTO();
        BeanUtils.copyProperties((Object)source, (Object)target);
        target.setTel(source.getTel());
        target.setWorkTel(source.getWorktel());
        target.setAlisname(source.getAname());
        target.setUsername(source.getName());
        target.setCreateTime(source.getCreatetime());
        target.setUserLevel(source.getCatalog());
        target.setId(source.getId());
        if (ObjectUtil.isNotEmpty((Object)source.getOrgNames())) {
            target.setDeptName(String.join((CharSequence)",", source.getOrgNames()));
        }
        target.setImgId(source.getImgid());
        target.setEmail(source.getEmail());
        HashSet<SimpleRole> roles = new HashSet<SimpleRole>();
        if (source.getRoles() != null && source.getRoles().size() > 0) {
            for (int i2 = 0; i2 < source.getRoles().size(); ++i2) {
                RpcSysRole rpcSysRole = (RpcSysRole)source.getRoles().get(i2);
                SimpleRole simpleRole = new SimpleRole();
                simpleRole.setId(rpcSysRole.getId());
                simpleRole.setRolename(rpcSysRole.getName());
                simpleRole.setLevel(1);
                simpleRole.setState(1);
                roles.add(simpleRole);
            }
        }
        target.setRoles(roles);
        if (source.getRegions() != null && source.getRegions().size() > 0) {
            String userXZQH = source.getRegions().stream().map(i -> i.getCode()).collect(Collectors.joining(","));
            target.setXzqdm(userXZQH);
        }
        if (source.getOrganizations() != null && source.getOrganizations().size() > 0) {
            String orgIds = source.getOrganizations().stream().map(f -> f.getId()).collect(Collectors.joining(","));
            target.setDeptId(orgIds);
            String orgNames = source.getOrganizations().stream().map(f -> f.getName()).collect(Collectors.joining(","));
            target.setDeptId(orgIds);
            target.setDeptName(orgNames);
        }
        target.setSex(source.getSex());
        return target;
    }
}

