/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.utils;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.lang.tree.TreeUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class BaseTreeUtil {
    public static <T> List<Tree<String>> listBuildTree(List<T> list, Class<?> clazz, TreeNodeConfig treeNodeConfig) {
        return BaseTreeUtil.listBuildTree(list, clazz, treeNodeConfig, "-1");
    }

    public static <T> List<Tree<String>> listBuildTree(List<T> list, Class<?> clazz, TreeNodeConfig treeNodeConfig, String parentId) {
        return TreeUtil.build(list, (Object)parentId, (TreeNodeConfig)treeNodeConfig, (t, tree) -> {
            Field[] fields;
            for (Field field : fields = ReflectUtil.getFieldsDirectly((Class)clazz, (boolean)true)) {
                String fieldName = field.getName();
                Object fieldValue = ReflectUtil.getFieldValue((Object)t, (Field)field);
                if (fieldValue instanceof Date) {
                    tree.putExtra(fieldName, (Object)DateUtil.formatDateTime((Date)((Date)fieldValue)));
                    continue;
                }
                tree.putExtra(fieldName, fieldValue);
            }
        });
    }

    public static <T> List<T> listToTree(List<T> tList, TreeNodeConfig treeNodeConfig) {
        return BaseTreeUtil.listToTree(tList, treeNodeConfig, "-1");
    }

    public static <T> List<T> listToTree(List<T> tList, TreeNodeConfig treeNodeConfig, String parentId) {
        if (tList != null && !tList.isEmpty()) {
            return tList.stream().filter(root -> parentId.equals(ReflectUtil.getFieldValue((Object)root, (String)treeNodeConfig.getParentIdKey()))).peek(children -> ReflectUtil.setFieldValue((Object)children, (String)treeNodeConfig.getChildrenKey(), BaseTreeUtil.getChildren(children, tList, treeNodeConfig))).sorted(Comparator.nullsLast(Comparator.comparingInt(o -> Convert.toInt((Object)ReflectUtil.getFieldValue((Object)o, (String)treeNodeConfig.getWeightKey()), (Integer)0)))).collect(Collectors.toList());
        }
        return new ArrayList();
    }

    public static <T> List<T> treeListToList(List<T> tList, final List<T> all, final TreeNodeConfig treeNodeConfig) {
        tList.stream().forEach(new Consumer<T>(){

            @Override
            public void accept(T t) {
                List childT = (List)ReflectUtil.getFieldValue(t, (String)treeNodeConfig.getChildrenKey());
                ReflectUtil.setFieldValue(t, (String)treeNodeConfig.getChildrenKey(), null);
                all.add(t);
                if (childT != null && childT.size() > 0) {
                    BaseTreeUtil.treeListToList(childT, all, treeNodeConfig);
                }
            }
        });
        return new ArrayList();
    }

    private static <T> List<T> getChildren(T root, List<T> all, TreeNodeConfig treeNodeConfig) {
        return all.stream().filter(menu -> ReflectUtil.getFieldValue((Object)root, (String)treeNodeConfig.getIdKey()).equals(ReflectUtil.getFieldValue((Object)menu, (String)treeNodeConfig.getParentIdKey()))).peek(children -> ReflectUtil.setFieldValue((Object)children, (String)treeNodeConfig.getChildrenKey(), BaseTreeUtil.getChildren(children, all, treeNodeConfig))).sorted(Comparator.nullsLast(Comparator.comparingInt(o -> Convert.toInt((Object)ReflectUtil.getFieldValue((Object)o, (String)treeNodeConfig.getWeightKey()), (Integer)0)))).collect(Collectors.toList());
    }

    public static void treeList2List(List<Map> treeList, List<Map> list, StringBuffer parentName) {
        if (ObjectUtil.isNull((Object)parentName)) {
            parentName = new StringBuffer();
        }
        for (Map t : treeList) {
            List children = (List)t.get("children");
            t.remove("children");
            if (ObjectUtil.isNotNull((Object)children)) {
                t.put("name", parentName.append("/").append(t.get("name")).toString().replaceFirst("/", ""));
                list.add(t);
                BaseTreeUtil.treeList2List(children, list, parentName);
                continue;
            }
            t.put("name", (parentName + "/" + t.get("name")).replaceFirst("/", ""));
            list.add(t);
        }
        if (parentName.indexOf("/") != -1) {
            parentName.delete(parentName.lastIndexOf("/"), parentName.length());
        }
    }
}

