/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.controller;

import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.sys.annotation.WhiteRequest;
import com.geoway.ns.sys.dto.BaseObjectResponse;
import com.geoway.ns.sys.dto.RestResult;
import com.geoway.ns.sys.service.IUISConfigService;
import com.geoway.sso.client.client.SsoClient;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u767b\u5f55\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/login"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    IUISConfigService uisConfigService;
    @Autowired
    private SsoClient ssoClient;

    @WhiteRequest(value=true)
    @ApiOperation(value="1-\u57fa\u4e8e\u7701\u5385\u7edf\u4e00\u767b\u5165\u63a5\u53e3\u8fd4\u56de\u7684code\u8fdb\u884c\u767b\u5165\uff0c\u83b7\u53d6accessToken")
    @RequestMapping(value={"/queryAccesTokenByCode"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public BaseObjectResponse queryAccesTokenByCode(HttpServletRequest request, @RequestParam(value="code") String code) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            String url = this.uisConfigService.getUISURL() + "/authCenter/Login";
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("code", code);
            String result = HttpUtil.createRequest((Method)Method.POST, (String)url).form(paramMap).execute().body();
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (jsonObject.containsKey((Object)"status") && "OK".equals(jsonObject.getString("status"))) {
                String accessToken = jsonObject.getString("token");
                jsonObject.remove((Object)"status");
                jsonObject.remove((Object)"code");
                jsonObject.remove((Object)"message");
                response.setData(jsonObject);
            } else {
                response.markFailure("\u7edf\u4e00\u767b\u5f55\u67e5\u8be2token\u5f02\u5e38");
            }
        }
        catch (Exception ex) {
            log.error("\u67e5\u8be2token\u5f02\u5e38", (Throwable)ex);
            response.markFailure("\u67e5\u8be2token\u5f02\u5e38:" + ex.getMessage());
        }
        return response;
    }

    @ApiOperation(value="2-\u4e00\u6b21\u6027\u4ee4\u724c\u83b7\u53d6")
    @RequestMapping(value={"/queryCode"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public RestResult<String> queryCode(HttpServletRequest request, @RequestParam(value="token") String token) {
        try {
            return RestResult.success(this.ssoClient.getAccessCode(token));
        }
        catch (Exception e) {
            return RestResult.error(e.getMessage());
        }
    }
}

