/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.utils;

import cn.hutool.core.collection.CollectionUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class SqlUtil {
    public static <T> List<String> getInsertSql(List<T> list, String table) {
        if (!CollectionUtil.isEmpty(list)) {
            ArrayList<String> results = new ArrayList<String>();
            for (T t : list) {
                try {
                    Map<String, Object> map = SqlUtil.beanToMap(t);
                    StringBuffer head = new StringBuffer("INSERT INTO `" + table + "` ( ");
                    StringBuffer end = new StringBuffer(" ) VALUES ( ");
                    for (String key : map.keySet()) {
                        Comparable<BigDecimal> b;
                        head.append(" `" + key + "`,");
                        Object val = map.get(key);
                        if (val == null) {
                            end.append(" null , ");
                            continue;
                        }
                        if (val instanceof BigDecimal) {
                            b = new BigDecimal(val.toString());
                            b = b != null ? ((BigDecimal)b).setScale(2, 5) : BigDecimal.ZERO;
                            end.append(" '" + ((BigDecimal)b).floatValue() + "', ");
                            continue;
                        }
                        if (val instanceof Date) {
                            b = (Date)val;
                            end.append(" '" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)b) + "', ");
                            continue;
                        }
                        end.append(" '" + val.toString() + "', ");
                    }
                    String result = head.toString();
                    result = result.substring(0, result.length() - 1);
                    String ttt = end.toString();
                    result = result + ttt.substring(0, ttt.length() - 2) + " ); ";
                    results.add(result);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return results;
        }
        return null;
    }

    public static Map<String, Object> beanToMap(Object object) throws IllegalAccessException {
        Field[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(object));
        }
        return map;
    }
}

