/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.geoway.ns.sys.domain.FileServer;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.FileDownloadMeta;
import com.geoway.ns.sys.dto.FilePart;
import com.geoway.ns.sys.dto.FileStoreMeta;
import com.geoway.ns.sys.dto.FileUploadResponse;
import com.geoway.ns.sys.dto.FileUploadTask;
import com.geoway.ns.sys.dto.UploadingFileInfo;
import com.geoway.ns.sys.service.MinIOFileService;
import com.geoway.ns.sys.service.RedisLockService;
import com.geoway.ns.sys.utils.CustomMinioClient;
import com.geoway.ns.sys.utils.ObjectKeyUtil;
import com.google.gson.Gson;
import com.obs.services.model.AbortMultipartUploadRequest;
import com.obs.services.model.ListMultipartUploadsRequest;
import com.obs.services.model.ListPartsRequest;
import io.minio.AbortMultipartUploadResponse;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListMultipartUploadsResponse;
import io.minio.ListPartsResponse;
import io.minio.MakeBucketArgs;
import io.minio.MinioAsyncClient;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.SetBucketPolicyArgs;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.UploadPartResponse;
import io.minio.http.Method;
import io.minio.messages.Part;
import io.minio.messages.Upload;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.coobird.thumbnailator.Thumbnails;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MinIOFileServiceImpl
implements MinIOFileService {
    private static final Logger log = LoggerFactory.getLogger(MinIOFileServiceImpl.class);
    @Value(value="${project.workDir:cache}")
    protected String workDir;
    @Autowired
    private RedisTemplate redisTemplate;
    private MinioClient _minioClient;
    private int _currentServerId = 0;
    @Autowired
    RedisLockService redisLockService;

    @Override
    public MinioClient getOssClient(FileServer fileServer) throws Exception {
        boolean secure = fileServer.getEndpoint() != null && fileServer.getEndpoint().startsWith("https://");
        MinioClient minioClient = MinioClient.builder().endpoint(fileServer.getEndpoint()).credentials(fileServer.getAppkey(), fileServer.getAppsecret()).build();
        return minioClient;
    }

    public CustomMinioClient getOssCustomMinioClient(FileServer fileServer) throws Exception {
        boolean secure = fileServer.getEndpoint() != null && fileServer.getEndpoint().startsWith("https://");
        MinioAsyncClient minioClient = CustomMinioClient.builder().endpoint(fileServer.getEndpoint()).credentials(fileServer.getAppkey(), fileServer.getAppsecret()).build();
        return new CustomMinioClient(minioClient);
    }

    @Override
    public FileStoreMeta sendFile(FileServer fileServer, MultipartFile file, String objectName) throws Exception {
        MinioClient minioClient;
        boolean isExists;
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        String fileName = file.getOriginalFilename();
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        String bucket = fileServer.getBucket();
        if (StrUtil.isBlank((CharSequence)objectName)) {
            objectName = ObjectKeyUtil.formatObjectName(fileName);
        }
        if (!(isExists = (minioClient = this.getOssClient(fileServer)).bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucket)).build()))) {
            this.CreateBucket(minioClient, bucket);
        }
        PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(objectName)).stream(file.getInputStream(), file.getSize(), -1L).contentType(file.getContentType()).build();
        ObjectWriteResponse objectWriteResponse = minioClient.putObject(putObjectArgs);
        GetPresignedObjectUrlArgs getPresignedObjectUrlArgs = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucket)).object(objectName)).build();
        String url = minioClient.getPresignedObjectUrl(getPresignedObjectUrlArgs);
        StatObjectArgs statObjectArgs = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucket)).object(objectName)).build();
        StatObjectResponse objMeta = minioClient.statObject(statObjectArgs);
        fileStoreMeta.setAbsolutePath(url);
        fileStoreMeta.setRelPath(objectName);
        fileStoreMeta.setName(fileName);
        fileStoreMeta.setFileSize(objMeta.size());
        fileStoreMeta.setFileType(fileType);
        fileStoreMeta.setPreviewURL(this.buildPreviewURL(fileServer, objectName, 30));
        return fileStoreMeta;
    }

    @Override
    public FileStoreMeta sendFile(FileServer fileServer, String fileName, String objectName) throws Exception {
        MinioClient minioClient;
        boolean isExists;
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        File file = new File(fileName);
        String shortName = file.getName();
        String fileType = shortName.substring(shortName.lastIndexOf(".") + 1);
        String bucket = fileServer.getBucket();
        if (StrUtil.isBlank((CharSequence)objectName)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String foldName = simpleDateFormat.format(new Date());
            objectName = foldName + "/" + System.currentTimeMillis() + "/" + fileName;
        }
        if (!(isExists = (minioClient = this.getOssClient(fileServer)).bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucket)).build()))) {
            this.CreateBucket(minioClient, bucket);
        }
        PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(objectName)).stream((InputStream)new FileInputStream(file), file.length(), -1L).contentType(ObjectKeyUtil.getContentTypeByFileType(fileType)).build();
        ObjectWriteResponse objectWriteResponse = minioClient.putObject(putObjectArgs);
        GetPresignedObjectUrlArgs getPresignedObjectUrlArgs = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucket)).object(objectName)).build();
        String url = minioClient.getPresignedObjectUrl(getPresignedObjectUrlArgs);
        fileStoreMeta.setAbsolutePath(url);
        fileStoreMeta.setRelPath(objectName);
        fileStoreMeta.setName(shortName);
        fileStoreMeta.setFileSize(file.length());
        fileStoreMeta.setFileType(fileType);
        return fileStoreMeta;
    }

    @Override
    public FileStoreMeta sendFile(FileServer fileServer, InputStream stream, String objectName, String contentType) throws Exception {
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        String bucket = fileServer.getBucket();
        MinioClient minioClient = this.getOssClient(fileServer);
        boolean isExists = minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucket)).build());
        if (!isExists) {
            this.CreateBucket(minioClient, bucket);
        }
        if (StrUtil.isBlank((CharSequence)objectName)) {
            String fileType = ObjectKeyUtil.getFileSuffixByContentType(contentType);
            String tempFileName = UUID.randomUUID().toString() + ObjectKeyUtil.getFileSuffixByContentType(contentType);
            objectName = ObjectKeyUtil.formatObjectName(tempFileName);
        }
        objectName = "/" + System.currentTimeMillis() + "/" + objectName;
        PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(objectName)).stream(stream, -1L, -1L).contentType(contentType).build();
        ObjectWriteResponse objectWriteResponse = minioClient.putObject(putObjectArgs);
        GetPresignedObjectUrlArgs getPresignedObjectUrlArgs = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucket)).object(objectName)).build();
        String url = minioClient.getPresignedObjectUrl(getPresignedObjectUrlArgs);
        fileStoreMeta.setAbsolutePath(url);
        fileStoreMeta.setRelPath(objectName);
        fileStoreMeta.setPreviewURL(url);
        return fileStoreMeta;
    }

    @Override
    public FileStoreMeta buildThumbnailFile(FileServer fileServer, String objectName) throws Exception {
        String[] videoTypes;
        boolean videoFlag;
        String[] officeTypes;
        boolean officeFlag;
        boolean pdfFlag;
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        String fileType = objectName.substring(objectName.lastIndexOf(".") + 1).toLowerCase();
        String minObjectName = objectName.replace("." + fileType, "-min." + fileType);
        String fileName = minObjectName.substring(minObjectName.lastIndexOf("/") + 1);
        String bucket = fileServer.getBucket();
        MinioClient minioClient = this.getOssClient(fileServer);
        GetObjectArgs getObjectResponse = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucket)).object(objectName)).build();
        GetObjectResponse inputStream = minioClient.getObject(getObjectResponse);
        String[] photoTypes = new String[]{"png", "jpg", "jpeg", "bmp"};
        boolean photoflag = Arrays.stream(photoTypes).anyMatch(type -> type.equalsIgnoreCase(fileType));
        if (photoflag) {
            int height;
            BufferedImage bufferedImage = ImageIO.read((InputStream)inputStream);
            int width = bufferedImage.getWidth();
            int max = width > (height = bufferedImage.getHeight()) ? width : height;
            int w = 0;
            int h = 0;
            if (max <= 360) {
                w = width;
                h = height;
            } else {
                double scale = 360.0 / (double)max;
                w = (int)((double)width * scale);
                h = (int)((double)height * scale);
            }
            inputStream.close();
            inputStream = minioClient.getObject(getObjectResponse);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Thumbnails.of((InputStream[])new InputStream[]{inputStream}).size(w, h).toOutputStream((OutputStream)out);
            inputStream.close();
            byte[] thumbBytes = out.toByteArray();
            long fileSize = thumbBytes.length;
            ByteArrayInputStream byteStream = new ByteArrayInputStream(thumbBytes);
            PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(minObjectName)).stream((InputStream)byteStream, fileSize, -1L).contentType(ObjectKeyUtil.getContentTypeByFileType(fileType)).build();
            ObjectWriteResponse objectWriteResponse = minioClient.putObject(putObjectArgs);
            ((InputStream)byteStream).close();
            out.close();
            GetPresignedObjectUrlArgs getPresignedObjectUrlArgs = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucket)).object(objectName)).build();
            String url = minioClient.getPresignedObjectUrl(getPresignedObjectUrlArgs);
            fileStoreMeta.setAbsolutePath(url);
            fileStoreMeta.setRelPath(minObjectName);
            fileStoreMeta.setName(fileName);
            fileStoreMeta.setFileType(fileType);
        }
        if (pdfFlag = "pdf".equalsIgnoreCase(fileType)) {
            // empty if block
        }
        if (officeFlag = Arrays.stream(officeTypes = new String[]{"doc", "docx", "xls", "xlsx", "ppt", "pptx"}).anyMatch(type -> type.equalsIgnoreCase(fileType))) {
            // empty if block
        }
        if (videoFlag = Arrays.stream(videoTypes = new String[]{"mp4", "avi"}).anyMatch(type -> type.equalsIgnoreCase(fileType))) {
            // empty if block
        }
        return fileStoreMeta;
    }

    @Override
    public void deleteFile(FileServer fileServer, String bucket, String path) throws Exception {
        MinioClient minioClient = this.getOssClient(fileServer);
        RemoveObjectArgs removeObjectArgs = (RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucket)).object(path)).build();
        minioClient.removeObject(removeObjectArgs);
    }

    @Override
    public String buildPreviewURL(FileServer fileServer, String objectName, Integer expires) throws Exception {
        MinioClient minioClient = this.getOssClient(fileServer);
        StatObjectArgs statObjectArgs = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(fileServer.getBucket())).object(objectName)).build();
        StatObjectResponse objectStat = minioClient.statObject(statObjectArgs);
        GetPresignedObjectUrlArgs getPresignedObjectUrlArgs = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(fileServer.getBucket())).object(objectName)).build();
        String url = minioClient.getPresignedObjectUrl(getPresignedObjectUrlArgs);
        String contentType = objectStat.contentType();
        if (StrUtil.isNotBlank((CharSequence)contentType) && contentType.toLowerCase().contains("image")) {
            minioClient = MinioClient.builder().endpoint(fileServer.getUrl()).credentials(fileServer.getAppkey(), fileServer.getAppsecret()).build();
            url = minioClient.getPresignedObjectUrl(getPresignedObjectUrlArgs);
        }
        return url;
    }

    @Override
    public byte[] createThumbnail(FileServer fileServer, String objectName) throws Exception {
        int height;
        GetObjectArgs getObjectResponse;
        String bucket = fileServer.getBucket();
        MinioClient minioClient = this.getOssClient(fileServer);
        GetObjectResponse inputStream = minioClient.getObject(getObjectResponse = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucket)).object(objectName)).build());
        BufferedImage bufferedImage = ImageIO.read((InputStream)inputStream);
        int width = bufferedImage.getWidth();
        int max = width > (height = bufferedImage.getHeight()) ? width : height;
        int w = 0;
        int h = 0;
        if (max <= 300) {
            w = width;
            h = height;
        } else {
            double scale = 300.0 / (double)max;
            w = (int)((double)width * scale);
            h = (int)((double)height * scale);
        }
        inputStream.close();
        inputStream = minioClient.getObject(getObjectResponse);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Thumbnails.of((InputStream[])new InputStream[]{inputStream}).size(w, h).toOutputStream((OutputStream)out);
        inputStream.close();
        byte[] thumnailBytes = out.toByteArray();
        out.close();
        return thumnailBytes;
    }

    @Override
    public FileDownloadMeta downLoadFile(FileServer fileServer, String objectName) throws Exception {
        FileDownloadMeta fileDownloadMeta = new FileDownloadMeta();
        MinioClient minioClient = this.getOssClient(fileServer);
        StatObjectArgs statObjectArgs = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(fileServer.getBucket())).object(objectName)).build();
        StatObjectResponse objectStat = minioClient.statObject(statObjectArgs);
        fileDownloadMeta.setFileSize(objectStat.size());
        GetObjectArgs getObjectResponse = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(fileServer.getBucket())).object(objectName)).build();
        GetObjectResponse inputStream = minioClient.getObject(getObjectResponse);
        fileDownloadMeta.setInputStream((InputStream)inputStream);
        return fileDownloadMeta;
    }

    @Override
    public UploadingFileInfo upLoadFileByChunk(FileServer fileServer, String code, String originalFileName, MultipartFile chunk, UploadingFileInfo uploadInfo, Boolean isParallel) throws Exception {
        if (uploadInfo == null) {
            uploadInfo = new UploadingFileInfo();
        }
        String bucketName = fileServer.getBucket();
        CustomMinioClient minioClient = this.getOssCustomMinioClient(fileServer);
        String objectKey = uploadInfo.getObjectKey();
        if (StringUtils.isEmpty((CharSequence)objectKey)) {
            if (StringUtils.isEmpty((CharSequence)code) || StringUtils.isEmpty((CharSequence)originalFileName)) {
                throw new Exception("code\uff0coriginalFileName\u4e24\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (code.length() == 12) {
                objectKey = code.substring(0, 6) + "/" + code.substring(0, 9) + "/" + code;
            } else if (code.length() == 9) {
                objectKey = code.substring(0, 6) + "/" + code;
            } else if (code.length() == 6) {
                objectKey = code;
            }
            objectKey = objectKey + "/" + originalFileName;
            objectKey = "test/" + objectKey;
            uploadInfo.setObjectKey(objectKey);
        }
        String uploadId = uploadInfo.getUploadId();
        String md5 = uploadInfo.getMd5();
        if (StringUtils.isEmpty((CharSequence)uploadId)) {
            uploadId = this.getUploadIdFromDB(md5, originalFileName);
        }
        Integer chunkIndex = uploadInfo.getChunkIndex();
        if (StringUtils.isEmpty((CharSequence)uploadId) && this.redisLockService.lock("UploadingFilesMD5" + md5, chunkIndex + "", true, false)) {
            uploadId = this.getUploadIdFromDB(md5, originalFileName);
            if (StringUtils.isEmpty((CharSequence)uploadId)) {
                uploadId = minioClient.initMultiPartUpload(bucketName, "", objectKey, null, null);
                uploadInfo.setUploadId(uploadId);
                this.redisTemplate.opsForHash().put((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName), (Object)JSON.toJSONString((Object)uploadInfo));
            }
            uploadInfo.setUploadId(uploadId);
            this.redisLockService.unlock("UploadingFilesMD5" + md5, chunkIndex + "");
        }
        CompletableFuture<UploadPartResponse> completableFuture = minioClient.uploadPartAsync(bucketName, "", objectKey, chunk.getInputStream(), chunk.getSize(), uploadId, chunkIndex + 1, null, null);
        UploadPartResponse uploadPartResponse = completableFuture.get();
        if (this.redisLockService.lock("UploadingFilesMD5" + md5, chunkIndex + "", true, false)) {
            String uploadInfoOldStr = (String)this.redisTemplate.opsForHash().get((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName));
            List<Object> partEtags = null;
            List<Integer> chunkIndexs = null;
            if (StringUtils.isNotEmpty((CharSequence)uploadInfoOldStr)) {
                Gson gson = new Gson();
                UploadingFileInfo uploadInfoOld = (UploadingFileInfo)gson.fromJson(uploadInfoOldStr, UploadingFileInfo.class);
                partEtags = uploadInfoOld.getPartEtags();
                chunkIndexs = uploadInfoOld.getChunkIndexs();
            }
            if (partEtags == null) {
                partEtags = Collections.synchronizedList(new ArrayList());
            }
            partEtags.add(new Part(uploadPartResponse.partNumber(), uploadPartResponse.etag()));
            uploadInfo.setPartEtags(partEtags);
            if (isParallel.booleanValue()) {
                if (chunkIndexs == null) {
                    chunkIndexs = Collections.synchronizedList(new ArrayList());
                }
                chunkIndexs.add(chunkIndex);
                uploadInfo.setChunkIndexs(chunkIndexs);
            }
            this.redisTemplate.opsForHash().put((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName), (Object)new Gson().toJson((Object)uploadInfo));
            this.redisLockService.unlock("UploadingFilesMD5" + md5, chunkIndex + "");
        }
        return uploadInfo;
    }

    @Override
    public FileUploadResponse upLoadFileCompleteWithMerge(FileServer fileServer, UploadingFileInfo uploadInfo) throws Exception {
        String bucketName = fileServer.getBucket();
        CustomMinioClient minioClient = this.getOssCustomMinioClient(fileServer);
        String objectKey = uploadInfo.getObjectKey();
        String uploadId = uploadInfo.getUploadId();
        List<Object> partEtagObjects = uploadInfo.getPartEtags();
        List<Part> partEtags = partEtagObjects.stream().map(obj -> {
            Gson gson = new Gson();
            return (Part)gson.fromJson(obj.toString(), Part.class);
        }).collect(Collectors.toList());
        Part[] partArray = partEtags.toArray(new Part[partEtags.size()]);
        Gson gson = new Gson();
        partEtags = partEtags.stream().sorted(Comparator.comparing(Part::partNumber)).collect(Collectors.toList());
        System.out.println(gson.toJson(partEtags));
        CompletableFuture<ObjectWriteResponse> completeMultipartUploadRequest = minioClient.mergeMultipartUpload(bucketName, "", objectKey, uploadId, partArray, null, null);
        ObjectWriteResponse objectWriteResponse = completeMultipartUploadRequest.get();
        if (objectWriteResponse == null) {
            throw new Exception("\u4e0a\u4f20\u5931\u8d25\uff1a");
        }
        String url = fileServer.getUrl() + "/" + objectWriteResponse.bucket() + "/" + objectWriteResponse.object();
        return FileUploadResponse.builder().absolutePath(url).relativePath(objectWriteResponse.bucket() + "@" + objectWriteResponse.object()).objectUrl(url).build();
    }

    @Override
    public List<FilePart> listUpLoadFileParts(FileServer fileServer, UploadingFileInfo uploadInfo) throws Exception {
        String bucketName = fileServer.getBucket();
        CustomMinioClient minioClient = this.getOssCustomMinioClient(fileServer);
        String objectKey = uploadInfo.getObjectKey();
        String uploadId = uploadInfo.getUploadId();
        ListPartsRequest request = new ListPartsRequest(bucketName, objectKey);
        request.setUploadId(uploadId);
        CompletableFuture<ListPartsResponse> completableFuture = minioClient.listPartsAsync(bucketName, "", objectKey, uploadInfo.getChunkCount(), null, uploadId, null, null);
        ListPartsResponse listPartsResponse = completableFuture.get();
        if (listPartsResponse == null || listPartsResponse.result() == null || listPartsResponse.result().partList() == null) {
            throw new Exception("\u83b7\u53d6\u5931\u8d25\uff1a");
        }
        ArrayList<FilePart> fileParts = new ArrayList<FilePart>();
        for (Part part : listPartsResponse.result().partList()) {
            FilePart filePart = new FilePart();
            BeanUtils.copyProperties((Object)part, (Object)filePart);
            fileParts.add(filePart);
        }
        System.out.println("listParts successfully");
        return fileParts;
    }

    @Override
    public List<FileUploadTask> listUpLoadFileTasks(FileServer fileServer) throws Exception {
        String bucketName = fileServer.getBucket();
        CustomMinioClient minioClient = this.getOssCustomMinioClient(fileServer);
        ListMultipartUploadsRequest request = new ListMultipartUploadsRequest(bucketName);
        CompletableFuture<ListMultipartUploadsResponse> completableFuture = minioClient.listMultipartUploadsAsync(bucketName, "", null, null, null, null, null, null, null, null);
        ListMultipartUploadsResponse listMultipartUploadsResponse = completableFuture.get();
        if (listMultipartUploadsResponse == null || listMultipartUploadsResponse.result() == null || listMultipartUploadsResponse.result().uploads() == null) {
            throw new Exception("\u83b7\u53d6\u5931\u8d25\uff1a");
        }
        ArrayList<FileUploadTask> fileParts = new ArrayList<FileUploadTask>();
        for (Upload upload : listMultipartUploadsResponse.result().uploads()) {
            FileUploadTask fileUploadTask = new FileUploadTask();
            BeanUtils.copyProperties((Object)upload, (Object)fileUploadTask);
            fileParts.add(fileUploadTask);
        }
        return fileParts;
    }

    @Override
    public BaseResponse abortMultipartUpload(FileServer fileServer, UploadingFileInfo uploadInfo) {
        try {
            String bucketName = fileServer.getBucket();
            CustomMinioClient minioClient = this.getOssCustomMinioClient(fileServer);
            String objectKey = uploadInfo.getObjectKey();
            String uploadId = uploadInfo.getUploadId();
            CompletableFuture<AbortMultipartUploadResponse> completableFuture = minioClient.abortMultipartUploadAsync(bucketName, "", objectKey, uploadId, null, null);
            AbortMultipartUploadResponse abortMultipartUploadResponse = completableFuture.get();
            if (abortMultipartUploadResponse != null) {
                return BaseResponse.success("\u53d6\u6d88\u5206\u6bb5\u4e0a\u4f20\u4efb\u52a1\u6210\u529f");
            }
            return BaseResponse.buildFailuaResponse("\u53d6\u6d88\u5206\u6bb5\u4e0a\u4f20\u4efb\u52a1\u5931\u8d25");
        }
        catch (Exception e) {
            System.out.println("AbortMultipartUpload failed");
            e.printStackTrace();
            return BaseResponse.buildFailuaResponse("\u53d6\u6d88\u5206\u6bb5\u4e0a\u4f20\u4efb\u52a1\u5931\u8d25:" + e.getMessage());
        }
    }

    @Override
    public BaseResponse abortMultipartUpload(FileServer fileServer, String objectKey, String uploadId) {
        try {
            String bucketName = fileServer.getBucket();
            CustomMinioClient minioClient = this.getOssCustomMinioClient(fileServer);
            AbortMultipartUploadRequest request = new AbortMultipartUploadRequest(bucketName, objectKey, uploadId);
            CompletableFuture<AbortMultipartUploadResponse> completableFuture = minioClient.abortMultipartUploadAsync(bucketName, "", objectKey, uploadId, null, null);
            AbortMultipartUploadResponse abortMultipartUploadResponse = completableFuture.get();
            if (abortMultipartUploadResponse != null) {
                return BaseResponse.success("\u53d6\u6d88\u5206\u6bb5\u4e0a\u4f20\u4efb\u52a1\u6210\u529f");
            }
            return BaseResponse.buildFailuaResponse("\u53d6\u6d88\u5206\u6bb5\u4e0a\u4f20\u4efb\u52a1\u5931\u8d25");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return BaseResponse.buildFailuaResponse("\u53d6\u6d88\u5206\u6bb5\u4e0a\u4f20\u4efb\u52a1\u5931\u8d25:" + ex.getMessage());
        }
    }

    @Override
    public FileStoreMeta sendObject2OssByMultiPart(FileServer fileServer, File file, String sendObjectName) {
        return null;
    }

    private OkHttpClient getUnsafeOkHttpClent(boolean secure) throws KeyManagementException {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            if (secure) {
                builder.sslSocketFactory(sslSocketFactory);
            }
            builder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });
            return builder.build();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getUploadIdFromDB(String md5, String originalFileName) {
        String uploadInfoOldStr = (String)this.redisTemplate.opsForHash().get((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName));
        if (StringUtils.isNotEmpty((CharSequence)uploadInfoOldStr)) {
            Gson gson = new Gson();
            UploadingFileInfo uploadInfoOld = (UploadingFileInfo)gson.fromJson(uploadInfoOldStr, UploadingFileInfo.class);
            return uploadInfoOld.getUploadId();
        }
        return null;
    }

    private void CreateBucket(MinioClient minioClient, String bucket) throws Exception {
        minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucket)).build());
        String policy = "{\n    \"Version\": \"2023-10-17\",\n    \"Statement\": [\n        {\n            \"Action\": [\n                \"s3:GetObject\"\n            ],\n            \"Effect\": \"Allow\",\n            \"Principal\": {\n                \"AWS\": [\n                    \"*\"\n                ]\n            },\n    \"Resource\": [\n                \"arn:aws:s3:::" + bucket + "/*\"\n            ]\n        }\n    ]\n}";
        SetBucketPolicyArgs bucketPolicyArgs = (SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().config(policy).bucket(bucket)).build();
        minioClient.setBucketPolicy(bucketPolicyArgs);
    }
}

