/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.support.handler;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.postgis.jdbc.PGgeometry;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class GeometryTypeHandler<T extends Geometry>
extends BaseTypeHandler<T> {
    private static final ThreadLocal<WKTReader> READER_POOL = ThreadLocal.withInitial(WKTReader::new);
    private static final ThreadLocal<WKTWriter> WRITER_POOL = ThreadLocal.withInitial(WKTWriter::new);
    private static final int SRID_IN_DB = 4490;

    public void setNonNullParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        PGgeometry pGgeometry = new PGgeometry(WRITER_POOL.get().write(parameter));
        net.postgis.jdbc.geometry.Geometry geometry = pGgeometry.getGeometry();
        geometry.setSrid(4490);
        ps.setObject(i, pGgeometry);
    }

    public T getNullableResult(ResultSet rs, String columnName) {
        PGgeometry pgGeometry = (PGgeometry)rs.getObject(columnName);
        return this.getResult(pgGeometry);
    }

    public T getNullableResult(ResultSet rs, int columnIndex) {
        PGgeometry pgGeometry = (PGgeometry)rs.getObject(columnIndex);
        return this.getResult(pgGeometry);
    }

    public T getNullableResult(CallableStatement cs, int columnIndex) {
        PGgeometry string = (PGgeometry)cs.getObject(columnIndex);
        return this.getResult(string);
    }

    private T getResult(PGgeometry pGgeometry) {
        if (pGgeometry == null) {
            return null;
        }
        String pgWkt = pGgeometry.toString();
        String target = String.format("SRID=%s;", 4490);
        String wkt = pgWkt.replace(target, "");
        try {
            return (T)READER_POOL.get().read(wkt);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u6790wkt\u5931\u8d25\uff1a" + wkt, e);
        }
    }
}

