/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.controller;

import com.geoway.ns.sys.dto.BaseObjectResponse;
import com.geoway.ns.sys.utils.MyRequestUtil;
import com.geoway.sso.client.client.OrganizationClient;
import com.geoway.sso.client.rpc.RpcSysOrganization;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec4\u7ec7\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/org"})
public class OrganizationController {
    private final Logger logger = LoggerFactory.getLogger(OrganizationController.class);
    @Autowired
    OrganizationClient organizationClient;

    @ApiOperation(value="1-\u83b7\u53d6\u7ec4\u7ec7\u6811")
    @RequestMapping(value={"/listTree"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseObjectResponse listUser(HttpServletRequest request, @RequestParam(defaultValue="", required=false) String filterParam) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            List organizations = this.organizationClient.getOrgTree();
            response.setData(organizations);
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
        }
        return response;
    }

    @ApiOperation(value="2-\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f")
    @RequestMapping(value={"/findOne"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseObjectResponse findOne(HttpServletRequest request, @RequestParam(value="id") String id, @RequestParam(defaultValue="", required=false) String filterParam) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader(request);
            RpcSysOrganization orgInfo = this.organizationClient.getOrgInfo(id, filterParam);
            response.setData(orgInfo);
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
        }
        return response;
    }

    @ApiOperation(value="3-\u83b7\u53d6\u7ec4\u7ec7\u7528\u6237")
    @RequestMapping(value={"/users"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseObjectResponse users(HttpServletRequest request, @RequestParam(value="orgId", required=true) String orgId) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            List userList = this.organizationClient.getRelUsers(orgId);
            response.setData(userList);
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
        }
        return response;
    }
}

