/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.sys.dto.AppMenuDTO;
import com.geoway.ns.sys.dto.RowsResponse;
import com.geoway.ns.sys.service.IUISConfigService;
import com.geoway.sso.client.client.SystemClient;
import com.geoway.sso.client.rpc.RpcSysMenu;
import com.geoway.sso.client.rpc.RpcSystemInfoDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u83dc\u5355\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/menu"})
public class MenuController {
    private static final Logger log = LoggerFactory.getLogger(MenuController.class);
    @Autowired
    IUISConfigService uisConfigService;
    @Autowired
    SystemClient systemClient;

    @ApiOperation(value="1-\u67e5\u8be2\u7cfb\u7edf\u83dc\u5355\u6811")
    @RequestMapping(value={"/queryMenuTree"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public RowsResponse<RpcSysMenu> menuTrees(HttpServletRequest request, @RequestParam(value="systemId") String systemId) {
        RowsResponse<RpcSysMenu> response = new RowsResponse<RpcSysMenu>();
        try {
            RpcSystemInfoDTO systemInfoDTO = this.systemClient.querySystemInfoByKey(systemId);
            response.setRows(systemInfoDTO.getMenu());
        }
        catch (Exception ex) {
            log.error("\u67e5\u8be2\u7cfb\u7edf\u83dc\u5355\u6811\u5f02\u5e38", (Throwable)ex);
            response.markFailure("\u67e5\u8be2\u7cfb\u7edf\u83dc\u5355\u6811\u5f02\u5e38:" + ex.getMessage());
        }
        return response;
    }

    private List<AppMenuDTO> convertMenuTree(JSONArray jsonArray) {
        return jsonArray.stream().map(item -> this.convertSingleNode((JSONObject)item)).collect(Collectors.toList());
    }

    private AppMenuDTO convertSingleNode(JSONObject json) {
        Object children;
        AppMenuDTO dto = (AppMenuDTO)JSON.parseObject((String)json.toJSONString(), AppMenuDTO.class);
        dto.setNewPage(3 == json.getInteger("openMode") ? 1 : 0);
        if (StringUtils.isNotEmpty((CharSequence)json.getString("pathType")) || json.getJSONObject("menuPath") != null) {
            dto.setLink(2 == (StringUtils.isEmpty((CharSequence)json.getString("pathType")) ? json.getJSONObject("menuPath").getInteger("pathType") : json.getInteger("pathType")) ? 1 : 0);
        } else {
            dto.setLink(0);
        }
        if (json.containsKey((Object)"children") && (children = json.get((Object)"children")) instanceof JSONArray) {
            dto.setChildren(this.convertMenuTree((JSONArray)children));
        }
        return dto;
    }
}

