-- 增加资源权限管理相关库表
CREATE TABLE tb_sys_power_tt (
     f_id varchar(64) NOT NULL,
     f_mandate_id varchar(255) NULL,
     f_mandate_name varchar(255) NULL,
     f_mandate_time timestamp NULL,
     f_mandate_type int2 NULL DEFAULT 1,
     f_mandate_limit_start timestamp NULL,
     f_mandate_limit_end timestamp NULL,
     f_relation_id varchar NULL,
     f_relation_type varchar NULL,
     f_param text NULL,
     CONSTRAINT tb_role_config_xxx_pk PRIMARY KEY (f_id),
     CONSTRAINT tb_sys_power_tt_un UNIQUE (f_mandate_id, f_relation_id, f_relation_type)
);
CREATE INDEX tb_sys_power_tt_f_mandate_id_idx ON tb_sys_power_tt USING btree (f_mandate_id, f_relation_id);
COMMENT ON TABLE tb_sys_power_tt IS '权限管理-铁塔';
COMMENT ON COLUMN tb_sys_power_tt.f_mandate_id IS '授权主体id';
COMMENT ON COLUMN tb_sys_power_tt.f_mandate_name IS '授权主体名称';
COMMENT ON COLUMN tb_sys_power_tt.f_mandate_time IS '授权时间（操作时间）';
COMMENT ON COLUMN tb_sys_power_tt.f_mandate_type IS '1.永久有效  2.阶段有效';
COMMENT ON COLUMN tb_sys_power_tt.f_mandate_limit_start IS '授权开始时间';
COMMENT ON COLUMN tb_sys_power_tt.f_mandate_limit_end IS '授权结束时间';
COMMENT ON COLUMN tb_sys_power_tt.f_relation_id IS '关联id';
COMMENT ON COLUMN tb_sys_power_tt.f_relation_type IS '关联类型（user、role）';
COMMENT ON COLUMN tb_sys_power_tt.f_param IS '扩展参数';

CREATE TABLE tb_sys_power_gj (
     f_id varchar(64) NOT NULL,
     f_mandate_id varchar(255) NULL,
     f_mandate_name varchar(255) NULL,
     f_mandate_time timestamp NULL,
     f_mandate_type int2 NULL DEFAULT 1,
     f_mandate_limit_start timestamp NULL,
     f_mandate_limit_end timestamp NULL,
     f_relation_id varchar NULL,
     f_relation_type varchar NULL,
     f_param text NULL,
     CONSTRAINT tb_role_config_xxx_pk_1 PRIMARY KEY (f_id),
     CONSTRAINT tb_sys_power_gj_un_1 UNIQUE (f_mandate_id, f_relation_id, f_relation_type)
);
CREATE INDEX tb_sys_power_gj_f_mandate_id_idx_1 ON tb_sys_power_gj USING btree (f_mandate_id, f_relation_id);
COMMENT ON TABLE tb_sys_power_gj IS '权限管理-工具';
COMMENT ON COLUMN tb_sys_power_gj.f_mandate_id IS '授权主体id';
COMMENT ON COLUMN tb_sys_power_gj.f_mandate_name IS '授权主体名称';
COMMENT ON COLUMN tb_sys_power_gj.f_mandate_time IS '授权时间（操作时间）';
COMMENT ON COLUMN tb_sys_power_gj.f_mandate_type IS '1.永久有效  2.阶段有效';
COMMENT ON COLUMN tb_sys_power_gj.f_mandate_limit_start IS '授权开始时间';
COMMENT ON COLUMN tb_sys_power_gj.f_mandate_limit_end IS '授权结束时间';
COMMENT ON COLUMN tb_sys_power_gj.f_relation_id IS '关联id';
COMMENT ON COLUMN tb_sys_power_gj.f_relation_type IS '关联类型（user、role）';
COMMENT ON COLUMN tb_sys_power_gj.f_param IS '扩展参数';