/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.tenant.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Context;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.callback.Statement;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.info.MigrationInfoImpl;

public class AfterMigrateCallback
implements Callback {
    public boolean supports(Event event, Context context) {
        return event == Event.AFTER_EACH_MIGRATE_ERROR;
    }

    public boolean canHandleInTransaction(Event event, Context context) {
        return event == Event.AFTER_EACH_MIGRATE_ERROR;
    }

    public void handle(Event event, Context context) {
        if (event == Event.AFTER_EACH_MIGRATE_ERROR) {
            Statement statement = context.getStatement();
            if (statement != null && StringUtils.isNotEmpty((CharSequence)statement.getSql())) {
                String scriptContent = statement.getSql();
                System.out.println("Executed script: " + scriptContent);
                if (scriptContent.contains("public") || scriptContent.contains("geometry")) {
                    scriptContent = scriptContent.replace("public.", "");
                    scriptContent = scriptContent.replace(" geometry(", " public.geometry(");
                    System.out.println("Executed replace script: " + scriptContent);
                    this.executeModifiedScript(context, scriptContent);
                }
            } else {
                MigrationInfo migrationInfo = context.getMigrationInfo();
                if (migrationInfo instanceof MigrationInfoImpl) {
                    MigrationInfoImpl migrationInfoImpl = (MigrationInfoImpl)migrationInfo;
                    ResolvedMigration resolvedMigration = migrationInfoImpl.getResolvedMigration();
                    String version = migrationInfo.getVersion() != null ? migrationInfo.getVersion().toString() : "";
                    String description = migrationInfo.getDescription() != null ? migrationInfo.getDescription() : "";
                    String scriptName = "V" + version + "__" + description + ".sql";
                    String physicalLocation = resolvedMigration.getPhysicalLocation();
                    String scriptContent = this.readScriptFromPath(physicalLocation);
                    if (scriptContent != null && (scriptContent.contains("public") || scriptContent.contains("geometry"))) {
                        System.out.println("Error in script: " + scriptName);
                        String modifiedScript = scriptContent.replace("public.", "").replace(" geometry(", " public.geometry(");
                        System.out.println("Modified script:\n" + modifiedScript);
                        this.executeModifiedScript(context, modifiedScript);
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readScriptFromPath(String physicalLocation) {
        try (FileInputStream inputStream = new FileInputStream(physicalLocation);){
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            System.err.println("Failed to read script from path: " + physicalLocation);
            return null;
        }
    }

    private void executeModifiedScript(Context context, String modifiedScript) {
        try (java.sql.Statement statement = context.getConnection().createStatement();){
            statement.execute(modifiedScript);
            System.out.println("Successfully executed modified script.");
        }
        catch (SQLException e) {
            System.err.println("Failed to execute modified script:");
            e.printStackTrace();
        }
    }

    public String getCallbackName() {
        return null;
    }
}

