--
-- PostgreSQL database dump
--

-- Dumped from database version 15.7
-- Dumped by pg_dump version 15.7


-- Name: gw_class_metadata; Type: TABLE; Schema: public; Owner: -
--
CREATE EXTENSION IF NOT EXISTS postgis;
CREATE EXTENSION IF NOT EXISTS pg_trgm;
CREATE TABLE gw_class_metadata (
    class_name character varying(128) NOT NULL,
    table_name character varying(128),
    class_type integer,
    feature_type integer,
    dataset_name character varying(128),
    alias_name character varying(255),
    oid_name character varying(255),
    subtype_name character varying(64),
    scale double precision,
    usage character varying(64),
    reserved text
);


--
-- Name: gw_field_metadata; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE gw_field_metadata (
    field_name character varying(64) NOT NULL,
    class_name character varying(128),
    alias_name character varying(255),
    field_type integer,
    data_type integer,
    isrequired boolean,
    iseditable boolean,
    isnullable boolean,
    defaultvalue character varying(255),
    length integer,
    "precision" smallint,
    scale smallint
);


--
-- Name: gw_geom_metadata; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE gw_geom_metadata (
    class_name character varying(128) NOT NULL,
    minx numeric(136,10),
    maxx numeric(136,10),
    miny numeric(136,10),
    maxy numeric(136,10),
    minz numeric(136,10),
    maxz numeric(136,10),
    geometry_type integer,
    coordinate_type integer DEFAULT 2
);


--
-- Name: gw_spatial_ref_metadata; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE gw_spatial_ref_metadata (
    class_name character varying(128) NOT NULL,
    srid integer,
    wkt text,
    resolution double precision,
    tolerance double precision
);


--
-- Name: t_adf_history; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE t_adf_history (
    installed_rank integer NOT NULL,
    version character varying(50),
    description character varying(200) NOT NULL,
    type character varying(20) NOT NULL,
    script character varying(1000) NOT NULL,
    checksum integer,
    installed_by character varying(100) NOT NULL,
    installed_on timestamp without time zone DEFAULT now() NOT NULL,
    execution_time integer NOT NULL,
    success boolean NOT NULL
);


--
-- Name: t_webstore_history; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE t_webstore_history (
    installed_rank integer NOT NULL,
    version character varying(50),
    description character varying(200) NOT NULL,
    type character varying(20) NOT NULL,
    script character varying(1000) NOT NULL,
    checksum integer,
    installed_by character varying(100) NOT NULL,
    installed_on timestamp without time zone DEFAULT now() NOT NULL,
    execution_time integer NOT NULL,
    success boolean NOT NULL
);


--
-- Name: tbchart_indicator; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbchart_indicator (
    f_id character varying(64) NOT NULL,
    f_pid character varying(64),
    f_type integer,
    f_name character varying(200) NOT NULL,
    f_des character varying(500),
    f_creator character varying(100),
    f_createtime timestamp(6) without time zone,
    f_order integer,
    f_datasetid character varying(512),
    f_groupfields text,
    f_indicatorfields text,
    f_filterbytime integer,
    f_timefield character varying(100),
    f_filterbydistrict integer,
    f_districtfield character varying(100),
    f_districtnamefield character varying(100),
    f_filterstr character varying(2000),
    f_dskey text,
    f_datasql text,
    f_datatype integer DEFAULT 0,
    f_enable integer DEFAULT 1,
    f_businessinfo text,
    f_stattimeunit integer,
    f_statstarttime timestamp(6) without time zone,
    f_statinterval bigint,
    f_stattablename character varying(100),
    f_apiparams text
);


--
-- Name: TABLE tbchart_indicator; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbchart_indicator IS '统计指标配置';


--
-- Name: COLUMN tbchart_indicator.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_id IS 'id';


--
-- Name: COLUMN tbchart_indicator.f_pid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_pid IS '父id';


--
-- Name: COLUMN tbchart_indicator.f_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_type IS '类型';


--
-- Name: COLUMN tbchart_indicator.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_name IS '名称';


--
-- Name: COLUMN tbchart_indicator.f_des; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_des IS '描述';


--
-- Name: COLUMN tbchart_indicator.f_creator; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_creator IS '创建者';


--
-- Name: COLUMN tbchart_indicator.f_createtime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_createtime IS '创建时间';


--
-- Name: COLUMN tbchart_indicator.f_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_order IS '顺序';


--
-- Name: COLUMN tbchart_indicator.f_datasetid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_datasetid IS '数据集id';


--
-- Name: COLUMN tbchart_indicator.f_groupfields; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_groupfields IS '分组字段';


--
-- Name: COLUMN tbchart_indicator.f_indicatorfields; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_indicatorfields IS '指标字段';


--
-- Name: COLUMN tbchart_indicator.f_filterbytime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_filterbytime IS '是否按时序进行过滤';


--
-- Name: COLUMN tbchart_indicator.f_timefield; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_timefield IS '时序字段';


--
-- Name: COLUMN tbchart_indicator.f_filterbydistrict; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_filterbydistrict IS '按政区进行过滤';


--
-- Name: COLUMN tbchart_indicator.f_districtfield; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_districtfield IS '政区字段';


--
-- Name: COLUMN tbchart_indicator.f_districtnamefield; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_districtnamefield IS '行政区名称字段';


--
-- Name: COLUMN tbchart_indicator.f_filterstr; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_filterstr IS '过滤条件';


--
-- Name: COLUMN tbchart_indicator.f_dskey; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_dskey IS '数据源key';


--
-- Name: COLUMN tbchart_indicator.f_datasql; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_datasql IS '数据查询sql';


--
-- Name: COLUMN tbchart_indicator.f_datatype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_datatype IS '数据来源类型';


--
-- Name: COLUMN tbchart_indicator.f_enable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_enable IS '是否启用1-启用 0-停用';


--
-- Name: COLUMN tbchart_indicator.f_businessinfo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_businessinfo IS '业务信息';


--
-- Name: COLUMN tbchart_indicator.f_stattimeunit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_stattimeunit IS '统计频率单位';


--
-- Name: COLUMN tbchart_indicator.f_statstarttime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_statstarttime IS '统计开始时间';


--
-- Name: COLUMN tbchart_indicator.f_statinterval; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_statinterval IS '统计间隔';


--
-- Name: COLUMN tbchart_indicator.f_stattablename; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_stattablename IS '统计结果表名';


--
-- Name: COLUMN tbchart_indicator.f_apiparams; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_indicator.f_apiparams IS '接口参数';


--
-- Name: tbchart_scene; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbchart_scene (
    f_id character varying(64) NOT NULL,
    f_pid character varying(64),
    f_type integer,
    f_name character varying(200) NOT NULL,
    f_des character varying(500),
    f_creator character varying(100),
    f_createtime timestamp(6) without time zone,
    f_order integer,
    f_config text,
    f_picture bytea
);


--
-- Name: TABLE tbchart_scene; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbchart_scene IS '图表场景表';


--
-- Name: COLUMN tbchart_scene.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_scene.f_id IS 'id';


--
-- Name: COLUMN tbchart_scene.f_pid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_scene.f_pid IS '父id';


--
-- Name: COLUMN tbchart_scene.f_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_scene.f_type IS '类型';


--
-- Name: COLUMN tbchart_scene.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_scene.f_name IS '名称';


--
-- Name: COLUMN tbchart_scene.f_des; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_scene.f_des IS '描述';


--
-- Name: COLUMN tbchart_scene.f_creator; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_scene.f_creator IS '创建者';


--
-- Name: COLUMN tbchart_scene.f_createtime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_scene.f_createtime IS '创建时间';


--
-- Name: COLUMN tbchart_scene.f_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_scene.f_order IS '顺序';


--
-- Name: COLUMN tbchart_scene.f_config; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_scene.f_config IS '图表配置信息';


--
-- Name: COLUMN tbchart_scene.f_picture; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_scene.f_picture IS '封面图片';


--
-- Name: tbchart_scene_version; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbchart_scene_version (
    f_id character varying(64) NOT NULL,
    f_sceneid character varying(64),
    f_config text,
    f_versiontime timestamp(6) without time zone,
    f_clientip character varying(255),
    f_username character varying(255)
);


--
-- Name: TABLE tbchart_scene_version; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbchart_scene_version IS '图表场景历史版本';


--
-- Name: COLUMN tbchart_scene_version.f_sceneid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_scene_version.f_sceneid IS '场景id';


--
-- Name: COLUMN tbchart_scene_version.f_config; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_scene_version.f_config IS '场景配置';


--
-- Name: COLUMN tbchart_scene_version.f_versiontime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_scene_version.f_versiontime IS '版本时间';


--
-- Name: COLUMN tbchart_scene_version.f_clientip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_scene_version.f_clientip IS '用户ip';


--
-- Name: COLUMN tbchart_scene_version.f_username; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_scene_version.f_username IS '用户名称';


--
-- Name: tbchart_snapshot; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbchart_snapshot (
    f_id bigint NOT NULL,
    f_sceneid character varying(64),
    f_snapshotkey text,
    f_thumbnail bytea,
    f_sceneshot bytea,
    f_mapshot bytea,
    f_createtime timestamp(6) without time zone,
    f_name character varying(128)
);


--
-- Name: TABLE tbchart_snapshot; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbchart_snapshot IS '场景快照';


--
-- Name: COLUMN tbchart_snapshot.f_sceneid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_snapshot.f_sceneid IS '场景id';


--
-- Name: COLUMN tbchart_snapshot.f_snapshotkey; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_snapshot.f_snapshotkey IS '快照标识';


--
-- Name: COLUMN tbchart_snapshot.f_thumbnail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_snapshot.f_thumbnail IS '场景缩略图';


--
-- Name: COLUMN tbchart_snapshot.f_sceneshot; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_snapshot.f_sceneshot IS '场景截图';


--
-- Name: COLUMN tbchart_snapshot.f_mapshot; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_snapshot.f_mapshot IS '地图截图';


--
-- Name: COLUMN tbchart_snapshot.f_createtime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_snapshot.f_createtime IS '创建时间';


--
-- Name: COLUMN tbchart_snapshot.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbchart_snapshot.f_name IS '名称';


--
-- Name: tbchart_snapshot_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbchart_snapshot_f_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbchart_snapshot_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbchart_snapshot_f_id_seq OWNED BY tbchart_snapshot.f_id;


--
-- Name: tbcm_attachment; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_attachment (
    f_id character varying(64) NOT NULL,
    f_relatedtype character varying(32),
    f_relatedid character varying(64),
    f_filename character varying(1024),
    f_createtime timestamp without time zone,
    f_tag text
);


--
-- Name: TABLE tbcm_attachment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbcm_attachment IS '附件管理';


--
-- Name: COLUMN tbcm_attachment.f_relatedtype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_attachment.f_relatedtype IS '附件关联类型';


--
-- Name: COLUMN tbcm_attachment.f_relatedid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_attachment.f_relatedid IS '附件关联标识id';


--
-- Name: COLUMN tbcm_attachment.f_filename; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_attachment.f_filename IS '附件文件名';


--
-- Name: COLUMN tbcm_attachment.f_createtime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_attachment.f_createtime IS '创建时间';


--
-- Name: COLUMN tbcm_attachment.f_tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_attachment.f_tag IS '附属信息';


--
-- Name: tbcm_basemap; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_basemap (
    f_id character varying(32) NOT NULL,
    f_name character varying(200) NOT NULL,
    f_type integer NOT NULL,
    f_serviceurl character varying(500),
    f_enable integer,
    f_minlevel integer,
    f_maxlevel integer,
    f_2dvisible integer,
    f_3dvisible integer,
    f_note integer,
    f_groupid character varying(32),
    f_isdefault integer,
    f_order integer,
    f_subdomain character varying(500),
    f_servicevague integer,
    f_openavoidance integer,
    f_annotationpixelrange integer,
    f_picture bytea,
    f_extension character varying
);


--
-- Name: TABLE tbcm_basemap; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbcm_basemap IS '底图配置';


--
-- Name: COLUMN tbcm_basemap.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_basemap.f_id IS '标识';


--
-- Name: COLUMN tbcm_basemap.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_basemap.f_name IS '名称';


--
-- Name: COLUMN tbcm_basemap.f_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_basemap.f_type IS '类型';


--
-- Name: COLUMN tbcm_basemap.f_serviceurl; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_basemap.f_serviceurl IS '服务地址';


--
-- Name: COLUMN tbcm_basemap.f_enable; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_basemap.f_enable IS '是否可用';


--
-- Name: COLUMN tbcm_basemap.f_minlevel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_basemap.f_minlevel IS '最小显示级别';


--
-- Name: COLUMN tbcm_basemap.f_maxlevel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_basemap.f_maxlevel IS '最大显示级别';


--
-- Name: COLUMN tbcm_basemap.f_2dvisible; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_basemap.f_2dvisible IS '二维可见';


--
-- Name: COLUMN tbcm_basemap.f_3dvisible; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_basemap.f_3dvisible IS '三维可见';


--
-- Name: COLUMN tbcm_basemap.f_note; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_basemap.f_note IS '是否注记';


--
-- Name: COLUMN tbcm_basemap.f_groupid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_basemap.f_groupid IS '分组标识';


--
-- Name: COLUMN tbcm_basemap.f_isdefault; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_basemap.f_isdefault IS '是否为默认';


--
-- Name: COLUMN tbcm_basemap.f_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_basemap.f_order IS '顺序';


--
-- Name: COLUMN tbcm_basemap.f_subdomain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_basemap.f_subdomain IS '子域名';


--
-- Name: COLUMN tbcm_basemap.f_servicevague; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_basemap.f_servicevague IS '模糊处理';


--
-- Name: COLUMN tbcm_basemap.f_openavoidance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_basemap.f_openavoidance IS '开启避让';


--
-- Name: COLUMN tbcm_basemap.f_annotationpixelrange; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_basemap.f_annotationpixelrange IS '避让因子';


--
-- Name: COLUMN tbcm_basemap.f_extension; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_basemap.f_extension IS '扩展信息';


--
-- Name: tbcm_catalogapp; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_catalogapp (
    f_id character varying(32) NOT NULL,
    f_name character varying(500),
    f_aliasname character varying(500),
    f_des character varying(500),
    f_isdefault smallint,
    f_order integer,
    f_startcenterx double precision,
    f_startcentery double precision,
    f_startscale double precision,
    f_usestartlocation smallint,
    f_layersortbyorder smallint DEFAULT 0,
    f_loadbasemap smallint DEFAULT 1
);


--
-- Name: TABLE tbcm_catalogapp; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbcm_catalogapp IS '应用目录表';


--
-- Name: COLUMN tbcm_catalogapp.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogapp.f_id IS '唯一标识，自增id';


--
-- Name: COLUMN tbcm_catalogapp.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogapp.f_name IS '名称';


--
-- Name: COLUMN tbcm_catalogapp.f_aliasname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogapp.f_aliasname IS '别名';


--
-- Name: COLUMN tbcm_catalogapp.f_des; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogapp.f_des IS '描述';


--
-- Name: COLUMN tbcm_catalogapp.f_isdefault; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogapp.f_isdefault IS '是否为默认';


--
-- Name: COLUMN tbcm_catalogapp.f_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogapp.f_order IS '顺序';


--
-- Name: COLUMN tbcm_catalogapp.f_startcenterx; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogapp.f_startcenterx IS '预加载起始中心点X';


--
-- Name: COLUMN tbcm_catalogapp.f_startcentery; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogapp.f_startcentery IS '预加载起始中心点Y';


--
-- Name: COLUMN tbcm_catalogapp.f_startscale; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogapp.f_startscale IS '预加载起始比例尺';


--
-- Name: COLUMN tbcm_catalogapp.f_usestartlocation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogapp.f_usestartlocation IS '是否启用初始位置设置';


--
-- Name: COLUMN tbcm_catalogapp.f_layersortbyorder; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogapp.f_layersortbyorder IS '图层是否按初始顺序加载';


--
-- Name: COLUMN tbcm_catalogapp.f_loadbasemap; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogapp.f_loadbasemap IS '是否加载底图';


--
-- Name: tbcm_catalogappright; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_catalogappright (
    f_id bigint NOT NULL,
    f_roleid character varying(64) NOT NULL,
    f_catalogid character varying(32) NOT NULL,
    f_isnode smallint NOT NULL
);


--
-- Name: TABLE tbcm_catalogappright; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbcm_catalogappright IS '应用目录权限表';


--
-- Name: COLUMN tbcm_catalogappright.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogappright.f_id IS '主键';


--
-- Name: COLUMN tbcm_catalogappright.f_roleid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogappright.f_roleid IS '角色id';


--
-- Name: COLUMN tbcm_catalogappright.f_catalogid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogappright.f_catalogid IS '目录节点id';


--
-- Name: COLUMN tbcm_catalogappright.f_isnode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogappright.f_isnode IS '是否为目录节点';


--
-- Name: tbcm_catalogfavoritenode; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_catalogfavoritenode (
    f_userid character varying(256),
    f_nodeid character varying(32) NOT NULL,
    f_catalogid character varying(32),
    f_catalogtype integer,
    f_order integer,
    f_pid character varying(32),
    f_name character varying(500),
    f_type integer
);


--
-- Name: TABLE tbcm_catalogfavoritenode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbcm_catalogfavoritenode IS '应用目录节点收藏表';


--
-- Name: COLUMN tbcm_catalogfavoritenode.f_userid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogfavoritenode.f_userid IS '用户标识';


--
-- Name: COLUMN tbcm_catalogfavoritenode.f_nodeid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogfavoritenode.f_nodeid IS '节点标识';


--
-- Name: COLUMN tbcm_catalogfavoritenode.f_catalogid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogfavoritenode.f_catalogid IS '目录标识';


--
-- Name: COLUMN tbcm_catalogfavoritenode.f_catalogtype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogfavoritenode.f_catalogtype IS '目录类型0-资源目录 1-应用目录';


--
-- Name: COLUMN tbcm_catalogfavoritenode.f_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogfavoritenode.f_order IS '顺序';


--
-- Name: COLUMN tbcm_catalogfavoritenode.f_pid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogfavoritenode.f_pid IS '父节点标识';


--
-- Name: COLUMN tbcm_catalogfavoritenode.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogfavoritenode.f_name IS '名称';


--
-- Name: COLUMN tbcm_catalogfavoritenode.f_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalogfavoritenode.f_type IS '类型0-文件夹 1-目录节点';


--
-- Name: tbcm_catalognodeapp; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_catalognodeapp (
    f_id character varying(32) NOT NULL,
    f_appcatalogid character varying(32),
    f_datasetid character varying(1000),
    f_resnodeid character varying(32),
    f_datasetname character varying(500),
    f_nodename character varying(500),
    f_nodetype integer,
    f_datasettype integer,
    f_servicetype integer,
    f_tiletype integer,
    f_featuretype integer,
    f_des character varying(500),
    f_fatherid character varying(32),
    f_order integer,
    f_autoload smallint,
    f_canchoose smallint,
    f_canquery smallint,
    f_render character varying(2000),
    f_isdefault smallint,
    f_definequerystring character varying(2000),
    f_startcenterx double precision,
    f_startcentery double precision,
    f_startscale double precision,
    f_picture bytea DEFAULT '\x'::bytea,
    f_layerorder integer,
    f_usestartlocation smallint,
    f_datumtype integer,
    f_aggregationsetting character varying(1024),
    f_showaggregation smallint,
    f_charturl character varying(1024),
    f_showtimeline smallint,
    f_xmin double precision,
    f_ymin double precision,
    f_xmax double precision,
    f_ymax double precision,
    f_minlevel integer,
    f_maxlevel integer,
    f_servicevague smallint,
    f_extension character varying,
    f_nodephase character varying(255) DEFAULT NULL::character varying,
    f_modeltype integer,
    f_showlabel smallint,
    f_autoloadchart smallint DEFAULT 0
);


--
-- Name: TABLE tbcm_catalognodeapp; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbcm_catalognodeapp IS '应用目录节点表';


--
-- Name: COLUMN tbcm_catalognodeapp.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_id IS '唯一标识，自增id';


--
-- Name: COLUMN tbcm_catalognodeapp.f_appcatalogid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_appcatalogid IS '应用目录id';


--
-- Name: COLUMN tbcm_catalognodeapp.f_datasetid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_datasetid IS '数据集标识';


--
-- Name: COLUMN tbcm_catalognodeapp.f_resnodeid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_resnodeid IS '资源目录节点id';


--
-- Name: COLUMN tbcm_catalognodeapp.f_datasetname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_datasetname IS '数据集名称';


--
-- Name: COLUMN tbcm_catalognodeapp.f_nodename; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_nodename IS '节点名称';


--
-- Name: COLUMN tbcm_catalognodeapp.f_nodetype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_nodetype IS '节点类型';


--
-- Name: COLUMN tbcm_catalognodeapp.f_datasettype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_datasettype IS '数据集类型';


--
-- Name: COLUMN tbcm_catalognodeapp.f_servicetype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_servicetype IS '服务类型';


--
-- Name: COLUMN tbcm_catalognodeapp.f_tiletype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_tiletype IS '瓦片类型';


--
-- Name: COLUMN tbcm_catalognodeapp.f_featuretype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_featuretype IS '要素类型';


--
-- Name: COLUMN tbcm_catalognodeapp.f_des; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_des IS '描述';


--
-- Name: COLUMN tbcm_catalognodeapp.f_fatherid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_fatherid IS '父节点';


--
-- Name: COLUMN tbcm_catalognodeapp.f_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_order IS '同父下顺序';


--
-- Name: COLUMN tbcm_catalognodeapp.f_autoload; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_autoload IS '启动时可见';


--
-- Name: COLUMN tbcm_catalognodeapp.f_canchoose; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_canchoose IS '可选择';


--
-- Name: COLUMN tbcm_catalognodeapp.f_canquery; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_canquery IS '可查询';


--
-- Name: COLUMN tbcm_catalognodeapp.f_render; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_render IS '渲染信息';


--
-- Name: COLUMN tbcm_catalognodeapp.f_isdefault; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_isdefault IS '是否默认显示的节点';


--
-- Name: COLUMN tbcm_catalognodeapp.f_definequerystring; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_definequerystring IS '预定义查询条件';


--
-- Name: COLUMN tbcm_catalognodeapp.f_startcenterx; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_startcenterx IS '预加载起始中心点X';


--
-- Name: COLUMN tbcm_catalognodeapp.f_startcentery; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_startcentery IS '预加载起始中心点Y';


--
-- Name: COLUMN tbcm_catalognodeapp.f_startscale; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_startscale IS '预加载起始比例尺';


--
-- Name: COLUMN tbcm_catalognodeapp.f_picture; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_picture IS '一级目录图片';


--
-- Name: COLUMN tbcm_catalognodeapp.f_layerorder; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_layerorder IS '图层显示顺序';


--
-- Name: COLUMN tbcm_catalognodeapp.f_usestartlocation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_usestartlocation IS '是否启用初始位置设置';


--
-- Name: COLUMN tbcm_catalognodeapp.f_datumtype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_datumtype IS '文件数据集类型';


--
-- Name: COLUMN tbcm_catalognodeapp.f_aggregationsetting; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_aggregationsetting IS '聚合配置';


--
-- Name: COLUMN tbcm_catalognodeapp.f_showaggregation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_showaggregation IS '是否显示聚合效果';


--
-- Name: COLUMN tbcm_catalognodeapp.f_charturl; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_charturl IS '图表服务地址';


--
-- Name: COLUMN tbcm_catalognodeapp.f_xmin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_xmin IS '显示范围-xmin';


--
-- Name: COLUMN tbcm_catalognodeapp.f_ymin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_ymin IS '显示范围-ymin';


--
-- Name: COLUMN tbcm_catalognodeapp.f_xmax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_xmax IS '显示范围-xmax';


--
-- Name: COLUMN tbcm_catalognodeapp.f_ymax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_ymax IS '显示范围-ymax';


--
-- Name: COLUMN tbcm_catalognodeapp.f_minlevel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_minlevel IS '最小显示级别';


--
-- Name: COLUMN tbcm_catalognodeapp.f_maxlevel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_maxlevel IS '最大显示级别';


--
-- Name: COLUMN tbcm_catalognodeapp.f_servicevague; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_servicevague IS '服务是否模糊显示';


--
-- Name: COLUMN tbcm_catalognodeapp.f_extension; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_extension IS '扩展信息';


--
-- Name: COLUMN tbcm_catalognodeapp.f_nodephase; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_nodephase IS '节点时相';


--
-- Name: COLUMN tbcm_catalognodeapp.f_modeltype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_modeltype IS '模型类型';


--
-- Name: COLUMN tbcm_catalognodeapp.f_showlabel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_showlabel IS '是否显示注记';


--
-- Name: COLUMN tbcm_catalognodeapp.f_autoloadchart; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognodeapp.f_autoloadchart IS '是否自动加载图表';


--
-- Name: tbcm_catalognoderes; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_catalognoderes (
    f_id character varying(32) NOT NULL,
    f_datasetid character varying(1000),
    f_datasetname character varying(500),
    f_nodename character varying(500),
    f_nodetype integer,
    f_datasettype integer,
    f_servicetype integer,
    f_featuretype integer,
    f_des character varying(500),
    f_fatherid character varying(32),
    f_order integer,
    f_autoload smallint,
    f_canchoose smallint,
    f_canquery smallint,
    f_servicezoom integer,
    f_serviceendzoom integer,
    f_styleid character varying(255),
    f_servicexmin double precision,
    f_serviceymin double precision,
    f_servicexmax double precision,
    f_serviceymax double precision,
    f_servicevague smallint,
    f_startcenterx double precision,
    f_startcentery double precision,
    f_startscale double precision,
    f_tiletype integer,
    f_datumtype integer,
    f_fields bytea,
    f_extendconfig bytea,
    f_modeltype integer,
    f_otherconfig bytea
);


--
-- Name: TABLE tbcm_catalognoderes; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbcm_catalognoderes IS '资源目录节点表';


--
-- Name: COLUMN tbcm_catalognoderes.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_id IS '唯一标识，自增id';


--
-- Name: COLUMN tbcm_catalognoderes.f_datasetid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_datasetid IS '数据集标识';


--
-- Name: COLUMN tbcm_catalognoderes.f_datasetname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_datasetname IS '数据集名称';


--
-- Name: COLUMN tbcm_catalognoderes.f_nodename; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_nodename IS '节点名称';


--
-- Name: COLUMN tbcm_catalognoderes.f_nodetype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_nodetype IS '节点类型';


--
-- Name: COLUMN tbcm_catalognoderes.f_datasettype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_datasettype IS '数据集类型';


--
-- Name: COLUMN tbcm_catalognoderes.f_servicetype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_servicetype IS '服务类型';


--
-- Name: COLUMN tbcm_catalognoderes.f_featuretype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_featuretype IS '要素类型';


--
-- Name: COLUMN tbcm_catalognoderes.f_des; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_des IS '描述';


--
-- Name: COLUMN tbcm_catalognoderes.f_fatherid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_fatherid IS '父节点';


--
-- Name: COLUMN tbcm_catalognoderes.f_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_order IS '同父下顺序';


--
-- Name: COLUMN tbcm_catalognoderes.f_autoload; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_autoload IS '启动时可见';


--
-- Name: COLUMN tbcm_catalognoderes.f_canchoose; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_canchoose IS '可选择';


--
-- Name: COLUMN tbcm_catalognoderes.f_canquery; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_canquery IS '可查询';


--
-- Name: COLUMN tbcm_catalognoderes.f_servicezoom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_servicezoom IS '服务起始级别';


--
-- Name: COLUMN tbcm_catalognoderes.f_serviceendzoom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_serviceendzoom IS '服务终止级别';


--
-- Name: COLUMN tbcm_catalognoderes.f_styleid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_styleid IS '矢量瓦片的渲染样式';


--
-- Name: COLUMN tbcm_catalognoderes.f_servicevague; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_servicevague IS '服务模糊处理';


--
-- Name: COLUMN tbcm_catalognoderes.f_startcenterx; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_startcenterx IS '预加载起始中心点X';


--
-- Name: COLUMN tbcm_catalognoderes.f_startcentery; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_startcentery IS '预加载起始中心点Y';


--
-- Name: COLUMN tbcm_catalognoderes.f_startscale; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_startscale IS '预加载起始比例尺';


--
-- Name: COLUMN tbcm_catalognoderes.f_tiletype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_tiletype IS '瓦片类型';


--
-- Name: COLUMN tbcm_catalognoderes.f_datumtype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_datumtype IS '文件数据集类型';


--
-- Name: COLUMN tbcm_catalognoderes.f_fields; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_fields IS '字段配置';


--
-- Name: COLUMN tbcm_catalognoderes.f_extendconfig; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_extendconfig IS '扩展属性配置';


--
-- Name: COLUMN tbcm_catalognoderes.f_modeltype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_modeltype IS '模型类型';


--
-- Name: COLUMN tbcm_catalognoderes.f_otherconfig; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_catalognoderes.f_otherconfig IS '其他应用配置';


--
-- Name: tbcm_color_item; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_color_item (
    f_id character varying(32) NOT NULL,
    f_name character varying(500),
    f_code character varying(500),
    f_colorid character varying(32),
    f_color character varying(500)
);


--
-- Name: tbcm_color_scheme; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_color_scheme (
    f_id character varying(32) NOT NULL,
    f_name character varying(500),
    f_describe character varying(1000)
);


--
-- Name: tbcm_draw_scheme; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_draw_scheme (
    f_id character varying(64) NOT NULL,
    f_name character varying(64),
    f_groupid character varying(64),
    f_type integer,
    f_style bytea,
    f_createtime timestamp without time zone,
    f_desc character varying(255),
    f_userid character varying(128)
);


--
-- Name: TABLE tbcm_draw_scheme; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbcm_draw_scheme IS '标绘方案';


--
-- Name: COLUMN tbcm_draw_scheme.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_draw_scheme.f_id IS 'id';


--
-- Name: COLUMN tbcm_draw_scheme.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_draw_scheme.f_name IS '名称';


--
-- Name: COLUMN tbcm_draw_scheme.f_groupid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_draw_scheme.f_groupid IS '父分组id';


--
-- Name: COLUMN tbcm_draw_scheme.f_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_draw_scheme.f_type IS '类型（0-分组）';


--
-- Name: COLUMN tbcm_draw_scheme.f_style; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_draw_scheme.f_style IS '样式';


--
-- Name: COLUMN tbcm_draw_scheme.f_createtime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_draw_scheme.f_createtime IS '创建时间';


--
-- Name: COLUMN tbcm_draw_scheme.f_desc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_draw_scheme.f_desc IS '描述信息';


--
-- Name: COLUMN tbcm_draw_scheme.f_userid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_draw_scheme.f_userid IS '用户id';


--
-- Name: tbcm_extracttemplate; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_extracttemplate (
    f_id character varying(64) NOT NULL,
    f_name character varying(500) NOT NULL,
    f_desc character varying(2000),
    f_layers character varying
);


--
-- Name: TABLE tbcm_extracttemplate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbcm_extracttemplate IS '数据抽取模板';


--
-- Name: COLUMN tbcm_extracttemplate.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_extracttemplate.f_id IS '标识';


--
-- Name: COLUMN tbcm_extracttemplate.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_extracttemplate.f_name IS '名称';


--
-- Name: COLUMN tbcm_extracttemplate.f_desc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_extracttemplate.f_desc IS '描述';


--
-- Name: COLUMN tbcm_extracttemplate.f_layers; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_extracttemplate.f_layers IS '待抽取的图层配置';


--
-- Name: tbcm_frontscheme; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_frontscheme (
    f_key character varying(64) NOT NULL,
    f_name character varying(500) NOT NULL,
    f_type character varying(100),
    f_group character varying(500),
    f_scheme bytea,
    f_userid character varying(255) DEFAULT NULL::character varying,
    f_bindinguser integer DEFAULT 0,
    f_order integer
);


--
-- Name: TABLE tbcm_frontscheme; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbcm_frontscheme IS '前端方案表';


--
-- Name: COLUMN tbcm_frontscheme.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_frontscheme.f_name IS '名称';


--
-- Name: COLUMN tbcm_frontscheme.f_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_frontscheme.f_type IS '类型';


--
-- Name: COLUMN tbcm_frontscheme.f_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_frontscheme.f_group IS '分组';


--
-- Name: COLUMN tbcm_frontscheme.f_scheme; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_frontscheme.f_scheme IS '方案内容';


--
-- Name: COLUMN tbcm_frontscheme.f_userid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_frontscheme.f_userid IS '用户标识';


--
-- Name: COLUMN tbcm_frontscheme.f_bindinguser; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_frontscheme.f_bindinguser IS '是否绑定用户';


--
-- Name: COLUMN tbcm_frontscheme.f_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_frontscheme.f_order IS '顺序';


--
-- Name: tbcm_indexlayer; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_indexlayer (
    f_id bigint NOT NULL,
    f_name character varying(200) NOT NULL,
    f_datasetid character varying(200) NOT NULL,
    f_scale character varying(50) NOT NULL,
    f_mapnofield character varying(100) NOT NULL
);


--
-- Name: TABLE tbcm_indexlayer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbcm_indexlayer IS '接图表';


--
-- Name: COLUMN tbcm_indexlayer.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_indexlayer.f_id IS 'id';


--
-- Name: COLUMN tbcm_indexlayer.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_indexlayer.f_name IS '名称';


--
-- Name: COLUMN tbcm_indexlayer.f_datasetid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_indexlayer.f_datasetid IS '要素类id';


--
-- Name: COLUMN tbcm_indexlayer.f_scale; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_indexlayer.f_scale IS '比例尺';


--
-- Name: COLUMN tbcm_indexlayer.f_mapnofield; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_indexlayer.f_mapnofield IS '图幅号字段';


--
-- Name: tbcm_mapscene; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_mapscene (
    f_id character varying(64) NOT NULL,
    f_pid character varying(64),
    f_type integer,
    f_name character varying(200) NOT NULL,
    f_desc character varying(2000),
    f_userid character varying(255),
    f_location text,
    f_layerinfo text,
    f_picture bytea,
    f_charturl character varying(1024)
);


--
-- Name: TABLE tbcm_mapscene; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbcm_mapscene IS '数据场景表';


--
-- Name: COLUMN tbcm_mapscene.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapscene.f_id IS '标识';


--
-- Name: COLUMN tbcm_mapscene.f_pid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapscene.f_pid IS '父标识';


--
-- Name: COLUMN tbcm_mapscene.f_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapscene.f_type IS '类型';


--
-- Name: COLUMN tbcm_mapscene.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapscene.f_name IS '名称';


--
-- Name: COLUMN tbcm_mapscene.f_desc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapscene.f_desc IS '描述';


--
-- Name: COLUMN tbcm_mapscene.f_userid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapscene.f_userid IS '用户标识';


--
-- Name: COLUMN tbcm_mapscene.f_location; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapscene.f_location IS '位置信息';


--
-- Name: COLUMN tbcm_mapscene.f_layerinfo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapscene.f_layerinfo IS '图层信息';


--
-- Name: COLUMN tbcm_mapscene.f_picture; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapscene.f_picture IS '图片';


--
-- Name: COLUMN tbcm_mapscene.f_charturl; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapscene.f_charturl IS '图表服务地址';


--
-- Name: tbcm_mapviewscheme; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_mapviewscheme (
    f_id bigint NOT NULL,
    f_name character varying(255),
    f_groupname character varying(255),
    f_userid character varying(255),
    f_appcatalogid character varying(32),
    f_location character varying(2000),
    f_catalogmodel smallint,
    f_layerinfo character varying(5000),
    f_cardid character varying(32),
    f_picture bytea,
    f_charturl character varying(1024),
    f_ispublic integer DEFAULT 1
);


--
-- Name: COLUMN tbcm_mapviewscheme.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapviewscheme.f_id IS '唯一标识，自增id';


--
-- Name: COLUMN tbcm_mapviewscheme.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapviewscheme.f_name IS '方案名称';


--
-- Name: COLUMN tbcm_mapviewscheme.f_groupname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapviewscheme.f_groupname IS '分组名称';


--
-- Name: COLUMN tbcm_mapviewscheme.f_userid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapviewscheme.f_userid IS '用户标识';


--
-- Name: COLUMN tbcm_mapviewscheme.f_appcatalogid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapviewscheme.f_appcatalogid IS '目录标识';


--
-- Name: COLUMN tbcm_mapviewscheme.f_location; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapviewscheme.f_location IS '位置参数';


--
-- Name: COLUMN tbcm_mapviewscheme.f_catalogmodel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapviewscheme.f_catalogmodel IS '目录模式';


--
-- Name: COLUMN tbcm_mapviewscheme.f_layerinfo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapviewscheme.f_layerinfo IS '图层信息';


--
-- Name: COLUMN tbcm_mapviewscheme.f_cardid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapviewscheme.f_cardid IS '演示模式的一级目录';


--
-- Name: COLUMN tbcm_mapviewscheme.f_picture; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapviewscheme.f_picture IS '一级目录图片';


--
-- Name: COLUMN tbcm_mapviewscheme.f_charturl; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapviewscheme.f_charturl IS '图表服务地址';


--
-- Name: COLUMN tbcm_mapviewscheme.f_ispublic; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_mapviewscheme.f_ispublic IS '书签是否为公有';


--
-- Name: tbcm_mapviewscheme_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbcm_mapviewscheme_f_id_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbcm_mapviewscheme_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbcm_mapviewscheme_f_id_seq OWNED BY tbcm_mapviewscheme.f_id;


--
-- Name: tbcm_material; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_material (
    f_id character varying(64) NOT NULL,
    f_name character varying(64),
    f_groupid character varying(64),
    f_type character varying(64),
    f_sourcename character varying(255),
    f_createtime timestamp without time zone,
    f_desc character varying(255),
    f_content bytea,
    f_thumbnail bytea
);


--
-- Name: TABLE tbcm_material; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbcm_material IS '素材管理';


--
-- Name: COLUMN tbcm_material.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_material.f_name IS '名称';


--
-- Name: COLUMN tbcm_material.f_groupid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_material.f_groupid IS '父分组id';


--
-- Name: COLUMN tbcm_material.f_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_material.f_type IS '类型';


--
-- Name: COLUMN tbcm_material.f_sourcename; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_material.f_sourcename IS '源名称';


--
-- Name: COLUMN tbcm_material.f_createtime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_material.f_createtime IS '创建时间';


--
-- Name: COLUMN tbcm_material.f_desc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_material.f_desc IS '描述信息';


--
-- Name: COLUMN tbcm_material.f_content; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_material.f_content IS '素材内容';


--
-- Name: COLUMN tbcm_material.f_thumbnail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_material.f_thumbnail IS '缩略图';


--
-- Name: tbcm_metadata; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_metadata (
    f_id bigint NOT NULL,
    f_relatedidtype integer,
    f_relatedid character varying(200),
    f_templateid bigint,
    f_keywords character varying(500)
);


--
-- Name: TABLE tbcm_metadata; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbcm_metadata IS '元数据表';


--
-- Name: COLUMN tbcm_metadata.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metadata.f_id IS '自增id';


--
-- Name: COLUMN tbcm_metadata.f_relatedidtype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metadata.f_relatedidtype IS '关联ID的类型';


--
-- Name: COLUMN tbcm_metadata.f_relatedid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metadata.f_relatedid IS '关联ID';


--
-- Name: COLUMN tbcm_metadata.f_templateid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metadata.f_templateid IS '模板标识';


--
-- Name: COLUMN tbcm_metadata.f_keywords; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metadata.f_keywords IS '关键词，多个逗号隔开';


--
-- Name: tbcm_metadata_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbcm_metadata_f_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbcm_metadata_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbcm_metadata_f_id_seq OWNED BY tbcm_metadata.f_id;


--
-- Name: tbcm_metadatavalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_metadatavalue (
    f_metadataid bigint NOT NULL,
    f_fieldname character varying(200),
    f_type integer,
    f_value character varying
);


--
-- Name: TABLE tbcm_metadatavalue; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbcm_metadatavalue IS '元数据记录表';


--
-- Name: COLUMN tbcm_metadatavalue.f_metadataid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metadatavalue.f_metadataid IS '元数据表的标识';


--
-- Name: COLUMN tbcm_metadatavalue.f_fieldname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metadatavalue.f_fieldname IS '字段名称';


--
-- Name: COLUMN tbcm_metadatavalue.f_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metadatavalue.f_type IS '字段类型';


--
-- Name: COLUMN tbcm_metadatavalue.f_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metadatavalue.f_value IS '字段值';


--
-- Name: tbcm_metakeyword; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_metakeyword (
    f_key character varying(100) NOT NULL,
    f_metadataids character varying(500)
);


--
-- Name: TABLE tbcm_metakeyword; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbcm_metakeyword IS '关键词表';


--
-- Name: COLUMN tbcm_metakeyword.f_key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metakeyword.f_key IS '关键词，唯一';


--
-- Name: COLUMN tbcm_metakeyword.f_metadataids; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metakeyword.f_metadataids IS '元数据标识，多个逗号隔开';


--
-- Name: tbcm_metatemplate; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_metatemplate (
    f_id bigint NOT NULL,
    f_name character varying(500),
    f_des character varying(500),
    f_key character varying(500)
);


--
-- Name: TABLE tbcm_metatemplate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbcm_metatemplate IS '元数据模板表';


--
-- Name: COLUMN tbcm_metatemplate.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metatemplate.f_id IS '自增id';


--
-- Name: COLUMN tbcm_metatemplate.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metatemplate.f_name IS '名称';


--
-- Name: COLUMN tbcm_metatemplate.f_des; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metatemplate.f_des IS '描述信息';


--
-- Name: COLUMN tbcm_metatemplate.f_key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metatemplate.f_key IS '标识';


--
-- Name: tbcm_metatemplate_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbcm_metatemplate_f_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbcm_metatemplate_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbcm_metatemplate_f_id_seq OWNED BY tbcm_metatemplate.f_id;


--
-- Name: tbcm_metatemplatefield; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbcm_metatemplatefield (
    f_id bigint NOT NULL,
    f_templateid bigint NOT NULL,
    f_name character varying(500),
    f_type integer,
    f_length integer,
    f_isnull integer,
    f_default character varying(500),
    f_des character varying(500),
    f_dictionarykey character varying(5000),
    f_pid bigint,
    f_order integer DEFAULT 0,
    f_multiselect smallint DEFAULT 0
);


--
-- Name: TABLE tbcm_metatemplatefield; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbcm_metatemplatefield IS '元数据字段表';


--
-- Name: COLUMN tbcm_metatemplatefield.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metatemplatefield.f_id IS '自增id';


--
-- Name: COLUMN tbcm_metatemplatefield.f_templateid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metatemplatefield.f_templateid IS '模板标识';


--
-- Name: COLUMN tbcm_metatemplatefield.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metatemplatefield.f_name IS '名称';


--
-- Name: COLUMN tbcm_metatemplatefield.f_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metatemplatefield.f_type IS '类型';


--
-- Name: COLUMN tbcm_metatemplatefield.f_length; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metatemplatefield.f_length IS '长度';


--
-- Name: COLUMN tbcm_metatemplatefield.f_isnull; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metatemplatefield.f_isnull IS '是否允许为空';


--
-- Name: COLUMN tbcm_metatemplatefield.f_default; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metatemplatefield.f_default IS '默认值';


--
-- Name: COLUMN tbcm_metatemplatefield.f_des; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metatemplatefield.f_des IS '描述信息';


--
-- Name: COLUMN tbcm_metatemplatefield.f_dictionarykey; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metatemplatefield.f_dictionarykey IS '值域标识';


--
-- Name: COLUMN tbcm_metatemplatefield.f_pid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metatemplatefield.f_pid IS '父分组id';


--
-- Name: COLUMN tbcm_metatemplatefield.f_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metatemplatefield.f_order IS '顺序';


--
-- Name: COLUMN tbcm_metatemplatefield.f_multiselect; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbcm_metatemplatefield.f_multiselect IS '是否多选';


--
-- Name: tbcm_metatemplatefield_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbcm_metatemplatefield_f_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbcm_metatemplatefield_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbcm_metatemplatefield_f_id_seq OWNED BY tbcm_metatemplatefield.f_id;


--
-- Name: tbdm_district; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbdm_district (
    f_id bigint NOT NULL,
    f_name character varying(100) NOT NULL,
    f_code character varying(100),
    f_dataphase character varying(100),
    f_desc character varying(500),
    f_isdefault smallint,
    f_type character varying(200),
    f_defaultitemid bigint
);


--
-- Name: COLUMN tbdm_district.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_district.f_id IS '区域定义唯一标识';


--
-- Name: COLUMN tbdm_district.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_district.f_name IS '区域定义名称';


--
-- Name: COLUMN tbdm_district.f_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_district.f_code IS '区域定义编码';


--
-- Name: COLUMN tbdm_district.f_dataphase; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_district.f_dataphase IS '区域定义时相';


--
-- Name: COLUMN tbdm_district.f_desc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_district.f_desc IS '描述';


--
-- Name: COLUMN tbdm_district.f_isdefault; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_district.f_isdefault IS '是否为默认';


--
-- Name: COLUMN tbdm_district.f_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_district.f_type IS '政区类型';


--
-- Name: COLUMN tbdm_district.f_defaultitemid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_district.f_defaultitemid IS '默认区域单元标识';


--
-- Name: tbdm_district_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbdm_district_f_id_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbdm_district_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbdm_district_f_id_seq OWNED BY tbdm_district.f_id;


--
-- Name: tbdm_districthot; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbdm_districthot (
    objectid integer NOT NULL,
    f_name character varying(1000),
    f_datasetid character varying(1000),
    f_fieldname character varying(1000),
    f_fieldvalue character varying(5000),
    shape ${schema_name}.geometry(Geometry,4490)
);


--
-- Name: tbdm_districthot_objectid_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbdm_districthot_objectid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbdm_districthot_objectid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbdm_districthot_objectid_seq OWNED BY tbdm_districthot.objectid;


--
-- Name: tbdm_districtitem; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbdm_districtitem (
    f_districtid bigint NOT NULL,
    f_id bigint NOT NULL,
    f_pid bigint NOT NULL,
    f_name character varying(100) NOT NULL,
    f_code character varying(100) NOT NULL,
    f_ext character varying(500),
    f_order bigint,
    f_levelindex smallint,
    f_centerx double precision,
    f_centery double precision,
    f_xmin double precision,
    f_ymin double precision,
    f_xmax double precision,
    f_ymax double precision
);


--
-- Name: TABLE tbdm_districtitem; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbdm_districtitem IS '行政区划单元表';


--
-- Name: COLUMN tbdm_districtitem.f_districtid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_districtitem.f_districtid IS '所属区域定义标识';


--
-- Name: COLUMN tbdm_districtitem.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_districtitem.f_id IS '唯一标识';


--
-- Name: COLUMN tbdm_districtitem.f_pid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_districtitem.f_pid IS '父级标识';


--
-- Name: COLUMN tbdm_districtitem.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_districtitem.f_name IS '名称';


--
-- Name: COLUMN tbdm_districtitem.f_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_districtitem.f_code IS '编码';


--
-- Name: COLUMN tbdm_districtitem.f_ext; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_districtitem.f_ext IS '扩展';


--
-- Name: COLUMN tbdm_districtitem.f_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_districtitem.f_order IS '顺序';


--
-- Name: COLUMN tbdm_districtitem.f_levelindex; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_districtitem.f_levelindex IS '区域层级';


--
-- Name: COLUMN tbdm_districtitem.f_centerx; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_districtitem.f_centerx IS '中心点x';


--
-- Name: COLUMN tbdm_districtitem.f_centery; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_districtitem.f_centery IS '中心点y';


--
-- Name: tbdm_districtitem_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbdm_districtitem_f_id_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbdm_districtitem_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbdm_districtitem_f_id_seq OWNED BY tbdm_districtitem.f_id;


--
-- Name: tbdm_districtlevel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbdm_districtlevel (
    f_districtid bigint NOT NULL,
    f_index smallint NOT NULL,
    f_name character varying(100),
    f_desc character varying(200),
    f_datasetid character varying(1000),
    f_codefldname character varying(100),
    f_namefldname character varying(100)
);


--
-- Name: TABLE tbdm_districtlevel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbdm_districtlevel IS '区划单元级别定义表';


--
-- Name: COLUMN tbdm_districtlevel.f_districtid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_districtlevel.f_districtid IS '所属区域定义标识';


--
-- Name: COLUMN tbdm_districtlevel.f_index; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_districtlevel.f_index IS '级别索引';


--
-- Name: COLUMN tbdm_districtlevel.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_districtlevel.f_name IS '名称';


--
-- Name: COLUMN tbdm_districtlevel.f_desc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_districtlevel.f_desc IS '别名';


--
-- Name: COLUMN tbdm_districtlevel.f_datasetid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_districtlevel.f_datasetid IS '定位数据集ID';


--
-- Name: COLUMN tbdm_districtlevel.f_codefldname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_districtlevel.f_codefldname IS '编码字段名称';


--
-- Name: COLUMN tbdm_districtlevel.f_namefldname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_districtlevel.f_namefldname IS '名称字段';


--
-- Name: tbdm_domain; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbdm_domain (
    f_dicno bigint NOT NULL,
    f_dicname character varying(100),
    f_diccodelen bigint,
    f_dictype bigint,
    f_dicdesc character varying(255),
    f_key character varying(50)
);


--
-- Name: TABLE tbdm_domain; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbdm_domain IS '枚举值表';


--
-- Name: COLUMN tbdm_domain.f_dicno; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_domain.f_dicno IS '字典编号';


--
-- Name: COLUMN tbdm_domain.f_dicname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_domain.f_dicname IS '字典名称';


--
-- Name: COLUMN tbdm_domain.f_diccodelen; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_domain.f_diccodelen IS '字典编码长度';


--
-- Name: COLUMN tbdm_domain.f_dictype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_domain.f_dictype IS '字典类型';


--
-- Name: COLUMN tbdm_domain.f_dicdesc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_domain.f_dicdesc IS '字典描述';


--
-- Name: COLUMN tbdm_domain.f_key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_domain.f_key IS '关键字';


--
-- Name: tbdm_domain_f_dicno_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbdm_domain_f_dicno_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbdm_domain_f_dicno_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbdm_domain_f_dicno_seq OWNED BY tbdm_domain.f_dicno;


--
-- Name: tbdm_domainvalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbdm_domainvalue (
    f_id bigint NOT NULL,
    f_code character varying(100),
    f_name character varying(100),
    f_remark character varying(3000),
    f_pid bigint,
    f_corder bigint,
    f_dicno bigint,
    f_level bigint
);


--
-- Name: TABLE tbdm_domainvalue; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbdm_domainvalue IS '枚举值域表';


--
-- Name: COLUMN tbdm_domainvalue.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_domainvalue.f_id IS 'id';


--
-- Name: COLUMN tbdm_domainvalue.f_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_domainvalue.f_code IS '编码';


--
-- Name: COLUMN tbdm_domainvalue.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_domainvalue.f_name IS '名称';


--
-- Name: COLUMN tbdm_domainvalue.f_remark; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_domainvalue.f_remark IS '备注';


--
-- Name: COLUMN tbdm_domainvalue.f_pid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_domainvalue.f_pid IS '父ID';


--
-- Name: COLUMN tbdm_domainvalue.f_corder; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_domainvalue.f_corder IS '顺序';


--
-- Name: COLUMN tbdm_domainvalue.f_dicno; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_domainvalue.f_dicno IS '字段序号';


--
-- Name: COLUMN tbdm_domainvalue.f_level; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_domainvalue.f_level IS '级别';


--
-- Name: tbdm_domainvalue_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbdm_domainvalue_f_id_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbdm_domainvalue_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbdm_domainvalue_f_id_seq OWNED BY tbdm_domainvalue.f_id;


--
-- Name: tbdm_filedata; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbdm_filedata (
    f_dataid bigint NOT NULL,
    f_dataname character varying(255),
    f_datatype character varying(255),
    f_datumdatasetid character varying(255),
    f_serverid character varying(255),
    f_registeruser character varying(255),
    f_updateuser character varying(50),
    f_registerdate timestamp without time zone,
    f_updatedate timestamp without time zone,
    f_dataamount bigint,
    f_flag bigint,
    f_packageid bigint,
    f_realpkgname character varying(255),
    f_mainpath character varying(1024),
    f_istemp bigint,
    f_dirid bigint,
    f_isonserver bigint,
    f_srcmainpath text,
    f_containsrootfolder bigint,
    f_catalogfiles bytea
);


--
-- Name: TABLE tbdm_filedata; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbdm_filedata IS '文件结构模型';


--
-- Name: COLUMN tbdm_filedata.f_dataid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filedata.f_dataid IS '数据包id';


--
-- Name: COLUMN tbdm_filedata.f_dataname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filedata.f_dataname IS '数据名称';


--
-- Name: COLUMN tbdm_filedata.f_datatype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filedata.f_datatype IS '数据类型';


--
-- Name: COLUMN tbdm_filedata.f_datumdatasetid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filedata.f_datumdatasetid IS '文件数据集id';


--
-- Name: COLUMN tbdm_filedata.f_serverid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filedata.f_serverid IS '服务器id';


--
-- Name: COLUMN tbdm_filedata.f_registeruser; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filedata.f_registeruser IS '注册用户';


--
-- Name: COLUMN tbdm_filedata.f_updateuser; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filedata.f_updateuser IS '更新用户';


--
-- Name: COLUMN tbdm_filedata.f_registerdate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filedata.f_registerdate IS '注册日期';


--
-- Name: COLUMN tbdm_filedata.f_updatedate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filedata.f_updatedate IS '更新时间';


--
-- Name: COLUMN tbdm_filedata.f_dataamount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filedata.f_dataamount IS '数据量';


--
-- Name: COLUMN tbdm_filedata.f_flag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filedata.f_flag IS '是否存在标记';


--
-- Name: COLUMN tbdm_filedata.f_packageid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filedata.f_packageid IS '文件结构数据包ID';


--
-- Name: COLUMN tbdm_filedata.f_realpkgname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filedata.f_realpkgname IS '文件结构数据包名称';


--
-- Name: COLUMN tbdm_filedata.f_mainpath; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filedata.f_mainpath IS '主路径';


--
-- Name: COLUMN tbdm_filedata.f_istemp; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filedata.f_istemp IS '是否临时数据';


--
-- Name: COLUMN tbdm_filedata.f_dirid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filedata.f_dirid IS '文件夹id';


--
-- Name: COLUMN tbdm_filedata.f_isonserver; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filedata.f_isonserver IS '是否在服务器上';


--
-- Name: COLUMN tbdm_filedata.f_srcmainpath; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filedata.f_srcmainpath IS '源路径';


--
-- Name: COLUMN tbdm_filedata.f_containsrootfolder; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filedata.f_containsrootfolder IS '是否包含顶层文件夹';


--
-- Name: tbdm_filedata_f_dataid_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbdm_filedata_f_dataid_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbdm_filedata_f_dataid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbdm_filedata_f_dataid_seq OWNED BY tbdm_filedata.f_dataid;


--
-- Name: tbdm_filemodel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbdm_filemodel (
    f_id bigint NOT NULL,
    f_name character varying(200),
    f_desc character varying(255),
    f_group character varying(200),
    f_hasmeta smallint,
    f_modelkey smallint,
    f_objecttypeid smallint,
    f_object bytea
);


--
-- Name: TABLE tbdm_filemodel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbdm_filemodel IS '文件结构模型';


--
-- Name: COLUMN tbdm_filemodel.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filemodel.f_id IS '标识';


--
-- Name: COLUMN tbdm_filemodel.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filemodel.f_name IS '名称';


--
-- Name: COLUMN tbdm_filemodel.f_desc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filemodel.f_desc IS '描述';


--
-- Name: COLUMN tbdm_filemodel.f_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filemodel.f_group IS '分组名称';


--
-- Name: COLUMN tbdm_filemodel.f_hasmeta; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filemodel.f_hasmeta IS '是否有元数据';


--
-- Name: COLUMN tbdm_filemodel.f_modelkey; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filemodel.f_modelkey IS '主数据标识是否为数据包';


--
-- Name: COLUMN tbdm_filemodel.f_objecttypeid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filemodel.f_objecttypeid IS '模型类型';


--
-- Name: COLUMN tbdm_filemodel.f_object; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_filemodel.f_object IS '模型内容';


--
-- Name: tbdm_filemodel_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbdm_filemodel_f_id_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbdm_filemodel_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbdm_filemodel_f_id_seq OWNED BY tbdm_filemodel.f_id;


--
-- Name: tbdm_fileproperty; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbdm_fileproperty (
    f_key character varying(50) NOT NULL,
    f_name character varying(100),
    f_objecttype bigint,
    f_unique bigint,
    f_necessary bigint
);


--
-- Name: TABLE tbdm_fileproperty; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbdm_fileproperty IS '数据对象属性表';


--
-- Name: COLUMN tbdm_fileproperty.f_key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_fileproperty.f_key IS '关键字';


--
-- Name: COLUMN tbdm_fileproperty.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_fileproperty.f_name IS '名称';


--
-- Name: COLUMN tbdm_fileproperty.f_objecttype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_fileproperty.f_objecttype IS '适用对象类型： 0-文件； 1-文件夹； 2-数据包';


--
-- Name: COLUMN tbdm_fileproperty.f_unique; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_fileproperty.f_unique IS '是否唯一';


--
-- Name: COLUMN tbdm_fileproperty.f_necessary; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_fileproperty.f_necessary IS '是否必选';


--
-- Name: tbdm_geotemplate; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbdm_geotemplate (
    f_id character varying(64) NOT NULL,
    f_name character varying(100),
    f_desc character varying(500),
    f_datasets bytea,
    f_code character varying(100)
);


--
-- Name: TABLE tbdm_geotemplate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbdm_geotemplate IS '空间数据模板';


--
-- Name: COLUMN tbdm_geotemplate.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_geotemplate.f_id IS 'id';


--
-- Name: COLUMN tbdm_geotemplate.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_geotemplate.f_name IS '名称';


--
-- Name: COLUMN tbdm_geotemplate.f_desc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_geotemplate.f_desc IS '描述';


--
-- Name: tbdm_thumb; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbdm_thumb (
    f_id character varying(1000) NOT NULL,
    f_image bytea,
    f_dataid bigint,
    f_xsize integer,
    f_ysize integer,
    f_offset integer,
    f_datasetid character varying(500)
);


--
-- Name: TABLE tbdm_thumb; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbdm_thumb IS '拇指图';


--
-- Name: COLUMN tbdm_thumb.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_thumb.f_id IS '标识';


--
-- Name: COLUMN tbdm_thumb.f_image; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_thumb.f_image IS '图片';


--
-- Name: COLUMN tbdm_thumb.f_dataid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_thumb.f_dataid IS '数据id';


--
-- Name: COLUMN tbdm_thumb.f_xsize; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_thumb.f_xsize IS 'XSize';


--
-- Name: COLUMN tbdm_thumb.f_ysize; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_thumb.f_ysize IS 'YSize';


--
-- Name: COLUMN tbdm_thumb.f_offset; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_thumb.f_offset IS '偏移量';


--
-- Name: COLUMN tbdm_thumb.f_datasetid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbdm_thumb.f_datasetid IS '数据集标识';


--
-- Name: tbds_backup; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbds_backup (
    f_key character varying(50) NOT NULL,
    f_backup_path character varying(2000),
    f_backup_time timestamp(6) without time zone
);


--
-- Name: TABLE tbds_backup; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbds_backup IS '数据源备份记录表';


--
-- Name: COLUMN tbds_backup.f_key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_backup.f_key IS '数据源标识';


--
-- Name: COLUMN tbds_backup.f_backup_path; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_backup.f_backup_path IS '备份文件路径';


--
-- Name: COLUMN tbds_backup.f_backup_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_backup.f_backup_time IS '备份时间';


--
-- Name: tbds_datasetmeta; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbds_datasetmeta (
    f_id character varying(255) NOT NULL,
    f_dataphase character varying(255),
    f_render character varying(2000),
    f_funcservices character varying(4000),
    f_detail text
);


--
-- Name: TABLE tbds_datasetmeta; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbds_datasetmeta IS '数据集元数据表';


--
-- Name: COLUMN tbds_datasetmeta.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datasetmeta.f_id IS '数据集id';


--
-- Name: COLUMN tbds_datasetmeta.f_dataphase; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datasetmeta.f_dataphase IS '数据时相';


--
-- Name: COLUMN tbds_datasetmeta.f_render; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datasetmeta.f_render IS '渲染信息';


--
-- Name: COLUMN tbds_datasetmeta.f_funcservices; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datasetmeta.f_funcservices IS '数据集关联的功能服务';


--
-- Name: COLUMN tbds_datasetmeta.f_detail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datasetmeta.f_detail IS '数据集详情';


--
-- Name: tbds_datasetrelation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbds_datasetrelation (
    f_sourceid character varying(512),
    f_relation character varying(100),
    f_targetid character varying(512),
    f_properties text
);


--
-- Name: TABLE tbds_datasetrelation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbds_datasetrelation IS '数据集关联关系表';


--
-- Name: COLUMN tbds_datasetrelation.f_sourceid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datasetrelation.f_sourceid IS '源数据集id';


--
-- Name: COLUMN tbds_datasetrelation.f_relation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datasetrelation.f_relation IS '关系';


--
-- Name: COLUMN tbds_datasetrelation.f_targetid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datasetrelation.f_targetid IS '目标数据集id';


--
-- Name: COLUMN tbds_datasetrelation.f_properties; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datasetrelation.f_properties IS '关系属性';


--
-- Name: tbds_datastore; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbds_datastore (
    f_key character varying(50) NOT NULL,
    f_name character varying(50),
    f_datastoretype integer DEFAULT '-1'::integer,
    f_datasourcetype integer DEFAULT '-1'::integer,
    f_url character varying(2000),
    f_user character varying(50),
    f_password character varying(50),
    f_isdefault smallint
);


--
-- Name: TABLE tbds_datastore; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbds_datastore IS '数据源存储表';


--
-- Name: COLUMN tbds_datastore.f_key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datastore.f_key IS '标识';


--
-- Name: COLUMN tbds_datastore.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datastore.f_name IS '名称';


--
-- Name: COLUMN tbds_datastore.f_datastoretype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datastore.f_datastoretype IS '数据存储类型';


--
-- Name: COLUMN tbds_datastore.f_datasourcetype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datastore.f_datasourcetype IS '数据源类型';


--
-- Name: COLUMN tbds_datastore.f_url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datastore.f_url IS '连接参数';


--
-- Name: COLUMN tbds_datastore.f_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datastore.f_user IS '用户名';


--
-- Name: COLUMN tbds_datastore.f_password; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datastore.f_password IS '密码';


--
-- Name: COLUMN tbds_datastore.f_isdefault; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datastore.f_isdefault IS '是否默认存储';


--
-- Name: tbds_datum; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbds_datum (
    f_dsid character varying(2000) NOT NULL,
    f_name character varying(200),
    f_aliasname character varying(200),
    f_datumdatasettype integer DEFAULT 0,
    f_geometrytype bigint,
    f_catalogmodelids character varying(2000),
    f_datumcount bigint,
    f_spatialdskey character varying(50),
    f_srid bigint,
    f_spfwkt character varying(2000),
    f_datastorekey character varying(50) NOT NULL,
    f_modeltype integer,
    f_geodatasetid character varying(2000)
);


--
-- Name: TABLE tbds_datum; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbds_datum IS '文件数据集表';


--
-- Name: COLUMN tbds_datum.f_dsid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datum.f_dsid IS '数据集标识';


--
-- Name: COLUMN tbds_datum.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datum.f_name IS '资料数据集名称';


--
-- Name: COLUMN tbds_datum.f_aliasname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datum.f_aliasname IS '资料数据集别名';


--
-- Name: COLUMN tbds_datum.f_datumdatasettype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datum.f_datumdatasettype IS '文件数据集类型';


--
-- Name: COLUMN tbds_datum.f_geometrytype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datum.f_geometrytype IS '几何类型';


--
-- Name: COLUMN tbds_datum.f_catalogmodelids; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datum.f_catalogmodelids IS '资料模型';


--
-- Name: COLUMN tbds_datum.f_datumcount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datum.f_datumcount IS '资料数量';


--
-- Name: COLUMN tbds_datum.f_spatialdskey; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datum.f_spatialdskey IS '空间数据库标识';


--
-- Name: COLUMN tbds_datum.f_srid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datum.f_srid IS 'srid';


--
-- Name: COLUMN tbds_datum.f_spfwkt; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datum.f_spfwkt IS '空间参考wkt';


--
-- Name: COLUMN tbds_datum.f_datastorekey; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datum.f_datastorekey IS '文件数据库标识';


--
-- Name: COLUMN tbds_datum.f_modeltype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datum.f_modeltype IS '模型类型';


--
-- Name: COLUMN tbds_datum.f_geodatasetid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datum.f_geodatasetid IS '空间数据集id';


--
-- Name: tbds_datumfields; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbds_datumfields (
    f_id bigint NOT NULL,
    f_dsid character varying(2000) NOT NULL,
    f_name character varying(100) NOT NULL,
    f_aliasname character varying(255),
    f_identify smallint,
    f_datumname smallint,
    f_system smallint
);


--
-- Name: TABLE tbds_datumfields; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbds_datumfields IS '资料数据集字段表';


--
-- Name: COLUMN tbds_datumfields.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datumfields.f_id IS '字段标识';


--
-- Name: COLUMN tbds_datumfields.f_dsid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datumfields.f_dsid IS '资料数据集ID';


--
-- Name: COLUMN tbds_datumfields.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datumfields.f_name IS '字段名称';


--
-- Name: COLUMN tbds_datumfields.f_aliasname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datumfields.f_aliasname IS '字段别名';


--
-- Name: COLUMN tbds_datumfields.f_identify; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datumfields.f_identify IS '是否为标识字段';


--
-- Name: COLUMN tbds_datumfields.f_datumname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datumfields.f_datumname IS '是否为名称字段';


--
-- Name: COLUMN tbds_datumfields.f_system; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_datumfields.f_system IS '是否为系统字段';


--
-- Name: tbds_datumfields_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbds_datumfields_f_id_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbds_datumfields_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbds_datumfields_f_id_seq OWNED BY tbds_datumfields.f_id;


--
-- Name: tbds_graphlabel; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbds_graphlabel (
    f_id character varying(64) NOT NULL,
    f_dskey character varying(500) NOT NULL,
    f_name character varying(500) NOT NULL,
    f_aliasname character varying(500),
    f_labeltype integer NOT NULL
);


--
-- Name: TABLE tbds_graphlabel; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbds_graphlabel IS '图库标签表';


--
-- Name: COLUMN tbds_graphlabel.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_graphlabel.f_id IS '唯一标识';


--
-- Name: COLUMN tbds_graphlabel.f_dskey; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_graphlabel.f_dskey IS '数据源标识';


--
-- Name: COLUMN tbds_graphlabel.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_graphlabel.f_name IS '名称';


--
-- Name: COLUMN tbds_graphlabel.f_aliasname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_graphlabel.f_aliasname IS '别名';


--
-- Name: COLUMN tbds_graphlabel.f_labeltype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_graphlabel.f_labeltype IS '标签类型';


--
-- Name: tbds_service; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbds_service (
    f_id character varying(255) NOT NULL,
    f_name character varying(255),
    f_aliasname character varying(255),
    f_servicetype integer,
    f_url character varying(2000),
    f_serviceformat integer DEFAULT 0,
    f_ext character varying
);


--
-- Name: TABLE tbds_service; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbds_service IS '服务信息表';


--
-- Name: COLUMN tbds_service.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_service.f_id IS '服务id';


--
-- Name: COLUMN tbds_service.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_service.f_name IS '服务名称';


--
-- Name: COLUMN tbds_service.f_aliasname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_service.f_aliasname IS '服务别名';


--
-- Name: COLUMN tbds_service.f_servicetype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_service.f_servicetype IS '服务类型';


--
-- Name: COLUMN tbds_service.f_url; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_service.f_url IS '服务地址';


--
-- Name: COLUMN tbds_service.f_serviceformat; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_service.f_serviceformat IS '服务地址格式';


--
-- Name: COLUMN tbds_service.f_ext; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_service.f_ext IS '扩展信息';


--
-- Name: tbds_statistic; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbds_statistic (
    f_id character varying(512) NOT NULL,
    f_dskey character varying(50),
    f_type integer,
    f_name character varying(255),
    f_datacount bigint,
    f_datasize bigint,
    f_updatetime timestamp(6) without time zone
);


--
-- Name: TABLE tbds_statistic; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbds_statistic IS '数据集统计信息';


--
-- Name: COLUMN tbds_statistic.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_statistic.f_id IS '数据集id';


--
-- Name: COLUMN tbds_statistic.f_dskey; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_statistic.f_dskey IS '数据源key';


--
-- Name: COLUMN tbds_statistic.f_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_statistic.f_type IS '数据集类型';


--
-- Name: COLUMN tbds_statistic.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_statistic.f_name IS '数据集名称';


--
-- Name: COLUMN tbds_statistic.f_datacount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_statistic.f_datacount IS '数量';


--
-- Name: COLUMN tbds_statistic.f_datasize; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_statistic.f_datasize IS '数据存储大小（byte）';


--
-- Name: COLUMN tbds_statistic.f_updatetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_statistic.f_updatetime IS '统计时间';


--
-- Name: tbds_tile; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbds_tile (
    f_id character varying(256) NOT NULL,
    f_name character varying(256),
    f_aliasname character varying(256),
    f_sourceformat integer,
    f_tiletype integer,
    f_path character varying(1024),
    f_username character varying(256),
    f_password character varying(256)
);


--
-- Name: TABLE tbds_tile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbds_tile IS '文件型瓦片数据集表';


--
-- Name: COLUMN tbds_tile.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_tile.f_id IS '数据集id';


--
-- Name: COLUMN tbds_tile.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_tile.f_name IS '数据集名称';


--
-- Name: COLUMN tbds_tile.f_aliasname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_tile.f_aliasname IS '数据集别名';


--
-- Name: COLUMN tbds_tile.f_sourceformat; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_tile.f_sourceformat IS '瓦片文件格式';


--
-- Name: COLUMN tbds_tile.f_tiletype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_tile.f_tiletype IS '瓦片类型';


--
-- Name: COLUMN tbds_tile.f_path; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_tile.f_path IS '瓦片文件路径';


--
-- Name: COLUMN tbds_tile.f_username; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_tile.f_username IS '文件连接用户名';


--
-- Name: COLUMN tbds_tile.f_password; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbds_tile.f_password IS '文件连接密码';


--
-- Name: tbexp_task; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbexp_task (
    f_id integer NOT NULL,
    f_name character varying(100),
    f_desc character varying(200),
    f_status integer,
    f_result integer,
    f_createuser character varying(255),
    f_createtime timestamp(6) without time zone,
    f_starttime timestamp(6) without time zone,
    f_modifytime timestamp(6) without time zone,
    f_endtime timestamp(6) without time zone,
    f_progsuccess integer,
    f_progfail integer,
    f_progtotal integer,
    f_failmsg character varying(1000),
    f_failcode integer,
    f_datatype smallint,
    f_params bytea,
    f_tasktype character varying(500) DEFAULT 0
);


--
-- Name: TABLE tbexp_task; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbexp_task IS '提取任务表';


--
-- Name: COLUMN tbexp_task.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_task.f_id IS 'id';


--
-- Name: COLUMN tbexp_task.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_task.f_name IS '任务名称';


--
-- Name: COLUMN tbexp_task.f_desc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_task.f_desc IS '任务描述';


--
-- Name: COLUMN tbexp_task.f_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_task.f_status IS '任务状态（1-未执行，2-执行中，4-暂停，8-完成）';


--
-- Name: COLUMN tbexp_task.f_result; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_task.f_result IS '任务结果（0-失败，1-成功）';


--
-- Name: COLUMN tbexp_task.f_createuser; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_task.f_createuser IS '创建用户id';


--
-- Name: COLUMN tbexp_task.f_createtime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_task.f_createtime IS '创建时间';


--
-- Name: COLUMN tbexp_task.f_starttime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_task.f_starttime IS '开始时间';


--
-- Name: COLUMN tbexp_task.f_modifytime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_task.f_modifytime IS '修改时间';


--
-- Name: COLUMN tbexp_task.f_endtime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_task.f_endtime IS '结束时间';


--
-- Name: COLUMN tbexp_task.f_progsuccess; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_task.f_progsuccess IS '成功数量';


--
-- Name: COLUMN tbexp_task.f_progfail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_task.f_progfail IS '失败数量';


--
-- Name: COLUMN tbexp_task.f_progtotal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_task.f_progtotal IS '总数';


--
-- Name: COLUMN tbexp_task.f_failmsg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_task.f_failmsg IS '失败信息';


--
-- Name: COLUMN tbexp_task.f_failcode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_task.f_failcode IS '失败code';


--
-- Name: COLUMN tbexp_task.f_datatype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_task.f_datatype IS '数据类型（0-矢量，1-栅格，2-瓦片）';


--
-- Name: COLUMN tbexp_task.f_params; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_task.f_params IS '提取参数';


--
-- Name: COLUMN tbexp_task.f_tasktype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_task.f_tasktype IS '任务类型';


--
-- Name: tbexp_task_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbexp_task_f_id_seq
    AS integer
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbexp_task_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbexp_task_f_id_seq OWNED BY tbexp_task.f_id;


--
-- Name: tbexp_taskdata; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbexp_taskdata (
    f_id integer NOT NULL,
    f_dataname character varying(100),
    f_taskid integer,
    f_taskunitid integer,
    f_status integer,
    f_result integer,
    f_progsuccess integer,
    f_progfail integer,
    f_progtotal integer,
    f_failmsg character varying(1000),
    f_failcode integer,
    f_params bytea,
    f_datatype smallint,
    f_starttime timestamp(6) without time zone,
    f_endtime timestamp(6) without time zone
);


--
-- Name: TABLE tbexp_taskdata; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbexp_taskdata IS '提取任务数据表';


--
-- Name: COLUMN tbexp_taskdata.f_dataname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskdata.f_dataname IS '数据名称';


--
-- Name: COLUMN tbexp_taskdata.f_taskid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskdata.f_taskid IS '任务id';


--
-- Name: COLUMN tbexp_taskdata.f_taskunitid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskdata.f_taskunitid IS '任务单元id';


--
-- Name: COLUMN tbexp_taskdata.f_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskdata.f_status IS '任务状态（1-未执行，2-执行中，4-暂停，8-完成';


--
-- Name: COLUMN tbexp_taskdata.f_result; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskdata.f_result IS '任务结果（0-失败，1-成功）';


--
-- Name: COLUMN tbexp_taskdata.f_progsuccess; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskdata.f_progsuccess IS '成功数量';


--
-- Name: COLUMN tbexp_taskdata.f_progfail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskdata.f_progfail IS '失败数量';


--
-- Name: COLUMN tbexp_taskdata.f_progtotal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskdata.f_progtotal IS '总数';


--
-- Name: COLUMN tbexp_taskdata.f_failmsg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskdata.f_failmsg IS '失败信息';


--
-- Name: COLUMN tbexp_taskdata.f_failcode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskdata.f_failcode IS '失败code';


--
-- Name: COLUMN tbexp_taskdata.f_params; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskdata.f_params IS '提取参数';


--
-- Name: COLUMN tbexp_taskdata.f_datatype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskdata.f_datatype IS '数据类型（0-矢量，1-栅格，2-瓦片）';


--
-- Name: COLUMN tbexp_taskdata.f_starttime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskdata.f_starttime IS '开始时间';


--
-- Name: COLUMN tbexp_taskdata.f_endtime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskdata.f_endtime IS '结束时间';


--
-- Name: tbexp_taskdata_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbexp_taskdata_f_id_seq
    AS integer
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbexp_taskdata_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbexp_taskdata_f_id_seq OWNED BY tbexp_taskdata.f_id;


--
-- Name: tbexp_tasklog; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbexp_tasklog (
    f_id integer NOT NULL,
    f_taskdataid integer,
    f_time timestamp(6) without time zone,
    f_content character varying(1000),
    f_level smallint
);


--
-- Name: tbexp_tasklog_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbexp_tasklog_f_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbexp_tasklog_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbexp_tasklog_f_id_seq OWNED BY tbexp_tasklog.f_id;


--
-- Name: tbexp_taskunit; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbexp_taskunit (
    f_id integer NOT NULL,
    f_taskid integer,
    f_unitname character varying(200),
    f_status integer,
    f_result integer,
    f_progsuccess integer,
    f_progfail integer,
    f_progtotal integer,
    f_failmsg character varying(1000),
    f_failcode integer,
    f_starttime timestamp(6) without time zone,
    f_endtime timestamp(6) without time zone
);


--
-- Name: TABLE tbexp_taskunit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbexp_taskunit IS '提取任务单元表';


--
-- Name: COLUMN tbexp_taskunit.f_taskid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskunit.f_taskid IS '任务id';


--
-- Name: COLUMN tbexp_taskunit.f_unitname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskunit.f_unitname IS '任务单元名称';


--
-- Name: COLUMN tbexp_taskunit.f_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskunit.f_status IS '任务状态（1-未执行，2-执行中，4-暂停，8-完成';


--
-- Name: COLUMN tbexp_taskunit.f_result; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskunit.f_result IS '任务结果（0-失败，1-成功）';


--
-- Name: COLUMN tbexp_taskunit.f_progsuccess; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskunit.f_progsuccess IS '成功数量';


--
-- Name: COLUMN tbexp_taskunit.f_progfail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskunit.f_progfail IS '失败数量';


--
-- Name: COLUMN tbexp_taskunit.f_progtotal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskunit.f_progtotal IS '总数';


--
-- Name: COLUMN tbexp_taskunit.f_failmsg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskunit.f_failmsg IS '失败信息';


--
-- Name: COLUMN tbexp_taskunit.f_failcode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskunit.f_failcode IS '失败code';


--
-- Name: COLUMN tbexp_taskunit.f_starttime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskunit.f_starttime IS '开始时间';


--
-- Name: COLUMN tbexp_taskunit.f_endtime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbexp_taskunit.f_endtime IS '结束时间';


--
-- Name: tbexp_taskunit_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbexp_taskunit_f_id_seq
    AS integer
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbexp_taskunit_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbexp_taskunit_f_id_seq OWNED BY tbexp_taskunit.f_id;


--
-- Name: tbimp_datadatum; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbimp_datadatum (
    f_id bigint NOT NULL,
    f_name character varying(500),
    f_taskid bigint,
    f_unitid bigint,
    f_path character varying(1000),
    f_datasetname character varying(100),
    f_xmin numeric(136,10),
    f_xmax numeric(136,10),
    f_ymin numeric(136,10),
    f_ymax numeric(136,10),
    f_filedata bytea
);


--
-- Name: COLUMN tbimp_datadatum.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datadatum.f_id IS 'id';


--
-- Name: COLUMN tbimp_datadatum.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datadatum.f_name IS '数据名称';


--
-- Name: COLUMN tbimp_datadatum.f_taskid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datadatum.f_taskid IS '任务id';


--
-- Name: COLUMN tbimp_datadatum.f_unitid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datadatum.f_unitid IS '数据单元id';


--
-- Name: COLUMN tbimp_datadatum.f_path; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datadatum.f_path IS '数据路径';


--
-- Name: COLUMN tbimp_datadatum.f_datasetname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datadatum.f_datasetname IS '目标数据集名称';


--
-- Name: COLUMN tbimp_datadatum.f_xmin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datadatum.f_xmin IS '数据范围xmin';


--
-- Name: COLUMN tbimp_datadatum.f_xmax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datadatum.f_xmax IS '数据范围xmax';


--
-- Name: COLUMN tbimp_datadatum.f_ymin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datadatum.f_ymin IS '数据范围ymin';


--
-- Name: COLUMN tbimp_datadatum.f_ymax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datadatum.f_ymax IS '数据范围ymax';


--
-- Name: tbimp_dataraster; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbimp_dataraster (
    f_id bigint NOT NULL,
    f_name character varying(200),
    f_taskid bigint,
    f_unitid bigint,
    f_path character varying(2000),
    f_datasetname character varying(200),
    f_xmin double precision,
    f_xmax double precision,
    f_ymin double precision,
    f_ymax double precision
);


--
-- Name: TABLE tbimp_dataraster; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbimp_dataraster IS '入库栅格数据';


--
-- Name: COLUMN tbimp_dataraster.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_dataraster.f_id IS 'id';


--
-- Name: COLUMN tbimp_dataraster.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_dataraster.f_name IS '数据名称';


--
-- Name: COLUMN tbimp_dataraster.f_taskid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_dataraster.f_taskid IS '任务id';


--
-- Name: COLUMN tbimp_dataraster.f_unitid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_dataraster.f_unitid IS '数据单元id';


--
-- Name: COLUMN tbimp_dataraster.f_path; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_dataraster.f_path IS '数据路径';


--
-- Name: COLUMN tbimp_dataraster.f_datasetname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_dataraster.f_datasetname IS '目标数据名称';


--
-- Name: COLUMN tbimp_dataraster.f_xmin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_dataraster.f_xmin IS '数据范围xmin';


--
-- Name: COLUMN tbimp_dataraster.f_xmax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_dataraster.f_xmax IS '数据范围xmax';


--
-- Name: COLUMN tbimp_dataraster.f_ymin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_dataraster.f_ymin IS '数据范围ymin';


--
-- Name: COLUMN tbimp_dataraster.f_ymax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_dataraster.f_ymax IS '数据范围ymax';


--
-- Name: tbimp_datatile; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbimp_datatile (
    f_id bigint NOT NULL,
    f_name character varying(500),
    f_taskid bigint,
    f_unitid bigint,
    f_path character varying(1000),
    f_levelid integer,
    f_xmin character varying(100),
    f_xmax character varying(100),
    f_ymin character varying(100),
    f_ymax character varying(100)
);


--
-- Name: TABLE tbimp_datatile; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbimp_datatile IS '入库瓦片数据';


--
-- Name: tbimp_dataunit; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbimp_dataunit (
    f_id bigint NOT NULL,
    f_name character varying(200),
    f_code character varying(200),
    f_taskid bigint NOT NULL,
    f_path character varying(2000)
);


--
-- Name: TABLE tbimp_dataunit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbimp_dataunit IS '入库数据单元';


--
-- Name: COLUMN tbimp_dataunit.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_dataunit.f_id IS 'id';


--
-- Name: COLUMN tbimp_dataunit.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_dataunit.f_name IS '数据单元名称';


--
-- Name: COLUMN tbimp_dataunit.f_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_dataunit.f_code IS '数据单元编码';


--
-- Name: COLUMN tbimp_dataunit.f_taskid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_dataunit.f_taskid IS '任务id';


--
-- Name: COLUMN tbimp_dataunit.f_path; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_dataunit.f_path IS '数据路径';


--
-- Name: tbimp_datavector; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbimp_datavector (
    f_id bigint NOT NULL,
    f_name character varying(200),
    f_taskid bigint,
    f_unitid bigint,
    f_path character varying(2000),
    f_datasetname character varying(200),
    f_xmin double precision,
    f_xmax double precision,
    f_ymin double precision,
    f_ymax double precision
);


--
-- Name: TABLE tbimp_datavector; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbimp_datavector IS '入库矢量数据';


--
-- Name: COLUMN tbimp_datavector.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datavector.f_id IS 'id';


--
-- Name: COLUMN tbimp_datavector.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datavector.f_name IS '数据名称';


--
-- Name: COLUMN tbimp_datavector.f_taskid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datavector.f_taskid IS '任务id';


--
-- Name: COLUMN tbimp_datavector.f_unitid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datavector.f_unitid IS '数据单元id';


--
-- Name: COLUMN tbimp_datavector.f_path; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datavector.f_path IS '数据路径';


--
-- Name: COLUMN tbimp_datavector.f_datasetname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datavector.f_datasetname IS '目标数据集名称';


--
-- Name: COLUMN tbimp_datavector.f_xmin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datavector.f_xmin IS '数据范围xmin';


--
-- Name: COLUMN tbimp_datavector.f_xmax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datavector.f_xmax IS '数据范围xmax';


--
-- Name: COLUMN tbimp_datavector.f_ymin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datavector.f_ymin IS '数据范围ymin';


--
-- Name: COLUMN tbimp_datavector.f_ymax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_datavector.f_ymax IS '数据范围ymax';


--
-- Name: tbimp_log; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbimp_log (
    f_taskid bigint NOT NULL,
    f_time timestamp(6) without time zone,
    f_content character varying(1000),
    f_type smallint,
    f_level smallint,
    f_refid bigint
);


--
-- Name: TABLE tbimp_log; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbimp_log IS '入库日志';


--
-- Name: COLUMN tbimp_log.f_taskid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_log.f_taskid IS '任务id';


--
-- Name: COLUMN tbimp_log.f_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_log.f_time IS '时间';


--
-- Name: COLUMN tbimp_log.f_content; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_log.f_content IS '日志内容';


--
-- Name: tbimp_plugin; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbimp_plugin (
    f_id bigint NOT NULL,
    f_name character varying(200),
    f_group character varying(100),
    f_desc character varying(500),
    f_assembly character varying(500),
    f_classname character varying(500),
    f_detail text
);


--
-- Name: TABLE tbimp_plugin; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbimp_plugin IS '入库插件表';


--
-- Name: COLUMN tbimp_plugin.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_plugin.f_id IS 'id';


--
-- Name: COLUMN tbimp_plugin.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_plugin.f_name IS '插件名称';


--
-- Name: COLUMN tbimp_plugin.f_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_plugin.f_group IS '插件分组';


--
-- Name: COLUMN tbimp_plugin.f_desc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_plugin.f_desc IS '描述';


--
-- Name: COLUMN tbimp_plugin.f_assembly; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_plugin.f_assembly IS '程序集';


--
-- Name: COLUMN tbimp_plugin.f_classname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_plugin.f_classname IS '插件类';


--
-- Name: COLUMN tbimp_plugin.f_detail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_plugin.f_detail IS '插件参数';


--
-- Name: tbimp_plugin_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbimp_plugin_f_id_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbimp_plugin_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbimp_plugin_f_id_seq OWNED BY tbimp_plugin.f_id;


--
-- Name: tbimp_schema; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbimp_schema (
    f_id bigint NOT NULL,
    f_name character varying(200),
    f_desc character varying(500),
    f_pluginid bigint NOT NULL,
    f_paramvalues bytea,
    f_type character varying(100),
    f_tag character varying(100),
    f_createuser character varying(255)
);


--
-- Name: TABLE tbimp_schema; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbimp_schema IS '入库方案表';


--
-- Name: COLUMN tbimp_schema.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_schema.f_id IS 'id';


--
-- Name: COLUMN tbimp_schema.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_schema.f_name IS '方案名称';


--
-- Name: COLUMN tbimp_schema.f_desc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_schema.f_desc IS '描述';


--
-- Name: COLUMN tbimp_schema.f_pluginid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_schema.f_pluginid IS '插件id';


--
-- Name: COLUMN tbimp_schema.f_paramvalues; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_schema.f_paramvalues IS '方案参数';


--
-- Name: COLUMN tbimp_schema.f_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_schema.f_type IS '分类';


--
-- Name: COLUMN tbimp_schema.f_tag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_schema.f_tag IS '扩展信息';


--
-- Name: COLUMN tbimp_schema.f_createuser; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_schema.f_createuser IS '用户';


--
-- Name: tbimp_schema_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbimp_schema_f_id_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbimp_schema_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbimp_schema_f_id_seq OWNED BY tbimp_schema.f_id;


--
-- Name: tbimp_task; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbimp_task (
    f_id bigint NOT NULL,
    f_name character varying(200),
    f_desc character varying(200),
    f_status integer,
    f_createuser character varying(255),
    f_createtime timestamp(6) without time zone,
    f_starttime timestamp(6) without time zone,
    f_modifytime timestamp(6) without time zone,
    f_endtime timestamp(6) without time zone,
    f_progsuccess bigint,
    f_progfail bigint,
    f_progtotal bigint,
    f_schemaid bigint,
    f_failmsg text,
    f_failcode integer,
    f_sourceparams bytea,
    f_settingparams bytea,
    f_tasktype character varying(500) DEFAULT 0
);


--
-- Name: TABLE tbimp_task; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbimp_task IS '入库任务表';


--
-- Name: COLUMN tbimp_task.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_task.f_id IS 'id';


--
-- Name: COLUMN tbimp_task.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_task.f_name IS '任务名称';


--
-- Name: COLUMN tbimp_task.f_desc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_task.f_desc IS '描述';


--
-- Name: COLUMN tbimp_task.f_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_task.f_status IS '任务状态';


--
-- Name: COLUMN tbimp_task.f_createuser; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_task.f_createuser IS '创建用户';


--
-- Name: COLUMN tbimp_task.f_createtime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_task.f_createtime IS '创建时间';


--
-- Name: COLUMN tbimp_task.f_starttime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_task.f_starttime IS '开始时间';


--
-- Name: COLUMN tbimp_task.f_modifytime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_task.f_modifytime IS '修改时间';


--
-- Name: COLUMN tbimp_task.f_endtime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_task.f_endtime IS '结束时间';


--
-- Name: COLUMN tbimp_task.f_progsuccess; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_task.f_progsuccess IS '成功数量';


--
-- Name: COLUMN tbimp_task.f_progfail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_task.f_progfail IS '失败数量';


--
-- Name: COLUMN tbimp_task.f_progtotal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_task.f_progtotal IS '总数';


--
-- Name: COLUMN tbimp_task.f_schemaid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_task.f_schemaid IS '入库方案id';


--
-- Name: COLUMN tbimp_task.f_failmsg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_task.f_failmsg IS '失败信息';


--
-- Name: COLUMN tbimp_task.f_failcode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_task.f_failcode IS '失败code';


--
-- Name: COLUMN tbimp_task.f_sourceparams; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_task.f_sourceparams IS '任务基本参数';


--
-- Name: COLUMN tbimp_task.f_settingparams; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_task.f_settingparams IS '任务运行时参数';


--
-- Name: COLUMN tbimp_task.f_tasktype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_task.f_tasktype IS '任务类型';


--
-- Name: tbimp_task_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbimp_task_f_id_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbimp_task_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbimp_task_f_id_seq OWNED BY tbimp_task.f_id;


--
-- Name: tbimp_taskdata; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbimp_taskdata (
    f_id bigint NOT NULL,
    f_dataname character varying(200),
    f_taskid bigint,
    f_taskunitid bigint,
    f_status integer,
    f_progsuccess bigint,
    f_progfail bigint,
    f_progtotal bigint,
    f_failmsg text,
    f_failcode integer,
    f_starttime timestamp(6) without time zone,
    f_endtime timestamp(6) without time zone
);


--
-- Name: TABLE tbimp_taskdata; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbimp_taskdata IS '入库任务数据表';


--
-- Name: COLUMN tbimp_taskdata.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdata.f_id IS 'id';


--
-- Name: COLUMN tbimp_taskdata.f_dataname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdata.f_dataname IS '数据名称';


--
-- Name: COLUMN tbimp_taskdata.f_taskid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdata.f_taskid IS '任务id';


--
-- Name: COLUMN tbimp_taskdata.f_taskunitid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdata.f_taskunitid IS '任务单元id';


--
-- Name: COLUMN tbimp_taskdata.f_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdata.f_status IS '任务状态';


--
-- Name: COLUMN tbimp_taskdata.f_progsuccess; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdata.f_progsuccess IS '成功数量';


--
-- Name: COLUMN tbimp_taskdata.f_progfail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdata.f_progfail IS '失败数量';


--
-- Name: COLUMN tbimp_taskdata.f_progtotal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdata.f_progtotal IS '总数';


--
-- Name: COLUMN tbimp_taskdata.f_failmsg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdata.f_failmsg IS '失败信息';


--
-- Name: COLUMN tbimp_taskdata.f_failcode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdata.f_failcode IS '失败码';


--
-- Name: COLUMN tbimp_taskdata.f_starttime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdata.f_starttime IS '开始时间';


--
-- Name: COLUMN tbimp_taskdata.f_endtime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdata.f_endtime IS '结束时间';


--
-- Name: tbimp_taskdata_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbimp_taskdata_f_id_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbimp_taskdata_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbimp_taskdata_f_id_seq OWNED BY tbimp_taskdata.f_id;


--
-- Name: tbimp_taskdataunit; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbimp_taskdataunit (
    f_id bigint NOT NULL,
    f_taskid bigint,
    f_unitname character varying(200),
    f_status integer,
    f_progsuccess bigint,
    f_progfail bigint,
    f_progtotal bigint,
    f_failmsg text,
    f_failcode integer,
    f_starttime timestamp(6) without time zone,
    f_endtime timestamp(6) without time zone
);


--
-- Name: TABLE tbimp_taskdataunit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbimp_taskdataunit IS '入库任务单元表';


--
-- Name: COLUMN tbimp_taskdataunit.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdataunit.f_id IS 'id';


--
-- Name: COLUMN tbimp_taskdataunit.f_taskid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdataunit.f_taskid IS '任务id';


--
-- Name: COLUMN tbimp_taskdataunit.f_unitname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdataunit.f_unitname IS '任务单元名称';


--
-- Name: COLUMN tbimp_taskdataunit.f_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdataunit.f_status IS '执行状态';


--
-- Name: COLUMN tbimp_taskdataunit.f_progsuccess; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdataunit.f_progsuccess IS '成功数量';


--
-- Name: COLUMN tbimp_taskdataunit.f_progfail; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdataunit.f_progfail IS '失败数量';


--
-- Name: COLUMN tbimp_taskdataunit.f_progtotal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdataunit.f_progtotal IS '总数';


--
-- Name: COLUMN tbimp_taskdataunit.f_failmsg; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdataunit.f_failmsg IS '失败信息';


--
-- Name: COLUMN tbimp_taskdataunit.f_failcode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdataunit.f_failcode IS '失败码';


--
-- Name: COLUMN tbimp_taskdataunit.f_starttime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdataunit.f_starttime IS '开始时间';


--
-- Name: COLUMN tbimp_taskdataunit.f_endtime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbimp_taskdataunit.f_endtime IS '结束时间';


--
-- Name: tbimp_taskdataunit_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbimp_taskdataunit_f_id_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbimp_taskdataunit_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbimp_taskdataunit_f_id_seq OWNED BY tbimp_taskdataunit.f_id;


--
-- Name: tbinput_spatialdata; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbinput_spatialdata (
    f_id bigint NOT NULL,
    f_mapno character varying(200),
    f_year character varying(100),
    f_datatype character varying(100),
    f_spatialref character varying(100),
    f_scale character varying(100),
    f_surveyarea character varying(20),
    f_copiesindex bigint,
    f_datapath character varying(500),
    f_metadatapath character varying(500),
    f_dbkey character varying(100),
    f_physicaldatasetname character varying(100),
    f_starttime timestamp without time zone,
    f_finishedtime timestamp without time zone,
    f_ip character varying(100),
    f_username character varying(50),
    f_transactionid character varying(40),
    f_metatablename character varying(100),
    f_metadataid character varying(100),
    f_oidfieldname character varying(100)
);


--
-- Name: TABLE tbinput_spatialdata; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbinput_spatialdata IS '入库空间数据表';


--
-- Name: COLUMN tbinput_spatialdata.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_id IS 'id';


--
-- Name: COLUMN tbinput_spatialdata.f_mapno; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_mapno IS '图幅号';


--
-- Name: COLUMN tbinput_spatialdata.f_year; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_year IS '年份';


--
-- Name: COLUMN tbinput_spatialdata.f_datatype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_datatype IS '数据类型';


--
-- Name: COLUMN tbinput_spatialdata.f_spatialref; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_spatialref IS '坐标参考';


--
-- Name: COLUMN tbinput_spatialdata.f_scale; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_scale IS '比例尺';


--
-- Name: COLUMN tbinput_spatialdata.f_surveyarea; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_surveyarea IS '测区';


--
-- Name: COLUMN tbinput_spatialdata.f_copiesindex; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_copiesindex IS '批次';


--
-- Name: COLUMN tbinput_spatialdata.f_datapath; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_datapath IS '数据路径';


--
-- Name: COLUMN tbinput_spatialdata.f_metadatapath; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_metadatapath IS '元数据路径';


--
-- Name: COLUMN tbinput_spatialdata.f_dbkey; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_dbkey IS '物理存储数据库';


--
-- Name: COLUMN tbinput_spatialdata.f_physicaldatasetname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_physicaldatasetname IS '物理数据集名称';


--
-- Name: COLUMN tbinput_spatialdata.f_starttime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_starttime IS '开始时间';


--
-- Name: COLUMN tbinput_spatialdata.f_finishedtime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_finishedtime IS '结束时间';


--
-- Name: COLUMN tbinput_spatialdata.f_ip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_ip IS 'ip';


--
-- Name: COLUMN tbinput_spatialdata.f_username; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_username IS '用户名';


--
-- Name: COLUMN tbinput_spatialdata.f_transactionid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_transactionid IS '事务id';


--
-- Name: COLUMN tbinput_spatialdata.f_metatablename; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_metatablename IS '元数据存储表表名';


--
-- Name: COLUMN tbinput_spatialdata.f_metadataid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_metadataid IS '元数据记录id';


--
-- Name: COLUMN tbinput_spatialdata.f_oidfieldname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbinput_spatialdata.f_oidfieldname IS '元数据表oid字段名称';


--
-- Name: tbinput_spatialdata_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbinput_spatialdata_f_id_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbinput_spatialdata_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbinput_spatialdata_f_id_seq OWNED BY tbinput_spatialdata.f_id;


--
-- Name: tbsys_indexlayer_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbsys_indexlayer_f_id_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbsys_indexlayer_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbsys_indexlayer_f_id_seq OWNED BY tbcm_indexlayer.f_id;


--
-- Name: tbsys_log; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbsys_log (
    f_id bigint NOT NULL,
    f_time timestamp without time zone,
    f_eventid bigint NOT NULL,
    f_username character varying(255),
    f_content character varying(512),
    f_ip character varying(255),
    f_clientos character varying(200),
    f_browsertype character varying(200),
    f_clientplatform character varying(200)
);


--
-- Name: TABLE tbsys_log; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbsys_log IS '日志表';


--
-- Name: COLUMN tbsys_log.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbsys_log.f_id IS '日志id';


--
-- Name: COLUMN tbsys_log.f_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbsys_log.f_time IS '时间';


--
-- Name: COLUMN tbsys_log.f_eventid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbsys_log.f_eventid IS '事件id';


--
-- Name: COLUMN tbsys_log.f_username; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbsys_log.f_username IS '用户名';


--
-- Name: COLUMN tbsys_log.f_content; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbsys_log.f_content IS '日志内容';


--
-- Name: COLUMN tbsys_log.f_ip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbsys_log.f_ip IS 'ip';


--
-- Name: tbsys_log_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbsys_log_f_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbsys_log_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbsys_log_f_id_seq OWNED BY tbsys_log.f_id;


--
-- Name: tbsys_logevent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbsys_logevent (
    f_eventid bigint NOT NULL,
    f_event character varying(255)
);


--
-- Name: TABLE tbsys_logevent; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbsys_logevent IS '事件表';


--
-- Name: COLUMN tbsys_logevent.f_eventid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbsys_logevent.f_eventid IS '事件id';


--
-- Name: COLUMN tbsys_logevent.f_event; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbsys_logevent.f_event IS '事件';


--
-- Name: tbsys_sysparam; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbsys_sysparam (
    f_id bigint NOT NULL,
    f_name character varying(500),
    f_key character varying(500),
    f_value bytea,
    f_desc character varying(1000),
    f_group bigint,
    f_userkey character varying(500),
    f_type integer
);


--
-- Name: TABLE tbsys_sysparam; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbsys_sysparam IS '系统参数配置表';


--
-- Name: COLUMN tbsys_sysparam.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbsys_sysparam.f_name IS '参数名称';


--
-- Name: COLUMN tbsys_sysparam.f_key; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbsys_sysparam.f_key IS '参数标识';


--
-- Name: COLUMN tbsys_sysparam.f_value; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbsys_sysparam.f_value IS '参数值';


--
-- Name: COLUMN tbsys_sysparam.f_desc; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbsys_sysparam.f_desc IS '描述';


--
-- Name: COLUMN tbsys_sysparam.f_group; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbsys_sysparam.f_group IS '分组标识';


--
-- Name: COLUMN tbsys_sysparam.f_userkey; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbsys_sysparam.f_userkey IS '用户标识';


--
-- Name: COLUMN tbsys_sysparam.f_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbsys_sysparam.f_type IS '0-参数，1-分组';


--
-- Name: tbsys_sysparam_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbsys_sysparam_f_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbsys_sysparam_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbsys_sysparam_f_id_seq OWNED BY tbsys_sysparam.f_id;


--
-- Name: tbupdate_caseinfo; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbupdate_caseinfo (
    f_id bigint NOT NULL,
    f_name character varying(200),
    f_buildtime timestamp without time zone,
    f_buildperson character varying(50),
    f_operator character varying(50) NOT NULL,
    f_layerversions character varying(5000) NOT NULL,
    f_displayfilter character varying(2500),
    f_type integer NOT NULL,
    f_description character varying(500)
);


--
-- Name: TABLE tbupdate_caseinfo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbupdate_caseinfo IS '更新记录表';


--
-- Name: COLUMN tbupdate_caseinfo.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_caseinfo.f_name IS '工程名称，或称为工程版本名称，唯一 ';


--
-- Name: COLUMN tbupdate_caseinfo.f_buildtime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_caseinfo.f_buildtime IS '创建时间';


--
-- Name: COLUMN tbupdate_caseinfo.f_buildperson; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_caseinfo.f_buildperson IS '创建人';


--
-- Name: COLUMN tbupdate_caseinfo.f_operator; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_caseinfo.f_operator IS '责任人';


--
-- Name: COLUMN tbupdate_caseinfo.f_layerversions; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_caseinfo.f_layerversions IS '图层版本列表，例：HYDAV1|HVDLV2';


--
-- Name: COLUMN tbupdate_caseinfo.f_displayfilter; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_caseinfo.f_displayfilter IS '过滤显示条件';


--
-- Name: COLUMN tbupdate_caseinfo.f_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_caseinfo.f_type IS '工程类别，替换式更新，区域式更新、工程式更新、归档式';


--
-- Name: COLUMN tbupdate_caseinfo.f_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_caseinfo.f_description IS '描述信息';


--
-- Name: tbupdate_caseinfo_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbupdate_caseinfo_f_id_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbupdate_caseinfo_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbupdate_caseinfo_f_id_seq OWNED BY tbupdate_caseinfo.f_id;


--
-- Name: tbupdate_layerupdateinfo; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbupdate_layerupdateinfo (
    f_id bigint NOT NULL,
    f_taskid bigint,
    f_layername character varying(200),
    f_predatetime date,
    f_postdatetime date,
    f_datasetname character varying(200),
    f_datasetid character varying(200),
    f_databasekey character varying(64)
);


--
-- Name: TABLE tbupdate_layerupdateinfo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbupdate_layerupdateinfo IS '图层更新记录表';


--
-- Name: COLUMN tbupdate_layerupdateinfo.f_taskid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerupdateinfo.f_taskid IS '更新任务id，tbupdate_caseinfo.f_id';


--
-- Name: COLUMN tbupdate_layerupdateinfo.f_layername; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerupdateinfo.f_layername IS '更新图层名称';


--
-- Name: COLUMN tbupdate_layerupdateinfo.f_predatetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerupdateinfo.f_predatetime IS '更新前时相';


--
-- Name: COLUMN tbupdate_layerupdateinfo.f_postdatetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerupdateinfo.f_postdatetime IS '更新后时相';


--
-- Name: COLUMN tbupdate_layerupdateinfo.f_datasetname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerupdateinfo.f_datasetname IS '更新要素数据集名称';


--
-- Name: COLUMN tbupdate_layerupdateinfo.f_datasetid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerupdateinfo.f_datasetid IS '更新要素数据集id';


--
-- Name: COLUMN tbupdate_layerupdateinfo.f_databasekey; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerupdateinfo.f_databasekey IS '数据库标识';


--
-- Name: tbupdate_layerupdateinfo_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbupdate_layerupdateinfo_f_id_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbupdate_layerupdateinfo_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbupdate_layerupdateinfo_f_id_seq OWNED BY tbupdate_layerupdateinfo.f_id;


--
-- Name: tbupdate_layerversionkeyinfo; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbupdate_layerversionkeyinfo (
    f_id bigint NOT NULL,
    f_datasetid character varying(200),
    f_layername character varying(200),
    f_worklayer character varying(200) NOT NULL,
    f_uniquefield character varying(100),
    f_spatial character varying(50),
    f_scale character varying(10),
    f_versioninfo bytea,
    f_timestamp date,
    f_dskey character varying(200)
);


--
-- Name: COLUMN tbupdate_layerversionkeyinfo.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerversionkeyinfo.f_id IS 'ID';


--
-- Name: COLUMN tbupdate_layerversionkeyinfo.f_datasetid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerversionkeyinfo.f_datasetid IS '图层ID';


--
-- Name: COLUMN tbupdate_layerversionkeyinfo.f_layername; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerversionkeyinfo.f_layername IS '现势性最强图层名';


--
-- Name: COLUMN tbupdate_layerversionkeyinfo.f_worklayer; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerversionkeyinfo.f_worklayer IS '增量库图层名称';


--
-- Name: COLUMN tbupdate_layerversionkeyinfo.f_uniquefield; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerversionkeyinfo.f_uniquefield IS '用于唯一确定一条记录的字段';


--
-- Name: COLUMN tbupdate_layerversionkeyinfo.f_spatial; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerversionkeyinfo.f_spatial IS '空间参考';


--
-- Name: COLUMN tbupdate_layerversionkeyinfo.f_scale; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerversionkeyinfo.f_scale IS '比例尺';


--
-- Name: COLUMN tbupdate_layerversionkeyinfo.f_versioninfo; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerversionkeyinfo.f_versioninfo IS '存储自身及增量图层所在的数据集';


--
-- Name: tbupdate_layerversionkeyinfo_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbupdate_layerversionkeyinfo_f_id_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbupdate_layerversionkeyinfo_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbupdate_layerversionkeyinfo_f_id_seq OWNED BY tbupdate_layerversionkeyinfo.f_id;


--
-- Name: tbupdate_layerversionlist; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbupdate_layerversionlist (
    f_id bigint NOT NULL,
    f_versionname character varying(200),
    f_datasetid character varying(200),
    f_layername character varying(200),
    f_starttime date,
    f_versionkey bigint,
    f_description character varying(200),
    f_versionaliasname character varying(200)
);


--
-- Name: TABLE tbupdate_layerversionlist; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbupdate_layerversionlist IS '图层版本注册表';


--
-- Name: COLUMN tbupdate_layerversionlist.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerversionlist.f_id IS 'ID';


--
-- Name: COLUMN tbupdate_layerversionlist.f_versionname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerversionlist.f_versionname IS '版本名称';


--
-- Name: COLUMN tbupdate_layerversionlist.f_datasetid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerversionlist.f_datasetid IS '图层ID';


--
-- Name: COLUMN tbupdate_layerversionlist.f_layername; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerversionlist.f_layername IS '版本名称';


--
-- Name: COLUMN tbupdate_layerversionlist.f_starttime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerversionlist.f_starttime IS '版本开始时间';


--
-- Name: COLUMN tbupdate_layerversionlist.f_versionkey; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerversionlist.f_versionkey IS 'tbupdate_layerversionkeyinfo.f_id';


--
-- Name: COLUMN tbupdate_layerversionlist.f_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_layerversionlist.f_description IS '备注';


--
-- Name: tbupdate_layerversionlist_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbupdate_layerversionlist_f_id_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbupdate_layerversionlist_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbupdate_layerversionlist_f_id_seq OWNED BY tbupdate_layerversionlist.f_id;


--
-- Name: tbupdate_statconfig; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbupdate_statconfig (
    f_id character varying(64) NOT NULL,
    f_name character varying(200),
    f_datasetid character varying(500),
    f_datasourcename character varying(500),
    f_groupfield character varying(100),
    f_order integer
);


--
-- Name: TABLE tbupdate_statconfig; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbupdate_statconfig IS '更新统计配置表';


--
-- Name: COLUMN tbupdate_statconfig.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_statconfig.f_id IS '唯一标识';


--
-- Name: COLUMN tbupdate_statconfig.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_statconfig.f_name IS '统计单元名称';


--
-- Name: COLUMN tbupdate_statconfig.f_datasetid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_statconfig.f_datasetid IS '数据来源的数据集标识';


--
-- Name: COLUMN tbupdate_statconfig.f_datasourcename; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_statconfig.f_datasourcename IS '数据来源的数据集标识';


--
-- Name: COLUMN tbupdate_statconfig.f_groupfield; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_statconfig.f_groupfield IS '分组字段';


--
-- Name: COLUMN tbupdate_statconfig.f_order; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_statconfig.f_order IS '顺序';


--
-- Name: tbupdate_statresult; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbupdate_statresult (
    f_configid character varying(64),
    f_name character varying(200),
    f_add integer,
    f_modify integer,
    f_delete integer,
    f_updatetime timestamp(6) without time zone,
    f_datasetnamenow character varying(200) NOT NULL,
    f_dskey character varying(200) NOT NULL,
    f_datasetid character varying(500)
);


--
-- Name: TABLE tbupdate_statresult; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbupdate_statresult IS '更新统计结果表';


--
-- Name: COLUMN tbupdate_statresult.f_configid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_statresult.f_configid IS '更新统计配置标识';


--
-- Name: COLUMN tbupdate_statresult.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_statresult.f_name IS '统计结果项名称';


--
-- Name: COLUMN tbupdate_statresult.f_add; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_statresult.f_add IS '新增数量';


--
-- Name: COLUMN tbupdate_statresult.f_modify; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_statresult.f_modify IS '修改数量';


--
-- Name: COLUMN tbupdate_statresult.f_delete; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_statresult.f_delete IS '删除数量';


--
-- Name: COLUMN tbupdate_statresult.f_updatetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_statresult.f_updatetime IS '更新时间';


--
-- Name: COLUMN tbupdate_statresult.f_datasetnamenow; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_statresult.f_datasetnamenow IS '时空数据集名称';


--
-- Name: COLUMN tbupdate_statresult.f_dskey; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_statresult.f_dskey IS '数据源标识';


--
-- Name: COLUMN tbupdate_statresult.f_datasetid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_statresult.f_datasetid IS '统计图层的标识';


--
-- Name: tbupdate_task; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbupdate_task (
    f_id bigint NOT NULL,
    f_name character varying(200),
    f_resperson character varying(100),
    f_createperson character varying(100),
    f_createdatetime timestamp(0) without time zone,
    f_status integer DEFAULT 0,
    f_succeed integer DEFAULT 0,
    f_progress integer,
    f_log bytea,
    f_description character varying(500),
    f_para bytea,
    f_threadid integer,
    f_tasktype integer,
    f_starttime timestamp(0) without time zone,
    f_endtime timestamp(0) without time zone
);


--
-- Name: TABLE tbupdate_task; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbupdate_task IS '更新任务表';


--
-- Name: COLUMN tbupdate_task.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_task.f_id IS '标识';


--
-- Name: COLUMN tbupdate_task.f_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_task.f_name IS '任务名称';


--
-- Name: COLUMN tbupdate_task.f_resperson; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_task.f_resperson IS '责任人';


--
-- Name: COLUMN tbupdate_task.f_createperson; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_task.f_createperson IS '创建人';


--
-- Name: COLUMN tbupdate_task.f_createdatetime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_task.f_createdatetime IS '创建时间';


--
-- Name: COLUMN tbupdate_task.f_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_task.f_status IS '任务状态';


--
-- Name: COLUMN tbupdate_task.f_succeed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_task.f_succeed IS '是否成功';


--
-- Name: COLUMN tbupdate_task.f_progress; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_task.f_progress IS '进度';


--
-- Name: COLUMN tbupdate_task.f_log; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_task.f_log IS '日志';


--
-- Name: COLUMN tbupdate_task.f_description; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_task.f_description IS '描述';


--
-- Name: COLUMN tbupdate_task.f_para; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_task.f_para IS '任务参数';


--
-- Name: COLUMN tbupdate_task.f_threadid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_task.f_threadid IS '线程标识';


--
-- Name: COLUMN tbupdate_task.f_tasktype; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_task.f_tasktype IS '任务类型';


--
-- Name: COLUMN tbupdate_task.f_starttime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_task.f_starttime IS '开始时间';


--
-- Name: COLUMN tbupdate_task.f_endtime; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_task.f_endtime IS '结束时间';


--
-- Name: tbupdate_task_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbupdate_task_f_id_seq
    START WITH 10000
    INCREMENT BY 1
    MINVALUE 10000
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbupdate_task_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbupdate_task_f_id_seq OWNED BY tbupdate_task.f_id;


--
-- Name: tbupdate_tasklog; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tbupdate_tasklog (
    f_id bigint NOT NULL,
    f_taskid bigint,
    f_time timestamp(0) without time zone,
    f_content bytea,
    f_level character varying(255),
    f_layername character varying(255)
);


--
-- Name: TABLE tbupdate_tasklog; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE tbupdate_tasklog IS '更新任务日志表';


--
-- Name: COLUMN tbupdate_tasklog.f_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_tasklog.f_id IS '标识';


--
-- Name: COLUMN tbupdate_tasklog.f_taskid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_tasklog.f_taskid IS '更新任务ID';


--
-- Name: COLUMN tbupdate_tasklog.f_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_tasklog.f_time IS '时间';


--
-- Name: COLUMN tbupdate_tasklog.f_content; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_tasklog.f_content IS '日志内容';


--
-- Name: COLUMN tbupdate_tasklog.f_level; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_tasklog.f_level IS '日志级别';


--
-- Name: COLUMN tbupdate_tasklog.f_layername; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN tbupdate_tasklog.f_layername IS '图层名称';


--
-- Name: tbupdate_tasklog_f_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tbupdate_tasklog_f_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: tbupdate_tasklog_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE tbupdate_tasklog_f_id_seq OWNED BY tbupdate_tasklog.f_id;


--
-- Name: tbchart_snapshot f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbchart_snapshot ALTER COLUMN f_id SET DEFAULT nextval('tbchart_snapshot_f_id_seq'::regclass);


--
-- Name: tbcm_indexlayer f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_indexlayer ALTER COLUMN f_id SET DEFAULT nextval('tbsys_indexlayer_f_id_seq'::regclass);


--
-- Name: tbcm_mapviewscheme f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_mapviewscheme ALTER COLUMN f_id SET DEFAULT nextval('tbcm_mapviewscheme_f_id_seq'::regclass);


--
-- Name: tbcm_metadata f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_metadata ALTER COLUMN f_id SET DEFAULT nextval('tbcm_metadata_f_id_seq'::regclass);


--
-- Name: tbcm_metatemplate f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_metatemplate ALTER COLUMN f_id SET DEFAULT nextval('tbcm_metatemplate_f_id_seq'::regclass);


--
-- Name: tbcm_metatemplatefield f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_metatemplatefield ALTER COLUMN f_id SET DEFAULT nextval('tbcm_metatemplatefield_f_id_seq'::regclass);


--
-- Name: tbdm_district f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbdm_district ALTER COLUMN f_id SET DEFAULT nextval('tbdm_district_f_id_seq'::regclass);


--
-- Name: tbdm_districthot objectid; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbdm_districthot ALTER COLUMN objectid SET DEFAULT nextval('tbdm_districthot_objectid_seq'::regclass);


--
-- Name: tbdm_districtitem f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbdm_districtitem ALTER COLUMN f_id SET DEFAULT nextval('tbdm_districtitem_f_id_seq'::regclass);


--
-- Name: tbdm_domain f_dicno; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbdm_domain ALTER COLUMN f_dicno SET DEFAULT nextval('tbdm_domain_f_dicno_seq'::regclass);


--
-- Name: tbdm_domainvalue f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbdm_domainvalue ALTER COLUMN f_id SET DEFAULT nextval('tbdm_domainvalue_f_id_seq'::regclass);


--
-- Name: tbdm_filedata f_dataid; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbdm_filedata ALTER COLUMN f_dataid SET DEFAULT nextval('tbdm_filedata_f_dataid_seq'::regclass);


--
-- Name: tbdm_filemodel f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbdm_filemodel ALTER COLUMN f_id SET DEFAULT nextval('tbdm_filemodel_f_id_seq'::regclass);


--
-- Name: tbds_datumfields f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbds_datumfields ALTER COLUMN f_id SET DEFAULT nextval('tbds_datumfields_f_id_seq'::regclass);


--
-- Name: tbexp_task f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbexp_task ALTER COLUMN f_id SET DEFAULT nextval('tbexp_task_f_id_seq'::regclass);


--
-- Name: tbexp_taskdata f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbexp_taskdata ALTER COLUMN f_id SET DEFAULT nextval('tbexp_taskdata_f_id_seq'::regclass);


--
-- Name: tbexp_tasklog f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbexp_tasklog ALTER COLUMN f_id SET DEFAULT nextval('tbexp_tasklog_f_id_seq'::regclass);


--
-- Name: tbexp_taskunit f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbexp_taskunit ALTER COLUMN f_id SET DEFAULT nextval('tbexp_taskunit_f_id_seq'::regclass);


--
-- Name: tbimp_plugin f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_plugin ALTER COLUMN f_id SET DEFAULT nextval('tbimp_plugin_f_id_seq'::regclass);


--
-- Name: tbimp_schema f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_schema ALTER COLUMN f_id SET DEFAULT nextval('tbimp_schema_f_id_seq'::regclass);


--
-- Name: tbimp_task f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_task ALTER COLUMN f_id SET DEFAULT nextval('tbimp_task_f_id_seq'::regclass);


--
-- Name: tbimp_taskdata f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_taskdata ALTER COLUMN f_id SET DEFAULT nextval('tbimp_taskdata_f_id_seq'::regclass);


--
-- Name: tbimp_taskdataunit f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_taskdataunit ALTER COLUMN f_id SET DEFAULT nextval('tbimp_taskdataunit_f_id_seq'::regclass);


--
-- Name: tbinput_spatialdata f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbinput_spatialdata ALTER COLUMN f_id SET DEFAULT nextval('tbinput_spatialdata_f_id_seq'::regclass);


--
-- Name: tbsys_log f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbsys_log ALTER COLUMN f_id SET DEFAULT nextval('tbsys_log_f_id_seq'::regclass);


--
-- Name: tbsys_sysparam f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbsys_sysparam ALTER COLUMN f_id SET DEFAULT nextval('tbsys_sysparam_f_id_seq'::regclass);


--
-- Name: tbupdate_caseinfo f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbupdate_caseinfo ALTER COLUMN f_id SET DEFAULT nextval('tbupdate_caseinfo_f_id_seq'::regclass);


--
-- Name: tbupdate_layerupdateinfo f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbupdate_layerupdateinfo ALTER COLUMN f_id SET DEFAULT nextval('tbupdate_layerupdateinfo_f_id_seq'::regclass);


--
-- Name: tbupdate_layerversionkeyinfo f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbupdate_layerversionkeyinfo ALTER COLUMN f_id SET DEFAULT nextval('tbupdate_layerversionkeyinfo_f_id_seq'::regclass);


--
-- Name: tbupdate_layerversionlist f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbupdate_layerversionlist ALTER COLUMN f_id SET DEFAULT nextval('tbupdate_layerversionlist_f_id_seq'::regclass);


--
-- Name: tbupdate_task f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbupdate_task ALTER COLUMN f_id SET DEFAULT nextval('tbupdate_task_f_id_seq'::regclass);


--
-- Name: tbupdate_tasklog f_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbupdate_tasklog ALTER COLUMN f_id SET DEFAULT nextval('tbupdate_tasklog_f_id_seq'::regclass);


--
-- Data for Name: gw_class_metadata; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: gw_field_metadata; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: gw_geom_metadata; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: gw_spatial_ref_metadata; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: spatial_ref_sys; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: t_adf_history; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO t_adf_history VALUES (1, '20231019', '<< Flyway Baseline >>', 'BASELINE', '<< Flyway Baseline >>', NULL, 'null', '2023-10-31 14:08:02.03649', 0, true);
INSERT INTO t_adf_history VALUES (2, '20231024', 'alter metaTemplate', 'SQL', 'V20231024__alter_metaTemplate.sql', -761842687, 'zhk', '2024-03-12 09:23:58.003356', 304, true);
INSERT INTO t_adf_history VALUES (3, '20231024.2', 'alter district', 'SQL', 'V20231024_2__alter_district.sql', 209982675, 'zhk', '2024-03-12 09:23:58.421389', 171, true);
INSERT INTO t_adf_history VALUES (4, '20231101', 'alter resCatalog', 'SQL', 'V20231101__alter_resCatalog.sql', -67822112, 'zhk', '2024-03-12 09:23:58.613635', 5, true);
INSERT INTO t_adf_history VALUES (5, '20231103', 'create catalogRole', 'SQL', 'V20231103__create_catalogRole.sql', -1761117055, 'zhk', '2024-03-12 09:23:58.640135', 304, true);
INSERT INTO t_adf_history VALUES (6, '20231103.2', 'insert eventId', 'SQL', 'V20231103_2__insert_eventId.sql', 1254068874, 'zhk', '2024-03-12 09:23:58.974629', 48, true);
INSERT INTO t_adf_history VALUES (7, '20231104', 'create tile', 'SQL', 'V20231104__create_tile.sql', 1907978425, 'zhk', '2024-03-12 09:23:59.040487', 14, true);
INSERT INTO t_adf_history VALUES (8, '20231114', 'alter attachment', 'SQL', 'V20231114__alter_attachment.sql', -850736144, 'zhk', '2024-03-12 09:23:59.068886', 4, true);
INSERT INTO t_adf_history VALUES (9, '20231130', 'alter catalog', 'SQL', 'V20231130__alter_catalog.sql', 842334501, 'zhk', '2024-03-12 09:23:59.08666', 110, true);
INSERT INTO t_adf_history VALUES (10, '20231207.1', 'alter viewScheme', 'SQL', 'V20231207_1__alter_viewScheme.sql', 572466458, 'zhk', '2024-03-12 09:23:59.212407', 5, true);
INSERT INTO t_adf_history VALUES (11, '20231207.2', 'alter frontScheme', 'SQL', 'V20231207_2__alter_frontScheme.sql', -1794270717, 'zhk', '2024-03-12 09:23:59.231379', 9, true);
INSERT INTO t_adf_history VALUES (12, '20231208', 'alter catalogApp', 'SQL', 'V20231208__alter_catalogApp.sql', 1013618177, 'zhk', '2024-03-12 09:23:59.267618', 4, true);
INSERT INTO t_adf_history VALUES (13, '20231227', 'alter metaTemplate', 'SQL', 'V20231227__alter_metaTemplate.sql', 1399530875, 'zhk', '2024-03-12 09:23:59.285578', 31, true);
INSERT INTO t_adf_history VALUES (14, '20240206', 'alter datum', 'SQL', 'V20240206__alter_datum.sql', 497478444, 'zhk', '2024-03-12 09:23:59.363874', 5, true);
INSERT INTO t_adf_history VALUES (15, '20240229', 'alter catalog', 'SQL', 'V20240229__alter_catalog.sql', 1900405147, 'zhk', '2024-03-12 09:23:59.382835', 5, true);
INSERT INTO t_adf_history VALUES (16, '20240307', 'alter catalog', 'SQL', 'V20240307__alter_catalog.sql', -355932253, 'zhk', '2024-07-08 12:05:58.400022', 236, true);
INSERT INTO t_adf_history VALUES (17, '20240308', 'alter indicator', 'SQL', 'V20240308__alter_indicator.sql', 1812836034, 'zhk', '2024-07-08 12:05:58.676402', 216, true);
INSERT INTO t_adf_history VALUES (18, '20240311', 'create report', 'SQL', 'V20240311__create_report.sql', -1363923086, 'zhk', '2024-07-08 12:05:58.914296', 571, true);
INSERT INTO t_adf_history VALUES (19, '20240320', 'create catalogFavorite', 'SQL', 'V20240320__create_catalogFavorite.sql', -1635543433, 'zhk', '2024-07-08 12:05:59.505001', 9, true);
INSERT INTO t_adf_history VALUES (20, '20240403', 'alter catalog', 'SQL', 'V20240403__alter_catalog.sql', -833877029, 'zhk', '2024-07-08 12:05:59.531753', 67, true);
INSERT INTO t_adf_history VALUES (21, '20240423', 'create mapScene', 'SQL', 'V20240423__create_mapScene.sql', 1142613298, 'zhk', '2024-07-08 12:05:59.616088', 18, true);
INSERT INTO t_adf_history VALUES (22, '20240515', 'alter catalogFavoriteNode', 'SQL', 'V20240515__alter_catalogFavoriteNode.sql', 981986955, 'zhk', '2024-07-08 12:05:59.649808', 51, true);
INSERT INTO t_adf_history VALUES (23, '20240528', 'alter catalog', 'SQL', 'V20240528__alter_catalog.sql', -1328353447, 'zhk', '2024-07-08 12:05:59.728899', 5, true);
INSERT INTO t_adf_history VALUES (24, '20240529', 'alter service', 'SQL', 'V20240529__alter_service.sql', -1801117900, 'zhk', '2024-07-08 12:05:59.749152', 6, true);
INSERT INTO t_adf_history VALUES (25, '20240603', 'alter service', 'SQL', 'V20240603__alter_service.sql', -1168401840, 'zhk', '2024-07-08 12:05:59.772583', 106, true);
INSERT INTO t_adf_history VALUES (26, '20240618', 'alter syslog', 'SQL', 'V20240618__alter_syslog.sql', 1791691834, 'zhk', '2024-07-08 12:05:59.894316', 5, true);
INSERT INTO t_adf_history VALUES (27, '20240619', 'alter syslog', 'SQL', 'V20240619__alter_syslog.sql', -1067744592, 'zhk', '2024-07-08 12:05:59.914762', 4, true);
INSERT INTO t_adf_history VALUES (28, '20240704', 'create thumb', 'SQL', 'V20240704__create_thumb.sql', 1180429462, 'zhk', '2024-08-08 11:03:50.637345', 220, true);
INSERT INTO t_adf_history VALUES (29, '20240816', 'alter indicator', 'SQL', 'V20240816__alter_indicator.sql', -113352539, 'zhk', '2025-01-08 15:44:44.246672', 39, true);
INSERT INTO t_adf_history VALUES (30, '20240820', 'alter catalog', 'SQL', 'V20240820__alter_catalog.sql', 1630724950, 'zhk', '2025-01-08 15:44:44.307553', 8, true);
INSERT INTO t_adf_history VALUES (31, '20240821', 'alter metafield', 'SQL', 'V20240821__alter_metafield.sql', -1064407794, 'zhk', '2025-01-08 15:44:44.345699', 30, true);
INSERT INTO t_adf_history VALUES (32, '20240823', 'alter metafield', 'SQL', 'V20240823__alter_metafield.sql', -516150348, 'zhk', '2025-01-08 15:44:44.390119', 6, true);
INSERT INTO t_adf_history VALUES (33, '20240830', 'alter thumb', 'SQL', 'V20240830__alter_thumb.sql', 415034308, 'zhk', '2025-01-08 15:44:44.408335', 37, true);
INSERT INTO t_adf_history VALUES (34, '20240902', 'alter thumb', 'SQL', 'V20240902__alter_thumb.sql', 1562543813, 'zhk', '2025-01-08 15:44:44.579041', 11, true);
INSERT INTO t_adf_history VALUES (35, '20240909', 'create graphLabel', 'SQL', 'V20240909__create_graphLabel.sql', 1517748853, 'zhk', '2025-01-08 15:44:44.603831', 21, true);
INSERT INTO t_adf_history VALUES (36, '20240910', 'alter datum', 'SQL', 'V20240910__alter_datum.sql', 714729432, 'zhk', '2025-01-08 15:44:44.639653', 99, true);
INSERT INTO t_adf_history VALUES (37, '20241016', 'insert material', 'SQL', 'V20241016__insert_material.sql', -59513609, 'zhk', '2025-01-08 15:44:44.753281', 18, true);
INSERT INTO t_adf_history VALUES (38, '20241030.1', 'drop chartReport', 'SQL', 'V20241030_1__drop_chartReport.sql', -1763771554, 'zhk', '2025-01-08 15:44:44.785037', 27, true);
INSERT INTO t_adf_history VALUES (39, '20241030.2', 'create chartSnapshot', 'SQL', 'V20241030_2__create_chartSnapshot.sql', 191889434, 'zhk', '2025-01-08 15:44:44.84059', 47, true);
INSERT INTO t_adf_history VALUES (40, '20241107', 'alter chartSnapshot', 'SQL', 'V20241107__alter_chartSnapshot.sql', 1649820140, 'zhk', '2025-01-08 15:44:44.919381', 115, true);
INSERT INTO t_adf_history VALUES (41, '20241115', 'alter chart', 'SQL', 'V20241115__alter_chart.sql', -228835121, 'zhk', '2025-01-08 15:44:45.072158', 6, true);
INSERT INTO t_adf_history VALUES (42, '20241203', 'alter drawScheme', 'SQL', 'V20241203__alter_drawScheme.sql', 1355715329, 'zhk', '2025-01-08 15:44:45.094335', 7, true);
INSERT INTO t_adf_history VALUES (43, '20241217', 'alter frontScheme', 'SQL', 'V20241217__alter_frontScheme.sql', -753305463, 'zhk', '2025-01-08 15:44:45.182966', 9, true);
INSERT INTO t_adf_history VALUES (44, '20241224', 'create chartVersion', 'SQL', 'V20241224__create_chartVersion.sql', 952525346, 'zhk', '2025-01-08 15:44:45.234363', 85, true);
INSERT INTO t_adf_history VALUES (45, '20250107', 'alter chart', 'SQL', 'V20250107__alter_chart.sql', 1156232640, 'zhk', '2025-01-08 15:44:45.333053', 6, true);


--
-- Data for Name: t_webstore_history; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO t_webstore_history VALUES (1, '20231010', '<< Flyway Baseline >>', 'BASELINE', '<< Flyway Baseline >>', NULL, 'null', '2023-10-31 14:08:03.264713', 0, true);
INSERT INTO t_webstore_history VALUES (2, '20231103', 'create extractTemplate', 'SQL', 'V20231103__create_extractTemplate.sql', 460221761, 'zhk', '2024-03-12 09:24:00.015306', 39, true);
INSERT INTO t_webstore_history VALUES (3, '20240105', 'update exportTask', 'SQL', 'V20240105__update_exportTask.sql', 1410768370, 'zhk', '2024-03-12 09:24:00.144518', 9, true);
INSERT INTO t_webstore_history VALUES (4, '20240118.1', 'update exportTask', 'SQL', 'V20240118_1__update_exportTask.sql', 739918765, 'zhk', '2024-03-12 09:24:00.178618', 4, true);
INSERT INTO t_webstore_history VALUES (5, '20240118.2', 'update importTask', 'SQL', 'V20240118_2__update_importTask.sql', -1162983738, 'zhk', '2024-03-12 09:24:00.192493', 4, true);
INSERT INTO t_webstore_history VALUES (6, '20240415', 'alter inputSpatialData', 'SQL', 'V20240415__alter_inputSpatialData.sql', -406957578, 'zhk', '2024-07-08 12:06:00.479816', 40, true);
INSERT INTO t_webstore_history VALUES (7, '20240418', 'alter importSchema', 'SQL', 'V20240418__alter_importSchema.sql', -2021718628, 'zhk', '2024-07-08 12:06:00.58893', 56, true);
INSERT INTO t_webstore_history VALUES (8, '20240425', 'update importPlugin', 'SQL', 'V20240425__update_importPlugin.sql', -72002819, 'zhk', '2024-07-08 12:06:00.657596', 4, true);
INSERT INTO t_webstore_history VALUES (9, '20240902', 'update importPlugin', 'SQL', 'V20240902__update_importPlugin.sql', 566297917, 'zhk', '2025-01-08 15:44:45.68775', 6, true);
INSERT INTO t_webstore_history VALUES (10, '20241012', 'update importPlugin', 'SQL', 'V20241012__update_importPlugin.sql', -921875284, 'zhk', '2025-01-08 15:44:45.712589', 22, true);
INSERT INTO t_webstore_history VALUES (11, '20241107', 'create spatialTemporalStat', 'SQL', 'V20241107__create_spatialTemporalStat.sql', -1479854669, 'zhk', '2025-01-08 15:44:45.777359', 70, true);


--
-- Data for Name: tbchart_indicator; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbchart_scene; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbchart_scene_version; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbchart_snapshot; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbcm_attachment; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbcm_basemap; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO tbcm_basemap VALUES ('1', '影像', 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '-1', NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tbcm_basemap VALUES ('2', '矢量', 11, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '-1', 1, 2, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tbcm_basemap VALUES ('3', '晕渲', 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '-1', NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tbcm_basemap VALUES ('4', 'ime', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '-1', 1, 4, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tbcm_basemap VALUES ('5', 'cesium', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '-1', NULL, 5, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO tbcm_basemap VALUES ('6', 'skyline', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '-1', NULL, 6, NULL, NULL, NULL, NULL, NULL, NULL);


--
-- Data for Name: tbcm_catalogapp; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbcm_catalogappright; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbcm_catalogfavoritenode; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbcm_catalognodeapp; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbcm_catalognoderes; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbcm_color_item; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbcm_color_scheme; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbcm_draw_scheme; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbcm_extracttemplate; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbcm_frontscheme; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbcm_indexlayer; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbcm_mapscene; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbcm_mapviewscheme; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbcm_material; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO tbcm_material VALUES ('picture', '图片', '', NULL, NULL, '2023-09-26 19:10:45', NULL, NULL, NULL);
INSERT INTO tbcm_material VALUES ('icon', '图标', '', NULL, NULL, '2023-09-26 19:10:48', NULL, NULL, NULL);
INSERT INTO tbcm_material VALUES ('border', '边框', '', NULL, NULL, '2023-09-26 19:10:49', NULL, NULL, NULL);
INSERT INTO tbcm_material VALUES ('font', '字体', '', NULL, NULL, '2023-09-26 19:10:52', NULL, NULL, NULL);
INSERT INTO tbcm_material VALUES ('model3d', '小品', '', NULL, NULL, '2023-09-26 19:10:54', NULL, NULL, NULL);
INSERT INTO tbcm_material VALUES ('video', '视频', '', NULL, NULL, '2024-10-15 10:19:10', NULL, NULL, NULL);


--
-- Data for Name: tbcm_metadata; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbcm_metadatavalue; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbcm_metakeyword; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbcm_metatemplate; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbcm_metatemplatefield; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbdm_district; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbdm_districthot; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbdm_districtitem; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbdm_districtlevel; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbdm_domain; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO tbdm_domain VALUES (1, '数据生产年代', 15, 0, NULL, 'DIC_ProductDate');
INSERT INTO tbdm_domain VALUES (2, '数据格式', 14, 0, '123', 'DIC_DATAFORMAT');
INSERT INTO tbdm_domain VALUES (3, '入库数据类型', 22, 0, NULL, 'DIC_DATACLASSIFICATION');
INSERT INTO tbdm_domain VALUES (4, '分幅类型', 16, 0, NULL, 'DIC_MapFrameType');
INSERT INTO tbdm_domain VALUES (5, 'SRID', 8, 0, NULL, 'DIC_SRID');

--
-- Data for Name: tbdm_domainvalue; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO tbdm_domainvalue VALUES (1, '2006', '2006', NULL, -1, 0, 1, 0);
INSERT INTO tbdm_domainvalue VALUES (2, '2007', '2007', NULL, -1, 1, 1, 0);
INSERT INTO tbdm_domainvalue VALUES (3, '2008', '2008', NULL, -1, 2, 1, 0);
INSERT INTO tbdm_domainvalue VALUES (4, '2009', '2009', NULL, -1, 3, 1, 0);
INSERT INTO tbdm_domainvalue VALUES (5, '2010', '2010', NULL, -1, 4, 1, 0);
INSERT INTO tbdm_domainvalue VALUES (6, '2011', '2011', NULL, -1, 5, 1, 0);
INSERT INTO tbdm_domainvalue VALUES (7, '2012', '2012', NULL, -1, 6, 1, 0);
INSERT INTO tbdm_domainvalue VALUES (8, '2013', '2013', NULL, -1, 7, 1, 0);
INSERT INTO tbdm_domainvalue VALUES (9, '2014', '2014', NULL, -1, 8, 1, 0);
INSERT INTO tbdm_domainvalue VALUES (10, '2015', '2015', NULL, -1, 9, 1, 0);
INSERT INTO tbdm_domainvalue VALUES (11, '2016', '2016', NULL, -1, 10, 1, 0);
INSERT INTO tbdm_domainvalue VALUES (12, '2017', '2017', NULL, -1, 11, 1, 0);
INSERT INTO tbdm_domainvalue VALUES (13, '2018', '2018', NULL, -1, 12, 1, 0);
INSERT INTO tbdm_domainvalue VALUES (14, '2019', '2019', NULL, -1, 13, 1, 0);
INSERT INTO tbdm_domainvalue VALUES (15, '2020', '2020', NULL, -1, 14, 1, 0);
INSERT INTO tbdm_domainvalue VALUES (16, '2021', '2021', NULL, -1, 15, 1, 0);
INSERT INTO tbdm_domainvalue VALUES (17, '2022', '2022', NULL, -1, 16, 1, 0);
INSERT INTO tbdm_domainvalue VALUES (18, 'jpg', 'jpg', NULL, -1, 0, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (19, 'doc', 'doc', NULL, -1, 1, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (20, 'xml', 'xml', NULL, -1, 2, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (21, 'swf', 'swf', NULL, -1, 3, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (22, 'pdf', 'pdf', NULL, -1, 4, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (23, 'xls', 'Excel', NULL, -1, 5, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (24, 'aux', 'aux', NULL, -1, 6, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (25, 'rrd', 'rrd', NULL, -1, 7, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (26, 'img', 'img', NULL, -1, 8, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (27, 'tfw', 'tfw', NULL, -1, 9, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (28, 'dgn', 'dgn', NULL, -1, 10, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (29, 'dwg', 'dwg', NULL, -1, 11, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (30, 'gz', 'gz', NULL, -1, 12, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (31, 'dbf', 'dbf', NULL, -1, 13, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (32, 'prj', 'prj', NULL, -1, 14, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (33, 'sbn', 'sbn', NULL, -1, 15, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (34, 'sbx', 'sbx', NULL, -1, 16, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (35, 'shp', 'shp', NULL, -1, 17, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (36, 'shx', 'shx', NULL, -1, 18, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (37, 'jgw', 'jgw', NULL, -1, 19, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (38, 'txt', 'txt', NULL, -1, 20, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (39, 'dem', 'dem', NULL, -1, 21, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (40, 'mat', 'mat', NULL, -1, 22, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (41, 'GRID', 'GRID', NULL, -1, 23, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (42, 'TIF', 'TIF', NULL, -1, 24, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (43, 'Shapefile', 'Shapefile', NULL, -1, 25, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (44, 'Coverage', 'Coverage', NULL, -1, 26, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (45, 'CAD', 'CAD', NULL, -1, 27, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (46, 'MDB', 'MDB', NULL, -1, 28, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (47, 'DIM', 'dim', NULL, -1, 29, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (48, '*', '其他', NULL, -1, 30, 2, 0);
INSERT INTO tbdm_domainvalue VALUES (49, 'DLG', 'DLG', NULL, -1, 0, 3, 0);
INSERT INTO tbdm_domainvalue VALUES (50, 'DOM', 'DOM', NULL, -1, 1, 3, 0);
INSERT INTO tbdm_domainvalue VALUES (51, 'DEM', 'DEM', NULL, -1, 2, 3, 0);
INSERT INTO tbdm_domainvalue VALUES (52, '5000', '1:5000', NULL, -1, 0, 4, 0);
INSERT INTO tbdm_domainvalue VALUES (53, '10000', '1:10000', NULL, -1, 1, 4, 0);
INSERT INTO tbdm_domainvalue VALUES (54, '25000', '1:25000', NULL, -1, 2, 4, 0);
INSERT INTO tbdm_domainvalue VALUES (55, '50000', '1:50000', NULL, -1, 3, 4, 0);
INSERT INTO tbdm_domainvalue VALUES (56, '100000', '1:100000', NULL, -1, 4, 4, 0);
INSERT INTO tbdm_domainvalue VALUES (57, '250000', '1:250000', NULL, -1, 5, 4, 0);
INSERT INTO tbdm_domainvalue VALUES (58, '500000', '1:500000', NULL, -1, 6, 4, 0);
INSERT INTO tbdm_domainvalue VALUES (59, '1000000', '1:1000000', NULL, -1, 7, 4, 0);
INSERT INTO tbdm_domainvalue VALUES (60, '4326', 'WGS1984', NULL, -1, 0, 5, 0);
INSERT INTO tbdm_domainvalue VALUES (61, '4214', 'Beijing1954', NULL, -1, 1, 5, 0);
INSERT INTO tbdm_domainvalue VALUES (62, '4610', 'Xian1980', NULL, -1, 2, 5, 0);
INSERT INTO tbdm_domainvalue VALUES (63, '4490', 'CGCS2000', NULL, -1, 3, 5, 0);
INSERT INTO tbdm_domainvalue VALUES (64, '未知空间参考', '未知空间参考', NULL, -1, 4, 5, 0);


--
-- Data for Name: tbdm_filedata; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbdm_filemodel; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbdm_fileproperty; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO tbdm_fileproperty VALUES ('Snapshot', '快视图文件', 0, 1, 0);
INSERT INTO tbdm_fileproperty VALUES ('Metadata', '标准元数据文件', 0, 1, 0);
INSERT INTO tbdm_fileproperty VALUES ('MZTFile', '拇指图文件', 0, 1, 0);
INSERT INTO tbdm_fileproperty VALUES ('IndexFile', '索引文件', 0, 1, 0);
INSERT INTO tbdm_fileproperty VALUES ('CKMetaFile', '元数据文件', 0, 1, 0);
INSERT INTO tbdm_fileproperty VALUES ('RasterFile', '影像文件', 0, 0, 0);
INSERT INTO tbdm_fileproperty VALUES ('MainViewObject', '主浏览对象', 0, 1, 0);


--
-- Data for Name: tbdm_geotemplate; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbdm_thumb; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbds_backup; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbds_datasetmeta; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbds_datasetrelation; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbds_datastore; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbds_datum; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbds_datumfields; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbds_graphlabel; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbds_service; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbds_statistic; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbds_tile; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbexp_task; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbexp_taskdata; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbexp_tasklog; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbexp_taskunit; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbimp_datadatum; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbimp_dataraster; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbimp_datatile; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbimp_dataunit; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbimp_datavector; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbimp_log; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbimp_plugin; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO tbimp_plugin VALUES (-101, '矢量通用入库插件', '矢量', '矢量通用入库', '', 'com.geoway.webstore.input.plugin.vector.general.VectorGenaralImportPlugin', NULL);
INSERT INTO tbimp_plugin VALUES (-102, '栅格通用入库插件', '栅格', '栅格通用入库', '', 'com.geoway.webstore.input.plugin.raster.general.MosaicGeneralImportPlugin', NULL);
INSERT INTO tbimp_plugin VALUES (-103, '表格通用入库插件', '表格', '表格通用入库', NULL, 'com.geoway.webstore.input.plugin.table.TableGeneralImportPlugin', NULL);
INSERT INTO tbimp_plugin VALUES (-104, '文件通用入库插件', '文件', '文件通用入库', NULL, 'com.geoway.webstore.input.plugin.datum.standard.DatumStandardImportPlugin', NULL);
INSERT INTO tbimp_plugin VALUES (1003, '矢量空间型文件数据入库插件', '文件', '矢量空间型文件数据入库插件', NULL, 'com.geoway.webstore.input.plugin.datum.DatumStandardExtentPlugin', NULL);
INSERT INTO tbimp_plugin VALUES (-105, '瓦片通用入库插件', '瓦片', '瓦片通用入库', NULL, 'com.geoway.webstore.input.plugin.tile.TileGeneralImportPlugin', NULL);
INSERT INTO tbimp_plugin VALUES (1001, '矢量分幅数据入库插件', '矢量', '矢量分幅数据入库', NULL, 'com.geoway.webstore.input.plugin.vector.frame.VectorFrameImportPlugin', '<Plugin>
	<Design>
		<Param type="dropbox" multiple="false" text="数据类型" name="TargetDataTypeKey" hideName="TargetDataTypeName" value="String" required="true">
			<Datasource type="dictionary" param="DIC_DATACLASSIFICATION" attr="code">

			</Datasource>
		</Param>

		<Param type="dropbox" multiple="false" text="空间参考" name="SpatialRefTypeKey" hideName="SpatialRefTypeName" value="String" required="true">
			<Datasource type="dictionary" param="DIC_SRID" attr="code">

			</Datasource>
		</Param>

		<Param type="dropbox" multiple="false" text="分幅类型" name="TargetMapFrameKey" hideName="TargetMapFrameName" value="String" required="true">
			<Datasource type="dictionary" param="DIC_MapFrameType" attr="code">

			</Datasource>
		</Param>

		<Param type="dropbox" multiple="true" text="数据格式" name="InputVectorDataType" hideName="InputVectorDataTypeName" value="Array" required="true">
			<Datasource type="enum">
				<option value="0" text="PersonalGDB" />
				<option value="1" text="FileGDB" />
				<option value="2" text="ShapeFile" />
				<option value="3" text="GeoPackage" />
				<option value="4" text="S57" />
			</Datasource>
		</Param>

		<Param type="text"  text="名称格式" name="VectorNamePattern" value="String" required="false">

		</Param>

		<Param type="dropbox" multiple="false" text="目标数据库" name="TargetDatabaseKey" hideName="TargetDatabaseName" value="String" required="true">
			<Datasource type="database" param="">

			</Datasource>
		</Param>

		<Param type="dropbox" multiple="false" text="目标要素集" name="TargetFeatureDatasetID" value="Number" hideName="TargetFeatureDatasetName" required="true">
			<Datasource type="featuredataset" param="${TargetDatabaseKey}">

			</Datasource>
		</Param>

		<Param type="dropbox" multiple="false" text="目标元数据表" name="TargetMetaTableID" value="Number" hideName="TargetMetaTableName" required="false">
			<Datasource type="table" param="${TargetDatabaseKey}">

			</Datasource>
		</Param>

		<Param type="file" multiple="false" text="样例模板" name="DemoDataPath" value="String" required="true">
			<Datasource type="enum">
				<option value="2" text="GeoPackage" />
				<option value="3" text="FileGDB" />
				<option value="4" text="MDB" />
				<option value="5" text="ShapeFile" />
				<option value="13" text="S57" />
			</Datasource>
		</Param>

		<Param type="table_edit" hasCheck="false" text="对应关系" name="LayerRelationships" value="Array">
			<Datasource type="table" param="${DemoDataPath}" >
				<option value="SourceLayerName" text="源图层" edit="false" />
				<option value="TargetLayerName" text="目标图层" edit="true" />
			</Datasource>
		</Param>

	</Design>
	<Run>
		<Param type="dropbox" multiple="false" text="数据时相" name="Year" value="String">
			<Datasource type="dictionary" param="DIC_ProductDate" attr="code" required="true">

			</Datasource>
		</Param>
		<Param type="custom" text="数据名称" name="FrameNameSlice" value="String" hideName="FrameNameSliceHideName">
		</Param>
		<Param type="dropbox" multiple="false" text="入库策略" name="FrameImportStrategy" hideName="FrameImportStrategyHideName" value="String" required="true">
			<Datasource type="enum">
				<option value="OnlySpatialData" text="仅入空间数据" />
				<option value="OnlyMetadata" text="仅入元数据" />
				<option value="Both" text="空间数据与元数据同时入库" />
			</Datasource>
		</Param>
	</Run>
</Plugin>');
INSERT INTO tbimp_plugin VALUES (-106, '三维模型文件入库插件', '文件', '三维模型文件入库', NULL, 'com.geoway.webstore.input.plugin.datum.standard.DatumModel3DPlugin', NULL);
INSERT INTO tbimp_plugin VALUES (1002, '栅格分幅数据入库插件', '栅格', '栅格分幅数据入库', NULL, 'com.geoway.webstore.input.plugin.raster.frame.RasterFrameImportPlugin', '<Plugin>
	<Design>
		<Param type="dropbox" multiple="false" text="数据类型" name="TargetDataTypeKey" hideName="TargetDataTypeName" value="String" required="true">
			<Datasource type="dictionary" param="DIC_DATACLASSIFICATION" attr="code">

			</Datasource>
		</Param>

		<Param type="dropbox" multiple="false" text="空间参考" name="SpatialRefTypeKey" hideName="SpatialRefTypeName" value="String" required="true">
			<Datasource type="dictionary" param="DIC_SRID" attr="code">

			</Datasource>
		</Param>

		<Param type="dropbox" multiple="false" text="分幅类型" name="TargetMapFrameKey" hideName="TargetMapFrameName" value="String" required="true">
			<Datasource type="dictionary" param="DIC_MapFrameType" attr="code">

			</Datasource>
		</Param>




		<Param type="dropbox" multiple="true" text="数据格式" name="InputRasterDataType" hideName="InputVectorDataTypeName" value="Array" required="true">
			<Datasource type="enum">
				<option value="1" text="GeoTiff" />
				<option value="2" text="GRID" />
				<option value="3" text="Image" />
			</Datasource>
		</Param>


		<Param type="text"  text="名称格式" name="RasterNamePattern" value="String">

		</Param>

		<Param type="dropbox" multiple="false" text="目标数据库" name="TargetDatabaseKey" hideName="TargetDatabaseName" value="String" required="true">
			<Datasource type="database" param="">

			</Datasource>
		</Param>

		<Param type="dropbox" multiple="false" text="目标数据集" name="TargetDatasetID" value="Number" hideName="TargetDatasetName" required="true">
			<Datasource type="mosaicdataset" param="${TargetDatabaseKey}">

			</Datasource>
		</Param>

		<Param type="dropbox" multiple="false" text="目标元数据表" name="TargetMetaTableID" value="Number" hideName="TargetMetaTableName" required="false">
			<Datasource type="table" param="${TargetDatabaseKey}">

			</Datasource>
		</Param>
	</Design>
	<Run>
		<Param type="datePicker" text="数据时相" name="Year" value="Date" needSecond="false" required="true">

		</Param>
		<Param type="dropbox" multiple="false" text="入库策略" name="FrameImportStrategy" hideName="FrameImportStrategyHideName" value="String">
			<Datasource type="enum">
				<option value="OnlySpatialData" text="仅入空间数据" />
				<option value="OnlyMetadata" text="仅入元数据" />
				<option value="Both" text="空间数据与元数据同时入库" />
			</Datasource>
		</Param>
	</Run>
</Plugin>');
INSERT INTO tbimp_plugin VALUES (-107, '坐标数据空间化导入', '矢量', '坐标数据空间化导入', NULL, 'com.geoway.webstore.input.plugin.spatialization.DataSpatializationImportPlugin', '<Plugin>
	<Run>
		<Param type="file" multiple="false" text="坐标文件位置" name="inputFile" value="String" required="true">
			<Datasource type="enum">
				<option value="40" text="表格" />
				<option value="41" text="文本文件" />
				<option value="43" text="ExcelSheet" />
				<option value="44" text="Csv" />
			</Datasource>
		</Param>
		<Param type="dropbox" multiple="false" text="要素类型" name="featureType" value="String" required="true">
			<Datasource type="enum">
				<option value="Point" text="点" />
				<option value="Polyline" text="线" />
				<option value="Polygon" text="面" />
			</Datasource>
		</Param>
		<Param type="dropbox" multiple="false" text="范围字段" name="geometryField" value="String" required="false">
			<Datasource type="vectorLayerInfo" param="${inputFile}" attr="code" required="true">

			</Datasource>
		</Param>
		<Param type="dropbox" multiple="false" text="X坐标字段" name="xField" value="String" required="false">
			<Datasource type="vectorLayerInfo" param="${inputFile}" attr="code" required="true">

			</Datasource>
		</Param>
		<Param type="dropbox" multiple="false" text="Y坐标字段" name="yField" value="String" required="false">
			<Datasource type="vectorLayerInfo" param="${inputFile}" attr="code" required="true">

			</Datasource>
		</Param>
		<Param type="dropbox" multiple="false" text="目标数据空间参考" name="targetSrid" value="String" required="true">
			<Datasource type="dictionary" param="DIC_SRID" attr="code" required="true">

			</Datasource>
		</Param>
		<Param type="dropbox" multiple="false" text="目标数据库" name="targetDatabaseKey" hideName="targetDatabaseName" value="String" required="true">
			<Datasource type="database" param="">

			</Datasource>
		</Param>
		<Param type="text"  text="目标图层名称" name="targetLayerName" value="String" required="true">

		</Param>
	</Run>
	<Source>
		<Param name="path" display="false" />
	</Source>
</Plugin>');


--
-- Data for Name: tbimp_schema; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO tbimp_schema VALUES (-101, '矢量数据导入', NULL, -101, NULL, '数据导入', NULL, NULL);
INSERT INTO tbimp_schema VALUES (-102, '栅格数据导入', NULL, -102, NULL, '数据导入', NULL, NULL);
INSERT INTO tbimp_schema VALUES (-103, '表格数据导入', NULL, -103, NULL, '数据导入', NULL, NULL);
INSERT INTO tbimp_schema VALUES (-104, '文件数据导入', NULL, -104, NULL, '数据导入', NULL, NULL);
INSERT INTO tbimp_schema VALUES (-105, '瓦片数据导入', NULL, -105, NULL, '数据导入', NULL, NULL);
INSERT INTO tbimp_schema VALUES (-106, '三维模型数据导入', NULL, -106, NULL, '数据导入', NULL, NULL);
INSERT INTO tbimp_schema VALUES (-107, '坐标数据空间化导入', NULL, -107, NULL, '数据导入', NULL, NULL);


--
-- Data for Name: tbimp_task; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbimp_taskdata; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbimp_taskdataunit; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbinput_spatialdata; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbsys_log; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO tbsys_log VALUES (1, '2025-01-08 15:46:46.458', 10, 'admin', '[admin]用户登录', '172.16.66.151', 'Windows 10 or Windows Server 2016', 'Chrome 128.0.0.0', 'Windows');


--
-- Data for Name: tbsys_logevent; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO tbsys_logevent VALUES (100, '空间数据库');
INSERT INTO tbsys_logevent VALUES (101, '空间数据集');
INSERT INTO tbsys_logevent VALUES (110, '文件数据库');
INSERT INTO tbsys_logevent VALUES (111, '文件数据集');
INSERT INTO tbsys_logevent VALUES (120, '瓦片数据库');
INSERT INTO tbsys_logevent VALUES (121, '瓦片数据集');
INSERT INTO tbsys_logevent VALUES (130, '图数据库');
INSERT INTO tbsys_logevent VALUES (140, '空间服务引擎');
INSERT INTO tbsys_logevent VALUES (141, '空间服务');
INSERT INTO tbsys_logevent VALUES (150, '文件存储');
INSERT INTO tbsys_logevent VALUES (1, '系统操作日志');
INSERT INTO tbsys_logevent VALUES (160, '大数据资源池');
INSERT INTO tbsys_logevent VALUES (161, '大数据资源池数据集');
INSERT INTO tbsys_logevent VALUES (170, '模型数据库');
INSERT INTO tbsys_logevent VALUES (171, '模型数据集');
INSERT INTO tbsys_logevent VALUES (201, '数据指标');
INSERT INTO tbsys_logevent VALUES (202, '应用场景');


--
-- Data for Name: tbsys_sysparam; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO tbsys_sysparam VALUES (1, '默认分组', '', NULL, NULL, NULL, '', 1);
INSERT INTO tbsys_sysparam VALUES (2, '更新类型', 'DIC_UpdateType', NULL, '', NULL, '', 1);
INSERT INTO tbsys_sysparam VALUES (3, NULL, '0', '\xe69caae69bb4e696b0', '', 2, '', 0);
INSERT INTO tbsys_sysparam VALUES (4, NULL, '2', '\xe5b19ee680a7e4bfaee694b9', '', 2, '', 0);
INSERT INTO tbsys_sysparam VALUES (5, NULL, '1', '\xe59bbee5bda2e4bfaee694b9', '', 2, '', 0);
INSERT INTO tbsys_sysparam VALUES (6, NULL, '3', '\xe59bbee5b19ee4bfaee694b9', '', 2, '', 0);
INSERT INTO tbsys_sysparam VALUES (7, NULL, '4', '\xe5a29ee58aa0', '', 2, '', 0);
INSERT INTO tbsys_sysparam VALUES (8, NULL, '5', '\xe588a0e999a4', '', 2, '', 0);
INSERT INTO tbsys_sysparam VALUES (9, '数据更新字段映射', 'DIC_UpdateFieldMap', NULL, '', NULL, '', 1);
INSERT INTO tbsys_sysparam VALUES (10, NULL, 'f_updatetype', '\xe69bb4e696b0e7b1bbe59e8b', '', 9, '', 0);
INSERT INTO tbsys_sysparam VALUES (11, NULL, 'f_updatetime', '\xe69bb4e696b0e697b6e997b4', '', 9, '', 0);
INSERT INTO tbsys_sysparam VALUES (12, NULL, 'f_guid', '\x465f47554944', '', 9, '', 0);
INSERT INTO tbsys_sysparam VALUES (13, '地图应用服务', 'MapService', NULL, '', NULL, '', 1);
INSERT INTO tbsys_sysparam VALUES (14, NULL, 'slope', '\x687474703a2f2f696e74656e616c2e67656f7761792d61746c61732e636f6d3a33313238302f696d652d636c6f75642f726573742f64656d33305f315f31352f7465727261696e2f616e616c7973743f6d6f64653d616c6c', '', 13, '', 0);
INSERT INTO tbsys_sysparam VALUES (15, NULL, 'volume', '\x687474703a2f2f696e74656e616c2e67656f7761792d61746c61732e636f6d3a33313238302f696d652d636c6f75642f726573742f64656d33305f315f31352f7465727261696e2f6561727468776f726b', '', 13, '', 0);
INSERT INTO tbsys_sysparam VALUES (16, NULL, 'water_surface', '\x687474703a2f2f696e74656e616c2e67656f7761792d61746c61732e636f6d3a33313038302f696d652d636c6f75642f726573742f776d74735f7379682f776d7473', '', 13, '', 0);
INSERT INTO tbsys_sysparam VALUES (17, NULL, 'poi', '\x687474703a2f2f696e74656e616c2e67656f7761792d61746c61732e636f6d3a33313238302f696d652d636c6f75642f726573742f504f495f67642f706c616365', '', 13, '', 0);


--
-- Data for Name: tbupdate_caseinfo; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbupdate_layerupdateinfo; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbupdate_layerversionkeyinfo; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbupdate_layerversionlist; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbupdate_statconfig; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbupdate_statresult; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbupdate_task; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Data for Name: tbupdate_tasklog; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- Name: tbchart_snapshot_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbchart_snapshot_f_id_seq', 1, false);


--
-- Name: tbcm_mapviewscheme_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbcm_mapviewscheme_f_id_seq', 10000, false);


--
-- Name: tbcm_metadata_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbcm_metadata_f_id_seq', 1, false);


--
-- Name: tbcm_metatemplate_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbcm_metatemplate_f_id_seq', 1, false);


--
-- Name: tbcm_metatemplatefield_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbcm_metatemplatefield_f_id_seq', 1, false);


--
-- Name: tbdm_district_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbdm_district_f_id_seq', 10000, false);


--
-- Name: tbdm_districthot_objectid_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbdm_districthot_objectid_seq', 1, false);


--
-- Name: tbdm_districtitem_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbdm_districtitem_f_id_seq', 10000, false);


--
-- Name: tbdm_domain_f_dicno_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbdm_domain_f_dicno_seq', 10000, true);


--
-- Name: tbdm_domainvalue_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbdm_domainvalue_f_id_seq', 10000, true);


--
-- Name: tbdm_filedata_f_dataid_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbdm_filedata_f_dataid_seq', 10000, false);


--
-- Name: tbdm_filemodel_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbdm_filemodel_f_id_seq', 10000, false);


--
-- Name: tbds_datumfields_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbds_datumfields_f_id_seq', 10000, false);


--
-- Name: tbexp_task_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbexp_task_f_id_seq', 10000, false);


--
-- Name: tbexp_taskdata_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbexp_taskdata_f_id_seq', 10000, false);


--
-- Name: tbexp_tasklog_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbexp_tasklog_f_id_seq', 1, false);


--
-- Name: tbexp_taskunit_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbexp_taskunit_f_id_seq', 10000, false);


--
-- Name: tbimp_plugin_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbimp_plugin_f_id_seq', 10000, false);


--
-- Name: tbimp_schema_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbimp_schema_f_id_seq', 10000, false);


--
-- Name: tbimp_task_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbimp_task_f_id_seq', 10000, false);


--
-- Name: tbimp_taskdata_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbimp_taskdata_f_id_seq', 10000, false);


--
-- Name: tbimp_taskdataunit_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbimp_taskdataunit_f_id_seq', 10000, false);


--
-- Name: tbinput_spatialdata_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbinput_spatialdata_f_id_seq', 10000, false);


--
-- Name: tbsys_indexlayer_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbsys_indexlayer_f_id_seq', 10000, false);


--
-- Name: tbsys_log_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbsys_log_f_id_seq', 33, true);


--
-- Name: tbsys_sysparam_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbsys_sysparam_f_id_seq', 17, true);


--
-- Name: tbupdate_caseinfo_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbupdate_caseinfo_f_id_seq', 10000, false);


--
-- Name: tbupdate_layerupdateinfo_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbupdate_layerupdateinfo_f_id_seq', 10000, false);


--
-- Name: tbupdate_layerversionkeyinfo_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbupdate_layerversionkeyinfo_f_id_seq', 10000, false);


--
-- Name: tbupdate_layerversionlist_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbupdate_layerversionlist_f_id_seq', 10000, false);


--
-- Name: tbupdate_task_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbupdate_task_f_id_seq', 10000, false);


--
-- Name: tbupdate_tasklog_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('tbupdate_tasklog_f_id_seq', 1, false);


--
-- Name: tbupdate_layerversionkeyinfo TBUPDATE_LAYERVERSIONKEYINFO_Key; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbupdate_layerversionkeyinfo
    ADD CONSTRAINT "TBUPDATE_LAYERVERSIONKEYINFO_Key" PRIMARY KEY (f_id);


--
-- Name: tbupdate_task f_updatetaskname_unique; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbupdate_task
    ADD CONSTRAINT f_updatetaskname_unique UNIQUE (f_name);


--
-- Name: gw_class_metadata gw_class_metadata_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY gw_class_metadata
    ADD CONSTRAINT gw_class_metadata_pkey PRIMARY KEY (class_name);


--
-- Name: gw_geom_metadata gw_geom_metadata_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY gw_geom_metadata
    ADD CONSTRAINT gw_geom_metadata_pkey PRIMARY KEY (class_name);


--
-- Name: gw_spatial_ref_metadata gw_spatial_ref_metadata_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY gw_spatial_ref_metadata
    ADD CONSTRAINT gw_spatial_ref_metadata_pkey PRIMARY KEY (class_name);


--
-- Name: t_adf_history t_adf_history_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY t_adf_history
    ADD CONSTRAINT t_adf_history_pk PRIMARY KEY (installed_rank);


--
-- Name: t_webstore_history t_webstore_history_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY t_webstore_history
    ADD CONSTRAINT t_webstore_history_pk PRIMARY KEY (installed_rank);


--
-- Name: tbchart_indicator tbchart_indicator_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbchart_indicator
    ADD CONSTRAINT tbchart_indicator_pkey PRIMARY KEY (f_id);


--
-- Name: tbchart_scene tbchart_scene_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbchart_scene
    ADD CONSTRAINT tbchart_scene_pkey PRIMARY KEY (f_id);


--
-- Name: tbchart_scene_version tbchart_scene_version_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbchart_scene_version
    ADD CONSTRAINT tbchart_scene_version_pk PRIMARY KEY (f_id);


--
-- Name: tbchart_snapshot tbchart_snapshot_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbchart_snapshot
    ADD CONSTRAINT tbchart_snapshot_pk PRIMARY KEY (f_id);


--
-- Name: tbcm_attachment tbcm_attachment_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_attachment
    ADD CONSTRAINT tbcm_attachment_pkey PRIMARY KEY (f_id);


--
-- Name: tbcm_basemap tbcm_basemap_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_basemap
    ADD CONSTRAINT tbcm_basemap_pk PRIMARY KEY (f_id);


--
-- Name: tbcm_catalogapp tbcm_catalogapp_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_catalogapp
    ADD CONSTRAINT tbcm_catalogapp_pkey PRIMARY KEY (f_id);


--
-- Name: tbcm_catalogappright tbcm_catalogappright_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_catalogappright
    ADD CONSTRAINT tbcm_catalogappright_pkey PRIMARY KEY (f_id);


--
-- Name: tbdm_filedata tbcm_catalogdata_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbdm_filedata
    ADD CONSTRAINT tbcm_catalogdata_pkey PRIMARY KEY (f_dataid);


--
-- Name: tbcm_catalognodeapp tbcm_catalognodeapp_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_catalognodeapp
    ADD CONSTRAINT tbcm_catalognodeapp_pkey PRIMARY KEY (f_id);


--
-- Name: tbcm_catalognoderes tbcm_catalognoderes_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_catalognoderes
    ADD CONSTRAINT tbcm_catalognoderes_pkey PRIMARY KEY (f_id);


--
-- Name: tbcm_color_item tbcm_color_item_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_color_item
    ADD CONSTRAINT tbcm_color_item_pk PRIMARY KEY (f_id);


--
-- Name: tbcm_color_scheme tbcm_color_scheme_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_color_scheme
    ADD CONSTRAINT tbcm_color_scheme_pk PRIMARY KEY (f_id);


--
-- Name: tbdm_filemodel tbcm_datamodel_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbdm_filemodel
    ADD CONSTRAINT tbcm_datamodel_pkey PRIMARY KEY (f_id);


--
-- Name: tbcm_draw_scheme tbcm_draw_scheme_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_draw_scheme
    ADD CONSTRAINT tbcm_draw_scheme_pkey PRIMARY KEY (f_id);


--
-- Name: tbcm_extracttemplate tbcm_extracttemplate_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_extracttemplate
    ADD CONSTRAINT tbcm_extracttemplate_pkey PRIMARY KEY (f_id);


--
-- Name: tbcm_frontscheme tbcm_frontscheme_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_frontscheme
    ADD CONSTRAINT tbcm_frontscheme_pk PRIMARY KEY (f_key);


--
-- Name: tbcm_mapscene tbcm_mapscene_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_mapscene
    ADD CONSTRAINT tbcm_mapscene_pkey PRIMARY KEY (f_id);


--
-- Name: tbcm_mapviewscheme tbcm_mapviewscheme_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_mapviewscheme
    ADD CONSTRAINT tbcm_mapviewscheme_pkey PRIMARY KEY (f_id);


--
-- Name: tbcm_material tbcm_material_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_material
    ADD CONSTRAINT tbcm_material_pkey PRIMARY KEY (f_id);


--
-- Name: tbcm_metadata tbcm_metadata_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_metadata
    ADD CONSTRAINT tbcm_metadata_pkey PRIMARY KEY (f_id);


--
-- Name: tbcm_metakeyword tbcm_metakeyword_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_metakeyword
    ADD CONSTRAINT tbcm_metakeyword_pkey PRIMARY KEY (f_key);


--
-- Name: tbcm_metatemplate tbcm_metatemplate_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_metatemplate
    ADD CONSTRAINT tbcm_metatemplate_pkey PRIMARY KEY (f_id);


--
-- Name: tbcm_metatemplatefield tbcm_metatemplatefield_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_metatemplatefield
    ADD CONSTRAINT tbcm_metatemplatefield_pkey PRIMARY KEY (f_id);


--
-- Name: tbdm_fileproperty tbcm_objectproperty_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbdm_fileproperty
    ADD CONSTRAINT tbcm_objectproperty_pkey PRIMARY KEY (f_key);


--
-- Name: tbdm_district tbdm_district_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbdm_district
    ADD CONSTRAINT tbdm_district_pkey PRIMARY KEY (f_id);


--
-- Name: tbdm_districthot tbdm_districthot_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbdm_districthot
    ADD CONSTRAINT tbdm_districthot_pkey PRIMARY KEY (objectid);


--
-- Name: tbdm_districtitem tbdm_districtitem_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbdm_districtitem
    ADD CONSTRAINT tbdm_districtitem_pkey PRIMARY KEY (f_id);


--
-- Name: tbdm_districtlevel tbdm_districtlevel_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbdm_districtlevel
    ADD CONSTRAINT tbdm_districtlevel_pkey PRIMARY KEY (f_districtid, f_index);


--
-- Name: tbdm_domain tbdm_domain_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbdm_domain
    ADD CONSTRAINT tbdm_domain_pkey PRIMARY KEY (f_dicno);


--
-- Name: tbdm_domainvalue tbdm_domainvalue_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbdm_domainvalue
    ADD CONSTRAINT tbdm_domainvalue_pkey PRIMARY KEY (f_id);


--
-- Name: tbds_datumfields tbdm_fields_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbds_datumfields
    ADD CONSTRAINT tbdm_fields_pkey PRIMARY KEY (f_id);


--
-- Name: tbdm_geotemplate tbdm_geotemplate_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbdm_geotemplate
    ADD CONSTRAINT tbdm_geotemplate_pkey PRIMARY KEY (f_id);


--
-- Name: tbdm_thumb tbdm_thumb_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbdm_thumb
    ADD CONSTRAINT tbdm_thumb_pk PRIMARY KEY (f_id);


--
-- Name: tbds_datastore tbds_databases_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbds_datastore
    ADD CONSTRAINT tbds_databases_pkey PRIMARY KEY (f_key);


--
-- Name: tbds_datasetmeta tbds_datasetinfo_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbds_datasetmeta
    ADD CONSTRAINT tbds_datasetinfo_pkey PRIMARY KEY (f_id);


--
-- Name: tbds_datum tbds_datum_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbds_datum
    ADD CONSTRAINT tbds_datum_pkey PRIMARY KEY (f_dsid);


--
-- Name: tbds_graphlabel tbds_graphlabel_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbds_graphlabel
    ADD CONSTRAINT tbds_graphlabel_pkey PRIMARY KEY (f_id);


--
-- Name: tbds_service tbds_service_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbds_service
    ADD CONSTRAINT tbds_service_pkey PRIMARY KEY (f_id);


--
-- Name: tbds_statistic tbds_statistic_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbds_statistic
    ADD CONSTRAINT tbds_statistic_pkey PRIMARY KEY (f_id);


--
-- Name: tbds_tile tbds_tile_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbds_tile
    ADD CONSTRAINT tbds_tile_pkey PRIMARY KEY (f_id);


--
-- Name: tbexp_task tbexp_task_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbexp_task
    ADD CONSTRAINT tbexp_task_pkey PRIMARY KEY (f_id);


--
-- Name: tbexp_taskdata tbexp_taskdata_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbexp_taskdata
    ADD CONSTRAINT tbexp_taskdata_pkey PRIMARY KEY (f_id);


--
-- Name: tbexp_tasklog tbexp_tasklog_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbexp_tasklog
    ADD CONSTRAINT tbexp_tasklog_pkey PRIMARY KEY (f_id);


--
-- Name: tbexp_taskunit tbexp_taskunit_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbexp_taskunit
    ADD CONSTRAINT tbexp_taskunit_pkey PRIMARY KEY (f_id);


--
-- Name: tbimp_datadatum tbimp_datadatum_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_datadatum
    ADD CONSTRAINT tbimp_datadatum_pkey PRIMARY KEY (f_id);


--
-- Name: tbimp_dataraster tbimp_dataraster_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_dataraster
    ADD CONSTRAINT tbimp_dataraster_pkey PRIMARY KEY (f_id);


--
-- Name: tbimp_datatile tbimp_datatile_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_datatile
    ADD CONSTRAINT tbimp_datatile_pk PRIMARY KEY (f_id);


--
-- Name: tbimp_dataunit tbimp_dataunit_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_dataunit
    ADD CONSTRAINT tbimp_dataunit_pkey PRIMARY KEY (f_id);


--
-- Name: tbimp_datavector tbimp_datavector_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_datavector
    ADD CONSTRAINT tbimp_datavector_pkey PRIMARY KEY (f_id);


--
-- Name: tbimp_plugin tbimp_plugin_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_plugin
    ADD CONSTRAINT tbimp_plugin_pkey PRIMARY KEY (f_id);


--
-- Name: tbimp_schema tbimp_schema_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_schema
    ADD CONSTRAINT tbimp_schema_pkey PRIMARY KEY (f_id);


--
-- Name: tbimp_task tbimp_task_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_task
    ADD CONSTRAINT tbimp_task_pkey PRIMARY KEY (f_id);


--
-- Name: tbimp_taskdata tbimp_taskdata_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_taskdata
    ADD CONSTRAINT tbimp_taskdata_pkey PRIMARY KEY (f_id);


--
-- Name: tbimp_taskdataunit tbimp_taskdataunit_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_taskdataunit
    ADD CONSTRAINT tbimp_taskdataunit_pkey PRIMARY KEY (f_id);


--
-- Name: tbinput_spatialdata tbinput_spatialdata_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbinput_spatialdata
    ADD CONSTRAINT tbinput_spatialdata_pkey PRIMARY KEY (f_id);


--
-- Name: tbcm_indexlayer tbsys_indexlayer_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbcm_indexlayer
    ADD CONSTRAINT tbsys_indexlayer_pkey PRIMARY KEY (f_id);


--
-- Name: tbsys_log tbsys_log_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbsys_log
    ADD CONSTRAINT tbsys_log_pkey PRIMARY KEY (f_id);


--
-- Name: tbsys_logevent tbsys_logevent_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbsys_logevent
    ADD CONSTRAINT tbsys_logevent_pkey PRIMARY KEY (f_eventid);


--
-- Name: tbsys_sysparam tbsys_sysparam_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbsys_sysparam
    ADD CONSTRAINT tbsys_sysparam_pk PRIMARY KEY (f_id);


--
-- Name: tbupdate_caseinfo tbupdate_caseinfo_key; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbupdate_caseinfo
    ADD CONSTRAINT tbupdate_caseinfo_key PRIMARY KEY (f_id);


--
-- Name: tbupdate_layerupdateinfo tbupdate_layerupdateinfo_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbupdate_layerupdateinfo
    ADD CONSTRAINT tbupdate_layerupdateinfo_pkey PRIMARY KEY (f_id);


--
-- Name: tbupdate_layerversionkeyinfo tbupdate_layerversionkeyinfo_key1; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbupdate_layerversionkeyinfo
    ADD CONSTRAINT tbupdate_layerversionkeyinfo_key1 UNIQUE (f_datasetid);


--
-- Name: tbupdate_layerversionlist tbupdate_layerversionlist_key; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbupdate_layerversionlist
    ADD CONSTRAINT tbupdate_layerversionlist_key PRIMARY KEY (f_id);


--
-- Name: tbupdate_statconfig tbupdate_statconfig_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbupdate_statconfig
    ADD CONSTRAINT tbupdate_statconfig_pk PRIMARY KEY (f_id);


--
-- Name: tbupdate_task tbupdate_task_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbupdate_task
    ADD CONSTRAINT tbupdate_task_pkey PRIMARY KEY (f_id);


--
-- Name: tbupdate_tasklog tbupdate_tasklog_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbupdate_tasklog
    ADD CONSTRAINT tbupdate_tasklog_pkey PRIMARY KEY (f_id);


--
-- Name: pk_tbcm_fileproperty; Type: INDEX; Schema: public; Owner: -
--

CREATE UNIQUE INDEX pk_tbcm_fileproperty ON tbdm_fileproperty USING btree (f_key);


--
-- Name: pk_tbdm_districtleve; Type: INDEX; Schema: public; Owner: -
--

CREATE UNIQUE INDEX pk_tbdm_districtleve ON tbdm_districtlevel USING btree (f_districtid, f_index);


--
-- Name: sidx_tbdm_districthot; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX sidx_tbdm_districthot ON tbdm_districthot USING gist (shape);


--
-- Name: t_adf_history_s_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX t_adf_history_s_idx ON t_adf_history USING btree (success);


--
-- Name: t_webstore_history_s_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX t_webstore_history_s_idx ON t_webstore_history USING btree (success);


--
-- Name: tbchart_snapshot_f_key_index; Type: INDEX; Schema: public; Owner: -
--

CREATE UNIQUE INDEX tbchart_snapshot_f_key_index ON tbchart_snapshot USING btree (f_sceneid, f_snapshotkey);


--
-- Name: tbcm_attachment_owner_index; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX tbcm_attachment_owner_index ON tbcm_attachment USING btree (f_relatedtype, f_relatedid);


--
-- Name: tbcm_attachment_ownertype_index; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX tbcm_attachment_ownertype_index ON tbcm_attachment USING btree (f_relatedtype);


--
-- Name: tbdm_districtitem_code_index; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX tbdm_districtitem_code_index ON tbdm_districtitem USING btree (f_districtid, f_code);


--
-- Name: tbds_datasetrelation_f_sourceid_index; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX tbds_datasetrelation_f_sourceid_index ON tbds_datasetrelation USING btree (f_sourceid);


--
-- Name: tbds_datasetrelation_f_targetid_index; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX tbds_datasetrelation_f_targetid_index ON tbds_datasetrelation USING btree (f_targetid);


--
-- Name: tbchart_snapshot tbchart_snapshot_tbchart_scene_f_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbchart_snapshot
    ADD CONSTRAINT tbchart_snapshot_tbchart_scene_f_id_fk FOREIGN KEY (f_sceneid) REFERENCES tbchart_scene(f_id) ON DELETE CASCADE;


--
-- Name: tbimp_datadatum tbimp_datadatum_fk; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_datadatum
    ADD CONSTRAINT tbimp_datadatum_fk FOREIGN KEY (f_taskid) REFERENCES tbimp_task(f_id) ON DELETE CASCADE;


--
-- Name: tbimp_dataraster tbimp_dataraster_fk; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_dataraster
    ADD CONSTRAINT tbimp_dataraster_fk FOREIGN KEY (f_taskid) REFERENCES tbimp_task(f_id) ON DELETE CASCADE;


--
-- Name: tbimp_datatile tbimp_datatile_fk; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_datatile
    ADD CONSTRAINT tbimp_datatile_fk FOREIGN KEY (f_taskid) REFERENCES tbimp_task(f_id) ON DELETE CASCADE;


--
-- Name: tbimp_dataunit tbimp_dataunit_fk; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_dataunit
    ADD CONSTRAINT tbimp_dataunit_fk FOREIGN KEY (f_taskid) REFERENCES tbimp_task(f_id) ON DELETE CASCADE;


--
-- Name: tbimp_datavector tbimp_datavector_fk; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_datavector
    ADD CONSTRAINT tbimp_datavector_fk FOREIGN KEY (f_taskid) REFERENCES tbimp_task(f_id) ON DELETE CASCADE;


--
-- Name: tbimp_log tbimp_log_fk; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_log
    ADD CONSTRAINT tbimp_log_fk FOREIGN KEY (f_taskid) REFERENCES tbimp_task(f_id) ON DELETE CASCADE;


--
-- Name: tbimp_taskdata tbimp_taskdata_fk; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_taskdata
    ADD CONSTRAINT tbimp_taskdata_fk FOREIGN KEY (f_taskid) REFERENCES tbimp_task(f_id) ON DELETE CASCADE;


--
-- Name: tbimp_taskdataunit tbimp_taskdataunit_fk; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY tbimp_taskdataunit
    ADD CONSTRAINT tbimp_taskdataunit_fk FOREIGN KEY (f_taskid) REFERENCES tbimp_task(f_id) ON DELETE CASCADE;

-- fxjc_gw_indicator_dictionary_id_seq definition

-- DROP SEQUENCE fxjc_gw_indicator_dictionary_id_seq;

CREATE SEQUENCE fxjc_gw_indicator_dictionary_id_seq
	INCREMENT BY 1
	MINVALUE 1
	MAXVALUE 9223372036854775807
	START 1
	CACHE 1
	NO CYCLE;

-- tb_doc_report definition

-- Drop table

-- DROP TABLE tb_doc_report;

CREATE TABLE tb_doc_report (
	f_id varchar(64) NOT NULL,
	f_name varchar(255) NULL,
	f_pid varchar(64) NULL,
	f_type int2 NULL,
	f_serverid int2 NULL,
	f_level int2 NULL,
	f_sort int2 NULL,
	f_path varchar(255) NULL,
	f_minpath varchar(255) NULL,
	f_filetype varchar(16) NULL,
	f_filesize varchar(128) NULL,
	f_createtime timestamp(6) NULL,
	f_desc text NULL,
	f_json text NULL,
	f_year varchar(32) NULL,
	f_regioncode varchar(32) NULL,
	f_owner varchar(255) NULL,
	f_thumail bytea NULL,
	CONSTRAINT tb_doc_report_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_doc_report.f_name IS '文档名称';
COMMENT ON COLUMN tb_doc_report.f_type IS '类型0：目录 1.文档项';
COMMENT ON COLUMN tb_doc_report.f_serverid IS '服务器Id';
COMMENT ON COLUMN tb_doc_report.f_level IS '级别';
COMMENT ON COLUMN tb_doc_report.f_path IS '存储路径';
COMMENT ON COLUMN tb_doc_report.f_minpath IS '缩略图路径';
COMMENT ON COLUMN tb_doc_report.f_filesize IS '文件大小';
COMMENT ON COLUMN tb_doc_report.f_year IS '年份信息';
COMMENT ON COLUMN tb_doc_report.f_regioncode IS '行政区代码';
COMMENT ON COLUMN tb_doc_report.f_owner IS '上传人';
COMMENT ON COLUMN tb_doc_report.f_thumail IS '缩略图';


-- tb_fxjc_indicator definition

-- Drop table

-- DROP TABLE tb_fxjc_indicator;

CREATE TABLE tb_fxjc_indicator (
	"name" varchar(50) NULL,
	code varchar(20) NOT NULL,
	unit varchar(10) NULL,
	property varchar(10) NULL,
	product_period varchar(10) NULL,
	busi_type varchar(2) NULL,
	busi_define varchar(500) NULL,
	remark varchar(500) NULL,
	in_use bool NULL,
	create_time timestamptz(6) NULL,
	creator varchar(20) NULL,
	creator_id varchar(50) NULL,
	source_type varchar(2) NULL DEFAULT 1,
	department varchar(36) NULL,
	direction varchar(2) NULL,
	value_type varchar(10) NULL,
	dict_options varchar(500) NULL
);

-- Column comments

COMMENT ON COLUMN tb_fxjc_indicator."name" IS '指标名称';
COMMENT ON COLUMN tb_fxjc_indicator.code IS '指标代码';
COMMENT ON COLUMN tb_fxjc_indicator.unit IS '指标单位';
COMMENT ON COLUMN tb_fxjc_indicator.property IS '指标属性';
COMMENT ON COLUMN tb_fxjc_indicator.product_period IS '生产周期';
COMMENT ON COLUMN tb_fxjc_indicator.busi_type IS '业务类型，枚举值';
COMMENT ON COLUMN tb_fxjc_indicator.busi_define IS '业务定义';
COMMENT ON COLUMN tb_fxjc_indicator.remark IS '备注';
COMMENT ON COLUMN tb_fxjc_indicator.in_use IS '是否在用';
COMMENT ON COLUMN tb_fxjc_indicator.create_time IS '创建时间';
COMMENT ON COLUMN tb_fxjc_indicator.creator IS '创建人';
COMMENT ON COLUMN tb_fxjc_indicator.creator_id IS '创建人id';
COMMENT ON COLUMN tb_fxjc_indicator.source_type IS '指标来源类型，枚举值';
COMMENT ON COLUMN tb_fxjc_indicator.department IS '处室ID';
COMMENT ON COLUMN tb_fxjc_indicator.direction IS '指标方向';
COMMENT ON COLUMN tb_fxjc_indicator.value_type IS '指标类型';
COMMENT ON COLUMN tb_fxjc_indicator.dict_options IS '字典项选项，逗号分隔';


-- tb_fxjc_indicator_analysis_model definition

-- Drop table

-- DROP TABLE tb_fxjc_indicator_analysis_model;

CREATE TABLE tb_fxjc_indicator_analysis_model (
	id varchar(50) NULL,
	"name" varchar(20) NULL,
	description varchar NULL,
	params varchar(255) NULL
);


-- tb_fxjc_indicator_datasource definition

-- Drop table

-- DROP TABLE tb_fxjc_indicator_datasource;

CREATE TABLE tb_fxjc_indicator_datasource (
	f_id varchar(50) NOT NULL,
	f_type numeric(3) NULL,
	f_cate numeric(3) NULL,
	f_name varchar(50) NULL,
	f_description varchar(50) NULL,
	f_status numeric(3) NULL,
	f_connectionparams text NULL,
	f_createtime timestamp(6) NOT NULL,
	f_user varchar(50) NULL,
	f_pwd varchar(50) NULL,
	f_datasoucekey varchar(128) NULL,
	f_userid varchar(50) NULL
);

-- Column comments

COMMENT ON COLUMN tb_fxjc_indicator_datasource.f_type IS '数据源类型2:postgresql,3:mysql,1:oracle,0:sqlite,8:kingbase';
COMMENT ON COLUMN tb_fxjc_indicator_datasource.f_name IS '数据源名称';
COMMENT ON COLUMN tb_fxjc_indicator_datasource.f_description IS '数据源描述';
COMMENT ON COLUMN tb_fxjc_indicator_datasource.f_connectionparams IS '连接地址';
COMMENT ON COLUMN tb_fxjc_indicator_datasource.f_createtime IS '创建时间';
COMMENT ON COLUMN tb_fxjc_indicator_datasource.f_user IS '用户名';
COMMENT ON COLUMN tb_fxjc_indicator_datasource.f_pwd IS '密码';
COMMENT ON COLUMN tb_fxjc_indicator_datasource.f_datasoucekey IS '匹配库管数据源key';


-- tb_fxjc_indicator_detail definition

-- Drop table

-- DROP TABLE tb_fxjc_indicator_detail;

CREATE TABLE tb_fxjc_indicator_detail (
	id varchar(50) NOT NULL,
	indicator_code varchar(50) NULL,
	xzqmc varchar(50) NULL,
	xzqdm varchar(50) NULL,
	"year" int2 NULL,
	"month" int2 NULL,
	indicator_value numeric(30, 8) NULL,
	indicator_basis numeric NULL,
	indicator_ratio numeric NULL,
	indicator_name varchar(50) NULL,
	indicator_source_type varchar(2) NULL,
	indicator_unit varchar(10) NULL,
	indicator_busi_type varchar(2) NULL,
	proportion numeric(5, 2) NULL,
	ranking int2 NULL,
	quarter int2 NULL,
	create_time timestamp(6) NULL DEFAULT CURRENT_TIMESTAMP
);

-- Column comments

COMMENT ON COLUMN tb_fxjc_indicator_detail.id IS 'ID';
COMMENT ON COLUMN tb_fxjc_indicator_detail.indicator_code IS '指标编码';
COMMENT ON COLUMN tb_fxjc_indicator_detail.xzqmc IS '行政区名称';
COMMENT ON COLUMN tb_fxjc_indicator_detail.xzqdm IS '行政区代码';
COMMENT ON COLUMN tb_fxjc_indicator_detail."year" IS '年份';
COMMENT ON COLUMN tb_fxjc_indicator_detail."month" IS '月份';
COMMENT ON COLUMN tb_fxjc_indicator_detail.indicator_value IS '指标值';
COMMENT ON COLUMN tb_fxjc_indicator_detail.indicator_basis IS '指标同比(%)';
COMMENT ON COLUMN tb_fxjc_indicator_detail.indicator_ratio IS '指标环比(%)';
COMMENT ON COLUMN tb_fxjc_indicator_detail.indicator_name IS '指标名称';
COMMENT ON COLUMN tb_fxjc_indicator_detail.indicator_source_type IS '指标来源类型，枚举值';
COMMENT ON COLUMN tb_fxjc_indicator_detail.indicator_unit IS '指标单位';
COMMENT ON COLUMN tb_fxjc_indicator_detail.indicator_busi_type IS '指标业务类型，枚举值';
COMMENT ON COLUMN tb_fxjc_indicator_detail.proportion IS '占比(%)';
COMMENT ON COLUMN tb_fxjc_indicator_detail.ranking IS '排名';
COMMENT ON COLUMN tb_fxjc_indicator_detail.quarter IS '季度';


-- tb_fxjc_indicator_detail_period definition

-- Drop table

-- DROP TABLE tb_fxjc_indicator_detail_period;

CREATE TABLE tb_fxjc_indicator_detail_period (
	id varchar(50) NOT NULL,
	indicator_code varchar(50) NULL,
	xzqmc varchar(50) NULL,
	xzqdm varchar(50) NULL,
	"year" int2 NULL,
	month_range varchar(5) NULL,
	indicator_period_value numeric(30, 8) NULL,
	indicator_period_basis numeric NULL,
	indicator_period_ratio numeric NULL,
	indicator_name varchar(50) NULL,
	indicator_source_type varchar(2) NULL,
	indicator_unit varchar(10) NULL,
	indicator_busi_type varchar(2) NULL,
	proportion numeric(5, 2) NULL,
	ranking int2 NULL,
	quarter int2 NULL,
	create_time timestamp(6) NULL DEFAULT CURRENT_TIMESTAMP
);

-- Column comments

COMMENT ON COLUMN tb_fxjc_indicator_detail_period.id IS 'ID';
COMMENT ON COLUMN tb_fxjc_indicator_detail_period.indicator_code IS '指标编码';
COMMENT ON COLUMN tb_fxjc_indicator_detail_period.xzqmc IS '行政区名称';
COMMENT ON COLUMN tb_fxjc_indicator_detail_period.xzqdm IS '行政区代码';
COMMENT ON COLUMN tb_fxjc_indicator_detail_period."year" IS '年份';
COMMENT ON COLUMN tb_fxjc_indicator_detail_period.month_range IS '月份范围';
COMMENT ON COLUMN tb_fxjc_indicator_detail_period.indicator_period_value IS '指标累计值';
COMMENT ON COLUMN tb_fxjc_indicator_detail_period.indicator_period_basis IS '指标累计值同比(%)';
COMMENT ON COLUMN tb_fxjc_indicator_detail_period.indicator_period_ratio IS '指标累计值环比(%)';
COMMENT ON COLUMN tb_fxjc_indicator_detail_period.indicator_name IS '指标名称';
COMMENT ON COLUMN tb_fxjc_indicator_detail_period.indicator_source_type IS '指标来源类型，枚举值';
COMMENT ON COLUMN tb_fxjc_indicator_detail_period.indicator_unit IS '指标单位';
COMMENT ON COLUMN tb_fxjc_indicator_detail_period.indicator_busi_type IS '业务类型，枚举值';
COMMENT ON COLUMN tb_fxjc_indicator_detail_period.proportion IS '占比(%)';
COMMENT ON COLUMN tb_fxjc_indicator_detail_period.ranking IS '排名';
COMMENT ON COLUMN tb_fxjc_indicator_detail_period.quarter IS '季度';


-- tb_fxjc_indicator_dictionary definition

-- Drop table

-- DROP TABLE tb_fxjc_indicator_dictionary;

CREATE TABLE tb_fxjc_indicator_dictionary (
	id int4 NOT NULL DEFAULT nextval('fxjc_gw_indicator_dictionary_id_seq'::regclass),
	code varchar(10) NULL,
	"name" varchar(50) NULL,
	dictype varchar(20) NULL,
	sortindex int2 NULL
);

-- Column comments

COMMENT ON COLUMN tb_fxjc_indicator_dictionary.code IS '代码';
COMMENT ON COLUMN tb_fxjc_indicator_dictionary."name" IS '名称';
COMMENT ON COLUMN tb_fxjc_indicator_dictionary.dictype IS '类型';
COMMENT ON COLUMN tb_fxjc_indicator_dictionary.sortindex IS '排序';


-- tb_fxjc_indicator_source definition

-- Drop table

-- DROP TABLE tb_fxjc_indicator_source;

CREATE TABLE tb_fxjc_indicator_source (
	id varchar(50) NOT NULL,
	source_type varchar(2) NULL,
	department varchar(2) NULL,
	fillin_user varchar(20) NULL,
	fillin_userid varchar(50) NULL,
	mobile_phone varchar(15) NULL,
	update_time timestamptz(6) NULL
);

-- Column comments

COMMENT ON COLUMN tb_fxjc_indicator_source.id IS 'ID';
COMMENT ON COLUMN tb_fxjc_indicator_source.source_type IS '来源类型，枚举值';
COMMENT ON COLUMN tb_fxjc_indicator_source.department IS '处室，枚举值';
COMMENT ON COLUMN tb_fxjc_indicator_source.fillin_user IS '填报人';
COMMENT ON COLUMN tb_fxjc_indicator_source.fillin_userid IS '填报人ID';
COMMENT ON COLUMN tb_fxjc_indicator_source.mobile_phone IS '填报人电话';
COMMENT ON COLUMN tb_fxjc_indicator_source.update_time IS '更新时间';


-- tb_fxjc_indicator_source_model definition

-- Drop table

-- DROP TABLE tb_fxjc_indicator_source_model;

CREATE TABLE tb_fxjc_indicator_source_model (
	id varchar(50) NULL,
	model_name varchar(50) NULL,
	indicator_name varchar(50) NULL,
	indicator_code varchar(20) NULL,
	model_id varchar(50) NULL,
	statis_sql varchar(500) NULL,
	description varchar(255) NULL,
	calc_value numeric(30, 4) NULL
);


-- tb_fxjc_indicator_source_sysextract definition

-- Drop table

-- DROP TABLE tb_fxjc_indicator_source_sysextract;

CREATE TABLE tb_fxjc_indicator_source_sysextract (
	id varchar(50) NULL,
	indicator_name varchar(50) NULL,
	indicator_code varchar(20) NULL,
	table_name varchar(50) NULL,
	table_filter varchar(200) NULL,
	table_sql varchar(200) NULL,
	datasource_id varchar(50) NULL,
	description varchar(255) NULL,
	calc_value numeric(30, 4) NULL
);

-- Column comments

COMMENT ON COLUMN tb_fxjc_indicator_source_sysextract.datasource_id IS '数据源';


-- tb_fxjc_indicator_sysextract_test1 definition

-- Drop table

-- DROP TABLE tb_fxjc_indicator_sysextract_test1;

CREATE TABLE tb_fxjc_indicator_sysextract_test1 (
	id varchar(50) NULL,
	indicator_name varchar(50) NULL,
	indicator_value numeric(12, 2) NULL,
	xzqdm varchar(20) NULL,
	"year" int2 NULL,
	"month" int2 NULL
);

-- Column comments

COMMENT ON COLUMN tb_fxjc_indicator_sysextract_test1.id IS 'ID';
COMMENT ON COLUMN tb_fxjc_indicator_sysextract_test1.indicator_name IS '指标名称';
COMMENT ON COLUMN tb_fxjc_indicator_sysextract_test1.indicator_value IS '指标值';
COMMENT ON COLUMN tb_fxjc_indicator_sysextract_test1.xzqdm IS '行政区代码';
COMMENT ON COLUMN tb_fxjc_indicator_sysextract_test1."year" IS '年份';
COMMENT ON COLUMN tb_fxjc_indicator_sysextract_test1."month" IS '月份';


-- tb_fxjc_indicator_system definition

-- Drop table

-- DROP TABLE tb_fxjc_indicator_system;

CREATE TABLE tb_fxjc_indicator_system (
	id varchar(20) NOT NULL,
	"name" varchar(50) NULL,
	create_time timestamptz(6) NULL,
	creator varchar(10) NULL,
	creator_id varchar(50) NULL,
	remark varchar(500) NULL,
	update_time timestamptz(6) NULL,
	update_user varchar(50) NULL,
	update_user_id varchar(50) NULL
);

-- Column comments

COMMENT ON COLUMN tb_fxjc_indicator_system.id IS 'ID';
COMMENT ON COLUMN tb_fxjc_indicator_system."name" IS '指标体系名称';
COMMENT ON COLUMN tb_fxjc_indicator_system.create_time IS '创建时间';
COMMENT ON COLUMN tb_fxjc_indicator_system.creator IS '创建人';
COMMENT ON COLUMN tb_fxjc_indicator_system.creator_id IS '创建人id';
COMMENT ON COLUMN tb_fxjc_indicator_system.remark IS '备注';
COMMENT ON COLUMN tb_fxjc_indicator_system.update_time IS '更新时间';
COMMENT ON COLUMN tb_fxjc_indicator_system.update_user IS '更新人';
COMMENT ON COLUMN tb_fxjc_indicator_system.update_user_id IS '更新人id';


-- tb_fxjc_indicator_system_detail definition

-- Drop table

-- DROP TABLE tb_fxjc_indicator_system_detail;

CREATE TABLE tb_fxjc_indicator_system_detail (
	id varchar(50) NOT NULL,
	system_id varchar(50) NULL,
	system_name varchar(50) NULL,
	dir_name varchar(50) NULL,
	dir_id varchar(50) NULL,
	dir_sort int2 NULL,
	parent_dir_id varchar(50) NULL,
	indicator_code varchar(50) NULL,
	indicator_sort int2 NULL,
	"operator" varchar(10) NULL,
	operator_id varchar(50) NULL
);

-- Column comments

COMMENT ON COLUMN tb_fxjc_indicator_system_detail.id IS 'ID';
COMMENT ON COLUMN tb_fxjc_indicator_system_detail.system_id IS '指标体系id';
COMMENT ON COLUMN tb_fxjc_indicator_system_detail.system_name IS '指标体系名称';
COMMENT ON COLUMN tb_fxjc_indicator_system_detail.dir_name IS '目录名称';
COMMENT ON COLUMN tb_fxjc_indicator_system_detail.dir_id IS '目录id';
COMMENT ON COLUMN tb_fxjc_indicator_system_detail.dir_sort IS '目录排序';
COMMENT ON COLUMN tb_fxjc_indicator_system_detail.parent_dir_id IS '父目录id';
COMMENT ON COLUMN tb_fxjc_indicator_system_detail.indicator_code IS '指标代码';
COMMENT ON COLUMN tb_fxjc_indicator_system_detail.indicator_sort IS '指标排序';
COMMENT ON COLUMN tb_fxjc_indicator_system_detail."operator" IS '操作人';
COMMENT ON COLUMN tb_fxjc_indicator_system_detail.operator_id IS '操作人id';


-- tb_fxjc_indicator_system_history definition

-- Drop table

-- DROP TABLE tb_fxjc_indicator_system_history;

CREATE TABLE tb_fxjc_indicator_system_history (
	id varchar(20) NOT NULL,
	system_id varchar(50) NULL,
	system_name varchar(50) NULL,
	indicator_add varchar(255) NULL,
	indicator_modify varchar(255) NULL,
	indicator_delete varchar(255) NULL,
	update_time timestamptz(6) NULL,
	"operator" varchar(10) NULL,
	operator_id varchar(50) NULL,
	remark varchar(500) NULL,
	system_detail text NULL
);

-- Column comments

COMMENT ON COLUMN tb_fxjc_indicator_system_history.id IS 'ID';
COMMENT ON COLUMN tb_fxjc_indicator_system_history.system_id IS '指标体系id';
COMMENT ON COLUMN tb_fxjc_indicator_system_history.system_name IS '指标体系名称';
COMMENT ON COLUMN tb_fxjc_indicator_system_history.indicator_add IS '新增的指标';
COMMENT ON COLUMN tb_fxjc_indicator_system_history.indicator_modify IS '修改的指标';
COMMENT ON COLUMN tb_fxjc_indicator_system_history.indicator_delete IS '删除的指标';
COMMENT ON COLUMN tb_fxjc_indicator_system_history.update_time IS '更新时间';
COMMENT ON COLUMN tb_fxjc_indicator_system_history."operator" IS '操作人';
COMMENT ON COLUMN tb_fxjc_indicator_system_history.operator_id IS '操作人id';
COMMENT ON COLUMN tb_fxjc_indicator_system_history.remark IS '备注';
COMMENT ON COLUMN tb_fxjc_indicator_system_history.system_detail IS '指标体系详情';


-- tb_fxjc_indicator_threshold definition

-- Drop table

-- DROP TABLE tb_fxjc_indicator_threshold;

CREATE TABLE tb_fxjc_indicator_threshold (
	id varchar(50) NOT NULL,
	indicator_code varchar(20) NULL,
	xzqmc varchar(50) NULL,
	xzqdm varchar(19) NULL,
	threshold_symbol int2 NULL,
	threshold_lower numeric(12, 4) NULL,
	threshold_upper numeric(12, 4) NULL,
	basis_warning_symbol int2 NULL,
	basis_warning_lower numeric(8, 2) NULL,
	basis_warning_upper numeric(8, 2) NULL,
	ratio_warning_symbol int2 NULL,
	ratio_warning_lower numeric(8, 2) NULL,
	ratio_warning_upper numeric(8, 2) NULL
);

-- Column comments

COMMENT ON COLUMN tb_fxjc_indicator_threshold.id IS 'ID';
COMMENT ON COLUMN tb_fxjc_indicator_threshold.indicator_code IS '指标编码';
COMMENT ON COLUMN tb_fxjc_indicator_threshold.xzqmc IS '行政区名称';
COMMENT ON COLUMN tb_fxjc_indicator_threshold.xzqdm IS '行政区代码';
COMMENT ON COLUMN tb_fxjc_indicator_threshold.threshold_symbol IS '阈值符号，1:<；2:≤；3:＞；4:≥；5:介于';
COMMENT ON COLUMN tb_fxjc_indicator_threshold.threshold_lower IS '阈值-下限';
COMMENT ON COLUMN tb_fxjc_indicator_threshold.threshold_upper IS '阈值值-上限';
COMMENT ON COLUMN tb_fxjc_indicator_threshold.basis_warning_symbol IS '同比预警符号，1:<；2:≤；3:＞；4:≥；5:介于';
COMMENT ON COLUMN tb_fxjc_indicator_threshold.basis_warning_lower IS '同比预警值-下限(%)';
COMMENT ON COLUMN tb_fxjc_indicator_threshold.basis_warning_upper IS '同比预警值-上限(%)';
COMMENT ON COLUMN tb_fxjc_indicator_threshold.ratio_warning_symbol IS '环比预警符号，1:<；2:≤；3:＞；4:≥；5:介于';
COMMENT ON COLUMN tb_fxjc_indicator_threshold.ratio_warning_lower IS '环比预警值-下限(%)';
COMMENT ON COLUMN tb_fxjc_indicator_threshold.ratio_warning_upper IS '环比预警值-上限(%)';

-- tb_hztj_catalog definition

-- Drop table

-- DROP TABLE tb_hztj_catalog;

CREATE TABLE tb_hztj_catalog (
	f_id varchar(36) NOT NULL,
	f_name varchar(64) NULL,
	f_level int2 NULL,
	f_pid varchar(36) NULL,
	f_param text NULL,
	f_sort int2 NULL,
	f_isdefault int2 NULL,
	f_xzqdm varchar(255) NULL,
	f_year varchar(255) NULL,
	f_years varchar(255) NULL,
	f_filllevel varchar(36) NULL,
	f_areaunit varchar(36) NULL,
	f_url varchar(255) NULL,
	f_datasource varchar(36) NULL,
	f_type int2 NULL DEFAULT 1,
	f_tablename varchar(255) NULL,
	f_dataversion varchar(255) NULL,
	f_overlaydataversion varchar(255) NULL,
	f_tjfams text NULL,
	f_key varchar(255) NULL,
	CONSTRAINT tb_hztj_catalog_pkey PRIMARY KEY (f_id)
);


-- tb_kjgh_clipimg definition

-- Drop table

-- DROP TABLE tb_kjgh_clipimg;

CREATE TABLE tb_kjgh_clipimg (
	f_id varchar(255) NOT NULL,
	f_code varchar(255) NULL,
	f_name varchar(255) NULL,
	f_img bytea NULL,
	f_analyzeid varchar(255) NULL,
	CONSTRAINT pk_tb_kjgh_clipimg PRIMARY KEY (f_id)
);


-- tb_kjgh_datasource definition

-- Drop table

-- DROP TABLE tb_kjgh_datasource;

CREATE TABLE tb_kjgh_datasource (
	f_id varchar(50) NOT NULL,
	f_type numeric(3) NULL,
	f_cate numeric(3) NULL,
	f_name varchar(50) NULL,
	f_description varchar(50) NULL,
	f_status numeric(3) NULL,
	f_connectionparams text NULL,
	f_createtime timestamp(6) NOT NULL,
	f_user varchar(50) NULL,
	f_pwd varchar(50) NULL,
	f_datasoucekey varchar(128) NULL,
	f_userid varchar(50) NULL,
	CONSTRAINT pk_tb_kjgh_datasource PRIMARY KEY (f_id)
);


-- tb_kjgh_featureclass definition

-- Drop table

-- DROP TABLE tb_kjgh_featureclass;

CREATE TABLE tb_kjgh_featureclass (
	f_id varchar(50) NOT NULL,
	f_name varchar(255) NOT NULL,
	f_datasourceid varchar(50) NOT NULL,
	f_srid int4 NOT NULL DEFAULT 0,
	f_keyfieldname varchar(255) NOT NULL,
	f_shapefieldname varchar(255) NOT NULL,
	f_areafieldname varchar(255) NOT NULL,
	f_areaunittype int4 NOT NULL DEFAULT 0,
	f_geometrytype int4 NOT NULL DEFAULT 0,
	CONSTRAINT pk_tb_kjgh_featureclass PRIMARY KEY (f_id)
);


-- tb_kjgh_hg_analysistype definition

-- Drop table

-- DROP TABLE tb_kjgh_hg_analysistype;

CREATE TABLE tb_kjgh_hg_analysistype (
	f_id varchar(255) NOT NULL,
	f_ytfldm varchar(255) NOT NULL,
	f_layertypeid varchar(255) NOT NULL,
	f_rule int4 NOT NULL DEFAULT 0,
	f_prefilter varchar(255) NULL,
	CONSTRAINT pk_tb_kjgh_hg_analysistype PRIMARY KEY (f_id)
);


-- tb_kjgh_hg_bookmark definition

-- Drop table

-- DROP TABLE tb_kjgh_hg_bookmark;

CREATE TABLE tb_kjgh_hg_bookmark (
	f_id varchar(50) NOT NULL,
	f_userid varchar(50) NOT NULL,
	f_xmbh varchar(255) NOT NULL,
	f_xmmc varchar(255) NOT NULL,
	f_xmwz varchar(255) NULL,
	f_ydlx varchar(10) NOT NULL,
	f_shape text NOT NULL,
	f_layer text NOT NULL,
	f_resultinfo text NOT NULL,
	f_area numeric(15, 6) NOT NULL,
	f_createtime date NOT NULL,
	CONSTRAINT pk_tb_kjgh_hg_bookmark PRIMARY KEY (f_id)
);


-- tb_kjgh_hg_layertype definition

-- Drop table

-- DROP TABLE tb_kjgh_hg_layertype;

CREATE TABLE tb_kjgh_hg_layertype (
	f_id varchar(32) NOT NULL,
	f_name varchar(255) NOT NULL,
	f_parentid varchar(255) NULL,
	f_order int4 NULL,
	f_relid varchar(50) NULL,
	f_mapserviceid varchar(64) NULL,
	f_showconfig text NULL,
	f_clip text NULL,
	CONSTRAINT pk_tb_kjgh_hg_layertype PRIMARY KEY (f_id)
);


-- tb_kjgh_siting_analysisitem definition

-- Drop table

-- DROP TABLE tb_kjgh_siting_analysisitem;

CREATE TABLE tb_kjgh_siting_analysisitem (
	f_id varchar(50) NOT NULL,
	f_analysisid varchar(50) NOT NULL,
	f_factorid varchar(50) NOT NULL,
	f_filtertype varchar(255) NOT NULL,
	f_filter varchar(255) NOT NULL,
	CONSTRAINT pk_tb_kjgh_siting_analysisitem PRIMARY KEY (f_id)
);


-- tb_kjgh_siting_analysisrecord definition

-- Drop table

-- DROP TABLE tb_kjgh_siting_analysisrecord;

CREATE TABLE tb_kjgh_siting_analysisrecord (
	f_id varchar(255) NOT NULL,
	f_analysisfeatureclassid varchar(255) NOT NULL,
	f_xzqdm varchar(12) NOT NULL,
	f_projectname varchar(255) NULL,
	f_projectunit varchar(255) NULL,
	f_minarea float8 NULL,
	f_maxarea float8 NULL,
	f_ydlx varchar(255) NULL,
	f_usedlayerids varchar(255) NULL,
	CONSTRAINT pk_tb_kjgh_siting_analysisrecord PRIMARY KEY (f_id)
);


-- tb_kjgh_siting_cache definition

-- Drop table

-- DROP TABLE tb_kjgh_siting_cache;

CREATE TABLE tb_kjgh_siting_cache (
	f_id varchar(255) NOT NULL,
	f_tablename varchar(255) NULL,
	CONSTRAINT pk_tb_kjgh_siting_cache PRIMARY KEY (f_id)
);


-- tb_kjgh_siting_factor definition

-- Drop table

-- DROP TABLE tb_kjgh_siting_factor;

CREATE TABLE tb_kjgh_siting_factor (
	f_id varchar(50) NOT NULL,
	f_factorname varchar(255) NOT NULL,
	f_featureclassid varchar(50) NOT NULL,
	f_prefilter varchar(255) NULL,
	f_valuedomain varchar(255) NULL,
	f_order int4 NOT NULL,
	f_field varchar(255) NULL,
	f_tag varchar(255) NULL,
	CONSTRAINT pk_tb_kjgh_siting_factor PRIMARY KEY (f_id)
);


-- tb_kjgh_siting_factorbookmark definition

-- Drop table

-- DROP TABLE tb_kjgh_siting_factorbookmark;

CREATE TABLE tb_kjgh_siting_factorbookmark (
	f_id varchar(50) NOT NULL,
	f_userid varchar(50) NOT NULL,
	f_name varchar(255) NOT NULL,
	f_ydlx varchar(10) NOT NULL,
	f_createtime date NOT NULL,
	f_factorinfo text NULL,
	CONSTRAINT pk_tb_kjgh_siting_factorbookmark PRIMARY KEY (f_id)
);


-- tb_kjgh_sitting_layers definition

-- Drop table

-- DROP TABLE tb_kjgh_sitting_layers;

CREATE TABLE tb_kjgh_sitting_layers (
	f_id varchar(50) NOT NULL,
	f_relid varchar(50) NOT NULL,
	f_name varchar(50) NOT NULL,
	f_order int2 NULL,
	CONSTRAINT pk_tb_kjgh_sitting_layers PRIMARY KEY (f_id)
);


-- tb_matter_approve_charge definition

-- Drop table

-- DROP TABLE tb_matter_approve_charge;

CREATE TABLE tb_matter_approve_charge (
	id bpchar(36) NOT NULL,
	dept_code varchar(64) NULL DEFAULT ''::character varying,
	area_code varchar(64) NULL DEFAULT ''::character varying,
	row_guid varchar(64) NULL DEFAULT ''::character varying,
	approve_guid varchar(64) NULL DEFAULT ''::character varying,
	approve_id varchar(64) NULL DEFAULT ''::character varying,
	approve_code varchar(64) NULL DEFAULT ''::character varying,
	task_handle_item varchar(64) NULL DEFAULT ''::character varying,
	fee_name varchar(200) NULL DEFAULT ''::character varying,
	fee_stand text NULL,
	by_law text NULL,
	is_desc varchar(64) NULL DEFAULT ''::character varying,
	desc_explain text NULL,
	remark varchar(1000) NULL DEFAULT ''::character varying,
	order_num int4 NULL DEFAULT 0,
	cd_operation varchar(64) NULL DEFAULT ''::character varying,
	cd_batch varchar(64) NULL DEFAULT ''::character varying,
	last_update_time timestamp(6) NULL,
	remark1 varchar(200) NULL DEFAULT ''::character varying,
	remark2 varchar(200) NULL DEFAULT ''::character varying,
	remark3 varchar(200) NULL DEFAULT ''::character varying,
	remark4 text NULL,
	remark5 text NULL,
	create_time timestamp(6) NULL,
	update_time timestamp(6) NULL,
	"source" varchar(6) NULL DEFAULT ''::character varying,
	material_type varchar(128) NULL DEFAULT ''::character varying,
	CONSTRAINT tb_matter_approve_charge_pk PRIMARY KEY (id)
);

-- Column comments

COMMENT ON COLUMN tb_matter_approve_charge.dept_code IS '实施主体统一社会信用代码';
COMMENT ON COLUMN tb_matter_approve_charge.area_code IS '区域编码';
COMMENT ON COLUMN tb_matter_approve_charge.row_guid IS '记录唯一标识';
COMMENT ON COLUMN tb_matter_approve_charge.approve_guid IS '事项唯一标识';
COMMENT ON COLUMN tb_matter_approve_charge.approve_id IS '事项ID';
COMMENT ON COLUMN tb_matter_approve_charge.approve_code IS '事项编码';
COMMENT ON COLUMN tb_matter_approve_charge.task_handle_item IS '业务办理项编码';
COMMENT ON COLUMN tb_matter_approve_charge.fee_name IS '收费项目名称';
COMMENT ON COLUMN tb_matter_approve_charge.fee_stand IS '收费标准';
COMMENT ON COLUMN tb_matter_approve_charge.by_law IS '收费依据';
COMMENT ON COLUMN tb_matter_approve_charge.is_desc IS '是否允许减免';
COMMENT ON COLUMN tb_matter_approve_charge.desc_explain IS '允许减免依据';
COMMENT ON COLUMN tb_matter_approve_charge.remark IS '备注';
COMMENT ON COLUMN tb_matter_approve_charge.order_num IS '排序';
COMMENT ON COLUMN tb_matter_approve_charge.cd_operation IS '同步类型';
COMMENT ON COLUMN tb_matter_approve_charge.cd_batch IS '每次交换应唯一';
COMMENT ON COLUMN tb_matter_approve_charge.last_update_time IS '数据同步时间';
COMMENT ON COLUMN tb_matter_approve_charge.remark1 IS '备用字段1';
COMMENT ON COLUMN tb_matter_approve_charge.remark2 IS '备用字段2';
COMMENT ON COLUMN tb_matter_approve_charge.remark3 IS '备用字段3';
COMMENT ON COLUMN tb_matter_approve_charge.remark4 IS '备用字段4';
COMMENT ON COLUMN tb_matter_approve_charge.remark5 IS '备用字段5';
COMMENT ON COLUMN tb_matter_approve_charge.create_time IS 'create_time';
COMMENT ON COLUMN tb_matter_approve_charge.update_time IS 'update_time';
COMMENT ON COLUMN tb_matter_approve_charge."source" IS '来源';
COMMENT ON COLUMN tb_matter_approve_charge.material_type IS '材料类型';


-- tb_matter_approve_faq definition

-- Drop table

-- DROP TABLE tb_matter_approve_faq;

CREATE TABLE tb_matter_approve_faq (
	id bpchar(36) NOT NULL,
	dept_code varchar(64) NULL DEFAULT ''::character varying,
	area_code varchar(64) NULL DEFAULT ''::character varying,
	faq_id varchar(64) NULL DEFAULT ''::character varying,
	approve_id varchar(64) NULL DEFAULT ''::character varying,
	approve_code varchar(64) NULL DEFAULT ''::character varying,
	faq_title varchar(255) NULL DEFAULT ''::character varying,
	faq_content varchar(1000) NULL DEFAULT ''::character varying,
	reply_content text NULL,
	faq_title_py varchar(50) NULL DEFAULT ''::character varying,
	faq_type varchar(255) NULL DEFAULT ''::character varying,
	submit_time timestamp(6) NULL,
	is_effective varchar(255) NULL DEFAULT ''::character varying,
	task_handle_item varchar(255) NULL DEFAULT ''::character varying,
	order_num int4 NULL DEFAULT 0,
	cd_operation varchar(255) NULL DEFAULT ''::character varying,
	cd_batch varchar(255) NULL DEFAULT ''::character varying,
	last_update_time timestamp(6) NULL,
	remark1 varchar(200) NULL DEFAULT ''::character varying,
	remark2 varchar(255) NULL DEFAULT ''::character varying,
	remark3 varchar(200) NULL DEFAULT ''::character varying,
	remark4 text NULL,
	remark5 text NULL,
	create_time timestamp(6) NULL,
	update_time timestamp(6) NULL,
	"source" varchar(6) NULL DEFAULT ''::character varying,
	CONSTRAINT tb_matter_approve_faq_pk PRIMARY KEY (id)
);

-- Column comments

COMMENT ON COLUMN tb_matter_approve_faq.dept_code IS '实施主体统一社会信用代码';
COMMENT ON COLUMN tb_matter_approve_faq.area_code IS '区域编码';
COMMENT ON COLUMN tb_matter_approve_faq.faq_id IS '常见问题ID';
COMMENT ON COLUMN tb_matter_approve_faq.approve_id IS '事项ID';
COMMENT ON COLUMN tb_matter_approve_faq.approve_code IS '实施编码';
COMMENT ON COLUMN tb_matter_approve_faq.faq_title IS '问题名称';
COMMENT ON COLUMN tb_matter_approve_faq.faq_content IS '问题内容';
COMMENT ON COLUMN tb_matter_approve_faq.reply_content IS '回复内容';
COMMENT ON COLUMN tb_matter_approve_faq.faq_title_py IS '问题名称拼音';
COMMENT ON COLUMN tb_matter_approve_faq.faq_type IS '问题类型';
COMMENT ON COLUMN tb_matter_approve_faq.submit_time IS '提交时间';
COMMENT ON COLUMN tb_matter_approve_faq.is_effective IS '是否有效';
COMMENT ON COLUMN tb_matter_approve_faq.task_handle_item IS '业务办理项编码';
COMMENT ON COLUMN tb_matter_approve_faq.order_num IS '排序';
COMMENT ON COLUMN tb_matter_approve_faq.cd_operation IS '同步类型';
COMMENT ON COLUMN tb_matter_approve_faq.cd_batch IS '每次交换应唯一';
COMMENT ON COLUMN tb_matter_approve_faq.last_update_time IS '数据同步时间';
COMMENT ON COLUMN tb_matter_approve_faq.remark1 IS '备用字段1';
COMMENT ON COLUMN tb_matter_approve_faq.remark2 IS '备用字段2';
COMMENT ON COLUMN tb_matter_approve_faq.remark3 IS '备用字段3';
COMMENT ON COLUMN tb_matter_approve_faq.remark4 IS '备用字段4';
COMMENT ON COLUMN tb_matter_approve_faq.remark5 IS '备用字段5';
COMMENT ON COLUMN tb_matter_approve_faq.create_time IS 'create_time';
COMMENT ON COLUMN tb_matter_approve_faq.update_time IS 'update_time';
COMMENT ON COLUMN tb_matter_approve_faq."source" IS '来源';


-- tb_matter_approve_flowchart definition

-- Drop table

-- DROP TABLE tb_matter_approve_flowchart;

CREATE TABLE tb_matter_approve_flowchart (
	id bpchar(36) NOT NULL,
	dept_code varchar(64) NULL DEFAULT ''::character varying,
	area_code varchar(64) NULL DEFAULT ''::character varying,
	row_guid varchar(100) NULL DEFAULT ''::character varying,
	approve_id varchar(64) NULL DEFAULT ''::character varying,
	approve_name varchar(1000) NULL DEFAULT ''::character varying,
	org_id varchar(50) NULL DEFAULT ''::character varying,
	org_name varchar(500) NULL DEFAULT ''::character varying,
	"name" varchar(255) NULL DEFAULT ''::character varying,
	"time" varchar(255) NULL DEFAULT ''::character varying,
	assign varchar(2000) NULL DEFAULT ''::character varying,
	alias varchar(200) NULL DEFAULT ''::character varying,
	act_id varchar(200) NULL DEFAULT ''::character varying,
	"next" varchar(200) NULL DEFAULT ''::character varying,
	cd_operation varchar(255) NULL DEFAULT ''::character varying,
	cd_batch varchar(255) NULL DEFAULT ''::character varying,
	last_update_time timestamp(6) NULL,
	remark1 varchar(200) NULL DEFAULT ''::character varying,
	remark2 varchar(200) NULL DEFAULT ''::character varying,
	remark3 varchar(200) NULL DEFAULT ''::character varying,
	remark4 text NULL,
	remark5 text NULL,
	create_time timestamp(6) NULL,
	update_time timestamp(6) NULL,
	"source" varchar(6) NULL DEFAULT ''::character varying,
	review_criteria varchar(128) NULL DEFAULT ''::character varying,
	CONSTRAINT tb_matter_approve_flowchart_pk PRIMARY KEY (id)
);

-- Column comments

COMMENT ON COLUMN tb_matter_approve_flowchart.dept_code IS '实施主体统一社会信用代码';
COMMENT ON COLUMN tb_matter_approve_flowchart.area_code IS '区域编码';
COMMENT ON COLUMN tb_matter_approve_flowchart.row_guid IS '唯一id';
COMMENT ON COLUMN tb_matter_approve_flowchart.approve_id IS '事项ID';
COMMENT ON COLUMN tb_matter_approve_flowchart.approve_name IS '事项名称';
COMMENT ON COLUMN tb_matter_approve_flowchart.org_id IS '实施机构ID';
COMMENT ON COLUMN tb_matter_approve_flowchart.org_name IS '单位名称';
COMMENT ON COLUMN tb_matter_approve_flowchart."name" IS '环节名称';
COMMENT ON COLUMN tb_matter_approve_flowchart."time" IS '时限';
COMMENT ON COLUMN tb_matter_approve_flowchart.assign IS '处理人';
COMMENT ON COLUMN tb_matter_approve_flowchart.alias IS '环节别名';
COMMENT ON COLUMN tb_matter_approve_flowchart.act_id IS '环节id';
COMMENT ON COLUMN tb_matter_approve_flowchart."next" IS '下一环节';
COMMENT ON COLUMN tb_matter_approve_flowchart.cd_operation IS '同步类型';
COMMENT ON COLUMN tb_matter_approve_flowchart.cd_batch IS '每次交换应唯一';
COMMENT ON COLUMN tb_matter_approve_flowchart.last_update_time IS '数据同步时间';
COMMENT ON COLUMN tb_matter_approve_flowchart.remark1 IS '时限单位(h：小时，D：工作日)';
COMMENT ON COLUMN tb_matter_approve_flowchart.remark2 IS '备用字段2';
COMMENT ON COLUMN tb_matter_approve_flowchart.remark3 IS '备用字段3';
COMMENT ON COLUMN tb_matter_approve_flowchart.remark4 IS '备用字段4';
COMMENT ON COLUMN tb_matter_approve_flowchart.remark5 IS '备用字段5';
COMMENT ON COLUMN tb_matter_approve_flowchart.create_time IS 'create_time';
COMMENT ON COLUMN tb_matter_approve_flowchart.update_time IS 'update_time';
COMMENT ON COLUMN tb_matter_approve_flowchart."source" IS '来源';
COMMENT ON COLUMN tb_matter_approve_flowchart.review_criteria IS '审核标准';


-- tb_matter_approve_info definition

-- Drop table

-- DROP TABLE tb_matter_approve_info;

CREATE TABLE tb_matter_approve_info (
	id bpchar(36) NOT NULL,
	dept_code varchar(64) NULL DEFAULT ''::character varying,
	area_code varchar(64) NULL DEFAULT ''::character varying,
	rights_code varchar(64) NULL DEFAULT ''::character varying,
	rights_id varchar(64) NULL DEFAULT ''::character varying,
	approve_id varchar(64) NULL DEFAULT ''::character varying,
	approve_code varchar(64) NULL DEFAULT ''::character varying,
	parent_code varchar(64) NULL DEFAULT ''::character varying,
	approve_name varchar(1000) NULL DEFAULT ''::character varying,
	org_id varchar(64) NULL DEFAULT ''::character varying,
	org_name varchar(255) NULL DEFAULT ''::character varying,
	type_code varchar(255) NULL DEFAULT ''::character varying,
	trans_type varchar(255) NULL DEFAULT ''::character varying,
	approve_source varchar(255) NULL DEFAULT ''::character varying,
	approve_properties varchar(255) NULL DEFAULT ''::character varying,
	transact_level varchar(255) NULL DEFAULT ''::character varying,
	min_seq int4 NULL DEFAULT 0,
	min_explain text NULL,
	serve_object varchar(255) NULL DEFAULT ''::character varying,
	theme_type varchar(255) NULL DEFAULT ''::character varying,
	life_concern varchar(255) NULL DEFAULT ''::character varying,
	is_self_system varchar(255) NULL DEFAULT ''::character varying,
	approve_state varchar(255) NULL DEFAULT ''::character varying,
	version_num int4 NULL DEFAULT 0,
	remark varchar(500) NULL DEFAULT ''::character varying,
	is_charge varchar(255) NULL DEFAULT ''::character varying,
	is_intermediary_services varchar(255) NULL DEFAULT ''::character varying,
	is_valid varchar(255) NULL DEFAULT ''::character varying,
	natural_person_type varchar(255) NULL DEFAULT ''::character varying,
	certification_type varchar(255) NULL DEFAULT ''::character varying,
	scene_type varchar(255) NULL DEFAULT ''::character varying,
	approve_code_main varchar(255) NULL DEFAULT ''::character varying,
	authority_division varchar(2000) NULL DEFAULT ''::character varying,
	approve_content varchar(2000) NULL DEFAULT ''::character varying,
	implementation_subject varchar(255) NULL DEFAULT ''::character varying,
	acceptance_condition varchar(2000) NULL DEFAULT ''::character varying,
	joint_agency varchar(500) NULL DEFAULT ''::character varying,
	quantitative_restriction varchar(2000) NULL DEFAULT ''::character varying,
	life_event varchar(255) NULL DEFAULT ''::character varying,
	spe_object_classification varchar(255) NULL DEFAULT ''::character varying,
	bus_activity_classification varchar(255) NULL DEFAULT ''::character varying,
	operation_system varchar(255) NULL DEFAULT ''::character varying,
	admin_reconsideration text NULL,
	people_code varchar(255) NULL DEFAULT ''::character varying,
	self_system varchar(500) NULL DEFAULT ''::character varying,
	consult_limit int4 NULL DEFAULT 0,
	approve_sn int4 NULL DEFAULT 0,
	applicant_power varchar(2000) NULL DEFAULT ''::character varying,
	applicant_duty varchar(2000) NULL DEFAULT ''::character varying,
	admin_review_dep_name varchar(2000) NULL DEFAULT ''::character varying,
	admin_review_dep_address varchar(2000) NULL DEFAULT ''::character varying,
	admin_review_dep_phone varchar(255) NULL DEFAULT ''::character varying,
	admin_review_dep_website varchar(255) NULL DEFAULT ''::character varying,
	admin_litigation_dep_address varchar(2000) NULL DEFAULT ''::character varying,
	admin_litigation_dep_phone varchar(255) NULL DEFAULT ''::character varying,
	admin_litigation_dep_website varchar(255) NULL DEFAULT ''::character varying,
	power_source varchar(255) NULL DEFAULT ''::character varying,
	local_catalog_code varchar(255) NULL DEFAULT ''::character varying,
	local_task_code varchar(255) NULL DEFAULT ''::character varying,
	task_handle_item varchar(255) NULL DEFAULT ''::character varying,
	entrust_name varchar(255) NULL DEFAULT ''::character varying,
	app_is_single_login varchar(255) NULL DEFAULT ''::character varying,
	mobile_terminal_url varchar(2000) NULL DEFAULT ''::character varying,
	is_single_login varchar(255) NULL DEFAULT ''::character varying,
	link_address varchar(2000) NULL DEFAULT ''::character varying,
	user_character_topic_type varchar(255) NULL DEFAULT ''::character varying,
	plan_effective_date timestamp(6) NULL,
	plan_cancel_date timestamp(6) NULL,
	intermediary_services varchar(500) NULL DEFAULT ''::character varying,
	corp_character_topic_type varchar(255) NULL DEFAULT ''::character varying,
	is_online varchar(255) NULL DEFAULT ''::character varying,
	online_handle_depth varchar(255) NULL DEFAULT ''::character varying,
	online_handle_url varchar(2000) NULL DEFAULT ''::character varying,
	limit_scene_explain varchar(1000) NULL DEFAULT ''::character varying,
	cd_operation varchar(255) NULL DEFAULT ''::character varying,
	cd_batch varchar(255) NULL DEFAULT ''::character varying,
	last_update_time timestamp(6) NULL,
	remark1 varchar(200) NULL DEFAULT ''::character varying,
	remark2 varchar(200) NULL DEFAULT ''::character varying,
	remark3 varchar(200) NULL DEFAULT ''::character varying,
	remark4 text NULL,
	remark5 text NULL,
	create_time timestamp(6) NULL,
	update_time timestamp(6) NULL,
	parent_child_relationships varchar(255) NULL DEFAULT ''::character varying,
	service_form varchar(255) NULL DEFAULT ''::character varying,
	business_type varchar(8) NULL DEFAULT ''::character varying,
	responsibility_office varchar(128) NULL DEFAULT ''::character varying,
	"source" varchar(6) NULL DEFAULT ''::character varying,
	platform varchar(2000) NULL DEFAULT ''::character varying,
	is_accept int4 NULL DEFAULT 0,
	admin_litigation_dep_name varchar(2000) NULL DEFAULT ''::character varying,
	consult_limit_unit varchar(128) NULL DEFAULT ''::character varying,
	parent_id varchar(128) NULL DEFAULT ''::character varying,
	dn_dept_code varchar(128) NULL DEFAULT ''::character varying,
	mod_flag varchar(128) NULL DEFAULT ''::character varying,
	dn_dept_code_gsj varchar(128) NULL DEFAULT ''::character varying,
	dn_dept_code_gs varchar(128) NULL DEFAULT ''::character varying,
	is_exchange varchar(128) NULL DEFAULT ''::character varying,
	CONSTRAINT tb_matter_approve_info_pk PRIMARY KEY (id)
);

-- Column comments

COMMENT ON COLUMN tb_matter_approve_info.dept_code IS '实施主体统一社会信用代码';
COMMENT ON COLUMN tb_matter_approve_info.area_code IS '区域编码';
COMMENT ON COLUMN tb_matter_approve_info.rights_code IS '基本编码';
COMMENT ON COLUMN tb_matter_approve_info.rights_id IS '目录ID';
COMMENT ON COLUMN tb_matter_approve_info.approve_id IS '事项ID';
COMMENT ON COLUMN tb_matter_approve_info.approve_code IS '事项编码';
COMMENT ON COLUMN tb_matter_approve_info.parent_code IS '父基本编码';
COMMENT ON COLUMN tb_matter_approve_info.approve_name IS '事项名称';
COMMENT ON COLUMN tb_matter_approve_info.org_id IS '实施机构';
COMMENT ON COLUMN tb_matter_approve_info.org_name IS '机构名称';
COMMENT ON COLUMN tb_matter_approve_info.type_code IS '事项类型';
COMMENT ON COLUMN tb_matter_approve_info.trans_type IS '办件类型';
COMMENT ON COLUMN tb_matter_approve_info.approve_source IS '行使层级';
COMMENT ON COLUMN tb_matter_approve_info.approve_properties IS '事项性质';
COMMENT ON COLUMN tb_matter_approve_info.transact_level IS '办理深度';
COMMENT ON COLUMN tb_matter_approve_info.min_seq IS '最少次数';
COMMENT ON COLUMN tb_matter_approve_info.min_explain IS '标准说明';
COMMENT ON COLUMN tb_matter_approve_info.serve_object IS '服务对象';
COMMENT ON COLUMN tb_matter_approve_info.theme_type IS '法人对象分类';
COMMENT ON COLUMN tb_matter_approve_info.life_concern IS '生命周期分类';
COMMENT ON COLUMN tb_matter_approve_info.is_self_system IS '是否为自有系统办理';
COMMENT ON COLUMN tb_matter_approve_info.approve_state IS '事项状态';
COMMENT ON COLUMN tb_matter_approve_info.version_num IS '版本号';
COMMENT ON COLUMN tb_matter_approve_info.remark IS '备注';
COMMENT ON COLUMN tb_matter_approve_info.is_charge IS '是否收费';
COMMENT ON COLUMN tb_matter_approve_info.is_intermediary_services IS '是否中介服务事项';
COMMENT ON COLUMN tb_matter_approve_info.is_valid IS '数据是否有效';
COMMENT ON COLUMN tb_matter_approve_info.natural_person_type IS '自然人分类';
COMMENT ON COLUMN tb_matter_approve_info.certification_type IS '认证类型';
COMMENT ON COLUMN tb_matter_approve_info.scene_type IS '场景分类';
COMMENT ON COLUMN tb_matter_approve_info.approve_code_main IS '主事项实施编码';
COMMENT ON COLUMN tb_matter_approve_info.authority_division IS '权限划分';
COMMENT ON COLUMN tb_matter_approve_info.approve_content IS '行使内容';
COMMENT ON COLUMN tb_matter_approve_info.implementation_subject IS '实施主体性质';
COMMENT ON COLUMN tb_matter_approve_info.acceptance_condition IS '受理条件,法规和文件列明的具体条件';
COMMENT ON COLUMN tb_matter_approve_info.joint_agency IS '联办机构';
COMMENT ON COLUMN tb_matter_approve_info.quantitative_restriction IS '数量限制';
COMMENT ON COLUMN tb_matter_approve_info.life_event IS '人生事件';
COMMENT ON COLUMN tb_matter_approve_info.spe_object_classification IS '特定对象分类';
COMMENT ON COLUMN tb_matter_approve_info.bus_activity_classification IS '经营活动分类';
COMMENT ON COLUMN tb_matter_approve_info.operation_system IS '运行系统';
COMMENT ON COLUMN tb_matter_approve_info.admin_reconsideration IS '行政复议及诉讼';
COMMENT ON COLUMN tb_matter_approve_info.people_code IS '群体分类';
COMMENT ON COLUMN tb_matter_approve_info.self_system IS '已有业务系统';
COMMENT ON COLUMN tb_matter_approve_info.consult_limit IS '咨询回复时限';
COMMENT ON COLUMN tb_matter_approve_info.approve_sn IS '排序号';
COMMENT ON COLUMN tb_matter_approve_info.applicant_power IS '申请人权利';
COMMENT ON COLUMN tb_matter_approve_info.applicant_duty IS '申请人义务';
COMMENT ON COLUMN tb_matter_approve_info.admin_review_dep_name IS '行政复议部门的名称';
COMMENT ON COLUMN tb_matter_approve_info.admin_review_dep_address IS '行政复议部门的地址';
COMMENT ON COLUMN tb_matter_approve_info.admin_review_dep_phone IS '行政复议部门的电话';
COMMENT ON COLUMN tb_matter_approve_info.admin_review_dep_website IS '行政复议部门的网址';
COMMENT ON COLUMN tb_matter_approve_info.admin_litigation_dep_address IS '行政诉讼部门的地址';
COMMENT ON COLUMN tb_matter_approve_info.admin_litigation_dep_phone IS '行政诉讼部门的电话';
COMMENT ON COLUMN tb_matter_approve_info.admin_litigation_dep_website IS '行政诉讼部门的网址';
COMMENT ON COLUMN tb_matter_approve_info.power_source IS '权力来源';
COMMENT ON COLUMN tb_matter_approve_info.local_catalog_code IS '地方目录编码';
COMMENT ON COLUMN tb_matter_approve_info.local_task_code IS '地方实施编码';
COMMENT ON COLUMN tb_matter_approve_info.task_handle_item IS '业务办理项编码';
COMMENT ON COLUMN tb_matter_approve_info.entrust_name IS '委托部门';
COMMENT ON COLUMN tb_matter_approve_info.app_is_single_login IS '移动端是否对接单点登录';
COMMENT ON COLUMN tb_matter_approve_info.mobile_terminal_url IS '移动端是否对接单点登录';
COMMENT ON COLUMN tb_matter_approve_info.is_single_login IS '是否对接了国家政务服务平台单点登录';
COMMENT ON COLUMN tb_matter_approve_info.link_address IS '计算机端是否对接单点登录';
COMMENT ON COLUMN tb_matter_approve_info.user_character_topic_type IS '面向自然人事项主题分类代码';
COMMENT ON COLUMN tb_matter_approve_info.plan_effective_date IS '计划生效时间';
COMMENT ON COLUMN tb_matter_approve_info.plan_cancel_date IS '计划取消时间';
COMMENT ON COLUMN tb_matter_approve_info.intermediary_services IS '法定涉及的中介服务名称';
COMMENT ON COLUMN tb_matter_approve_info.corp_character_topic_type IS '面向法人事项主题分类代码';
COMMENT ON COLUMN tb_matter_approve_info.is_online IS '是否网办';
COMMENT ON COLUMN tb_matter_approve_info.online_handle_depth IS '网上办理深度';
COMMENT ON COLUMN tb_matter_approve_info.online_handle_url IS '网办地址';
COMMENT ON COLUMN tb_matter_approve_info.limit_scene_explain IS '办事人必须到现场办理的情况进行说明';
COMMENT ON COLUMN tb_matter_approve_info.cd_operation IS '同步类型';
COMMENT ON COLUMN tb_matter_approve_info.cd_batch IS '每次交换应唯一';
COMMENT ON COLUMN tb_matter_approve_info.last_update_time IS '数据同步时间';
COMMENT ON COLUMN tb_matter_approve_info.remark1 IS '父子关系 F：父项；C：子项；D:独立项';
COMMENT ON COLUMN tb_matter_approve_info.remark2 IS '备用字段2';
COMMENT ON COLUMN tb_matter_approve_info.remark3 IS '服务形式';
COMMENT ON COLUMN tb_matter_approve_info.remark4 IS '服务形式';
COMMENT ON COLUMN tb_matter_approve_info.remark5 IS '服务形5';
COMMENT ON COLUMN tb_matter_approve_info.create_time IS 'create_time';
COMMENT ON COLUMN tb_matter_approve_info.update_time IS 'update_time';
COMMENT ON COLUMN tb_matter_approve_info.parent_child_relationships IS '父子关系';
COMMENT ON COLUMN tb_matter_approve_info.service_form IS '服务形式';
COMMENT ON COLUMN tb_matter_approve_info.business_type IS '业务类型';
COMMENT ON COLUMN tb_matter_approve_info.responsibility_office IS '责任处室';
COMMENT ON COLUMN tb_matter_approve_info."source" IS '来源';
COMMENT ON COLUMN tb_matter_approve_info.platform IS '适用平台';
COMMENT ON COLUMN tb_matter_approve_info.is_accept IS '是否受理';
COMMENT ON COLUMN tb_matter_approve_info.admin_litigation_dep_name IS '行政诉讼部门的名称';
COMMENT ON COLUMN tb_matter_approve_info.consult_limit_unit IS '咨询时限单位';
COMMENT ON COLUMN tb_matter_approve_info.parent_id IS '父事项id';
COMMENT ON COLUMN tb_matter_approve_info.dn_dept_code IS '区分厅局统一社会信用代码';
COMMENT ON COLUMN tb_matter_approve_info.mod_flag IS '数据操作增量标志位';
COMMENT ON COLUMN tb_matter_approve_info.dn_dept_code_gsj IS '工商统一社会信用代码专用';
COMMENT ON COLUMN tb_matter_approve_info.dn_dept_code_gs IS '多厅局事项下发标志';
COMMENT ON COLUMN tb_matter_approve_info.is_exchange IS '是否存在交换';


-- tb_matter_approve_info_expand definition

-- Drop table

-- DROP TABLE tb_matter_approve_info_expand;

CREATE TABLE tb_matter_approve_info_expand (
	id varchar(64) NOT NULL DEFAULT ''::character varying,
	approve_id varchar(64) NOT NULL DEFAULT ''::character varying,
	approve_name varchar(1000) NOT NULL DEFAULT ''::character varying,
	business_type varchar(255) NOT NULL DEFAULT ''::character varying,
	responsibility_office varchar(255) NOT NULL DEFAULT ''::character varying,
	form_type varchar(1) NOT NULL DEFAULT '3'::character varying,
	accept_system varchar(1) NOT NULL DEFAULT '2'::character varying,
	dock_system varchar(1) NOT NULL DEFAULT '1'::character varying,
	accept_user_name varchar(255) NOT NULL DEFAULT ''::character varying,
	accept_user_id varchar(255) NOT NULL DEFAULT ''::character varying,
	accept_url varchar(500) NULL DEFAULT ''::character varying,
	apply_url varchar(500) NULL DEFAULT ''::character varying,
	approve_relation_code varchar(255) NULL DEFAULT ''::character varying,
	CONSTRAINT tb_matter_approve_info_expand_pk PRIMARY KEY (id)
);

-- Column comments

COMMENT ON COLUMN tb_matter_approve_info_expand.id IS '主键id';
COMMENT ON COLUMN tb_matter_approve_info_expand.approve_id IS '事项id';
COMMENT ON COLUMN tb_matter_approve_info_expand.approve_name IS '事项名称';
COMMENT ON COLUMN tb_matter_approve_info_expand.business_type IS '业务类型:多个用^隔开';
COMMENT ON COLUMN tb_matter_approve_info_expand.responsibility_office IS '责任处室:多个用^隔开';
COMMENT ON COLUMN tb_matter_approve_info_expand.form_type IS '表单类型:1 嵌入 2 跳转 3 通用';
COMMENT ON COLUMN tb_matter_approve_info_expand.accept_system IS '受理系统:1 一体化 2 两个大厅';
COMMENT ON COLUMN tb_matter_approve_info_expand.dock_system IS '对接系统:1 政务平台 2 长规';
COMMENT ON COLUMN tb_matter_approve_info_expand.accept_user_name IS '受理人员名称';
COMMENT ON COLUMN tb_matter_approve_info_expand.accept_user_id IS '受理人员id';
COMMENT ON COLUMN tb_matter_approve_info_expand.accept_url IS '受理表单地址';
COMMENT ON COLUMN tb_matter_approve_info_expand.apply_url IS '申请表单地址';
COMMENT ON COLUMN tb_matter_approve_info_expand.approve_relation_code IS '事项库与第三方系统的关联code';


-- tb_matter_approve_material definition

-- Drop table

-- DROP TABLE tb_matter_approve_material;

CREATE TABLE tb_matter_approve_material (
	id bpchar(36) NOT NULL,
	dept_code varchar(64) NULL DEFAULT ''::character varying,
	area_code varchar(64) NULL DEFAULT ''::character varying,
	material_id varchar(64) NULL DEFAULT ''::character varying,
	approve_id varchar(64) NULL DEFAULT ''::character varying,
	type_id varchar(64) NULL DEFAULT ''::character varying,
	material_title varchar(200) NULL DEFAULT ''::character varying,
	material_py varchar(255) NULL DEFAULT ''::character varying,
	copies_num varchar(50) NULL DEFAULT ''::character varying,
	material_standard varchar(255) NULL DEFAULT ''::character varying,
	is_electronic_material varchar(255) NULL DEFAULT ''::character varying,
	commit_way varchar(255) NULL DEFAULT ''::character varying,
	accept_standard text NULL,
	order_num int4 NULL DEFAULT 0,
	is_blank varchar(255) NULL DEFAULT ''::character varying,
	blank_name varchar(1000) NULL DEFAULT ''::character varying,
	is_model varchar(255) NULL DEFAULT ''::character varying,
	model_name varchar(1000) NULL DEFAULT ''::character varying,
	source_channel varchar(255) NULL DEFAULT ''::character varying,
	material_explain varchar(500) NULL DEFAULT ''::character varying,
	material_type varchar(255) NULL DEFAULT ''::character varying,
	task_code varchar(64) NULL DEFAULT ''::character varying,
	task_handle_item varchar(64) NULL DEFAULT ''::character varying,
	is_must varchar(255) NULL DEFAULT ''::character varying,
	source_explain varchar(128) NULL DEFAULT ''::character varying,
	page_format varchar(200) NULL DEFAULT ''::character varying,
	by_law text NULL,
	remark text NULL,
	is_effective varchar(255) NULL DEFAULT ''::character varying,
	cd_operation varchar(255) NULL DEFAULT ''::character varying,
	cd_batch varchar(255) NULL DEFAULT ''::character varying,
	last_update_time timestamp(6) NULL,
	remark1 varchar(200) NULL DEFAULT ''::character varying,
	remark2 varchar(200) NULL DEFAULT ''::character varying,
	remark3 varchar(200) NULL DEFAULT ''::character varying,
	remark4 text NULL,
	remark5 text NULL,
	create_time timestamp(6) NULL,
	update_time timestamp(6) NULL,
	"source" varchar(6) NULL DEFAULT ''::character varying,
	material_num int4 NULL DEFAULT 0,
	material_property varchar(128) NULL DEFAULT ''::character varying,
	sample_tab varchar(1000) NULL DEFAULT ''::character varying,
	certificate varchar(1000) NULL DEFAULT ''::character varying,
	blank_tab varchar(1000) NULL DEFAULT ''::character varying,
	CONSTRAINT tb_matter_approve_material_pk PRIMARY KEY (id)
);

-- Column comments

COMMENT ON COLUMN tb_matter_approve_material.dept_code IS '实施主体统一社会信用代码';
COMMENT ON COLUMN tb_matter_approve_material.area_code IS '区域编码';
COMMENT ON COLUMN tb_matter_approve_material.material_id IS '材料ID唯一标识';
COMMENT ON COLUMN tb_matter_approve_material.approve_id IS '事项ID(';
COMMENT ON COLUMN tb_matter_approve_material.type_id IS '材料类型id';
COMMENT ON COLUMN tb_matter_approve_material.material_title IS '材料名称';
COMMENT ON COLUMN tb_matter_approve_material.material_py IS '材料拼音';
COMMENT ON COLUMN tb_matter_approve_material.copies_num IS '份数';
COMMENT ON COLUMN tb_matter_approve_material.material_standard IS '材料形式';
COMMENT ON COLUMN tb_matter_approve_material.is_electronic_material IS '是否需要电子材料';
COMMENT ON COLUMN tb_matter_approve_material.commit_way IS '提交方式';
COMMENT ON COLUMN tb_matter_approve_material.accept_standard IS '受理标准';
COMMENT ON COLUMN tb_matter_approve_material.order_num IS '排序';
COMMENT ON COLUMN tb_matter_approve_material.is_blank IS '是否有空白模板';
COMMENT ON COLUMN tb_matter_approve_material.blank_name IS '空白模板名称';
COMMENT ON COLUMN tb_matter_approve_material.is_model IS '是否有示范文本';
COMMENT ON COLUMN tb_matter_approve_material.model_name IS '示范文本名称';
COMMENT ON COLUMN tb_matter_approve_material.source_channel IS '来源渠道';
COMMENT ON COLUMN tb_matter_approve_material.material_explain IS '填报须知';
COMMENT ON COLUMN tb_matter_approve_material.material_type IS '材料类型';
COMMENT ON COLUMN tb_matter_approve_material.task_code IS '实施编码';
COMMENT ON COLUMN tb_matter_approve_material.task_handle_item IS '业务办理项编码';
COMMENT ON COLUMN tb_matter_approve_material.is_must IS '材料必要性';
COMMENT ON COLUMN tb_matter_approve_material.source_explain IS '来源渠道说明';
COMMENT ON COLUMN tb_matter_approve_material.page_format IS '纸质材料规格 ';
COMMENT ON COLUMN tb_matter_approve_material.by_law IS '要求依据';
COMMENT ON COLUMN tb_matter_approve_material.remark IS '备注 ';
COMMENT ON COLUMN tb_matter_approve_material.is_effective IS '材料是否有效‘Y’有效，‘N’无效';
COMMENT ON COLUMN tb_matter_approve_material.cd_operation IS '同步类型';
COMMENT ON COLUMN tb_matter_approve_material.cd_batch IS '每次交换应唯一';
COMMENT ON COLUMN tb_matter_approve_material.last_update_time IS '数据同步时间';
COMMENT ON COLUMN tb_matter_approve_material.remark1 IS '备用字段1';
COMMENT ON COLUMN tb_matter_approve_material.remark2 IS '备用字段2';
COMMENT ON COLUMN tb_matter_approve_material.remark3 IS '是否需要提交：Y：提交；N：无需提交';
COMMENT ON COLUMN tb_matter_approve_material.remark4 IS '备用字段4';
COMMENT ON COLUMN tb_matter_approve_material.remark5 IS '备用字段5';
COMMENT ON COLUMN tb_matter_approve_material.create_time IS 'create_time';
COMMENT ON COLUMN tb_matter_approve_material.update_time IS 'update_time';
COMMENT ON COLUMN tb_matter_approve_material."source" IS '来源';
COMMENT ON COLUMN tb_matter_approve_material.material_num IS '纸质材料份数';
COMMENT ON COLUMN tb_matter_approve_material.material_property IS '材料性质';
COMMENT ON COLUMN tb_matter_approve_material.sample_tab IS '示例样表';
COMMENT ON COLUMN tb_matter_approve_material.certificate IS '电子证照';
COMMENT ON COLUMN tb_matter_approve_material.blank_tab IS '空白表格';


-- tb_matter_approve_result definition

-- Drop table

-- DROP TABLE tb_matter_approve_result;

CREATE TABLE tb_matter_approve_result (
	id bpchar(36) NOT NULL,
	dept_code varchar(64) NULL DEFAULT ''::character varying,
	area_code varchar(64) NULL DEFAULT ''::character varying,
	attach_id varchar(500) NULL DEFAULT ''::character varying,
	attach_code varchar(50) NULL DEFAULT ''::character varying,
	business_id varchar(50) NULL DEFAULT ''::character varying,
	attach_name varchar(500) NULL DEFAULT ''::character varying,
	attach_type varchar(50) NULL DEFAULT ''::character varying,
	attach_path varchar(255) NULL DEFAULT ''::character varying,
	attach_size numeric(8, 8) NULL DEFAULT 0,
	is_delete varchar(64) NULL DEFAULT ''::character varying,
	cd_operation varchar(64) NULL DEFAULT ''::character varying,
	cd_batch varchar(64) NULL DEFAULT ''::character varying,
	last_update_time timestamp(6) NULL,
	remark1 varchar(200) NULL DEFAULT ''::character varying,
	remark2 varchar(200) NULL DEFAULT ''::character varying,
	remark3 varchar(200) NULL DEFAULT ''::character varying,
	remark4 text NULL,
	remark5 text NULL,
	create_time timestamp(6) NULL,
	update_time timestamp(6) NULL,
	"source" varchar(6) NULL DEFAULT ''::character varying,
	CONSTRAINT tb_matter_approve_result_pk PRIMARY KEY (id)
);

-- Column comments

COMMENT ON COLUMN tb_matter_approve_result.dept_code IS '实施主体统一社会信用代码';
COMMENT ON COLUMN tb_matter_approve_result.area_code IS '区域编码';
COMMENT ON COLUMN tb_matter_approve_result.attach_id IS '附件ID';
COMMENT ON COLUMN tb_matter_approve_result.attach_code IS '附件编码';
COMMENT ON COLUMN tb_matter_approve_result.business_id IS '父表ID';
COMMENT ON COLUMN tb_matter_approve_result.attach_name IS '附件名称';
COMMENT ON COLUMN tb_matter_approve_result.attach_type IS '附件后缀';
COMMENT ON COLUMN tb_matter_approve_result.attach_path IS '附件路径';
COMMENT ON COLUMN tb_matter_approve_result.attach_size IS '附件大小';
COMMENT ON COLUMN tb_matter_approve_result.is_delete IS '附件是否已删除';
COMMENT ON COLUMN tb_matter_approve_result.cd_operation IS '同步类型';
COMMENT ON COLUMN tb_matter_approve_result.cd_batch IS '每次交换应唯一';
COMMENT ON COLUMN tb_matter_approve_result.last_update_time IS '每次交换应唯一';
COMMENT ON COLUMN tb_matter_approve_result.remark1 IS '省S3附件来源筒子名称';
COMMENT ON COLUMN tb_matter_approve_result.remark2 IS '备用字段2';
COMMENT ON COLUMN tb_matter_approve_result.remark3 IS '备用字段3';
COMMENT ON COLUMN tb_matter_approve_result.remark4 IS '备用字段4';
COMMENT ON COLUMN tb_matter_approve_result.remark5 IS '备用字段5';
COMMENT ON COLUMN tb_matter_approve_result.create_time IS 'create_time';
COMMENT ON COLUMN tb_matter_approve_result.update_time IS 'update_time';
COMMENT ON COLUMN tb_matter_approve_result."source" IS '来源';


-- tb_matter_files definition

-- Drop table

-- DROP TABLE tb_matter_files;

CREATE TABLE tb_matter_files (
	id bpchar(36) NOT NULL,
	approve_id varchar(128) NULL DEFAULT ''::character varying,
	data_type varchar(128) NULL DEFAULT ''::character varying,
	file_path varchar(2000) NULL DEFAULT ''::character varying,
	table_id varchar(128) NULL DEFAULT ''::character varying,
	"source" varchar(128) NULL DEFAULT ''::character varying,
	CONSTRAINT tb_matter_files_pk PRIMARY KEY (id)
);

-- Column comments

COMMENT ON COLUMN tb_matter_files.approve_id IS '事项ID';
COMMENT ON COLUMN tb_matter_files.data_type IS '区分数据';
COMMENT ON COLUMN tb_matter_files.file_path IS '文件地址';
COMMENT ON COLUMN tb_matter_files.table_id IS '数据表ID';
COMMENT ON COLUMN tb_matter_files."source" IS '来源1平台2一体化';


-- tb_matter_force_check_info definition

-- Drop table

-- DROP TABLE tb_matter_force_check_info;

CREATE TABLE tb_matter_force_check_info (
	id bpchar(36) NOT NULL,
	dept_code varchar(128) NULL DEFAULT ''::character varying,
	area_code varchar(128) NULL DEFAULT ''::character varying,
	approve_id varchar(128) NULL DEFAULT ''::character varying,
	row_guid varchar(128) NULL DEFAULT ''::character varying,
	rights_code varchar(128) NULL DEFAULT ''::character varying,
	approve_code_main varchar(128) NULL DEFAULT ''::character varying,
	approve_name varchar(128) NULL DEFAULT ''::character varying,
	org_id varchar(128) NULL DEFAULT ''::character varying,
	duty_office varchar(128) NULL DEFAULT ''::character varying,
	type_code varchar(128) NULL DEFAULT ''::character varying,
	approve_state varchar(128) NULL DEFAULT ''::character varying,
	setting_gist_hyperlink text NULL,
	approve_source varchar(128) NULL DEFAULT ''::character varying,
	task_handle_item varchar(128) NULL DEFAULT ''::character varying,
	implementation_subject varchar(128) NULL DEFAULT ''::character varying,
	administrative_counterpart varchar(500) NULL DEFAULT ''::character varying,
	constraint_object varchar(500) NULL DEFAULT ''::character varying,
	constraint_measures varchar(2000) NULL DEFAULT ''::character varying,
	duty_approve_qz varchar(1000) NULL DEFAULT ''::character varying,
	examine_object varchar(500) NULL DEFAULT ''::character varying,
	duty_approve_jc varchar(1000) NULL DEFAULT ''::character varying,
	handing_procedures text NULL,
	result_name varchar(2000) NULL DEFAULT ''::character varying,
	commitment_limit varchar(500) NULL DEFAULT ''::character varying,
	result_delivery varchar(500) NULL DEFAULT ''::character varying,
	consult_tel text NULL,
	complaint_tel text NULL,
	transact_address varchar(2000) NULL DEFAULT ''::character varying,
	work_time varchar(500) NULL DEFAULT ''::character varying,
	approve_code varchar(128) NULL DEFAULT ''::character varying,
	rights_id varchar(128) NULL DEFAULT ''::character varying,
	father_child varchar(128) NULL DEFAULT ''::character varying,
	power_source varchar(128) NULL DEFAULT ''::character varying,
	parent_code varchar(128) NULL DEFAULT ''::character varying,
	setting_gist text NULL,
	is_all_right varchar(128) NULL DEFAULT ''::character varying,
	version_num int4 NULL DEFAULT 0,
	local_catalog_code varchar(128) NULL DEFAULT ''::character varying,
	local_task_code varchar(128) NULL DEFAULT ''::character varying,
	entrust_name varchar(128) NULL DEFAULT ''::character varying,
	anticipate_day int4 NULL DEFAULT 0,
	anticipate_type varchar(128) NULL DEFAULT ''::character varying,
	anticipate_explain text NULL,
	plan_effective_date timestamp(6) NULL,
	plan_cancel_date timestamp(6) NULL,
	create_time timestamp(6) NULL,
	last_update_time timestamp(6) NULL,
	cd_operation varchar(128) NULL DEFAULT ''::character varying,
	cd_batch varchar(128) NULL DEFAULT ''::character varying,
	remark1 varchar(2000) NULL DEFAULT ''::character varying,
	remark2 varchar(2000) NULL DEFAULT ''::character varying,
	remark3 varchar(2000) NULL DEFAULT ''::character varying,
	remark4 text NULL,
	remark5 text NULL,
	"source" varchar(128) NULL DEFAULT ''::character varying,
	administrative_type varchar(200) NULL DEFAULT ''::character varying,
	duty_item text NULL,
	transact_area varchar(1000) NULL DEFAULT ''::character varying,
	transact_area_name varchar(1000) NULL DEFAULT ''::character varying,
	flow_img varchar(128) NULL DEFAULT ''::character varying,
	result_file varchar(2000) NULL DEFAULT ''::character varying,
	org_name varchar(1000) NULL DEFAULT ''::character varying,
	business_type varchar(128) NULL DEFAULT ''::character varying,
	CONSTRAINT tb_matter_force_check_info_pk PRIMARY KEY (id)
);

-- Column comments

COMMENT ON COLUMN tb_matter_force_check_info.dept_code IS '实施主体统一社会信用代码';
COMMENT ON COLUMN tb_matter_force_check_info.area_code IS '区域编码';
COMMENT ON COLUMN tb_matter_force_check_info.approve_id IS '事项ID';
COMMENT ON COLUMN tb_matter_force_check_info.row_guid IS '记录唯一标识';
COMMENT ON COLUMN tb_matter_force_check_info.rights_code IS '基本编码';
COMMENT ON COLUMN tb_matter_force_check_info.approve_code_main IS '主事项编码';
COMMENT ON COLUMN tb_matter_force_check_info.approve_name IS '事项名称';
COMMENT ON COLUMN tb_matter_force_check_info.org_id IS '机构ID';
COMMENT ON COLUMN tb_matter_force_check_info.duty_office IS '责任处（科）室';
COMMENT ON COLUMN tb_matter_force_check_info.type_code IS '事项类型';
COMMENT ON COLUMN tb_matter_force_check_info.approve_state IS '事项状态';
COMMENT ON COLUMN tb_matter_force_check_info.setting_gist_hyperlink IS '实施依据超链接';
COMMENT ON COLUMN tb_matter_force_check_info.approve_source IS '行使层级';
COMMENT ON COLUMN tb_matter_force_check_info.task_handle_item IS '业务办理项编码';
COMMENT ON COLUMN tb_matter_force_check_info.implementation_subject IS '实施主体性质';
COMMENT ON COLUMN tb_matter_force_check_info.administrative_counterpart IS '行政相对人权利';
COMMENT ON COLUMN tb_matter_force_check_info.constraint_object IS '强制对象(强制类才有值)';
COMMENT ON COLUMN tb_matter_force_check_info.constraint_measures IS '强制措施(强制类才有值)';
COMMENT ON COLUMN tb_matter_force_check_info.duty_approve_qz IS '强制事项(强制类才有值)';
COMMENT ON COLUMN tb_matter_force_check_info.examine_object IS '检查对象(检查类才有值)';
COMMENT ON COLUMN tb_matter_force_check_info.duty_approve_jc IS '检查事项(检查类才有值)';
COMMENT ON COLUMN tb_matter_force_check_info.handing_procedures IS '办理流程';
COMMENT ON COLUMN tb_matter_force_check_info.result_name IS '结果名称';
COMMENT ON COLUMN tb_matter_force_check_info.commitment_limit IS '办结时限(强制类才有值)';
COMMENT ON COLUMN tb_matter_force_check_info.result_delivery IS '办理结果送达方式';
COMMENT ON COLUMN tb_matter_force_check_info.consult_tel IS '咨询方式';
COMMENT ON COLUMN tb_matter_force_check_info.complaint_tel IS '监督投诉方式';
COMMENT ON COLUMN tb_matter_force_check_info.transact_address IS '办理地址';
COMMENT ON COLUMN tb_matter_force_check_info.work_time IS '办理时间';
COMMENT ON COLUMN tb_matter_force_check_info.approve_code IS '实施编码';
COMMENT ON COLUMN tb_matter_force_check_info.rights_id IS '目录ID';
COMMENT ON COLUMN tb_matter_force_check_info.father_child IS '父子关系 F：父项；C：子项';
COMMENT ON COLUMN tb_matter_force_check_info.power_source IS '权力来源';
COMMENT ON COLUMN tb_matter_force_check_info.parent_code IS '父编码';
COMMENT ON COLUMN tb_matter_force_check_info.setting_gist IS '设定依据';
COMMENT ON COLUMN tb_matter_force_check_info.is_all_right IS '是否全权下放（Y:是  N:否）';
COMMENT ON COLUMN tb_matter_force_check_info.version_num IS '事项版本';
COMMENT ON COLUMN tb_matter_force_check_info.local_catalog_code IS '地方基本编码';
COMMENT ON COLUMN tb_matter_force_check_info.local_task_code IS '地方实施编码';
COMMENT ON COLUMN tb_matter_force_check_info.entrust_name IS '委托部门';
COMMENT ON COLUMN tb_matter_force_check_info.anticipate_day IS '法定办结时限';
COMMENT ON COLUMN tb_matter_force_check_info.anticipate_type IS '法定办结时限单位';
COMMENT ON COLUMN tb_matter_force_check_info.anticipate_explain IS '法定办结时限说明';
COMMENT ON COLUMN tb_matter_force_check_info.plan_effective_date IS '计划生效时间';
COMMENT ON COLUMN tb_matter_force_check_info.plan_cancel_date IS '计划取消时间';
COMMENT ON COLUMN tb_matter_force_check_info.create_time IS '创建时间';
COMMENT ON COLUMN tb_matter_force_check_info.last_update_time IS '数据同步时间';
COMMENT ON COLUMN tb_matter_force_check_info.cd_operation IS '同步类型：I-插入，U-更新，D-删除';
COMMENT ON COLUMN tb_matter_force_check_info.cd_batch IS '每次交换应唯一，用于数据对账';
COMMENT ON COLUMN tb_matter_force_check_info.remark1 IS '备用字段1';
COMMENT ON COLUMN tb_matter_force_check_info.remark2 IS '备用字段2';
COMMENT ON COLUMN tb_matter_force_check_info.remark3 IS '备用字段3';
COMMENT ON COLUMN tb_matter_force_check_info.remark4 IS '备用字段4';
COMMENT ON COLUMN tb_matter_force_check_info.remark5 IS '备用字段5';
COMMENT ON COLUMN tb_matter_force_check_info."source" IS '来源';
COMMENT ON COLUMN tb_matter_force_check_info.administrative_type IS '行政相对人类型';
COMMENT ON COLUMN tb_matter_force_check_info.duty_item IS '责任事项';
COMMENT ON COLUMN tb_matter_force_check_info.transact_area IS '办理地址行政区代码';
COMMENT ON COLUMN tb_matter_force_check_info.transact_area_name IS '办理地址行政区名称';
COMMENT ON COLUMN tb_matter_force_check_info.flow_img IS '流程图';
COMMENT ON COLUMN tb_matter_force_check_info.result_file IS '结果名称文件';
COMMENT ON COLUMN tb_matter_force_check_info.org_name IS '实施机构名称';
COMMENT ON COLUMN tb_matter_force_check_info.business_type IS '业务类型';


-- tb_matter_info definition

-- Drop table

-- DROP TABLE tb_matter_info;

CREATE TABLE tb_matter_info (
	id bpchar(36) NOT NULL,
	rights_id varchar(64) NULL DEFAULT ''::character varying,
	rights_code varchar(64) NULL DEFAULT ''::character varying,
	parent_code varchar(64) NULL DEFAULT ''::character varying,
	rights_name varchar(1000) NULL DEFAULT ''::character varying,
	rights_eng_name varchar(2000) NULL DEFAULT ''::character varying,
	type_code varchar(255) NULL DEFAULT ''::character varying,
	rights_state varchar(255) NULL DEFAULT ''::character varying,
	version_num int4 NULL DEFAULT 0,
	parent_name varchar(2000) NULL DEFAULT ''::character varying,
	industry_code varchar(255) NULL DEFAULT ''::character varying,
	industry_name varchar(255) NULL DEFAULT ''::character varying,
	scheme_levels varchar(255) NULL DEFAULT ''::character varying,
	"according" text NULL,
	local_catalog_code varchar(255) NULL DEFAULT ''::character varying,
	plan_effective_date timestamp(6) NULL,
	plan_cancel_date timestamp(6) NULL,
	cd_operation varchar(255) NULL DEFAULT ''::character varying,
	cd_batch varchar(255) NULL DEFAULT ''::character varying,
	last_update_time timestamp(6) NULL,
	remark1 varchar(2000) NULL DEFAULT ''::character varying,
	remark2 varchar(2000) NULL DEFAULT ''::character varying,
	remark3 varchar(2000) NULL DEFAULT ''::character varying,
	remark4 text NULL,
	remark5 text NULL,
	"source" varchar(6) NULL DEFAULT ''::character varying,
	dept_code varchar(128) NULL DEFAULT ''::character varying,
	dept_name varchar(1000) NULL DEFAULT ''::character varying,
	responsibility_office varchar(128) NULL DEFAULT ''::character varying,
	platform varchar(500) NULL DEFAULT ''::character varying,
	item_relationship varchar(128) NULL DEFAULT ''::character varying,
	dept_id varchar(128) NULL DEFAULT ''::character varying,
	approve_id varchar(128) NULL DEFAULT ''::character varying,
	approve_code varchar(128) NULL DEFAULT ''::character varying,
	business_type varchar(128) NULL DEFAULT ''::character varying,
	task_handle_item varchar(128) NULL DEFAULT ''::character varying,
	transact_level varchar(255) NULL DEFAULT ''::character varying,
	server_object varchar(128) NULL DEFAULT ''::character varying,
	commitment_limit varchar(128) NULL,
	commitment_limit_unit varchar(128) NULL,
	approve_limit varchar(128) NULL DEFAULT ''::character varying,
	approve_limit_unit varchar(128) NULL DEFAULT ''::character varying,
	is_can_do varchar(128) NULL DEFAULT '0'::character varying,
	parent_id varchar(128) NULL DEFAULT ''::character varying,
	power_source varchar(128) NULL DEFAULT ''::character varying,
	CONSTRAINT tb_matter_info_pk PRIMARY KEY (id)
);

-- Column comments

COMMENT ON COLUMN tb_matter_info.rights_id IS '目录ID';
COMMENT ON COLUMN tb_matter_info.rights_code IS '基本编码';
COMMENT ON COLUMN tb_matter_info.parent_code IS '目录父编码';
COMMENT ON COLUMN tb_matter_info.rights_name IS '事项名称';
COMMENT ON COLUMN tb_matter_info.rights_eng_name IS '事项英文名称';
COMMENT ON COLUMN tb_matter_info.type_code IS '事项类型';
COMMENT ON COLUMN tb_matter_info.rights_state IS '目录状态';
COMMENT ON COLUMN tb_matter_info.version_num IS '版本号';
COMMENT ON COLUMN tb_matter_info.parent_name IS '父事项名称';
COMMENT ON COLUMN tb_matter_info.industry_code IS '行业编码';
COMMENT ON COLUMN tb_matter_info.industry_name IS '行业名称';
COMMENT ON COLUMN tb_matter_info.scheme_levels IS '行使层级';
COMMENT ON COLUMN tb_matter_info."according" IS '设定依据';
COMMENT ON COLUMN tb_matter_info.local_catalog_code IS '地方基本编码';
COMMENT ON COLUMN tb_matter_info.plan_effective_date IS '计划生效时间';
COMMENT ON COLUMN tb_matter_info.plan_cancel_date IS '计划取消时间';
COMMENT ON COLUMN tb_matter_info.cd_operation IS '同步类型';
COMMENT ON COLUMN tb_matter_info.cd_batch IS '每次交换应唯一';
COMMENT ON COLUMN tb_matter_info.last_update_time IS '数据同步时间';
COMMENT ON COLUMN tb_matter_info.remark1 IS '备用字段1';
COMMENT ON COLUMN tb_matter_info.remark2 IS '备用字段2';
COMMENT ON COLUMN tb_matter_info.remark3 IS '备用字段3';
COMMENT ON COLUMN tb_matter_info.remark4 IS '备用字段4';
COMMENT ON COLUMN tb_matter_info.remark5 IS '备用字段5';
COMMENT ON COLUMN tb_matter_info."source" IS '来源';
COMMENT ON COLUMN tb_matter_info.dept_code IS '实施主体统一社会信用代码';
COMMENT ON COLUMN tb_matter_info.dept_name IS '实施主体名称';
COMMENT ON COLUMN tb_matter_info.responsibility_office IS '责任处室';
COMMENT ON COLUMN tb_matter_info.platform IS '适用平台';
COMMENT ON COLUMN tb_matter_info.item_relationship IS '事项关系';
COMMENT ON COLUMN tb_matter_info.dept_id IS '实施机构ID';
COMMENT ON COLUMN tb_matter_info.approve_id IS '事项ID';
COMMENT ON COLUMN tb_matter_info.approve_code IS '事项编码';
COMMENT ON COLUMN tb_matter_info.business_type IS '业务类型';
COMMENT ON COLUMN tb_matter_info.task_handle_item IS '业务办理项编码';
COMMENT ON COLUMN tb_matter_info.transact_level IS '办理深度';
COMMENT ON COLUMN tb_matter_info.server_object IS '服务对象';
COMMENT ON COLUMN tb_matter_info.commitment_limit IS '办结时限';
COMMENT ON COLUMN tb_matter_info.commitment_limit_unit IS '办结时限单位';
COMMENT ON COLUMN tb_matter_info.approve_limit IS '法定期限';
COMMENT ON COLUMN tb_matter_info.approve_limit_unit IS '法定期限特殊情况说明';
COMMENT ON COLUMN tb_matter_info.is_can_do IS '是否可办理：1 是可办理 0 是不可办理';
COMMENT ON COLUMN tb_matter_info.parent_id IS '父事项id';
COMMENT ON COLUMN tb_matter_info.power_source IS '权利来源';


-- tb_matter_inter_services definition

-- Drop table

-- DROP TABLE tb_matter_inter_services;

CREATE TABLE tb_matter_inter_services (
	id bpchar(36) NOT NULL,
	service_id varchar(128) NULL DEFAULT ''::character varying,
	service_item_name varchar(2000) NULL DEFAULT ''::character varying,
	service_org_property varchar(2000) NULL DEFAULT ''::character varying,
	service_time_limit int4 NULL DEFAULT 0,
	charge_desc varchar(2000) NULL DEFAULT ''::character varying,
	approve_id varchar(128) NULL DEFAULT ''::character varying,
	service_explain varchar(2000) NULL DEFAULT ''::character varying,
	last_update_time timestamp(6) NULL,
	mod_flag varchar(128) NULL DEFAULT ''::character varying,
	remark1 varchar(128) NULL DEFAULT ''::character varying,
	remark2 varchar(128) NULL DEFAULT ''::character varying,
	remark3 varchar(128) NULL DEFAULT ''::character varying,
	remark4 text NULL,
	remark5 text NULL,
	is_delete varchar(128) NULL DEFAULT ''::character varying,
	"source" varchar(128) NULL DEFAULT ''::character varying,
	CONSTRAINT tb_matter_inter_services_pk PRIMARY KEY (id)
);

-- Column comments

COMMENT ON COLUMN tb_matter_inter_services.service_id IS '中介服务id';
COMMENT ON COLUMN tb_matter_inter_services.service_item_name IS '服务项目名称';
COMMENT ON COLUMN tb_matter_inter_services.service_org_property IS '服务机构性质';
COMMENT ON COLUMN tb_matter_inter_services.service_time_limit IS '服务时限';
COMMENT ON COLUMN tb_matter_inter_services.charge_desc IS '收费说明';
COMMENT ON COLUMN tb_matter_inter_services.approve_id IS '事项ID';
COMMENT ON COLUMN tb_matter_inter_services.service_explain IS '服务时限说明';
COMMENT ON COLUMN tb_matter_inter_services.last_update_time IS '数据同步时间';
COMMENT ON COLUMN tb_matter_inter_services.mod_flag IS '数据操作增量标志位';
COMMENT ON COLUMN tb_matter_inter_services.remark1 IS '备用字段1';
COMMENT ON COLUMN tb_matter_inter_services.remark2 IS '备用字段2';
COMMENT ON COLUMN tb_matter_inter_services.remark3 IS '备用字段3';
COMMENT ON COLUMN tb_matter_inter_services.remark4 IS '备用字段4';
COMMENT ON COLUMN tb_matter_inter_services.remark5 IS '备用字段5';
COMMENT ON COLUMN tb_matter_inter_services.is_delete IS '是否删除';
COMMENT ON COLUMN tb_matter_inter_services."source" IS '来源';


-- tb_matter_law_info definition

-- Drop table

-- DROP TABLE tb_matter_law_info;

CREATE TABLE tb_matter_law_info (
	id bpchar(36) NOT NULL,
	approve_id varchar(128) NULL,
	law_id varchar(128) NULL,
	law_title varchar(2000) NULL,
	law_detail text NULL,
	link_id varchar(128) NULL,
	order_no int4 NULL DEFAULT 0,
	object_id varchar(128) NULL DEFAULT ''::character varying,
	CONSTRAINT tb_matter_law_info_pk PRIMARY KEY (id)
);

-- Column comments

COMMENT ON COLUMN tb_matter_law_info.approve_id IS '事项ID';
COMMENT ON COLUMN tb_matter_law_info.law_id IS '法规ID';
COMMENT ON COLUMN tb_matter_law_info.law_title IS '法规标题';
COMMENT ON COLUMN tb_matter_law_info.law_detail IS '依据条款信息';
COMMENT ON COLUMN tb_matter_law_info.link_id IS '关联ID如办事指南ID等';
COMMENT ON COLUMN tb_matter_law_info.order_no IS '顺序编号';
COMMENT ON COLUMN tb_matter_law_info.object_id IS '查询唯一id';


-- tb_matter_organization definition

-- Drop table

-- DROP TABLE tb_matter_organization;

CREATE TABLE tb_matter_organization (
	id bpchar(36) NOT NULL,
	dept_code varchar(128) NULL DEFAULT ''::character varying,
	area_code varchar(128) NULL DEFAULT ''::character varying,
	row_guid varchar(128) NULL DEFAULT ''::character varying,
	org_id varchar(128) NULL DEFAULT ''::character varying,
	org_name varchar(128) NULL DEFAULT ''::character varying,
	org_show_name varchar(128) NULL DEFAULT ''::character varying,
	parent_id varchar(128) NULL DEFAULT ''::character varying,
	order_num int4 NULL DEFAULT 0,
	last_update_time timestamp(6) NULL,
	cd_operation varchar(128) NULL DEFAULT ''::character varying,
	cd_batch varchar(128) NULL DEFAULT ''::character varying,
	remark1 varchar(200) NULL DEFAULT ''::character varying,
	remark2 varchar(200) NULL DEFAULT ''::character varying,
	remark3 varchar(200) NULL DEFAULT ''::character varying,
	remark4 text NULL,
	remark5 text NULL,
	"source" varchar(128) NULL DEFAULT ''::character varying,
	pt_org_id varchar(128) NULL DEFAULT ''::character varying,
	CONSTRAINT tb_matter_organization_pk PRIMARY KEY (id)
);

-- Column comments

COMMENT ON COLUMN tb_matter_organization.dept_code IS '实施主体统一社会信用代码';
COMMENT ON COLUMN tb_matter_organization.area_code IS '区域编码';
COMMENT ON COLUMN tb_matter_organization.row_guid IS '记录唯一标识码';
COMMENT ON COLUMN tb_matter_organization.org_id IS '机构ID';
COMMENT ON COLUMN tb_matter_organization.org_name IS '机构名称';
COMMENT ON COLUMN tb_matter_organization.org_show_name IS '机构显示名称';
COMMENT ON COLUMN tb_matter_organization.parent_id IS '机构父ID';
COMMENT ON COLUMN tb_matter_organization.order_num IS '排序号';
COMMENT ON COLUMN tb_matter_organization.last_update_time IS '数据同步时间';
COMMENT ON COLUMN tb_matter_organization.cd_operation IS '同步类型：I-插入，U-更新，D-删除';
COMMENT ON COLUMN tb_matter_organization.cd_batch IS '每次交换应唯一，用于数据对账';
COMMENT ON COLUMN tb_matter_organization.remark1 IS '省网厅是否展示（‘1’展示，‘0’不展示）';
COMMENT ON COLUMN tb_matter_organization.remark2 IS '备用字段2';
COMMENT ON COLUMN tb_matter_organization.remark3 IS '备用字段3';
COMMENT ON COLUMN tb_matter_organization.remark4 IS '备用字段4';
COMMENT ON COLUMN tb_matter_organization.remark5 IS '备用字段5';
COMMENT ON COLUMN tb_matter_organization."source" IS '来源';
COMMENT ON COLUMN tb_matter_organization.pt_org_id IS '对应平台组织机构ID';


-- tb_matter_platform definition

-- Drop table

-- DROP TABLE tb_matter_platform;

CREATE TABLE tb_matter_platform (
	id bpchar(36) NOT NULL,
	platform_code varchar(128) NULL DEFAULT ''::character varying,
	platform varchar(2000) NULL DEFAULT ''::character varying,
	form_type varchar(128) NULL DEFAULT ''::character varying,
	title_name varchar(1000) NULL DEFAULT ''::character varying,
	add_url varchar(128) NULL DEFAULT ''::character varying,
	title_pic varchar(128) NULL DEFAULT ''::character varying,
	approve_id varchar(128) NULL DEFAULT ''::character varying,
	integration_method varchar(128) NULL DEFAULT ''::character varying,
	accept_channel varchar(128) NULL DEFAULT ''::character varying,
	CONSTRAINT tb_matter_platform_pk PRIMARY KEY (id)
);

-- Column comments

COMMENT ON COLUMN tb_matter_platform.platform_code IS '平台编码';
COMMENT ON COLUMN tb_matter_platform.platform IS '平台名称';
COMMENT ON COLUMN tb_matter_platform.form_type IS '申请模式：1 通用 2 跳转 3 内嵌';
COMMENT ON COLUMN tb_matter_platform.title_name IS '标题名称';
COMMENT ON COLUMN tb_matter_platform.add_url IS '网页地址';
COMMENT ON COLUMN tb_matter_platform.title_pic IS '图标';
COMMENT ON COLUMN tb_matter_platform.approve_id IS '事项ID';
COMMENT ON COLUMN tb_matter_platform.integration_method IS '申报集成方式';
COMMENT ON COLUMN tb_matter_platform.accept_channel IS '受理渠道';


-- tb_matter_rights_info definition

-- Drop table

-- DROP TABLE tb_matter_rights_info;

CREATE TABLE tb_matter_rights_info (
	id varchar(64) NOT NULL DEFAULT ''::character varying,
	rights_id varchar(64) NOT NULL DEFAULT ''::character varying,
	rights_code varchar(64) NOT NULL DEFAULT ''::character varying,
	parent_code varchar(64) NULL DEFAULT ''::character varying,
	rights_name varchar(1000) NOT NULL DEFAULT ''::character varying,
	rights_eng_name varchar(4000) NULL DEFAULT ''::character varying,
	type_code varchar(255) NOT NULL DEFAULT ''::character varying,
	rights_state varchar(255) NOT NULL DEFAULT ''::character varying,
	version_num int4 NOT NULL DEFAULT 0,
	parent_name varchar(4000) NULL DEFAULT ''::character varying,
	industry_code varchar(255) NULL DEFAULT ''::character varying,
	industry_name varchar(255) NULL DEFAULT ''::character varying,
	scheme_levels varchar(255) NOT NULL DEFAULT ''::character varying,
	"according" text NULL DEFAULT ''::text,
	local_catalog_code varchar(255) NULL DEFAULT ''::character varying,
	plan_effective_date timestamp(6) NULL DEFAULT CURRENT_TIMESTAMP,
	plan_cancel_date timestamp(6) NULL DEFAULT CURRENT_TIMESTAMP,
	cd_operation varchar(255) NOT NULL DEFAULT ''::character varying,
	cd_batch varchar(255) NOT NULL DEFAULT ''::character varying,
	last_update_time timestamp(6) NOT NULL DEFAULT CURRENT_TIMESTAMP,
	remark1 text NULL DEFAULT ''::text,
	remark2 text NULL DEFAULT ''::text,
	remark3 text NULL DEFAULT ''::text,
	remark4 text NULL DEFAULT ''::text,
	remark5 text NULL DEFAULT ''::text,
	CONSTRAINT tb_matter_rights_info_pk PRIMARY KEY (id)
);
COMMENT ON TABLE tb_matter_rights_info IS '目录清单基本信息';

-- Column comments

COMMENT ON COLUMN tb_matter_rights_info.rights_id IS '目录ID记录唯一标识，取值为uuid,符合GB/T 17969.8-2010的规定';
COMMENT ON COLUMN tb_matter_rights_info.rights_code IS '基本编码';
COMMENT ON COLUMN tb_matter_rights_info.parent_code IS '目录父编码';
COMMENT ON COLUMN tb_matter_rights_info.rights_name IS '事项名称';
COMMENT ON COLUMN tb_matter_rights_info.rights_eng_name IS '事项英文名称（获取事项名称拼音首字母）';
COMMENT ON COLUMN tb_matter_rights_info.type_code IS '事项类型（字典数据为9.1）';
COMMENT ON COLUMN tb_matter_rights_info.rights_state IS '目录状态（0，新增；1，发布；2，驳回；3，取消；4，暂停；6，取消待审核）';
COMMENT ON COLUMN tb_matter_rights_info.version_num IS '版本号（目录每修改一次版本号加1）';
COMMENT ON COLUMN tb_matter_rights_info.parent_name IS '父事项名称';
COMMENT ON COLUMN tb_matter_rights_info.industry_code IS '行业编码（字典数据为9.30）';
COMMENT ON COLUMN tb_matter_rights_info.industry_name IS '行业名称';
COMMENT ON COLUMN tb_matter_rights_info.scheme_levels IS '行使层级（基本目录行使层级，有国家级、省级、市级、县级，可以多个层级组合，用符号“^”隔开。代码集为“行使层级”）';
COMMENT ON COLUMN tb_matter_rights_info."according" IS '设定依据';
COMMENT ON COLUMN tb_matter_rights_info.local_catalog_code IS '地方基本编码（地方基本目录基本编码）';
COMMENT ON COLUMN tb_matter_rights_info.plan_effective_date IS '计划生效时间（YYYY-MM-DD hh:mm:ss）';
COMMENT ON COLUMN tb_matter_rights_info.plan_cancel_date IS '计划取消时间（YYYY-MM-DD hh:mm:ss）';
COMMENT ON COLUMN tb_matter_rights_info.cd_operation IS '同步类型：I-插入，U-更新，D-删除';
COMMENT ON COLUMN tb_matter_rights_info.cd_batch IS '每次交换应唯一，用于数据对账';
COMMENT ON COLUMN tb_matter_rights_info.last_update_time IS '数据同步时间';
COMMENT ON COLUMN tb_matter_rights_info.remark1 IS '备用字段1';
COMMENT ON COLUMN tb_matter_rights_info.remark2 IS '备用字段2';
COMMENT ON COLUMN tb_matter_rights_info.remark3 IS '备用字段3';
COMMENT ON COLUMN tb_matter_rights_info.remark4 IS '备用字段4';
COMMENT ON COLUMN tb_matter_rights_info.remark5 IS '备用字段5';


-- tb_matter_services_guide definition

-- Drop table

-- DROP TABLE tb_matter_services_guide;

CREATE TABLE tb_matter_services_guide (
	id bpchar(36) NOT NULL,
	row_guid varchar(64) NULL DEFAULT ''::character varying,
	dept_code varchar(64) NULL DEFAULT ''::character varying,
	area_code varchar(64) NULL DEFAULT ''::character varying,
	approve_code varchar(64) NULL DEFAULT ''::character varying,
	approve_name varchar(1000) NULL DEFAULT ''::character varying,
	type_code varchar(255) NULL DEFAULT ''::character varying,
	setting_gist text NULL,
	transaction_from varchar(255) NULL DEFAULT ''::character varying,
	do_scope varchar(255) NULL DEFAULT ''::character varying,
	make_transaction varchar(255) NULL DEFAULT ''::character varying,
	online_payment varchar(255) NULL DEFAULT ''::character varying,
	logistics_express varchar(255) NULL DEFAULT ''::character varying,
	approve_id varchar(64) NULL DEFAULT ''::character varying,
	approve_limit numeric(10, 2) NULL DEFAULT 0,
	approve_limit_explain text NULL,
	commitment_limit numeric(10, 2) NULL DEFAULT 0,
	commitment_limit_explain text NULL,
	charge_standard varchar(2500) NULL DEFAULT ''::character varying,
	charge_gist text NULL,
	consult_tel varchar(2000) NULL DEFAULT ''::character varying,
	complaint_tel varchar(2000) NULL DEFAULT ''::character varying,
	transact_address varchar(500) NULL DEFAULT ''::character varying,
	work_time varchar(500) NULL DEFAULT ''::character varying,
	version_num int4 NULL DEFAULT 0,
	remark varchar(500) NULL DEFAULT ''::character varying,
	result_sample_name varchar(200) NULL DEFAULT ''::character varying,
	special_procedure varchar(500) NULL DEFAULT ''::character varying,
	is_valid varchar(255) NULL DEFAULT ''::character varying,
	anticipate_type varchar(255) NULL DEFAULT ''::character varying,
	promise_type varchar(255) NULL DEFAULT ''::character varying,
	handing_procedures text NULL,
	is_special_procedure varchar(255) NULL DEFAULT ''::character varying,
	special_procedure_type varchar(2000) NULL DEFAULT ''::character varying,
	special_procedure_time_limit int4 NULL DEFAULT 0,
	task_handle_item varchar(255) NULL DEFAULT ''::character varying,
	other_dept varchar(255) NULL DEFAULT ''::character varying,
	result_type varchar(255) NULL DEFAULT ''::character varying,
	is_service_terminals varchar(255) NULL DEFAULT ''::character varying,
	town_name varchar(255) NULL DEFAULT ''::character varying,
	town_code varchar(255) NULL DEFAULT ''::character varying,
	village_name varchar(255) NULL DEFAULT ''::character varying,
	village_code varchar(255) NULL DEFAULT ''::character varying,
	extend_field varchar(2000) NULL DEFAULT ''::character varying,
	is_entry_center varchar(255) NULL DEFAULT ''::character varying,
	result_guid varchar(256) NULL DEFAULT ''::character varying,
	cd_operation varchar(255) NULL DEFAULT ''::character varying,
	cd_batch varchar(255) NULL DEFAULT ''::character varying,
	last_update_time timestamp(6) NULL,
	remark1 varchar(200) NULL DEFAULT ''::character varying,
	remark2 varchar(200) NULL DEFAULT ''::character varying,
	remark3 varchar(200) NULL DEFAULT ''::character varying,
	remark4 text NULL,
	remark5 text NULL,
	create_time timestamp(6) NULL,
	update_time timestamp(6) NULL,
	"source" varchar(6) NULL DEFAULT ''::character varying,
	is_pay int4 NULL DEFAULT 0,
	area_address varchar(500) NULL DEFAULT ''::character varying,
	is_investment_apr int4 NULL DEFAULT 0,
	flow_memo varchar(2000) NULL DEFAULT ''::character varying,
	flow_file varchar(128) NULL DEFAULT ''::character varying,
	join_org varchar(500) NULL DEFAULT ''::character varying,
	approve_limit_unit varchar(128) NULL DEFAULT ''::character varying,
	commitment_limit_unit varchar(128) NULL DEFAULT ''::character varying,
	special_time_limit_unit varchar(128) NULL DEFAULT ''::character varying,
	province_code varchar(128) NULL DEFAULT ''::character varying,
	city_code varchar(128) NULL DEFAULT ''::character varying,
	district_county_code varchar(128) NULL DEFAULT ''::character varying,
	small_town_code varchar(128) NULL DEFAULT ''::character varying,
	CONSTRAINT tb_matter_services_guide_pk PRIMARY KEY (id)
);

-- Column comments

COMMENT ON COLUMN tb_matter_services_guide.row_guid IS '记录唯一标识';
COMMENT ON COLUMN tb_matter_services_guide.dept_code IS '实施主体统一社会信用代码';
COMMENT ON COLUMN tb_matter_services_guide.area_code IS '区域编码';
COMMENT ON COLUMN tb_matter_services_guide.approve_code IS '事项编码';
COMMENT ON COLUMN tb_matter_services_guide.approve_name IS '事项名称';
COMMENT ON COLUMN tb_matter_services_guide.type_code IS '事项类型';
COMMENT ON COLUMN tb_matter_services_guide.setting_gist IS '设定依据';
COMMENT ON COLUMN tb_matter_services_guide.transaction_from IS '办理形式';
COMMENT ON COLUMN tb_matter_services_guide.do_scope IS '通办范围';
COMMENT ON COLUMN tb_matter_services_guide.make_transaction IS '是否预约办理';
COMMENT ON COLUMN tb_matter_services_guide.online_payment IS '是否网上支付';
COMMENT ON COLUMN tb_matter_services_guide.logistics_express IS '是否物流快递';
COMMENT ON COLUMN tb_matter_services_guide.approve_id IS '事项ID';
COMMENT ON COLUMN tb_matter_services_guide.approve_limit IS '法定期限';
COMMENT ON COLUMN tb_matter_services_guide.approve_limit_explain IS '法定期限特殊情况说明';
COMMENT ON COLUMN tb_matter_services_guide.commitment_limit IS '承诺期限';
COMMENT ON COLUMN tb_matter_services_guide.commitment_limit_explain IS '承诺期限特殊情况说明';
COMMENT ON COLUMN tb_matter_services_guide.charge_standard IS '收费标准';
COMMENT ON COLUMN tb_matter_services_guide.charge_gist IS '收费依据.';
COMMENT ON COLUMN tb_matter_services_guide.consult_tel IS '咨询方式';
COMMENT ON COLUMN tb_matter_services_guide.complaint_tel IS '投诉方式';
COMMENT ON COLUMN tb_matter_services_guide.transact_address IS '办理地点';
COMMENT ON COLUMN tb_matter_services_guide.work_time IS '办理时间';
COMMENT ON COLUMN tb_matter_services_guide.version_num IS '实施清单版本号';
COMMENT ON COLUMN tb_matter_services_guide.remark IS '备注';
COMMENT ON COLUMN tb_matter_services_guide.result_sample_name IS '结果样本名称';
COMMENT ON COLUMN tb_matter_services_guide.special_procedure IS '特殊程序';
COMMENT ON COLUMN tb_matter_services_guide.is_valid IS '数据是否有效 Y有效 N 无效 默认为 Y';
COMMENT ON COLUMN tb_matter_services_guide.anticipate_type IS '法定办结时限单位';
COMMENT ON COLUMN tb_matter_services_guide.promise_type IS '承诺办结时限单位';
COMMENT ON COLUMN tb_matter_services_guide.handing_procedures IS '描述所涉及的法定程序和环节要求';
COMMENT ON COLUMN tb_matter_services_guide.is_special_procedure IS '是否特别程序申请';
COMMENT ON COLUMN tb_matter_services_guide.special_procedure_type IS '特别程序类型';
COMMENT ON COLUMN tb_matter_services_guide.special_procedure_time_limit IS '特别程序申请时限';
COMMENT ON COLUMN tb_matter_services_guide.task_handle_item IS '是否进驻政务大厅';
COMMENT ON COLUMN tb_matter_services_guide.other_dept IS '同一事项有两个以上实施主体';
COMMENT ON COLUMN tb_matter_services_guide.result_type IS '审批结果类型';
COMMENT ON COLUMN tb_matter_services_guide.is_service_terminals IS '是否支持自助终端办理';
COMMENT ON COLUMN tb_matter_services_guide.town_name IS '行使该事项的乡镇街道名称';
COMMENT ON COLUMN tb_matter_services_guide.town_code IS '行使该事项的乡镇街道统一社会信用代码';
COMMENT ON COLUMN tb_matter_services_guide.village_name IS '行使该事项的村居社区名称';
COMMENT ON COLUMN tb_matter_services_guide.village_code IS '行使该事项的村居社区统一社会信用代码';
COMMENT ON COLUMN tb_matter_services_guide.extend_field IS '预留备用扩展字段';
COMMENT ON COLUMN tb_matter_services_guide.is_entry_center IS '是否进驻政务大厅代';
COMMENT ON COLUMN tb_matter_services_guide.result_guid IS '审批结果样本';
COMMENT ON COLUMN tb_matter_services_guide.cd_operation IS '同步类型';
COMMENT ON COLUMN tb_matter_services_guide.cd_batch IS '每次交换应唯一';
COMMENT ON COLUMN tb_matter_services_guide.last_update_time IS '数据同步时间';
COMMENT ON COLUMN tb_matter_services_guide.remark1 IS '备用字段1';
COMMENT ON COLUMN tb_matter_services_guide.remark2 IS '备用字段2';
COMMENT ON COLUMN tb_matter_services_guide.remark3 IS '备用字段3';
COMMENT ON COLUMN tb_matter_services_guide.remark4 IS '备用字段4';
COMMENT ON COLUMN tb_matter_services_guide.remark5 IS '备用字段5';
COMMENT ON COLUMN tb_matter_services_guide.create_time IS 'create_time';
COMMENT ON COLUMN tb_matter_services_guide.update_time IS 'update_time';
COMMENT ON COLUMN tb_matter_services_guide."source" IS '来源';
COMMENT ON COLUMN tb_matter_services_guide.is_pay IS '是否收费';
COMMENT ON COLUMN tb_matter_services_guide.area_address IS '办理地址所在区域';
COMMENT ON COLUMN tb_matter_services_guide.is_investment_apr IS '是否投资审批项目';
COMMENT ON COLUMN tb_matter_services_guide.flow_memo IS '流程说明';
COMMENT ON COLUMN tb_matter_services_guide.flow_file IS '办理流程文件';
COMMENT ON COLUMN tb_matter_services_guide.join_org IS '联办机构';
COMMENT ON COLUMN tb_matter_services_guide.approve_limit_unit IS '法定办结时限单位';
COMMENT ON COLUMN tb_matter_services_guide.commitment_limit_unit IS '承诺期限单位';
COMMENT ON COLUMN tb_matter_services_guide.special_time_limit_unit IS '特别程序申请时限';
COMMENT ON COLUMN tb_matter_services_guide.province_code IS '省编码';
COMMENT ON COLUMN tb_matter_services_guide.city_code IS '市编码';
COMMENT ON COLUMN tb_matter_services_guide.district_county_code IS '区县编码';
COMMENT ON COLUMN tb_matter_services_guide.small_town_code IS '乡镇街道编码';

-- tb_proxy_access_roll definition

-- Drop table

-- DROP TABLE tb_proxy_access_roll;

CREATE TABLE tb_proxy_access_roll (
	f_id varchar(50) NOT NULL,
	f_resourceid varchar(50) NULL,
	f_authorizerid varchar(255) NULL,
	f_roll int2 NULL,
	CONSTRAINT pk_proxy_access_roll PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_proxy_access_roll.f_resourceid IS '服务的ID';
COMMENT ON COLUMN tb_proxy_access_roll.f_authorizerid IS '授权对象的ID';
COMMENT ON COLUMN tb_proxy_access_roll.f_roll IS '0.白名单   1.黑名单';


-- tb_proxy_access_statistics definition

-- Drop table

-- DROP TABLE tb_proxy_access_statistics;

CREATE TABLE tb_proxy_access_statistics (
	f_id varchar(32) NOT NULL,
	f_accesscount int8 NULL,
	f_exception int8 NULL,
	f_costtime float8 NULL,
	f_accesstime timestamp NULL,
	f_precision int2 NOT NULL,
	f_accessid varchar(255) NULL,
	f_accesstype int2 NULL,
	f_resourceid varchar(50) NULL,
	f_resourcetype int2 NULL,
	f_params text NULL,
	f_authorizetoken varchar(255) NULL,
	CONSTRAINT pk_proxy_access_statistics PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_proxy_access_statistics.f_accesscount IS '访问量';
COMMENT ON COLUMN tb_proxy_access_statistics.f_exception IS '访问异常数';
COMMENT ON COLUMN tb_proxy_access_statistics.f_costtime IS '访问耗时';
COMMENT ON COLUMN tb_proxy_access_statistics.f_accesstime IS '统计日期';
COMMENT ON COLUMN tb_proxy_access_statistics.f_precision IS '查询的精度（ 2.年  0.天 ）';
COMMENT ON COLUMN tb_proxy_access_statistics.f_accessid IS '访问对象 id';
COMMENT ON COLUMN tb_proxy_access_statistics.f_accesstype IS '访问对象的类型（ 0.用户 1.部门 2.应用 ）';
COMMENT ON COLUMN tb_proxy_access_statistics.f_resourceid IS '服务资源 id';
COMMENT ON COLUMN tb_proxy_access_statistics.f_resourcetype IS '服务的类型 （ 0.数据 1.分析 2.组件 3.其他）';
COMMENT ON COLUMN tb_proxy_access_statistics.f_params IS '扩展参数';
COMMENT ON COLUMN tb_proxy_access_statistics.f_authorizetoken IS '代理服务令牌';


-- tb_proxy_authorize_token definition

-- Drop table

-- DROP TABLE tb_proxy_authorize_token;

CREATE TABLE tb_proxy_authorize_token (
	f_id varchar(50) NOT NULL,
	f_token varchar(255) NULL,
	f_resourceid varchar(50) NULL DEFAULT ''::character varying,
	f_relativeurl varchar(255) NULL,
	f_indate date NULL,
	f_status int4 NULL,
	f_updatetime date NULL,
	f_authorization varchar(255) NULL DEFAULT ''::character varying,
	f_authorizeway int4 NULL,
	f_resourcetype int4 NULL,
	f_params text NULL,
	f_authorizertype int4 NULL,
	f_authorizerid varchar(255) NULL,
	f_authorizername varchar(255) NULL,
	f_applyid varchar(255) NULL,
	f_url varchar(255) NULL,
	f_frequency text NULL,
	f_ipscope varchar(255) NULL,
	f_xzqlimit varchar(255) NULL,
	CONSTRAINT pk_proxy_authorize_token PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_proxy_authorize_token.f_token IS 'token值';
COMMENT ON COLUMN tb_proxy_authorize_token.f_resourceid IS '资源id';
COMMENT ON COLUMN tb_proxy_authorize_token.f_relativeurl IS '相对路径 ';
COMMENT ON COLUMN tb_proxy_authorize_token.f_indate IS '有效期';
COMMENT ON COLUMN tb_proxy_authorize_token.f_status IS '状态 （0.有效  1.过期）';
COMMENT ON COLUMN tb_proxy_authorize_token.f_updatetime IS '授权时间';
COMMENT ON COLUMN tb_proxy_authorize_token.f_authorization IS '授权者或授权单位（存ID）';
COMMENT ON COLUMN tb_proxy_authorize_token.f_authorizeway IS '授权方式（针对于用户：0为主动，1为申请）';
COMMENT ON COLUMN tb_proxy_authorize_token.f_resourcetype IS '资源类型 ( 4.数据服务 5.分析服务  6.组件服务 7.云资源服务 )';
COMMENT ON COLUMN tb_proxy_authorize_token.f_params IS '额外参数';
COMMENT ON COLUMN tb_proxy_authorize_token.f_authorizertype IS '授权对象类型（0.用户  1.部门   2.应用）';
COMMENT ON COLUMN tb_proxy_authorize_token.f_authorizerid IS '授权对象Id';
COMMENT ON COLUMN tb_proxy_authorize_token.f_authorizername IS '授权对象名称';
COMMENT ON COLUMN tb_proxy_authorize_token.f_applyid IS '申请表Id';
COMMENT ON COLUMN tb_proxy_authorize_token.f_xzqlimit IS '行政区限制';


-- tb_proxy_temp_statistics definition

-- Drop table

-- DROP TABLE tb_proxy_temp_statistics;

CREATE TABLE tb_proxy_temp_statistics (
	f_id varchar(32) NOT NULL,
	f_accessid varchar(255) NULL,
	f_accesstype int2 NULL,
	f_resourceid varchar(50) NULL,
	f_resourcetype int2 NULL,
	f_authorizetoken varchar(255) NULL,
	f_params text NULL,
	f_time timestamp NULL,
	f_costtime float8 NULL,
	f_accesscount int8 NULL,
	f_exception int8 NULL,
	CONSTRAINT pk_proxy_temp_statistics PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_proxy_temp_statistics.f_accessid IS '访问对象 id';
COMMENT ON COLUMN tb_proxy_temp_statistics.f_accesstype IS '访问对象的类型（ 0.用户  1.应用 ）';
COMMENT ON COLUMN tb_proxy_temp_statistics.f_resourceid IS '服务资源 id';
COMMENT ON COLUMN tb_proxy_temp_statistics.f_resourcetype IS '服务的类型 （ 0.数据 1.分析 2.组件 3.其他）';
COMMENT ON COLUMN tb_proxy_temp_statistics.f_authorizetoken IS '代理服务令牌';
COMMENT ON COLUMN tb_proxy_temp_statistics.f_params IS '扩展参数';
COMMENT ON COLUMN tb_proxy_temp_statistics.f_time IS '访问时间 时分秒';
COMMENT ON COLUMN tb_proxy_temp_statistics.f_costtime IS '访问耗时';
COMMENT ON COLUMN tb_proxy_temp_statistics.f_accesscount IS '访问量';
COMMENT ON COLUMN tb_proxy_temp_statistics.f_exception IS '访问异常数';


-- tb_share4_analysisservice definition

-- Drop table

-- DROP TABLE tb_share4_analysisservice;

CREATE TABLE tb_share4_analysisservice (
	f_id varchar(50) NOT NULL,
	f_method int2 NULL DEFAULT 1,
	f_requestexample text NULL,
	f_reponseexample text NULL,
	f_producetime timestamp NULL,
	f_produceunit text NULL,
	f_srs varchar(128) NULL,
	f_updatetime timestamp NULL,
	f_inputparams text NULL,
	f_outputparams text NULL,
	f_responsetime int4 NULL,
	f_concurrent int4 NULL,
	f_colony varchar(255) NULL,
	f_involvedata text NULL,
	f_isdel int2 NULL DEFAULT 0,
	CONSTRAINT pk_tb_share4_analysisservice_id PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share4_analysisservice.f_method IS 'Get/Post  默认 1.get 2.post 3.put 4.delete 5.get,post  6.all';
COMMENT ON COLUMN tb_share4_analysisservice.f_requestexample IS '请求示例';
COMMENT ON COLUMN tb_share4_analysisservice.f_reponseexample IS '返回示例';
COMMENT ON COLUMN tb_share4_analysisservice.f_producetime IS '数据生产时间';
COMMENT ON COLUMN tb_share4_analysisservice.f_produceunit IS '数据生产单位';
COMMENT ON COLUMN tb_share4_analysisservice.f_srs IS '空间参考';
COMMENT ON COLUMN tb_share4_analysisservice.f_updatetime IS '数据更新时间';
COMMENT ON COLUMN tb_share4_analysisservice.f_inputparams IS '输入参数';
COMMENT ON COLUMN tb_share4_analysisservice.f_outputparams IS '输出参数';
COMMENT ON COLUMN tb_share4_analysisservice.f_responsetime IS '响应时间';
COMMENT ON COLUMN tb_share4_analysisservice.f_concurrent IS '并发量';
COMMENT ON COLUMN tb_share4_analysisservice.f_colony IS '集群';
COMMENT ON COLUMN tb_share4_analysisservice.f_involvedata IS '关联的数据';


-- tb_share4_appservice definition

-- Drop table

-- DROP TABLE tb_share4_appservice;

CREATE TABLE tb_share4_appservice (
	f_id varchar(50) NOT NULL,
	f_labels text NULL,
	f_desc text NULL,
	f_detailimg varchar(50) NULL,
	f_homedesc text NULL,
	f_homeimg varchar(50) NULL,
	f_isdel int2 NULL DEFAULT 0,
	CONSTRAINT pk_tb_share4_appservice PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_share4_appservice IS '组件服务表';

-- Column comments

COMMENT ON COLUMN tb_share4_appservice.f_id IS '唯一标识';
COMMENT ON COLUMN tb_share4_appservice.f_labels IS '标签';
COMMENT ON COLUMN tb_share4_appservice.f_desc IS '描述信息';
COMMENT ON COLUMN tb_share4_appservice.f_detailimg IS '内容图片id';
COMMENT ON COLUMN tb_share4_appservice.f_homedesc IS '首页描述';
COMMENT ON COLUMN tb_share4_appservice.f_homeimg IS '首页图片id';
COMMENT ON COLUMN tb_share4_appservice.f_isdel IS '是否删除';


-- tb_share4_catalog_service definition

-- Drop table

-- DROP TABLE tb_share4_catalog_service;

CREATE TABLE tb_share4_catalog_service (
	f_id varchar(50) NOT NULL,
	f_nodeid varchar(50) NULL,
	f_nodecode varchar(50) NULL,
	f_serviceid varchar(50) NULL,
	f_order int4 NULL,
	CONSTRAINT pk_tb_share4_catalog_service_id PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_share4_catalog_service IS '服务目录与服务关联表';

-- Column comments

COMMENT ON COLUMN tb_share4_catalog_service.f_nodeid IS '目录节点id';
COMMENT ON COLUMN tb_share4_catalog_service.f_nodecode IS '节点编码';
COMMENT ON COLUMN tb_share4_catalog_service.f_serviceid IS '目录关联服务id';
COMMENT ON COLUMN tb_share4_catalog_service.f_order IS '节点排序';


-- tb_share4_concurrent_check definition

-- Drop table

-- DROP TABLE tb_share4_concurrent_check;

CREATE TABLE tb_share4_concurrent_check (
	f_id varchar(32) NOT NULL,
	f_taskid varchar(32) NOT NULL,
	f_taskreceiver varchar(255) NULL,
	f_taskreceiverid varchar(255) NULL,
	f_checkstatus int4 NULL,
	f_approvalopinion text NULL,
	f_checkdate timestamp(6) NULL,
	f_concurrentdataurl varchar(255) NULL,
	f_concurrentdatastructuretree text NULL,
	f_concurrenttime timestamp(6) NULL,
	f_concurrentcount int4 NULL DEFAULT 0,
	CONSTRAINT tb_share4_concurrent_check_pkey PRIMARY KEY (f_id)
);


-- tb_share4_concurrent_task definition

-- Drop table

-- DROP TABLE tb_share4_concurrent_task;

CREATE TABLE tb_share4_concurrent_task (
	f_id varchar(32) NOT NULL,
	f_templatesid varchar(32) NULL,
	f_datareceiver varchar(255) NULL,
	f_datareceiverid varchar(255) NULL,
	f_datareceivingunit varchar(255) NULL,
	f_telephone varchar(50) NULL,
	f_email varchar(128) NULL,
	f_concurrentmode int4 NULL,
	f_note text NULL,
	f_name varchar(255) NULL,
	f_deadline timestamp(6) NULL,
	f_createtime timestamp(6) NULL,
	f_taskpublisher varchar(255) NULL,
	f_taskpublisherid varchar(64) NULL,
	f_concurrenttype int4 NULL,
	CONSTRAINT tb_share4_concurrent_task_pkey PRIMARY KEY (f_id)
);


-- tb_share4_concurrent_templates definition

-- Drop table

-- DROP TABLE tb_share4_concurrent_templates;

CREATE TABLE tb_share4_concurrent_templates (
	f_id varchar(32) NOT NULL,
	f_name varchar(255) NOT NULL,
	f_templatesuploadurl varchar(255) NULL,
	f_templatestructuretree text NULL,
	f_status int4 NULL,
	f_description text NULL,
	f_builder varchar(255) NULL,
	f_builderid varchar(255) NULL,
	f_createtime timestamp(6) NULL,
	f_updatetime timestamp(6) NULL,
	CONSTRAINT tb_share4_concurrent_templates_pkey PRIMARY KEY (f_id)
);


-- tb_share4_data_access definition

-- Drop table

-- DROP TABLE tb_share4_data_access;

CREATE TABLE tb_share4_data_access (
	f_id varchar(64) NOT NULL,
	f_dataid varchar(500) NULL,
	f_count int8 NULL,
	f_todaycount int8 NULL DEFAULT 0,
	CONSTRAINT pk_id_tb_share4_data_access PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share4_data_access.f_todaycount IS '今日访问次数';


-- tb_share4_data_apply definition

-- Drop table

-- DROP TABLE tb_share4_data_apply;

CREATE TABLE tb_share4_data_apply (
	f_id varchar(32) NOT NULL,
	f_userid varchar(255) NULL,
	f_username varchar(64) NULL,
	f_tel varchar(32) NULL,
	f_email varchar(255) NULL,
	f_address varchar(255) NULL,
	f_leadername varchar(64) NULL,
	f_desc text NULL,
	f_createtime timestamp(6) NULL,
	f_dataendtime timestamp(6) NULL,
	f_department varchar(255) NULL,
	f_name text NULL,
	f_ext text NULL,
	f_checkstatus int2 NULL,
	f_checkcomment text NULL,
	f_checkpersonid varchar(32) NULL,
	f_checkdate timestamp(6) NULL,
	f_datagettype int2 NULL,
	f_downloadstatus int4 NULL,
	f_hasread_apply int2 NULL DEFAULT 0,
	f_hasread_check int2 NULL DEFAULT 0,
	f_applytype int2 NULL DEFAULT 0,
	f_checkpersonname varchar NULL,
	CONSTRAINT tb_share4_data_apply_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share4_data_apply.f_userid IS '用户id';
COMMENT ON COLUMN tb_share4_data_apply.f_username IS '用户名称';
COMMENT ON COLUMN tb_share4_data_apply.f_tel IS '电话号码';
COMMENT ON COLUMN tb_share4_data_apply.f_email IS '电子邮箱';
COMMENT ON COLUMN tb_share4_data_apply.f_address IS '单位地址';
COMMENT ON COLUMN tb_share4_data_apply.f_leadername IS '单位负责人';
COMMENT ON COLUMN tb_share4_data_apply.f_desc IS '描述';
COMMENT ON COLUMN tb_share4_data_apply.f_createtime IS '创建时间';
COMMENT ON COLUMN tb_share4_data_apply.f_dataendtime IS '数据过期时间';
COMMENT ON COLUMN tb_share4_data_apply.f_department IS '单位';
COMMENT ON COLUMN tb_share4_data_apply.f_name IS '数据名称，多个数据用逗号隔开';
COMMENT ON COLUMN tb_share4_data_apply.f_ext IS '扩展';
COMMENT ON COLUMN tb_share4_data_apply.f_checkstatus IS '审批状态、未审批、审批通过、审批不通过';
COMMENT ON COLUMN tb_share4_data_apply.f_checkcomment IS '审批意见';
COMMENT ON COLUMN tb_share4_data_apply.f_checkpersonid IS '审批人';
COMMENT ON COLUMN tb_share4_data_apply.f_checkdate IS '审批时间';
COMMENT ON COLUMN tb_share4_data_apply.f_datagettype IS '数据获取方式：线上下载、线下拷贝';
COMMENT ON COLUMN tb_share4_data_apply.f_downloadstatus IS '数据下载状态';


-- tb_share4_data_apply_detail definition

-- Drop table

-- DROP TABLE tb_share4_data_apply_detail;

CREATE TABLE tb_share4_data_apply_detail (
	f_id varchar(32) NOT NULL,
	f_applyid varchar(32) NOT NULL,
	f_dataid varchar(255) NULL,
	f_datatype varchar(255) NULL,
	f_dataname text NULL,
	f_datatime text NULL,
	f_xzqlimit varchar(64) NULL,
	f_xzqlimitname varchar(255) NULL,
	f_fields varchar NULL,
	f_filter varchar NULL,
	f_exportformat varchar NULL,
	f_orgtype varchar NULL,
	f_clip varchar NULL,
	f_minlevel int4 NULL DEFAULT 0,
	f_maxlevel int4 NULL DEFAULT 0,
	f_nodeid varchar(255) NULL DEFAULT 0,
	f_cover varchar(255) NULL DEFAULT ''::character varying,
	CONSTRAINT tb_share4_data_apply_detail_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share4_data_apply_detail.f_dataid IS '数据id';
COMMENT ON COLUMN tb_share4_data_apply_detail.f_datatype IS '数据类型';
COMMENT ON COLUMN tb_share4_data_apply_detail.f_dataname IS '数据名称';
COMMENT ON COLUMN tb_share4_data_apply_detail.f_datatime IS '数据时相';
COMMENT ON COLUMN tb_share4_data_apply_detail.f_xzqlimit IS '行政区代码';
COMMENT ON COLUMN tb_share4_data_apply_detail.f_xzqlimitname IS '行政区名称';
COMMENT ON COLUMN tb_share4_data_apply_detail.f_fields IS '字段选择，用逗号隔开';
COMMENT ON COLUMN tb_share4_data_apply_detail.f_filter IS '属性过滤';
COMMENT ON COLUMN tb_share4_data_apply_detail.f_exportformat IS '数据导出格式gdb/mdb';
COMMENT ON COLUMN tb_share4_data_apply_detail.f_orgtype IS '数据组织方式:按省、市、县';
COMMENT ON COLUMN tb_share4_data_apply_detail.f_clip IS '是否裁剪';


-- tb_share4_data_collection definition

-- Drop table

-- DROP TABLE tb_share4_data_collection;

CREATE TABLE tb_share4_data_collection (
	f_id varchar(64) NOT NULL,
	f_dataid varchar(500) NULL,
	f_userid varchar(64) NULL,
	f_type int2 NULL,
	CONSTRAINT pk_id_tb_share4_data_collection PRIMARY KEY (f_id)
);


-- tb_share4_data_copy definition

-- Drop table

-- DROP TABLE tb_share4_data_copy;

CREATE TABLE tb_share4_data_copy (
	f_id varchar(32) NOT NULL,
	f_applyid varchar(32) NOT NULL,
	f_copyusername varchar(255) NULL,
	f_copyunitname varchar(255) NULL,
	f_copydate timestamp(6) NULL,
	CONSTRAINT tb_share4_data_copy_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share4_data_copy.f_id IS '唯一标识';
COMMENT ON COLUMN tb_share4_data_copy.f_applyid IS '申请id';
COMMENT ON COLUMN tb_share4_data_copy.f_copyusername IS '拷贝人名称';
COMMENT ON COLUMN tb_share4_data_copy.f_copyunitname IS '拷贝人所在单位名称';
COMMENT ON COLUMN tb_share4_data_copy.f_copydate IS '拷贝日期';


-- tb_share4_data_exporttask definition

-- Drop table

-- DROP TABLE tb_share4_data_exporttask;

CREATE TABLE tb_share4_data_exporttask (
	f_id varchar(32) NOT NULL,
	f_applyid varchar NULL,
	f_taskname varchar NULL,
	f_exportpath varchar NULL,
	CONSTRAINT tb_share4_data_exporttask_pkey PRIMARY KEY (f_id)
);


-- tb_share4_dataservice definition

-- Drop table

-- DROP TABLE tb_share4_dataservice;

CREATE TABLE tb_share4_dataservice (
	f_id varchar(50) NOT NULL,
	f_method int2 NULL DEFAULT 1,
	f_requestexample text NULL,
	f_reponseexample text NULL,
	f_producetime timestamp NULL,
	f_produceunit text NULL,
	f_srs varchar(128) NULL,
	f_updatetime timestamp NULL,
	f_databaseid varchar(50) NULL,
	f_tableid varchar(50) NULL,
	f_tablename varchar(50) NULL,
	f_params text NULL,
	f_isdel int2 NULL DEFAULT 0,
	CONSTRAINT pk_tb_share4_dataservice_id PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share4_dataservice.f_method IS 'Get/Post  默认 1.get 2.post 3.put 4.delete 5.get,post  6.all';
COMMENT ON COLUMN tb_share4_dataservice.f_requestexample IS '请求示例';
COMMENT ON COLUMN tb_share4_dataservice.f_reponseexample IS '返回示例';
COMMENT ON COLUMN tb_share4_dataservice.f_producetime IS '数据生产时间';
COMMENT ON COLUMN tb_share4_dataservice.f_produceunit IS '数据生产单位';
COMMENT ON COLUMN tb_share4_dataservice.f_srs IS '空间参考';
COMMENT ON COLUMN tb_share4_dataservice.f_updatetime IS '数据更新时间';
COMMENT ON COLUMN tb_share4_dataservice.f_databaseid IS '数据源ID';
COMMENT ON COLUMN tb_share4_dataservice.f_tableid IS '关联的数据id';
COMMENT ON COLUMN tb_share4_dataservice.f_tablename IS '关联的数据表名称';
COMMENT ON COLUMN tb_share4_dataservice.f_params IS '其他参数';


-- tb_share4_icon definition

-- Drop table

-- DROP TABLE tb_share4_icon;

CREATE TABLE tb_share4_icon (
	f_id varchar(50) NOT NULL,
	f_thumnail text NULL,
	f_icon text NULL,
	CONSTRAINT pk_tb_share4_icon_f_id PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_share4_icon IS '缩略图表';

-- Column comments

COMMENT ON COLUMN tb_share4_icon.f_thumnail IS '缩略图';
COMMENT ON COLUMN tb_share4_icon.f_icon IS '图标';


-- tb_share4_service definition

-- Drop table

-- DROP TABLE tb_share4_service;

CREATE TABLE tb_share4_service (
	f_id varchar(50) NOT NULL,
	f_name varchar(128) NULL,
	f_url text NULL,
	f_group int2 NULL,
	f_version varchar(50) NULL,
	f_xzqdm varchar(50) NULL,
	f_xzqmc varchar(50) NULL,
	f_labelids varchar(128) NULL,
	f_createtime timestamp NULL,
	f_count int4 NULL,
	f_secret int2 NULL,
	f_xmin numeric(12, 6) NULL,
	f_ymin numeric(12, 6) NULL,
	f_xmax numeric(12, 6) NULL,
	f_ymax numeric(12, 6) NULL,
	f_content text NULL,
	f_order int4 NULL,
	f_servicetype int4 NULL,
	f_iconid varchar(50) NULL,
	f_oid varchar(50) NULL,
	f_params text NULL,
	f_alias varchar(50) NULL,
	f_searchcount int4 NULL DEFAULT 0,
	f_isdel int2 NULL DEFAULT 0,
	f_desc varchar NULL,
	CONSTRAINT pk_tb_share4_service_id PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share4_service.f_url IS '服务地址';
COMMENT ON COLUMN tb_share4_service.f_group IS '分类(1.数据服务  2.分析服务  3.应用服务）';
COMMENT ON COLUMN tb_share4_service.f_version IS '数据版本（对应数据年份）';
COMMENT ON COLUMN tb_share4_service.f_xzqdm IS '行政区代码';
COMMENT ON COLUMN tb_share4_service.f_xzqmc IS '行政区名称';
COMMENT ON COLUMN tb_share4_service.f_labelids IS '数据标签（多个中间用逗号隔开）';
COMMENT ON COLUMN tb_share4_service.f_createtime IS '数据创建时间';
COMMENT ON COLUMN tb_share4_service.f_count IS '查询一次，申请一次+1';
COMMENT ON COLUMN tb_share4_service.f_secret IS '服务密级(1.公开访问 2.需要申请访问）';
COMMENT ON COLUMN tb_share4_service.f_xmin IS 'x最小值';
COMMENT ON COLUMN tb_share4_service.f_ymin IS 'y最小值';
COMMENT ON COLUMN tb_share4_service.f_xmax IS 'x最大值';
COMMENT ON COLUMN tb_share4_service.f_ymax IS 'y最大值';
COMMENT ON COLUMN tb_share4_service.f_content IS '内容描述';
COMMENT ON COLUMN tb_share4_service.f_order IS '顺序';
COMMENT ON COLUMN tb_share4_service.f_servicetype IS '服务类型';
COMMENT ON COLUMN tb_share4_service.f_iconid IS '缩略图id';
COMMENT ON COLUMN tb_share4_service.f_oid IS '原始服务id(如果是第三方服务就为0）';
COMMENT ON COLUMN tb_share4_service.f_searchcount IS '搜素次数';


-- tb_share4_service_apply definition

-- Drop table

-- DROP TABLE tb_share4_service_apply;

CREATE TABLE tb_share4_service_apply (
	f_id varchar(32) NOT NULL,
	f_userid varchar(255) NULL,
	f_username varchar(64) NULL,
	f_tel varchar(32) NULL,
	f_email varchar(255) NULL,
	f_address varchar(255) NULL,
	f_leadername varchar(64) NULL,
	f_desc text NULL,
	f_createtime timestamp(6) NULL,
	f_serviceendtime timestamp(6) NULL,
	f_department varchar(255) NULL,
	f_name text NULL,
	f_ext text NULL,
	f_checkstatus int2 NULL,
	f_checkcomment text NULL,
	f_checkpersonid varchar(32) NULL,
	f_checkdate timestamp(6) NULL,
	f_ipscope varchar(255) NULL,
	f_frequency text NULL,
	f_hasread_apply int2 NULL DEFAULT 0,
	f_hasread_check int2 NULL DEFAULT 0,
	CONSTRAINT tb_share4_serviceapply_pkey PRIMARY KEY (f_id)
);


-- tb_share4_service_apply_attachment definition

-- Drop table

-- DROP TABLE tb_share4_service_apply_attachment;

CREATE TABLE tb_share4_service_apply_attachment (
	f_id varchar NOT NULL,
	f_applyid varchar NULL,
	f_name text NULL,
	f_filetype varchar(16) NULL,
	f_path varchar(255) NULL,
	CONSTRAINT tb_share4_service_apply_attachment_pkey PRIMARY KEY (f_id)
);
CREATE INDEX i_tb_share4_service_apply_attachment ON tb_share4_service_apply_attachment USING btree (f_applyid);

-- Column comments

COMMENT ON COLUMN tb_share4_service_apply_attachment.f_name IS '附件名称';
COMMENT ON COLUMN tb_share4_service_apply_attachment.f_filetype IS '附件文件类型';
COMMENT ON COLUMN tb_share4_service_apply_attachment.f_path IS '附件路径';


-- tb_share4_service_apply_detail definition

-- Drop table

-- DROP TABLE tb_share4_service_apply_detail;

CREATE TABLE tb_share4_service_apply_detail (
	f_id varchar(32) NOT NULL,
	f_applyid varchar(32) NOT NULL,
	f_serviceid varchar(255) NULL,
	f_xzqlimit varchar(64) NULL,
	f_xzqlimitname varchar(255) NULL,
	f_token varchar(255) NULL,
	f_styleids varchar(255) NULL,
	f_vectorservicetypes varchar(255) NULL,
	CONSTRAINT tb_share4_serviceapply_detail_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share4_service_apply_detail.f_token IS '代理的token';
COMMENT ON COLUMN tb_share4_service_apply_detail.f_styleids IS '服务样式id';
COMMENT ON COLUMN tb_share4_service_apply_detail.f_vectorservicetypes IS '矢量瓦片服务类型';


-- tb_share4_service_catalog definition

-- Drop table

-- DROP TABLE tb_share4_service_catalog;

CREATE TABLE tb_share4_service_catalog (
	f_id varchar(32) NOT NULL,
	f_name varchar(255) NOT NULL,
	f_desc text NULL,
	f_isdefault int4 NULL DEFAULT 0,
	CONSTRAINT pk_tb_share4_service_catalog_id PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share4_service_catalog.f_name IS '目录名称';


-- tb_share4_service_catalog_node definition

-- Drop table

-- DROP TABLE tb_share4_service_catalog_node;

CREATE TABLE tb_share4_service_catalog_node (
	f_id varchar(32) NOT NULL,
	f_pid varchar(32) NULL,
	f_nodetype int4 NULL,
	f_name varchar(64) NULL,
	f_desc text NULL,
	f_sort int4 NULL,
	f_catalogid varchar NULL,
	f_nodecode varchar(50) NULL,
	CONSTRAINT pk_tb_share4_service_catalog_node PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share4_service_catalog_node.f_id IS '唯一标识';
COMMENT ON COLUMN tb_share4_service_catalog_node.f_pid IS '父id';
COMMENT ON COLUMN tb_share4_service_catalog_node.f_nodetype IS '目录节点还是数据节点';
COMMENT ON COLUMN tb_share4_service_catalog_node.f_name IS '名称';
COMMENT ON COLUMN tb_share4_service_catalog_node.f_sort IS '服务排序';
COMMENT ON COLUMN tb_share4_service_catalog_node.f_catalogid IS '目录ID';
COMMENT ON COLUMN tb_share4_service_catalog_node.f_nodecode IS '节点编码（从根目录开始收到编码，子节点按照添加时间递增编码，参考行政区编码）';


-- tb_share4_service_interface definition

-- Drop table

-- DROP TABLE tb_share4_service_interface;

CREATE TABLE tb_share4_service_interface (
	f_id varchar(50) NOT NULL,
	f_name text NULL,
	f_desc text NULL,
	f_url text NULL,
	f_serviceid varchar(50) NULL,
	f_requestexample text NULL,
	f_reponseexample text NULL,
	f_method int2 NULL DEFAULT 1,
	f_updatetime timestamp NULL,
	f_producetime timestamp NULL,
	f_produceunit text NULL,
	f_srs varchar(128) NULL,
	f_inputparams text NULL,
	f_outputparams text NULL,
	f_responsetime int4 NULL,
	f_concurrent int4 NULL,
	f_colony varchar(255) NULL,
	f_involvedata text NULL,
	f_isdel int2 NULL DEFAULT 0,
	CONSTRAINT pk_tb_share4_appservice_interface PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_share4_service_interface IS '组件服务接口表';

-- Column comments

COMMENT ON COLUMN tb_share4_service_interface.f_id IS '唯一标识';
COMMENT ON COLUMN tb_share4_service_interface.f_url IS '接口地址';
COMMENT ON COLUMN tb_share4_service_interface.f_serviceid IS '对应的组件服务id';
COMMENT ON COLUMN tb_share4_service_interface.f_requestexample IS '请求示例';
COMMENT ON COLUMN tb_share4_service_interface.f_reponseexample IS '返回示例';
COMMENT ON COLUMN tb_share4_service_interface.f_method IS 'Get/Post  默认 1.get 2.post 3.put 4.delete 5.get,post  6.all';
COMMENT ON COLUMN tb_share4_service_interface.f_updatetime IS '数据更新时间';
COMMENT ON COLUMN tb_share4_service_interface.f_producetime IS '数据生产时间';
COMMENT ON COLUMN tb_share4_service_interface.f_produceunit IS '数据生产单位';
COMMENT ON COLUMN tb_share4_service_interface.f_srs IS '空间参考';
COMMENT ON COLUMN tb_share4_service_interface.f_inputparams IS '输入参数';
COMMENT ON COLUMN tb_share4_service_interface.f_outputparams IS '输出参数';
COMMENT ON COLUMN tb_share4_service_interface.f_responsetime IS '响应时间';
COMMENT ON COLUMN tb_share4_service_interface.f_concurrent IS '并发量';
COMMENT ON COLUMN tb_share4_service_interface.f_colony IS '集群';
COMMENT ON COLUMN tb_share4_service_interface.f_involvedata IS '关联的数据';


-- tb_share_analysisservice definition

-- Drop table

-- DROP TABLE tb_share_analysisservice;

CREATE TABLE tb_share_analysisservice (
	f_id varchar(32) NOT NULL,
	f_groupid varchar(32) NULL,
	f_name varchar(64) NULL,
	f_desc text NULL,
	f_createtime timestamp(6) NULL,
	f_requestexample text NULL,
	f_reponseexample text NULL,
	f_url varchar(255) NULL,
	f_method int2 NULL,
	f_order int4 NULL,
	f_type int2 NULL,
	f_iconimageurl varchar(255) NULL,
	f_realiconimageurl varchar(255) NULL,
	f_contentimageurl varchar(255) NULL,
	f_realcontentimageurl varchar(255) NULL,
	f_count int4 NULL,
	f_labelids text NULL,
	f_responsetime int4 NULL,
	f_concurrent int4 NULL,
	f_colony varchar(255) NULL,
	f_involvedata text NULL,
	f_outputparams text NULL,
	f_inputparams text NULL,
	f_updatetime timestamp(6) NULL,
	CONSTRAINT tb_share_service_copy1_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share_analysisservice.f_id IS '唯一标识';
COMMENT ON COLUMN tb_share_analysisservice.f_groupid IS '分组id';
COMMENT ON COLUMN tb_share_analysisservice.f_name IS '接口名称';
COMMENT ON COLUMN tb_share_analysisservice.f_desc IS '接口描述';
COMMENT ON COLUMN tb_share_analysisservice.f_createtime IS '创建时间';
COMMENT ON COLUMN tb_share_analysisservice.f_requestexample IS '请求示例';
COMMENT ON COLUMN tb_share_analysisservice.f_reponseexample IS '返回示例';
COMMENT ON COLUMN tb_share_analysisservice.f_url IS '接口地址';
COMMENT ON COLUMN tb_share_analysisservice.f_method IS 'Get/Post  默认Post';
COMMENT ON COLUMN tb_share_analysisservice.f_order IS '顺序';
COMMENT ON COLUMN tb_share_analysisservice.f_type IS '分类';
COMMENT ON COLUMN tb_share_analysisservice.f_responsetime IS '响应时间';
COMMENT ON COLUMN tb_share_analysisservice.f_concurrent IS '并发量';
COMMENT ON COLUMN tb_share_analysisservice.f_colony IS '集群';
COMMENT ON COLUMN tb_share_analysisservice.f_involvedata IS '关联的数据';


-- tb_share_concurrent_check definition

-- Drop table

-- DROP TABLE tb_share_concurrent_check;

CREATE TABLE tb_share_concurrent_check (
	f_id varchar(32) NOT NULL,
	f_taskid varchar(32) NOT NULL,
	f_taskreceiver varchar(255) NULL,
	f_taskreceiverid varchar(255) NULL,
	f_checkstatus int4 NULL,
	f_approvalopinion text NULL,
	f_checkdate timestamp(6) NULL,
	f_concurrentdataurl varchar(255) NULL,
	f_concurrentdatastructuretree text NULL,
	f_concurrenttime timestamp(6) NULL,
	f_concurrentcount int4 NULL DEFAULT 0,
	CONSTRAINT tb_share_concurrent_check_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share_concurrent_check.f_taskid IS '汇交任务id';
COMMENT ON COLUMN tb_share_concurrent_check.f_taskreceiver IS '任务接收人';
COMMENT ON COLUMN tb_share_concurrent_check.f_taskreceiverid IS '任务接收人id';
COMMENT ON COLUMN tb_share_concurrent_check.f_checkstatus IS '审批状态：1 通过 0 驳回';
COMMENT ON COLUMN tb_share_concurrent_check.f_approvalopinion IS '审批意见';
COMMENT ON COLUMN tb_share_concurrent_check.f_checkdate IS '审批时间';
COMMENT ON COLUMN tb_share_concurrent_check.f_concurrentdataurl IS '汇交数据上传到服务器的url';
COMMENT ON COLUMN tb_share_concurrent_check.f_concurrentdatastructuretree IS '汇交数据的目录结构树';
COMMENT ON COLUMN tb_share_concurrent_check.f_concurrenttime IS '汇交数据时间';
COMMENT ON COLUMN tb_share_concurrent_check.f_concurrentcount IS '汇交数据次数';


-- tb_share_concurrent_task definition

-- Drop table

-- DROP TABLE tb_share_concurrent_task;

CREATE TABLE tb_share_concurrent_task (
	f_id varchar(32) NOT NULL,
	f_templatesid varchar(32) NULL,
	f_datareceiver varchar(255) NULL,
	f_datareceiverid varchar(255) NULL,
	f_datareceivingunit varchar(255) NULL,
	f_telephone varchar(50) NULL,
	f_email varchar(128) NULL,
	f_concurrentmode int4 NULL,
	f_note text NULL,
	f_name varchar(255) NULL,
	f_deadline timestamp(6) NULL,
	f_createtime timestamp(6) NULL,
	f_taskpublisher varchar(255) NULL,
	f_taskpublisherid varchar(64) NULL,
	f_concurrenttype int4 NULL,
	CONSTRAINT tb_share_concurrent_task_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share_concurrent_task.f_templatesid IS '汇交模板id';
COMMENT ON COLUMN tb_share_concurrent_task.f_datareceiver IS '数据接收人';
COMMENT ON COLUMN tb_share_concurrent_task.f_datareceiverid IS '数据接收人id';
COMMENT ON COLUMN tb_share_concurrent_task.f_datareceivingunit IS '数据接收单位';
COMMENT ON COLUMN tb_share_concurrent_task.f_telephone IS '联系电话';
COMMENT ON COLUMN tb_share_concurrent_task.f_email IS '邮箱';
COMMENT ON COLUMN tb_share_concurrent_task.f_concurrentmode IS '汇交模式：1 线上汇交 0 线下汇交';
COMMENT ON COLUMN tb_share_concurrent_task.f_note IS '备注';
COMMENT ON COLUMN tb_share_concurrent_task.f_name IS '汇交任务名称';
COMMENT ON COLUMN tb_share_concurrent_task.f_deadline IS '汇交截止日期';
COMMENT ON COLUMN tb_share_concurrent_task.f_createtime IS '汇交任务创建时间';
COMMENT ON COLUMN tb_share_concurrent_task.f_taskpublisher IS '汇交任务发布人';
COMMENT ON COLUMN tb_share_concurrent_task.f_taskpublisherid IS '汇交任务发布人id';
COMMENT ON COLUMN tb_share_concurrent_task.f_concurrenttype IS '汇交任务类型：0 主动申请 1 被动提交';


-- tb_share_concurrent_templates definition

-- Drop table

-- DROP TABLE tb_share_concurrent_templates;

CREATE TABLE tb_share_concurrent_templates (
	f_id varchar(32) NOT NULL,
	f_name varchar(255) NOT NULL,
	f_templatesuploadurl varchar(255) NULL,
	f_templatestructuretree text NULL,
	f_status int4 NULL,
	f_description text NULL,
	f_builder varchar(255) NULL,
	f_builderid varchar(255) NULL,
	f_createtime timestamp(6) NULL,
	f_updatetime timestamp(6) NULL,
	CONSTRAINT tb_share_concurrent_templates_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share_concurrent_templates.f_name IS '汇交模板名称';
COMMENT ON COLUMN tb_share_concurrent_templates.f_templatesuploadurl IS '汇交模板上传到服务器的url';
COMMENT ON COLUMN tb_share_concurrent_templates.f_templatestructuretree IS '汇交模板的目录结构树';
COMMENT ON COLUMN tb_share_concurrent_templates.f_status IS '汇交模板的启用状态：1 启用 0 未启用';
COMMENT ON COLUMN tb_share_concurrent_templates.f_description IS '汇交模板说明';
COMMENT ON COLUMN tb_share_concurrent_templates.f_builder IS '汇交模板创建者';
COMMENT ON COLUMN tb_share_concurrent_templates.f_builderid IS '汇交模板创建者id';
COMMENT ON COLUMN tb_share_concurrent_templates.f_createtime IS '汇交模板创建时间';
COMMENT ON COLUMN tb_share_concurrent_templates.f_updatetime IS '模板更新时间';


-- tb_share_data_catalog definition

-- Drop table

-- DROP TABLE tb_share_data_catalog;

CREATE TABLE tb_share_data_catalog (
	f_id varchar(64) NOT NULL,
	f_name varchar(255) NULL,
	f_pid varchar(64) NULL,
	f_isdefault int4 NULL,
	f_createtime timestamp(6) NULL
);

-- Column comments

COMMENT ON COLUMN tb_share_data_catalog.f_id IS '目录分类id';
COMMENT ON COLUMN tb_share_data_catalog.f_name IS '目录分类名称';
COMMENT ON COLUMN tb_share_data_catalog.f_pid IS '目录分类父id';
COMMENT ON COLUMN tb_share_data_catalog.f_isdefault IS '是否为默认目录';
COMMENT ON COLUMN tb_share_data_catalog.f_createtime IS '目录分类创建时间';


-- tb_share_data_catalog_role definition

-- Drop table

-- DROP TABLE tb_share_data_catalog_role;

CREATE TABLE tb_share_data_catalog_role (
	f_id varchar(255) NOT NULL,
	f_catalogid varchar(255) NULL,
	f_roleid varchar(255) NULL,
	f_selectid text NULL,
	f_idtype text NULL,
	f_isshow int2 NULL,
	CONSTRAINT tb_share_data_catalog_role_pkey PRIMARY KEY (f_id)
);


-- tb_share_data_tree definition

-- Drop table

-- DROP TABLE tb_share_data_tree;

CREATE TABLE tb_share_data_tree (
	f_id varchar(64) NOT NULL,
	f_name varchar(255) NULL,
	f_pid varchar(64) NULL,
	f_level int4 NULL,
	f_datacatalogid varchar(64) NULL,
	f_tableid varchar(64) NULL,
	f_serviceid varchar(64) NULL,
	f_jsoninfo json NULL,
	f_createtime timestamp(6) NULL,
	f_viewnum int4 NULL DEFAULT 0,
	f_tablename varchar(255) NULL,
	f_todayviewnum int4 NULL DEFAULT 0,
	f_type int2 NULL
);

-- Column comments

COMMENT ON COLUMN tb_share_data_tree.f_id IS '目录树id';
COMMENT ON COLUMN tb_share_data_tree.f_name IS '目录树名称';
COMMENT ON COLUMN tb_share_data_tree.f_pid IS '目录树父id(一级目录的父id都为-1)';
COMMENT ON COLUMN tb_share_data_tree.f_level IS '区分目录数据还是图层数据：1 目录 2 图层数据';
COMMENT ON COLUMN tb_share_data_tree.f_datacatalogid IS '目录分类id';
COMMENT ON COLUMN tb_share_data_tree.f_tableid IS '图层数据绑定的分析服务引擎对应的图层id';
COMMENT ON COLUMN tb_share_data_tree.f_serviceid IS '图层数据绑定的数据服务id';
COMMENT ON COLUMN tb_share_data_tree.f_jsoninfo IS '图层数据对应的信息详情：数据结构为json，分为三大块：jbxx,sjyl,sjtp；字段信息直接根据图层id请求分析服务引擎的接口调取';
COMMENT ON COLUMN tb_share_data_tree.f_createtime IS '目录树创建时间';
COMMENT ON COLUMN tb_share_data_tree.f_viewnum IS '浏览次数';
COMMENT ON COLUMN tb_share_data_tree.f_tablename IS '图层数据图层名称';

-- tb_share_dataservice definition

-- Drop table

-- DROP TABLE tb_share_dataservice;

CREATE TABLE tb_share_dataservice (
	f_id varchar(32) NOT NULL,
	f_groupid varchar(32) NULL,
	f_name varchar(64) NULL,
	f_desc text NULL,
	f_createtime timestamp(6) NULL,
	f_requestexample text NULL,
	f_reponseexample text NULL,
	f_url text NULL,
	f_method int2 NULL,
	f_xmax float8 NULL,
	f_xmin float8 NULL,
	f_ymax float8 NULL,
	f_ymin float8 NULL,
	f_year varchar(32) NULL,
	f_xzq varchar(32) NULL,
	f_producetime timestamp(6) NULL,
	f_produceunit varchar(255) NULL,
	f_count int4 NULL,
	f_labelids text NULL,
	f_secret int4 NULL,
	f_iconimageurl varchar(255) NULL,
	f_realiconimageurl varchar(255) NULL,
	f_contentimageurl varchar(255) NULL,
	f_realcontentimageurl varchar(255) NULL,
	f_dataservicetype int4 NULL,
	f_tableid varchar(32) NULL,
	f_tablename varchar(64) NULL,
	f_type int4 NULL,
	f_inputparams text NULL,
	f_outputparams text NULL,
	f_xzqname varchar(255) NULL,
	f_srs varchar(255) NULL,
	f_databaseid varchar(100) NULL,
	f_updatetime timestamp(6) NULL,
	f_params text NULL,
	f_isdel int2 NULL DEFAULT 0,
	CONSTRAINT tb_share_dataservice_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share_dataservice.f_id IS '唯一标识';
COMMENT ON COLUMN tb_share_dataservice.f_groupid IS '分组id';
COMMENT ON COLUMN tb_share_dataservice.f_name IS '接口名称';
COMMENT ON COLUMN tb_share_dataservice.f_desc IS '接口描述';
COMMENT ON COLUMN tb_share_dataservice.f_createtime IS '创建时间';
COMMENT ON COLUMN tb_share_dataservice.f_requestexample IS '请求示例';
COMMENT ON COLUMN tb_share_dataservice.f_reponseexample IS '返回示例';
COMMENT ON COLUMN tb_share_dataservice.f_url IS '服务地址';
COMMENT ON COLUMN tb_share_dataservice.f_method IS 'Get/Post  默认 0：Post，1：Get ';
COMMENT ON COLUMN tb_share_dataservice.f_xmax IS 'x最大值';
COMMENT ON COLUMN tb_share_dataservice.f_xmin IS 'x最小值';
COMMENT ON COLUMN tb_share_dataservice.f_ymax IS 'y最大值';
COMMENT ON COLUMN tb_share_dataservice.f_ymin IS 'y最小值';
COMMENT ON COLUMN tb_share_dataservice.f_year IS '年份';
COMMENT ON COLUMN tb_share_dataservice.f_xzq IS '行政区划';
COMMENT ON COLUMN tb_share_dataservice.f_producetime IS '数据生产年份';
COMMENT ON COLUMN tb_share_dataservice.f_produceunit IS '数据生产单位';
COMMENT ON COLUMN tb_share_dataservice.f_count IS '查询一次，申请一次+1';
COMMENT ON COLUMN tb_share_dataservice.f_labelids IS '数据标签';
COMMENT ON COLUMN tb_share_dataservice.f_secret IS '服务密级';
COMMENT ON COLUMN tb_share_dataservice.f_iconimageurl IS '缩略图图片minio相对地址';
COMMENT ON COLUMN tb_share_dataservice.f_realiconimageurl IS '缩略图图片minio相对地址';
COMMENT ON COLUMN tb_share_dataservice.f_contentimageurl IS '缩略图图片minio相对地址';
COMMENT ON COLUMN tb_share_dataservice.f_realcontentimageurl IS '缩略图图片minio相对地址';
COMMENT ON COLUMN tb_share_dataservice.f_dataservicetype IS '数据服务类型';
COMMENT ON COLUMN tb_share_dataservice.f_tableid IS '关联的数据id';
COMMENT ON COLUMN tb_share_dataservice.f_tablename IS '关联的数据表名';
COMMENT ON COLUMN tb_share_dataservice.f_type IS '服务类型：4代表数据服务，5代表分析服务，6代表组件服务';
COMMENT ON COLUMN tb_share_dataservice.f_xzqname IS '行政区划名称';
COMMENT ON COLUMN tb_share_dataservice.f_srs IS '空间参考';
COMMENT ON COLUMN tb_share_dataservice.f_databaseid IS '关联的数据库id';


-- tb_share_hottags definition

-- Drop table

-- DROP TABLE tb_share_hottags;

CREATE TABLE tb_share_hottags (
	f_id varchar(64) NOT NULL,
	f_name varchar(500) NULL,
	f_userid varchar(64) NULL,
	f_username varchar(64) NULL,
	f_createtime timestamp(6) NULL,
	f_weight int2 NULL,
	f_type int2 NULL
);

-- Column comments

COMMENT ON COLUMN tb_share_hottags.f_name IS '标签名称';
COMMENT ON COLUMN tb_share_hottags.f_userid IS '用户ID';
COMMENT ON COLUMN tb_share_hottags.f_username IS '用户登录名';
COMMENT ON COLUMN tb_share_hottags.f_createtime IS '标签创建时间';
COMMENT ON COLUMN tb_share_hottags.f_weight IS '标签权重';
COMMENT ON COLUMN tb_share_hottags.f_type IS '标签类型（默认为1 为数据共享目录类型数据的标签）';


-- tb_share_meta_data definition

-- Drop table

-- DROP TABLE tb_share_meta_data;

CREATE TABLE tb_share_meta_data (
	f_id varchar(32) NOT NULL,
	f_name varchar(64) NULL,
	f_alisname varchar(64) NULL,
	f_type int4 NULL,
	f_length varchar(10) NULL,
	f_pid varchar(60) NULL,
	f_defaultvalues text NULL,
	f_desc text NULL,
	f_createtime timestamp(6) NULL,
	f_isnull int4 NULL,
	f_level int4 NULL,
	CONSTRAINT tb_share_meta_data_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share_meta_data.f_name IS '元数据名称';
COMMENT ON COLUMN tb_share_meta_data.f_alisname IS '元数据别名';
COMMENT ON COLUMN tb_share_meta_data.f_type IS '元数据类型：1 文本 2 浮点型 3 整型 4 枚举值 5 日期 6 二进制';
COMMENT ON COLUMN tb_share_meta_data.f_length IS '元数据长度：日期与二进制无具体长度，浮点型存具体的精度（如4,2）';
COMMENT ON COLUMN tb_share_meta_data.f_pid IS '父id：根目录默认都为-1';
COMMENT ON COLUMN tb_share_meta_data.f_defaultvalues IS '元数据默认值';
COMMENT ON COLUMN tb_share_meta_data.f_desc IS '元数据创建时间';
COMMENT ON COLUMN tb_share_meta_data.f_isnull IS '元数据可否为空：1 可为空 0 不可为空，默认为1';
COMMENT ON COLUMN tb_share_meta_data.f_level IS '元数据级别：1 元数据目录 2 元数据';


-- tb_share_metadata_template definition

-- Drop table

-- DROP TABLE tb_share_metadata_template;

CREATE TABLE tb_share_metadata_template (
	f_id varchar(64) NOT NULL,
	f_name varchar(255) NULL,
	f_pid varchar(64) NULL,
	f_metadataid varchar(64) NULL,
	f_createtime timestamp(6) NULL,
	f_sort int4 NULL
);

-- Column comments

COMMENT ON COLUMN tb_share_metadata_template.f_id IS '模板id';
COMMENT ON COLUMN tb_share_metadata_template.f_name IS '模板名称';
COMMENT ON COLUMN tb_share_metadata_template.f_pid IS '元数据模板的父id为-1，元数据的父id为模板id';
COMMENT ON COLUMN tb_share_metadata_template.f_metadataid IS '元数据项id';
COMMENT ON COLUMN tb_share_metadata_template.f_createtime IS '元数据创建时间';
COMMENT ON COLUMN tb_share_metadata_template.f_sort IS '元数据顺序';


-- tb_share_personcollection definition

-- Drop table

-- DROP TABLE tb_share_personcollection;

CREATE TABLE tb_share_personcollection (
	f_id varchar(64) NOT NULL,
	f_name varchar(500) NULL,
	f_userid varchar(64) NULL,
	f_username varchar(64) NULL,
	f_createtime timestamp(6) NULL,
	f_type int2 NULL,
	f_dataclassifyid varchar(64) NULL,
	CONSTRAINT pk_id_personcollection PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share_personcollection.f_name IS '收藏数据信息';
COMMENT ON COLUMN tb_share_personcollection.f_userid IS '用户ID';
COMMENT ON COLUMN tb_share_personcollection.f_username IS '用户登录名';
COMMENT ON COLUMN tb_share_personcollection.f_createtime IS '收藏时间';
COMMENT ON COLUMN tb_share_personcollection.f_type IS '收藏类型（默认为1 为数据共享目录类型数据的标签）';


-- tb_share_service definition

-- Drop table

-- DROP TABLE tb_share_service;

CREATE TABLE tb_share_service (
	f_id varchar(32) NOT NULL,
	f_groupid varchar(32) NULL,
	f_name varchar(64) NULL,
	f_desc text NULL,
	f_createtime timestamp(6) NULL,
	f_requestexample text NULL,
	f_reponseexample text NULL,
	f_url varchar(255) NULL,
	f_method int2 NULL,
	f_order int4 NULL,
	f_type int2 NULL,
	f_iconimageurl varchar(255) NULL,
	f_realiconimageurl varchar(255) NULL,
	f_contentimageurl varchar(255) NULL,
	f_realcontentimageurl varchar(255) NULL,
	f_count int4 NULL,
	f_labelids text NULL,
	f_inputparams text NULL,
	f_outputparams text NULL,
	f_updatetime timestamp(6) NULL,
	CONSTRAINT tb_biz_manager_service_copy1_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share_service.f_id IS '唯一标识';
COMMENT ON COLUMN tb_share_service.f_groupid IS '分组id';
COMMENT ON COLUMN tb_share_service.f_name IS '接口名称';
COMMENT ON COLUMN tb_share_service.f_desc IS '接口描述';
COMMENT ON COLUMN tb_share_service.f_createtime IS '创建时间';
COMMENT ON COLUMN tb_share_service.f_requestexample IS '请求示例';
COMMENT ON COLUMN tb_share_service.f_reponseexample IS '返回示例';
COMMENT ON COLUMN tb_share_service.f_url IS '接口地址';
COMMENT ON COLUMN tb_share_service.f_method IS 'Get/Post  默认Post';
COMMENT ON COLUMN tb_share_service.f_order IS '顺序';
COMMENT ON COLUMN tb_share_service.f_type IS '分类';


-- tb_share_service_apply definition

-- Drop table

-- DROP TABLE tb_share_service_apply;

CREATE TABLE tb_share_service_apply (
	f_id varchar(32) NOT NULL,
	f_type int2 NULL,
	f_serviceids text NULL,
	f_username varchar(64) NULL,
	f_tel varchar(32) NULL,
	f_email varchar(255) NULL,
	f_address varchar(255) NULL,
	f_leadername varchar(64) NULL,
	f_desc text NULL,
	f_createtime timestamp(6) NULL,
	f_endtime timestamp(6) NULL,
	f_servicenames text NULL,
	f_servicegroupnames text NULL,
	f_serviceendtime timestamp(6) NULL,
	f_department varchar(255) NULL,
	f_name text NULL,
	f_ext text NULL,
	f_userid varchar(255) NULL,
	f_downloadstatus int4 NULL,
	f_hasread int4 NULL DEFAULT 0,
	f_xzqlimit varchar(64) NULL,
	f_xzqlimitname varchar(255) NULL,
	CONSTRAINT tb_biz_manager_service_apply_copy1_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share_service_apply.f_id IS '唯一标识';
COMMENT ON COLUMN tb_share_service_apply.f_type IS '服务类别';
COMMENT ON COLUMN tb_share_service_apply.f_serviceids IS '申请的服务列表';
COMMENT ON COLUMN tb_share_service_apply.f_username IS '申请人姓名';
COMMENT ON COLUMN tb_share_service_apply.f_tel IS '联系电话';
COMMENT ON COLUMN tb_share_service_apply.f_email IS '邮箱';
COMMENT ON COLUMN tb_share_service_apply.f_address IS '单位地址';
COMMENT ON COLUMN tb_share_service_apply.f_leadername IS '单位负责人';
COMMENT ON COLUMN tb_share_service_apply.f_desc IS '申请备注';
COMMENT ON COLUMN tb_share_service_apply.f_createtime IS '申请时间';
COMMENT ON COLUMN tb_share_service_apply.f_endtime IS '申请完成时间';
COMMENT ON COLUMN tb_share_service_apply.f_department IS '申请单位';
COMMENT ON COLUMN tb_share_service_apply.f_ext IS '其他信息，数据服务对应的是wkt';
COMMENT ON COLUMN tb_share_service_apply.f_userid IS '申请人id';
COMMENT ON COLUMN tb_share_service_apply.f_downloadstatus IS '下载状态：1 已下载 0 未下载';


-- tb_share_service_catalog definition

-- Drop table

-- DROP TABLE tb_share_service_catalog;

CREATE TABLE tb_share_service_catalog (
	f_id varchar(32) NOT NULL,
	f_type int4 NOT NULL,
	f_name varchar(255) NOT NULL,
	f_desc text NULL,
	f_isdefault int4 NULL DEFAULT 0,
	CONSTRAINT tb_share_service_catalog_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share_service_catalog.f_type IS '服务类型：4:地图服务，5:组件服务，6:分析服务、7:云资源服务';
COMMENT ON COLUMN tb_share_service_catalog.f_name IS '目录名称';


-- tb_share_service_catalog_node definition

-- Drop table

-- DROP TABLE tb_share_service_catalog_node;

CREATE TABLE tb_share_service_catalog_node (
	f_id varchar(32) NOT NULL,
	f_pid varchar(32) NULL,
	f_nodetype int4 NULL,
	f_name varchar(64) NULL,
	f_desc text NULL,
	f_catalogid varchar(32) NULL,
	f_serviceid varchar(32) NULL,
	f_sort int4 NULL,
	CONSTRAINT tb_share_service_catalog_node_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share_service_catalog_node.f_id IS '唯一标识';
COMMENT ON COLUMN tb_share_service_catalog_node.f_pid IS '父id';
COMMENT ON COLUMN tb_share_service_catalog_node.f_nodetype IS '目录节点还是数据节点';
COMMENT ON COLUMN tb_share_service_catalog_node.f_name IS '名称';
COMMENT ON COLUMN tb_share_service_catalog_node.f_catalogid IS '目录id';
COMMENT ON COLUMN tb_share_service_catalog_node.f_serviceid IS '服务id';
COMMENT ON COLUMN tb_share_service_catalog_node.f_sort IS '服务排序';


-- tb_share_service_catalog_role definition

-- Drop table

-- DROP TABLE tb_share_service_catalog_role;

CREATE TABLE tb_share_service_catalog_role (
	f_id varchar(255) NOT NULL,
	f_catalogid varchar(255) NULL,
	f_roleid varchar(255) NULL,
	f_selectid text NULL,
	f_idtype text NULL,
	f_isshow int2 NULL,
	f_type int2 NULL,
	f_isrole int2 NULL
);


-- tb_share_service_check definition

-- Drop table

-- DROP TABLE tb_share_service_check;

CREATE TABLE tb_share_service_check (
	f_id varchar(32) NOT NULL,
	f_applyid varchar(32) NOT NULL,
	f_checkstatus int2 NULL,
	f_checkcomment text NULL,
	f_checkpersonid varchar(32) NULL,
	f_checkdate timestamp(6) NULL,
	f_gettype int4 NULL,
	f_ipscope varchar(255) NULL,
	f_frequency text NULL,
	CONSTRAINT tb_biz_manager_service_check_copy1_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share_service_check.f_id IS '唯一标识';
COMMENT ON COLUMN tb_share_service_check.f_applyid IS '申请id';
COMMENT ON COLUMN tb_share_service_check.f_checkstatus IS '审核状态 ：通过、不通过、待审核';
COMMENT ON COLUMN tb_share_service_check.f_checkcomment IS '审核意见';
COMMENT ON COLUMN tb_share_service_check.f_checkpersonid IS '审核人id';
COMMENT ON COLUMN tb_share_service_check.f_checkdate IS '审核时间';
COMMENT ON COLUMN tb_share_service_check.f_gettype IS '获取方式：1 线上提取 0 线下拷贝';
COMMENT ON COLUMN tb_share_service_check.f_ipscope IS 'ip访问限制';
COMMENT ON COLUMN tb_share_service_check.f_frequency IS '访问频率限制';


-- tb_share_service_collection definition

-- Drop table

-- DROP TABLE tb_share_service_collection;

CREATE TABLE tb_share_service_collection (
	f_id varchar(32) NOT NULL,
	f_serviceid varchar(32) NULL,
	f_userid varchar(32) NULL,
	f_type int4 NULL,
	CONSTRAINT tb_share_service_collection_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share_service_collection.f_id IS '唯一标识';
COMMENT ON COLUMN tb_share_service_collection.f_serviceid IS '服务id';
COMMENT ON COLUMN tb_share_service_collection.f_userid IS '用户id';
COMMENT ON COLUMN tb_share_service_collection.f_type IS '服务类别';


-- tb_share_service_copy definition

-- Drop table

-- DROP TABLE tb_share_service_copy;

CREATE TABLE tb_share_service_copy (
	f_id varchar(32) NOT NULL,
	f_applyid varchar(32) NOT NULL,
	f_copyusername varchar(255) NULL,
	f_copyunitname varchar(255) NULL,
	f_copydate timestamp(6) NULL,
	CONSTRAINT tb_share_service_copy_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share_service_copy.f_id IS '唯一标识';
COMMENT ON COLUMN tb_share_service_copy.f_applyid IS '申请id';
COMMENT ON COLUMN tb_share_service_copy.f_copyusername IS '拷贝人名称';
COMMENT ON COLUMN tb_share_service_copy.f_copyunitname IS '拷贝人所在单位名称';
COMMENT ON COLUMN tb_share_service_copy.f_copydate IS '拷贝日期';


-- tb_share_service_group definition

-- Drop table

-- DROP TABLE tb_share_service_group;

CREATE TABLE tb_share_service_group (
	f_id varchar(32) NOT NULL,
	f_name varchar(64) NULL,
	f_desc text NULL,
	f_labels varchar(255) NULL,
	f_iconimageurl varchar(255) NULL,
	f_realiconimageurl varchar(255) NULL,
	f_contentimageurl varchar(255) NULL,
	f_realcontentimageurl varchar(255) NULL,
	f_type int4 NULL,
	f_homedesc text NULL,
	f_homeimageurl varchar(255) NULL,
	CONSTRAINT tb_share_service_group_copy1_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share_service_group.f_id IS '唯一标识';
COMMENT ON COLUMN tb_share_service_group.f_name IS '分组名称';
COMMENT ON COLUMN tb_share_service_group.f_desc IS '描述';
COMMENT ON COLUMN tb_share_service_group.f_labels IS '标签';
COMMENT ON COLUMN tb_share_service_group.f_iconimageurl IS '缩略图图片minio相对地址';
COMMENT ON COLUMN tb_share_service_group.f_realiconimageurl IS '缩略图图片minio相对地址';
COMMENT ON COLUMN tb_share_service_group.f_contentimageurl IS '缩略图图片minio相对地址';
COMMENT ON COLUMN tb_share_service_group.f_realcontentimageurl IS '缩略图图片minio相对地址';
COMMENT ON COLUMN tb_share_service_group.f_type IS '服务类型：地图服务，组件服务，分析服务、云资源服务';
COMMENT ON COLUMN tb_share_service_group.f_homedesc IS '首页描述';
COMMENT ON COLUMN tb_share_service_group.f_homeimageurl IS '首页图片地址';


-- tb_share_service_params definition

-- Drop table

-- DROP TABLE tb_share_service_params;

CREATE TABLE tb_share_service_params (
	f_id varchar(32) NOT NULL,
	f_serviceid varchar(32) NULL,
	f_name varchar(64) NULL,
	f_type int4 NULL,
	f_required int2 NULL,
	f_desc text NULL,
	f_default text NULL,
	f_order int2 NULL,
	f_direction int4 NULL,
	f_aliasname varchar(255) NULL,
	CONSTRAINT tb_biz_manager_service_params_copy1_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share_service_params.f_id IS '唯一标识';
COMMENT ON COLUMN tb_share_service_params.f_serviceid IS ' 接口id';
COMMENT ON COLUMN tb_share_service_params.f_name IS '参数名称';
COMMENT ON COLUMN tb_share_service_params.f_type IS '参数类型';
COMMENT ON COLUMN tb_share_service_params.f_required IS '是否必须';
COMMENT ON COLUMN tb_share_service_params.f_desc IS '参数描述';
COMMENT ON COLUMN tb_share_service_params.f_default IS '默认值';
COMMENT ON COLUMN tb_share_service_params.f_order IS '顺序';
COMMENT ON COLUMN tb_share_service_params.f_direction IS '输入还是输出参数；0代表输入，1代表输出';
COMMENT ON COLUMN tb_share_service_params.f_aliasname IS '别名';


-- tb_share_service_task definition

-- Drop table

-- DROP TABLE tb_share_service_task;

CREATE TABLE tb_share_service_task (
	f_id varchar NOT NULL,
	f_taskid int4 NULL,
	f_status int4 NULL,
	f_progress int4 NULL,
	f_param text NULL,
	f_group varchar(64) NULL,
	f_name varchar(255) NULL,
	f_createtime timestamp(6) NULL,
	f_starttime timestamp(6) NULL,
	f_endtime timestamp(6) NULL,
	f_handler varchar(255) NULL,
	f_desc text NULL,
	f_author varchar(255) NULL,
	CONSTRAINT tb_share_service_task_pkey PRIMARY KEY (f_id)
);


-- tb_share_service_token definition

-- Drop table

-- DROP TABLE tb_share_service_token;

CREATE TABLE tb_share_service_token (
	f_id varchar(32) NOT NULL,
	f_applyid varchar(32) NULL,
	f_serviceid varchar(32) NULL,
	f_token varchar(255) NULL,
	CONSTRAINT tb_biz_manager_service_token_copy1_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share_service_token.f_id IS '唯一标识';
COMMENT ON COLUMN tb_share_service_token.f_applyid IS '申请id';
COMMENT ON COLUMN tb_share_service_token.f_serviceid IS '服务id';
COMMENT ON COLUMN tb_share_service_token.f_token IS 'token';


-- tb_share_service_user definition

-- Drop table

-- DROP TABLE tb_share_service_user;

CREATE TABLE tb_share_service_user (
	f_id varchar(64) NOT NULL,
	f_applyid varchar(64) NULL,
	f_receivedate timestamp(6) NULL,
	f_userid varchar(64) NULL,
	f_username varchar(128) NULL,
	f_isreceive int2 NULL DEFAULT 0,
	CONSTRAINT tb_share_service_user_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share_service_user.f_id IS '主键';
COMMENT ON COLUMN tb_share_service_user.f_applyid IS '外键主表id';
COMMENT ON COLUMN tb_share_service_user.f_receivedate IS '接收日期';
COMMENT ON COLUMN tb_share_service_user.f_userid IS '接收人id';
COMMENT ON COLUMN tb_share_service_user.f_username IS '接收人名称';
COMMENT ON COLUMN tb_share_service_user.f_isreceive IS '接收状态';


-- tb_share_service_vector_extract definition

-- Drop table

-- DROP TABLE tb_share_service_vector_extract;

CREATE TABLE tb_share_service_vector_extract (
	f_id varchar(32) NOT NULL,
	f_applyid varchar(32) NULL,
	f_taskid varchar(32) NULL,
	f_range int2 NULL,
	f_extent text NULL,
	f_clip int4 NULL,
	f_orgtype int4 NULL,
	f_format varchar(32) NULL,
	f_xzqgroup varchar(255) NULL,
	f_serviceids text NULL,
	f_tableids text NULL,
	f_fields text NULL,
	f_filters text NULL,
	f_tablenames text NULL,
	f_datatype int2 NULL,
	f_applyinfo text NULL,
	f_applyrange varchar(255) NULL,
	CONSTRAINT tb_share_service_extract_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_share_service_vector_extract.f_id IS '唯一标识';
COMMENT ON COLUMN tb_share_service_vector_extract.f_applyid IS '申请id';
COMMENT ON COLUMN tb_share_service_vector_extract.f_taskid IS '任务id';
COMMENT ON COLUMN tb_share_service_vector_extract.f_range IS '0：代表按行政区划 ；1:代表任意范围';
COMMENT ON COLUMN tb_share_service_vector_extract.f_extent IS '传wkt或者行政区划代码';
COMMENT ON COLUMN tb_share_service_vector_extract.f_clip IS '0：代表不裁剪；1：代表裁剪';
COMMENT ON COLUMN tb_share_service_vector_extract.f_orgtype IS '组织方式';
COMMENT ON COLUMN tb_share_service_vector_extract.f_format IS 'gdb,mdb,shp';
COMMENT ON COLUMN tb_share_service_vector_extract.f_xzqgroup IS '行政区划组id';
COMMENT ON COLUMN tb_share_service_vector_extract.f_serviceids IS '申请的服务ids';
COMMENT ON COLUMN tb_share_service_vector_extract.f_tableids IS '申请数据实体ids';
COMMENT ON COLUMN tb_share_service_vector_extract.f_fields IS '申请的实体fields';
COMMENT ON COLUMN tb_share_service_vector_extract.f_filters IS '申请的实体filters';
COMMENT ON COLUMN tb_share_service_vector_extract.f_tablenames IS '申请数据实体名称';


-- tb_signature_base definition

-- Drop table

-- DROP TABLE tb_signature_base;

CREATE TABLE tb_signature_base (
	f_id varchar(64) NOT NULL,
	f_name varchar(255) NULL,
	f_xydhm varchar(64) NULL,
	f_ywlx int2 NULL,
	f_yzlx int2 NULL,
	f_user_name varchar NULL,
	f_user_id varchar(32) NULL,
	f_user_phone varchar NULL,
	f_address text NULL,
	f_telephone varchar NULL,
	f_create_time timestamp NULL,
	f_type int2 NULL,
	f_excerpt text NULL,
	f_del int2 NULL,
	f_email varchar(255) NULL,
	CONSTRAINT tb_signature_base_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_signature_base IS '电子签章 - 签章信息表';

-- Column comments

COMMENT ON COLUMN tb_signature_base.f_name IS '名称';
COMMENT ON COLUMN tb_signature_base.f_xydhm IS '统一社会信用代码';
COMMENT ON COLUMN tb_signature_base.f_ywlx IS '业务类型 1.签章新办 2.签章补办  3.签章注销 4.签章更新';
COMMENT ON COLUMN tb_signature_base.f_yzlx IS '用章类型 1.分散式用章  2.集中式用章';
COMMENT ON COLUMN tb_signature_base.f_user_name IS '经办人名称';
COMMENT ON COLUMN tb_signature_base.f_user_id IS '经办人身份证';
COMMENT ON COLUMN tb_signature_base.f_user_phone IS '经办人手机号';
COMMENT ON COLUMN tb_signature_base.f_address IS '通讯地址';
COMMENT ON COLUMN tb_signature_base.f_telephone IS '单位电话';
COMMENT ON COLUMN tb_signature_base.f_create_time IS '登记时间';
COMMENT ON COLUMN tb_signature_base.f_type IS '申请状态  1.申请中 2.已备案';
COMMENT ON COLUMN tb_signature_base.f_excerpt IS '样章';
COMMENT ON COLUMN tb_signature_base.f_del IS '逻辑删除 0.删除 1.正常';
COMMENT ON COLUMN tb_signature_base.f_email IS '邮箱';


-- tb_signature_cancellation definition

-- Drop table

-- DROP TABLE tb_signature_cancellation;

CREATE TABLE tb_signature_cancellation (
	f_id varchar(64) NOT NULL,
	f_create_time timestamp NULL,
	f_name varchar(255) NULL,
	f_info text NULL,
	f_user varchar NULL,
	f_sid varchar(64) NULL,
	CONSTRAINT tb_signature_cancellation_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_signature_cancellation IS '电子签章 - 公章作废';

-- Column comments

COMMENT ON COLUMN tb_signature_cancellation.f_create_time IS '作废时间';
COMMENT ON COLUMN tb_signature_cancellation.f_name IS '印章名称';
COMMENT ON COLUMN tb_signature_cancellation.f_info IS '作废原因';
COMMENT ON COLUMN tb_signature_cancellation.f_user IS '作废人';
COMMENT ON COLUMN tb_signature_cancellation.f_sid IS '公章发放关联id';

-- tb_signature_issue definition

-- Drop table

-- DROP TABLE tb_signature_issue;

CREATE TABLE tb_signature_issue (
	f_id varchar(64) NOT NULL,
	f_create_time timestamp NULL,
	f_name varchar(255) NULL,
	f_department varchar(255) NULL,
	f_user_name varchar NULL,
	f_issue_user varchar NULL,
	f_status int2 NULL,
	f_stop_user varchar NULL,
	f_stop_time timestamp NULL,
	f_type varchar NULL,
	f_pid varchar(64) NULL,
	CONSTRAINT tb_signature_issue_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_signature_issue IS '电子签章 - 发放记录表';

-- Column comments

COMMENT ON COLUMN tb_signature_issue.f_create_time IS '发放时间';
COMMENT ON COLUMN tb_signature_issue.f_name IS '印章名称';
COMMENT ON COLUMN tb_signature_issue.f_department IS '接收单位';
COMMENT ON COLUMN tb_signature_issue.f_user_name IS '接收人';
COMMENT ON COLUMN tb_signature_issue.f_issue_user IS '下发任';
COMMENT ON COLUMN tb_signature_issue.f_status IS '启用状态 1.启用 2.关闭';
COMMENT ON COLUMN tb_signature_issue.f_stop_user IS '停用人';
COMMENT ON COLUMN tb_signature_issue.f_stop_time IS '停用时间';
COMMENT ON COLUMN tb_signature_issue.f_type IS '操作限制 1.启用盖章 2.启用打印  1,2 全部';


-- tb_signature_log definition

-- Drop table

-- DROP TABLE tb_signature_log;

CREATE TABLE tb_signature_log (
	f_id varchar(64) NOT NULL,
	f_user varchar NULL,
	f_type varchar NULL,
	f_create_time timestamp NULL,
	CONSTRAINT tb_signature_log_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_signature_log IS '电子签章 - 日志记录';

-- Column comments

COMMENT ON COLUMN tb_signature_log.f_user IS '操作人';
COMMENT ON COLUMN tb_signature_log.f_type IS '操作类型： create 、issue 、cancel 、stop 、start';
COMMENT ON COLUMN tb_signature_log.f_create_time IS '创建时间';

INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10006, '三维分析', 13, 0, '', 'DIC_3DService');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10007, '单位', 2, 0, '', '单位');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10008, '数据更新字段映射', 18, 0, NULL, 'DIC_UpdateFieldMap');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10009, '更新类型', 14, 0, NULL, 'DIC_UpdateType');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10010, '数据年份', 15, 0, '', 'FZX_ProductDate');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10011, '数据批次', 13, 0, '', 'FZX_DataBatch');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10012, '数据来源', 15, 0, '', 'FZX_DataSources');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10013, '数据阶段', 13, 0, '', 'FZX_DataPhase');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10015, '地名地址', 14, 0, 'http://intenal.geoway-atlas.com:31280/ime-cloud/rest/POI_gd/place', 'DIC_PoiService');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10018, '在线分析', 4, 0, '在线分析插件配置', '在线分析');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10019, '专题分析算法', 17, 0, '', 'AnalysisAlgorithm');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10020, '在线分析', 5, 0, '在线分析目录', 'atlas');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10024, '用户体系', 9, 0, '', 'DIC_OAUTH');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10025, '字段类型', 14, 0, '', 'DIC_Field_Type');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10028, '专题分析模板配置', 20, 0, '', 'specific_template');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10031, '汇总统计', 20, 0, '汇总统计相关字典配置', 'DIC_SummaryStatistic');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10032, '服务中心-空间参考', 11, 0, '', 'service_srs');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10033, '服务中心-数据年份', 12, 0, '', 'service_year');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(100301, '国土空间规划用途分类', 14, 0, '国土空间规划用途分类', 'DIC_GTKJGHYTFL');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(100331, '国土空间规划建设用地用途分类', 18, 0, '国土空间规划建设用地用途分类', 'DIC_GTKJGHJSYDYTFL');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(100321, '国土空间规划分区代码表', 12, 0, '国土空间规划分区代码表', 'DIC_GTKJGHFQ');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10034, 'Excel模板管理', 17, 0, 'Excel模板管理', 'ExcelTemplate_DIC');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10035, '云查询配置', 14, 0, '', 'DIC_CLOUDQUERY');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10039, '机构资源单位类型', 12, 0, '', 'DIC_JgzyType');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10040, '信息平台工具资源', 16, 0, '信息平台智能工具资源', 'XXPT_TOOL_SOURCE');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10041, '信息平台工具类别', 14, 0, '', 'XXPT_TOOL_TYPE');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10044, '资源发现-业务类别', 13, 0, '', 'ZYFX_YWLB_DIC');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10045, '资源发现-信息资源格式类型', 17, 0, '', 'ZYFX_XXZYGSLX_DIC');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10046, '资源发现- 安全级别', 13, 0, '', 'ZYFX_SJMJ_DIC');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10047, '资源发现-资源主题', 13, 0, '资源发现-资源主题', 'ZYFX_ZYZT_DIC');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10048, '资源发现-主管单位', 13, 0, '资源发现-主管单位', 'ZYFX_ZGDW_DIC');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10049, '建筑结构', 4, 0, '', 'JZJG');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10050, '查封类型', 4, 0, '', 'CFLX');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10051, '更正登记类型', 6, 0, '', 'gzdjlx');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10052, '权利类型', 4, 0, '', 'qllx');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10053, '预告登记种类', 6, 0, '', 'ygdjzl');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10054, '权属性质', 4, 0, '', 'qsxz');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10055, '模型压平', 15, 0, '', 'Modelflattening');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10056, '资源发现-注册单位', 13, 0, '', 'ZYFX_SCDW_DIC');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10057, '资源发现-更新频次', 13, 0, '', 'ZYFX_GXPC_DIC');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10058, '资源发现-数据格式', 13, 0, '', 'ZYFX_SJGS_DIC');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10059, '数据汇交-汇交方式', 9, 0, '', 'sjhj-hjfs');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10060, '资源发现-覆盖范围', 13, 0, '', 'ZYFX_FGFW_DIC');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10061, '数据汇交-数据阶段', 14, 0, '数据汇交字典', 'sjhj-dataStage');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10062, '数据汇交-单位类型', 13, 0, '数据汇交字典', 'sjhj-unitType');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10063, '建设用地管制区类型', 9, 0, '', 'jsydgzqlx');
INSERT INTO tbdm_domain
(f_dicno, f_dicname, f_diccodelen, f_dictype, f_dicdesc, f_key)
VALUES(10064, '耕地等别', 4, 0, '', 'gddb');

SELECT pg_catalog.setval('tbdm_domain_f_dicno_seq', 11000, true);

INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10052, 'slope', '坡度坡向', 'http://intenal.geoway-atlas.com:31280/ime-cloud/rest/dem30_1_15/terrain/analyst?mode=all', -1, 1, 10006, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10057, 'volume', '方量分析', 'http://intenal.geoway-atlas.com:31280/ime-cloud/rest/dem30_1_15/terrain/earthwork', -1, 0, 10006, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10058, 'F_UPDATETYPE', '更新类型', NULL, -1, 0, 10008, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10059, 'F_UPDATETIME', '更新时间', NULL, -1, 1, 10008, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10061, 'F_GUID', '要素唯一标识', NULL, -1, 2, 10008, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10062, '0', '未更新', NULL, -1, 0, 10009, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10063, '1', '图形修改', NULL, -1, 1, 10009, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10064, '2', '属性修改', NULL, -1, 2, 10009, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10065, '3', '图属修改', NULL, -1, 3, 10009, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10066, 'water_space', '水下空间', 'http://intenal.geoway-atlas.com:31080/ime-cloud/rest/wmts_syh/wmts', -1, 2, 10006, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10067, '4', '增加', NULL, -1, 4, 10009, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10068, '5', '删除', NULL, -1, 5, 10009, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10069, '2019', '2019', '', -1, 0, 10042, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10070, '2020', '2020', '', -1, 1, 10042, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10073, '2021', '2021', '', -1, 2, 10042, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10075, '2022', '2022', '', -1, 3, 10042, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11152, 'terrain-flood', '淹没分析', '', -1, 11, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11153, 'earth-stratify', '三维立体分层', '', -1, 12, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10080, 'GJXF', '国家下发', '', -1, 0, 10045, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10081, 'DFHJ', '地方汇交', '', -1, 1, 10045, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10082, 'QTBMGX', '其他部门共享', '', -1, 2, 10045, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10083, 'XYSJZH', '现有数据整合', '', -1, 3, 10045, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10084, 'QT', '其他', '', -1, 4, 10045, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11154, 'scheme', '场景组装', '', -1, 13, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11155, 'online-query', '在线查询', '', -1, 14, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10089, 'true', 'enable', '是否启用单点登录', -1, 1, 10079, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10090, 'http://127.0.0.1:8058/design', 'uisurl', '单点登录地址', -1, 2, 10079, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10091, 'gw12e2e62b-5b36-4d09-b1dc-2881ff6e9aa2', 'appkey', '应用key', -1, 3, 10079, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10092, 'a1d95c39-c928-4efb-b426-7795fbe7984e', 'appsecret', '应用密钥', -1, 4, 10079, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10093, '7200', 'timeout', 'token过期时间（单位：秒）', -1, 5, 10079, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10109, '基础调查现状分析', '基础调查现状分析', '', -1, 0, 10018, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10115, '设施农用地分析', '设施农用地分析', '', 10114, 0, 10018, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10116, '通用分析', '通用分析', '', -1, 3, 10018, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10111, '基础调查流量分析', '基础调查流量分析', '', -1, 1, 10018, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10112, '二三调流量分析', '二三调流量分析', '', 10111, 0, 10018, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10114, '地类专题分析', '地类专题分析', '', -1, 2, 10018, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10118, '汇总统计', '汇总统计', '', 10116, 1, 10018, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10119, '字段计算', '字段计算', '', 10116, 2, 10018, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10108, 'DIC_PoiService', 'POI_china', 'http://atlas.geoway.com.cn:31580/ime-cloud/rest/POI_china/place', -1, 0, 10015, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10117, 'TYDJTJMX', '叠加统计', '', 10116, 0, 10018, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10110, '三调数据现状分析', '三调数据现状分析', '', 10109, 0, 10018, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11156, 'historyBack', '历史回溯', '', -1, 15, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11157, 'slope-aspect', '坡度坡向分析', '', -1, 16, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11158, 'contour', '等高线', '', -1, 17, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10145, '1', '汇总统计', '', 10143, 1, 10020, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10146, '1', '字段计算', '', 10143, 2, 10020, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11159, 'through-analysis', '通视分析', '', -1, 18, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10144, 'af269545-52a6-41b5-a7e2-bffc9623daad', '叠加统计', '1', 10143, 0, 10020, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11160, 'viewshed', '视域分析', '', -1, 19, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10123, 'EDDLFX_Ministry', '二调地类分析（部算法）', 'com.cn.geoserver4.baseservice.yzfx.service._000000.DLFX.DLFXService', -1, 1, 10019, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10124, 'SDDLFX_Ministry', '三调地类分析（部算法）', 'com.cn.geoserver4.baseservice.yzfx.service._000000.SDDLFX.SDDLFXService', -1, 2, 10019, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10125, 'TKJSDDLFX', '同口径三调地类分析算法', 'com.cn.geoserver4.baseservice.yzfx.service._000000.TKJ_SDDLFX.TKJ_SDDLFXService', -1, 3, 10019, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10122, 'EDDLFX_Ministry', '通用算法', '', -1, 0, 10019, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10126, '基础调查现状分析', '基础调查现状分析', '', -1, 0, 10020, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10130, '1', '三调数据现状分析', '', 10126, 0, 10020, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10131, '1', '三调同口径数据现状分析', '', 10126, 1, 10020, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10132, '1', '二调数据现状分析', '', 10126, 2, 10020, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10127, '基础调查流量分析', '基础调查流量分析', '', -1, 1, 10020, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10133, '1', '二三调流量分析', '', 10127, 0, 10020, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10134, '1', '三调与三调变更流量分析', '', 10127, 1, 10020, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10135, '专题分析工具', '专题分析工具', '', -1, 2, 10020, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10136, '1', '设施农用地分析', '', 10135, 0, 10020, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10137, '1', '林地分析', '', 10135, 1, 10020, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10138, '1', '临时用地分析', '', 10135, 2, 10020, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10139, '1', '批而未用分析', '', 10135, 3, 10020, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10140, '1', '珠三角村镇工业聚集区', '', 10135, 4, 10020, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10141, '1', '土地卫片执法', '', 10135, 5, 10020, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10142, '1', '遥感监测分析', '', 10135, 6, 10020, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10143, '通用分析', '通用分析', '', -1, 3, 10020, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20702, '0702', '文化用地', NULL, 100007, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20703, '0703', '教育用地', NULL, 100007, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20704, '0704', '体育用地', NULL, 100007, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20705, '0705', '医疗卫生用地', NULL, 100007, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20706, '0706', '社会福利用地', NULL, 100007, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20707, '0707', '科研用地', NULL, 100007, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20708, '0708', '外事用地', NULL, 100007, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20709, '0709', '文物古迹用地', NULL, 100007, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20801, '0801', '商业服务用地', NULL, 100008, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20802, '0802', '商务办公用地', NULL, 100008, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20803, '0803', '批发市场用地', NULL, 100008, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20804, '0804', '娱乐康体用地', NULL, 100008, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20805, '0805', '农村游览接待用地', NULL, 100008, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20806, '0806', '其他商服用地', NULL, 100008, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20901, '0901', '一类工业用地', NULL, 100009, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20902, '0902', '二类工业用地', NULL, 100009, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20903, '0903', '三类工业用地', NULL, 100009, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21001, '1001', '一类物流仓储用地', NULL, 100010, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10649, 'url', '服务地址', '', -1, 0, 10024, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10650, '0', '整型', 'Integer', -1, 0, 10025, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10651, '4', '字符型', 'String', -1, 1, 10025, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10652, '9', '日期型', 'Date', -1, 2, 10025, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10707, 'sd-year', 'sd-year', '汇总统计三调年份', -1, 0, 10031, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10708, '2019', '2019', '', 10707, 0, 10031, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10709, 'xzq-level', 'xzq-level', '汇总统计行政级别', -1, 1, 10031, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10710, '省级', '1', '', 10709, 0, 10031, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10711, '地市级', '2', '', 10709, 1, 10031, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10712, '县级', '3', '', 10709, 2, 10031, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10713, '乡镇级', '4', '', 10709, 3, 10031, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10714, '村级', '5', '', 10709, 4, 10031, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10715, 'area-unit', 'area-unit', '汇总统计面积单位', -1, 2, 10031, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10716, '公顷', '1', '', 10715, 0, 10031, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10717, '万亩', '0.0015', '', 10715, 1, 10031, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10718, '平方米', '10000', '', 10715, 2, 10031, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10719, '亩', '15', '', 10715, 3, 10031, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10720, '西安80', '西安80', '', -1, 0, 10032, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10721, '北京54', '北京54', '', -1, 1, 10032, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11161, 'skyline', '天际线', '', -1, 20, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11162, 'sun-analysis', '日照分析', '', -1, 21, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11163, 'height-limit', '控高分析', '', -1, 22, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10669, '["", "CustomDLStat"]', 'customExclude', '自定义压占分析中被屏蔽项目列表，tag控制', -1, 4, 10017, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11164, 'volume', '填挖方', '', -1, 23, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10676, 'tymb', '通用模板', '通用模板', -1, 0, 10028, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10677, 'edbg', '二调表格-定制模板', '二调表格-定制模板', -1, 1, 10028, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10678, 'sdbg', '三调表格-定制模板', '三调表格-定制模板', -1, 2, 10028, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10679, 'sdtkj', '三调同口径表格-定制模板', '三调同口径表格-定制模板', -1, 3, 10028, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10680, 'zyzc', '资源资产', '资源资产', -1, 4, 10028, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11165, 'terrain-profile', '地形剖面', '', -1, 24, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10722, 'CGCS2000', 'CGCS2000', '', -1, 2, 10032, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10723, '2009', '2009', '', -1, 0, 10033, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10724, '2010', '2010', '', -1, 1, 10033, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10725, '2011', '2011', '', -1, 2, 10033, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10727, '2012', '2012', '', -1, 3, 10033, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10726, '2013', '2013', '', -1, 4, 10033, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10729, '2014', '2014', '', -1, 5, 10033, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10730, '2015', '2015', '', -1, 6, 10033, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10731, '2016', '2016', '', -1, 7, 10033, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10732, '2017', '2017', '', -1, 8, 10033, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10733, '2018', '2018', '', -1, 9, 10033, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10734, '2019', '2019', '', -1, 10, 10033, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21302, '1302', '防护绿地', NULL, 100013, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21303, '1303', '广场用地', NULL, 100013, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21501, '1501', '铁路用地', NULL, 100015, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100001, '01', '耕地', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100002, '02', '种植园用地', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100003, '03', '林地', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100004, '04', '牧草地', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100005, '05', '其他农用地', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100006, '06', '居住用地', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100007, '07', '公共管理与公共服务设施用地', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100008, '08', '商服用地', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100009, '09', '工业用地', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100010, '10', '物流仓储用地', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100011, '11', '道路与交通设施用地', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100012, '12', '公共设施用地', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100013, '13', '绿地与广场用地', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100014, '14', '留白用地', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100015, '15', '区域基础设施用地', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100016, '16', '特殊用地', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100017, '17', '采矿盐田用地', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100018, '18', '湿地', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100019, '19', '其他自然保留地', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100020, '20', '陆地水域', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100021, '21', '渔业用海', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100022, '22', '工业与矿产能源用海', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11166, 'geobody-cutting', '地质体剖切', '', -1, 25, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11167, 'plane-cutting', '平面剖切', '', -1, 26, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11168, 'model-flatten', '模型压平', '', -1, 27, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11169, 'model-cutting', '模型剖面', '', -1, 28, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11170, 'terrain-excavation', '地形开挖', '', -1, 29, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11171, 'terrain-flat', '地形整平', '', -1, 30, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11172, 'terrain-exaggeration', '地形夸张', '', -1, 31, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11173, 'ellipsoid-line', '直线测距', '', -1, 32, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11182, 'azimuth', '方位角量测', '', -1, 41, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11183, 'volume-measure', '体积量测', '', -1, 42, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11184, 'plotting-map', '三维标绘', '', -1, 43, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11185, 'simple-draw', '二维标绘', '', -1, 44, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11186, 'map-measure-len', '二维测距', '', -1, 45, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11187, 'map-measure-area', '二维测面', '', -1, 46, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11188, 'RealtyQuery', '不动产查询', '', -1, 47, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11189, '010', '允许建设区', '', -1, 0, 10063, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11193, '1', '1', '', -1, 0, 10064, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11194, '2', '2', '', -1, 1, 10064, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11195, '3', '3', '', -1, 2, 10064, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11196, '4', '4', '', -1, 3, 10064, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11197, '5', '5', '', -1, 4, 10064, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11198, '6', '6', '', -1, 5, 10064, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11202, 'BD_DIC', '百度搜索', 'http://baiduxx.xxx', -1, 2, 10015, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11201, 'GD_DIC', '高德搜索', 'http://', -1, 1, 10015, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10675, '4.0', 'version', '版本', -1, 4, 10017, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11174, 'spatial-distance', '水平测距', '', -1, 33, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11175, 'height-diff', '垂直测距', '', -1, 34, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11176, 'floor-distance', '贴地测距', '', -1, 35, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11177, 'triangulation', '三角测量', '', -1, 36, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11178, 'ellipsoid-polygon', '投影面积', '', -1, 37, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11179, 'horizontal-area', '空间面积', '', -1, 38, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11180, 'floor-area', '地表面积', '', -1, 39, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11181, 'triangle-angle', '夹角量测', '', -1, 40, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11190, '020', '有条件建设区', '', -1, 1, 10063, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11191, '030', '限制建设区', '', -1, 2, 10063, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11192, '040', '禁止建设区', '', -1, 3, 10063, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(22204, '2204', '油气开采用海', NULL, 100022, 0, 100301, 0);


INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11218, 'TdtpQuery', '土地图谱', '', -1, 52, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11219, 'SelectionLoaction', '优化选址', '', -1, 51, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11220, 'TowerViewshed', '铁塔可视域', '', -1, 50, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11221, 'pick-position', '坐标拾取', '', -1, 49, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11222, 'mapsheet-location', '图幅定位', '', -1, 48, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100023, '23', '交通运输用海', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100024, '24', '旅游娱乐用海', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100025, '25', '特殊用海', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100026, '26', '可利用无居民海岛', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100027, '27', '保护海域海岛', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100028, '28', '保留海域海岛', NULL, -1, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20101, '0101', '水田', NULL, 100001, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20102, '0102', '水浇地', NULL, 100001, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20103, '0103', '旱地', NULL, 100001, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20201, '0201', '果园', NULL, 100002, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20202, '0202', '茶园', NULL, 100002, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20203, '0203', '橡胶园', NULL, 100002, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20204, '0204', '其他园地', NULL, 100002, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20301, '0301', '乔木林地', NULL, 100003, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20302, '0302', '竹林地', NULL, 100003, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20303, '0303', '灌木林地', NULL, 100003, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20304, '0304', '其他林地', NULL, 100003, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20401, '0401', '天然牧草地', NULL, 100004, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20402, '0402', '人工牧草地', NULL, 100004, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20501, '0501', '设施农用地', NULL, 100005, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20502, '0502', '农村道路', NULL, 100005, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20503, '0503', '田坎', NULL, 100005, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20504, '0504', '坑塘水面', NULL, 100005, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20505, '0505', '沟渠', NULL, 100005, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20601, '0601', '城镇居住用地', NULL, 100006, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20602, '0602', '农村居住用地', NULL, 100006, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(20701, '0701', '行政办公用地', NULL, 100007, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21002, '1002', '二类物流仓储用地', NULL, 100010, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21003, '1003', '危险品物流仓储用地', NULL, 100010, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21101, '1101', '城镇道路用地', NULL, 100011, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21102, '1102', '村庄道路用地', NULL, 100011, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21103, '1103', '城市轨道交通用地', NULL, 100011, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21104, '1104', '交通枢纽用地', NULL, 100011, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21105, '1105', '交通场站用地', NULL, 100011, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21106, '1106', '加油加气站用地', NULL, 100011, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21107, '1107', '其他交通设施用地', NULL, 100011, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21201, '1201', '供水用地', NULL, 100012, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21202, '1202', '排水用地', NULL, 100012, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21203, '1203', '供电用地', NULL, 100012, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21204, '1204', '供燃气用地', NULL, 100012, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21205, '1205', '供热用地', NULL, 100012, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21206, '1206', '通信用地', NULL, 100012, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21207, '1207', '广播电视用地', NULL, 100012, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21208, '1208', '环卫用地', NULL, 100012, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21209, '1209', '消防用地', NULL, 100012, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21210, '1210', '防洪用地', NULL, 100012, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21211, '1211', '其他公用设施用地', NULL, 100012, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21301, '1301', '公园绿地', NULL, 100013, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21502, '1502', '公路用地', NULL, 100015, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21503, '1503', '港口码头用地', NULL, 100015, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21504, '1504', '机场用地', NULL, 100015, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21505, '1505', '管道运输用地', NULL, 100015, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21506, '1506', '区域公共设施用地', NULL, 100015, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21601, '1601', '军事用地', NULL, 100016, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21602, '1602', '宗教用地', NULL, 100016, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21603, '1603', '安保用地', NULL, 100016, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21604, '1604', '殡葬用地', NULL, 100016, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21605, '1605', '储备库用地', NULL, 100016, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21606, '1606', '其他特殊用地', NULL, 100016, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21701, '1701', '采矿用地', NULL, 100017, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21702, '1702', '盐田', NULL, 100017, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21801, '1801', '红树林地', NULL, 100018, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21802, '1802', '沼泽', NULL, 100018, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21803, '1803', '滩涂', NULL, 100018, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21901, '1901', '盐碱地', NULL, 100019, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21902, '1902', '沙地', NULL, 100019, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21903, '1903', '裸土地', NULL, 100019, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21904, '1904', '裸岩石砾地', NULL, 100019, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(21905, '1905', '其他草地', NULL, 100019, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(22001, '2001', '河流水面', NULL, 100020, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(22002, '2002', '湖泊水面', NULL, 100020, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(22003, '2003', '水库水面', NULL, 100020, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(22004, '2004', '冰川及永久积雪', NULL, 100020, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(22101, '2101', '渔业基础设施用海', NULL, 100021, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(22102, '2102', '增养殖用海', NULL, 100021, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(22201, '2201', '工业用海', NULL, 100022, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(22202, '2202', '盐业用海', NULL, 100022, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(22203, '2203', '固体矿产开采用海', NULL, 100022, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(22205, '2205', '可再生能源用海', NULL, 100022, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(22301, '2301', '港口用海', NULL, 100023, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(22302, '2302', '航运用海', NULL, 100023, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(22303, '2303', '路桥用海', NULL, 100023, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(22401, '2401', '风景旅游用海', NULL, 100024, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(22402, '2402', '文体休闲娱乐用海', NULL, 100024, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(22501, '2501', '军事用海', NULL, 100025, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(22502, '2502', '其他特殊用海', NULL, 100025, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30001, '060101', '一类住宅用地', NULL, 20601, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30002, '060102', '二类住宅用地', NULL, 20601, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30003, '060103', '三类住宅用地', NULL, 20601, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30004, '060104', '社区服务设施用地', NULL, 20601, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30005, '060201', '一类宅基地', NULL, 20602, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30006, '060202', '二类宅基地', NULL, 20602, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30007, '060203', '农村社区服务设施用地', NULL, 20602, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30008, '060204', '农村生产服务设施用地', NULL, 20602, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30009, '070201', '图书博览用地', NULL, 20702, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30010, '070202', '文化活动用地', NULL, 20702, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30011, '070301', '高等教育用地', NULL, 20703, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30012, '070302', '中等职业教育用地', NULL, 20703, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30013, '070303', '中小学用地', NULL, 20703, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30014, '070304', '特殊教育用地', NULL, 20703, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30015, '070401', '体育场馆用地', NULL, 20704, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30016, '070402', '体育训练用地', NULL, 20704, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30017, '070501', '医院用地', NULL, 20705, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30018, '070502', '公共卫生用地', NULL, 20705, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30019, '070601', '老年人社会福利用地', NULL, 20706, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30020, '070602', '儿童社会福利用地', NULL, 20706, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30021, '070603', '残疾人社会福利用地', NULL, 20706, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30022, '070604', '其他社会福利用地', NULL, 20706, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30023, '110501', '公共交通场站用地', NULL, 21105, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(30024, '110502', '社会停车场用地', NULL, 21105, 0, 100301, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(103821, '100', '生态红线区', NULL, -1, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(103831, '200', '自然保留区', NULL, -1, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(103841, '300', '永久基本农田集中区', NULL, -1, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(103851, '400', '城镇发展区', NULL, -1, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(103981, '500', '农业农村发展区', NULL, -1, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(104031, '600', '海洋发展区', NULL, -1, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(103861, '410', '城镇集中建设区', NULL, 103851, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(103871, '411', '居住生活区', NULL, 103851, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(103881, '412', '综合服务区', NULL, 103851, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(103891, '413', '商业商务区', NULL, 103851, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(103901, '414', '工业物流区', NULL, 103851, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(103911, '415', '绿地休闲区', NULL, 103851, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(103921, '416', '交通枢纽区', NULL, 103851, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(103931, '417', '公用设施集中区', NULL, 103851, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(103941, '418', '战略预留区', NULL, 103851, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(103951, '419', '特色功能区', NULL, 103851, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(103961, '420', '城镇弹性发展区', NULL, 103851, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(103971, '430', '特别用途区', NULL, 103851, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(103991, '510', '村庄建设区', NULL, 103981, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(104001, '520', '一般农业区', NULL, 103981, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(104011, '530', '林业发展区', NULL, 103981, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(104021, '540', '牧业发展区', NULL, 103981, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(104041, '610', '渔业利用区', NULL, 104031, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(104051, '620', '交通运输用海区', NULL, 104031, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(104061, '630', '工业用海区', NULL, 104031, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(104071, '640', '矿产与能源用海区', NULL, 104031, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(104081, '650', '旅游休闲娱乐用海区', NULL, 104031, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(104091, '660', '特殊利用区', NULL, 104031, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(104101, '670', '无居民海岛利用区', NULL, 104031, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(104111, '680', '海洋预留区', NULL, 104031, 0, 100321, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100412, 'H', '建设用地', '包括城乡居民点建设用地、区域交通设施用地、区域公用设施用地、特殊用地、采矿用地等', -1, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100413, 'E', '非建设用地', '水域、农林等非建设用地', -1, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100414, 'R', '居住用地', '住宅和相应服务设施的用地', -1, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100416, 'B', '商业服务业设施用地', '各类商业、商务、娱乐康体等设施用地，不包括居住用地中的服务设施用地以及公共管理与公共服务用地内的事业单位用地', -1, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100417, 'M', '工业用地', '工矿企业的生产车间、库房及其附属设施等用地，包括专用铁路、码头和附属道路、停车场等用地，不包括露天矿用地', -1, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100418, 'W', '物流仓储用地', '物资储备、中转、配送等用地，包括附属道路、停车场以及货运公司车队的站场等用地', -1, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100419, 'S', '道路与交通设施用地', '城市道路、交通设施等用地，不包括居住用地、工业用地等内部的道路、停车场等用地', -1, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100420, 'U', '公用设施用地', '供应、环境、安全等设施用地', -1, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100421, 'G', '绿地与广场用地', '公园绿地、防护绿地、广场等公共开放空间用地', -1, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100422, 'H1', '城乡居民点建设用地', '城市、镇、乡、村庄以及独立的建设用地', 100412, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100423, 'H11', '城市建设用地', '城市和县人民政府所在地镇内的居住用地、公共管理与公共服务用地、商业服务业设施用地、工业用地、物流仓储用地、交通设施用地、公用设施用地、绿地', 100422, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100424, 'H12', '镇建设用地', '非县人民政府所在地镇的建设用地', 100422, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100425, 'H13', '乡建设用地', '乡人民政府驻地的建设用地', 100422, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100426, 'H14', '村庄建设用地', '农村居民点的建设用地', 100422, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100427, 'H2', '区域交通设施用地', '铁路、公路、港口、机场和管道运输等区域交通运输及其附属设施用地，不包括中心城区的铁路客货运站、公路长途客货运站以及港口客运码头', 100412, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100428, 'H21', '铁路用地', '铁路编组站、线路等用地', 100427, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100429, 'H22', '公路用地', '高速公路、国道、省道、县道和乡道用地及附属设施用地', 100427, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100430, 'H23', '港口用地', '海港和河港的陆域部分，包括码头作业区、辅助生产区等用地', 100427, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100431, 'H24', '机场用地', '民用及军民合用的机场用地，包括飞行区、航站区等用地', 100427, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100432, 'H25', '管道运输用地', '运输煤炭、石油和天然气等地面管道运输用地', 100427, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100433, 'H3', '区域公用设施用地', '为区域服务的公用设施用地，包括区域性能源设施、水工设施、通讯设施、殡葬设施、环卫设施、排水设施等用地', 100412, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100434, 'H4', '特殊用地', '特殊性质的用地', 100412, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100435, 'H41', '军事用地', '专门用于军事目的的设施用地，不包括部队家属生活区和军民共用设施等用地', 100434, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100436, 'H42', '安保用地', '监狱、拘留所、劳改场所和安全保卫设施等用地，不包括公安局用地', 100434, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100437, 'H5', '采矿用地', '采矿、采石、采沙、盐田、砖瓦窑等地面生产用地及尾矿堆放地', 100412, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100438, 'H9', '其他建设用地', '除以上之外的建设用地，包括边境口岸和风景名胜区、森林公园等的管理及服务设施等用地', 100412, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100439, 'E1', '水域', '河流、湖泊、水库、坑塘、沟渠、滩涂、冰川及永久积雪，不包括公园绿地及单位内的水域', 100413, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100440, 'E11', '自然水域', '河流、湖泊、滩涂、冰川及永久积雪', 100439, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100441, 'E12', '水库', '人工拦截汇集而成的总库容不小于10万m³的水库正常蓄水位岸线所围成的水面', 100439, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100442, 'E13', '坑塘沟渠', '蓄水量小于10万m³的坑塘水面和人工修建用于引、排、灌的渠道', 100439, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100443, 'E2', '农林用地', '耕地、园地、林地、牧草地、设施农用地、田坎、农村道路等用地', 100413, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100444, 'E9', '其他非建设用地', '空闲地、盐碱地', 100413, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100445, 'R1', '一类居住用地', '公用设施、交通设施和公共服务设施齐全、布局完整、环境良好的低层住区用地', 100414, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100446, 'R11', '住宅用地', '住宅建筑用地、住区内城市支路以下的道路、停车场及其社区附属绿地', 100445, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10755, '一级类统计-按任意范围', '一级类统计-按任意范围', '', -1, 5, 10034, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10756, '6', '起始行', '', 10755, 0, 10034, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10757, '2', '起始列', '', 10755, 1, 10034, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10758, 'HZTJ_YJL_RYFW_EXCEL', '服务名称', '', 10755, 2, 10034, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100447, 'R12', '服务设施用地', '住区主要公共设施和服务设施用地，包括幼托、文化体育设施、商业金融、社区卫生服务站、公用设施等用地，不包括中小学用地', 100445, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100448, 'R2', '二类居住用地', '公用设施、交通设施和公共服务设施较齐全、布局较完整、环境良好的多、中、高层住区用地', 100414, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100449, 'R20', '保障性住宅用地', '住宅建筑用地、住区内城市支路以下的道路、停车场及其社区附属绿地', 100448, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100450, 'R21', '住宅用地', '住宅建筑用地、住区内城市支路以下的道路、停车场及其社区附属绿地', 100448, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100451, 'R22', '服务设施用地', '住区主要公共设施和服务设施用地，包括幼托、文化体育设施、商业金融、社区卫生服务站、公用设施等用地，不包括中小学用地', 100448, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100452, 'R3', '三类居住用地', '公用设施、交通设施不齐全，公共服务设施较欠缺，环境较差，需要加以改造的简陋住区用地，包括危房、棚户区、临时住宅等用地', 100414, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100453, 'R31', '住宅用地', '住宅建筑用地、住区内城市支路以下的道路、停车场及其社区附属绿地', 100452, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100454, 'R32', '服务设施用地', '住区主要公共设施和服务设施用地，包括幼托、文化体育设施、商业金融、社区卫生服务站、公用设施等用地，不包括中小学用地', 100452, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100455, 'A1', '行政办公用地', '党政机关、社会团体、事业单位等机构及其相关设施用地', 100415, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100456, 'A2', '文化设施用地', '图书、展览等公共文化活动设施用地', 100415, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100457, 'A21', '图书展览设施用地', '公共图书馆、博物馆、科技馆、纪念馆、美术馆和展览馆、会展中心等设施用地', 100456, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100458, 'A22', '文化活动设施用地', '综合文化活动中心、文化馆、青少年宫、儿童活动中心、老年活动中心等设施用地', 100456, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100459, 'A3', '教育科研用地', '高等院校、中等专业学校、中学、小学、科研事业单位等用地，包括为学校配建的独立地段的学生生活用地', 100415, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100460, 'A31', '高等院校用地', '大学、学院、专科学校、研究生院、电视大学、党校、干部学校及其附属用地，包括军事院校用地', 100459, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100461, 'A32', '中等专业学校用地', '中等专业学校、技工学校、职业学校等用地，不包括附属于普通中学内的职业高中用地', 100459, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100462, 'A33', '中小学用地', '中学、小学用地', 100459, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100463, 'A34', '特殊教育用地', '聋、哑、盲人学校及工读学校等用地', 100459, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100464, 'A35', '科研用地', '科研事业单位用地', 100459, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100465, 'A4', '体育用地', '体育场馆和体育训练基地等用地，不包括学校等机构专用的体育设施用地', 100415, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100466, 'A41', '体育场馆用地', '室内外体育运动用地，包括体育场馆、游泳场馆、各类球场及其附属的业余体校等用地', 100465, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100467, 'A42', '体育训练用地', '为各类体育运动专设的训练基地用地', 100465, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100468, 'A5', '医疗卫生用地', '医疗、保健、卫生、防疫、康复和急救设施等用地', 100415, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100469, 'A51', '医院用地', '综合医院、专科医院、社区卫生服务中心等用地', 100468, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100470, 'A52', '卫生防疫用地', '卫生防疫站、专科防治所、检验中心和动物检疫站等用地', 100468, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100471, 'A53', '特殊医疗用地', '对环境有特殊要求的传染病、精神病等专科医院用地', 100468, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100472, 'A59', '其他医疗卫生用地', '急救中心、血库等用地', 100468, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100473, 'A6', '社会福利设施用地', '为社会提供福利和慈善服务的设施及其附属设施用地，包括福利院、养老院、孤儿院等用地', 100415, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100474, 'A7', '文物古迹用地', '具有历史、艺术、科学价值且没有其他使用功能的建筑物、构筑物、遗址、墓葬等用地', 100415, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100475, 'A8', '外事用地', '外国驻华使馆、领事馆、国际机构及其生活设施等用地', 100415, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100476, 'A9', '宗教设施用地', '宗教活动场所用地', 100415, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100477, 'B1', '商业用地', '各类商业经营活动及餐饮、旅馆等服务业用地', 100416, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100479, 'B11', '零售商业用地', '商铺、商场、超市、服装及小商品市场等用地,', 100477, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100480, 'B12', '批发市场用地', '以批发功能为主的市场用地', 100477, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100481, 'B13', '餐饮业用地', '饭店、餐厅、酒吧等用地,', 100477, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100482, 'B14', '旅馆用地', '宾馆、旅馆、招待所、服务型公寓、度假村等用地,', 100477, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100483, 'B2', '商务用地', '金融、保险、证券、新闻出版、文艺团体等综合性办公用地,', 100416, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100484, 'B21', '金融保险业用地', '银行及分理处、信用社、信托投资公司、证券期货交易所、保险公司，以及各类公司总部及综合性商务办公楼宇等用地,', 100483, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100485, 'B22', '艺术传媒产业用地', '音乐、美术、影视、广告、网络媒体等的制作及管理设施用地,', 100483, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100486, 'B29', '其他商务设施用地', '邮政、电信、工程咨询、技术服务、会计和法律服务以及其他中介服务等的办公用地,', 100483, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100487, 'B3', '娱乐康体用地', '各类娱乐、康体等设施用地,', 100416, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100488, 'B31', '娱乐用地', '单独设置的剧院、音乐厅、电影院、歌舞厅、网吧以及绿地率小于65%的大型游乐等设施用地,', 100487, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100489, 'B32', '康体用地', '单独设置的高尔夫练习场、赛马场、溜冰场、跳伞场、摩托车场、射击场，以及水上运动的陆域部分等用地,', 100487, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100490, 'B4', '公用设施营业网点用地', '零售加油、加气、电信、邮政等公用设施营业网点用地,', 100416, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100491, 'B41', '加油加气站用地', '零售加油、加气以及液化石油气换瓶站用地,', 100490, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100492, 'B49', '其他公用设施营业网点用地', '电信、邮政、供水、燃气、供电、供热等其他公用设施营业网点用地,', 100490, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100493, 'B9', '其他服务设施用地', '业余学校、民营培训机构、私人诊所、宠物医院等其他服务设施用地,', 100416, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100494, 'M1', '一类工业用地', '对居住和公共环境基本无干扰、污染和安全隐患的工业用地,', 100417, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100495, 'M2', '二类工业用地', '对居住和公共环境有一定干扰、污染和安全隐患的工业用地,', 100417, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100496, 'M3', '三类工业用地', '对居住和公共环境有严重干扰、污染和安全隐患的工业用地(需布置绿化防护用地),', 100417, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100497, 'W1', '一类物流仓储用地', '对居住和公共环境基本无干扰、污染和安全隐患的物流仓储用地,', 100418, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100498, 'W2', '二类物流仓储用地', '对居住和公共环境有一定干扰、污染和安全隐患的物流仓储用地,', 100418, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100499, 'W3', '三类物流仓储用地', '存放易燃、易爆和剧毒等危险品的专用物流仓储用地,', 100418, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100500, 'S1', '城市道路用地', '快速路、主干路、次干路和支路等用地，包括其交叉口用地,', 100419, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100501, 'S2', '轨道交通线路用地', '独立地段的城市轨道交通地面以上部分的线路、站点用地,', 100419, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100502, 'S3', '交通枢纽用地', '铁路客货运站、公路长途客货运站、港口客运码头、公交枢纽及其附属设施用地,', 100419, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100503, 'S4', '交通场站用地', '静态交通设施用地，不包括交通指挥中心、交通队用地,', 100419, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100504, 'S41', '公共交通场站用地', '公共汽车、出租汽车、轨道交通（地面部分）的车辆段、地面站、首末站、停车场（库）、保养场等用地，以及轮渡、缆车、索道等的地面部分及其附属设施用地,', 100503, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100505, 'S42', '社会停车场用地', '公共使用的停车场和停车库用地，不包括其他各类用地配建的停车场（库）用地,', 100503, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100506, 'S9', '其他交通设施用地', '除以上之外的交通设施用地，包括教练场等用地,', 100419, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100507, 'U1', '供应设施用地', '供水、供电、供燃气和供热等设施用地,', 100420, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100508, 'U11', '供水用地', '城市取水设施、水厂、加压站及其附属的构筑物用地，包括泵房和高位水池等用地,', 100507, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100509, 'U12', '供电用地', '变电站、配电所、高压塔基等用地，不包括各类发电设施用地,', 100507, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100510, 'U13', '供燃气用地', '分输站、门站、储气站、加气母站、液化石油气储配站、灌瓶站和地面输气管廊等用地,', 100507, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100511, 'U14', '供热用地', '集中供热锅炉房、热力站、换热站和地面输热管廊等用地,', 100507, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100512, 'U15', '通信用地', '邮政中心局、邮政支局、邮件处理中心等用地,', 100507, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100513, 'U16', '广播电视用地', '广播电视与通信系统的发射和接收设施等用地，包括发射塔、转播台、差转台、基站等用地,', 100507, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100514, 'U2', '环境设施用地', '雨水、污水、固体废物处理和环境保护设施及其附属设施用地,', 100420, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100515, 'U21', '排水用地', '雨水泵站、污水泵站、污水处理、污泥处理厂等设施及其附属的构筑物用地，不包括排水河渠用地,', 100514, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100516, 'U22', '环卫用地', '生活垃圾、医疗垃圾、危险废物处理（置），以及垃圾转运、公厕、车辆清洗、环卫车辆停放修理等设施用地,', 100514, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100517, 'U3', '安全设施用地', '消防、防洪等保卫城市安全的公用设施及其附属设施用地,', 100420, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100518, 'U31', '消防用地', '消防站、消防通信及指挥训练中心等设施用地,', 100517, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100519, 'U32', '防洪用地', '防洪堤、排涝泵站、防洪枢纽、排洪沟渠等防洪设施用地,', 100517, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100520, 'U9', '其他公用设施用地', '除以上之外的公用设施用地，包括施工、养护、维修设施等用地,', 100420, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100521, 'G1', '公园绿地', '向公众开放，以游憩为主要功能，兼具生态、美化、防灾等作用的绿地,', 100421, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100522, 'G2', '防护绿地', '具有卫生、隔离和安全防护功能的绿地,', 100421, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100523, 'G3', '广场用地', '以游憩、纪念、集会和避险等功能为主的城市公共活动场地,', 100421, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10735, '三大类统计-按行政区范围', '三大类统计-按行政区范围', '', -1, 0, 10034, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10736, '6', '起始行', '', 10735, 0, 10034, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10737, '2', '起始列', '', 10735, 1, 10034, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10738, 'HZTJ_SDL_XZQ_EXCEL', '服务名称', '', 10735, 2, 10034, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10739, '二级类统计-按行政区范围', '二级类统计-按行政区范围', '', -1, 1, 10034, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10740, '6', '起始行', '', 10739, 0, 10034, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10741, '2', '起始列', '', 10739, 1, 10034, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10742, 'HZTJ_EJL_XZQ_EXCEL', '服务名称', '', 10739, 2, 10034, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10743, '一级类统计-按行政区范围', '一级类统计-按行政区范围', '', -1, 2, 10034, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10744, '6', '起始行', '', 10743, 0, 10034, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10745, '2', '起始列', '', 10743, 1, 10034, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10746, 'HZTJ_YJL_XZQ_EXCEL', '服务名称', '', 10743, 2, 10034, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10747, '三大类统计-按任意范围', '三大类统计-按任意范围', '', -1, 3, 10034, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10748, '6', '起始行', '', 10747, 0, 10034, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10749, '2', '起始列', '', 10747, 1, 10034, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10750, 'HZTJ_SDL_RYFW_EXCEL', '服务名称', '', 10747, 2, 10034, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10751, '二级类统计-按任意范围', '二级类统计-按任意范围', '', -1, 4, 10034, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10752, '6', '起始行', '', 10751, 0, 10034, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10753, '2', '起始列', '', 10751, 1, 10034, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10754, 'HZTJ_EJL_RYFW_EXCEL', '服务名称', '', 10751, 2, 10034, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10785, '1', '自然资源部', '', -1, 0, 10039, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10786, '2', '厅直属单位', '', -1, 1, 10039, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10787, '3', '市州自然资源和规划局', '', -1, 2, 10039, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10788, '4', '区县自然资源和规划局', '', -1, 3, 10039, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10789, '5', '行业厅局', '', -1, 4, 10039, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10790, '6', '其他单位', '', -1, 5, 10039, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10101, 'http://172.16.67.105:86/geoserver-open', 'url', '分析服务引擎地址', -1, 0, 10017, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10791, 'cloud-query', '智能图审', '提供分析范围与各类成果数据的即时压占查询服务，可以有效辅助国土调查、建设用地审查报批、耕地“非粮化”“非农化”问题整治、“三区三线”划定、国土空间规划编制等工作。', -1, 0, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10806, 'analysistools', '分析工具', '', -1, 2, 10041, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10792, 'map-property-query', '图属查询', '图属查询', -1, 1, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10807, 'applicationtools', '应用工具', '', -1, 3, 10041, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10808, 'securitytools', '安全工具', '', -1, 4, 10041, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10809, 'demotools', '演示工具', '', -1, 5, 10041, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10811, 'maptools', '地图工具', '', -1, 6, 10041, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10795, 'specificAnalyse', '叠加分析（专题分析）', '分析地块与各专题图层的空间压占情况，如矿产压覆分析、规划合规分析、耕地保护分析等。', -1, 3, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10814, 'othertools', '其他', '', -1, 7, 10041, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10797, 'roam-fly', '漫游飞行', '支持制作三维飞行场景，将地图移动到感兴趣区域，调整好视角后添加为视点，飞行路线由一系列视点组成。', -1, 5, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(100415, 'A', '公共管理与公共服务用地', '行政、文化、教育、体育、卫生等机构和设施的用地，不包括居住用地中的服务设施用地', -1, 0, 100331, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10799, 'SiteSelection', '辅助选址', '数据+工具”的在线服务模式，为院内及行业用户提供丰富便捷的辅助分析模型', -1, 7, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10801, 'coord-location', '坐标定位', '', -1, 8, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10794, 'linkQuery', '关联分析', '关联分析', -1, 2, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10796, 'multi-sgj-tool', '时光机', '提供多年份的同一类数据组合浏览，支持手动、自动播放数据，动态展示数据在地图上的变化情况，支持生产GIF动画图片，辅助日常报告输出等工作。', -1, 4, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10816, 'zntsQuerySpeciality', '专业图审工具', '', -1, 10, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10802, 'linkageUpdate', '联动更新', '', -1, 9, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10251, 'https://gl.landcloud.org.cn:9443', 'url', '国土调查云ip地址', -1, 0, 10035, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10252, 'gwd050b85e-ee2c-4028-865e-bdf82109196b', 'applicationGuid', '国土调查云查询key(gw15ad22de-85ec-4ba0-87a1-416e05a81743)', -1, 1, 10035, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10253, 'a0891cc0-125b-46b3-beeb-1ec9a91f1f58', 'appSecret', '国土调查云查询秘钥(fcbfd14b-44fc-4fb7-a337-5a9e29a7350e)', -1, 2, 10035, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10254, 'dc155516-9f49-4857-878a-45746cb0b434', 'nodeId', '国土调查云节点id', -1, 3, 10035, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10798, 'codeQuery', '一码管地', '为每块地分配一个独一无二的土地编码，实现土地全生命周期管理的创新模式。', -1, 6, 10040, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10805, 'graphictools', '审批工具', '', -1, 1, 10041, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10804, 'documenttools', '文档工具', '', -1, 0, 10041, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10891, 'ShapeFile', '矢量', '', -1, 5, 10045, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10892, 'shp', 'shp', '', 10891, 0, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10893, 'dwg', 'dwg', '', 10891, 1, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10894, 'gml', 'gml', '', 10891, 2, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10895, 'kml', 'kml', '', 10891, 3, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10896, 'geojson', 'geojson', '', 10891, 4, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10897, 'vct', 'vct', '', 10891, 5, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10898, 'wt', 'wt', '', 10891, 6, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10899, 'wp', 'wp', '', 10891, 7, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10900, 'wl', 'wl', '', 10891, 8, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10901, '其他', '其他', '', 10891, 9, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10902, 'Tif', '栅格', '', -1, 6, 10045, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10903, 'tif', 'tif', '', 10902, 0, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10904, 'img', 'img', '', 10902, 1, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10905, 'ecw', 'ecw', '', 10902, 2, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10906, 'bil', 'bil', '', 10902, 3, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10907, 'grid', 'grid', '', 10902, 4, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10908, '其他', '其他', '', 10902, 5, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10909, 'ModelDataset', '三维', '', -1, 7, 10045, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10910, 'osgb', 'osgb', '', 10909, 0, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10911, 'b3dm', 'b3dm', '', 10909, 1, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10912, 'obj', 'obj', '', 10909, 2, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10913, '3ds', '3ds', '', 10909, 3, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10914, 'las', 'las', '', 10909, 4, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10915, '其他', '其他', '', 10909, 5, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10916, 'Picture', '图片', '', -1, 8, 10045, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10917, 'bmp', 'bmp', '', 10916, 0, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10918, 'gif', 'gif', '', 10916, 1, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10919, 'jpg', 'jpg', '', 10916, 2, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10920, 'png', 'png', '', 10916, 3, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10921, '其他', '其他', '', 10916, 4, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10923, 'doc', 'doc', '', 10922, 0, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10924, 'docx', 'docx', '', 10922, 1, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10925, 'html', 'html', '', 10922, 2, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10926, 'OFD', 'OFD', '', 10922, 3, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10927, 'pdf', 'pdf', '', 10922, 4, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10928, 'ppt', 'ppt', '', 10922, 5, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10929, 'txt', 'txt', '', 10922, 6, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10930, 'wps', 'wps', '', 10922, 7, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10931, '其他', '其他', '', 10922, 8, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10932, 'Table', '表格', '', -1, 10, 10045, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10933, 'et', 'et', '', 10932, 0, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10934, 'xls', 'xls', '', 10932, 1, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10935, 'xlsx', 'xlsx', '', 10932, 2, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10936, '其他', '其他', '', 10932, 3, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10937, 'Video', '视频', '', -1, 11, 10045, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10938, 'mpg', 'mpg', '', 10937, 0, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10939, 'rm', 'rm', '', 10937, 1, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10940, 'swf', 'swf', '', 10937, 2, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10941, '其他', '其他', '', 10937, 3, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10942, 'FeatureClass', '数据库', '', -1, 12, 10045, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10943, 'gdb', 'gdb', '', 10942, 0, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10944, 'mdb', 'mdb', '', 10942, 1, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10945, 'hdf', 'hdf', '', 10942, 2, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10946, 'idata', 'idata', '', 10942, 3, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10947, '其他', '其他', '', 10942, 4, 10045, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10948, 'Other', '其他', '', -1, 13, 10045, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10817, '1', '数据集', '', -1, 0, 10044, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10818, '发改', '发改', '', 10817, 0, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10922, 'DatumDataset', '文档', '', -1, 9, 10045, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10819, '教育', '教育', '', 10817, 1, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10820, '科技', '科技', '', 10817, 2, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10821, '工信', '工信', '', 10817, 3, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10822, '公安', '公安', '', 10817, 4, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10823, '民政', '民政', '', 10817, 5, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10824, '司法', '司法', '', 10817, 6, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10825, '财政', '财政', '', 10817, 7, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10826, '人社', '人社', '', 10817, 8, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10827, '自然资源', '自然资源', '', 10817, 9, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10828, '调查监测', '调查监测', '', 10827, 0, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10829, '资源资产', '资源资产', '', 10827, 1, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10830, '确权登记', '确权登记', '', 10827, 2, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10831, '开发利用', '开发利用', '', 10827, 3, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10832, '空间规划', '空间规划', '', 10827, 4, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10833, '用途管制', '用途管制', '', 10827, 5, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10834, '生态修复', '生态修复', '', 10827, 6, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10835, '耕地保护', '耕地保护', '', 10827, 7, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10836, '地灾应急', '地灾应急', '', 10827, 8, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10837, '地质矿产', '地质矿产', '', 10827, 9, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10838, '测绘地理', '测绘地理', '', 10827, 10, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10839, '督察执法', '督察执法', '', 10827, 11, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10840, '其他', '其他', '', 10827, 12, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10841, '生环', '生环', '', 10817, 10, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10842, '住建', '住建', '', 10817, 11, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10843, '交通', '交通', '', 10817, 12, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10844, '水利', '水利', '', 10817, 13, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10845, '农业', '农业', '', 10817, 14, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10846, '商务', '商务', '', 10817, 15, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10847, '文旅', '文旅', '', 10817, 16, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10848, '卫健', '卫健', '', 10817, 17, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10849, '审计', '审计', '', 10817, 18, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10850, '应急', '应急', '', 10817, 19, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10851, '林业', '林业', '', 10817, 20, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10852, '统计', '统计', '', 10817, 21, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10853, '其他', '其他', '', 10817, 22, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10854, '2', '服务集', '', -1, 1, 10044, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10855, '发改', '发改', '', 10854, 0, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10856, '教育', '教育', '', 10854, 1, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10857, '科技', '科技', '', 10854, 2, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10858, '工信', '工信', '', 10854, 3, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10859, '公安', '公安', '', 10854, 4, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10982, '省科技厅', '省科技厅', '', 10975, 6, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10983, '省财政厅', '省财政厅', '', 10975, 7, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10984, '省自然资源厅', '省自然资源厅', '', 10975, 8, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10985, '财税综合信息', '财税综合信息', '', -1, 2, 10047, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10986, '互联网监管', '互联网监管', '', -1, 3, 10047, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10950, '密级', '密级', '', -1, 0, 10046, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10951, '4', '秘密', '', 10950, 0, 10046, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10952, '5', '机密', '', 10950, 1, 10046, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10953, '6', '绝密', '', 10950, 2, 10046, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10954, '数据级别', '数据级别', '', -1, 1, 10046, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10955, '1', '一般数据', '', 10954, 0, 10046, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10956, '2', '重要数据', '', 10954, 1, 10046, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10957, '3', '核心数据', '', 10954, 2, 10046, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10958, '互联网政务', '互联网政务', '', -1, 0, 10047, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10959, '湘易办APP', '湘易办APP', '', -1, 1, 10047, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10960, '市州资源目录', '市州资源目录', '', 10959, 0, 10047, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10961, '长沙市', '长沙市', '', 10960, 0, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10962, '衡阳市', '衡阳市', '', 10960, 1, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10963, '岳阳市', '岳阳市', '', 10960, 2, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10964, '株洲市', '株洲市', '', 10960, 3, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10965, '湘潭市', '湘潭市', '', 10960, 4, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10966, '娄底市', '娄底市', '', 10960, 5, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10967, '常德市', '常德市', '', 10960, 6, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10968, '益阳市', '益阳市', '', 10960, 7, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10860, '民政', '民政', '', 10854, 5, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10861, '司法', '司法', '', 10854, 6, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10862, '财政', '财政', '', 10854, 7, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10863, '人社', '人社', '', 10854, 8, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10864, '自然资源', '自然资源', '', 10854, 9, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10865, '调查监测', '调查监测', '', 10864, 0, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10866, '资源资产', '资源资产', '', 10864, 1, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10867, '确权登记', '确权登记', '', 10864, 2, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10868, '开发利用', '开发利用', '', 10864, 3, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10869, '空间规划', '空间规划', '', 10864, 4, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10870, '用途管制', '用途管制', '', 10864, 5, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10871, '生态修复', '生态修复', '', 10864, 6, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10872, '耕地保护', '耕地保护', '', 10864, 7, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10873, '地灾应急', '地灾应急', '', 10864, 8, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10874, '地质矿产', '地质矿产', '', 10864, 9, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10875, '测绘地理', '测绘地理', '', 10864, 10, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10876, '督察执法', '督察执法', '', 10864, 11, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10877, '其他', '其他', '', 10864, 12, 10044, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10878, '生环', '生环', '', 10854, 10, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10879, '住建', '住建', '', 10854, 11, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10880, '交通', '交通', '', 10854, 12, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10881, '水利', '水利', '', 10854, 13, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10882, '农业', '农业', '', 10854, 14, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10883, '商务', '商务', '', 10854, 15, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10884, '文旅', '文旅', '', 10854, 16, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10885, '卫健', '卫健', '', 10854, 17, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10886, '审计', '审计', '', 10854, 18, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10887, '应急', '应急', '', 10854, 19, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10888, '林业', '林业', '', 10854, 20, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10889, '统计', '统计', '', 10854, 21, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10890, '其他', '其他', '', 10854, 22, 10044, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10987, '食品药品安全', '食品药品安全', '', -1, 4, 10047, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10988, '安全生产', '安全生产', '', -1, 5, 10047, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10989, '价格监管', '价格监管', '', -1, 6, 10047, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10990, '能源安全', '能源安全', '', -1, 7, 10047, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10991, '信用体系', '信用体系', '', -1, 8, 10047, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10992, '城乡建设', '城乡建设', '', -1, 9, 10047, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10993, '社区治理', '社区治理', '', -1, 10, 10047, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10994, '生态环保', '生态环保', '', -1, 11, 10047, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10995, '应急维稳', '应急维稳', '', -1, 12, 10047, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10996, '公共服务', '公共服务', '', -1, 13, 10047, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10997, '健康保障', '健康保障', '', -1, 14, 10047, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10969, '永州市', '永州市', '', 10960, 8, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10970, '怀化市', '怀化市', '', 10960, 9, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10971, '张家界市', '张家界市', '', 10960, 10, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10972, '郴州市', '郴州市', '', 10960, 11, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10973, '邵阳市', '邵阳市', '', 10960, 12, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10974, '湘西自治州', '湘西自治州', '', 10960, 13, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10975, '省直部门资源目录', '省直部门资源目录', '', 10959, 1, 10047, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10976, '省市场监管局', '省市场监管局', '', 10975, 0, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10977, '省教育厅', '省教育厅', '', 10975, 1, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10978, '省残联', '省残联', '', 10975, 2, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10979, '省税务局', '省税务局', '', 10975, 3, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10980, '省商务厅', '省商务厅', '', 10975, 4, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10981, '省医保局', '省医保局', '', 10975, 5, 10047, 2);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10998, '社会保障', '社会保障', '', -1, 15, 10047, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(10999, '省发展和改革委员会', '省发展和改革委员会', '', -1, 0, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11000, '省民族宗教事务委员会', '省民族宗教事务委员会', '', -1, 1, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11001, '省财政厅', '省财政厅', '', -1, 2, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11002, '省住房和城乡建设厅', '省住房和城乡建设厅', '', -1, 3, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11003, '省商务厅', '省商务厅', '', -1, 4, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11004, '省退役军人事务厅', '省退役军人事务厅', '', -1, 5, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11005, '省市场监督管理局', '省市场监督管理局', '', -1, 6, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11006, '省机关事务管理局', '省机关事务管理局', '', -1, 7, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11007, '省粮食和物资储备局', '省粮食和物资储备局', '', -1, 8, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11008, '省中医药管理局', '省中医药管理局', '', -1, 9, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11009, '省教育厅', '省教育厅', '', -1, 10, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11010, '省公安厅', '省公安厅', '', -1, 11, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11011, '省科学技术厅', '省科学技术厅', '', -1, 12, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11012, '省民政厅', '省民政厅', '', -1, 13, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11013, '省人力资源和社会保障厅', '省人力资源和社会保障厅', '', -1, 14, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11014, '省自然资源厅', '省自然资源厅', '', -1, 15, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11015, '办公室', '办公室', '', 11014, 0, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11016, '综合规划处', '综合规划处', '', 11014, 1, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11017, '法规处', '法规处', '', 11014, 2, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11018, '自然资源调查监测处', '自然资源调查监测处', '', 11014, 3, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11019, '自然资源确权登记局', '自然资源确权登记局', '', 11014, 4, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11020, '自然资源所有者权益处', '自然资源所有者权益处', '', 11014, 5, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11021, '自然资源开发利用处', '自然资源开发利用处', '', 11014, 6, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11022, '国土空间规划局', '国土空间规划局', '', 11014, 7, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11023, '国土空间用途管制处', '国土空间用途管制处', '', 11014, 8, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11024, '国土空间生态修复处', '国土空间生态修复处', '', 11014, 9, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11025, '耕地保护监督处', '耕地保护监督处', '', 11014, 10, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11026, '地质勘查管理处', '地质勘查管理处', '', 11014, 11, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11027, '矿业权管理处', '矿业权管理处', '', 11014, 12, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11028, '矿产资源保护监督处', '矿产资源保护监督处', '', 11014, 13, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11029, '国土测绘处', '国土测绘处', '', 11014, 14, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11030, '地理信息管理处', '地理信息管理处', '', 11014, 15, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11031, '自然资源督察办公室（自然资源督察一处）', '自然资源督察办公室（自然资源督察一处）', '', 11014, 16, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11032, '执法局（自然资源督察二处）', '执法局（自然资源督察二处）', '', 11014, 17, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11033, '自然资源督察三处', '自然资源督察三处', '', 11014, 18, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11034, '自然资源督察四处', '自然资源督察四处', '', 11014, 19, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11035, '改革发展与科技处', '改革发展与科技处', '', 11014, 20, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11036, '财务与资金运用处', '财务与资金运用处', '', 11014, 21, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11037, '人事处', '人事处', '', 11014, 22, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11038, '政务服务处', '政务服务处', '', 11014, 23, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11039, '机关党委', '机关党委', '', 11014, 24, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11040, '离退休人员管理处', '离退休人员管理处', '', 11014, 25, 10048, 1);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11041, '省交通运输厅', '省交通运输厅', '', -1, 16, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11042, '省文化和旅游厅', '省文化和旅游厅', '', -1, 17, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11043, '省应急管理厅', '省应急管理厅', '', -1, 18, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11044, '省广播电视局', '省广播电视局', '', -1, 19, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11045, '省地方金融监督管理局', '省地方金融监督管理局', '', -1, 20, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11046, '省医疗保障局', '省医疗保障局', '', -1, 21, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11047, '省药品监督管理局', '省药品监督管理局', '', -1, 22, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11048, '省水利厅', '省水利厅', '', -1, 23, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11049, '省卫生健康委员会', '省卫生健康委员会', '', -1, 24, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11050, '省国资委', '省国资委', '', -1, 25, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11051, '省体育局', '省体育局', '', -1, 26, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11052, '省人防办', '省人防办', '', -1, 27, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11053, '省监狱管理局', '省监狱管理局', '', -1, 28, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11054, '省供销合作总社', '省供销合作总社', '', -1, 29, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11055, '省工业和信息化厅', '省工业和信息化厅', '', -1, 30, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11056, '省司法厅', '省司法厅', '', -1, 31, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11057, '省生态环境厅', '省生态环境厅', '', -1, 32, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11058, '省农业农村厅', '省农业农村厅', '', -1, 33, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11059, '省审计厅', '省审计厅', '', -1, 34, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11060, '省林业局', '省林业局', '', -1, 35, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11061, '省统计局', '省统计局', '', -1, 36, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11062, '省信访局', '省信访局', '', -1, 37, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11063, '省文物局', '省文物局', '', -1, 38, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11064, '省文史研究馆', '省文史研究馆', '', -1, 39, 10048, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11070, '4', '混合结构', '', -1, 3, 10049, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11065, '1', '钢结构', '', -1, 0, 10049, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11066, '2', '钢和钢筋混凝土结构', '', -1, 1, 10049, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11067, '3', '钢筋混凝土结构', '', -1, 2, 10049, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11071, '6', '其他结构', '', -1, 5, 10049, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11069, '5', '砖木结构', '', -1, 4, 10049, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11072, '1', '查封', '', -1, 0, 10050, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11074, '3', '预查封', '', -1, 1, 10050, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11075, '3', '轮候查封', '', -1, 2, 10050, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11076, '4', '轮候预查封', '', -1, 3, 10050, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11077, '1', '依申请', '', -1, 0, 10051, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11078, '2', '依职权', '', -1, 1, 10051, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11079, '1', '集体土地所有权', '', -1, 0, 10052, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11080, '2', '国家土地所有权', '', -1, 1, 10052, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11081, '3', '国有建设用地使用权', '', -1, 2, 10052, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11082, '4', '国有建设用地使用权/房屋所有权', '', -1, 3, 10052, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11129, '8', '全市', '', -1, 7, 10060, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11150, '吉威', '北京吉威空间信息股份有限公司', '', -1, 3, 10056, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11084, '1', '预售商品房买卖预告登记', '', -1, 0, 10053, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11085, '2', '其他不动产买卖预告登记', '', -1, 1, 10053, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11086, '3', '预售商品房抵押权预告登记', '', -1, 2, 10053, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11087, '4', '其他不动产抵押权预告登记', '', -1, 3, 10053, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11089, '9', '其他预告登记', '', -1, 4, 10053, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11083, '5', '宅基地使用权', '', -1, 4, 10052, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11130, '9', '市本级', '', -1, 8, 10060, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11131, '10', '各县（区）', '', -1, 9, 10060, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11132, '11', '全县（区）', '', -1, 10, 10060, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11133, '12', '县（区）本级', '', -1, 11, 10060, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11134, '13', '其他', '', -1, 12, 10060, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11135, '原始数据', '原始数据', '1', -1, 0, 10061, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11136, '过程数据', '过程数据', '2', -1, 1, 10061, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11097, '33', '乡集体经济组织', '', -1, 6, 10054, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11096, '32', '村集体经济组织', '', -1, 5, 10054, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11093, '31', '村民小组', '', -1, 4, 10054, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11094, '30', '集体土地所有权', '', -1, 3, 10054, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11092, '21', '国有无居民海岛使用权', '', -1, 2, 10054, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11091, '20', '国有土地使用权', '', -1, 1, 10054, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11090, '10', '国有土地所有权', '', -1, 0, 10054, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11098, '34', '其它农民集体经济组织', '', -1, 7, 10054, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11099, '40', '集体土地使用权', '', -1, 8, 10054, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11100, 'http://intenal.geoway-atlas.com:31280/ime-cloud/rest/zhucheng_all_KTX_DSMV5/3dtiles/tileset.json', '测试模型', '', -1, 0, 10055, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11102, '1', '每年', '', -1, 0, 10057, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11103, '2', '每季度', '', -1, 1, 10057, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11104, '3', '每月', '', -1, 2, 10057, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11105, '7', '每周', '', -1, 3, 10057, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11106, '8', '每日', '', -1, 4, 10057, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11107, '4', '实时', '', -1, 5, 10057, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11108, '5', '按需', '', -1, 6, 10057, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11109, '6', '其他', '', -1, 7, 10057, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11110, 'ShapeFile', '矢量', '', -1, 0, 10058, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11111, 'Tif', '栅格', '', -1, 1, 10058, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11112, 'ModelDataset', '三维', '', -1, 2, 10058, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11113, 'Picture', '图片', '', -1, 3, 10058, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11115, 'Table', '表格', '', -1, 5, 10058, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11116, 'Video', '视频', '', -1, 6, 10058, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11117, 'FeatureClass', '数据库', '', -1, 7, 10058, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11118, 'Other', '其他', '', -1, 8, 10058, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11148, '第二测绘院', '第二测绘院', '', -1, 1, 10056, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11114, 'DatumDataset', '文档', '', -1, 4, 10058, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11119, '11', '网络', '', -1, 0, 10059, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11120, '12', '光盘', '', -1, 1, 10059, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11121, '13', '硬盘', '', -1, 2, 10059, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11122, '1', '全球', '', -1, 0, 10060, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11123, '2', '全国', '', -1, 1, 10060, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11124, '3', '部本级', '', -1, 2, 10060, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11125, '4', '各省市', '', -1, 3, 10060, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11126, '5', '全省', '', -1, 4, 10060, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11127, '6', '省本级', '', -1, 5, 10060, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11128, '7', '各地市', '', -1, 6, 10060, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11137, '最终成果', '最终成果', '3', -1, 2, 10061, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11138, '定制数据', '定制数据', '4', -1, 3, 10061, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11139, '临时数据', '临时数据', '5', -1, 4, 10061, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11140, '底图数据', '底图数据', '6', -1, 5, 10061, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11141, '脱密汇交数据', '脱密汇交数据', '7', -1, 6, 10061, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11142, '政府部门', '政府部门', '1', -1, 0, 10062, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11143, '事业单位', '事业单位', '2', -1, 1, 10062, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11144, '国有企业', '国有企业', '3', -1, 2, 10062, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11145, '民营企业', '民营企业', '4', -1, 3, 10062, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11146, '其他', '其他', '5', -1, 4, 10062, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11101, '第一测绘院', '第一测绘院', '', -1, 0, 10056, 0);
INSERT INTO tbdm_domainvalue
(f_id, f_code, f_name, f_remark, f_pid, f_corder, f_dicno, f_level)
VALUES(11149, '第三测绘院', '第三测绘院', '', -1, 2, 10056, 0);

SELECT pg_catalog.setval('tbdm_domainvalue_f_id_seq', 12000, true);

INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(20, 'atlas-task-advanced-setting', 'atlas-task-advanced-setting', NULL, 'atlas任务高级配置参数组', NULL, '', 1);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(21, 'atlas-task-strategy', 'atlas-task-strategy', decode('3130','hex'), 'atlas任务高级配置之调度策略，0：常规工作流 10：多任务调度', 20, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(22, 'atlas-task-priority', 'atlas-task-priority', decode('313030','hex'), 'atlas任务高级配置之优先级，整数，值越大，优先级越高', 20, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(23, 'atlas-task-queue', 'atlas-task-queue', decode('33','hex'), 'atlas任务高级配置之多任务规模，1：小 2：中 3：大', 20, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(37, '数据中心', 'dataCenter', NULL, '', NULL, '', 1);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(38, NULL, 'appCatalogName', decode('E4B880E5BCA0E59BBE','hex'), '数据中心', 37, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(39, '实时外部配置', 'hnSys', NULL, '', NULL, '', 1);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(40, NULL, 'cgzhptConfig', decode('7B22636F6E66696744617461223A5B7B22636C69656E745F6964223A227A6870745F646C6B6A797A74222C22417574686F72697A6174696F6E223A22426173696320656D68776446396B62477471655870304F6D743252556C7061453157596C4277593170315748424764564535556D633950513D3D222C226261736555726C223A22687474703A2F2F35392E3233312E3231392E31323A3138303031222C227265646972656374557269223A22687474703A2F2F35392E3233312E3231392E31323A31383030312F6E61747572616C2F232F7A7770746C6F67696E227D2C7B22636C69656E745F6964223A227A6870745F646C6B6A797A745F67627A7974222C22417574686F72697A6174696F6E223A22426173696320656D68776446396B624774716558703058326469656E6C304F6D6C50567A684D596B5A354F5756695A30684C59335130524578785248633950513D3D222C226261736555726C223A22687474703A2F2F35392E3233312E3231392E31323A3138303039222C227265646972656374557269223A22687474703A2F2F35392E3233312E3231392E31323A31383030392F6E61747572616C2F232F7A7770746C6F67696E227D5D2C2263677A68707455726C223A222F6F617574682F617574686F72697A65222C22746F6B656E55726C223A222F6F617574682F746F6B656E222C2275736572546F6B656E55726C223A222F6170692F757365722F746F6B656E2F62795F636C69656E74222C22757365724C69737455726C223A222F6170692F757365722F646F636B696E672F73777A782F75736572222C227573657250686F6E6555726C223A222F6170692F757365722F70726F66696C652F70686F6E652F6C697374222C226F70656E44657461696C223A222F696E6465784E65772F6F70656E44657461696C222C2264657061727455726C223A222F6170692F757365722F646F636B696E672F73777A782F646570617274222C22756E6974496473223A223132312C313833222C2273796E6354696D65223A22323031392D30312D33305431323A35363A33332E3030305A222C22726F6C65496473223A22393232333339313937353232353432353932227D','hex'), '', 39, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(41, '集成框架配置', 'jckj', NULL, '', NULL, '', 1);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(42, NULL, 'user', decode('61646D696E','hex'), '', 41, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(43, NULL, 'password', decode('6531306164633339343962613539616262653536653035376632306638383365','hex'), '', 41, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(44, NULL, 'datajr', decode('7B2022746F776572566964656F223A7B226B6579223A223330326435303837386464363461643061396364626533383861366335336464222C22757365726E616D65223A22686E6473636879222C2270617373776F7264223A224E5240366A377155694358222C226261736555726C223A2268747470733A2F2F7A727A797A686A632E686E64656368792E636F6D3A383131312F227D2C226878736A4B6579223A2022653539643238313231623932343436326230623965343164333463623866306426656E63222C2020202022445A5A48417574686F72697A6174696F6E223A202242617369632064476870636D52666347467964486B3663336C7A64475674222C20202022445A5A4855726C223A2022687474703A2F2F6C6F63616C686F73743A38303036222C20202022445A5A48555345524E414D45223A2022737975616E74657374222C20202022445A5A4850415353574F5244223A202267394E77773176592B42594E7A4B42785752555058513D3D222C20226D617841726561223A203630303030302C202020224A4A54595052223A20312C2020202261704B6579223A202276373352637448513448377252624749726B684D4C676A574470476D436C4E52222C202020224A4A55524C223A2022687474703A2F2F3137322E31362E36372E33343A383036362F696D652D636C6F75642F6D616E616765722F6578616D706C652F737472656574566965772E646F3F6C6E673D3131382E3333373834383330353239353134266C61743D32342E3434393730313535323132363639222C2279756E79616F223A7B22757365726E616D65223A22686E736473636879222C2270617373776F7264223A223171617A40575358222C226B6579223A222D2D2D2D2D424547494E205055424C4943204B45592D2D2D2D2D4D4947664D413047435371475349623344514542415155414134474E4144434269514B426751435041655A2B73394566677241665466665A34494D4A7866714F2F4B2B7373654A704C613457714750646C376C3352396B70372F4337744357737974444830704A765530456A44455175646D487266796D39412B6148536B66584F6E666D2B2F31646A4D547742512F6E2F6273446A77505853633842307864374463376A4D35316C7664656E584556656D587972657459664C7252487A4774493344344D524D7870426D6B735371787661774944415141422D2D2D2D2D454E44205055424C4943204B45592D2D2D2D2D222C2275726C223A22687474703A2F2F3232322E3234302E3136382E32313A373039322F6163636573732F726573742F73657276696365732F67656E6572617465546F6B656E227D7D','hex'), '', 39, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(45, '分析服务引擎', 'geoserver3', NULL, '分析服务引擎相关配置', NULL, '', 1);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(46, NULL, 'serverUrl', decode('687474703A2F2F3137322E31362E36372E3130353A38362F67656F7365727665722D6F70656E','hex'), '分析服务引擎后端地址', 45, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(47, NULL, 'ApplicationGUID', decode('38383739383439662D303038372D346462352D613866322D333836616135653862306361','hex'), '应用id', 45, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(48, NULL, 'access_key', decode('47656F776179','hex'), '免登录通行码', 45, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(50, NULL, 'customExclude', decode('22222C20437573746F6D444C53746174','hex'), '自定义压占分析中被屏蔽项目列表，tag控制', 45, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(51, NULL, 'version', decode('342E30','hex'), '版本', 45, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(52, '数据申请附件模板', 'ApplyAttachmentTemplate', NULL, '', NULL, '', 1);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(53, NULL, '自然资源与空间地理库资源申请表', decode('687474703A2F2F3137322E31362E36372E34363A37332F736861726534312FE59BBDE59C9FE7A9BAE997B4E59FBAE7A180E4BFA1E681AFE5B9B3E58FB0E8B584E6BA90E794B3E8AFB7E8A1A82E646F6378','hex'), 'http://172.16.67.155:9000/test/%E8%87%AA%E7%84%B6%E8%B5%84%E6%BA%90%E4%B8%8E%E7%A9%BA%E9%97%B4%E5%9C%B0%E7%90%86%E5%BA%93%E8%B5%84%E6%BA%90%E7%94%B3%E8%AF%B7%E8%A1%A82.xlsx?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Credential=KPJ7GOZ0038VL25XFQ6I%2F20240911%2Fus-east-1%2Fs3%2Faws4_request&X-Amz-Date=20240911T020648Z&X-Amz-Expires=604799&X-Amz-Security-Token=eyJhbGciOiJIUzUxMiIsInR5cCI6IkpXVCJ9.eyJhY2Nlc3NLZXkiOiJLUEo3R09aMDAzOFZMMjVYRlE2SSIsImV4cCI6MzYwMDAwMDAwMDAwMCwicG9saWN5IjoiY29uc29sZUFkbWluIn0.jDezDoB-sR82OknVktvTGT90GqHalo5wezc4gH6l3mQholV8UGlwgp3W8U2HvgwR054c_hMo84plL6sYbf2Qag&X-Amz-SignedHeaders=host&versionId=null&X-Amz-Signature=af003e20c94163fb5ca7c6b9a5a806cdeb7e7613adb9da00413e5aa18db0cc68', 52, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(60, '调查云举证查询信息', 'hndcyjz', NULL, '', NULL, '', 1);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(61, NULL, 'proofUser', decode('484E4453434859','hex'), '', 60, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(62, NULL, 'proofType', decode('70617373776F7264','hex'), '', 60, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(63, NULL, 'proofPassWord', decode('313233343536','hex'), '', 60, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(64, NULL, 'proofUrl', decode('687474703A2F2F686E677870742E7469616E6D752E636C6F75643A383535','hex'), '', 60, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(65, '数据汇交-数据清单模板', 'HjQDTemplate', NULL, '', NULL, '', 1);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(66, NULL, '数据清单模板', decode('687474703A2F2F3137322E31362E36372E34363A37332F736861726534312FE695B0E68DAEE6B187E4BAA42DE695B0E68DAEE6B885E58D95E6A8A1E69DBF2E786C7378','hex'), '', 65, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(67, '资源配置元数据模板', 'MetadataTemplate', NULL, '', NULL, '', 1);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(68, NULL, 'toolset', decode('32','hex'), '', 67, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(69, NULL, 'serviceset', decode('687474703A2F2F3137322E31362E36372E34363A37332F736861726534312FE69C8DE58AA1E99B86E58583E695B0E68DAEE6A8A1E69DBF2E786C7378','hex'), '', 67, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(70, NULL, 'dataset', decode('687474703A2F2F3137322E31362E36372E34363A37332F736861726534312FE695B0E68DAEE99B86E58583E695B0E68DAEE6A8A1E69DBF2E786C7378','hex'), '', 67, '', 0);
INSERT INTO tbsys_sysparam
(f_id, f_name, f_key, f_value, f_desc, f_group, f_userkey, f_type)
VALUES(71, NULL, 'saveRecord', decode('66616C7365','hex'), '是否保存日志', 45, '', 0);

SELECT pg_catalog.setval('tbsys_sysparam_f_id_seq', 71, true);