/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.tenant.service;

import com.geoway.ns.tenant.config.AfterMigrateCallback;
import com.github.pagehelper.util.StringUtil;
import com.zaxxer.hikari.HikariDataSource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.callback.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TenantService {
    private static final Logger log = LoggerFactory.getLogger(TenantService.class);
    private static final String ENCODING = "UTF-8";
    @Value(value="${spring.flyway.placeholders.schema_name}")
    private String publicSchemaName;
    @Value(value="${spring.datasource.driver-class-name}")
    private String driverClassName;
    @Value(value="${spring.datasource.url}")
    private String url;
    @Value(value="${spring.datasource.username}")
    private String username;
    @Value(value="${spring.datasource.password}")
    private String password;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void CreatTenantDbSchema(String tenantId) {
        if (StringUtil.isEmpty((String)tenantId)) {
            throw new RuntimeException("\u79df\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("public".equalsIgnoreCase(tenantId) || "sde".equalsIgnoreCase(tenantId)) {
            throw new RuntimeException("\u975e\u6cd5\u79df\u6237id");
        }
        String schemaName = tenantId;
        String sqlFilePath = "db/tenant/zhkweb.sql";
        Connection conn = null;
        Statement stmt = null;
        try {
            Class.forName(this.driverClassName);
            conn = DriverManager.getConnection(this.url, this.username, this.password);
            stmt = conn.createStatement();
            String createSchemaSQL = "CREATE SCHEMA IF NOT EXISTS " + schemaName + ";";
            stmt.executeUpdate(createSchemaSQL);
            String setSearchPathSQL = "SET search_path TO " + schemaName + ";";
            stmt.executeUpdate(setSearchPathSQL);
            ClassLoader classLoader = TenantService.class.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(sqlFilePath);
            if (inputStream == null) {
                System.err.println("\u65e0\u6cd5\u627e\u5230\u8d44\u6e90\u6587\u4ef6: " + sqlFilePath);
                throw new RuntimeException("\u65e0\u6cd5\u627e\u5230\u8d44\u6e90\u6587\u4ef6: " + sqlFilePath);
            }
            StringBuilder sqlScript = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    sqlScript.append(line).append("\n");
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String sqlScriptStr = sqlScript.toString();
            if (sqlScriptStr.contains("${schema_name}")) {
                sqlScriptStr = sqlScriptStr.replace("${schema_name}", this.publicSchemaName);
            }
            stmt.execute(sqlScriptStr);
            this.migrateDatabase(tenantId);
            System.out.println("Schema created and SQL file executed successfully.");
        }
        catch (ClassNotFoundException e) {
            System.out.println("PostgreSQL JDBC Driver not found. Include it in your library path.");
            e.printStackTrace();
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }

    public void migrateDatabase(String tenantId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("adf/db/sql", "t_adf_history");
        map.put("webstore/db/sql", "t_webstore_history");
        map.put("/db/govt", "t_govt4_history");
        map.put("/db/onemap4", "t_onemap4_history");
        map.put("/db/smart", "t_smart_history");
        map.put("/db/sys", "t_sys4_history");
        map.put("/db/proxy", "t_proxy4_history");
        map.put("/db/zyfx", "t_zyfx_history");
        HikariDataSource hikariDataSource = new HikariDataSource();
        hikariDataSource.setJdbcUrl(this.url);
        hikariDataSource.setUsername(this.username);
        hikariDataSource.setPassword(this.password);
        for (Map.Entry entry : map.entrySet()) {
            try {
                log.info("\u5f00\u59cb\u66f4\u65b0\u4e1a\u52a1\u5e93\u8868\uff1a" + (String)entry.getKey() + "," + (String)entry.getValue());
                Flyway zyfxflyway = Flyway.configure().dataSource((DataSource)hikariDataSource).schemas(new String[]{tenantId}).defaultSchema(tenantId).locations(new String[]{(String)entry.getKey()}).callbacks(new Callback[]{new AfterMigrateCallback()}).encoding(ENCODING).baselineOnMigrate(true).table((String)entry.getValue()).cleanDisabled(true).ignoreFutureMigrations(true).load();
                zyfxflyway.migrate();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                log.error("\u4e1a\u52a1\u5e93\u66f4\u65b0\u5931\u8d25", (Throwable)exception);
            }
        }
    }
}

