--创建资源对象表
CREATE TABLE tb_zyfx_object
(
    f_id         varchar(50) NOT NULL,
    f_oid varchar(50),              --原始数据id
    f_name       varchar(255),
    f_alias      varchar(255),
    f_shortname  varchar(255),
    f_bsm        varchar(255),
    f_keyword    text,
    f_version    varchar(50),
    f_abstract   text,
    f_createtime timestamp,
    f_gxlx       smallint,
    f_kflx       smallint,
    f_userid     varchar(50),
    f_imgid      varchar(50),
    f_grouptype  smallint,
    f_fgfw       smallint,
    f_labels     varchar(255),
    f_hqfs       varchar(50),
    f_aqjb       varchar(50),
    f_lxr        varchar(50),
    f_lxfs       varchar(50),
    f_lylx       varchar(50),
    f_ywlb       varchar(128),
    f_lb         varchar(50),
    f_gs         varchar(50),
    f_zgdwid     varchar(50),
    f_tjdwid     varchar(50),
    f_hjdwid     varchar(50),
    f_tjdw       varchar(50),
    f_zgdw       varchar(255),
    f_hjdw       varchar(255),
    f_jsdw       varchar(50),       --建设单位
    f_whdw       varchar(50),
    f_xmmc       varchar(128),
    f_xmbh       varchar(128),
    f_xzqdm      varchar(50),
    f_xzqmc      varchar(128),
    f_status     smallint,
    f_fbsj       timestamp,
    f_acount     bigint,            --访问次数
    f_isdel      smallint DEFAULT 0
);
COMMENT ON COLUMN tb_zyfx_object.f_oid IS '原始数据id';
COMMENT ON COLUMN tb_zyfx_object.f_name IS '数据集名称';
COMMENT ON COLUMN tb_zyfx_object.f_alias IS '数据集别名';
COMMENT ON COLUMN tb_zyfx_object.f_shortname IS '数据集简称';
COMMENT ON COLUMN tb_zyfx_object.f_bsm IS '标识码';
COMMENT ON COLUMN tb_zyfx_object.f_keyword IS '关键字，建议中间用;隔开';
COMMENT ON COLUMN tb_zyfx_object.f_version IS '数据版本';
COMMENT ON COLUMN tb_zyfx_object.f_abstract IS '摘要';
COMMENT ON COLUMN tb_zyfx_object.f_createtime IS '提交时间';
COMMENT ON COLUMN tb_zyfx_object.f_gxlx IS '共享类型（1.无条件共享 2.有条件共享 3 暂不共享）';
COMMENT ON COLUMN tb_zyfx_object.f_kflx IS '开放类型（1.不对社会开放 2.对社会开放 3.部分对社会开放）';
COMMENT ON COLUMN tb_zyfx_object.f_userid IS '提交用户id';
COMMENT ON COLUMN tb_zyfx_object.f_imgid IS '图形引用id(多个用逗号隔开）';
COMMENT ON COLUMN tb_zyfx_object.f_grouptype IS '分组类型(1.数据集节点 2.服务集节点 3.工具集节点）';
COMMENT ON COLUMN tb_zyfx_object.f_fgfw IS '覆盖范围（1全球 2.全国 3.全省 4.市 5县）';
COMMENT ON COLUMN tb_zyfx_object.f_labels IS '标签';
COMMENT ON COLUMN tb_zyfx_object.f_hqfs IS '获取方式';
COMMENT ON COLUMN tb_zyfx_object.f_aqjb IS '安全级别';
COMMENT ON COLUMN tb_zyfx_object.f_lxr IS '联系人';
COMMENT ON COLUMN tb_zyfx_object.f_lxfs IS '联系方式';
COMMENT ON COLUMN tb_zyfx_object.f_lylx IS '来源类型';
COMMENT ON COLUMN tb_zyfx_object.f_ywlb IS '业务类别';
COMMENT ON COLUMN tb_zyfx_object.f_lb IS '1.数据集类别（矢量，栅格，三维，文档，图片，视频，其他） 2. 服务集类别（查询核验，电子证照，基础底图，地图服务，地图组件，分析服务，统计服务，配号服务，系统对接，其他服务） 3.工具集类别（文档工具，图形工具，分析工具，应用工具，安全工具，演示工具，其他）';
COMMENT ON COLUMN tb_zyfx_object.f_gs IS '1.数据集格式（shapfile, tif, gdb等） 2.服务集（WMTS，WMS，WFS，MapServer，XYZ，VectorTile，SkyLine，白模，倾斜模型，地质服务）';
COMMENT ON COLUMN tb_zyfx_object.f_zgdwid IS '主管单位ID';
COMMENT ON COLUMN tb_zyfx_object.f_hjdwid IS '汇交单位ID';
COMMENT ON COLUMN tb_zyfx_object.f_tjdwid IS '提交单位ID';
COMMENT ON COLUMN tb_zyfx_object.f_tjdw IS '提交单位名称';
COMMENT ON COLUMN tb_zyfx_object.f_zgdw IS '主管单位名称';
COMMENT ON COLUMN tb_zyfx_object.f_hjdw IS '汇交单位名称';
COMMENT ON COLUMN tb_zyfx_object.f_jsdw IS '建设单位';
COMMENT ON COLUMN tb_zyfx_object.f_whdw IS '维护单位';
COMMENT ON COLUMN tb_zyfx_object.f_xmmc IS '项目名称';
COMMENT ON COLUMN tb_zyfx_object.f_xmbh IS '项目编号';
COMMENT ON COLUMN tb_zyfx_object.f_xzqdm IS '行政区代码';
COMMENT ON COLUMN tb_zyfx_object.f_xzqmc IS '行政区名称';
COMMENT ON COLUMN tb_zyfx_object.f_status IS '（0.未发布 1.已发布 2停止）';
COMMENT ON COLUMN tb_zyfx_object.f_fbsj IS '发布时间';
COMMENT ON COLUMN tb_zyfx_object.f_acount IS '访问次数';
COMMENT ON COLUMN tb_zyfx_object.f_isdel IS '是否删除（0 未删除 1删除）';

ALTER TABLE tb_zyfx_object ADD CONSTRAINT PK_tb_zyfx_object PRIMARY KEY (f_id);

--创建服务集
CREATE TABLE tb_zyfx_serviceset (
    f_id varchar(50) NOT NULL,
    f_dataid varchar(255),
    f_xmin numeric(15,6),
    f_ymin numeric(15,6),
    f_xmax numeric(15,6),
    f_ymax numeric(15,6),
    f_method varchar(255),
    f_inputparams text,
    f_outputparams text,
    f_requestexample text,
    f_reponseexample text,
    f_srs varchar(50),
    f_databaseid varchar(50),
    f_tableid varchar(50),
    f_tablename varchar(50),
    f_url text,
    f_zyzt varchar(50),
    f_ywlx varchar(50),
    f_fwrl varchar(50),
    f_sjnr varchar(255),
    f_prj varchar(255),
    f_gcjz varchar(50),
    f_kjfbl varchar(50),   --空间分辨率
    f_scales text,
    f_cjsb varchar(50),
    f_gxpc int4,
    f_yycj text,
    f_otherparams text,
    f_gxsj timestamp,
    f_gxr varchar(50),
    f_gxsm varchar(255),
    f_jssj timestamp,
    f_zcsj timestamp
);
COMMENT ON COLUMN tb_zyfx_serviceset.f_dataid IS '关联数据id';
COMMENT ON COLUMN tb_zyfx_serviceset.f_xmin IS '数据范围X最小值';
COMMENT ON COLUMN tb_zyfx_serviceset.f_ymin IS '数据范围Y最小值';
COMMENT ON COLUMN tb_zyfx_serviceset.f_xmax IS '数据范围X最大值';
COMMENT ON COLUMN tb_zyfx_serviceset.f_ymax IS '数据范围Y最大值';
COMMENT ON COLUMN tb_zyfx_serviceset.f_method IS '支持的方法类型,多个用逗号隔开（1.get 2.post 3.put 4.delete)';
COMMENT ON COLUMN tb_zyfx_serviceset.f_inputparams IS '接口参数(json存储）';
COMMENT ON COLUMN tb_zyfx_serviceset.f_outputparams IS '输出参数';
COMMENT ON COLUMN tb_zyfx_serviceset.f_requestexample IS '请求示例';
COMMENT ON COLUMN tb_zyfx_serviceset.f_reponseexample IS '返回示例';
COMMENT ON COLUMN tb_zyfx_serviceset.f_srs IS '坐标系';
COMMENT ON COLUMN tb_zyfx_serviceset.f_databaseid IS '数据源ID';
COMMENT ON COLUMN tb_zyfx_serviceset.f_tableid IS '关联的数据id';
COMMENT ON COLUMN tb_zyfx_serviceset.f_tablename IS '关联的数据表名称';
COMMENT ON COLUMN tb_zyfx_serviceset.f_url IS '服务地址';
COMMENT ON COLUMN tb_zyfx_serviceset.f_zyzt IS '资源主题';
COMMENT ON COLUMN tb_zyfx_serviceset.f_ywlx IS '业务类别';
COMMENT ON COLUMN tb_zyfx_serviceset.f_fwrl IS '服务容量';
COMMENT ON COLUMN tb_zyfx_serviceset.f_sjnr IS '填写该服务包含的图层，多个图层以英文分号分隔（地图服务）';
COMMENT ON COLUMN tb_zyfx_serviceset.f_prj IS '投影信息';
COMMENT ON COLUMN tb_zyfx_serviceset.f_gcjz IS '高程基准';
COMMENT ON COLUMN tb_zyfx_serviceset.f_kjfbl IS '空间分辨率';
COMMENT ON COLUMN tb_zyfx_serviceset.f_scales IS '比例尺';
COMMENT ON COLUMN tb_zyfx_serviceset.f_cjsb IS '采集设备';
COMMENT ON COLUMN tb_zyfx_serviceset.f_gxpc IS '更新频次';
COMMENT ON COLUMN tb_zyfx_serviceset.f_yycj IS '应用场景（文本描述）';
COMMENT ON COLUMN tb_zyfx_serviceset.f_otherparams IS '扩展参数(json 存储）';
COMMENT ON COLUMN tb_zyfx_serviceset.f_gxsj IS '更新时间';
COMMENT ON COLUMN tb_zyfx_serviceset.f_gxr IS '更新人';
COMMENT ON COLUMN tb_zyfx_serviceset.f_gxsm IS '更新说明';
COMMENT ON COLUMN tb_zyfx_serviceset.f_jssj IS '建设时间';
COMMENT ON COLUMN tb_zyfx_serviceset.f_zcsj IS '注册时间';

ALTER TABLE tb_zyfx_serviceset ADD CONSTRAINT PK_tb_zyfx_serviceset PRIMARY KEY (f_id);


--创建数据集
CREATE TABLE tb_zyfx_dataset (
     f_id varchar(50) NOT NULL,
     f_dataid varchar(50),
     f_sjfl smallint DEFAULT 1,
     f_xmin numeric(15,6),
     f_ymin numeric(15,6),
     f_xmax numeric(15,6),
     f_ymax numeric(15,6),
     f_hjtime timestamp,
     f_sjl bigint,
     f_wjs numeric(10,2),
     f_info text,
     f_dicts text,
     f_scsj timestamp,
     f_scdw varchar(255),
     f_srs text,
     f_prj varchar(255),
     f_kjfbl varchar(50),
     f_gcjz varchar(50),
     f_cjsb varchar(128),
     f_gxpc int4,
     f_version bigint,
     f_ywmc varchar(128),
     f_ywbm varchar(128),
     f_yycj text,
     f_otherparams text
);
COMMENT ON COLUMN tb_zyfx_dataset.f_dataid IS '数据id(库管存储id)';
COMMENT ON COLUMN tb_zyfx_dataset.f_sjfl IS '数据分类（1.专项调查）';
COMMENT ON COLUMN tb_zyfx_dataset.f_xmin IS '数据范围X最小值';
COMMENT ON COLUMN tb_zyfx_dataset.f_ymin IS '数据范围Y最小值';
COMMENT ON COLUMN tb_zyfx_dataset.f_xmax IS '数据范围X最大值';
COMMENT ON COLUMN tb_zyfx_dataset.f_ymax IS '数据范围Y最大值';
COMMENT ON COLUMN tb_zyfx_dataset.f_hjtime IS '数据汇交时间';
COMMENT ON COLUMN tb_zyfx_dataset.f_sjl IS '文件大小KB';
COMMENT ON COLUMN tb_zyfx_dataset.f_wjs IS '文件个数';
COMMENT ON COLUMN tb_zyfx_dataset.f_info IS '数据文件信息（富文本存储）';
COMMENT ON COLUMN tb_zyfx_dataset.f_dicts IS '数据包含的字典信息';
COMMENT ON COLUMN tb_zyfx_dataset.f_scsj IS '数据生产时间';
COMMENT ON COLUMN tb_zyfx_dataset.f_scdw IS '生产单位';
COMMENT ON COLUMN tb_zyfx_dataset.f_srs IS '坐标系';
COMMENT ON COLUMN tb_zyfx_dataset.f_prj IS '投影信息';
COMMENT ON COLUMN tb_zyfx_dataset.f_kjfbl IS '空间分辨率';
COMMENT ON COLUMN tb_zyfx_dataset.f_gcjz IS '高程基准';
COMMENT ON COLUMN tb_zyfx_dataset.f_cjsb IS '采集设备';
COMMENT ON COLUMN tb_zyfx_dataset.f_gxpc IS '更新频次';
COMMENT ON COLUMN tb_zyfx_dataset.f_version IS '数据版本';
COMMENT ON COLUMN tb_zyfx_dataset.f_ywbm IS '业务编码';
COMMENT ON COLUMN tb_zyfx_dataset.f_yycj IS '数据应用场景（文本描述）';
COMMENT ON COLUMN tb_zyfx_dataset.f_otherparams IS '其他参数，JSON存储扩展';

ALTER TABLE tb_zyfx_dataset ADD CONSTRAINT PK_tb_zyfx_dataset PRIMARY KEY (f_id);

--创建工具集
CREATE TABLE tb_zyfx_toolset (
     f_id varchar(50) NOT NULL,
     f_method varchar(255),
     f_url text,
     f_inputparams text,
     f_outputparams text,
     f_requestexample text,
     f_reponseexample text,
     f_relsvrids bigint,
     f_yycj text,
     f_otherparams text
);
COMMENT ON COLUMN tb_zyfx_toolset.f_method IS '支持的方法类型（1.get 2.post 3.put 4.delete)';
COMMENT ON COLUMN tb_zyfx_toolset.f_url IS '服务地址';
COMMENT ON COLUMN tb_zyfx_toolset.f_outputparams IS '输出参数';
COMMENT ON COLUMN tb_zyfx_toolset.f_requestexample IS '请求样例';
COMMENT ON COLUMN tb_zyfx_toolset.f_reponseexample IS '响应参数';
COMMENT ON COLUMN tb_zyfx_toolset.f_relsvrids IS '关联服务id';
COMMENT ON COLUMN tb_zyfx_toolset.f_yycj IS '数据应用场景（文本描述）';

ALTER TABLE tb_zyfx_toolset ADD CONSTRAINT PK_tb_zyfx_toolset PRIMARY KEY (f_id);

--资源集目录方案
CREATE TABLE tb_zyfx_catalog_scheme (
    f_id varchar(50) NOT NULL,
    f_name varchar(255),
    f_key varchar(50),
    f_sort bigint,
    f_createtime timestamp,
    f_isdefault smallint
);
COMMENT ON COLUMN tb_zyfx_catalog_scheme.f_name IS '目录名称';
COMMENT ON COLUMN tb_zyfx_catalog_scheme.f_key IS '方案关键字';
COMMENT ON COLUMN tb_zyfx_catalog_scheme.f_sort IS '排序';
COMMENT ON COLUMN tb_zyfx_catalog_scheme.f_createtime IS '创建时间';
COMMENT ON COLUMN tb_zyfx_catalog_scheme.f_isdefault IS '是否默认方案';

ALTER TABLE tb_zyfx_catalog_scheme ADD CONSTRAINT PK_tb_zyfx_catalog_scheme PRIMARY KEY (f_id);


--资源集目录
CREATE TABLE tb_zyfx_catalog (
     f_id varchar(50) NOT NULL,
     f_pid varchar(50),
     f_name varchar(255),
     f_bm  varchar(255),
     f_nodetype smallint,
     f_grouptype smallint,
     f_code varchar(255),
     f_schemeid varchar(50),
     f_oid varchar(50),
     f_bz text,
     f_level smallint,
     f_params text,
     f_imgid  varchar(50),
     f_logoid  varchar(50),
     f_sort bigint
);
COMMENT ON COLUMN tb_zyfx_catalog.f_pid IS '父id';
COMMENT ON COLUMN tb_zyfx_catalog.f_name IS '目录名称';
COMMENT ON COLUMN tb_zyfx_catalog.f_bm IS '编码';
COMMENT ON COLUMN tb_zyfx_catalog.f_nodetype IS '节点类型（0 目录 1数据节点）';
COMMENT ON COLUMN tb_zyfx_catalog.f_grouptype IS '分组类型（1.数据集节点 2.服务集节点  3.工具集节点）';
COMMENT ON COLUMN tb_zyfx_catalog.f_code IS '节点编码（从根目录开始收到编码，子节点按照添加时间递增编码，参考行政区编码）';

COMMENT ON COLUMN tb_zyfx_catalog.f_schemeid IS '目录方案id';
COMMENT ON COLUMN tb_zyfx_catalog.f_oid IS '原始ID，从资源目录同步的原id';
COMMENT ON COLUMN tb_zyfx_catalog.f_sort IS '排序';
COMMENT ON COLUMN tb_zyfx_catalog.f_bz IS '备注';
COMMENT ON COLUMN tb_zyfx_catalog.f_imgid IS '图片id';
COMMENT ON COLUMN tb_zyfx_catalog.f_logoid IS 'logoid';
COMMENT ON COLUMN tb_zyfx_catalog.f_params IS '扩展信息';
ALTER TABLE tb_zyfx_catalog ADD CONSTRAINT PK_tb_zyfx_catalog PRIMARY KEY (f_id);


-- 资源目录对象关联表
CREATE TABLE tb_zyfx_catalog_object (
    f_id varchar(50) NOT NULL,
    f_catalogid varchar(50),
    f_catalogcode varchar(255),
    f_objectid varchar(50),
    f_grouptype smallint,
    f_schemeid varchar(50),
    f_sort integer
);
COMMENT ON COLUMN tb_zyfx_catalog_object.f_catalogid IS '目录id';
COMMENT ON COLUMN tb_zyfx_catalog_object.f_catalogcode IS '目录编码';
COMMENT ON COLUMN tb_zyfx_catalog_object.f_objectid IS '对象id';
COMMENT ON COLUMN tb_zyfx_catalog_object.f_grouptype IS '分组类型(1.数据集节点 2.服务集节点 3.工具集节点）';
COMMENT ON COLUMN tb_zyfx_catalog_object.f_schemeid IS '目录方案id';
COMMENT ON COLUMN tb_zyfx_catalog_object.f_sort IS '排序';

ALTER TABLE tb_zyfx_catalog_object ADD CONSTRAINT PK_tb_zyfx_catalog_object PRIMARY KEY (f_id);

-- 字典字段描述表
CREATE TABLE tb_zyfx_dictfld (
     f_id varchar(50) NOT NULL,
     f_objectid varchar(50),   --关联数据对象id
     f_fldname  varchar(50),
     f_fldAlias varchar(50),
     f_tableid varchar(50),
     f_tablename varchar(50),
     f_dictkey varchar(50)
);
COMMENT ON COLUMN tb_zyfx_dictfld.f_objectid IS '关联数据对象id';
COMMENT ON COLUMN tb_zyfx_dictfld.f_fldname IS '字典字典名称';
COMMENT ON COLUMN tb_zyfx_dictfld.f_fldAlias IS '字典字段中文名';
COMMENT ON COLUMN tb_zyfx_dictfld.f_tableid IS '表ID';
COMMENT ON COLUMN tb_zyfx_dictfld.f_tablename IS '表名';
COMMENT ON COLUMN tb_zyfx_dictfld.f_dictkey IS '对应字典关键字';

ALTER TABLE tb_zyfx_dictfld ADD CONSTRAINT PK_tb_zyfx_dictfld PRIMARY KEY (f_id);

--资源收藏表
CREATE TABLE tb_zyfx_favorite (
    f_id varchar(50) NOT NULL,
    f_userid varchar(50),
    f_objectid varchar(50),
    f_createtime timestamp
);
COMMENT ON COLUMN tb_zyfx_favorite.f_userid IS '收藏用户id';
COMMENT ON COLUMN tb_zyfx_favorite.f_objectid IS '收藏数据id';
COMMENT ON COLUMN tb_zyfx_favorite.f_createtime IS '收藏时间';

ALTER TABLE tb_zyfx_favorite ADD CONSTRAINT PK_tb_zyfx_favorite PRIMARY KEY (f_id);

--资源图片表
CREATE TABLE tb_zyfx_image (
    f_id varchar(50) NOT NULL,
    f_objectid varchar(50),
    f_createtime timestamp,
    f_image bytea,
    f_thumnail bytea,
    f_tag varchar(50)
);
COMMENT ON COLUMN tb_zyfx_image.f_objectid IS '数据id';
COMMENT ON COLUMN tb_zyfx_image.f_createtime IS '收藏时间';
COMMENT ON COLUMN tb_zyfx_image.f_image IS '图片';
COMMENT ON COLUMN tb_zyfx_image.f_thumnail IS '缩略图';
COMMENT ON COLUMN tb_zyfx_image.f_tag IS '标签';

ALTER TABLE tb_zyfx_image ADD CONSTRAINT PK_tb_zyfx_image PRIMARY KEY (f_id);

--资源购物车表
CREATE TABLE tb_zyfx_cart (
    f_id varchar(50) NOT NULL,
    f_userid varchar(50),
    f_objectid varchar(50),
    f_createtime timestamp,
    f_grouptype smallint
);
COMMENT ON COLUMN tb_zyfx_cart.f_userid IS '用户id';
COMMENT ON COLUMN tb_zyfx_cart.f_objectid IS '对象id';
COMMENT ON COLUMN tb_zyfx_cart.f_createtime IS '收藏时间';
COMMENT ON COLUMN tb_zyfx_cart.f_grouptype IS '分组类型(1.数据集节点 2.服务集节点 3.工具集节点）';

ALTER TABLE tb_zyfx_cart ADD CONSTRAINT PK_tb_zyfx_cart PRIMARY KEY (f_id);

--资源对象申请表
CREATE TABLE tb_zyfx_object_apply (
      f_id varchar(50) NOT NULL,
      f_objectid varchar(255),
      f_objectname varchar(255),
      f_userid varchar(50),
      f_username varchar(255),
      f_tel varchar(50),
      f_email varchar(50),
      f_leadname varchar(255),
      f_createtime timestamp,
      f_expiretime timestamp,
      f_department varchar(255),
      f_checkstatus smallint DEFAULT 0,
      f_datagettype smallint,
      f_params text,
      f_downloadstatus smallint DEFAULT 0,
      f_bz text,
      f_grouptype smallint
);
COMMENT ON COLUMN tb_zyfx_object_apply.f_objectid IS '申请的数据id（多个用逗号隔开）';
COMMENT ON COLUMN tb_zyfx_object_apply.f_objectname IS '数据名称，多个中间用逗号隔开';
COMMENT ON COLUMN tb_zyfx_object_apply.f_userid IS '申请用户id';
COMMENT ON COLUMN tb_zyfx_object_apply.f_username IS '申请用户名称';
COMMENT ON COLUMN tb_zyfx_object_apply.f_tel IS '电话';
COMMENT ON COLUMN tb_zyfx_object_apply.f_email IS '邮箱';
COMMENT ON COLUMN tb_zyfx_object_apply.f_leadname IS '申请单位领导名称';
COMMENT ON COLUMN tb_zyfx_object_apply.f_createtime IS '创建时间';
COMMENT ON COLUMN tb_zyfx_object_apply.f_expiretime IS '过期时间';
COMMENT ON COLUMN tb_zyfx_object_apply.f_department IS '部门名称';
COMMENT ON COLUMN tb_zyfx_object_apply.f_checkstatus IS '审批状态（0 未审批 1审批中 2.审批通过 3.审批未通过 4.退回）';
COMMENT ON COLUMN tb_zyfx_object_apply.f_datagettype IS '数据获取方式：1线上下载、2线下拷贝';
COMMENT ON COLUMN tb_zyfx_object_apply.f_params IS '申请参数(json存储）';
COMMENT ON COLUMN tb_zyfx_object_apply.f_downloadstatus IS '下载状态（0 不可下载 1可下载  2异常）';
COMMENT ON COLUMN tb_zyfx_object_apply.f_bz IS '申请备注';
COMMENT ON COLUMN tb_zyfx_object_apply.f_grouptype IS '分组(1.数据集节点 2.服务集节点 3.工具集节点）';

ALTER TABLE tb_zyfx_object_apply ADD CONSTRAINT PK_tb_zyfx_object_apply PRIMARY KEY (f_id);


--资源数据申请表
CREATE TABLE tb_zyfx_data_apply (
    f_id varchar(50) NOT NULL,
    f_objectid varchar(50),
    f_applyid varchar(50),
    f_path text,
    f_createtime timestamp
);
COMMENT ON COLUMN tb_zyfx_data_apply.f_objectid IS '审批对象id';
COMMENT ON COLUMN tb_zyfx_data_apply.f_applyid IS '申请id';
COMMENT ON COLUMN tb_zyfx_data_apply.f_path IS '文件路径';
COMMENT ON COLUMN tb_zyfx_data_apply.f_createtime IS '创建时间';

ALTER TABLE tb_zyfx_data_apply ADD CONSTRAINT PK_tb_zyfx_data_apply PRIMARY KEY (f_id);

-- 资源申请授权表
CREATE TABLE tb_zyfx_apply_token (
     f_id varchar(50) NOT NULL,
     f_objectid varchar(50),
     f_applyid varchar(50),
     f_token varchar(255),
     f_createtime timestamp
);
COMMENT ON COLUMN tb_zyfx_apply_token.f_objectid IS '审批对象id';
COMMENT ON COLUMN tb_zyfx_apply_token.f_applyid IS '申请id';
COMMENT ON COLUMN tb_zyfx_apply_token.f_createtime IS '创建时间';

ALTER TABLE tb_zyfx_apply_token ADD CONSTRAINT PK_tb_zyfx_apply_token PRIMARY KEY (f_id);

--资源申请审核记录表
CREATE TABLE tb_zyfx_object_approval (
     f_id varchar(50) NOT NULL,
     f_objectid varchar(50),
     f_objectname varchar(255),
     f_checkuserid varchar(50),
     f_checkusername varchar(255),
     f_createtime timestamp,
     f_updatetime timestamp,
     f_checkstatus varchar(255) DEFAULT 0,
     f_comment text,
     f_hasread smallint DEFAULT 0,
     f_applyread smallint
);
COMMENT ON COLUMN tb_zyfx_object_approval.f_objectid IS '审批对象id';
COMMENT ON COLUMN tb_zyfx_object_approval.f_objectname IS '审批对象名称';
COMMENT ON COLUMN tb_zyfx_object_approval.f_checkuserid IS '审批用户id';
COMMENT ON COLUMN tb_zyfx_object_approval.f_checkusername IS '审批用户名称';
COMMENT ON COLUMN tb_zyfx_object_approval.f_createtime IS '创建时间';
COMMENT ON COLUMN tb_zyfx_object_approval.f_updatetime IS '审批时间';
COMMENT ON COLUMN tb_zyfx_object_approval.f_checkstatus IS '审批状态（0 未审批 1审批通过 2.审批未通过 3.退回）';
COMMENT ON COLUMN tb_zyfx_object_approval.f_comment IS '审批说明';
COMMENT ON COLUMN tb_zyfx_object_approval.f_hasread IS '是否已读（0 未读  1已读）';
COMMENT ON COLUMN tb_zyfx_object_approval.f_applyread IS '审核结果是否已阅（0 未读  1已读）';

ALTER TABLE tb_zyfx_object_approval ADD CONSTRAINT PK_tb_zyfx_object_approval PRIMARY KEY (f_id);


CREATE TABLE tb_zyfx_files (
   f_id varchar(50) NOT NULL,
   f_serverid int4,
   f_objectid varchar(50),
   f_name varchar(50),
   f_type smallint,
   f_pid varchar(50),
   f_size varchar(50),
   f_url text,
   f_snapshot text,
   f_filetype varchar(50),
   f_tag varchar(50),
   f_createtime timestamp
);
COMMENT ON COLUMN tb_zyfx_files.f_objectid IS '关联对象id';
COMMENT ON COLUMN tb_zyfx_files.f_name IS '文件名称';
COMMENT ON COLUMN tb_zyfx_files.f_type IS '文件类型( 1 文件夹  2.文件）';
COMMENT ON COLUMN tb_zyfx_files.f_pid IS '父文件ID';
COMMENT ON COLUMN tb_zyfx_files.f_size IS '文件大小';
COMMENT ON COLUMN tb_zyfx_files.f_url IS '文件地址';
COMMENT ON COLUMN tb_zyfx_files.f_createtime IS '创建时间';
COMMENT ON COLUMN tb_zyfx_files.f_filetype IS '文件类型 （.zip,.pdf,.word等）';
COMMENT ON COLUMN tb_zyfx_files.f_tag IS '标签';

ALTER TABLE tb_zyfx_files ADD CONSTRAINT PK_tb_zyfx_files PRIMARY KEY (f_id);

--访问记录表
CREATE TABLE tb_zyfx_access (
    f_id varchar(50) NOT NULL,
    f_objectid varchar(50),
    f_userid varchar(50),
    f_accesscount integer
);
COMMENT ON TABLE tb_zyfx_access IS '访问统计表';
COMMENT ON COLUMN tb_zyfx_access.f_objectid IS '关联对象id';
COMMENT ON COLUMN tb_zyfx_access.f_userid IS '用户id';
COMMENT ON COLUMN tb_zyfx_access.f_accesscount IS '访问次数';

ALTER TABLE tb_zyfx_access ADD CONSTRAINT PK_tb_zyfx_access PRIMARY KEY (f_id);

--资源发现机构信息表
CREATE TABLE tb_zyfx_organization (
      f_id varchar(50) NOT NULL,
      f_pid varchar(50),
      f_name varchar(255),
      f_bsm varchar(50),
      f_address varchar(255),
      f_tel varchar(50),
      f_leader varchar(50),
      f_nodecode varchar(50),
      f_createtime timestamp,
      f_sort bigint,
      f_level smallint,
      f_desc text
);
COMMENT ON COLUMN tb_zyfx_organization.f_pid IS '父id';
COMMENT ON COLUMN tb_zyfx_organization.f_name IS '目录名称';
COMMENT ON COLUMN tb_zyfx_organization.f_bsm IS '机构编码';
COMMENT ON COLUMN tb_zyfx_organization.f_address IS '机构地址';
COMMENT ON COLUMN tb_zyfx_organization.f_tel IS '机构电话';
COMMENT ON COLUMN tb_zyfx_organization.f_leader IS '机构负责人';
COMMENT ON COLUMN tb_zyfx_organization.f_nodecode IS '节点编码（从根目录开始收到编码，子节点按照添加时间递增编码，参考行政区编码）';
COMMENT ON COLUMN tb_zyfx_organization.f_createtime IS '创建时间';
COMMENT ON COLUMN tb_zyfx_organization.f_sort IS '排序';
COMMENT ON COLUMN tb_zyfx_organization.f_level IS '级别';
COMMENT ON COLUMN tb_zyfx_organization.f_desc IS '机构信息';

ALTER TABLE tb_zyfx_organization ADD CONSTRAINT PK_tb_zyfx_organization PRIMARY KEY (f_id);

--项目信息
CREATE TABLE tb_zyfx_project (
     f_id varchar(50) NOT NULL,
     f_pid varchar(50) NOT NULL,
     f_xmmc varchar(255),
     f_xmbh varchar(50),
     f_xmlx smallint,
     f_desc varchar(255),
     f_leader varchar(50),
     f_tel varchar(50),
     f_createtime timestamp
);
COMMENT ON COLUMN tb_zyfx_project.f_pid IS '父项目id';
COMMENT ON COLUMN tb_zyfx_project.f_xmmc IS '项目名称';
COMMENT ON COLUMN tb_zyfx_project.f_xmbh IS '项目编号';
COMMENT ON COLUMN tb_zyfx_project.f_xmlx IS '项目类型（1.建设项目  2.科研项目 3.其他）';
COMMENT ON COLUMN tb_zyfx_project.f_desc IS '项目信息';
COMMENT ON COLUMN tb_zyfx_project.f_leader IS '项目负责人';
COMMENT ON COLUMN tb_zyfx_project.f_tel IS '联系电话';
COMMENT ON COLUMN tb_zyfx_project.f_createtime IS '项目开始时间';

ALTER TABLE tb_zyfx_project ADD CONSTRAINT PK_tb_zyfx_project PRIMARY KEY (f_id);

--申请订单（申请记录父表）
CREATE TABLE tb_zyfx_apply_order (
     f_id varchar(50) NOT NULL,
     f_name text,
     f_code varchar(255),
     f_userid varchar(50),
     f_username varchar(50),
     f_createtime timestamp,
     f_grouptype smallint,
     f_status smallint,
     f_finishtime timestamp
);
COMMENT ON COLUMN tb_zyfx_apply_order.f_id IS '订单id';
COMMENT ON COLUMN tb_zyfx_apply_order.f_name IS '订单名称';
COMMENT ON COLUMN tb_zyfx_apply_order.f_code IS '订单编号';
COMMENT ON COLUMN tb_zyfx_apply_order.f_userid IS '申请用户id';
COMMENT ON COLUMN tb_zyfx_apply_order.f_username IS '申请用户名称';
COMMENT ON COLUMN tb_zyfx_apply_order.f_createtime IS '创建时间';
COMMENT ON COLUMN tb_zyfx_apply_order.f_grouptype IS '分组（1 数据集 2.服务集 3.工具集）';
COMMENT ON COLUMN tb_zyfx_apply_order.f_status IS '订单状态(1 待审批 2.审批中 3.审批完成 4.退回）';
COMMENT ON COLUMN tb_zyfx_apply_order.f_finishtime IS '完成时间';

ALTER TABLE tb_zyfx_apply_order ADD CONSTRAINT PK_tb_zyfx_apply_group PRIMARY KEY (f_id);


ALTER TABLE tb_zyfx_object_apply ADD f_orderid varchar(50) NULL;
COMMENT ON COLUMN tb_zyfx_object_apply.f_orderid IS '订单id';
ALTER TABLE tb_zyfx_object_apply ADD f_dwmc varchar(255) NULL;
COMMENT ON COLUMN tb_zyfx_object_apply.f_dwmc IS '定位名称';
ALTER TABLE tb_zyfx_object_apply ADD f_dwdz varchar(255) NULL;
COMMENT ON COLUMN tb_zyfx_object_apply.f_dwdz IS '单位地址';


CREATE TABLE tb_zyfx_reg_aval (
      f_id varchar(50) NOT NULL,
      f_objectid varchar(50),
      f_reguserid varchar(50),
      f_regusername varchar(50),
      f_avalstatus smallint,
      f_avaluserid varchar(50),
      f_avalusername varchar(50),
      f_comment text,
      f_updatetime timestamp
);
COMMENT ON TABLE tb_zyfx_reg_aval IS '汇交注册 审核表';
COMMENT ON COLUMN tb_zyfx_reg_aval.f_objectid IS '关联对象id';
COMMENT ON COLUMN tb_zyfx_reg_aval.f_reguserid IS '注册用户id';
COMMENT ON COLUMN tb_zyfx_reg_aval.f_regusername IS '注册用户名称';
COMMENT ON COLUMN tb_zyfx_reg_aval.f_avalstatus IS '审核状态（0 未审核 1审核中 2审核通过 3审核不通过 4退回）';
COMMENT ON COLUMN tb_zyfx_reg_aval.f_avaluserid IS '审核用户名称';
COMMENT ON COLUMN tb_zyfx_reg_aval.f_avalusername IS '审核用户名称';
COMMENT ON COLUMN tb_zyfx_reg_aval.f_comment IS '审核说明';
COMMENT ON COLUMN tb_zyfx_reg_aval.f_updatetime IS '更新时间';

ALTER TABLE tb_zyfx_reg_aval ADD CONSTRAINT PK_tb_zyfx_reg_aval PRIMARY KEY (f_id);


--tb_zyfx_object 增加流程状态字段
ALTER TABLE tb_zyfx_object ADD f_flowstatus smallint NULL;
ALTER TABLE tb_zyfx_object ADD f_hot smallint;
ALTER TABLE tb_zyfx_object ADD f_zyzt varchar(128) NULL;
ALTER TABLE tb_zyfx_object ADD f_xmin numeric(15, 6) NULL;
ALTER TABLE tb_zyfx_object ADD f_ymin numeric(15, 6) NULL;
ALTER TABLE tb_zyfx_object ADD f_xmax numeric(15, 6) NULL;
ALTER TABLE tb_zyfx_object ADD f_ymax numeric(15, 6) NULL;

COMMENT ON COLUMN tb_zyfx_object.f_flowstatus IS '流程状态（0 未审核 1.审核中 2.审核通过 3.审核不通过 4退回）';
COMMENT ON COLUMN tb_zyfx_object.f_hot IS '是否推荐为热门数据，（1是，0否）';
COMMENT ON COLUMN tb_zyfx_object.f_zyzt IS '资源主题';




