/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.controller;

import cn.hutool.core.util.StrUtil;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.RowsResponse;
import com.geoway.ns.zyfx.domain.ZyfxCatalogScheme;
import com.geoway.ns.zyfx.service.ZyfxCatalogSchemeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u76ee\u5f55\u65b9\u6848\u63a5\u53e3"})
@RestController
@RequestMapping(value={"zyfx/catalog/scheme"})
public class ZyfxCatalogSchemeController {
    private static final Logger log = LoggerFactory.getLogger(ZyfxCatalogSchemeController.class);
    @Autowired
    ZyfxCatalogSchemeService zyfxCatalogSchemeService;

    @ApiOperation(value="\u67e5\u8be2\u65b9\u6848\u5217\u8868")
    @GetMapping(value={"listAll"}, produces={"application/json;charset=UTF-8"})
    public RowsResponse queryDataCatalogList(HttpServletRequest request, @RequestParam(value="filterParam", required=false) String filterParam, @RequestParam(value="needResCatalog", defaultValue="false", required=false) Boolean needResCatalog) {
        RowsResponse response = new RowsResponse();
        try {
            String sortParam = "SORT_sort_ASC";
            if (!needResCatalog.booleanValue()) {
                filterParam = StrUtil.isNotBlank((CharSequence)filterParam) ? filterParam + ";Q_key_S_NLK=zyml" : "Q_key_S_NLK=zyml";
            }
            List<ZyfxCatalogScheme> catalogSchemes = this.zyfxCatalogSchemeService.listAll(filterParam, sortParam);
            response.setRows(catalogSchemes);
            response.setTotal(Long.valueOf(catalogSchemes.size()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u67e5\u8be2\u65b9\u6848\u5217\u8868\u6811")
    @GetMapping(value={"listTree"}, produces={"application/json;charset=UTF-8"})
    public RowsResponse queryDataCatalogListTree(HttpServletRequest request, @RequestParam(value="filterParam", required=false) String filterParam, @RequestParam(value="needResCatalog", defaultValue="false", required=false) Boolean needResCatalog) {
        RowsResponse response = new RowsResponse();
        try {
            String sortParam = "SORT_sort_ASC";
            if (!needResCatalog.booleanValue()) {
                filterParam = StrUtil.isNotBlank((CharSequence)filterParam) ? filterParam + ";Q_key_S_NLK=zyml" : "Q_key_S_NLK=zyml";
            }
            List<ZyfxCatalogScheme> catalogSchemes = this.zyfxCatalogSchemeService.queryTree(filterParam, sortParam);
            response.setRows(catalogSchemes);
            response.setTotal(Long.valueOf(catalogSchemes.size()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5220\u9664\u76ee\u5f55\u65b9\u6848")
    @PostMapping(value={"delete"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse deleteCatalog(HttpServletRequest request, String id) {
        BaseResponse response = new BaseResponse();
        if (StrUtil.isNotEmpty((CharSequence)id)) {
            try {
                this.zyfxCatalogSchemeService.deleteOne(id);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage(), (Throwable)e);
                response.markFailure(e.getMessage());
            }
        }
        return response;
    }

    @ApiOperation(value="\u4fdd\u5b58\u65b9\u6848")
    @PostMapping(value={"save"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse saveCatalog(HttpServletRequest request, @ModelAttribute ZyfxCatalogScheme catalogScheme) {
        BaseResponse response = new BaseResponse();
        try {
            this.zyfxCatalogSchemeService.saveOne(catalogScheme);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }
}

