/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.ns.sys.dto.BaseObjectResponse;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.dto.EasyUIResponse;
import com.geoway.ns.sys.dto.FileServerResponse;
import com.geoway.ns.sys.dto.FileUploadResponse;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.dto.UploadedFileInfo;
import com.geoway.ns.sys.dto.UploadingFileInfo;
import com.geoway.ns.sys.service.FileServerService;
import com.geoway.ns.sys.service.RedisLockService;
import com.geoway.ns.sys.service.impl.TokenServiceImpl;
import com.geoway.ns.sys.utils.MyRequestUtil;
import com.geoway.ns.zyfx.domain.DataDelivery;
import com.geoway.ns.zyfx.domain.DataDeliveryItem;
import com.geoway.ns.zyfx.dto.ChartPieDTO;
import com.geoway.ns.zyfx.dto.RestServiceDeliveryQueryParams;
import com.geoway.ns.zyfx.dto.ShareExDeliveryDTO;
import com.geoway.ns.zyfx.dto.ShareExDeliveryParams;
import com.geoway.ns.zyfx.dto.ShareExLineChartDTO;
import com.geoway.ns.zyfx.service.DataDeliveryService;
import com.geoway.ns.zyfx.utils.CustomDateTimeEditor;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.beans.PropertyEditor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u6570\u636e\u6c47\u4ea4"})
@RestController
@RequestMapping(value={"dataDelivery"})
public class DataDeliveryController {
    private static final Logger log = LoggerFactory.getLogger(DataDeliveryController.class);
    @Resource
    private DataDeliveryService dataDeliveryService;
    @Autowired
    private TokenServiceImpl tokenService;
    @Autowired
    RedisLockService redisLockService;
    @Resource
    private FileServerService fileServerService;
    @Autowired
    private RedisTemplate redisTemplate;

    @InitBinder
    public void dataBinding(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateTimeEditor());
    }

    @ApiOperation(value="\u6570\u636e\u5206\u53d1\u4e0a\u4f20\u9644\u4ef6\u53ca\u8868\u5355\u4fe1\u606f")
    @PostMapping(value={"/addDataDeliveryInfo.do"})
    public BaseResponse addDataDeliveryInfo(HttpServletRequest request, @ModelAttribute DataDelivery dataDelivery, @RequestParam(value="token", required=false) String token, @RequestParam(value="file", required=false) MultipartFile[] files, @RequestParam(value="fileInfos", required=false) String fileInfos, @RequestParam(value="dataDeliveryItemsStr", required=false) String dataDeliveryItemsStr) {
        BaseResponse response = new BaseResponse();
        if (StrUtil.isNotBlank((CharSequence)dataDelivery.getNumber())) {
            try {
                SysUserDTO sysUser;
                if (StringUtils.isEmpty((CharSequence)token)) {
                    token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
                }
                if ((sysUser = this.tokenService.querySysUserByToken(token)) == null) {
                    return BaseResponse.buildFailuaResponse((String)"\u8bf7\u5148\u767b\u5165\u7cfb\u7edf");
                }
                String userId = sysUser.getId();
                String code = sysUser.getXzqdm();
                JSONArray fileInfoJSonArray = null;
                if (StringUtils.isNotEmpty((CharSequence)fileInfos)) {
                    fileInfoJSonArray = JSONArray.parseArray((String)fileInfos);
                }
                List _dataDeliveryItems = null;
                if (StringUtils.isNotEmpty((CharSequence)dataDeliveryItemsStr)) {
                    Gson gson = new Gson();
                    _dataDeliveryItems = (List)gson.fromJson(dataDeliveryItemsStr, new TypeToken<List<DataDeliveryItem>>(){}.getType());
                }
                List<Map<String, String>> list = this.dataDeliveryService.addDataDeliveryInfo(sysUser, code, dataDelivery, files, fileInfoJSonArray, _dataDeliveryItems);
                boolean hasAuditRole = sysUser.getRoles().stream().filter(role -> role != null).anyMatch(role -> role.getRolename().contains("\u5ba1\u6838"));
                if (hasAuditRole) {
                    DataDelivery dataDeliveryCheck = this.dataDeliveryService.queryShareExDeliveryInfoDetails(dataDelivery.getId(), sysUser);
                    dataDeliveryCheck.setStatus(2);
                    dataDeliveryCheck.setReviewremark("\u5ba1\u6838\u5458\u6c47\u4ea4\uff0c\u9ed8\u8ba4\u5ba1\u6838\u901a\u8fc7\u3002");
                    dataDeliveryCheck.setUpdateTime(new Date());
                    if ("1".equals(dataDeliveryCheck.getType())) {
                        this.dataDeliveryService.generateDeliveryCertificate(dataDeliveryCheck);
                    }
                    this.dataDeliveryService.saveOne(sysUser, dataDeliveryCheck);
                }
                response.setMessage("\u6570\u636e\u5206\u53d1\u63d0\u4ea4\u6210\u529f");
            }
            catch (Exception e) {
                return BaseResponse.buildFailuaResponse((String)e.getMessage());
            }
        } else {
            response.setMessage("\u5206\u53d1\u5355\u7f16\u53f7\u683c\u5f0f\u9519\u8bef\u6216\u8005\u4e0d\u5b58\u5728");
        }
        return response;
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    @RequestMapping(value={"deleteById"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse deleteById(HttpServletRequest request, String id) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            response.setData((Object)this.dataDeliveryService.deleteById(sysUser, id));
        }
        catch (Exception e) {
            return BaseResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6570\u636e\u5206\u53d1\u4e0a\u4f20\u9644\u4ef6\u53ca\u8868\u5355\u4fe1\u606f")
    @PostMapping(value={"/updateDataDeliveryInfo.do"})
    public BaseResponse updateDataDeliveryInfo(HttpServletRequest request, @ModelAttribute DataDelivery dataDelivery, @RequestParam(value="token", required=false) String token, @RequestParam(value="file", required=false) MultipartFile[] files) {
        BaseResponse response = new BaseResponse();
        if (StrUtil.isNotBlank((CharSequence)dataDelivery.getNumber())) {
            try {
                if (StringUtils.isEmpty((CharSequence)token)) {
                    token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
                }
                SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
                String code = sysUser.getXzqdm();
                List<Map<String, String>> list = this.dataDeliveryService.updateDataDeliveryInfo(sysUser, code, dataDelivery, files);
                response.setMessage("\u6570\u636e\u5206\u53d1\u63d0\u4ea4\u6210\u529f");
            }
            catch (Exception e) {
                return BaseResponse.buildFailuaResponse((String)e.getMessage());
            }
        } else {
            response.setMessage("\u5206\u53d1\u5355\u7f16\u53f7\u683c\u5f0f\u9519\u8bef\u6216\u8005\u4e0d\u5b58\u5728");
        }
        return response;
    }

    @ApiOperation(value="\u6570\u636e\u5206\u53d1\u8868\u5355\u4fe1\u606f(\u6279\u91cf)")
    @PostMapping(value={"/addDataDeliveryInfoBatch.do"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse addDataDeliveryInfoBatch(HttpServletRequest request, @RequestParam(value="token", required=false) String token, @RequestBody List<DataDelivery> dataDeliveries) {
        BaseResponse response = new BaseResponse();
        try {
            if (StringUtils.isEmpty((CharSequence)token)) {
                token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            }
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            String code = sysUser.getXzqdm();
            this.dataDeliveryService.addDataDeliveryInfoBatch(sysUser, code, dataDeliveries);
            response.setMessage("\u6570\u636e\u5206\u53d1\u63d0\u4ea4\u6210\u529f");
        }
        catch (DuplicateKeyException e) {
            return BaseResponse.buildFailuaResponse((String)("\u6c47\u4ea4\u5355\u7f16\u53f7\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u6c47\u4ea4\u5355\uff1a" + e.getMessage()));
        }
        catch (Exception e) {
            return BaseResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6570\u636e\u5206\u53d1\u8868\u5355\u4fe1\u606f\u4fee\u6539")
    @PostMapping(value={"/updateDataDeliveryInfoBatch.do"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse updateDataDeliveryInfoBatch(HttpServletRequest request, @RequestParam(value="token", required=false) String token, @RequestBody List<DataDelivery> dataDeliveries) {
        BaseResponse response = new BaseResponse();
        try {
            if (StringUtils.isEmpty((CharSequence)token)) {
                token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            }
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            if (dataDeliveries.size() == 0) {
                throw new RuntimeException("\u5185\u5bb9\u4e3a\u7a7a");
            }
            DataDelivery dataDeliverie = dataDeliveries.get(0);
            if (StringUtils.isBlank((CharSequence)dataDeliverie.getId())) {
                throw new RuntimeException("\u5185\u5bb9\u7f3a\u5c11id\u503c");
            }
            this.dataDeliveryService.updateDataDeliveryInfoBatch(sysUser, dataDeliverie);
            response.setMessage("\u6570\u636e\u5206\u53d1\u63d0\u4ea4\u6210\u529f");
        }
        catch (Exception e) {
            return BaseResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6570\u636e\u6c47\u4ea4\u4e0a\u4f20\u9644\u4ef6\u8fdb\u5ea6\u83b7\u53d6")
    @GetMapping(value={"/getFileUploadDegree.do"})
    public BaseResponse getFileUploadDegree(HttpServletRequest request, @RequestParam(value="id") String id) {
        BaseObjectResponse response = new BaseObjectResponse();
        String ratio = "100";
        response.setData((Object)(ratio + "%"));
        response.setMessage("");
        return response;
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @RequestMapping(value={"/searchPage.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public EasyUIResponse searchPage(HttpServletRequest request, RestServiceDeliveryQueryParams params, @RequestParam(value="token", required=false) String token) {
        EasyUIResponse response = new EasyUIResponse();
        try {
            if (StringUtils.isEmpty((CharSequence)token)) {
                token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            }
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            params.setUserId(sysUser.getId());
            if (params.getMenuType() != null) {
                params.setMenuType(2);
            }
            if (StrUtil.isBlank((CharSequence)params.getOrder())) {
                params.setOrder("f_createtime");
            }
            if (StrUtil.isBlank((CharSequence)params.getOrderType())) {
                params.setOrderType("desc");
            }
            IPage<DataDelivery> resultPage = this.dataDeliveryService.searchPage(params, sysUser);
            response.setRows(resultPage.getRecords());
            response.setTotal(Long.valueOf(resultPage.getTotal()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            response.markFailure();
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u8bbe\u7f6e\u6d88\u606f\u4e3a\u5df2\u8bfb")
    @PostMapping(value={"setHasReadById"}, produces={"application/json;charset=UTF-8"})
    public BaseObjectResponse setHasReadById(HttpServletRequest request, @RequestParam(value="id") String id, @RequestParam(value="hasRead", required=false, defaultValue="1") Integer hasRead) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            this.dataDeliveryService.setHasReadById(id, hasRead);
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6570\u636e\u6c47\u4ea4\u4e0b\u8f7d\u7559\u75d5")
    @RequestMapping(value={"/sjhjOutputOplog"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public BaseResponse sjhjOutputOplog() {
        BaseResponse responseDataBase = new BaseResponse();
        return responseDataBase;
    }

    @ApiOperation(value="\u7b80\u5355\u6587\u4ef6\u4e0a\u4f20")
    @PostMapping(value={"/uploadFile"})
    public BaseResponse uploadFile(@RequestParam(value="file") MultipartFile multipartFile, @RequestParam(value="md5") String md5) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            String contentType = multipartFile.getContentType();
            System.out.println("\u6587\u4ef6\u7c7b\u578b\uff08MIME\u7c7b\u578b\uff09: " + contentType);
            FileServerResponse fileServerResponse = this.fileServerService.sendFileToServer(multipartFile, contentType.toLowerCase().contains("image"));
            if (fileServerResponse != null && StringUtils.isNotEmpty((CharSequence)fileServerResponse.getViewURL())) {
                FileUploadResponse fileUploadResponse = FileUploadResponse.builder().absolutePath(fileServerResponse.getViewURL()).relativePath(fileServerResponse.getPath()).objectUrl(fileServerResponse.getPath()).build();
                UploadedFileInfo uploadInfo = new UploadedFileInfo();
                uploadInfo.setMd5(md5);
                uploadInfo.setFileSize(Long.valueOf(multipartFile.getSize()));
                uploadInfo.setOriginalFileName(multipartFile.getOriginalFilename());
                uploadInfo.setFileurl(fileServerResponse.getViewURL());
                uploadInfo.setFileInfo(fileUploadResponse);
                Gson gson = new Gson();
                this.redisTemplate.opsForHash().put((Object)"UploadedFilesMD5", (Object)(md5 + "=" + multipartFile.getOriginalFilename()), (Object)gson.toJson((Object)uploadInfo));
                response.setData((Object)fileUploadResponse);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/upLoadFileByChunk"})
    public BaseResponse upLoadFileByChunk(HttpServletRequest request, @RequestParam(value="chunk") MultipartFile chunk, @RequestParam(value="filename") String fileName, @RequestParam(value="originalFileName") String originalFileName, @RequestParam(value="md5") String md5, @RequestParam(value="chunkIndex") Integer chunkIndex, @RequestParam(value="chunkCount") Integer chunkCount, @RequestParam(value="chunkSize") Long chunkSize, @RequestParam(value="fileSize") Long fileSize, @RequestParam(value="token", required=false) String token, @RequestParam(value="isParallel") Boolean isParallel) {
        BaseResponse response = new BaseResponse();
        try {
            String uploadInfoOldStr = (String)this.redisTemplate.opsForHash().get((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName));
            UploadingFileInfo uploadingFileInfo = new UploadingFileInfo();
            if (StringUtils.isNotEmpty((CharSequence)uploadInfoOldStr)) {
                Gson gson = new Gson();
                uploadingFileInfo = (UploadingFileInfo)gson.fromJson(uploadInfoOldStr, UploadingFileInfo.class);
            }
            uploadingFileInfo.setIsParallelParallel(isParallel);
            uploadingFileInfo.setFileName(fileName);
            uploadingFileInfo.setOriginalFileName(originalFileName);
            uploadingFileInfo.setMd5(md5);
            uploadingFileInfo.setChunkIndex(chunkIndex);
            uploadingFileInfo.setChunkCount(chunkCount);
            uploadingFileInfo.setChunkSize(chunkSize);
            uploadingFileInfo.setFileSize(fileSize);
            if (StringUtils.isEmpty((CharSequence)token)) {
                token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            }
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            String code = "010001001";
            if (sysUser != null && StringUtils.isNotEmpty((CharSequence)sysUser.getXzqdm())) {
                code = sysUser.getXzqdm();
            }
            this.fileServerService.upLoadFileByChunk(code, originalFileName, chunk, uploadingFileInfo, isParallel);
            response.setMessage("\u5206\u7247\u4e0a\u4f20\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.redisLockService.unlock("UploadingFilesMD5" + md5, chunkIndex + "");
            return BaseResponse.buildFailuaResponse((String)e.getMessage(), (Integer)500);
        }
        return response;
    }

    @GetMapping(value={"/upLoadFileCompleteWithMerge"})
    public BaseResponse upLoadFileCompleteWithMerge(@RequestParam(value="filename") String fileName, @RequestParam(value="originalFileName") String originalFileName, @RequestParam(value="md5") String md5) {
        BaseObjectResponse response = new BaseObjectResponse();
        String uploadInfoOldStr = (String)this.redisTemplate.opsForHash().get((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName));
        try {
            Gson gson;
            UploadingFileInfo uploadInfoOld;
            if (StringUtils.isNotEmpty((CharSequence)uploadInfoOldStr) && (uploadInfoOld = (UploadingFileInfo)(gson = new Gson()).fromJson(uploadInfoOldStr, UploadingFileInfo.class)) != null) {
                FileUploadResponse fileUploadResponse = this.fileServerService.upLoadFileCompleteWithMerge(uploadInfoOld);
                if (StringUtils.isNotEmpty((CharSequence)originalFileName)) {
                    UploadedFileInfo uploadInfo = new UploadedFileInfo();
                    uploadInfo.setMd5(md5);
                    uploadInfo.setFileSize(uploadInfoOld.getFileSize());
                    uploadInfo.setOriginalFileName(originalFileName);
                    uploadInfo.setFileurl(fileUploadResponse.getObjectUrl());
                    uploadInfo.setFileInfo(fileUploadResponse);
                    this.redisTemplate.opsForHash().put((Object)"UploadedFilesMD5", (Object)(md5 + "=" + originalFileName), (Object)gson.toJson((Object)uploadInfo));
                    this.redisTemplate.opsForHash().delete((Object)"UploadingFilesMD5", new Object[]{md5 + "=" + originalFileName});
                }
                response.setData((Object)fileUploadResponse);
            }
            response.setMessage("\u6570\u636e\u4e0a\u4f20\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @GetMapping(value={"/upLoadFileWithBeforeCheck"})
    public BaseResponse upLoadFileWithBeforeCheck(@RequestParam(value="md5") String md5, @RequestParam(value="originalFileName") String originalFileName) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        if (!this.redisTemplate.opsForHash().hasKey((Object)"UploadedFilesMD5", (Object)(md5 + "=" + originalFileName)).booleanValue()) {
            if (this.redisTemplate.opsForHash().hasKey((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName)).booleanValue()) {
                String uploadInfoString = (String)this.redisTemplate.opsForHash().get((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName));
                BaseObjectResponse objectResponse = new BaseObjectResponse();
                objectResponse.setData((Object)JSON.parseObject((String)uploadInfoString));
                objectResponse.setCode(Integer.valueOf(100));
                return objectResponse;
            }
            return BaseResponse.buildFailuaResponse((String)"\u670d\u52a1\u7aef\u4e0d\u5b58\u5728\u8be5\u6587\u4ef6", (Integer)404);
        }
        String uploadInfoOldStr = (String)this.redisTemplate.opsForHash().get((Object)"UploadedFilesMD5", (Object)(md5 + "=" + originalFileName));
        Gson gson = new Gson();
        UploadedFileInfo uploadInfoOld = (UploadedFileInfo)gson.fromJson(uploadInfoOldStr, UploadedFileInfo.class);
        if (StringUtils.isNotEmpty((CharSequence)md5) && md5.equalsIgnoreCase(uploadInfoOld.getMd5())) {
            baseObjectResponse.setData((Object)uploadInfoOld);
            baseObjectResponse.setMessage("\u670d\u52a1\u7aef\u5df2\u7ecf\u5b58\u5728\u8be5\u6587\u4ef6\uff01");
            return baseObjectResponse;
        }
        return BaseResponse.buildFailuaResponse((String)"\u670d\u52a1\u7aef\u4e0d\u5b58\u5728\u8be5\u6587\u4ef6", (Integer)404);
    }

    @GetMapping(value={"/listUpLoadFileParts"})
    public BaseResponse listUpLoadFileParts(@RequestParam(value="originalFileName") String originalFileName, @RequestParam(value="md5") String md5) {
        BaseObjectResponse response = new BaseObjectResponse();
        String uploadInfoOldStr = (String)this.redisTemplate.opsForHash().get((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName));
        try {
            Gson gson;
            UploadingFileInfo uploadInfoOld;
            if (StringUtils.isNotEmpty((CharSequence)uploadInfoOldStr) && (uploadInfoOld = (UploadingFileInfo)(gson = new Gson()).fromJson(uploadInfoOldStr, UploadingFileInfo.class)) != null) {
                List list = this.fileServerService.listUpLoadFileParts(uploadInfoOld);
                response.setData((Object)list);
            }
            response.setMessage("\u8bf7\u6c42\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @GetMapping(value={"/listUpLoadFileTasks"})
    public BaseResponse listUpLoadFileTasks() {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            List list = this.fileServerService.listUpLoadFileTasks();
            response.setData((Object)list);
            response.setMessage("\u8bf7\u6c42\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @GetMapping(value={"/cancelUploadFile"})
    public BaseResponse cancelUploadFile(@RequestParam(value="originalFileName") String originalFileName, @RequestParam(value="md5") String md5) {
        BaseObjectResponse response = new BaseObjectResponse();
        String uploadInfoOldStr = (String)this.redisTemplate.opsForHash().get((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName));
        try {
            Gson gson;
            UploadingFileInfo uploadInfoOld;
            if (StringUtils.isNotEmpty((CharSequence)uploadInfoOldStr) && (uploadInfoOld = (UploadingFileInfo)(gson = new Gson()).fromJson(uploadInfoOldStr, UploadingFileInfo.class)) != null) {
                BaseResponse baseResponse = this.fileServerService.abortMultipartUpload(uploadInfoOld);
                if (baseResponse.getCode() == 200) {
                    this.redisTemplate.opsForHash().delete((Object)"UploadingFilesMD5", new Object[]{md5 + "=" + originalFileName});
                }
                return baseResponse;
            }
            return BaseResponse.buildFailuaResponse((String)"\u53d6\u6d88\u4efb\u52a1\u4e0a\u4f20\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMessage(e.getMessage());
            return response;
        }
    }

    @GetMapping(value={"/cancelUploadFile1"})
    public BaseResponse cancelUploadFile1(@RequestParam(value="objectKey") String objectKey, @RequestParam(value="uploadId") String uploadId) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            return this.fileServerService.abortMultipartUpload(objectKey, uploadId);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMessage(e.getMessage());
            return response;
        }
    }

    @RequestMapping(value={"/query-getDeliveryNumber"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse getDeliveryNumber(@RequestBody List<Integer> years) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            HashSet<Integer> yearSet = new HashSet<Integer>(years);
            response.setData(this.dataDeliveryService.getDeliveryNumber(yearSet));
        }
        catch (Exception e) {
            return BaseResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/query-shareExDeliveryInfoDetails"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse queryShareExDeliveryInfoDetails(String id, HttpServletRequest request, @RequestParam(value="token", required=false) String token) {
        BaseObjectResponse responseDataBase = new BaseObjectResponse();
        try {
            if (StringUtils.isEmpty((CharSequence)token)) {
                token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            }
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            DataDelivery dataDelivery = this.dataDeliveryService.queryShareExDeliveryInfoDetails(id, sysUser);
            responseDataBase.setData((Object)dataDelivery);
        }
        catch (Exception e) {
            return BaseObjectResponse.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @RequestMapping(value={"/query-shareExDeliveryStatic"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse queryShareExDeliveryStatic(Integer year) {
        BaseObjectResponse responseDataBase = new BaseObjectResponse();
        try {
            Map<String, Object> map = this.dataDeliveryService.queryShareExDeliveryStatic(year);
            responseDataBase.setData(map);
        }
        catch (Exception e) {
            return BaseObjectResponse.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @RequestMapping(value={"/query-shareExDeliveryTableData"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse queryShareExDeliveryTableData(ShareExDeliveryParams params) {
        BaseObjectResponse responseDataBase = new BaseObjectResponse();
        try {
            Date strDate = null;
            Date endDate = null;
            if (StringUtils.isNotEmpty((CharSequence)params.getSTime()) && StringUtils.isNotEmpty((CharSequence)params.getETime())) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                strDate = sdf.parse(params.getSTime());
                endDate = sdf.parse(params.getETime());
                params.setStrTime(strDate);
                params.setEndTime(endDate);
            }
            IPage<ShareExDeliveryDTO> deliveryTableData = this.dataDeliveryService.queryShareExDeliveryTableData(params);
            responseDataBase.setData(deliveryTableData);
        }
        catch (Exception e) {
            return BaseObjectResponse.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @RequestMapping(value={"/query-shareExDeliveryChartData"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse queryShareExDeliveryPieChartData(String groupBy, Integer year) {
        BaseObjectResponse responseDataBase = new BaseObjectResponse();
        try {
            List<ChartPieDTO> data = this.dataDeliveryService.queryShareExDeliveryChartData(groupBy, year);
            responseDataBase.setData(data);
        }
        catch (Exception e) {
            return BaseObjectResponse.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @RequestMapping(value={"/query-shareExDeliveryLineChartData"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse queryShareExDeliveryLineChartData(Integer year) {
        BaseObjectResponse responseDataBase = new BaseObjectResponse();
        try {
            List<ShareExLineChartDTO> data = this.dataDeliveryService.queryShareExDeliveryLineChartData(year);
            responseDataBase.setData(data);
        }
        catch (Exception e) {
            return BaseObjectResponse.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @RequestMapping(value={"/query-shareExDeliveryYears"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse queryDeliveryYears() {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            response.setData((Object)this.dataDeliveryService.queryDeliveryYears());
        }
        catch (Exception e) {
            return BaseResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }

    @RequestMapping(value={"/generateDeliveryCertificate"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse generateDeliveryCertificate(String id) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            response.setData((Object)this.dataDeliveryService.generateDeliveryCertificate(id));
        }
        catch (Exception e) {
            return BaseResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6c47\u4ea4\u6e05\u6863\u5bfc\u51faExcel")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public void excelExport(HttpServletRequest request, HttpServletResponse response, RestServiceDeliveryQueryParams params, @RequestParam(value="token", required=false) String token) throws Exception {
        if (StringUtils.isEmpty((CharSequence)token)) {
            token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
        }
        SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
        params.setUserId(sysUser.getId());
        if (params.getMenuType() != null) {
            params.setMenuType(2);
        }
        if (StrUtil.isBlank((CharSequence)params.getOrder())) {
            params.setOrder("f_createtime");
        }
        if (StrUtil.isBlank((CharSequence)params.getOrderType())) {
            params.setOrderType("desc");
        }
        this.dataDeliveryService.excelExport(response, params);
    }
}

