/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl.export;

import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.DistrictService;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.ns.zyfx.domain.ZyfxObjectApply;
import com.geoway.ns.zyfx.dto.ZyfxObjectDetail;
import com.geoway.ns.zyfx.mapper.ZyfxDatasetMapper;
import com.geoway.ns.zyfx.service.ExportTaskParamsService;
import com.geoway.ns.zyfx.service.ZyfxObjectService;
import com.geoway.webstore.export.constant.ExportVectorFormatEnum;
import com.geoway.webstore.export.dto.ExportCustomTaskUnitDTO;
import com.geoway.webstore.export.params.ExportTaskLayerParams;
import com.geoway.webstore.export.params.ExportTaskVectorParams;
import com.geoway.webstore.export.params.ExportVectorFieldsMath;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VectorDataTaskParamsServiceImpl
implements ExportTaskParamsService {
    @Autowired
    private DistrictService districtService;
    @Autowired
    private ZyfxObjectService zyfxObjectService;
    @Autowired
    ZyfxDatasetMapper zyfxDatasetMapper;
    @Resource
    private DataSourceService dataSourceService;

    @Override
    public ExportCustomTaskUnitDTO toExportTaskLayerParams(String outputPath, ZyfxObjectApply shareDataApplyDetail) {
        if (shareDataApplyDetail == null || StringUtils.isEmpty((CharSequence)shareDataApplyDetail.getParams())) {
            return null;
        }
        JSONObject paramJson = JSONObject.parseObject((String)shareDataApplyDetail.getParams());
        DistrictItemDTO targetDistrictItemDTO = null;
        int targetLevel = -1;
        if (paramJson != null && paramJson.containsKey((Object)"range") && paramJson.getInteger("range").equals(1)) {
            targetDistrictItemDTO = ExportTaskParamsService.getTargetDistrictItemDTO(shareDataApplyDetail);
            targetLevel = ExportTaskParamsService.getTargetXzqDistrictLevel(shareDataApplyDetail);
        }
        ArrayList<ExportTaskLayerParams> outputParams = new ArrayList<ExportTaskLayerParams>();
        ZyfxObjectDetail zyfxObjectDetail = this.zyfxObjectService.findDetailById(shareDataApplyDetail.getObjectid(), false, false);
        String realDatasetId = ExportTaskParamsService.getRealDatasetId(zyfxObjectDetail);
        this.getExportTaskLayerParams(outputPath, targetDistrictItemDTO, shareDataApplyDetail, realDatasetId, targetLevel, outputParams);
        ExportCustomTaskUnitDTO taskUnitDTO = new ExportCustomTaskUnitDTO();
        taskUnitDTO.setName(shareDataApplyDetail.getObjectname());
        taskUnitDTO.setTaskLayerParamsList(outputParams);
        return taskUnitDTO;
    }

    private void getExportTaskLayerParams(String parentPath, DistrictItemDTO districtItemDTO, ZyfxObjectApply shareDataApplyDetail, String targetDatasetId, int targetOrgLevel, List<ExportTaskLayerParams> params) {
        if (shareDataApplyDetail == null || StringUtils.isEmpty((CharSequence)shareDataApplyDetail.getParams())) {
            return;
        }
        JSONObject paramJson = JSONObject.parseObject((String)shareDataApplyDetail.getParams());
        if (paramJson == null) {
            throw new RuntimeException("\u4e0d\u5305\u542bparams\u4fe1\u606f");
        }
        if (paramJson.containsKey((Object)"range") && !paramJson.getInteger("range").equals(1)) {
            String targetPath = Paths.get(parentPath, shareDataApplyDetail.getObjectname() + "." + paramJson.getString("exportFormat")).toFile().getAbsolutePath();
            ExportTaskVectorParams vectorParams = new ExportTaskVectorParams();
            vectorParams.setClip(Boolean.valueOf(paramJson.containsKey((Object)"clip") ? paramJson.getInteger("clip") == 1 : false));
            vectorParams.setFormat(this.getExportFormat(shareDataApplyDetail));
            vectorParams.setDatasetId(targetDatasetId);
            if (!paramJson.containsKey((Object)"extent") || paramJson.getJSONArray("extent").size() == 0) {
                throw new RuntimeException("\u7a7a\u95f4\u8303\u56f4\u4e0d\u5b58\u5728");
            }
            vectorParams.setGeometry(this.UnionGeometry(paramJson.getJSONArray("extent")));
            vectorParams.setCondition(paramJson.containsKey((Object)"filters") ? paramJson.getString("filters") : paramJson.getString("filter"));
            vectorParams.setRelation("Intersects");
            vectorParams.setTargetPath(targetPath);
            vectorParams.setTargetName(shareDataApplyDetail.getObjectname());
            vectorParams.setExportFields(this.getExportFields(shareDataApplyDetail));
            params.add((ExportTaskLayerParams)vectorParams);
        } else if (districtItemDTO.getLevelIndex() >= targetOrgLevel) {
            String targetPath = Paths.get(parentPath, String.format("%s_%s", districtItemDTO.getName(), districtItemDTO.getCode())).toFile().getAbsolutePath();
            File targetFile = new File(targetPath);
            if (!targetFile.exists()) {
                targetFile.mkdirs();
            }
            targetPath = Paths.get(targetPath, shareDataApplyDetail.getObjectname() + "." + paramJson.getString("exportFormat")).toFile().getAbsolutePath();
            ExportTaskVectorParams vectorParams = new ExportTaskVectorParams();
            vectorParams.setClip(Boolean.valueOf(paramJson.containsKey((Object)"clip") ? paramJson.getInteger("clip") == 1 : false));
            vectorParams.setFormat(this.getExportFormat(shareDataApplyDetail));
            vectorParams.setDatasetId(targetDatasetId);
            vectorParams.setGeometry(this.districtService.getDistrictItemGeometry(districtItemDTO.getId()).toWkt());
            vectorParams.setCondition(paramJson.containsKey((Object)"filters") ? paramJson.getString("filters") : paramJson.getString("filter"));
            vectorParams.setRelation("Intersects");
            vectorParams.setTargetPath(targetPath);
            vectorParams.setTargetName(shareDataApplyDetail.getObjectname());
            vectorParams.setExportFields(this.getExportFields(shareDataApplyDetail));
            params.add((ExportTaskLayerParams)vectorParams);
        } else {
            List childDistrictItems = this.districtService.getDistrictItem(districtItemDTO.getDistrictId(), null, districtItemDTO.getCode(), "", Boolean.valueOf(false), Integer.valueOf(10000));
            String tempPath = Paths.get(parentPath, String.format("%s_%s", districtItemDTO.getName(), districtItemDTO.getCode())).toFile().getAbsolutePath();
            for (DistrictItemDTO childDistrictItem : childDistrictItems) {
                this.getExportTaskLayerParams(tempPath, childDistrictItem, shareDataApplyDetail, targetDatasetId, targetOrgLevel, params);
            }
        }
    }

    private String UnionGeometry(JSONArray jsonArray) {
        IGeometry unionGeo = null;
        if (jsonArray.size() == 1) {
            return jsonArray.getString(0);
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            String geoWkt = jsonArray.getString(i);
            IGeometry geo = GeometryFunc.createGeometry((String)geoWkt);
            if (geo == null) continue;
            unionGeo = unionGeo != null ? unionGeo.union(geo) : geo;
        }
        if (unionGeo == null) {
            throw new RuntimeException("\u8303\u56f4\u5408\u5e76\u9519\u8bef");
        }
        return unionGeo.toWkt();
    }

    private List<ExportVectorFieldsMath> getExportFields(ZyfxObjectApply shareDataApplyDetail) {
        if (shareDataApplyDetail == null || StringUtils.isEmpty((CharSequence)shareDataApplyDetail.getParams())) {
            return null;
        }
        JSONObject paramJson = JSONObject.parseObject((String)shareDataApplyDetail.getParams());
        if (paramJson == null || !paramJson.containsKey((Object)"fields")) {
            throw new RuntimeException("\u4e0d\u5305\u542bfields\u5b57\u6bb5");
        }
        String[] fieldStrs = paramJson.getString("fields").split(",");
        ArrayList<ExportVectorFieldsMath> fields = new ArrayList<ExportVectorFieldsMath>();
        for (String fieldStr : fieldStrs) {
            ExportVectorFieldsMath vectorFieldsMath = new ExportVectorFieldsMath();
            vectorFieldsMath.setSourceField(fieldStr);
            vectorFieldsMath.setTargetField(fieldStr);
            fields.add(vectorFieldsMath);
        }
        return fields;
    }

    private ExportVectorFormatEnum getExportFormat(ZyfxObjectApply shareDataApplyDetail) {
        if (shareDataApplyDetail == null || StringUtils.isEmpty((CharSequence)shareDataApplyDetail.getParams())) {
            return null;
        }
        JSONObject paramJson = JSONObject.parseObject((String)shareDataApplyDetail.getParams());
        if (paramJson == null || !paramJson.containsKey((Object)"exportFormat")) {
            throw new RuntimeException("\u4e0d\u5305\u542bexportFormat\u5b57\u6bb5");
        }
        switch (paramJson.getString("exportFormat").toLowerCase()) {
            case "shp": {
                return ExportVectorFormatEnum.SHAPEFILE;
            }
            case "mdb": {
                return ExportVectorFormatEnum.PGDB;
            }
            case "gdb": {
                return ExportVectorFormatEnum.FGDB;
            }
            case "gpkg": {
                return ExportVectorFormatEnum.GeoPackage;
            }
            case "\u7cfb\u7edf\u7a7a\u95f4\u5e93": {
                return ExportVectorFormatEnum.SPATIALDB;
            }
        }
        return ExportVectorFormatEnum.SHAPEFILE;
    }
}

