/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.datasource.dao.DmDistrictDao;
import com.geoway.adf.dms.datasource.dao.DmDistrictItemDao;
import com.geoway.adf.dms.datasource.entity.DmDistrict;
import com.geoway.ns.sys.dto.FileDownloadMeta;
import com.geoway.ns.sys.dto.FileServerResponse;
import com.geoway.ns.sys.dto.FileStructureDTO;
import com.geoway.ns.sys.service.FileServerService;
import com.geoway.ns.sys.support.DateUtils;
import com.geoway.ns.sys.utils.FileUploadUtil;
import com.geoway.ns.zyfx.constant.submitcenter.EnumConcurrentTaskMode;
import com.geoway.ns.zyfx.domain.ConcurrentCheck;
import com.geoway.ns.zyfx.domain.ConcurrentTask;
import com.geoway.ns.zyfx.domain.ConcurrentTemplates;
import com.geoway.ns.zyfx.mapper.ConcurrentCheckMapper;
import com.geoway.ns.zyfx.service.ConcurrentCheckService;
import com.geoway.ns.zyfx.service.ConcurrentTaskService;
import com.geoway.ns.zyfx.service.ConcurrentTemplatesService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ConcurrentCheckServiceImpl
extends ServiceImpl<ConcurrentCheckMapper, ConcurrentCheck>
implements ConcurrentCheckService {
    private static final String[] PARSE_PATTERNS = new String[]{"yyyy-MM-dd", "yyyy\u5e74MM\u6708dd\u65e5", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyyMMdd", "yyyy", "yyyy-MM", "yyyyMM"};
    @Autowired
    FileServerService fileServerService;
    @Autowired
    FileUploadUtil fileUploadUtil;
    @Resource
    private DmDistrictItemDao dmDistrictItemDao;
    @Autowired
    DmDistrictDao dmDistrictDao;
    @Resource
    private ConcurrentTemplatesService concurrentTemplatesService;
    @Resource
    private ConcurrentTaskService concurrentTaskService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void checkConcurrentTask(ConcurrentCheck concurrentCheck) throws Exception {
        if (StrUtil.isBlank((CharSequence)concurrentCheck.getId()) || ObjectUtil.isEmpty((Object)concurrentCheck.getCheckStatus())) {
            throw new Exception("\u5ba1\u6838\u4fe1\u606f\u4e0d\u5168\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        ConcurrentCheck originConcurrentCheck = (ConcurrentCheck)this.getById((Serializable)((Object)concurrentCheck.getId()));
        ConcurrentTask concurrentTask = (ConcurrentTask)this.concurrentTaskService.getById((Serializable)((Object)originConcurrentCheck.getTaskId()));
        originConcurrentCheck.setCheckStatus(concurrentCheck.getCheckStatus());
        originConcurrentCheck.setApprovalOpinion(concurrentCheck.getApprovalOpinion());
        originConcurrentCheck.setCheckDate(new Date());
        if (concurrentTask.getConcurrentMode() == EnumConcurrentTaskMode.Offline.value) {
            if (ObjectUtil.isEmpty((Object)originConcurrentCheck.getConcurrentCount())) {
                originConcurrentCheck.setConcurrentCount(0);
            }
            originConcurrentCheck.setConcurrentCount(originConcurrentCheck.getConcurrentCount() + 1);
            originConcurrentCheck.setConcurrentTime(originConcurrentCheck.getCheckDate());
        }
        this.saveOrUpdate(originConcurrentCheck);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateConcurrentDataById(ConcurrentCheck concurrentCheck) throws Exception {
        boolean flag;
        if (StrUtil.isBlank((CharSequence)concurrentCheck.getId())) {
            throw new Exception("\u6c47\u4ea4\u6570\u636e\u4fe1\u606f\u4e0d\u5168\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        ConcurrentCheck originConcurrentCheck = (ConcurrentCheck)this.getById((Serializable)((Object)concurrentCheck.getId()));
        ConcurrentTask concurrentTask = (ConcurrentTask)this.concurrentTaskService.getById((Serializable)((Object)originConcurrentCheck.getTaskId()));
        boolean bl = flag = EnumConcurrentTaskMode.Online.value == concurrentTask.getConcurrentMode() && StrUtil.isNotBlank((CharSequence)concurrentCheck.getConcurrentDataUrl()) && StrUtil.isNotBlank((CharSequence)concurrentCheck.getConcurrentDataStructureTree()) || EnumConcurrentTaskMode.Offline.value == concurrentTask.getConcurrentMode();
        if (!flag) {
            throw new Exception("\u6c47\u4ea4\u6570\u636e\u4fe1\u606f\u4e0d\u5168\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        originConcurrentCheck.setConcurrentDataUrl(concurrentCheck.getConcurrentDataUrl());
        originConcurrentCheck.setConcurrentDataStructureTree(concurrentCheck.getConcurrentDataStructureTree());
        originConcurrentCheck.setCheckStatus(0);
        if (EnumConcurrentTaskMode.Online.value == concurrentTask.getConcurrentMode()) {
            if (ObjectUtil.isEmpty((Object)originConcurrentCheck.getConcurrentCount())) {
                originConcurrentCheck.setConcurrentCount(0);
            }
            originConcurrentCheck.setConcurrentCount(originConcurrentCheck.getConcurrentCount() + 1);
            originConcurrentCheck.setConcurrentTime(new Date());
        }
        this.saveOrUpdate(originConcurrentCheck);
    }

    @Override
    public void downloadFileById(String id, HttpServletResponse response) throws Exception {
        ConcurrentCheck concurrentCheck = (ConcurrentCheck)this.getById((Serializable)((Object)id));
        if (StrUtil.isBlank((CharSequence)concurrentCheck.getConcurrentDataUrl())) {
            throw new Exception("\u8be5\u6c47\u4ea4\u4efb\u52a1\u672a\u63d0\u4ea4\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
        String[] strings = concurrentCheck.getConcurrentDataUrl().split("@");
        FileDownloadMeta fileDownloadMeta = this.fileServerService.queryDownLoadMeta(concurrentCheck.getConcurrentDataUrl());
        long fileSize = fileDownloadMeta.getFileSize();
        this.fileUploadUtil.downloadInputStream2Browser(response, fileDownloadMeta.getInputStream(), strings[1].substring(strings[1].lastIndexOf("/") + 1), fileSize);
    }

    @Override
    public FileServerResponse uploadFile(MultipartFile multipartFile) throws Exception {
        FileServerResponse fileUploadResponse = this.concurrentTemplatesService.uploadFile(multipartFile);
        if (ObjectUtil.isEmpty((Object)fileUploadResponse.getTreeList())) {
            throw new Exception("\u6c47\u4ea4\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return fileUploadResponse;
    }

    @Override
    public List<FileStructureDTO> compareUploadConcurrentData(String templatesId, FileServerResponse fileUploadResponse) throws Exception {
        List templateFileStructureDTOS;
        List originFileStructureDTOS;
        ConcurrentTemplates concurrentTemplates = (ConcurrentTemplates)this.concurrentTemplatesService.getById((Serializable)((Object)templatesId));
        if (ObjectUtil.isEmpty((Object)concurrentTemplates) || StrUtil.isBlank((CharSequence)concurrentTemplates.getTemplateStructureTree())) {
            this.fileServerService.deleteFile(fileUploadResponse.getPath());
            throw new Exception("\u6587\u4ef6\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        String templateFileStructureJsonString = JSONArray.toJSONString((Object)fileUploadResponse.getTreeList());
        try {
            originFileStructureDTOS = JSONArray.parseArray((String)concurrentTemplates.getTemplateStructureTree(), FileStructureDTO.class);
            templateFileStructureDTOS = JSONArray.parseArray((String)templateFileStructureJsonString, FileStructureDTO.class);
        }
        catch (Exception e) {
            this.fileServerService.deleteFile(fileUploadResponse.getPath());
            throw new Exception("\u6a21\u677f\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (ObjectUtil.isEmpty((Object)originFileStructureDTOS) || ObjectUtil.isEmpty((Object)templateFileStructureDTOS)) {
            this.fileServerService.deleteFile(fileUploadResponse.getPath());
            throw new Exception("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return this.compareListAndList(originFileStructureDTOS, templateFileStructureDTOS);
    }

    @Override
    public Boolean getCompareResult(List<FileStructureDTO> compareTreeList, boolean compareResult) {
        long count = compareTreeList.stream().filter(fileStructureDTO -> fileStructureDTO.getIsExists() == false).count();
        if (count > 0L) {
            return false;
        }
        for (FileStructureDTO fileStructureDTO2 : compareTreeList) {
            if (!ObjectUtil.isNotEmpty((Object)fileStructureDTO2.getChildren()) || fileStructureDTO2.getChildren().isEmpty()) continue;
            this.getCompareResult(fileStructureDTO2.getChildren(), compareResult);
        }
        return compareResult;
    }

    @Override
    public Map<String, Object> concurrentSurvey(ConcurrentCheck concurrentCheck) {
        return ((ConcurrentCheckMapper)this.baseMapper).concurrentSurvey(concurrentCheck);
    }

    @Override
    public List<Map<String, Object>> concurrentSurveyShowBarGraph() {
        List dateList = DateUtils.getWeekDate((int)4);
        for (Map map : dateList) {
            map.putAll(((ConcurrentCheckMapper)this.baseMapper).concurrentSurveyShowBarGraph(Convert.toDate(map.get("begin")), Convert.toDate(map.get("end"))));
        }
        return dateList;
    }

    private List<FileStructureDTO> compareListAndList(List<FileStructureDTO> originList, List<FileStructureDTO> templateList) {
        block11: {
            try {
                if (!ObjectUtil.isNotEmpty(originList) || !ObjectUtil.isNotEmpty(templateList)) break block11;
                for (FileStructureDTO fileStructureDTO : originList) {
                    String fileName = fileStructureDTO.getFileName();
                    List<Integer> regionList = this.getAllIndexInStr(fileName, Arrays.asList("[[", "]]"));
                    List<Integer> dateList = this.getAllIndexInStr(fileName, Arrays.asList("{{", "}}"));
                    List allList = CollectionUtils.collate(dateList, regionList);
                    String allClearFileName = this.clearOriginFileName(fileName, regionList, dateList);
                    List fileStructureDTOS = templateList.stream().filter(file -> fileStructureDTO.getFileType().equals(file.getFileType()) && this.clearStringSpecialSymbol(fileName).length() == file.getFileName().length() && allClearFileName.equals(this.clearUploadFileNameDynamicInfo(file.getFileName(), regionList, dateList, allList))).collect(Collectors.toList());
                    if (fileStructureDTOS.size() == 1) {
                        boolean existsFlag;
                        if (regionList.isEmpty() && dateList.isEmpty()) {
                            existsFlag = fileName.equals(((FileStructureDTO)fileStructureDTOS.get(0)).getFileName());
                            fileStructureDTO.setIsExists(Boolean.valueOf(existsFlag));
                        } else {
                            existsFlag = true;
                            List regions = this.buildList(((FileStructureDTO)fileStructureDTOS.get(0)).getFileName(), regionList, allList).stream().distinct().collect(Collectors.toList());
                            List dates = this.buildList(((FileStructureDTO)fileStructureDTOS.get(0)).getFileName(), dateList, allList).stream().distinct().collect(Collectors.toList());
                            if (!regions.isEmpty()) {
                                List districtList = this.dmDistrictDao.queryDefault();
                                List dmDistrictItems = this.dmDistrictItemDao.selectByCodes(((DmDistrict)districtList.get(0)).getId(), regions);
                                boolean bl = existsFlag = dmDistrictItems.size() == regions.size();
                            }
                            if (existsFlag && !dates.isEmpty()) {
                                try {
                                    for (String s : dates) {
                                        Date parse = DateUtils.parseDate((String)s, (String[])PARSE_PATTERNS);
                                        if (!ObjectUtil.isNull((Object)parse)) continue;
                                        existsFlag = false;
                                        break;
                                    }
                                }
                                catch (Exception e) {
                                    existsFlag = false;
                                }
                            }
                        }
                        fileStructureDTO.setIsExists(Boolean.valueOf(existsFlag));
                        ((FileStructureDTO)fileStructureDTOS.get(0)).setIsExists(Boolean.valueOf(existsFlag));
                        if (!existsFlag || fileStructureDTO.getFileType() != 0 || fileStructureDTO.getChildren().isEmpty() || ((FileStructureDTO)fileStructureDTOS.get(0)).getFileType() != 0 || ((FileStructureDTO)fileStructureDTOS.get(0)).getChildren().isEmpty()) continue;
                        this.compareListAndList(fileStructureDTO.getChildren(), ((FileStructureDTO)fileStructureDTOS.get(0)).getChildren());
                        continue;
                    }
                    fileStructureDTO.setIsExists(Boolean.valueOf(false));
                    ((FileStructureDTO)fileStructureDTOS.get(0)).setIsExists(Boolean.valueOf(false));
                    return originList;
                }
            }
            catch (Exception e) {
                return originList;
            }
        }
        return originList;
    }

    private String clearStringSpecialSymbol(String context) {
        List<String> strings = Arrays.asList("[[", "]]", "{{", "}}");
        for (String string : strings) {
            context = context.replace(string, "");
        }
        return context;
    }

    private List<Integer> getAllIndexInStr(String context, List<String> strings) {
        List<Integer> integerList = new ArrayList<Integer>();
        List<Integer> left = this.getAllSubStrIndexInString(context, strings.get(0));
        List<Integer> right = this.getAllSubStrIndexInString(context, strings.get(1));
        if (!left.isEmpty() && !right.isEmpty() && left.size() == right.size()) {
            integerList.addAll(left);
            integerList.addAll(right);
            integerList = integerList.stream().sorted().collect(Collectors.toList());
        }
        return integerList;
    }

    private List<Integer> getAllSubStrIndexInString(String str, String subStr) {
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        int index = str.indexOf(subStr);
        while (index > -1) {
            integerList.add(index);
            index = str.indexOf(subStr, subStr.length() + index);
        }
        return integerList;
    }

    private String clearOriginFileName(String fileName, List<Integer> regionList, List<Integer> dateList) {
        ArrayList<String> strings = new ArrayList<String>();
        int i = 0;
        while (i + 1 < regionList.size()) {
            strings.add(fileName.substring(regionList.get(i), regionList.get(i + 1) + 2));
            i += 2;
        }
        i = 0;
        while (i + 1 < dateList.size()) {
            strings.add(fileName.substring(dateList.get(i), dateList.get(i + 1) + 2));
            i += 2;
        }
        for (String s : strings) {
            fileName = fileName.replace(s, "");
        }
        return fileName;
    }

    private List<String> buildList(String fileName, List<Integer> specialList, List<Integer> allList) {
        ArrayList<String> strings = new ArrayList<String>();
        int i = 0;
        while (i + 1 < specialList.size()) {
            int index = allList.indexOf(specialList.get(i));
            if (index > -1) {
                strings.add(fileName.substring(specialList.get(i) - index * 2, specialList.get(i + 1) - (index + 1) * 2));
            }
            i += 2;
        }
        return strings;
    }

    private String clearUploadFileNameDynamicInfo(String fileName, List<Integer> regionList, List<Integer> dateList, List<Integer> allList) {
        List<String> strings = this.buildList(fileName, regionList, allList);
        strings.addAll(this.buildList(fileName, dateList, allList));
        for (String s : strings) {
            fileName = fileName.replace(s, "");
        }
        return fileName;
    }
}

