/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.monitor.controller;

import cn.hutool.core.util.StrUtil;
import com.geoway.ns.proxy.entity.ProxyApplication;
import com.geoway.ns.proxy.service.ProxyApplicationService;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.RowsResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e94\u7528\u4ee3\u7406\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/proxyApp"})
public class ProxyAppController {
    private static final Logger log = LoggerFactory.getLogger(ProxyAppController.class);
    @Resource
    ProxyApplicationService proxyApplicationService;

    @ApiOperation(value="\u67e5\u8be2\u4ee3\u7406\u5e94\u7528\u6811")
    @RequestMapping(value={"/listTree"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RowsResponse listTree(HttpServletRequest request, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam) {
        RowsResponse response = new RowsResponse();
        try {
            if (StrUtil.isBlank((CharSequence)sortParam)) {
                sortParam = "SORT_createtime_DESC";
            }
            List appTree = this.proxyApplicationService.queryTreeByFilter(filterParam, sortParam);
            response.setRows(appTree);
            response.setTotal(Long.valueOf(appTree.size()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u4fdd\u5b58\u4ee3\u7406\u5206\u7ec4")
    @PostMapping(value={"/saveGroup"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse saveGroup(HttpServletRequest request, @RequestParam(value="id", required=false, defaultValue="") String id, @RequestParam(value="name") String name) {
        BaseResponse response = new BaseResponse();
        try {
            this.proxyApplicationService.saveGroup(id, "-1", name);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u4fdd\u5b58\u4ee3\u7406\u5e94\u7528")
    @PostMapping(value={"/saveApp"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse addProxyObject(HttpServletRequest request, @ModelAttribute ProxyApplication proxyApplication) {
        BaseResponse response = new BaseResponse();
        try {
            proxyApplication.setType(Integer.valueOf(1));
            this.proxyApplicationService.saveApplication(proxyApplication);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5220\u9664\u4ee3\u7406\u5e94\u7528")
    @PostMapping(value={"/delete"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse batchDelete(HttpServletRequest request, @RequestParam(value="id") String id) {
        BaseResponse response = new BaseResponse();
        try {
            this.proxyApplicationService.deleteOne(id);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }
}

