/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.zyfx.domain.ZyfxCatalogObject;
import com.geoway.ns.zyfx.mapper.ZyfxCatalogObjectMapper;
import com.geoway.ns.zyfx.service.ZyfxCatalogObjectService;
import org.springframework.stereotype.Service;

@Service
public class ZyfxCatalogObjectServiceImpl
extends ServiceImpl<ZyfxCatalogObjectMapper, ZyfxCatalogObject>
implements ZyfxCatalogObjectService {
    @Override
    public void saveIfNotExists(String schemeId, String nodeId, String objectId, String nodeCode, int groupType) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxCatalogObject::getCatalogid, (Object)nodeId);
        queryWrapper.eq(ZyfxCatalogObject::getObjectid, (Object)objectId);
        queryWrapper.eq(ZyfxCatalogObject::getSchemeid, (Object)schemeId);
        if (this.count((Wrapper)queryWrapper) > 0L) {
            return;
        }
        Integer maxOrder = ((ZyfxCatalogObjectMapper)this.getBaseMapper()).queryMaxOrder(nodeId);
        int order = maxOrder == null ? 1 : maxOrder + 1;
        ZyfxCatalogObject zyfxCatalogObject = new ZyfxCatalogObject();
        zyfxCatalogObject.setCatalogid(nodeId);
        zyfxCatalogObject.setObjectid(objectId);
        zyfxCatalogObject.setCatalogcode(nodeCode);
        zyfxCatalogObject.setGrouptype(groupType);
        zyfxCatalogObject.setSchemeid(schemeId);
        zyfxCatalogObject.setSort(order);
        this.save(zyfxCatalogObject);
    }

    @Override
    public void moveByObjectId(String catalogid, String catalogcode, String objectid, String schemeid) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxCatalogObject::getObjectid, (Object)objectid);
        queryWrapper.eq(ZyfxCatalogObject::getSchemeid, (Object)schemeid);
        ZyfxCatalogObject zyfxCatalogObject = (ZyfxCatalogObject)this.getOne((Wrapper)queryWrapper);
        zyfxCatalogObject.setCatalogcode(catalogcode);
        zyfxCatalogObject.setCatalogid(catalogid);
        this.update(zyfxCatalogObject, (Wrapper)queryWrapper);
    }

    @Override
    public void remove(String nodeId, String objectId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxCatalogObject::getCatalogid, (Object)nodeId);
        queryWrapper.eq(ZyfxCatalogObject::getObjectid, (Object)objectId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public void removeByObjectId(String objectId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxCatalogObject::getObjectid, (Object)objectId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public void removeByCatalogId(String catalogId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxCatalogObject::getCatalogid, (Object)catalogId);
        this.remove((Wrapper)queryWrapper);
    }
}

