/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.monitor.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.ns.monitor.service.AuthorizeTokenService;
import com.geoway.ns.proxy.entity.AuthorizeToken;
import com.geoway.ns.sys.dto.DataResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u670d\u52a1\u6388\u6743"})
@RestController
@RequestMapping(value={"/proxy-authorize"})
public class AccessAuthorizeController {
    private final AuthorizeTokenService authorizeTokenService;

    @ApiOperation(value="token\u83b7\u53d6")
    @RequestMapping(value={"/get-token"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse save(@RequestBody AuthorizeToken authorizeToken) {
        DataResponse response = new DataResponse();
        try {
            String s = this.authorizeTokenService.saveOrUpdateAuthorizeToken(authorizeToken);
            response.setResult((Object)s);
        }
        catch (Exception e) {
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58")
    @RequestMapping(value={"/saves"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse saves(String params, HttpServletRequest request) {
        DataResponse response = new DataResponse();
        try {
            this.authorizeTokenService.saveAuthorizeTokenList(params, request);
            response.setResult((Object)"\u6570\u636e\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (Exception e) {
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2")
    @RequestMapping(value={"/list-authorize-filter"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse listAuthorizeFilter(String filterparams, Integer page, Integer size) {
        DataResponse response = new DataResponse();
        try {
            IPage<AuthorizeToken> authorizeTokenIPage = this.authorizeTokenService.listFilter(filterparams, page, size);
            response.setResult(authorizeTokenIPage);
        }
        catch (Exception e) {
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5220\u9664")
    @RequestMapping(value={"/delete-authorize"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse delete(String token, String sid) {
        DataResponse response = new DataResponse();
        try {
            this.authorizeTokenService.removeAuthorizeToken(token, sid);
            response.setResult((Object)"\u6570\u636e\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u7f16\u8f91")
    @RequestMapping(value={"/update-authorize"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse update(AuthorizeToken authorizeToken) {
        DataResponse response = new DataResponse();
        try {
            this.authorizeTokenService.updateAuthorizeToken(authorizeToken);
            response.setResult((Object)"\u6570\u636e\u66f4\u65b0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6839\u636etoken\u67e5\u8be2")
    @RequestMapping(value={"/query-token"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse findToken(String token) {
        DataResponse response = new DataResponse();
        try {
            AuthorizeToken authorizeToken = this.authorizeTokenService.findByToken(token);
            response.setResult((Object)authorizeToken);
        }
        catch (Exception e) {
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5730\u5740\u53d8\u66f4")
    @RequestMapping(value={"/update-url"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse updateProxyUrl(String id, String url) {
        DataResponse response = new DataResponse();
        try {
            this.authorizeTokenService.updateUrl(id, url);
            response.setResult((Object)"\u6570\u636e\u66f4\u65b0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u4e34\u65f6token\u83b7\u53d6")
    @RequestMapping(value={"/get-temporary-token"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse getTemporaryToken(String id, Integer type, String url) {
        DataResponse response = new DataResponse();
        try {
            String temporaryToken = this.authorizeTokenService.getTemporaryToken(id, type, url);
            response.setResult((Object)temporaryToken);
        }
        catch (Exception e) {
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6388\u6743\u72b6\u6001\u66f4\u6539")
    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse updateStatus(String token, Integer status) {
        DataResponse response = new DataResponse();
        try {
            this.authorizeTokenService.updateStatus(token, status);
        }
        catch (Exception e) {
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6839\u636e\u670d\u52a1\u4fe1\u606f\u67e5\u8be2\u6388\u6743\u5bf9\u8c61")
    @RequestMapping(value={"/getAuthorizerByService"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse getAuthorizerByService(String serviceName, String serviceId, Integer serviceType, Integer authorizeType) {
        DataResponse response = new DataResponse();
        try {
            response.setResult((Object)this.authorizeTokenService.getAuthorizerByService(serviceName, serviceId, serviceType, authorizeType));
        }
        catch (Exception e) {
            response.markFailure(e.getMessage());
        }
        return response;
    }

    public AccessAuthorizeController(AuthorizeTokenService authorizeTokenService) {
        this.authorizeTokenService = authorizeTokenService;
    }
}

