/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl;

import cn.afterturn.easypoi.word.WordExportUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.service.DictionaryService;
import com.geoway.adf.dms.config.service.SysParamsService;
import com.geoway.ns.sys.dto.FileServerResponse;
import com.geoway.ns.sys.dto.SimpleRole;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.enums.SysParamGroupEnum;
import com.geoway.ns.sys.service.FileServerService;
import com.geoway.ns.sys.service.RedisLockService;
import com.geoway.ns.sys.service.impl.TokenServiceImpl;
import com.geoway.ns.sys.utils.UpAndDownloadUtil;
import com.geoway.ns.zyfx.domain.DataDelivery;
import com.geoway.ns.zyfx.domain.DataDeliveryFile;
import com.geoway.ns.zyfx.domain.DataDeliveryItem;
import com.geoway.ns.zyfx.dto.ChartPieDTO;
import com.geoway.ns.zyfx.dto.DeliveryNumberDTO;
import com.geoway.ns.zyfx.dto.RestServiceDeliveryQueryParams;
import com.geoway.ns.zyfx.dto.ShareExDeliveryDTO;
import com.geoway.ns.zyfx.dto.ShareExDeliveryParams;
import com.geoway.ns.zyfx.dto.ShareExLineChartDTO;
import com.geoway.ns.zyfx.mapper.DataDeliveryFileMapper;
import com.geoway.ns.zyfx.mapper.DataDeliveryItemMapper;
import com.geoway.ns.zyfx.mapper.DataDeliveryMapper;
import com.geoway.ns.zyfx.service.DataDeliveryService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ResourceUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DataDeliveryServiceImpl
extends ServiceImpl<DataDeliveryMapper, DataDelivery>
implements DataDeliveryService {
    @Value(value="${project.workDir:''}")
    protected String tempDir;
    @Autowired
    DataDeliveryItemMapper dataDeliveryItemMapper;
    @Autowired
    DataDeliveryMapper dataDeliveryMapper;
    @Autowired
    DataDeliveryFileMapper dataDeliveryFileMapper;
    private static SysParamsService sysParamsService = (SysParamsService)SpringContextUtil.getBean(SysParamsService.class);
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    TokenServiceImpl tokenService;
    @Autowired
    RedisLockService redisLockService;
    @Resource
    private FileServerService fileServerService;
    @Autowired
    private DictionaryService dictionaryService;

    public boolean userHasRoles(List<String> roleNames, SysUserDTO user) {
        Set userRoleNames = user.getRoles().stream().map(SimpleRole::getRolename).collect(Collectors.toSet());
        return userRoleNames.containsAll(roleNames);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Map<String, String>> addDataDeliveryInfo(SysUserDTO user, String code, DataDelivery dataDelivery, MultipartFile[] files, JSONArray fileInfos, List<DataDeliveryItem> dataDeliveryItems) throws Exception {
        String uuid2;
        String uuid = UUID.randomUUID().toString();
        dataDelivery.setId(uuid);
        dataDelivery.setHasRead(0);
        dataDelivery.setCreateUser(user.getId());
        dataDelivery.setCreateTime(new Date());
        dataDelivery.setUpdateTime(new Date());
        dataDelivery.setStatus(0);
        if (dataDelivery.getTime() == null) {
            dataDelivery.setTime(new Date());
        }
        this.dataDeliveryMapper.insert(dataDelivery);
        String formId = dataDelivery.getId();
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (dataDelivery.getType() == 1) {
            if (files != null && files.length > 0) {
                for (MultipartFile file : files) {
                    File tempFile = new File(file.getOriginalFilename());
                    FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)tempFile);
                    FileServerResponse fileServerResponse = this.fileServerService.sendObject2OssByMultiPart(tempFile, null);
                    long size = file.getSize();
                    long partSize = 0x3200000L;
                    long partCount = size % partSize == 0L ? size / partSize : size / partSize + 1L;
                    DataDeliveryFile dataDeliveryFile = this.createDataDeliveryFile(fileServerResponse.getUploadId(), formId, file.getOriginalFilename(), size, file.getContentType(), fileServerResponse.getViewURL(), user.getId(), partCount, null);
                    this.dataDeliveryFileMapper.insert(dataDeliveryFile);
                }
            } else if (fileInfos != null && fileInfos.size() > 0) {
                for (Object fileInfo : fileInfos) {
                    JSONObject jsonObject = (JSONObject)fileInfo;
                    uuid2 = UUID.randomUUID().toString();
                    Long filesize = jsonObject.getLong("dataSize");
                    DataDeliveryFile dataDeliveryFile = this.createDataDeliveryFile(uuid2, formId, jsonObject.getString("originalFilename"), filesize, jsonObject.getString("contentType"), jsonObject.getString("relativePath"), user.getId(), 0L, jsonObject.getString("fileurl"));
                    this.dataDeliveryFileMapper.insert(dataDeliveryFile);
                }
            }
        }
        Double dataSizeTotal = 0.0;
        if (dataDeliveryItems != null && dataDeliveryItems.size() > 0) {
            for (DataDeliveryItem item : dataDeliveryItems) {
                uuid2 = UUID.randomUUID().toString();
                List<String> unitLists = Arrays.asList("B", "KB", "MB", "GB", "TB");
                Integer index = unitLists.indexOf(item.getQuantityUnit());
                Double val = item.getQuantity() * Math.pow(1024.0, index.intValue());
                String dataSize = new DecimalFormat("#,##0.#####").format(val / Math.pow(1024.0, 3.0));
                Double _dataSize = Double.parseDouble(dataSize);
                dataSizeTotal = dataSizeTotal + _dataSize;
                item.setDataSize(Double.parseDouble(dataSize));
                item.setId(uuid2);
                item.setFormId(formId);
                item.setNumber(dataDelivery.getNumber());
                this.dataDeliveryItemMapper.insert(item);
            }
        }
        dataDelivery.setDataSize(dataSizeTotal);
        this.dataDeliveryMapper.updateById(dataDelivery);
        return list;
    }

    private DataDeliveryFile createDataDeliveryFile(String id, String formId, String originalFilename, Long size, String contentType, String fileUrl, String userid, long partCount, String downUrl) {
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size.longValue()) / Math.log10(1024.0));
        String dataSize = new DecimalFormat("#,##0.#").format((double)size.longValue() / Math.pow(1024.0, digitGroups)) + units[digitGroups];
        DataDeliveryFile dataDeliveryFile = new DataDeliveryFile();
        dataDeliveryFile.setId(id);
        dataDeliveryFile.setFormId(formId);
        dataDeliveryFile.setName(originalFilename);
        dataDeliveryFile.setSize(dataSize);
        dataDeliveryFile.setStyle(contentType);
        dataDeliveryFile.setPath(fileUrl);
        dataDeliveryFile.setCreateUser(userid);
        dataDeliveryFile.setCreateTime(new Date());
        dataDeliveryFile.setPartCount(partCount);
        dataDeliveryFile.setDownloadUrl(downUrl);
        return dataDeliveryFile;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Map<String, String>> updateDataDeliveryInfo(SysUserDTO user, String code, DataDelivery dataDeliverie, MultipartFile[] files) throws Exception {
        if (!StringUtils.equals((CharSequence)user.getId(), (CharSequence)dataDeliverie.getCreateUser()) && !this.userHasRoles(Arrays.asList("\u7ba1\u7406\u5458", "\u8d85\u7ea7\u7ba1\u7406\u5458"), user)) {
            throw new RuntimeException("\u60a8\u6ca1\u6709\u7f16\u8f91\u6c47\u4ea4\u8bb0\u5f55\u7684\u6743\u9650");
        }
        DataDelivery dataDelivery = (DataDelivery)this.dataDeliveryMapper.selectById((Serializable)((Object)dataDeliverie.getId()));
        BeanUtils.copyProperties((Object)dataDeliverie, (Object)dataDelivery);
        dataDeliverie.setUpdateTime(new Date());
        this.dataDeliveryMapper.updateById(dataDelivery);
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (dataDelivery.getType() == 1 && files != null) {
            for (MultipartFile file : files) {
                File tempFile = new File(file.getOriginalFilename());
                FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)tempFile);
                FileServerResponse fileServerResponse = this.fileServerService.sendObject2OssByMultiPart(tempFile, null);
                String formId = dataDelivery.getId();
                DataDeliveryFile dataDeliveryFile = new DataDeliveryFile();
                dataDeliveryFile.setFormId(formId);
                dataDeliveryFile.setName(file.getOriginalFilename());
                long size = file.getSize();
                String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
                int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
                String dataSize = new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + units[digitGroups];
                dataDeliveryFile.setSize(dataSize);
                dataDeliveryFile.setStyle(file.getContentType());
                dataDeliveryFile.setPath(fileServerResponse.getPath());
                dataDeliveryFile.setCreateUser(user.getId());
                dataDeliveryFile.setCreateTime(new Date());
                long partSize = 0x3200000L;
                long partCount = size % partSize == 0L ? size / partSize : size / partSize + 1L;
                dataDeliveryFile.setPartCount(partCount);
                this.dataDeliveryFileMapper.insert(dataDeliveryFile);
            }
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int addDataDeliveryInfoBatch(SysUserDTO user, String code, List<DataDelivery> dataDeliveries) throws Exception {
        if (!dataDeliveries.stream().allMatch(e -> StringUtils.isNotBlank((CharSequence)e.getNumber()))) {
            throw new RuntimeException("\u90e8\u5206\u5206\u53d1\u5355\u7f16\u53f7\u4e3a\u7a7a");
        }
        int result = 0;
        for (DataDelivery dataDelivery : dataDeliveries) {
            String uuid = UUID.randomUUID().toString();
            dataDelivery.setId(uuid);
            dataDelivery.setHasRead(0);
            dataDelivery.setCreateUser(user.getId());
            dataDelivery.setCreateTime(new Date());
            dataDelivery.setUpdateTime(new Date());
            dataDelivery.setStatus(0);
            result += this.dataDeliveryMapper.insert(dataDelivery);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int updateDataDeliveryInfoBatch(SysUserDTO user, DataDelivery dataDeliverie) throws Exception {
        if (!StringUtils.equals((CharSequence)user.getId(), (CharSequence)dataDeliverie.getCreateUser()) && !this.userHasRoles(Arrays.asList("\u7ba1\u7406\u5458", "\u8d85\u7ea7\u7ba1\u7406\u5458"), user)) {
            throw new RuntimeException("\u60a8\u6ca1\u6709\u7f16\u8f91\u6c47\u4ea4\u8bb0\u5f55\u7684\u6743\u9650");
        }
        if (StringUtils.isBlank((CharSequence)dataDeliverie.getNumber())) {
            throw new RuntimeException("\u90e8\u5206\u5206\u53d1\u5355\u7f16\u53f7\u4e3a\u7a7a");
        }
        DataDelivery dataDelivery = (DataDelivery)this.dataDeliveryMapper.selectById((Serializable)((Object)dataDeliverie.getId()));
        BeanUtils.copyProperties((Object)dataDeliverie, (Object)dataDelivery);
        dataDeliverie.setUpdateTime(new Date());
        return this.dataDeliveryMapper.updateById(dataDelivery);
    }

    @Override
    public IPage<DataDelivery> searchPage(RestServiceDeliveryQueryParams params, SysUserDTO user) {
        Page dataServicePage = new Page((long)params.getPage().intValue(), (long)params.getSize().intValue());
        IPage<DataDelivery> result = this.dataDeliveryMapper.searchPage((Page<DataDelivery>)dataServicePage, params);
        return this.convertTo(result);
    }

    private void hideSavePath(List<DataDelivery> dataDeliveries, String functionKey, SysUserDTO user) {
        boolean hide = true;
        List roles = user.getRoles().stream().map(SimpleRole::getId).collect(Collectors.toList());
        Stream<String> roleNames = user.getRoles().stream().map(SimpleRole::getRolename);
        if (roleNames.anyMatch(e -> e.equals("\u7ba1\u7406\u5458") || e.equals("\u8d85\u7ea7\u7ba1\u7406\u5458"))) {
            hide = false;
        }
        ArrayList<DataDelivery> tempDataDeliveryList = new ArrayList<DataDelivery>();
        for (DataDelivery dataDelivery : dataDeliveries) {
            if (user.getId().equals(dataDelivery.getCreateUser())) {
                hide = false;
            } else {
                tempDataDeliveryList.add(dataDelivery);
            }
            if (!hide) continue;
            dataDelivery.setSavePath("******");
        }
    }

    @Override
    public Map<String, Object> queryShareExDeliveryStatic(Integer year) {
        HashMap<String, Object> staticMap = new HashMap<String, Object>();
        double totalCount = this.dataDeliveryMapper.queryDeliveryCount(year) == null ? 0.0 : this.dataDeliveryMapper.queryDeliveryCount(year);
        totalCount = Double.parseDouble(String.format("%.2f", totalCount / 1024.0));
        Integer unitCount = this.dataDeliveryMapper.queryDeliveryUnitCount(year);
        Integer deliveryNum = this.dataDeliveryMapper.queryDeliveryNum(year);
        Integer todayCount = this.dataDeliveryMapper.queryDeliveryNumByToday();
        Integer projectCount = this.dataDeliveryMapper.queryDeliveryProjectCount(year);
        staticMap.put("totalCount", totalCount);
        staticMap.put("unitCount", unitCount);
        staticMap.put("deliveryCount", deliveryNum);
        staticMap.put("todayCount", todayCount);
        staticMap.put("projectCount", projectCount);
        return staticMap;
    }

    @Override
    public List<ChartPieDTO> queryShareExDeliveryChartData(String groupBy, Integer year) {
        List<ChartPieDTO> deliveryChartData;
        double sum;
        double totalCount = this.dataDeliveryMapper.queryDeliveryCount(year) == null ? 0.0 : this.dataDeliveryMapper.queryDeliveryCount(year);
        if (totalCount - (sum = (deliveryChartData = this.dataDeliveryMapper.queryShareExDeliveryChartData(groupBy, year)).stream().reduce(0.0, (s, cur) -> s + cur.getCount(), Double::sum).doubleValue()) > 0.01) {
            deliveryChartData.add(new ChartPieDTO("\u5176\u4ed6", totalCount - sum));
        }
        return deliveryChartData;
    }

    @Override
    public IPage<ShareExDeliveryDTO> queryShareExDeliveryTableData(ShareExDeliveryParams params) {
        Page shareExDeliveryDTOPage = new Page((long)params.getPage().intValue(), (long)params.getRows().intValue());
        IPage<ShareExDeliveryDTO> deliveryTableData = this.dataDeliveryMapper.queryShareExDeliveryTableData((Page<ShareExDeliveryDTO>)shareExDeliveryDTOPage, params);
        return deliveryTableData;
    }

    @Override
    public List<ShareExLineChartDTO> queryShareExDeliveryLineChartData(Integer year) {
        return this.dataDeliveryMapper.queryShareExDeliveryLineChartData(year);
    }

    @Override
    public DataDelivery queryShareExDeliveryInfoDetails(String id, SysUserDTO user) {
        DataDelivery dataDelivery = this.dataDeliveryMapper.queryShareExDeliveryInfoDetails(id);
        List<DataDeliveryFile> deliveryFiles = this.dataDeliveryMapper.queryShareExDeliveryFiles(id);
        dataDelivery.setDataDeliveryFiles(deliveryFiles);
        List<DataDeliveryItem> deliveryItems = this.dataDeliveryItemMapper.getDataByFormId(id);
        dataDelivery.setDataDeliveryItems(deliveryItems);
        return dataDelivery;
    }

    private IPage<DataDelivery> convertTo(IPage<DataDelivery> srcPage) {
        Page tarPage = new Page();
        tarPage.setPages(srcPage.getPages());
        tarPage.setCurrent(srcPage.getCurrent());
        tarPage.setSize(srcPage.getSize());
        tarPage.setTotal(srcPage.getTotal());
        tarPage.setRecords(this.convertTo(srcPage.getRecords()));
        return tarPage;
    }

    private List<DataDelivery> convertTo(List<DataDelivery> srcLst) {
        ArrayList<DataDelivery> result = new ArrayList<DataDelivery>();
        for (DataDelivery dataDelivery : srcLst) {
            result.add(this.convertTo(dataDelivery));
        }
        return result;
    }

    private DataDelivery convertTo(DataDelivery dataDelivery) {
        List<DataDeliveryFile> dataDeliveryFiles = this.dataDeliveryFileMapper.getDataByFormId(dataDelivery.getId());
        Integer index = 1;
        for (DataDeliveryFile dataDeliveryFile : dataDeliveryFiles) {
            String ratio = "100";
            dataDeliveryFile.setRatio(ratio);
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
            dataDeliveryFile.setIndex(n);
        }
        List<DataDeliveryItem> deliveryItems = this.dataDeliveryItemMapper.getDataByFormId(dataDelivery.getId());
        for (int i = 0; i < deliveryItems.size(); ++i) {
            deliveryItems.get(i).setIndex(i + 1);
        }
        dataDelivery.setDataDeliveryItems(deliveryItems);
        dataDelivery.setDataDeliveryFiles(dataDeliveryFiles);
        return dataDelivery;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setHasReadById(String id, Integer hasRead) {
        DataDelivery dataDelivery = (DataDelivery)this.dataDeliveryMapper.selectById((Serializable)((Object)id));
        dataDelivery.setHasRead(hasRead);
        this.dataDeliveryMapper.updateById(dataDelivery);
    }

    @Override
    public int deleteById(SysUserDTO user, String id) {
        String[] split = id.split(",");
        List dataDeliveries = this.dataDeliveryMapper.selectBatchIds(Arrays.asList(split));
        boolean isAdmin = this.userHasRoles(Arrays.asList("\u7ba1\u7406\u5458", "\u8d85\u7ea7\u7ba1\u7406\u5458"), user);
        for (DataDelivery dataDelivery : dataDeliveries) {
            if (isAdmin || StringUtils.equals((CharSequence)user.getId(), (CharSequence)dataDelivery.getCreateUser())) continue;
            throw new RuntimeException("\u60a8\u65e0\u6cd5\u5220\u9664\u4e0d\u662f\u7531\u60a8\u53d1\u8d77\u7684\u6c47\u4ea4\u8bb0\u5f55");
        }
        return this.dataDeliveryMapper.deleteBatchIds(Arrays.asList(split));
    }

    @Override
    public DataDelivery saveOne(SysUserDTO user, DataDelivery dataDelivery) {
        this.saveOrUpdate(dataDelivery);
        return dataDelivery;
    }

    @Override
    public List<DeliveryNumberDTO> getDeliveryNumber(Set<Integer> years) {
        return this.dataDeliveryMapper.getDeliveryNumber(years);
    }

    @Override
    public Integer[] queryDeliveryYears() {
        return this.dataDeliveryMapper.queryDeliveryYears();
    }

    @Override
    public String generateDeliveryCertificate(String id) {
        DataDelivery dataDelivery = (DataDelivery)this.dataDeliveryMapper.selectById((Serializable)((Object)id));
        if (dataDelivery == null) {
            throw new RuntimeException("\u6c47\u4ea4\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        dataDelivery = this.convertTo(dataDelivery);
        return this.generateDeliveryCertificate(dataDelivery);
    }

    @Override
    public String generateDeliveryCertificate(DataDelivery dataDelivery) {
        File parentDir;
        String url = "templates/submissionVoucher.docx";
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        String fileName = dataDelivery.getNumber() + "\u6c47\u4ea4\u51ed\u8bc1-" + format.format(new Date()) + ".docx";
        String pdfFileName = dataDelivery.getNumber() + "\u6c47\u4ea4\u51ed\u8bc1-" + format.format(new Date()) + ".pdf";
        String tmpPath = this.tempDir + File.separator + "temp" + File.separator + "submissionVoucher" + File.separator + fileName;
        String pdfTmpPath = this.tempDir + File.separator + "temp" + File.separator + "submissionVoucher" + File.separator + pdfFileName;
        File wordFile = new File(tmpPath);
        File pdfFile = new File(pdfTmpPath);
        if (!wordFile.exists() && !(parentDir = new File(wordFile.getParent())).exists()) {
            parentDir.mkdirs();
        }
        if (!pdfFile.exists() && !(parentDir = new File(pdfFile.getParent())).exists()) {
            parentDir.mkdirs();
        }
        try {
            while (dataDelivery.getDataDeliveryItems().size() < 4) {
                dataDelivery.getDataDeliveryItems().add(new DataDeliveryItem());
            }
            while (dataDelivery.getDataDeliveryFiles().size() < 4) {
                dataDelivery.getDataDeliveryFiles().add(new DataDeliveryFile());
            }
            Map params = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataDelivery), Map.class);
            params.put("year", LocalDate.now().getYear());
            params.put("month", LocalDate.now().getMonthValue());
            params.put("day", LocalDate.now().getDayOfMonth());
            SysUserDTO sysUser = this.tokenService.queryCurrentSysUser();
            params.put("userName", sysUser.getAlisname());
            params.put("userTel", sysUser.getTel());
            params.put("userUnit", sysUser.getDeptName());
            XWPFDocument doc = WordExportUtil.exportWord07((String)url, (Map)params);
            FileOutputStream fileOutputStream = FileUtils.openOutputStream((File)wordFile);
            doc.write((OutputStream)fileOutputStream);
            doc.close();
            String inputfilepath = tmpPath;
            HttpRequest httpRequest = HttpRequest.post((String)(DataDeliveryServiceImpl.getDocumentURL() + "/convert/docxToPdf"));
            HashMap<String, File> formData = new HashMap<String, File>();
            formData.put("docxFile", wordFile);
            httpRequest.form(formData);
            HttpResponse httpResponse = httpRequest.execute();
            if (!httpResponse.isOk()) {
                throw new RuntimeException(httpResponse.body());
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(httpResponse.bodyBytes());
            MockMultipartFile multipartFile = new MockMultipartFile("docxFile", pdfFileName, "application/octet-stream", (InputStream)inputStream);
            FileServerResponse fileServerResponse = this.fileServerService.sendFileToServer((MultipartFile)multipartFile, "", false);
            dataDelivery.setHjcertificate(fileServerResponse.getViewURL());
            this.dataDeliveryMapper.updateById(dataDelivery);
            FileUtils.deleteQuietly((File)new File(pdfTmpPath));
            FileUtils.deleteQuietly((File)new File(inputfilepath));
        }
        catch (Exception e) {
            System.out.println("\u5bfc\u51faWord\u6587\u6863\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return e.getMessage();
        }
        return dataDelivery.getHjcertificate();
    }

    private static String getDocumentURL() {
        SysParamDTO api = sysParamsService.getDetail(SysParamGroupEnum.API.value, SysParamGroupEnum.API_DOCUMENT_URL.value);
        return api.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void excelExport(HttpServletResponse response, RestServiceDeliveryQueryParams params) throws Exception {
        String curProjectPath = System.getProperty("user.dir");
        String tempDirPath = curProjectPath + File.separator + UUID.randomUUID().toString();
        File tempDirFile = new File(tempDirPath);
        tempDirFile.mkdir();
        try {
            String templateFilePath = tempDirPath + File.separator + "hjqd.xlsx";
            this.copyTemplateFile(templateFilePath);
            this.exportResult(params, templateFilePath);
            UpAndDownloadUtil.downloadFile((HttpServletResponse)response, (String)templateFilePath);
        }
        finally {
            FileUtils.deleteQuietly((File)tempDirFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTemplateFile(String templateFilePath) throws Exception {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            String curProjectPath = System.getProperty("user.dir");
            String templatePath = curProjectPath + File.separator + "data/hjqd.xlsx";
            File templateFile = new File(templatePath);
            inputStream = templateFile.exists() && templateFile.isFile() ? new FileInputStream(templateFile) : ResourceUtils.getURL((String)"classpath:data/hjqd.xlsx").openStream();
            File file = new File(templateFilePath);
            outputStream = new FileOutputStream(file);
            byte[] byteStr = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(byteStr)) > 0) {
                outputStream.write(byteStr, 0, len);
            }
            outputStream.flush();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportResult(RestServiceDeliveryQueryParams params, String templateFile) throws Exception {
        XSSFWorkbook wb = null;
        FileOutputStream out = null;
        FileInputStream fileInputStream = null;
        try {
            File destFile = new File(templateFile);
            fileInputStream = new FileInputStream(destFile);
            wb = new XSSFWorkbook((InputStream)fileInputStream);
            Integer pageSize = 100;
            Integer pageIndex = 1;
            Page dataServicePage = new Page(1L, (long)pageSize.intValue());
            Page result = this.dataDeliveryMapper.searchPage((Page<DataDelivery>)dataServicePage, params);
            Integer rowNum = 3;
            Integer xhNumOffset = 2;
            while (result.getSize() > 0L) {
                rowNum = this.appendDataToSheet(wb, result.getRecords(), rowNum, xhNumOffset);
                Integer n = pageIndex;
                Integer n2 = pageIndex = Integer.valueOf(pageIndex + 1);
                if ((long)pageIndex.intValue() <= result.getPages()) {
                    result = this.dataDeliveryMapper.searchPage((Page<DataDelivery>)dataServicePage, params);
                    continue;
                }
                result = new Page(0L, 0L, result.getTotal());
            }
            out = new FileOutputStream(destFile);
            wb.write((OutputStream)out);
            out.flush();
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private <K, V> Map<K, V> filterByValue(Map<K, V> map, Predicate<V> predicate) {
        return map.entrySet().stream().filter(x -> predicate.test(x.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Integer appendDataToSheet(XSSFWorkbook wb, List<DataDelivery> dataDeliveries, Integer rowNum, Integer xhNumOffset) {
        String sheet = "Sheet1";
        XSSFSheet workSheet = wb.getSheet(sheet);
        if (workSheet == null) {
            workSheet = wb.getSheetAt(0);
        }
        for (DataDelivery dataDelivery : dataDeliveries) {
            rowNum = this.createRow(wb, workSheet, rowNum, dataDelivery, xhNumOffset);
        }
        return rowNum;
    }

    private Integer createRow(XSSFWorkbook wb, XSSFSheet workSheet, int rowIndex, DataDelivery dataDelivery, int xhNumOffset) {
        XSSFCellStyle defaultStyle = this.createCellStyle(wb);
        if (dataDelivery.getDataDeliveryItems() != null && dataDelivery.getDataDeliveryItems().size() > 0) {
            Integer index = 0;
            for (DataDeliveryItem dataDeliveryItem : dataDelivery.getDataDeliveryItems()) {
                XSSFRow rowi = workSheet.createRow(rowIndex);
                this.createPrimaryRow(rowi, dataDelivery, rowIndex - xhNumOffset, defaultStyle);
                XSSFCell cell14 = rowi.createCell(14);
                cell14.setCellValue(dataDelivery.getDataDeliveryItems().get(index).getDataName());
                cell14.setCellStyle((CellStyle)defaultStyle);
                XSSFCell cell15 = rowi.createCell(15);
                if (StringUtils.isEmpty((CharSequence)dataDelivery.getDataDeliveryItems().get(index).getDataType())) {
                    cell15.setCellValue("");
                } else {
                    DmDictValueDTO dmDictValueDTO = this.dictionaryService.getDictionaryTree("ZYFX_SJGS_DIC");
                    cell15.setCellValue(this.getDictValueLabel(dmDictValueDTO, dataDelivery.getDataDeliveryItems().get(index).getDataType()));
                }
                cell15.setCellStyle((CellStyle)defaultStyle);
                XSSFCell cell16 = rowi.createCell(16);
                cell16.setCellValue(dataDelivery.getDataDeliveryItems().get(index).getGs());
                cell16.setCellStyle((CellStyle)defaultStyle);
                XSSFCell cell17 = rowi.createCell(17);
                cell17.setCellValue(dataDelivery.getDataDeliveryItems().get(index).getRemark());
                cell17.setCellStyle((CellStyle)defaultStyle);
                XSSFCell cell18 = rowi.createCell(18);
                if (dataDelivery.getDataDeliveryItems().get(index).getFgfw() == null) {
                    cell18.setCellValue("");
                } else {
                    DmDictValueDTO dmDictValueDTO = this.dictionaryService.getDictionaryTree("ZYFX_FGFW_DIC");
                    cell18.setCellValue(this.getDictValueLabel(dmDictValueDTO, dataDelivery.getDataDeliveryItems().get(index).getFgfw() + ""));
                }
                cell18.setCellStyle((CellStyle)defaultStyle);
                XSSFCell cell19 = rowi.createCell(19);
                cell19.setCellValue(dataDelivery.getDataDeliveryItems().get(index).getDataSize().doubleValue());
                cell19.setCellStyle((CellStyle)defaultStyle);
                XSSFCell cell20 = rowi.createCell(20);
                cell20.setCellValue(dataDelivery.getDataDeliveryItems().get(index).getSjfwks() + "\u81f3" + dataDelivery.getDataDeliveryItems().get(index).getSjfwjs());
                cell20.setCellStyle((CellStyle)defaultStyle);
                XSSFCell cell21 = rowi.createCell(21);
                if (dataDelivery.getDataDeliveryItems().get(index).getGxpc() == null) {
                    cell21.setCellValue("");
                } else {
                    DmDictValueDTO dmDictValueDTO = this.dictionaryService.getDictionaryTree("ZYFX_GXPC_DIC");
                    cell21.setCellValue(this.getDictValueLabel(dmDictValueDTO, dataDelivery.getDataDeliveryItems().get(index).getGxpc() + ""));
                }
                cell21.setCellStyle((CellStyle)defaultStyle);
                XSSFCell cell22 = rowi.createCell(22);
                cell22.setCellValue(dataDelivery.getDataDeliveryItems().get(index).getDataStage());
                cell22.setCellStyle((CellStyle)defaultStyle);
                XSSFCell cell23 = rowi.createCell(23);
                cell23.setCellValue(dataDelivery.getDataDeliveryItems().get(index).getCjsb());
                cell23.setCellStyle((CellStyle)defaultStyle);
                XSSFCell cell24 = rowi.createCell(24);
                cell24.setCellValue(dataDelivery.getDataDeliveryItems().get(index).getAqjb());
                cell24.setCellStyle((CellStyle)defaultStyle);
                XSSFCell cell25 = rowi.createCell(25);
                if (dataDelivery.getDataDeliveryItems().get(index).getSrs() == null) {
                    cell25.setCellValue("");
                } else {
                    DmDictValueDTO dmDictValueDTO = this.dictionaryService.getDictionaryTree("DIC_SRID");
                    cell25.setCellValue(this.getDictValueLabel(dmDictValueDTO, dataDelivery.getDataDeliveryItems().get(index).getSrs()));
                }
                cell25.setCellStyle((CellStyle)defaultStyle);
                XSSFCell cell26 = rowi.createCell(26);
                cell26.setCellValue(dataDelivery.getDataDeliveryItems().get(index).getKjfbl());
                cell26.setCellStyle((CellStyle)defaultStyle);
                XSSFCell cell27 = rowi.createCell(27);
                cell27.setCellValue(dataDelivery.getDataDeliveryItems().get(index).getGcjz());
                cell27.setCellStyle((CellStyle)defaultStyle);
                XSSFCell cell28 = rowi.createCell(28);
                cell28.setCellValue(dataDelivery.getDataDeliveryItems().get(index).getPrj());
                cell28.setCellStyle((CellStyle)defaultStyle);
                ++rowIndex;
            }
        } else {
            XSSFRow rowi = workSheet.createRow(rowIndex);
            this.createPrimaryRow(rowi, dataDelivery, rowIndex - xhNumOffset, defaultStyle);
            XSSFCell cell14 = rowi.createCell(14);
            cell14.setCellValue("");
            cell14.setCellStyle((CellStyle)defaultStyle);
            XSSFCell cell15 = rowi.createCell(15);
            cell15.setCellValue("");
            cell15.setCellStyle((CellStyle)defaultStyle);
            XSSFCell cell16 = rowi.createCell(16);
            cell16.setCellValue("");
            cell16.setCellStyle((CellStyle)defaultStyle);
            XSSFCell cell17 = rowi.createCell(17);
            cell17.setCellValue("");
            cell17.setCellStyle((CellStyle)defaultStyle);
            XSSFCell cell18 = rowi.createCell(18);
            cell18.setCellValue("");
            cell18.setCellStyle((CellStyle)defaultStyle);
            XSSFCell cell19 = rowi.createCell(19);
            cell19.setCellValue("");
            cell19.setCellStyle((CellStyle)defaultStyle);
            XSSFCell cell20 = rowi.createCell(20);
            cell20.setCellValue("");
            cell20.setCellStyle((CellStyle)defaultStyle);
            XSSFCell cell21 = rowi.createCell(21);
            cell21.setCellValue("");
            cell21.setCellStyle((CellStyle)defaultStyle);
            XSSFCell cell22 = rowi.createCell(22);
            cell22.setCellValue("");
            cell22.setCellStyle((CellStyle)defaultStyle);
            XSSFCell cell23 = rowi.createCell(23);
            cell23.setCellValue("");
            cell23.setCellStyle((CellStyle)defaultStyle);
            XSSFCell cell24 = rowi.createCell(24);
            cell24.setCellValue("");
            cell24.setCellStyle((CellStyle)defaultStyle);
            XSSFCell cell25 = rowi.createCell(25);
            cell25.setCellValue("");
            cell25.setCellStyle((CellStyle)defaultStyle);
            XSSFCell cell26 = rowi.createCell(26);
            cell26.setCellValue("");
            cell26.setCellStyle((CellStyle)defaultStyle);
            XSSFCell cell27 = rowi.createCell(27);
            cell27.setCellValue("");
            cell27.setCellStyle((CellStyle)defaultStyle);
            XSSFCell cell28 = rowi.createCell(28);
            cell28.setCellValue("");
            cell28.setCellStyle((CellStyle)defaultStyle);
            ++rowIndex;
        }
        return rowIndex;
    }

    private void createPrimaryRow(XSSFRow rowi, DataDelivery dataDelivery, int xhNum, XSSFCellStyle defaultStyle) {
        XSSFCell cell0 = rowi.createCell(0);
        cell0.setCellValue((double)xhNum);
        cell0.setCellStyle((CellStyle)defaultStyle);
        XSSFCell cell1 = rowi.createCell(1);
        cell1.setCellValue(this.NoNullString(dataDelivery.getNumber()));
        cell1.setCellStyle((CellStyle)defaultStyle);
        XSSFCell cell2 = rowi.createCell(2);
        cell2.setCellValue(this.NoNullString(dataDelivery.getLylx()));
        cell2.setCellStyle((CellStyle)defaultStyle);
        XSSFCell cell3 = rowi.createCell(3);
        cell3.setCellValue(this.NoNullString(dataDelivery.getOffice()));
        cell3.setCellStyle((CellStyle)defaultStyle);
        XSSFCell cell4 = rowi.createCell(4);
        cell4.setCellValue(this.NoNullString(dataDelivery.getUnit()));
        cell4.setCellStyle((CellStyle)defaultStyle);
        XSSFCell cell5 = rowi.createCell(5);
        cell5.setCellValue(this.NoNullString(dataDelivery.getUnitType()));
        cell5.setCellStyle((CellStyle)defaultStyle);
        XSSFCell cell6 = rowi.createCell(6);
        cell6.setCellValue(this.NoNullString(dataDelivery.getPerson()));
        cell6.setCellStyle((CellStyle)defaultStyle);
        XSSFCell cell7 = rowi.createCell(7);
        cell7.setCellValue(this.NoNullString(dataDelivery.getPhone()));
        cell7.setCellStyle((CellStyle)defaultStyle);
        XSSFCell cell8 = rowi.createCell(8);
        if (dataDelivery.getHjfs() == null) {
            cell8.setCellValue("");
        } else {
            DmDictValueDTO dmDictValueDTO = this.dictionaryService.getDictionaryTree("sjhj-hjfs");
            cell8.setCellValue(this.getDictValueLabel(dmDictValueDTO, dataDelivery.getHjfs() + ""));
        }
        cell8.setCellStyle((CellStyle)defaultStyle);
        XSSFCell cell9 = rowi.createCell(9);
        cell9.setCellValue(this.NoNullString(dataDelivery.getRemark()));
        cell9.setCellStyle((CellStyle)defaultStyle);
        XSSFCell cell10 = rowi.createCell(10);
        cell10.setCellValue(this.NoNullString(dataDelivery.getProject()));
        cell10.setCellStyle((CellStyle)defaultStyle);
        XSSFCell cell11 = rowi.createCell(11);
        cell11.setCellValue(this.NoNullString(dataDelivery.getProjectLeader()));
        cell11.setCellStyle((CellStyle)defaultStyle);
        XSSFCell cell12 = rowi.createCell(12);
        cell12.setCellValue(this.NoNullString(dataDelivery.getProjectLeaderTel()));
        cell12.setCellStyle((CellStyle)defaultStyle);
        XSSFCell cell13 = rowi.createCell(13);
        cell13.setCellValue(dataDelivery.getDataSize().doubleValue());
        cell13.setCellStyle((CellStyle)defaultStyle);
    }

    private String NoNullString(String object) {
        return Optional.ofNullable(object).orElse("");
    }

    private String getDictValueLabel(DmDictValueDTO dmDictValueDTO, String value) {
        if (dmDictValueDTO == null || dmDictValueDTO.getChildren() == null || dmDictValueDTO.getChildren().size() == 0) {
            return "";
        }
        for (DmDictValueDTO data : dmDictValueDTO.getChildren()) {
            if (!data.getCode().equalsIgnoreCase(value)) continue;
            return data.getName();
        }
        return "";
    }

    private XSSFCellStyle createCellStyle(XSSFWorkbook wb) {
        XSSFCellStyle titleStyle = wb.createCellStyle();
        titleStyle.setBorderLeft(BorderStyle.THIN);
        titleStyle.setBorderRight(BorderStyle.THIN);
        titleStyle.setBorderBottom(BorderStyle.THIN);
        titleStyle.setBorderTop(BorderStyle.THIN);
        titleStyle.setAlignment(HorizontalAlignment.LEFT);
        return titleStyle;
    }
}

