/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.controller;

import cn.hutool.core.util.StrUtil;
import com.geoway.ns.sys.dto.BaseObjectResponse;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.FileServerResponse;
import com.geoway.ns.sys.dto.FileStructureDTO;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.zyfx.domain.ConcurrentCheck;
import com.geoway.ns.zyfx.service.ConcurrentCheckService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u6570\u636e\u6c47\u4ea4\u5ba1\u6838"})
@RestController
@RequestMapping(value={"concurrentCheck"})
public class ConcurrentCheckController {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentCheckController.class);
    @Resource
    private ITokenService tokenService;
    @Resource
    private ConcurrentCheckService concurrentCheckService;

    @ApiOperation(value="\u5ba1\u6838\u6570\u636e\u6c47\u4ea4\u4efb\u52a1:id(\u5ba1\u6838\u4fe1\u606fid)\uff0ccheckStatue(\u5ba1\u6279\u72b6\u6001 1 \u901a\u8fc7 2 \u62d2\u7edd)\u5fc5\u586b,approvalOpinion\u5ba1\u6279\u610f\u89c1\u9009\u586b")
    @PostMapping(value={"checkConcurrentTask"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse checkConcurrentTask(@ModelAttribute ConcurrentCheck concurrentCheck) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            this.concurrentCheckService.checkConcurrentTask(concurrentCheck);
            response.setData((Object)"\u5ba1\u6838\u6570\u636e\u6c47\u4ea4\u4efb\u52a1\u6210\u529f");
        }
        catch (Exception e) {
            return BaseResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u4e0a\u4f20\u6570\u636e\u6c47\u4ea4\u6570\u636e")
    @PostMapping(value={"/uploadFile"})
    public BaseResponse uploadFile(@RequestParam(value="file") MultipartFile multipartFile, @RequestParam(value="templatesId") String templatesId) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            FileServerResponse fileUploadResponse = this.concurrentCheckService.uploadFile(multipartFile);
            List<FileStructureDTO> compareTreeList = this.concurrentCheckService.compareUploadConcurrentData(templatesId, fileUploadResponse);
            fileUploadResponse.setTreeList(compareTreeList);
            try {
                fileUploadResponse.setMessage(this.concurrentCheckService.getCompareResult(compareTreeList, true).toString());
            }
            catch (Exception e) {
                fileUploadResponse.setMessage("false");
            }
            response.setData((Object)fileUploadResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u901a\u8fc7\u5ba1\u6838id\u66f4\u65b0\u6c47\u4ea4\u6570\u636e\u4fe1\u606f")
    @PostMapping(value={"/updateConcurrentDataById"})
    public BaseResponse updateConcurrentDataById(@ModelAttribute ConcurrentCheck concurrentCheck) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            this.concurrentCheckService.updateConcurrentDataById(concurrentCheck);
            response.setData((Object)"\u6c47\u4ea4\u6570\u636e\u63d0\u4ea4\u6210\u529f");
        }
        catch (Exception e) {
            return BaseObjectResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u901a\u8fc7\u6570\u636e\u6c47\u4ea4\u5ba1\u6838id\u4e0b\u8f7d\u6c47\u4ea4\u6570\u636e")
    @GetMapping(value={"/downloadFileById"})
    public void downloadFileById(@RequestParam(value="id") String id, HttpServletResponse response) {
        try {
            this.concurrentCheckService.downloadFileById(id, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @ApiOperation(value="\u6211\u7684\u6c47\u4ea4/\u6c47\u4ea4\u4efb\u52a1-\u6982\u89c8:\u6211\u7684\u6c47\u4ea4\u65f6\u9700\u4f20\u5165\u767b\u5f55\u7528\u6237\u7684token\uff0c\u6c47\u4ea4\u4efb\u52a1\u65f6\u4e0d\u7528\u4f20\u5165")
    @PostMapping(value={"/concurrentSurvey"})
    public BaseResponse concurrentSurvey(@RequestParam(value="token", required=false) String token) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            ConcurrentCheck concurrentCheck = ConcurrentCheck.builder().build();
            if (StrUtil.isNotBlank((CharSequence)token)) {
                SysUserDTO sysUser = this.tokenService.queryCurrentSysUser();
                concurrentCheck.setTaskReceiverId(sysUser.getId());
            }
            Map<String, Object> surveyMap = this.concurrentCheckService.concurrentSurvey(concurrentCheck);
            response.setData(surveyMap);
        }
        catch (Exception e) {
            return BaseObjectResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6570\u636e\u6a21\u677f/\u6c47\u4ea4\u5ba1\u6838\u6982\u89c8")
    @GetMapping(value={"/concurrentSurveyShowBarGraph"})
    public BaseResponse concurrentTemplatesSurvey() {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            List<Map<String, Object>> barGraphList = this.concurrentCheckService.concurrentSurveyShowBarGraph();
            response.setData(barGraphList);
        }
        catch (Exception e) {
            return BaseObjectResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }
}

