/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.geoway.ns.base.exception.BizException;
import com.geoway.ns.sys.dto.BaseObjectResponse;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.dto.PageParam;
import com.geoway.ns.sys.dto.RowsResponse;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.utils.TenantUserUtil;
import com.geoway.ns.zyfx.domain.ZyfxDataset;
import com.geoway.ns.zyfx.domain.ZyfxObject;
import com.geoway.ns.zyfx.domain.ZyfxServiceset;
import com.geoway.ns.zyfx.domain.ZyfxServicesetApi;
import com.geoway.ns.zyfx.domain.ZyfxToolset;
import com.geoway.ns.zyfx.dto.ZyfxObjectDetail;
import com.geoway.ns.zyfx.service.ZyfxImageService;
import com.geoway.ns.zyfx.service.ZyfxObjectService;
import com.geoway.ns.zyfx.service.ZyfxToolsetService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5bf9\u8c61\u96c6\u63a5\u53e3"})
@RestController
@RequestMapping(value={"zyfx/object"})
public class ZyfxObjectController {
    private static final Logger log = LoggerFactory.getLogger(ZyfxObjectController.class);
    @Autowired
    ZyfxObjectService zyfxObjectService;
    @Autowired
    private ITokenService iTokenService;
    @Autowired
    ZyfxImageService zyfxImageService;
    @Autowired
    ZyfxToolsetService zyfxToolsetService;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private TenantUserUtil tenantUserUtil;
    @Value(value="${right.tenant-enabled:false}")
    private Boolean tenantEnable = true;

    @ApiOperation(value="\u67e5\u8be2\u8d44\u6e90\u5bf9\u8c61\u96c6\u5217\u8868")
    @RequestMapping(value={"/list"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RowsResponse queryDataCatalogList(HttpServletRequest request, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size) {
        RowsResponse response = new RowsResponse();
        try {
            if (StrUtil.isEmpty((CharSequence)sortParam)) {
                sortParam = "SORT_createtime_ASC";
            }
            IPage<ZyfxObject> objectList = this.zyfxObjectService.queryPageByFilter(filterParam, sortParam, page, size);
            response.setRows(objectList.getRecords());
            response.setTotal(Long.valueOf(objectList.getTotal()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u70ed\u70b9\u5bf9\u8c61\u96c6\u5217\u8868")
    @RequestMapping(value={"/hots"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RowsResponse hotZxfxObjects(HttpServletRequest request, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="groupType", required=true) Integer groupType, @RequestParam(value="schemeId", required=false, defaultValue="") String schemeId, @RequestParam(value="isApplication", required=false) Integer isApplication, @RequestParam(value="maxcount", defaultValue="50", required=false) Integer maxcount) {
        RowsResponse response = new RowsResponse();
        try {
            List<ZyfxObject> objectList = this.zyfxObjectService.queryHots(filterParam, groupType, schemeId, isApplication, maxcount);
            response.setRows(objectList);
            response.setTotal(Long.valueOf(objectList.size()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u9ad8\u9891\u5173\u952e\u5b57\u5217\u8868")
    @RequestMapping(value={"/frequencyKeywords"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RowsResponse frequencyKeywords(HttpServletRequest request, @RequestParam(value="groupType", required=true) String groupType) {
        RowsResponse response = new RowsResponse();
        try {
            String key = "frequencyKeywords" + groupType;
            if (this.redisTemplate.hasKey((Object)key).booleanValue()) {
                ObjectMapper mapper = new ObjectMapper();
                List objectList = (List)mapper.readValue(this.redisTemplate.boundValueOps((Object)key).get().toString(), (TypeReference)new TypeReference<List<ZyfxObject>>(){});
                response.setRows(objectList);
                return response;
            }
            String[] types = groupType.split("-");
            List<Object> objectList = new ArrayList();
            objectList = types.length > 1 ? this.zyfxObjectService.frequencyKeywords(Integer.parseInt(types[0]), Integer.parseInt(types[1])) : this.zyfxObjectService.frequencyKeywords(Integer.parseInt(types[0]));
            ObjectMapper mapper = new ObjectMapper();
            String json = mapper.writeValueAsString(objectList);
            this.redisTemplate.boundValueOps((Object)key).set((Object)json);
            this.redisTemplate.expire((Object)key, 1L, TimeUnit.DAYS);
            response.setRows(objectList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u670d\u52a1\u8be6\u60c5--\u8fd0\u7ef4\u63a5\u53e3")
    @RequestMapping(value={"/detailSimple"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public DataResponse<ZyfxObjectDetail> detailSimple(HttpServletRequest request, @RequestParam(value="id") String id, @RequestParam(value="havaDataSet", defaultValue="false", required=false) Boolean havaDataSet) {
        DataResponse detailDataResponse = new DataResponse();
        try {
            ZyfxObjectDetail detail = this.zyfxObjectService.findDetailWithOriUrlById(id, havaDataSet);
            detailDataResponse.setResult((Object)detail);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            detailDataResponse.markFailure(e.getMessage());
        }
        return detailDataResponse;
    }

    @ApiOperation(value="\u670d\u52a1\u8be6\u60c5--\u95e8\u6237\u63a5\u53e3")
    @RequestMapping(value={"/detail"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public DataResponse<ZyfxObjectDetail> detail(HttpServletRequest request, @RequestParam(value="id") String id, @RequestParam(value="havaDataSet", defaultValue="false", required=false) Boolean havaDataSet) {
        DataResponse detailDataResponse = new DataResponse();
        try {
            boolean isTempUrl = true;
            ZyfxObjectDetail detail = this.zyfxObjectService.findDetailById(id, havaDataSet, isTempUrl);
            detailDataResponse.setResult((Object)detail);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            detailDataResponse.markFailure(e.getMessage());
        }
        return detailDataResponse;
    }

    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u96c6")
    @PostMapping(value={"/saveDataset"}, consumes={"multipart/form-data"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse saveDataset(HttpServletRequest request, @ModelAttribute ZyfxObject zyfxObject, @ModelAttribute ZyfxDataset zyfxDataset, @RequestPart(value="file", required=false) MultipartFile file, @RequestPart(value="otherfiles", required=false) MultipartFile[] otherfiles) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            this.WrapperObjectStatus(zyfxObject);
            String id = this.zyfxObjectService.saveOneDataSet2(zyfxObject, zyfxDataset, file, otherfiles);
            response.setData((Object)id);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u4fdd\u5b58\u670d\u52a1\u96c6")
    @PostMapping(value={"saveServerset"}, consumes={"multipart/form-data"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse saveServerset(HttpServletRequest request, @ModelAttribute ZyfxObject zyfxObject, @ModelAttribute ZyfxServiceset zyfxServiceset, @RequestPart(value="file", required=false) MultipartFile file, @RequestPart(value="otherfiles", required=false) MultipartFile[] otherfiles) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            this.WrapperObjectStatus(zyfxObject);
            String id = this.zyfxObjectService.saveOneServiceSet2(zyfxObject, zyfxServiceset, file, otherfiles);
            response.setData((Object)id);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u4fdd\u5b58\u5de5\u5177\u96c6")
    @PostMapping(value={"saveToolset"}, consumes={"multipart/form-data"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse saveToolset(HttpServletRequest request, @ModelAttribute ZyfxObject zyfxObject, @ModelAttribute ZyfxToolset zyfxToolset, @RequestPart(value="file", required=false) MultipartFile file, @RequestPart(value="otherfiles", required=false) MultipartFile[] otherfiles) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            this.WrapperObjectStatus(zyfxObject);
            String id = this.zyfxObjectService.saveOneToolSet2(zyfxObject, zyfxToolset, file, otherfiles);
            response.setData((Object)id);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6570\u636e\u8282\u70b9\u79fb\u52a8")
    @RequestMapping(value={"/move"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public BaseResponse move(HttpServletRequest request, @RequestParam(value="catalogid") String catalogid, @RequestParam(value="objectid") String objectid) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            this.zyfxObjectService.moveDataNode(catalogid, objectid);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u4e0a\u4f20\u6a21\u677f")
    @PostMapping(value={"uploadTemplate"}, consumes={"multipart/form-data"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse uploadTemplate(HttpServletRequest request, @RequestParam(value="nodeId") String nodeId, @RequestParam(value="schemeId") String schemeId, @RequestParam(value="type") String type, @RequestPart(value="file", required=false) MultipartFile file) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            List<String> errorMessageList = this.zyfxObjectService.uploadTemplate(type, file, nodeId, schemeId);
            if (errorMessageList.size() == 0) {
                response.setData((Object)"\u5bfc\u5165\u6210\u529f\uff01");
            } else {
                response.markFailure("\u5bfc\u5165\u5931\u8d25\uff01" + String.join((CharSequence)"\n", errorMessageList));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5220\u9664\u5bf9\u8c61\u96c6")
    @PostMapping(value={"logicDel"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse logicDel(HttpServletRequest request, @RequestParam(value="ids", defaultValue="") String ids) {
        BaseResponse response = new BaseResponse();
        try {
            this.zyfxObjectService.logicDelObjectSets(ids);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6570\u636e\u5143\u6570\u636e\u6279\u91cf\u5bfc\u51fa")
    @GetMapping(value={"dataBatchExport"})
    public void dataBatchExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="grouptype", defaultValue="") Integer grouptype) {
        try {
            List<Map<String, Object>> objectList = this.zyfxObjectService.dataBatchExport(grouptype);
            XSSFWorkbook workbook = new XSSFWorkbook();
            Sheet sheet = workbook.createSheet("Data");
            Row headerRow = sheet.createRow(0);
            Map<String, Object> firstRow = objectList.get(0);
            int columnIndex = 0;
            for (String string : firstRow.keySet()) {
                Cell cell = headerRow.createCell(columnIndex++);
                cell.setCellValue(string);
            }
            int rowIndex = 1;
            for (Map<String, Object> map : objectList) {
                Row row = sheet.createRow(rowIndex++);
                columnIndex = 0;
                for (String key : firstRow.keySet()) {
                    Cell cell = row.createCell(columnIndex++);
                    Object value = map.get(key);
                    if (value == null) continue;
                    cell.setCellValue(value.toString());
                }
            }
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            LocalDateTime localDateTime = LocalDateTime.now();
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss");
            String formattedDateTime = localDateTime.format(dateTimeFormatter);
            String fileName = URLEncoder.encode("\u8d44\u6e90\u5143\u6570\u636e" + formattedDateTime + ".xlsx", "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName);
            ServletOutputStream outputStream = response.getOutputStream();
            workbook.write((OutputStream)outputStream);
            workbook.close();
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @ApiOperation(value="\u6536\u85cf/\u53d6\u6d88\u6536\u85cf")
    @PostMapping(value={"toggleFavorite"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse toggleFavorite(HttpServletRequest request, @RequestParam(value="ids", defaultValue="") String ids, @RequestParam(value="flag", defaultValue="") boolean flag) {
        BaseResponse response = new BaseResponse();
        try {
            this.zyfxObjectService.toggleFavorite(ids, flag);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u52a0\u5165/\u79fb\u51fa\u8d2d\u7269\u8f66")
    @PostMapping(value={"toggleInCart"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse toggleInCart(HttpServletRequest request, @RequestParam(value="ids", defaultValue="") String ids, @RequestParam(value="flag", defaultValue="") boolean flag) {
        BaseResponse response = new BaseResponse();
        try {
            this.zyfxObjectService.toggleInCart(ids, flag);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u52a0\u5165/\u79fb\u51fa\u7533\u8bf7")
    @PostMapping(value={"toggleApply"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse toggleApply(HttpServletRequest request, @RequestParam(value="ids", defaultValue="") String ids, @RequestParam(value="flag", defaultValue="") boolean flag) {
        BaseResponse response = new BaseResponse();
        try {
            this.zyfxObjectService.toggleInCart(ids, flag);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u63a8\u8350\u70ed\u95e8/\u53d6\u6d88\u63a8\u8350\u70ed\u95e8")
    @PostMapping(value={"toggleHot"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse toggleHot(HttpServletRequest request, @RequestParam(value="ids", defaultValue="") String ids, @RequestParam(value="flag", defaultValue="") boolean flag) {
        BaseResponse response = new BaseResponse();
        try {
            this.zyfxObjectService.toggleHot(ids, flag);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u7a7a\u95f4\u68c0\u7d22\u8d44\u6e90\u5bf9\u8c61\u96c6\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="schemeId", value="\u65b9\u6848id", required=true), @ApiImplicitParam(name="filterParam", value="\u5c5e\u6027\u8fc7\u6ee4\u6761\u4ef6", required=false), @ApiImplicitParam(name="sortParam", value="\u6392\u5e8f\u6761\u4ef6", required=false), @ApiImplicitParam(name="groupType", value="\u5206\u7ec4\u7f16\u7801", required=true), @ApiImplicitParam(name="mapno", value="\u56fe\u5e45\u53f7", required=false), @ApiImplicitParam(name="range", value="\u56db\u81f3\u8303\u56f4,\u683c\u5f0f\u5982\u4e0b\uff0c\u4e2d\u95f4\u7528\u82f1\u6587\u9017\u53f7\u5206\u5272(xmin;ymin;xmax;ymax)", example="108.1;20.3;109.2;21.4", required=false), @ApiImplicitParam(name="xzqdm", value="\u884c\u653f\u533a\u4ee3\u7801", required=false), @ApiImplicitParam(name="wkt", value="\u51e0\u4f55\u56fe\u5f62WKT", required=false)})
    @RequestMapping(value={"/spatialSeach"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RowsResponse spatialSeach(HttpServletRequest request, @RequestParam(value="catalogIds", required=false, defaultValue="") String catalogIds, @RequestParam(value="schemeId") String schemeId, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(value="groupType", required=true) Integer groupType, @RequestParam(value="mapno", required=false, defaultValue="") String mapno, @RequestParam(value="range", required=false, defaultValue="") String range, @RequestParam(value="xzqdm", required=false) String xzqdm, @RequestParam(value="wkt", required=false) String wkt, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size) {
        RowsResponse response = new RowsResponse();
        try {
            IPage<ZyfxObject> objectList = this.zyfxObjectService.spatialSeach(mapno, range, xzqdm, wkt, schemeId, catalogIds, groupType, filterParam, sortParam, page, size);
            response.setRows(objectList.getRecords());
            response.setTotal(Long.valueOf(objectList.getTotal()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u67e5\u8be2\u8d44\u6e90\u5bf9\u8c61\u5de5\u5177\u96c6\u96c6\u5217\u8868")
    @RequestMapping(value={"/listTools"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RowsResponse listTools(HttpServletRequest request, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(value="inYykj", required=false, defaultValue="0") Integer inYykj, @RequestParam(value="mapModes", required=false, defaultValue="") String mapModes, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size) {
        RowsResponse response = new RowsResponse();
        try {
            if (StrUtil.isEmpty((CharSequence)sortParam)) {
                sortParam = "SORT_createtime_ASC";
            }
            Page<ZyfxObject> objectList = this.zyfxObjectService.queryYykjToolSets(filterParam, sortParam, inYykj, mapModes, page, size);
            response.setRows(objectList.getRecords());
            response.setTotal(Long.valueOf(objectList.getTotal()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u52a0\u5165/\u79fb\u51fa\u5e94\u7528\u7a7a\u95f4")
    @PostMapping(value={"toggleYykj"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse toggleYykj(HttpServletRequest request, @RequestParam(value="ids") String ids, @RequestParam(value="flag") boolean flag) {
        BaseResponse response = new BaseResponse();
        try {
            boolean isSuccess = this.zyfxToolsetService.toggleInYyJk(ids, flag);
            if (!isSuccess) {
                throw new BizException("\u66f4\u65b0\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5730\u56fe\u670d\u52a1API\u91cd\u7f6e\u3001\u5206\u6790\u670d\u52a1\u53c2\u6570\u6279\u91cf\u8bf7\u6c42\u529f\u80fd")
    @PostMapping(value={"resetService"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse resetService(HttpServletRequest request, @RequestParam(value="ids") String ids) {
        BaseResponse response = new BaseResponse();
        try {
            this.zyfxObjectService.resetService(ids);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    private void WrapperObjectStatus(ZyfxObject zyfxObject) {
        SysUserDTO userDTO = null;
        try {
            userDTO = this.iTokenService.queryCurrentSysUserWithNull();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        boolean isAdmin = false;
        if (userDTO != null) {
            boolean bl = isAdmin = !userDTO.getUsername().equalsIgnoreCase("admin");
        }
        if (isAdmin && !zyfxObject.getLylx().equals("\u5171\u4eab\u6ce8\u518c")) {
            zyfxObject.setStatus(1);
        } else {
            zyfxObject.setStatus(0);
        }
    }

    @ApiOperation(value="\u670d\u52a1\u8be6\u60c5--\u95e8\u6237\u63a5\u53e3")
    @RequestMapping(value={"/metadata/detail"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public DataResponse<List<ZyfxObjectDetail>> dataMetaDetail(HttpServletRequest request, @RequestParam(value="relatedIds") String relatedIds) {
        DataResponse detailDataResponse = new DataResponse();
        try {
            boolean isTempUrl = true;
            boolean havaDataSet = false;
            List<ZyfxObjectDetail> details = this.zyfxObjectService.findMetaDetailsByRelatedId(relatedIds, havaDataSet, isTempUrl);
            detailDataResponse.setResult(details);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            detailDataResponse.markFailure(e.getMessage());
        }
        return detailDataResponse;
    }

    @ApiOperation(value="\u5de5\u5177\u6743\u9650--\u5206\u9875\u67e5\u8be2")
    @RequestMapping(value={"/power/page"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public DataResponse<IPage<ZyfxObject>> powerPage(HttpServletRequest request, PageParam page, @RequestParam String relationId, String name, String lb, String aqj) {
        DataResponse detailDataResponse = new DataResponse();
        try {
            detailDataResponse.setResult(this.zyfxObjectService.queryPowerPage(page, relationId, name, lb, aqj));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            detailDataResponse.markFailure(e.getMessage());
        }
        return detailDataResponse;
    }

    @ApiOperation(value="\u68c0\u6d4b\u670d\u52a1\u96c6\u865a\u62df\u5730\u5740\u662f\u5426\u51b2\u7a81")
    @RequestMapping(value={"testVirtualUrl"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public BaseResponse testVirtualUrl(HttpServletRequest request, String id, String virtualUrl) {
        BaseResponse response = new BaseResponse();
        try {
            List<ZyfxServiceset> entitys = this.zyfxObjectService.queryZyfxServicesetByVirtualUrl(id, virtualUrl);
            if (entitys != null && entitys.size() > 0) {
                response.setMessage("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u865a\u62df\u5730\u5740\u4fe1\u606f");
                response.setStatus("FAILURE");
            } else {
                List<ZyfxServicesetApi> entityApis = this.zyfxObjectService.queryZyfxServicesetApiByVirtualUrl(id, virtualUrl);
                if (entityApis != null && entityApis.size() > 0) {
                    response.setMessage("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u865a\u62df\u5730\u5740\u4fe1\u606f");
                    response.setStatus("FAILURE");
                } else {
                    response.setMessage("\u8be5\u865a\u62df\u5730\u5740\u4fe1\u606f\u53ef\u7528");
                    response.setStatus("OK");
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }
}

