/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.flowable.listener;

import com.geoway.ns.zyfx.domain.ZyfxObjectApply;
import com.geoway.ns.zyfx.service.ZyfxObjectApplyService;
import java.io.Serializable;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.ExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="processEndExecutionListener")
public class ProcessEndExecutionListener
implements ExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(ProcessEndExecutionListener.class);
    @Autowired
    private ZyfxObjectApplyService applyService;

    public void notify(DelegateExecution execution) {
        try {
            String businessKey = execution.getProcessInstanceBusinessKey();
            String processInstanceId = execution.getProcessInstanceId();
            log.info("\u6d41\u7a0b\u7ed3\u675f\u76d1\u542c\u5668\u89e6\u53d1 - \u6d41\u7a0b\u5b9e\u4f8bID: {}, \u4e1a\u52a1Key: {}", (Object)processInstanceId, (Object)businessKey);
            ZyfxObjectApply apply = (ZyfxObjectApply)this.applyService.getById((Serializable)((Object)businessKey));
            if (apply != null) {
                apply.setCheckstatus(2);
                this.applyService.updateById(apply);
                log.info("\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7\uff08\u6d41\u7a0b\u7ed3\u675f\uff09 - \u7533\u8bf7ID: {}, \u7533\u8bf7\u540d\u79f0: {}", (Object)apply.getId(), (Object)apply.getObjectname());
                this.handlePostApproval(apply, execution);
            }
        }
        catch (Exception e) {
            log.error("\u6d41\u7a0b\u7ed3\u675f\u76d1\u542c\u5668\u5904\u7406\u5931\u8d25", (Throwable)e);
        }
    }

    private void handlePostApproval(ZyfxObjectApply apply, DelegateExecution execution) {
        log.info("\u6267\u884c\u5ba1\u6838\u901a\u8fc7\u540e\u7684\u4e1a\u52a1\u5904\u7406 - \u7533\u8bf7ID: {}", (Object)apply.getId());
        Boolean approved = (Boolean)execution.getVariable("approved");
        String finalComment = (String)execution.getVariable("finalComment");
        log.info("\u5ba1\u6838\u7ed3\u679c: {}, \u6700\u7ec8\u610f\u89c1: {}", (Object)approved, (Object)finalComment);
    }
}

