/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.ns.sys.dto.BaseObjectResponse;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.EasyUIResponse;
import com.geoway.ns.sys.dto.FileServerResponse;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.zyfx.constant.submitcenter.EnumConcurrentTemplateStatus;
import com.geoway.ns.zyfx.domain.ConcurrentTemplates;
import com.geoway.ns.zyfx.service.ConcurrentTemplatesService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u6570\u636e\u6c47\u4ea4\u6a21\u677f"})
@RestController
@RequestMapping(value={"concurrentTemplates"})
public class ConcurrentTemplatesController {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentTemplatesController.class);
    @Resource
    private ConcurrentTemplatesService concurrentTemplatesService;
    @Resource
    private ITokenService iTokenService;
    @Resource
    private ITokenService tokenService;

    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u6c47\u4ea4\u6a21\u677f:name(\u6570\u636e\u6c47\u4ea4\u6a21\u677f\u540d\u79f0)\u3001templatesUploadUrl(\u6c47\u4ea4\u6a21\u677f\u4e0a\u4f20\u5230\u670d\u52a1\u5668\u7684url)\u3001templateStructureTree(\u6c47\u4ea4\u6a21\u677f\u76ee\u5f55\u7ed3\u6784\u6811)\u5fc5\u586b\uff0c,description(\u6c47\u4ea4\u6a21\u677f\u8bf4\u660e)\u9009\u586b")
    @PostMapping(value={"addConcurrentTemplates"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse addConcurrentTemplates(HttpServletRequest request, @ModelAttribute ConcurrentTemplates concurrentTemplates) throws Exception {
        BaseObjectResponse response = new BaseObjectResponse();
        SysUserDTO sysUser = this.tokenService.queryCurrentSysUser();
        if (StrUtil.isNotBlank((CharSequence)concurrentTemplates.getName()) && StrUtil.isNotBlank((CharSequence)concurrentTemplates.getTemplatesUploadUrl()) && StrUtil.isNotBlank((CharSequence)concurrentTemplates.getTemplateStructureTree())) {
            try {
                concurrentTemplates.setCreateTime(new Date());
                concurrentTemplates.setUpdateTime(new Date());
                if (ObjectUtil.isEmpty((Object)concurrentTemplates.getStatus())) {
                    concurrentTemplates.setStatus(EnumConcurrentTemplateStatus.No.value);
                }
                concurrentTemplates.setBuilder(sysUser.getAlisname());
                concurrentTemplates.setBuilderId(sysUser.getId());
                this.concurrentTemplatesService.addConcurrentTemplates(concurrentTemplates);
                response.setData((Object)"\u6570\u636e\u6c47\u4ea4\u6a21\u677f\u65b0\u5efa\u6210\u529f");
            }
            catch (Exception e) {
                return BaseResponse.buildFailuaResponse((String)e.getMessage());
            }
        }
        return response;
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e\u6c47\u4ea4\u6a21\u677f:id(\u6570\u636e\u6c47\u4ea4\u6a21\u677fid\uff0c\u5b58\u5728\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00)\u5fc5\u586b")
    @PostMapping(value={"deleteConcurrentTemplates"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse deleteConcurrentTemplates(@ModelAttribute ConcurrentTemplates concurrentTemplates) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            this.concurrentTemplatesService.deleteConcurrentTemplates(concurrentTemplates);
            response.setData((Object)"\u6570\u636e\u6c47\u4ea4\u6a21\u677f\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            return BaseResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u6c47\u4ea4\u6a21\u677f\uff1aid(\u6570\u636e\u6c47\u4ea4\u6a21\u677fid)\u3001name(\u6570\u636e\u6c47\u4ea4\u6a21\u677f\u540d\u79f0)\u3001templatesUploadUrl(\u6c47\u4ea4\u6a21\u677f\u4e0a\u4f20\u5230\u670d\u52a1\u5668\u7684url)\u3001templateStructureTree(\u6c47\u4ea4\u6a21\u677f\u76ee\u5f55\u7ed3\u6784\u6811)\u5fc5\u586b\uff0c,description(\u6c47\u4ea4\u6a21\u677f\u8bf4\u660e)\u9009\u586b")
    @PostMapping(value={"updateConcurrentTemplates"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse updateConcurrentTemplates(@ModelAttribute ConcurrentTemplates concurrentTemplates) {
        BaseObjectResponse response = new BaseObjectResponse();
        if (StrUtil.isNotBlank((CharSequence)concurrentTemplates.getId()) && StrUtil.isNotBlank((CharSequence)concurrentTemplates.getName()) && StrUtil.isNotBlank((CharSequence)concurrentTemplates.getTemplatesUploadUrl()) && StrUtil.isNotBlank((CharSequence)concurrentTemplates.getTemplateStructureTree())) {
            try {
                this.concurrentTemplatesService.updateConcurrentTemplates(concurrentTemplates);
                response.setData((Object)"\u6570\u636e\u6c47\u4ea4\u6a21\u677f\u4fee\u6539\u6210\u529f");
            }
            catch (Exception e) {
                return BaseResponse.buildFailuaResponse((String)e.getMessage());
            }
        }
        return response;
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6570\u636e\u6c47\u4ea4\u6a21\u677f\u6a21\u677f\u4fe1\u606f\uff1apage(\u9875\u7801),rows(\u6bcf\u9875\u6570\u636e\u91cf)\u5206\u9875\u4fe1\u606f\u5fc5\u586b,name(\u6570\u636e\u6c47\u4ea4\u6a21\u677f\u540d\u79f0)\u3001status(\u6a21\u677f\u542f\u7528\u72b6\u6001:1 \u542f\u7528 0 \u672a\u542f\u7528)\u3001startQueryDate(\u8d77\u59cb\u521b\u5efa\u65f6\u95f4)\u3001endQueryDate(\u622a\u6b62\u521b\u5efa\u65f6\u95f4)\u9009\u586b")
    @PostMapping(value={"queryConcurrentTemplatesPage"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse queryConcurrentTemplatesPage(@ModelAttribute ConcurrentTemplates concurrentTemplates) {
        EasyUIResponse response = new EasyUIResponse();
        try {
            IPage<ConcurrentTemplates> concurrentTemplatesIPage = this.concurrentTemplatesService.queryConcurrentTemplatesPage(concurrentTemplates);
            response.setRows(concurrentTemplatesIPage.getRecords());
            response.setTotal(Long.valueOf(concurrentTemplatesIPage.getTotal()));
        }
        catch (Exception e) {
            return EasyUIResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u4e0a\u4f20\u6570\u636e\u6c47\u4ea4\u6a21\u677f\u6570\u636e")
    @PostMapping(value={"/uploadFile"})
    public BaseResponse uploadFile(@RequestParam(value="file") MultipartFile multipartFile) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            FileServerResponse fileUploadResponse = this.concurrentTemplatesService.uploadFile(multipartFile);
            response.setData((Object)fileUploadResponse);
        }
        catch (Exception e) {
            return BaseObjectResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u901a\u8fc7\u6570\u636e\u6c47\u4ea4\u6a21\u677fid\u4e0b\u8f7d\u6a21\u677f")
    @GetMapping(value={"/downloadFileById"})
    public void downloadFileById(@RequestParam(value="id") String id, HttpServletResponse response) {
        try {
            this.concurrentTemplatesService.downloadFileById(id, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

