/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl;

import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.entity.DmDictValue;
import com.geoway.adf.dms.config.service.DictionaryService;
import com.geoway.adf.dms.config.service.SysParamsService;
import com.geoway.adf.dms.datasource.dao.DmDistrictItemDao;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemDTO;
import com.geoway.adf.dms.datasource.entity.DmDistrictItem;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.DistrictService;
import com.geoway.ns.base.exception.BizException;
import com.geoway.ns.proxy.entity.AuthorizeToken;
import com.geoway.ns.proxy.entity.ProxyObject;
import com.geoway.ns.proxy.entity.ProxyToken;
import com.geoway.ns.proxy.mapper.AuthorizeTokenMapper;
import com.geoway.ns.proxy.mapper.ProxyObjectMapper;
import com.geoway.ns.proxy.mapper.ProxyTokenMapper;
import com.geoway.ns.proxy.service.ProxyObjectService;
import com.geoway.ns.proxy.utils.UnityUtils;
import com.geoway.ns.sys.domain.BaseSysPower;
import com.geoway.ns.sys.domain.SysPowerGj;
import com.geoway.ns.sys.dto.PageParam;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.enums.SysParamGroupEnum;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.service.SysPowerGjService;
import com.geoway.ns.sys.support.query.MPJQueryMapperUtil;
import com.geoway.ns.sys.support.query.MyQueryMapperUtil;
import com.geoway.ns.sys.support.query.QueryParamUtil;
import com.geoway.ns.sys.utils.BaseTreeUtil;
import com.geoway.ns.sys.utils.ProxyUtil;
import com.geoway.ns.zyfx.domain.GeoJfb;
import com.geoway.ns.zyfx.domain.ZyfxCart;
import com.geoway.ns.zyfx.domain.ZyfxCatalog;
import com.geoway.ns.zyfx.domain.ZyfxCatalogObject;
import com.geoway.ns.zyfx.domain.ZyfxDataset;
import com.geoway.ns.zyfx.domain.ZyfxDictfld;
import com.geoway.ns.zyfx.domain.ZyfxFavorite;
import com.geoway.ns.zyfx.domain.ZyfxFiles;
import com.geoway.ns.zyfx.domain.ZyfxImage;
import com.geoway.ns.zyfx.domain.ZyfxObject;
import com.geoway.ns.zyfx.domain.ZyfxObjectApply;
import com.geoway.ns.zyfx.domain.ZyfxRegAval;
import com.geoway.ns.zyfx.domain.ZyfxServiceset;
import com.geoway.ns.zyfx.domain.ZyfxServicesetApi;
import com.geoway.ns.zyfx.domain.ZyfxToolset;
import com.geoway.ns.zyfx.dto.FldDicts;
import com.geoway.ns.zyfx.dto.ZyfxObjectDetail;
import com.geoway.ns.zyfx.dto.ZyfxObjectSt;
import com.geoway.ns.zyfx.mapper.ZyfxCartMapper;
import com.geoway.ns.zyfx.mapper.ZyfxCatalogMapper;
import com.geoway.ns.zyfx.mapper.ZyfxDatasetMapper;
import com.geoway.ns.zyfx.mapper.ZyfxDictfldMapper;
import com.geoway.ns.zyfx.mapper.ZyfxFavoriteMapper;
import com.geoway.ns.zyfx.mapper.ZyfxObjectApplyMapper;
import com.geoway.ns.zyfx.mapper.ZyfxObjectMapper;
import com.geoway.ns.zyfx.mapper.ZyfxRegAvalMapper;
import com.geoway.ns.zyfx.mapper.ZyfxServicesetMapper;
import com.geoway.ns.zyfx.mapper.ZyfxToolsetMapper;
import com.geoway.ns.zyfx.service.GeoJfbService;
import com.geoway.ns.zyfx.service.ZyfxAccessService;
import com.geoway.ns.zyfx.service.ZyfxCatalogObjectService;
import com.geoway.ns.zyfx.service.ZyfxFilesService;
import com.geoway.ns.zyfx.service.ZyfxImageService;
import com.geoway.ns.zyfx.service.ZyfxObjectGeomService;
import com.geoway.ns.zyfx.service.ZyfxObjectService;
import com.geoway.ns.zyfx.service.ZyfxRegAvalService;
import com.geoway.ns.zyfx.service.ZyfxServicesetApiService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class ZyfxObjectServiceImpl
extends MPJBaseServiceImpl<ZyfxObjectMapper, ZyfxObject>
implements ZyfxObjectService {
    @Autowired
    ZyfxCatalogMapper zyfxCatalogMapper;
    @Autowired
    ZyfxDatasetMapper zyfxDatasetMapper;
    @Autowired
    ZyfxServicesetMapper zyfxServicesetMapper;
    @Autowired
    ZyfxServicesetApiService zyfxServicesetApiService;
    @Autowired
    ZyfxToolsetMapper zyfxToolsetMapper;
    @Autowired
    ZyfxImageService zyfxImageService;
    @Autowired
    ZyfxFavoriteMapper zyfxFavoriteMapper;
    @Autowired
    ZyfxCartMapper zyfxCartMapper;
    @Autowired
    ZyfxObjectApplyMapper zyfxObjectApplyMapper;
    @Autowired
    ITokenService iTokenService;
    @Autowired
    ZyfxAccessService zyfxAccessService;
    @Autowired
    ZyfxDictfldMapper zyfxDictfldMapper;
    @Autowired
    DictionaryService dictionaryService;
    @Autowired
    ZyfxCatalogObjectService zyfxCatalogObjectService;
    @Resource
    private DataSourceService dataSourceService;
    @Autowired
    ZyfxFilesService zyfxFilesService;
    @Autowired
    ZyfxRegAvalService zyfxRegAvalService;
    @Resource
    GeoJfbService geoJfbService;
    @Resource
    DistrictService districtService;
    @Autowired
    ZyfxObjectGeomService zyfxObjectGeomService;
    @Resource
    private ZyfxObjectApplyMapper applyService;
    @Autowired
    private AuthorizeTokenMapper authorizeMapper;
    @Autowired
    private ZyfxRegAvalMapper zyfxRegAvalMapper;
    @Autowired
    private SysParamsService sysParamsService;
    @Resource
    private DmDistrictItemDao dmDistrictItemDao;
    @Autowired
    private ProxyObjectMapper proxyObjectMapper;
    @Autowired
    private ProxyTokenMapper proxyTokenMapper;
    @Autowired
    private SysPowerGjService sysPowerGjService;
    @Resource
    ProxyObjectService proxyObjectService;

    @Override
    public List<String> queryIdsByName(String name) throws Exception {
        MPJLambdaWrapper wrapper = new MPJLambdaWrapper();
        wrapper.like(ZyfxObject::getName, (Object)name);
        ((MPJLambdaWrapper)wrapper.or()).like(ZyfxObject::getAlias, (Object)name);
        wrapper.select(new SFunction[]{ZyfxObject::getId});
        List mapCounts = this.listMaps((Wrapper)wrapper);
        if (mapCounts.size() > 0) {
            return mapCounts.stream().map(i -> i.get("f_id").toString()).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public List<ZyfxObject> queryListByFilter(String filterParam, String sortParam, boolean tempUrl) throws Exception {
        MyQueryMapperUtil qmu;
        QueryWrapper queryWrapper;
        List listResults;
        if (StrUtil.isEmpty((CharSequence)sortParam)) {
            sortParam = "SORT_id_DESC";
        }
        if ((listResults = this.list((Wrapper)(queryWrapper = (qmu = new MyQueryMapperUtil()).queryMapper(filterParam, sortParam, ZyfxObject.class)))).size() > 0 && StrUtil.isNotBlank((CharSequence)filterParam)) {
            List list = listResults.stream().map(i -> i.getId()).collect(Collectors.toList());
        }
        if (tempUrl) {
            // empty if block
        }
        return listResults;
    }

    @Override
    public IPage<ZyfxObject> queryPageByFilter2(String filterParam, String sortParam, int page, int size) throws Exception {
        MyQueryMapperUtil qmu = new MyQueryMapperUtil();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, sortParam, ZyfxObject.class);
        Page pageT = new Page((long)page, (long)size);
        return this.page((IPage)pageT, (Wrapper)queryWrapper);
    }

    @Override
    public IPage<ZyfxObject> queryPageByFilter(String filterParam, String sortParam, int page, int size) throws Exception {
        return this.queryCatalogPageByFilter(null, null, -1, -1, -1, null, filterParam, sortParam, false, page, size);
    }

    @Override
    public IPage<ZyfxObject> queryCatalogPageByFilter(String nodeId, String schemeId, int groupType, int favorite, int inCart, Integer isApplication, String filterParam, String sortParam, boolean haveDetail, int page, int size) throws Exception {
        Page pageT;
        IPage pageResults;
        List listResults;
        String userId;
        boolean isNoValid;
        boolean needJoinCatalog;
        String nodeCode = null;
        if (StrUtil.isNotBlank((CharSequence)nodeId)) {
            ZyfxCatalog catalogNode = (ZyfxCatalog)this.zyfxCatalogMapper.selectById((Serializable)((Object)nodeId));
            nodeCode = catalogNode != null ? catalogNode.getCode() : "not exists";
        }
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, sortParam, ZyfxObject.class);
        queryWrapper.selectAll(ZyfxObject.class);
        List queryFilterParams = QueryParamUtil.parseQueryFilterParams((String)filterParam);
        if (groupType == 1) {
            queryWrapper.leftJoin(ZyfxDataset.class, "zt", ZyfxDataset::getId, ZyfxObject::getId);
            queryWrapper.selectAs("zt", ZyfxDataset::getScdw, ZyfxObject::getScdw);
            queryFilterParams.forEach(p -> {
                if (p.getParamName().equals("gxpc")) {
                    queryWrapper.eq(ZyfxDataset::getGxpc, (Object)Integer.parseInt(p.getParamValue()));
                }
                if (p.getParamName().equals("srs")) {
                    queryWrapper.eq(ZyfxDataset::getSrs, (Object)p.getParamValue());
                }
                if (p.getParamName().equals("gcjz")) {
                    queryWrapper.eq(ZyfxDataset::getGcjz, (Object)p.getParamValue());
                }
                if (p.getParamName().equals("prj")) {
                    queryWrapper.eq(ZyfxDataset::getPrj, (Object)p.getParamValue());
                }
            });
        }
        if (groupType == 2) {
            queryWrapper.leftJoin(ZyfxServiceset.class, "zt", ZyfxServiceset::getId, ZyfxObject::getId);
            queryFilterParams.forEach(p -> {
                if (p.getParamName().equals("gxpc")) {
                    queryWrapper.eq(ZyfxServiceset::getGxpc, (Object)Integer.parseInt(p.getParamValue()));
                }
                if (p.getParamName().equals("srs")) {
                    queryWrapper.eq(ZyfxServiceset::getSrs, (Object)p.getParamValue());
                }
                if (p.getParamName().equals("gcjz")) {
                    queryWrapper.eq(ZyfxServiceset::getGcjz, (Object)p.getParamValue());
                }
                if (p.getParamName().equals("prj")) {
                    queryWrapper.eq(ZyfxServiceset::getPrj, (Object)p.getParamValue());
                }
            });
        }
        if (groupType == 3) {
            queryWrapper.selectAs("zt", ZyfxToolset::getInyykj, ZyfxObject::getInYykj);
            queryWrapper.selectAs("zt", ZyfxToolset::getOpenmode, ZyfxObject::getOpenmode);
            queryWrapper.selectAs("zt", ZyfxToolset::getToolkey, ZyfxObject::getToolkey);
            queryWrapper.selectAs("zt", ZyfxToolset::getMapmode, ZyfxObject::getMapmode);
            queryWrapper.leftJoin(ZyfxToolset.class, "zt", ZyfxToolset::getId, ZyfxObject::getId);
            if (isApplication != null) {
                queryWrapper.eq(ZyfxToolset::getIsapplication, (Object)isApplication);
            }
        }
        if (groupType > -1) {
            queryWrapper.eq(ZyfxObject::getGrouptype, (Object)groupType);
        }
        boolean bl = needJoinCatalog = StrUtil.isNotEmpty((CharSequence)nodeCode) || StrUtil.isNotBlank((CharSequence)schemeId);
        if (needJoinCatalog) {
            queryWrapper.leftJoin(ZyfxCatalogObject.class, ZyfxCatalogObject::getObjectid, ZyfxObject::getId);
            queryWrapper.leftJoin(ZyfxCatalog.class, ZyfxCatalog::getId, ZyfxCatalogObject::getCatalogid);
            if (StrUtil.isNotEmpty((CharSequence)nodeCode)) {
                queryWrapper.likeRight(ZyfxCatalogObject::getCatalogcode, (Object)nodeCode);
            }
            if (StrUtil.isNotBlank((CharSequence)schemeId)) {
                queryWrapper.eq(ZyfxCatalogObject::getSchemeid, (Object)schemeId);
            }
            queryWrapper.orderByAsc(ZyfxCatalogObject::getSort);
        }
        boolean bl2 = isNoValid = StrUtil.isBlank((CharSequence)(userId = this.iTokenService.queryCurrentSysUserId())) && (favorite != 2 || inCart != 2);
        if (isNoValid) {
            throw new BizException("\u672a\u67e5\u5230\u6b63\u786e\u7684\u7528\u6237\u4fe1\u606f");
        }
        if (StrUtil.isNotBlank((CharSequence)userId)) {
            if (favorite == 0) {
                queryWrapper.leftJoin(ZyfxFavorite.class, ZyfxFavorite::getObjectid, ZyfxObject::getId);
                queryWrapper.and(i -> {
                    MPJLambdaWrapper cfr_ignored_0 = (MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)i.ne(ZyfxFavorite::getUserid, (Object)userId)).or()).isNull(ZyfxFavorite::getUserid);
                });
            } else if (favorite == 1) {
                queryWrapper.leftJoin(ZyfxFavorite.class, ZyfxFavorite::getObjectid, ZyfxObject::getId);
                queryWrapper.eq(ZyfxFavorite::getUserid, (Object)userId);
            }
            if (inCart == 0) {
                queryWrapper.leftJoin(ZyfxCart.class, ZyfxCart::getObjectid, ZyfxObject::getId);
                queryWrapper.and(i -> {
                    MPJLambdaWrapper cfr_ignored_0 = (MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)i.ne(ZyfxCart::getUserid, (Object)userId)).or()).isNull(ZyfxCart::getUserid);
                });
            } else if (inCart == 1) {
                queryWrapper.leftJoin(ZyfxCart.class, ZyfxCart::getObjectid, ZyfxObject::getId);
                queryWrapper.eq(ZyfxCart::getUserid, (Object)userId);
            }
        }
        if ((listResults = (pageResults = this.selectJoinListPage((IPage)(pageT = new Page((long)page, (long)size)), ZyfxObject.class, (MPJBaseJoin)queryWrapper)).getRecords()).size() <= 0 || StrUtil.isNotBlank((CharSequence)filterParam)) {
            // empty if block
        }
        this.wrapperFavoriteAndCart(userId, listResults);
        this.wapperStInfo(listResults);
        if (haveDetail) {
            this.wrapperDetail(listResults, groupType);
        }
        return pageResults;
    }

    private int saveOneZyfxObject(ZyfxObject zyfxObject, InputStream inputStream, String tag) throws IOException {
        boolean isEdit;
        int iflag = 1;
        if (StringUtils.isEmpty((CharSequence)tag)) {
            tag = "dataset";
        }
        ZyfxObject oldZyfxObject = null;
        if (StrUtil.isNotBlank((CharSequence)zyfxObject.getId())) {
            oldZyfxObject = (ZyfxObject)this.getById((Serializable)((Object)zyfxObject.getId()));
        }
        boolean bl = isEdit = oldZyfxObject != null;
        if (isEdit) {
            zyfxObject.setStatus(oldZyfxObject.getStatus());
            zyfxObject.setCreatetime(oldZyfxObject.getCreatetime());
            zyfxObject.setAcount(oldZyfxObject.getAcount());
            zyfxObject.setImgid(oldZyfxObject.getImgid());
            iflag = 2;
        }
        if (inputStream != null) {
            String iconId = zyfxObject.getImgid();
            ZyfxImage zyfxImage = this.zyfxImageService.updateZyfxImage(iconId, inputStream, tag);
            zyfxObject.setImgid(zyfxImage.getId());
        }
        this.saveOrUpdate(zyfxObject);
        if (zyfxObject.getXmin() == null || zyfxObject.getXmax() == null || zyfxObject.getYmin() == null || zyfxObject.getYmax() != null) {
            // empty if block
        }
        return iflag;
    }

    @Override
    public String saveOneDataSet(ZyfxObject zyfxObject, ZyfxDataset zyfxDataset, InputStream inputStream) throws Exception {
        boolean isNew = this.saveOneZyfxObject(zyfxObject, inputStream, "dataset") == 1;
        zyfxDataset.setId(zyfxObject.getId());
        if (isNew) {
            zyfxDataset.setId(zyfxObject.getId());
        }
        if (isNew) {
            this.zyfxDatasetMapper.insert(zyfxDataset);
        } else {
            this.zyfxDatasetMapper.updateById(zyfxDataset);
        }
        return zyfxObject.getId();
    }

    @Override
    public String saveOneDataSet2(ZyfxObject zyfxObject, ZyfxDataset zyfxDataset, MultipartFile imgFile, MultipartFile[] otherfiles) throws Exception {
        boolean isNew = StrUtil.isBlank((CharSequence)zyfxObject.getId());
        InputStream inputStream = null;
        if (imgFile != null) {
            inputStream = imgFile.getInputStream();
        }
        String objectId = this.saveOneDataSet(zyfxObject, zyfxDataset, inputStream);
        this.zyfxFilesService.saveFiles(otherfiles, objectId, "dataset", true, false);
        if (isNew && zyfxObject.getLylx().equals("\u5171\u4eab\u6ce8\u518c")) {
            this.zyfxRegAvalService.addOneRegValRecord(objectId);
        }
        return objectId;
    }

    @Override
    public String saveOneServiceSet(ZyfxObject zyfxObject, ZyfxServiceset zyfxServiceset, InputStream inputStream) throws Exception {
        JSONArray jsonArray;
        JSONObject inputJson;
        boolean isNew;
        boolean bl = isNew = this.saveOneZyfxObject(zyfxObject, inputStream, "serviceset") == 1;
        if (isNew) {
            zyfxServiceset.setId(zyfxObject.getId());
        }
        if (StringUtils.isBlank((CharSequence)zyfxServiceset.getVirtualUrl())) {
            zyfxServiceset.setVirtualUrl(null);
        }
        if (isNew) {
            this.zyfxServicesetMapper.insert(zyfxServiceset);
        } else {
            this.zyfxServicesetMapper.updateById(zyfxServiceset);
        }
        LocalDateTime curLocalDateTime = LocalDateTime.now();
        if (zyfxServiceset.getApiList() != null && zyfxServiceset.getApiList().size() > 0) {
            for (int i = 0; i < zyfxServiceset.getApiList().size(); ++i) {
                ZyfxServicesetApi zyfxServicesetApi = zyfxServiceset.getApiList().get(i);
                if (StringUtils.isEmpty((CharSequence)zyfxServicesetApi.getId())) {
                    zyfxServicesetApi.setId(UUID.randomUUID().toString());
                    zyfxServicesetApi.setCreatetime(curLocalDateTime);
                }
                if (StringUtils.isEmpty((CharSequence)zyfxServicesetApi.getServicetype())) {
                    zyfxServicesetApi.setServicetype(zyfxObject.getGs());
                }
                zyfxServicesetApi.setObejctid(zyfxObject.getId());
                zyfxServicesetApi.setUpdatetime(curLocalDateTime);
                this.zyfxServicesetApiService.saveOrUpdate(zyfxServicesetApi);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)zyfxServiceset.getInputparams()) && zyfxServiceset.getInputparams().startsWith("{") && (inputJson = JSONObject.parseObject((String)zyfxServiceset.getInputparams())).containsKey((Object)"urls") && (jsonArray = inputJson.getJSONArray("urls")) != null && jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                ZyfxServicesetApi zyfxServicesetApi = new ZyfxServicesetApi();
                zyfxServicesetApi.setId(UUID.randomUUID().toString());
                zyfxServicesetApi.setObejctid(zyfxObject.getId());
                zyfxServicesetApi.setName(jsonObject.getString("name"));
                zyfxServicesetApi.setUrl(jsonObject.getString("url"));
                zyfxServicesetApi.setCreatetime(curLocalDateTime);
                this.zyfxServicesetApiService.saveOrUpdate(zyfxServicesetApi);
            }
        }
        this.zyfxServicesetApiService.deleteOldListByObjectId2time(zyfxObject.getId(), curLocalDateTime);
        this.proxyObjectService.updateProxyRoute(zyfxObject.getId());
        return zyfxObject.getId();
    }

    @Override
    public String saveOneServiceSet2(ZyfxObject zyfxObject, ZyfxServiceset zyfxServiceset, MultipartFile imgFile, MultipartFile[] otherfiles) throws Exception {
        boolean isNew = StrUtil.isEmpty((CharSequence)zyfxObject.getId());
        InputStream inputStream = null;
        if (imgFile != null) {
            inputStream = imgFile.getInputStream();
        }
        String objectId = this.saveOneServiceSet(zyfxObject, zyfxServiceset, inputStream);
        if (otherfiles != null) {
            this.zyfxFilesService.saveFiles(otherfiles, objectId, "dataset", true, false);
        }
        if (isNew && zyfxObject.getLylx().equals("\u5171\u4eab\u6ce8\u518c")) {
            this.zyfxRegAvalService.addOneRegValRecord(objectId);
        }
        return objectId;
    }

    @Override
    public String saveOneToolSet(ZyfxObject zyfxObject, ZyfxToolset zyfxToolset, InputStream inputStream) throws Exception {
        boolean isNew;
        boolean bl = isNew = this.saveOneZyfxObject(zyfxObject, inputStream, "toolset") == 1;
        if (isNew) {
            zyfxToolset.setId(zyfxObject.getId());
        }
        if (isNew) {
            this.zyfxToolsetMapper.insert(zyfxToolset);
        } else {
            this.zyfxToolsetMapper.updateById(zyfxToolset);
        }
        return zyfxObject.getId();
    }

    @Override
    public String saveOneToolSet2(ZyfxObject zyfxObject, ZyfxToolset zyfxToolset, MultipartFile imgFile, MultipartFile[] otherfiles) throws Exception {
        boolean isNew = StrUtil.isEmpty((CharSequence)zyfxObject.getId());
        InputStream inputStream = null;
        if (imgFile != null) {
            inputStream = imgFile.getInputStream();
        }
        String objectId = this.saveOneToolSet(zyfxObject, zyfxToolset, inputStream);
        if (otherfiles != null) {
            this.zyfxFilesService.saveFiles(otherfiles, objectId, "dataset", true, false);
        }
        if (isNew && zyfxObject.getLylx().equals("\u5171\u4eab\u6ce8\u518c")) {
            this.zyfxRegAvalService.addOneRegValRecord(objectId);
        }
        return objectId;
    }

    @Override
    public void moveDataNode(String catalogid, String objectid) {
        ZyfxCatalog catalogNode = (ZyfxCatalog)this.zyfxCatalogMapper.selectById((Serializable)((Object)catalogid));
        this.zyfxCatalogObjectService.moveByObjectId(catalogNode.getId(), catalogNode.getCode(), objectid, catalogNode.getSchemeid());
    }

    @Override
    public void logicDelObjectSets(String ids) {
        String[] objectIdArr;
        for (String objectId : objectIdArr = ids.split(",")) {
            this.removeById((Serializable)((Object)objectId));
            this.zyfxCatalogObjectService.removeByObjectId(objectId);
            ZyfxServiceset zyfxServiceset = (ZyfxServiceset)this.zyfxServicesetMapper.selectById((Serializable)((Object)objectId));
            if (zyfxServiceset == null) continue;
            zyfxServiceset.setVirtualUrl(null);
            this.zyfxServicesetMapper.updateById(zyfxServiceset);
        }
    }

    @Override
    public List<Map<String, Object>> dataBatchExport(Integer grouptype) {
        if (grouptype.equals(2)) {
            return ((ZyfxObjectMapper)this.getBaseMapper()).serviceBatchExport();
        }
        return ((ZyfxObjectMapper)this.getBaseMapper()).dataBatchExport();
    }

    @Override
    public void realDelete(String ids) {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return;
        }
        String[] objectIdArr = ids.split(",");
        List<String> idList = Arrays.asList(objectIdArr);
        ((ZyfxObjectMapper)this.getBaseMapper()).deleteBatchIds(idList);
        for (String objectId : idList) {
            this.zyfxCatalogObjectService.removeByObjectId(objectId);
        }
    }

    @Override
    public void toggleFavorite(String ids, boolean isFavorite) throws Exception {
        String currentUserId = this.iTokenService.queryCurrentSysUserId();
        if (StrUtil.isNotBlank((CharSequence)currentUserId)) {
            String[] idArr = ids.split(",");
            List<String> idList = Arrays.asList(idArr);
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.in(ZyfxFavorite::getObjectid, idList);
            queryWrapper.eq(ZyfxFavorite::getUserid, (Object)currentUserId);
            this.zyfxFavoriteMapper.delete((Wrapper)queryWrapper);
            if (isFavorite) {
                for (String objectId : idList) {
                    ZyfxFavorite zyfxFavorite = new ZyfxFavorite();
                    zyfxFavorite.setObjectid(objectId);
                    zyfxFavorite.setUserid(currentUserId);
                    this.zyfxFavoriteMapper.insert(zyfxFavorite);
                }
            }
        } else {
            throw new Exception("\u7cfb\u7edf\u672a\u767b\u5165");
        }
    }

    @Override
    public void toggleInCart(String ids, boolean isInCard) throws Exception {
        String currentUserId = this.iTokenService.queryCurrentSysUserId();
        if (StrUtil.isNotBlank((CharSequence)currentUserId)) {
            String[] idArr = ids.split(",");
            List<String> idList = Arrays.asList(idArr);
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.in(ZyfxCart::getObjectid, idList);
            queryWrapper.eq(ZyfxCart::getUserid, (Object)currentUserId);
            this.zyfxCartMapper.delete((Wrapper)queryWrapper);
            if (isInCard) {
                for (String objectId : idList) {
                    ZyfxCart zyfxCart = new ZyfxCart();
                    zyfxCart.setObjectid(objectId);
                    zyfxCart.setUserid(currentUserId);
                    this.zyfxCartMapper.insert(zyfxCart);
                }
            }
        } else {
            throw new Exception("\u7cfb\u7edf\u672a\u767b\u5165");
        }
    }

    @Override
    public void toggleApply(String ids, boolean isApply, String reason) throws Exception {
        String currentUserId = this.iTokenService.queryCurrentSysUserId();
        if (StrUtil.isNotBlank((CharSequence)currentUserId)) {
            String[] idArr = ids.split(",");
            List<String> idList = Arrays.asList(idArr);
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.in(ZyfxObjectApply::getObjectid, new Object[]{ids});
            queryWrapper.eq(ZyfxObjectApply::getUserid, (Object)currentUserId);
            if (isApply) {
                // empty if block
            }
        }
    }

    @Override
    public void toggleHot(String ids, boolean isHot) throws Exception {
        String[] idArr = ids.split(",");
        List<String> idList = Arrays.asList(idArr);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.in(ZyfxObject::getId, idList);
        List listResults = this.list((Wrapper)queryWrapper);
        listResults.stream().forEach(t -> {
            if (isHot) {
                t.setIsHot(1);
            } else {
                t.setIsHot(0);
            }
        });
        this.saveOrUpdateBatch(listResults);
    }

    @Override
    public ZyfxObjectDetail findDetailById(String id, boolean havaDataSet, boolean tempUrl) {
        try {
            SysUserDTO userDTO = null;
            userDTO = this.iTokenService.queryCurrentSysUserWithNull();
            return this.findDetailById(id, userDTO.getId(), havaDataSet, tempUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ZyfxObjectDetail findDetailById(String id, String userId, boolean havaDataSet, boolean tempUrl) {
        Serializable detail;
        ZyfxObject baseInfo = (ZyfxObject)this.getById((Serializable)((Object)id));
        if (baseInfo == null) {
            return null;
        }
        String currentUserId = null;
        try {
            currentUserId = this.iTokenService.queryCurrentSysUserId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.zyfxAccessService.addOneAccess(id, currentUserId);
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(ZyfxObject::getId, (Object)id);
        updateWrapper.set(ZyfxObject::getAcount, (Object)(baseInfo.getAcount() + 1L));
        this.update((Wrapper)updateWrapper);
        try {
            this.wrapperFavoriteAndCart(currentUserId, baseInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List zyfxObjectApplyList = new ArrayList();
        try {
            zyfxObjectApplyList = this.applyService.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ZyfxObjectApply.class).in(ZyfxObjectApply::getUserid, new Object[]{userId})).in(ZyfxObjectApply::getObjectid, new Object[]{id}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ZyfxObjectDetail zyfxObjectDetail = new ZyfxObjectDetail();
        zyfxObjectDetail.setBase(baseInfo);
        int groupType = baseInfo.getGrouptype();
        if (groupType == 1) {
            detail = (ZyfxDataset)this.zyfxDatasetMapper.selectById((Serializable)((Object)id));
            if (havaDataSet && StringUtils.isNotEmpty((CharSequence)((ZyfxDataset)detail).getDataid())) {
                DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(((ZyfxDataset)detail).getDataid());
                zyfxObjectDetail.setDataset(datasetDTO);
            }
            zyfxObjectDetail.setDetail(detail);
        } else if (groupType == 2) {
            List<ZyfxServicesetApi> apiList;
            detail = (ZyfxServiceset)this.zyfxServicesetMapper.selectById((Serializable)((Object)id));
            SysParamDTO api = this.sysParamsService.getDetail(SysParamGroupEnum.API.value, SysParamGroupEnum.API_PROXY_URL.value);
            String gkCodeStr = null;
            if (zyfxObjectApplyList != null && zyfxObjectApplyList.size() > 0) {
                List proxyObjectList;
                List proxyTokenList;
                List authorizeTokenList = this.authorizeMapper.selectList((Wrapper)Wrappers.lambdaQuery(AuthorizeToken.class).in(AuthorizeToken::getApplyid, new Object[]{((ZyfxObjectApply)zyfxObjectApplyList.get(0)).getId()}));
                if (authorizeTokenList != null && authorizeTokenList.size() > 0) {
                    gkCodeStr = ((AuthorizeToken)authorizeTokenList.get(0)).getToken();
                    String tURL = String.format("%s%s%sgk=%s", api.getValue(), ((AuthorizeToken)authorizeTokenList.get(0)).getRelativeUrl(), Character.valueOf(((AuthorizeToken)authorizeTokenList.get(0)).getRelativeUrl().contains("?") ? (char)'&' : '?'), gkCodeStr);
                    ((ZyfxServiceset)detail).setUrl(tURL);
                    ((ZyfxServiceset)detail).setIsTempUrl(false);
                    tempUrl = false;
                }
                if ((proxyTokenList = this.proxyTokenMapper.selectList((Wrapper)Wrappers.lambdaQuery(ProxyToken.class).in(ProxyToken::getObjectid, new Object[]{((ZyfxObjectApply)zyfxObjectApplyList.get(0)).getUserid()}))) != null && proxyTokenList.size() > 0 && (proxyObjectList = this.proxyObjectMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ProxyObject.class).in(ProxyObject::getServiceid, new Object[]{((ZyfxServiceset)detail).getId()})).in(ProxyObject::getToken, new Object[]{((ProxyToken)proxyTokenList.get(0)).getId()}))) != null && proxyObjectList.size() > 0) {
                    gkCodeStr = ((ProxyObject)proxyObjectList.get(0)).getToken();
                    String orgUrl = ((ZyfxServiceset)detail).getUrl();
                    String relPath = UnityUtils.getRealUrlUtil((String)orgUrl, (Integer)3);
                    String tURL = String.format("%s%s%sgk=%s", api.getValue(), relPath, Character.valueOf(relPath.contains("?") ? (char)'&' : '?'), gkCodeStr);
                    ((ZyfxServiceset)detail).setUrl(tURL);
                    ((ZyfxServiceset)detail).setIsTempUrl(false);
                    tempUrl = false;
                }
            }
            if (tempUrl && StrUtil.isNotBlank((CharSequence)((ZyfxServiceset)detail).getUrl())) {
                String tURL = ProxyUtil.queryTempProxyURL((String)((ZyfxServiceset)detail).getUrl());
                ((ZyfxServiceset)detail).setUrl(tURL);
                ((ZyfxServiceset)detail).setIsTempUrl(true);
            }
            boolean regCompleted = true;
            List zyfxRegAval = this.zyfxRegAvalMapper.selectList((Wrapper)Wrappers.lambdaQuery(ZyfxRegAval.class).in(ZyfxRegAval::getObjectid, new Object[]{((ZyfxServiceset)detail).getId()}));
            if (zyfxRegAval.size() > 0 && ((ZyfxRegAval)zyfxRegAval.get(0)).getAvalstatus() != 2) {
                regCompleted = false;
            }
            if (StrUtil.isNotEmpty((CharSequence)((ZyfxServiceset)detail).getInputparams()) && regCompleted && JsonParser.parseString((String)((ZyfxServiceset)detail).getInputparams()).isJsonObject()) {
                JSONObject objectInfo = JSON.parseObject((String)((ZyfxServiceset)detail).getInputparams());
                JSONArray jsonArray = objectInfo.getJSONArray("urls");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    try {
                        URI uri = new URI(jsonArray.getJSONObject(i).getString("url"));
                        jsonArray.getJSONObject(i).put("url", (Object)("http://ip:port" + uri.getPath()));
                        continue;
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
                ((ZyfxServiceset)detail).setInputparams(JSON.toJSONString((Object)objectInfo));
            }
            if ((apiList = this.zyfxServicesetApiService.getListByObjectId(id)) != null && apiList.size() > 0) {
                for (int i = 0; i < apiList.size(); ++i) {
                    ZyfxServicesetApi zyfxServicesetApi = apiList.get(i);
                    String orgUrl = zyfxServicesetApi.getUrl();
                    if (tempUrl && StrUtil.isNotBlank((CharSequence)orgUrl)) {
                        try {
                            URI uri = new URI(orgUrl);
                            zyfxServicesetApi.setUrl("http://ip:port" + uri.getPath());
                            zyfxServicesetApi.setIsTempUrl(true);
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (tempUrl || !StrUtil.isNotBlank((CharSequence)orgUrl)) continue;
                    String relPath = UnityUtils.getRealUrlUtil((String)orgUrl, (Integer)3);
                    String tURL = String.format("%s%s%sgk=%s", api.getValue(), relPath, Character.valueOf(relPath.contains("?") ? (char)'&' : '?'), gkCodeStr);
                    zyfxServicesetApi.setUrl(tURL);
                    zyfxServicesetApi.setIsTempUrl(false);
                }
            }
            ((ZyfxServiceset)detail).setApiList(apiList);
            zyfxObjectDetail.setDetail(detail);
        } else if (groupType == 3) {
            detail = (ZyfxToolset)this.zyfxToolsetMapper.selectById((Serializable)((Object)id));
            zyfxObjectDetail.setDetail(detail);
        }
        ZyfxObjectSt zyfxObjectSt = this.queryStInfo(id);
        zyfxObjectSt.setAccessCount(baseInfo.getAcount() + 1L);
        zyfxObjectDetail.setStInfo(zyfxObjectSt);
        List<ZyfxObject> recommends = ((ZyfxObjectMapper)this.getBaseMapper()).querySimilaryByName(baseInfo.getName(), baseInfo.getKeyword(), baseInfo.getGrouptype());
        zyfxObjectDetail.setRecommends(recommends);
        List<FldDicts> fldDicts = this.queryObjectRelFldDicts(id);
        zyfxObjectDetail.setFldDicts(fldDicts);
        List<ZyfxFiles> zyfxFiles = this.zyfxFilesService.queryZyfxFilesByObjectId(id, null);
        if (zyfxObjectApplyList != null && zyfxObjectApplyList.size() > 0) {
            if (((ZyfxObjectApply)zyfxObjectApplyList.get(0)).getCheckstatus() != 2) {
                zyfxFiles.forEach(p -> p.setUrl(null));
            }
        } else {
            zyfxFiles.forEach(p -> p.setUrl(null));
        }
        zyfxObjectDetail.setFiles(zyfxFiles);
        return zyfxObjectDetail;
    }

    @Override
    public ZyfxObjectDetail findDetailWithOriUrlById(String id, boolean havaDataSet) {
        Serializable detail;
        ZyfxObject baseInfo = (ZyfxObject)this.getById((Serializable)((Object)id));
        if (baseInfo == null) {
            return null;
        }
        String currentUserId = null;
        try {
            currentUserId = this.iTokenService.queryCurrentSysUserId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ZyfxObjectDetail zyfxObjectDetail = new ZyfxObjectDetail();
        zyfxObjectDetail.setBase(baseInfo);
        int groupType = baseInfo.getGrouptype();
        if (groupType == 1) {
            detail = (ZyfxDataset)this.zyfxDatasetMapper.selectById((Serializable)((Object)id));
            if (havaDataSet && StringUtils.isNotEmpty((CharSequence)((ZyfxDataset)detail).getDataid())) {
                DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(((ZyfxDataset)detail).getDataid());
                zyfxObjectDetail.setDataset(datasetDTO);
            }
            zyfxObjectDetail.setDetail(detail);
        } else if (groupType == 2) {
            detail = (ZyfxServiceset)this.zyfxServicesetMapper.selectById((Serializable)((Object)id));
            List<ZyfxServicesetApi> apiList = this.zyfxServicesetApiService.getListByObjectId(id);
            ((ZyfxServiceset)detail).setApiList(apiList);
            zyfxObjectDetail.setDetail(detail);
        } else if (groupType == 3) {
            detail = (ZyfxToolset)this.zyfxToolsetMapper.selectById((Serializable)((Object)id));
            zyfxObjectDetail.setDetail(detail);
        }
        List<ZyfxFiles> zyfxFiles = this.zyfxFilesService.queryZyfxFilesByObjectId(id, null);
        zyfxObjectDetail.setFiles(zyfxFiles);
        return zyfxObjectDetail;
    }

    @Override
    public List<ZyfxObject> frequencyKeywords(Integer groupType) {
        return ((ZyfxObjectMapper)this.getBaseMapper()).queryKeywords(groupType);
    }

    @Override
    public List<ZyfxObject> frequencyKeywords(Integer groupType, Integer isapplication) {
        return ((ZyfxObjectMapper)this.getBaseMapper()).queryKeywordsByToolset(groupType, isapplication);
    }

    @Override
    public List<ZyfxObject> queryHots(String filterParam, Integer groupType, String schemeId, Integer isApplication, int maxCount) throws Exception {
        String sortParam = "SORT_isHot_DESC;SORT_acount_DESC";
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, sortParam, ZyfxObject.class);
        if (StrUtil.isNotBlank((CharSequence)schemeId)) {
            queryWrapper.leftJoin(ZyfxCatalogObject.class, ZyfxCatalogObject::getObjectid, ZyfxObject::getId);
            queryWrapper.eq(ZyfxCatalogObject::getSchemeid, (Object)schemeId);
        }
        if (groupType > 0) {
            if (groupType == 3 && isApplication != null) {
                queryWrapper.leftJoin(ZyfxToolset.class, "zt", ZyfxToolset::getId, ZyfxObject::getId);
                queryWrapper.eq(ZyfxToolset::getIsapplication, (Object)isApplication);
            }
            queryWrapper.eq(ZyfxObject::getGrouptype, (Object)groupType);
        }
        queryWrapper.last(" limit " + maxCount);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public boolean existsByOid(String oid) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxObject::getOid, (Object)oid);
        long icount = this.count((Wrapper)queryWrapper);
        return icount > 0L;
    }

    @Override
    public List<String> findOids() {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.select(new SFunction[]{ZyfxObject::getOid});
        List objectList = this.list((Wrapper)queryWrapper);
        ArrayList<String> oidList = new ArrayList<String>();
        for (ZyfxObject obj : objectList) {
            if (obj == null || oidList.contains(obj.getOid())) continue;
            oidList.add(obj.getOid());
        }
        return oidList;
    }

    @Override
    public boolean existsByOidAndLb(String oid, String lb) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxObject::getOid, (Object)oid);
        queryWrapper.eq(ZyfxObject::getLb, (Object)lb);
        long icount = this.count((Wrapper)queryWrapper);
        return icount > 0L;
    }

    @Override
    public ZyfxObject findOneNoDelete(String id) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxObject::getId, (Object)id);
        queryWrapper.last(" limit 1");
        return (ZyfxObject)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public IPage<ZyfxObject> spatialSeach(String mapno, String range, String xzqdm, String wkt, String schemeId, String catalogIds, int groupType, String filterParam, String sortParam, int page, int size) throws Exception {
        Page pageT;
        IPage pageResults;
        List listResults;
        DistrictItemDTO defaultDistrictItem;
        DistrictItemDTO districtItemDTO;
        String[] rangeArr;
        GeoJfb geoJfb;
        double xmin = 180.0;
        double ymin = 90.0;
        double xmax = -180.0;
        double ymax = -90.0;
        boolean isRangeExists = false;
        if (StrUtil.isNotBlank((CharSequence)mapno) && (geoJfb = this.geoJfbService.findByMapNo(mapno)) != null) {
            xmin = geoJfb.getMinl();
            ymin = geoJfb.getMinb();
            xmax = geoJfb.getMaxl();
            ymax = geoJfb.getMaxb();
            isRangeExists = true;
        }
        if (StrUtil.isNotBlank((CharSequence)range) && (rangeArr = range.split(";")).length == 4) {
            double xminT = Double.parseDouble(rangeArr[0]);
            double yminT = Double.parseDouble(rangeArr[1]);
            double xmaxT = Double.parseDouble(rangeArr[2]);
            double ymaxT = Double.parseDouble(rangeArr[3]);
            xmin = xminT < xmin ? xminT : xmin;
            ymin = yminT < ymin ? yminT : ymin;
            xmax = xmaxT > xmax ? xmaxT : xmax;
            ymax = ymaxT > ymax ? ymaxT : ymax;
            isRangeExists = true;
        }
        if (StrUtil.isNotBlank((CharSequence)xzqdm) && (districtItemDTO = this.districtService.getDistrictItemDetail((defaultDistrictItem = this.districtService.getDefaultDistrictItem(null)).getDistrictId(), xzqdm)) != null) {
            double xminT = districtItemDTO.getExtent().getXmin();
            double yminT = districtItemDTO.getExtent().getYmin();
            double xmaxT = districtItemDTO.getExtent().getXmax();
            double ymaxT = districtItemDTO.getExtent().getYmax();
            xmin = xminT < xmin ? xminT : xmin;
            ymin = yminT < ymin ? yminT : ymin;
            xmax = xmaxT > xmax ? xmaxT : xmax;
            ymax = ymaxT > ymax ? ymaxT : ymax;
            isRangeExists = true;
        }
        if (StrUtil.isEmpty((CharSequence)sortParam)) {
            sortParam = "SORT_id_DESC";
        }
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, sortParam, ZyfxObject.class);
        queryWrapper.leftJoin(ZyfxCatalogObject.class, ZyfxCatalogObject::getObjectid, ZyfxObject::getId);
        if (groupType > 0) {
            queryWrapper.eq(ZyfxObject::getGrouptype, (Object)groupType);
        }
        queryWrapper.eq(ZyfxCatalogObject::getSchemeid, (Object)schemeId);
        if (StringUtils.isNotEmpty((CharSequence)catalogIds)) {
            Object[] catalogIdsArray = catalogIds.split(",");
            queryWrapper.in(ZyfxCatalogObject::getCatalogid, catalogIdsArray);
        }
        if (isRangeExists) {
            double finalXmin = xmin;
            double finalYmin = ymin;
            double finalXmax = xmax;
            double finalYmax = ymax;
            queryWrapper.not(sub -> {
                MPJLambdaWrapper cfr_ignored_0 = (MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)((MPJLambdaWrapper)sub.gt(ZyfxObject::getXmin, (Object)finalXmax)).or()).gt(ZyfxObject::getYmin, (Object)finalYmax)).or()).lt(ZyfxObject::getXmax, (Object)finalXmin)).or()).lt(ZyfxObject::getYmax, (Object)finalYmin);
            });
        }
        if (StrUtil.isNotBlank((CharSequence)wkt)) {
            queryWrapper.apply("ST_Intersects(ST_GeomFromText({0}), ST_MakeEnvelope(f_xmin, f_ymin, f_xmax, f_ymax))", new Object[]{wkt});
        }
        if ((listResults = (pageResults = this.page((IPage)(pageT = new Page((long)page, (long)size)), (Wrapper)queryWrapper)).getRecords()).size() <= 0 || StrUtil.isNotBlank((CharSequence)filterParam)) {
            // empty if block
        }
        String userId = this.iTokenService.queryCurrentSysUserId();
        this.wrapperFavoriteAndCart(userId, listResults);
        this.wapperStInfo(listResults);
        return pageResults;
    }

    @Override
    public List<String> uploadTemplate(String type, MultipartFile file, String nodeId, String schemeId) {
        ArrayList<String> errorMessageList = new ArrayList<String>();
        try {
            HashMap<String, String> mapRelation = new HashMap<String, String>();
            mapRelation.put("\u8d44\u6e90\u6807\u8bc6", "bsm");
            mapRelation.put("\u670d\u52a1\u540d\u79f0", "name");
            mapRelation.put("\u670d\u52a1\u522b\u540d", "alias");
            mapRelation.put("\u670d\u52a1\u7b80\u79f0", "shortname");
            mapRelation.put("\u6458\u8981", "abstractZ");
            mapRelation.put("\u5173\u952e\u8bcd", "keyword");
            mapRelation.put("\u8d44\u6e90\u4e3b\u9898", "zyzt");
            mapRelation.put("\u4e1a\u52a1\u7c7b\u522b", "ywlb");
            mapRelation.put("\u670d\u52a1\u7c7b\u522b", "lb");
            mapRelation.put("\u670d\u52a1\u683c\u5f0f", "gs");
            mapRelation.put("\u670d\u52a1\u5bb9\u91cf", "fwrl");
            mapRelation.put("\u8bbf\u95ee\u5730\u5740", "url");
            mapRelation.put("\u8986\u76d6\u8303\u56f4", "fgfw");
            mapRelation.put("\u884c\u653f\u533a\u5212", "xzqmc");
            mapRelation.put("\u5750\u6807\u7cfb", "srs");
            mapRelation.put("\u6295\u5f71\u65b9\u5f0f", "prj");
            mapRelation.put("\u9ad8\u7a0b\u57fa\u51c6", "gcjz");
            mapRelation.put("\u56db\u81f3-\u4e1c", "xmax");
            mapRelation.put("\u56db\u81f3-\u5357", "ymin");
            mapRelation.put("\u56db\u81f3-\u897f", "xmin");
            mapRelation.put("\u56db\u81f3-\u5317", "ymax");
            mapRelation.put("\u5206\u8fa8\u7387", "kjfbl");
            mapRelation.put("\u6bd4\u4f8b\u5c3a", "scales");
            mapRelation.put("\u91c7\u96c6\u8bbe\u5907", "cjsb");
            mapRelation.put("\u66f4\u65b0\u9891\u6b21", "gxpc");
            mapRelation.put("\u66f4\u65b0\u5468\u671f", "gxpc");
            mapRelation.put("\u5efa\u8bbe\u65f6\u95f4", "jssj");
            mapRelation.put("\u6ce8\u518c\u65f6\u95f4", "zcsj");
            mapRelation.put("\u53d1\u5e03\u65f6\u95f4", "fbsj");
            mapRelation.put("\u670d\u52a1\u6765\u6e90", "lylx");
            mapRelation.put("\u4e1a\u52a1\u540d\u79f0", "ywmc");
            mapRelation.put("\u4e1a\u52a1\u7f16\u7801", "ywbm");
            mapRelation.put("\u4e3b\u7ba1\u90e8\u95e8", "zgdw");
            mapRelation.put("\u5efa\u8bbe\u5355\u4f4d", "jsdw");
            mapRelation.put("\u6ce8\u518c\u5355\u4f4d", "hjdw");
            mapRelation.put("\u5171\u4eab\u7c7b\u578b", "gxlx");
            mapRelation.put("\u516c\u5f00\u7c7b\u578b", "kflx");
            mapRelation.put("\u83b7\u53d6\u65b9\u5f0f", "hqfs");
            mapRelation.put("\u5b89\u5168\u7ea7\u522b", "aqjb");
            mapRelation.put("\u8054\u7cfb\u4eba", "lxr");
            mapRelation.put("\u8054\u7cfb\u65b9\u5f0f", "lxfs");
            mapRelation.put("\u670d\u52a1\u7248\u672c", "version");
            mapRelation.put("\u66f4\u65b0\u65f6\u95f4", "gxsj");
            mapRelation.put("\u66f4\u65b0\u4eba", "gxr");
            mapRelation.put("\u66f4\u65b0\u8bf4\u660e", "gxsm");
            mapRelation.put("\u751f\u4ea7\u65e5\u671f", "scsj");
            mapRelation.put("\u76ee\u5f55\u7684\u6570\u636e\u5b58\u50a8\u603b\u91cf(G)", "otherparams");
            mapRelation.put("\u7ed3\u6784\u5316\u4fe1\u606f\u8bb0\u5f55\u603b\u6570\uff08\u4e07\uff09", "otherparams");
            mapRelation.put("\u5df2\u5171\u4eab\u7684\u6570\u636e\u5b58\u50a8\u91cf\uff08G\uff09", "otherparams");
            mapRelation.put("\u5df2\u5171\u4eab\u7ed3\u6784\u5316\u8bb0\u5f55\u6570\uff08\u4e07\uff09", "otherparams");
            mapRelation.put("\u5df2\u5f00\u653e\u7684\u6570\u636e\u5b58\u50a8\u91cf\uff08G\uff09", "otherparams");
            mapRelation.put("\u5df2\u5f00\u653e\u7ed3\u6784\u5316\u8bb0\u5f55\u6570\uff08\u4e07\uff09", "otherparams");
            mapRelation.put("\u6570\u636e\u6240\u5c5e\u9886\u57df", "otherparams");
            mapRelation.put("\u6570\u636e\u6765\u6e90\u4e8b\u9879\u57fa\u672c\u76ee\u5f55\u540d\u79f0", "otherparams");
            mapRelation.put("\u6570\u636e\u6765\u6e90\u4e8b\u9879\u57fa\u672c\u76ee\u5f55\u7f16\u7801", "otherparams");
            mapRelation.put("\u6570\u636e\u6240\u5728\u5c42\u7ea7", "otherparams");
            mapRelation.put("\u6570\u636e\u76ee\u5f55\u5171\u4eab\u6761\u4ef6", "otherparams");
            mapRelation.put("\u6570\u636e\u76ee\u5f55\u5f00\u653e\u6761\u4ef6", "otherparams");
            mapRelation.put("\u6570\u636e\u5206\u7ea7", "otherparams");
            mapRelation.put("\u6570\u636e\u6765\u6e90\u4e8b\u9879\u5b9e\u65bd\u6e05\u5355\u540d\u79f0", "otherparams");
            mapRelation.put("\u6570\u636e\u6765\u6e90\u4e8b\u9879\u5b9e\u65bd\u6e05\u5355\u7f16\u7801", "otherparams");
            mapRelation.put("\u6570\u636e\u5173\u8054\u4e8b\u9879\u57fa\u672c\u76ee\u5f55\u540d\u79f0", "otherparams");
            mapRelation.put("\u6570\u636e\u5173\u8054\u4e8b\u9879\u57fa\u672c\u76ee\u5f55\u7f16\u7801", "otherparams");
            mapRelation.put("\u6570\u636e\u52a0\u5de5\u7a0b\u5ea6", "otherparams");
            mapRelation.put("\u662f\u5426\u53d1\u5e03", "otherparams");
            mapRelation.put("\u76ee\u5f55\u6807\u7b7e", "otherparams");
            mapRelation.put("\u5e94\u7528\u573a\u666f", "otherparams");
            mapRelation.put("\u63d0\u4f9b\u6e20\u9053", "otherparams");
            mapRelation.put("\u662f\u5426\u56de\u6d41\u5730\u5e02\uff08\u5dde\uff09", "otherparams");
            mapRelation.put("\u56de\u6d41\u662f\u5426\u80fd\u533a\u5206\u5730\u5e02\uff08\u5dde\uff09", "otherparams");
            mapRelation.put("\u6570\u636e\u540d\u79f0", "name");
            mapRelation.put("\u6570\u636e\u7c7b\u522b", "lb");
            mapRelation.put("\u6570\u636e\u683c\u5f0f", "gs");
            mapRelation.put("\u6570\u636e\u91cf\uff08MB\uff09", "sjl");
            mapRelation.put("\u6587\u4ef6/\u8bb0\u5f55\u6570", "wjs");
            mapRelation.put("\u7a7a\u95f4\u5206\u8fa8\u7387", "kjfbl");
            mapRelation.put("\u91c7\u96c6\u8bbe\u5907", "cjsb");
            mapRelation.put("\u66f4\u65b0\u9891\u6b21", "gxpc");
            mapRelation.put("\u66f4\u65b0\u9891\u6b21\u63cf\u8ff0", "gxpcms");
            mapRelation.put("\u6570\u636e\u7248\u672c", "version");
            mapRelation.put("\u6c47\u4ea4\u65f6\u95f4", "hjtime");
            mapRelation.put("\u6570\u636e\u6765\u6e90", "lylx");
            mapRelation.put("\u9879\u76ee\u540d\u79f0", "xmmc");
            mapRelation.put("\u9879\u76ee\u7f16\u53f7", "xmbh");
            mapRelation.put("\u751f\u4ea7\u5355\u4f4d", "scdw");
            mapRelation.put("\u6c47\u4ea4\u5355\u4f4d", "hjdw");
            mapRelation.put("\u4fe1\u606f\u8d44\u6e90\u683c\u5f0f\u7c7b\u578b", "xxzygslx");
            mapRelation.put("\u5176\u4ed6\u7c7b\u578b\u8d44\u6e90\u683c\u5f0f\u63cf\u8ff0", "xxzygsms");
            mapRelation.put("\u5171\u4eab\u6761\u4ef6", "gxtj");
            mapRelation.put("\u5f00\u653e\u6761\u4ef6", "kftj");
            mapRelation.put("\u6570\u636e\u65f6\u95f4\u8303\u56f4", "sjfw");
            List<String> keys = Arrays.asList("\u6570\u636e\u540d\u79f0", "\u8d44\u6e90\u6807\u8bc6", "\u6458\u8981", "\u5173\u952e\u8bcd", "\u4e1a\u52a1\u7c7b\u522b", "\u6570\u636e\u7c7b\u522b", "\u6570\u636e\u683c\u5f0f", "\u4fe1\u606f\u8d44\u6e90\u683c\u5f0f\u7c7b\u578b", "\u6570\u636e\u91cf", "\u8986\u76d6\u8303\u56f4", "\u66f4\u65b0\u5468\u671f", "\u6570\u636e\u7248\u672c", "\u6c47\u4ea4\u65f6\u95f4", "\u53d1\u5e03\u65f6\u95f4", "\u6570\u636e\u6765\u6e90", "\u5171\u4eab\u7c7b\u578b", "\u516c\u5f00\u7c7b\u578b", "\u83b7\u53d6\u65b9\u5f0f", "\u5b89\u5168\u7ea7\u522b", "\u6570\u636e\u6240\u5c5e\u9886\u57df", "\u6570\u636e\u6240\u5728\u5c42\u7ea7");
            ArrayList<Integer> keyIndex = new ArrayList<Integer>();
            InputStream inputStream = null;
            if (file != null) {
                inputStream = file.getInputStream();
            }
            XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
            XSSFSheet sheet = workbook.getSheetAt(0);
            HashMap hashMap = new HashMap();
            XSSFRow titleRow = sheet.getRow(0);
            Integer pathindex = -1;
            for (int i = 0; i < titleRow.getLastCellNum(); ++i) {
                String name = titleRow.getCell(i).toString();
                if (mapRelation.containsKey(name)) {
                    hashMap.put(i, mapRelation.get(name));
                }
                if (name.equals("\u5206\u7c7b\u76ee\u5f55")) {
                    pathindex = i;
                }
                if (!keys.contains(name)) continue;
                keyIndex.add(i);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            HashMap<String, String> lbMap = new HashMap<String, String>();
            lbMap.put("\u67e5\u8be2\u6838\u9a8c", "verification");
            lbMap.put("\u7535\u5b50\u8bc1\u7167", "elecLicense");
            lbMap.put("\u57fa\u7840\u5e95\u56fe", "basemap");
            lbMap.put("\u5730\u56fe\u670d\u52a1", "mapservice");
            lbMap.put("\u5730\u56fe\u7ec4\u4ef6", "mapcomponent");
            lbMap.put("\u5206\u6790\u670d\u52a1", "analysisservice");
            lbMap.put("\u7edf\u8ba1\u670d\u52a1", "statisticalservice");
            lbMap.put("\u914d\u53f7\u670d\u52a1", "allocationservice");
            lbMap.put("\u7cfb\u7edf\u5bf9\u63a5", "systemdocking");
            lbMap.put("\u5176\u4ed6\u670d\u52a1", "otherservice");
            lbMap.put("\u5730\u56fe", "map");
            lbMap.put("\u8bc1\u7167", "licence");
            lbMap.put("\u5e93\u8868", "dbtalbe");
            lbMap.put("\u6587\u4ef6", "file");
            lbMap.put("\u6587\u4ef6\u5939", "folder");
            lbMap.put("\u5176\u4ed6", "other");
            HashMap<String, Integer> fgfwMap = new HashMap<String, Integer>();
            fgfwMap.put("\u5168\u7403", 1);
            fgfwMap.put("\u5168\u56fd", 2);
            fgfwMap.put("\u5168\u7701", 3);
            fgfwMap.put("\u7701\u672c\u7ea7", 4);
            fgfwMap.put("\u5404\u5730\u5e02", 5);
            fgfwMap.put("\u5168\u5e02", 6);
            fgfwMap.put("\u5404\u53bf\uff08\u533a\uff09", 7);
            fgfwMap.put("\u5168\u53bf\uff08\u533a\uff09", 8);
            fgfwMap.put("\u5176\u4ed6", 9);
            HashMap<String, Integer> gxpcMap = new HashMap<String, Integer>();
            gxpcMap.put("\u6bcf\u5e74", 1);
            gxpcMap.put("\u6bcf\u5b63\u5ea6", 2);
            gxpcMap.put("\u6bcf\u6708", 3);
            gxpcMap.put("\u6bcf\u5468", 4);
            gxpcMap.put("\u6bcf\u65e5", 5);
            gxpcMap.put("\u5b9e\u65f6", 6);
            gxpcMap.put("\u6309\u9700", 7);
            gxpcMap.put("\u5176\u4ed6", 8);
            for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
                try {
                    XSSFRow row = sheet.getRow(i);
                    if (row.getCell(1) == null && row.getCell(2) == null) continue;
                    JSONObject kzxxJson = new JSONObject();
                    JSONObject jsonObj = new JSONObject();
                    boolean lackKey = false;
                    block45: for (Map.Entry entry : hashMap.entrySet()) {
                        String value;
                        String string = value = row.getCell(((Integer)entry.getKey()).intValue()) == null ? null : row.getCell(((Integer)entry.getKey()).intValue()).toString();
                        if (((String)entry.getValue()).equals("otherparams") && !StringUtils.isEmpty((CharSequence)value)) {
                            kzxxJson.put(titleRow.getCell(((Integer)entry.getKey()).intValue()).toString(), (Object)row.getCell(((Integer)entry.getKey()).intValue()).toString());
                            continue;
                        }
                        if (keyIndex.contains(entry.getKey()) && StringUtils.isEmpty((CharSequence)value)) {
                            errorMessageList.add("\u7b2c" + i + "\u884c\u5165\u5e93\u5931\u8d25\uff0c\u5173\u952e\u5b57 " + sheet.getRow(0).getCell(((Integer)entry.getKey()).intValue()) + " \u672a\u586b\u5199\uff01");
                            lackKey = true;
                            continue;
                        }
                        if (StringUtils.isEmpty((CharSequence)value)) continue;
                        switch ((String)entry.getValue()) {
                            case "sjfw": {
                                String[] times = value.split("-");
                                if (times.length > 0 && times[0].contains(".")) {
                                    jsonObj.put((String)entry.getValue(), (Object)times[0].replace(".", "-"));
                                }
                                if (times.length <= 1 || !times[1].contains(".")) continue block45;
                                jsonObj.put("sjfwjs", (Object)times[1].replace(".", "-"));
                                continue block45;
                            }
                            case "gxlx": {
                                jsonObj.put((String)entry.getValue(), (Object)(value.equals("\u65e0\u6761\u4ef6\u5171\u4eab") ? 1 : (value.equals("\u6709\u6761\u4ef6\u5171\u4eab") ? 2 : 3)));
                                continue block45;
                            }
                            case "kflx": {
                                jsonObj.put((String)entry.getValue(), (Object)(value.equals("\u65e0\u6761\u4ef6\u5f00\u653e") ? 1 : (value.equals("\u6709\u6761\u4ef6\u5f00\u653e") ? 2 : 3)));
                                continue block45;
                            }
                            case "fgfw": {
                                jsonObj.put((String)entry.getValue(), (Object)(fgfwMap.containsKey(value.toString()) ? fgfwMap.get(value).toString() : value));
                                continue block45;
                            }
                            case "gxpc": {
                                jsonObj.put((String)entry.getValue(), (Object)(gxpcMap.containsKey(value.toString()) ? gxpcMap.get(value).toString() : value));
                                continue block45;
                            }
                            case "lb": {
                                jsonObj.put((String)entry.getValue(), (Object)(lbMap.containsKey(value.toString()) ? lbMap.get(value).toString() : value));
                                continue block45;
                            }
                            case "gs": {
                                jsonObj.put((String)entry.getValue(), (Object)(value.equals("\u77e2\u91cf") ? "ShapeFile" : (value.equals("\u6805\u683c") ? "Tif" : (value.equals("\u4e09\u7ef4") ? "ModelDataset" : (value.equals("\u56fe\u7247") ? "Picture" : (value.equals("\u6587\u6863") ? "DatumDataset" : (value.equals("\u8868\u683c") ? "Table" : (value.equals("\u89c6\u9891") ? "Video" : (value.equals("\u6570\u636e\u5e93") ? "FeatureClass" : "Other")))))))));
                                continue block45;
                            }
                            case "xzqmc": {
                                jsonObj.put((String)entry.getValue(), (Object)value);
                                List dmDistrictItemList = this.dmDistrictItemDao.selectByPId(null, null, value);
                                if (dmDistrictItemList.size() <= 0) continue block45;
                                jsonObj.put("xzqdm", (Object)((DmDistrictItem)dmDistrictItemList.get(0)).getCode());
                                continue block45;
                            }
                            case "scsj": 
                            case "jssj": 
                            case "zcsj": 
                            case "fbsj": 
                            case "gxsj": 
                            case "hjtime": {
                                jsonObj.put((String)entry.getValue(), (Object)row.getCell(((Integer)entry.getKey()).intValue()).toString().replace(".", "-"));
                                continue block45;
                            }
                            case "lxfs": {
                                jsonObj.put((String)entry.getValue(), (Object)value);
                                continue block45;
                            }
                        }
                        jsonObj.put((String)entry.getValue(), value.matches("^[0-9]+$") ? Integer.valueOf(Integer.parseInt(value)) : (value.matches("^[+-]?[0-9]+(\\.[0-9]+)?([eE][+-]?[0-9]+)?$") ? Double.valueOf(Double.parseDouble(value)) : value));
                    }
                    if (lackKey) continue;
                    ZyfxCatalog catalogNode = new ZyfxCatalog();
                    catalogNode.setId("-1");
                    catalogNode.setSchemeid(schemeId);
                    catalogNode.setGrouptype(Integer.parseInt(type));
                    catalogNode.setNodetype(0);
                    if (pathindex != -1) {
                        for (String nodename : row.getCell(pathindex.intValue()).toString().split(Pattern.quote("/"))) {
                            catalogNode = this.addNode(catalogNode, nodename);
                        }
                    }
                    nodeId = catalogNode.getId();
                    ObjectMapper objectMapper = new ObjectMapper();
                    objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    ZyfxObject zyfxObject = (ZyfxObject)objectMapper.readValue(jsonObj.toString(), ZyfxObject.class);
                    zyfxObject.setGrouptype(Integer.parseInt(type));
                    zyfxObject.setFbsj(new Date());
                    JSONObject otherJson = new JSONObject();
                    otherJson.put("kzxxData", (Object)kzxxJson.toString());
                    switch (type) {
                        case "1": {
                            ZyfxDataset zyfxDataset = (ZyfxDataset)objectMapper.readValue(jsonObj.toString(), ZyfxDataset.class);
                            zyfxDataset.setOtherparams(otherJson.toString());
                            String dataId = this.saveOneDataSet2(zyfxObject, zyfxDataset, null, null);
                            this.zyfxCatalogObjectService.saveIfNotExists(catalogNode.getSchemeid(), nodeId, dataId, catalogNode.getCode(), 1);
                            break;
                        }
                        case "2": {
                            ZyfxServiceset zyfxServiceset = (ZyfxServiceset)objectMapper.readValue(jsonObj.toString(), ZyfxServiceset.class);
                            zyfxServiceset.setOtherparams(otherJson.toString());
                            String serviceId = this.saveOneServiceSet2(zyfxObject, zyfxServiceset, null, null);
                            this.zyfxCatalogObjectService.saveIfNotExists(catalogNode.getSchemeid(), nodeId, serviceId, catalogNode.getCode(), 2);
                            break;
                        }
                        case "3": {
                            ZyfxToolset zyfxToolset = (ZyfxToolset)objectMapper.readValue(jsonObj.toString(), ZyfxToolset.class);
                            String toolId = this.saveOneToolSet2(zyfxObject, zyfxToolset, null, null);
                            this.zyfxCatalogObjectService.saveIfNotExists(catalogNode.getSchemeid(), nodeId, toolId, catalogNode.getCode(), 3);
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errorMessageList.add("\u7b2c" + i + "\u884c\u5165\u5e93\u5931\u8d25\uff0c" + e.getMessage());
                }
            }
            return errorMessageList;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorMessageList.add("\u5165\u5e93\u5931\u8d25\uff0c" + e.getMessage());
            return errorMessageList;
        }
    }

    private ZyfxCatalog addNode(ZyfxCatalog parentNode, String nodeName) {
        ZyfxCatalog zyfxCatalog = new ZyfxCatalog();
        zyfxCatalog.setPid(parentNode.getId());
        zyfxCatalog.setName(nodeName);
        zyfxCatalog.setSchemeid(parentNode.getSchemeid());
        zyfxCatalog.setNodetype(parentNode.getNodetype());
        zyfxCatalog.setGrouptype(parentNode.getGrouptype());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxCatalog::getName, (Object)zyfxCatalog.getName());
        queryWrapper.eq(ZyfxCatalog::getPid, (Object)zyfxCatalog.getPid());
        List zyfxCatalogList = this.zyfxCatalogMapper.selectList((Wrapper)queryWrapper);
        if (zyfxCatalogList.size() > 0) {
            return (ZyfxCatalog)zyfxCatalogList.get(0);
        }
        Long id = IdUtil.getSnowflakeNextId();
        zyfxCatalog.setId(id.toString());
        String maxNodeCode = this.zyfxCatalogMapper.queryMaxNodeCode(parentNode.getId());
        String nodeCode = null;
        int level = 0;
        if (StrUtil.isNotEmpty((CharSequence)maxNodeCode)) {
            int start = maxNodeCode.lastIndexOf("-");
            String addCode = maxNodeCode.substring(start + 1);
            String pNodeCode = maxNodeCode.substring(0, start == -1 ? maxNodeCode.length() : start);
            int iCode = Integer.parseInt(addCode);
            nodeCode = String.format("%s-%d", pNodeCode, iCode + 1);
        } else if (parentNode.getId() == "-1") {
            level = 1;
            nodeCode = String.format("%s%s-%d", parentNode.getSchemeid(), -1, 10000);
        } else {
            nodeCode = String.format("%s-%d", parentNode.getCode(), 10000);
            if (parentNode.getLevel() != null) {
                level = parentNode.getLevel() + 1;
            }
        }
        zyfxCatalog.setCode(nodeCode);
        zyfxCatalog.setLevel(level);
        long order = this.queryMaxSort(parentNode.getId(), zyfxCatalog.getSchemeid()) + 1L;
        zyfxCatalog.setSort((int)order);
        this.zyfxCatalogMapper.insert(zyfxCatalog);
        return zyfxCatalog;
    }

    private long queryMaxSort(String pid, String schemeId) {
        String aliasname = "maxsort";
        MPJLambdaWrapper queryWrapper = new MPJLambdaWrapper();
        ((MPJLambdaWrapper)((MPJLambdaWrapper)queryWrapper.selectMax(ZyfxCatalog::getSort, aliasname)).eq(ZyfxCatalog::getPid, (Object)pid)).eq(ZyfxCatalog::getSchemeid, (Object)schemeId);
        Map mapResult = (Map)this.zyfxCatalogMapper.selectMaps((Wrapper)queryWrapper).get(0);
        long maxSort = 0L;
        if (mapResult != null && mapResult.containsKey(aliasname)) {
            maxSort = mapResult.get(aliasname) == null ? 0L : (Long)mapResult.get(aliasname);
        }
        return maxSort;
    }

    private ZyfxObjectSt queryStInfo(String objectId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxFavorite::getObjectid, (Object)objectId);
        long favoriteCount = this.zyfxFavoriteMapper.selectCount((Wrapper)queryWrapper);
        LambdaQueryWrapper queryWrapperApply = Wrappers.lambdaQuery();
        queryWrapperApply.eq(ZyfxObjectApply::getObjectid, (Object)objectId);
        long applyCount = this.zyfxObjectApplyMapper.selectCount((Wrapper)queryWrapperApply);
        ZyfxObjectSt stInfo = new ZyfxObjectSt();
        stInfo.setApplyCount(applyCount);
        stInfo.setFavoriteCount(favoriteCount);
        return stInfo;
    }

    private List<FldDicts> queryObjectRelFldDicts(String objectId) {
        ArrayList<FldDicts> fldDicts = new ArrayList<FldDicts>();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxDictfld::getObjectid, (Object)objectId);
        List zyfxDictflds = this.zyfxDictfldMapper.selectList((Wrapper)queryWrapper);
        for (ZyfxDictfld zyfxDictfld : zyfxDictflds) {
            DmDictValueDTO dictionaryTree = this.dictionaryService.getDictionaryTree(zyfxDictfld.getDictkey());
            TreeNodeConfig treeNodeConfig = new TreeNodeConfig();
            treeNodeConfig.setIdKey("id");
            treeNodeConfig.setParentIdKey("fatherId");
            ArrayList<DmDictValue> dictValues = new ArrayList<DmDictValue>();
            ArrayList<DmDictValueDTO> dictTrees = new ArrayList<DmDictValueDTO>();
            dictTrees.add(dictionaryTree);
            BaseTreeUtil.treeListToList(dictTrees, dictValues, (TreeNodeConfig)treeNodeConfig);
            FldDicts fldDict = new FldDicts();
            fldDict.setFldname(zyfxDictfld.getFldname());
            fldDict.setFldAlias(zyfxDictfld.getFldAlias());
            fldDict.setDicts(dictValues);
            fldDicts.add(fldDict);
        }
        return fldDicts;
    }

    private void checkZyfxObject(ZyfxObject zyfxObject) throws Exception {
        long iCount;
        boolean isOld = StrUtil.isNotEmpty((CharSequence)zyfxObject.getId());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxObject::getName, (Object)zyfxObject.getName());
        if (isOld) {
            queryWrapper.ne(ZyfxObject::getId, (Object)zyfxObject.getId());
        }
        if ((iCount = this.count((Wrapper)queryWrapper)) > 0L) {
            throw new Exception("\u540d\u79f0\u5df2\u5b58\u5728!");
        }
    }

    private void wapperStInfo(List<ZyfxObject> listResults) {
        List<String> objectIds;
        Map<String, Long> mapCount;
        if (listResults.size() > 0 && (mapCount = this.zyfxAccessService.queryAccessCountByObjectIds(objectIds = listResults.stream().map(i -> i.getId()).collect(Collectors.toList()))).size() > 0) {
            for (ZyfxObject zyfxObject : listResults) {
                if (!mapCount.containsKey(zyfxObject.getId())) continue;
                zyfxObject.setAccessCount(mapCount.get(zyfxObject.getId()));
            }
        }
    }

    public void wrapperDetail(List<ZyfxObject> listResults, int groupType) throws Exception {
        block3: {
            List objectIds;
            block5: {
                block4: {
                    if (listResults.size() <= 0) break block3;
                    objectIds = listResults.stream().map(i -> i.getId()).collect(Collectors.toList());
                    if (groupType != 1) break block4;
                    LambdaQueryWrapper subQueryWrapper = Wrappers.lambdaQuery();
                    subQueryWrapper.in(ZyfxDataset::getId, objectIds);
                    List details = this.zyfxDatasetMapper.selectList((Wrapper)subQueryWrapper);
                    for (ZyfxObject zyfxObject : listResults) {
                        ZyfxDataset detail = details.stream().filter(u -> u.getId().equals(zyfxObject.getId())).findFirst().orElse(null);
                        detail.setOtherparams(null);
                        zyfxObject.setDetail(detail);
                    }
                    break block3;
                }
                if (groupType != 2) break block5;
                LambdaQueryWrapper subQueryWrapper = Wrappers.lambdaQuery();
                subQueryWrapper.in(ZyfxServiceset::getId, objectIds);
                List details = this.zyfxServicesetMapper.selectList((Wrapper)subQueryWrapper);
                for (ZyfxObject zyfxObject : listResults) {
                    ZyfxServiceset detail = details.stream().filter(u -> u.getId().equals(zyfxObject.getId())).findFirst().orElse(null);
                    detail.setUrl(null);
                    detail.setIsTempUrl(true);
                    detail.setInputparams(null);
                    detail.setOutputparams(null);
                    detail.setOtherparams(null);
                    detail.setRequestexample(null);
                    detail.setReponseexample(null);
                    detail.setApiList(null);
                    zyfxObject.setDetail(detail);
                }
                break block3;
            }
            if (groupType != 3) break block3;
            LambdaQueryWrapper subQueryWrapper = Wrappers.lambdaQuery();
            subQueryWrapper.in(ZyfxToolset::getId, objectIds);
            List details = this.zyfxToolsetMapper.selectList((Wrapper)subQueryWrapper);
            for (ZyfxObject zyfxObject : listResults) {
                ZyfxToolset detail = details.stream().filter(u -> u.getId().equals(zyfxObject.getId())).findFirst().orElse(null);
                detail.setUrl(null);
                detail.setIsTempUrl(true);
                detail.setInputparams(null);
                detail.setOutputparams(null);
                detail.setOtherparams(null);
                detail.setRequestexample(null);
                detail.setReponseexample(null);
                zyfxObject.setDetail(detail);
            }
        }
    }

    @Override
    public void wrapperFavoriteAndCart(String userId, List<ZyfxObject> listResults) throws Exception {
        String currentUserId = userId;
        if (StrUtil.isNotBlank((CharSequence)currentUserId) && listResults.size() > 0) {
            List zyfxFavorites = new ArrayList();
            List zyfxCarts = new ArrayList();
            List zyfxObjectApplys = new ArrayList();
            List objectIds = listResults.stream().map(i -> i.getId()).collect(Collectors.toList());
            LambdaQueryWrapper subQueryWrapper1 = Wrappers.lambdaQuery();
            subQueryWrapper1.in(ZyfxFavorite::getObjectid, objectIds);
            subQueryWrapper1.eq(ZyfxFavorite::getUserid, (Object)currentUserId);
            zyfxFavorites = this.zyfxFavoriteMapper.selectList((Wrapper)subQueryWrapper1);
            LambdaQueryWrapper subQueryWrapper2 = Wrappers.lambdaQuery();
            subQueryWrapper2.in(ZyfxCart::getObjectid, objectIds);
            subQueryWrapper2.eq(ZyfxCart::getUserid, (Object)currentUserId);
            zyfxCarts = this.zyfxCartMapper.selectList((Wrapper)subQueryWrapper2);
            LambdaQueryWrapper subQueryWrapper3 = Wrappers.lambdaQuery();
            subQueryWrapper3.in(ZyfxObjectApply::getUserid, new Object[]{currentUserId});
            zyfxObjectApplys = this.zyfxObjectApplyMapper.selectList((Wrapper)subQueryWrapper3);
            for (ZyfxObject zyfxObject : listResults) {
                boolean isApply;
                boolean isInCart;
                boolean isFavorite = zyfxFavorites.stream().anyMatch(i -> i.getObjectid().equals(zyfxObject.getId()));
                if (isFavorite) {
                    zyfxObject.setIsFavorite(1);
                }
                if (isInCart = zyfxCarts.stream().anyMatch(i -> i.getObjectid().equals(zyfxObject.getId()))) {
                    zyfxObject.setIsInCart(1);
                }
                if (!(isApply = zyfxObjectApplys.stream().anyMatch(i -> i.getObjectid().equals(zyfxObject.getId())))) continue;
                zyfxObject.setIsApply(1);
            }
        }
    }

    @Override
    public Page<ZyfxObject> queryYykjToolSets(String filterParam, String sortParam, int inyykj, String mapModes, int page, int size) throws Exception {
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper<ZyfxObject> queryWrapper = qmu.queryMapper(filterParam, sortParam, ZyfxObject.class);
        queryWrapper = this.manageParam(queryWrapper, mapModes);
        if (inyykj == 1) {
            queryWrapper.eq(ZyfxToolset::getInyykj, (Object)inyykj);
        }
        Page pageT = new Page((long)page, (long)size);
        IPage pageResults = this.selectJoinListPage((IPage)pageT, ZyfxObject.class, (MPJBaseJoin)queryWrapper);
        List listResults = pageResults.getRecords();
        String userId = this.iTokenService.queryCurrentSysUserId();
        SysUserDTO userDTO = this.iTokenService.queryCurrentSysUser();
        List roleIds = userDTO.getRoles().stream().map(m -> m.getId()).collect(Collectors.toList());
        List ids = this.sysPowerGjService.listObjs((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysPowerGj.class).in(BaseSysPower::getRelationId, roleIds)).select(new SFunction[]{BaseSysPower::getMandateId}), a -> a.toString()).stream().distinct().collect(Collectors.toList());
        if (!ids.isEmpty()) {
            queryWrapper = qmu.queryMapper(filterParam, sortParam, ZyfxObject.class);
            queryWrapper = this.manageParam(queryWrapper, mapModes);
            queryWrapper.eq(ZyfxToolset::getInyykj, (Object)0);
            queryWrapper.in(ZyfxObject::getId, ids);
            List list = this.selectJoinList(ZyfxObject.class, (MPJBaseJoin)queryWrapper);
            listResults.addAll(list);
            listResults = listResults.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ZyfxObject>(Comparator.comparing(s -> s.getId()))), ArrayList::new));
            pageT.setRecords(listResults);
            pageT.setTotal((long)listResults.size());
        }
        this.wrapperFavoriteAndCart(userId, listResults);
        return pageT;
    }

    private MPJLambdaWrapper<ZyfxObject> manageParam(MPJLambdaWrapper<ZyfxObject> queryWrapper, String mapModes) {
        queryWrapper.eq(ZyfxObject::getGrouptype, (Object)3);
        queryWrapper.selectAll(ZyfxObject.class);
        queryWrapper.selectAs("zt", ZyfxToolset::getInyykj, ZyfxObject::getInYykj);
        queryWrapper.selectAs("zt", ZyfxToolset::getOpenmode, ZyfxObject::getOpenmode);
        queryWrapper.selectAs("zt", ZyfxToolset::getToolkey, ZyfxObject::getToolkey);
        queryWrapper.selectAs("zt", ZyfxToolset::getMapmode, ZyfxObject::getMapmode);
        queryWrapper.leftJoin(ZyfxToolset.class, "zt", ZyfxToolset::getId, ZyfxObject::getId);
        if (StrUtil.isNotBlank((CharSequence)mapModes)) {
            String[] mapModeArr = mapModes.split(",");
            if (mapModeArr.length == 1) {
                int mapMode = Integer.parseInt(mapModeArr[0]);
                queryWrapper.eq(ZyfxToolset::getMapmode, (Object)mapMode);
            } else if (mapModeArr.length > 1) {
                List mapModeList = Arrays.asList(mapModeArr).stream().map(item -> Integer.parseInt(item)).collect(Collectors.toList());
                queryWrapper.in(ZyfxToolset::getMapmode, mapModeList);
            }
        }
        return queryWrapper;
    }

    @Override
    public boolean resetService(String ids) {
        String[] idArr = ids.split(",");
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        if (idArr.length == 1) {
            queryWrapper.eq(ZyfxObject::getId, (Object)ids);
        } else {
            queryWrapper.in(ZyfxObject::getId, Arrays.asList(idArr));
        }
        queryWrapper.eq(ZyfxObject::getId, (Object)ids);
        return true;
    }

    private void wrapperFavoriteAndCart(String userId, ZyfxObject zyfxObject) throws Exception {
        String currentUserId = userId;
        if (StrUtil.isNotBlank((CharSequence)currentUserId) && zyfxObject != null) {
            boolean isApply;
            boolean isInCart;
            List zyfxFavorites = new ArrayList();
            List zyfxCarts = new ArrayList();
            List zyfxObjectApplys = new ArrayList();
            LambdaQueryWrapper subQueryWrapper1 = Wrappers.lambdaQuery();
            subQueryWrapper1.eq(ZyfxFavorite::getObjectid, (Object)zyfxObject.getId());
            subQueryWrapper1.eq(ZyfxFavorite::getUserid, (Object)currentUserId);
            zyfxFavorites = this.zyfxFavoriteMapper.selectList((Wrapper)subQueryWrapper1);
            LambdaQueryWrapper subQueryWrapper2 = Wrappers.lambdaQuery();
            subQueryWrapper2.eq(ZyfxCart::getObjectid, (Object)zyfxObject.getId());
            subQueryWrapper2.eq(ZyfxCart::getUserid, (Object)currentUserId);
            zyfxCarts = this.zyfxCartMapper.selectList((Wrapper)subQueryWrapper2);
            LambdaQueryWrapper subQueryWrapper3 = Wrappers.lambdaQuery();
            subQueryWrapper3.in(ZyfxObjectApply::getUserid, new Object[]{currentUserId});
            zyfxObjectApplys = this.zyfxObjectApplyMapper.selectList((Wrapper)subQueryWrapper3);
            boolean isFavorite = zyfxFavorites.stream().anyMatch(i -> i.getObjectid().equals(zyfxObject.getId()));
            if (isFavorite) {
                zyfxObject.setIsFavorite(1);
            }
            if (isInCart = zyfxCarts.stream().anyMatch(i -> i.getObjectid().equals(zyfxObject.getId()))) {
                zyfxObject.setIsInCart(1);
            }
            if (isApply = zyfxObjectApplys.stream().anyMatch(i -> i.getObjectid().equals(zyfxObject.getId()))) {
                zyfxObject.setIsApply(1);
            }
        }
    }

    @Override
    public List<ZyfxObjectDetail> findMetaDetailsByRelatedId(String relatedIds, boolean havaDataSet, boolean tempUrl) {
        try {
            String[] ids;
            SysUserDTO userDTO = this.iTokenService.queryCurrentSysUserWithNull();
            ArrayList<ZyfxObjectDetail> result = new ArrayList<ZyfxObjectDetail>();
            QueryWrapper queryWrapper = new QueryWrapper();
            for (String relatedId : ids = relatedIds.split(",")) {
                ((QueryWrapper)queryWrapper.or()).apply("'" + relatedId + "' = ANY (string_to_array(f_relatedid, ','))", new Object[0]);
            }
            List listResults = this.list((Wrapper)queryWrapper);
            for (int i = 0; i < listResults.size(); ++i) {
                Serializable detail;
                ZyfxObject baseInfo = (ZyfxObject)listResults.get(i);
                if (baseInfo == null) {
                    return null;
                }
                String currentUserId = null;
                try {
                    currentUserId = this.iTokenService.queryCurrentSysUserId();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.zyfxAccessService.addOneAccess(baseInfo.getId(), currentUserId);
                LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.eq(ZyfxObject::getId, (Object)baseInfo.getId());
                updateWrapper.set(ZyfxObject::getAcount, (Object)(baseInfo.getAcount() + 1L));
                this.update((Wrapper)updateWrapper);
                try {
                    this.wrapperFavoriteAndCart(currentUserId, baseInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ZyfxObjectDetail zyfxObjectDetail = new ZyfxObjectDetail();
                zyfxObjectDetail.setBase(baseInfo);
                int groupType = baseInfo.getGrouptype();
                if (groupType == 1) {
                    detail = (ZyfxDataset)this.zyfxDatasetMapper.selectById((Serializable)((Object)baseInfo.getId()));
                    if (havaDataSet && StringUtils.isNotEmpty((CharSequence)((ZyfxDataset)detail).getDataid())) {
                        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(((ZyfxDataset)detail).getDataid());
                        zyfxObjectDetail.setDataset(datasetDTO);
                    }
                    zyfxObjectDetail.setDetail(detail);
                } else if (groupType == 2) {
                    detail = (ZyfxServiceset)this.zyfxServicesetMapper.selectById((Serializable)((Object)baseInfo.getId()));
                    ((ZyfxServiceset)detail).setUrl(null);
                    ((ZyfxServiceset)detail).setIsTempUrl(true);
                    ((ZyfxServiceset)detail).setInputparams(null);
                    zyfxObjectDetail.setDetail(detail);
                } else if (groupType == 3) {
                    detail = (ZyfxToolset)this.zyfxToolsetMapper.selectById((Serializable)((Object)baseInfo.getId()));
                    zyfxObjectDetail.setDetail(detail);
                }
                zyfxObjectDetail.setStInfo(null);
                zyfxObjectDetail.setRecommends(null);
                zyfxObjectDetail.setFldDicts(null);
                zyfxObjectDetail.setFiles(null);
                result.add(zyfxObjectDetail);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public IPage<ZyfxObject> queryPowerPage(PageParam page, String relationId, String name, String lb, String aqj) {
        return ((ZyfxObjectMapper)this.baseMapper).queryPowerPage((Page<ZyfxObject>)new Page((long)page.getPage().intValue(), (long)page.getSize().intValue()), relationId, name, lb, aqj);
    }

    @Override
    public List<Map<String, Object>> findMyResources(String userId, String name, Integer resourceType, Integer authorizationType) {
        return ((ZyfxObjectMapper)this.baseMapper).queryMyResources(userId, name, resourceType, authorizationType);
    }

    @Override
    public List<ZyfxServiceset> queryZyfxServicesetByVirtualUrl(String id, String virtualUrl) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(ZyfxServiceset::getVirtualUrl, (Object)virtualUrl);
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            wrapper.ne(ZyfxServiceset::getId, (Object)id);
        }
        return this.zyfxServicesetMapper.selectList((Wrapper)wrapper);
    }

    @Override
    public List<ZyfxServicesetApi> queryZyfxServicesetApiByVirtualUrl(String id, String virtualUrl) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(ZyfxServicesetApi::getVirtualUrl, (Object)virtualUrl);
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            wrapper.ne(ZyfxServicesetApi::getId, (Object)id);
        }
        return this.zyfxServicesetApiService.list((Wrapper)wrapper);
    }
}

