/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.flowable.controller;

import com.alibaba.fastjson2.JSONObject;
import com.geoway.adf.gbpm.flow.constant.ErrorCodeEnum;
import com.geoway.adf.gbpm.flow.entity.GbpmTbActivites;
import com.geoway.adf.gbpm.flow.service.GbpmFlowService;
import com.geoway.adf.gbpm.flow.service.GbpmProcessService;
import com.geoway.adf.gbpm.flow.service.GbpmTaskService;
import com.geoway.adf.gbpm.flow.utils.CallResult;
import com.geoway.adf.gbpm.flow.utils.ResponseResult;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.ITokenService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4efb\u52a1\u73af\u8282\u76f8\u5173\u63a5\u53e3"})
@RestController
@CrossOrigin
@RequestMapping(value={"/open/task"})
public class TaskController {
    private static final Logger log = LoggerFactory.getLogger(TaskController.class);
    @Autowired
    GbpmFlowService gbpmFlowService;
    @Autowired
    GbpmProcessService gbpmProcessService;
    @Autowired
    GbpmTaskService gbpmTaskService;
    @Autowired
    ITokenService tokenService;

    @ApiOperation(value="\u6d41\u8f6c\u5f53\u524d\u4efb\u52a1", notes="\u6839\u636e\u6761\u4ef6\u6d41\u8f6c\u5f53\u524d\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", value="\u6d41\u7a0b\u5b9e\u4f8bID", required=true), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=false), @ApiImplicitParam(name="actDefKey", value="\u73af\u8282\u6807\u8bc6", required=false), @ApiImplicitParam(name="comment", value="\u6d41\u8f6c\u8bb0\u5f55", required=true), @ApiImplicitParam(name="approvalType", value="\u5ba1\u6838\u7ed3\u679c", required=true), @ApiImplicitParam(name="variableData", value="\u4efb\u52a1\u53c2\u6570JSON\u5b57\u7b26\u4e32", required=true), @ApiImplicitParam(name="nextAssignee", value="\u4e0b\u73af\u8282\u4efb\u52a1\u6267\u884c\u4eba", required=false)})
    @PostMapping(value={"/completProcessByParams"})
    public ResponseResult<Void> completProcessByParams(HttpServletRequest request, String processInstanceId, String taskId, String actDefKey, String comment, String approvalType, String variableData, String nextAssignee) {
        try {
            Task task;
            SysUserDTO loginUserInfo = this.tokenService.queryCurrentSysUserWithNull();
            String completeUser = loginUserInfo.getId();
            String completeUserName = loginUserInfo.getUsername();
            String completeUserRegion = loginUserInfo.getXzqdm();
            JSONObject jo = null;
            if (StringUtils.isNotEmpty((CharSequence)variableData)) {
                jo = JSONObject.parseObject((String)variableData);
            }
            if ((task = this.gbpmTaskService.getProcessInstanceActiveTask(processInstanceId, taskId)) == null) {
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)"\u4efb\u52a1\u4e0d\u5b58\u5728!\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u88ab\u4ed6\u4eba\u5904\u7406");
            }
            if (StringUtils.isNotEmpty((CharSequence)taskId) || task.getTaskDefinitionKey().equals(actDefKey)) {
                this.gbpmTaskService.completeProcessActiveTask(task, comment, completeUser, completeUserName, completeUserRegion, approvalType, (Map)jo, nextAssignee);
                return ResponseResult.success();
            }
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)"\u53c2\u6570\u9519\u8bef!");
        }
        catch (Exception ex) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)ex.getMessage());
        }
    }

    @ApiOperation(value="\u540c\u610f\u901a\u8fc7\u6d41\u8f6c\u4efb\u52a1", notes="\u6839\u636e\u6761\u4ef6\u6d41\u8f6c\u5f53\u524d\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", value="\u6d41\u7a0b\u5b9e\u4f8bID", required=true), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=false), @ApiImplicitParam(name="actDefKey", value="\u73af\u8282\u6807\u8bc6", required=false), @ApiImplicitParam(name="comment", value="\u6d41\u8f6c\u8bb0\u5f55", required=true), @ApiImplicitParam(name="variableData", value="\u4efb\u52a1\u53c2\u6570JSON\u5b57\u7b26\u4e32", required=true), @ApiImplicitParam(name="nextAssignee", value="\u4e0b\u73af\u8282\u4efb\u52a1\u6267\u884c\u4eba", required=false)})
    @PostMapping(value={"/completProcessByAgree"})
    public ResponseResult<Void> completProcessByAgree(HttpServletRequest request, String processInstanceId, String taskId, String actDefKey, String comment, String variableData, String nextAssignee) {
        try {
            Task task;
            SysUserDTO loginUserInfo = this.tokenService.queryCurrentSysUserWithNull();
            String completeUser = loginUserInfo.getId();
            String completeUserName = loginUserInfo.getUsername();
            String completeUserRegion = loginUserInfo.getXzqdm();
            JSONObject jo = null;
            if (StringUtils.isNotEmpty((CharSequence)variableData)) {
                jo = JSONObject.parseObject((String)variableData);
            }
            if ((task = this.gbpmTaskService.getProcessInstanceActiveTask(processInstanceId, taskId)) == null) {
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)"\u4efb\u52a1\u4e0d\u5b58\u5728!\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u88ab\u4ed6\u4eba\u5904\u7406");
            }
            if (StringUtils.isNotEmpty((CharSequence)taskId) || task.getTaskDefinitionKey().equals(actDefKey)) {
                this.gbpmTaskService.completeProcessActiveTask(processInstanceId, taskId, comment, completeUser, completeUserName, completeUserRegion, "agree", (Map)jo, nextAssignee);
                return ResponseResult.success();
            }
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)"\u53c2\u6570\u9519\u8bef!");
        }
        catch (Exception ex) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)ex.getMessage());
        }
    }

    @ApiOperation(value="\u5ba1\u6838\u4e0d\u901a\u8fc7\u6d41\u8f6c\u4efb\u52a1", notes="\u6839\u636e\u6761\u4ef6\u6d41\u8f6c\u5f53\u524d\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", value="\u6d41\u7a0b\u5b9e\u4f8bID", required=true), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=false), @ApiImplicitParam(name="actDefKey", value="\u73af\u8282\u6807\u8bc6", required=false), @ApiImplicitParam(name="comment", value="\u6d41\u8f6c\u8bb0\u5f55", required=true), @ApiImplicitParam(name="variableData", value="\u4efb\u52a1\u53c2\u6570JSON\u5b57\u7b26\u4e32", required=true), @ApiImplicitParam(name="nextAssignee", value="\u4e0b\u73af\u8282\u4efb\u52a1\u6267\u884c\u4eba", required=false)})
    @PostMapping(value={"/completProcessByRefuse"})
    public ResponseResult<Void> completProcessByRefuse(HttpServletRequest request, String processInstanceId, String taskId, String actDefKey, String comment, String variableData, String nextAssignee) {
        try {
            Task task;
            SysUserDTO loginUserInfo = this.tokenService.queryCurrentSysUserWithNull();
            String completeUser = loginUserInfo.getId();
            String completeUserName = loginUserInfo.getUsername();
            String completeUserRegion = loginUserInfo.getXzqdm();
            JSONObject jo = null;
            if (StringUtils.isNotEmpty((CharSequence)variableData)) {
                jo = JSONObject.parseObject((String)variableData);
            }
            if ((task = this.gbpmTaskService.getProcessInstanceActiveTask(processInstanceId, taskId)) == null) {
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)"\u4efb\u52a1\u4e0d\u5b58\u5728!\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u88ab\u4ed6\u4eba\u5904\u7406");
            }
            if (StringUtils.isNotEmpty((CharSequence)taskId) || task.getTaskDefinitionKey().equals(actDefKey)) {
                this.gbpmTaskService.completeProcessActiveTask(processInstanceId, taskId, comment, completeUser, completeUserName, completeUserRegion, "refuse", (Map)jo, nextAssignee);
                return ResponseResult.success();
            }
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)"\u53c2\u6570\u9519\u8bef!");
        }
        catch (Exception ex) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)ex.getMessage());
        }
    }

    @ApiOperation(value="\u56de\u9000\u5230\u4e0a\u4e00\u4e2a\u7528\u6237\u4efb\u52a1\u8282\u70b9\u3002\u5982\u679c\u6ca1\u6709\u6307\u5b9a\uff0c\u5219\u56de\u9000\u5230\u4e0a\u4e00\u4e2a\u4efb\u52a1\u3002", notes="\u6839\u636e\u6761\u4ef6\u9000\u56de\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", value="\u6d41\u7a0b\u5b9e\u4f8bID", required=true), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=false), @ApiImplicitParam(name="actDefKey", value="\u73af\u8282\u6807\u8bc6", required=false), @ApiImplicitParam(name="targetKey", value="\u56de\u9000\u8282\u70b9", required=false), @ApiImplicitParam(name="reason", value="\u9a73\u56de\u539f\u56e0", required=true)})
    @PostMapping(value={"/backToRuntimeTask"})
    public ResponseResult<Void> backToRuntimeTask(HttpServletRequest request, String processInstanceId, String taskId, String actDefKey, String targetKey, String reason, String targetUser) {
        SysUserDTO loginUserInfo = null;
        try {
            loginUserInfo = this.tokenService.queryCurrentSysUserWithNull();
            String userId = loginUserInfo.getId();
            String userName = loginUserInfo.getUsername();
            String userRegion = loginUserInfo.getXzqdm();
            Task task = this.gbpmTaskService.getProcessInstanceActiveTask(processInstanceId, taskId);
            if (task == null) {
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)"\u4efb\u52a1\u4e0d\u5b58\u5728!\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u88ab\u4ed6\u4eba\u5904\u7406");
            }
            if (StringUtils.isNotEmpty((CharSequence)taskId) || task.getTaskDefinitionKey().equals(actDefKey)) {
                CallResult cr = this.gbpmTaskService.backTaskToTarget(task, userId, userName, userRegion, reason, targetKey, targetUser, null);
                if (cr.isSuccess()) {
                    return ResponseResult.success();
                }
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)cr.getErrorMessage());
            }
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)"\u53c2\u6570\u9519\u8bef!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)e.getMessage());
        }
    }

    @ApiOperation(value="\u81ea\u7531\u8df3", notes="\u81ea\u7531\u8df3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", value="\u6d41\u7a0b\u5b9e\u4f8bID", required=true), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=false), @ApiImplicitParam(name="actDefKey", value="\u73af\u8282\u6807\u8bc6", required=false), @ApiImplicitParam(name="targetKey", value="\u56de\u9000\u8282\u70b9", required=true), @ApiImplicitParam(name="reason", value="\u539f\u56e0", required=true)})
    @PostMapping(value={"/freeJump"})
    public ResponseResult<Void> freeJump(HttpServletRequest request, String processInstanceId, String taskId, String actDefKey, String targetKey, String reason) {
        try {
            SysUserDTO loginUserInfo = this.tokenService.queryCurrentSysUserWithNull();
            String userId = loginUserInfo.getId();
            String userName = loginUserInfo.getUsername();
            String userRegion = loginUserInfo.getXzqdm();
            Task task = this.gbpmTaskService.getProcessInstanceActiveTask(processInstanceId, taskId);
            if (task == null) {
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)"\u4efb\u52a1\u4e0d\u5b58\u5728!\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u88ab\u4ed6\u4eba\u5904\u7406");
            }
            if (StringUtils.isNotEmpty((CharSequence)taskId) || task.getTaskDefinitionKey().equals(actDefKey)) {
                CallResult cr = this.gbpmTaskService.freeJump(task, userId, userName, userRegion, reason, targetKey, "", null);
                if (cr.isSuccess()) {
                    return ResponseResult.success();
                }
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)cr.getErrorMessage());
            }
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)"\u53c2\u6570\u9519\u8bef!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)e.getMessage());
        }
    }

    @ApiOperation(value="\u64a4\u56de\u4efb\u52a1", notes="\u64a4\u56de\u7528\u6237\u63d0\u4ea4\u7684\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true), @ApiImplicitParam(name="reason", value="\u9a73\u56de\u6216\u64a4\u56de\u539f\u56e0", required=true)})
    @PostMapping(value={"/revokeTask"})
    public ResponseResult<Void> revokeTask(String taskId, String reason) {
        CallResult cr = this.gbpmTaskService.revokeSelfTask(taskId, reason, false);
        if (cr.isSuccess()) {
            return ResponseResult.success();
        }
        return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)cr.getErrorMessage());
    }

    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u5bf9\u5e94\u7684\u8fde\u63a5\u5730\u5740", notes="\u6839\u636eID\u83b7\u53d6\u4efb\u52a1\u5bf9\u5e94\u7684\u8fde\u63a5\u5730\u5740")
    @ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true)
    @GetMapping(value={"/getTaskUrl"})
    public ResponseResult<String> getTaskUrl(String taskId) {
        try {
            HistoricTaskInstance hti = this.gbpmTaskService.getTaskDetail(taskId);
            if (hti != null) {
                String readOnly = "false";
                if (hti.getEndTime() != null) {
                    readOnly = "true";
                }
                HistoricProcessInstance hpi = this.gbpmProcessService.getHistoricProcessInstance(hti.getProcessInstanceId());
                String urlParams = "?taskId=" + URLEncoder.encode(taskId, "UTF-8") + "&readOnly=" + readOnly + "&taskDefKey=" + URLEncoder.encode(hti.getTaskDefinitionKey(), "UTF-8") + "&processDefinitionId=" + URLEncoder.encode(hti.getProcessDefinitionId(), "UTF-8") + "&processInstanceId=" + URLEncoder.encode(hti.getProcessInstanceId(), "UTF-8") + "&bkey=" + URLEncoder.encode(hpi.getBusinessKey(), "UTF-8");
                GbpmTbActivites activites = this.gbpmProcessService.findActivityByParam(hti.getProcessDefinitionId(), hti.getTaskDefinitionKey());
                String url = activites.getFormUrl();
                if (StringUtils.isNotEmpty((CharSequence)url)) {
                    url = url + urlParams;
                    return ResponseResult.success((Object)url);
                }
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u9875\u9762\u4fe1\u606f");
            }
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u4efb\u52a1\u4fe1\u606f");
        }
        catch (Exception ex) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)ex.getMessage());
        }
    }

    @ApiOperation(value="\u8ba4\u9886\u4efb\u52a1", notes="\u6839\u636e\u6761\u4ef6\u8ba4\u9886\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true)})
    @GetMapping(value={"/claimTaskUser"})
    public ResponseResult<Void> claimTaskUser(HttpServletRequest request, String taskId) {
        try {
            Task task = this.gbpmTaskService.getRuntimeTask(taskId);
            if (task != null) {
                String userId = this.tokenService.queryCurrentSysUserId();
                CallResult cr = this.gbpmTaskService.claimTask(task, userId);
                if (cr.isSuccess()) {
                    return ResponseResult.success();
                }
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)cr.getErrorMessage());
            }
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u4efb\u52a1\u4fe1\u606f");
        }
        catch (Exception ex) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)ex.getMessage());
        }
    }

    @ApiOperation(value="\u4efb\u52a1\u8f6c\u529e", notes="\u6839\u636e\u6761\u4ef6\u8f6c\u529e\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="delegateUser", value="\u8f6c\u529e\u4eba", required=true), @ApiImplicitParam(name="delegateUserName", value="\u8f6c\u529e\u4eba\u540d\u79f0", required=true), @ApiImplicitParam(name="delegateUserRegion", value="\u8f6c\u529e\u4eba\u884c\u653f\u533a\u4ee3\u7801", required=true), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true)})
    @GetMapping(value={"/transferTaskUser"})
    public ResponseResult<Void> transferTaskUser(HttpServletRequest request, String taskId, String delegateUser, String delegateUserName, String delegateUserRegion) {
        try {
            SysUserDTO loginUserInfo = this.tokenService.queryCurrentSysUserWithNull();
            String userId = loginUserInfo.getId();
            String userName = loginUserInfo.getUsername();
            String userRegion = loginUserInfo.getXzqdm();
            Task task = this.gbpmTaskService.getRuntimeTask(taskId);
            if (task != null) {
                this.gbpmTaskService.transferTask(task, userId, userName, userRegion, delegateUser, delegateUserName, delegateUserRegion);
                return ResponseResult.success();
            }
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u4efb\u52a1\u4fe1\u606f");
        }
        catch (Exception ex) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)ex.getMessage());
        }
    }
}

