/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.flowable.service;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.adf.gbpm.flow.entity.GbpmTbFlow;
import com.geoway.adf.gbpm.flow.entity.GbpmTbFlowPublish;
import com.geoway.adf.gbpm.flow.entity.GbpmTbTaskComment;
import com.geoway.adf.gbpm.flow.service.GbpmProcessService;
import com.geoway.adf.gbpm.flow.service.GbpmTaskService;
import com.geoway.adf.gbpm.flow.service.IGbpmTbFlowService;
import com.geoway.adf.gbpm.flow.service.IGbpmTbTaskCommentService;
import com.geoway.adf.gbpm.flow.utils.CallResult;
import com.geoway.adf.gbpm.flow.utils.MyPageData;
import com.geoway.adf.gbpm.flow.utils.MyPageParam;
import com.geoway.ns.flowable.dto.BatchFlowResult;
import com.geoway.ns.proxy.dto.ProxyObjectLimit;
import com.geoway.ns.zyfx.domain.ZyfxApplyOrder;
import com.geoway.ns.zyfx.domain.ZyfxObjectApply;
import com.geoway.ns.zyfx.dto.ZyfxApplyFilterDTO;
import com.geoway.ns.zyfx.service.ZyfxObjectApplyService;
import com.geoway.ns.zyfx.utils.ObjectUtils;
import com.geoway.sso.client.client.RoleClient;
import com.geoway.sso.client.client.UserClient;
import com.geoway.sso.client.rpc.RpcSysRole;
import com.geoway.sso.client.rpc.RpcSysUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShareFlowService {
    private static final Logger log = LoggerFactory.getLogger(ShareFlowService.class);
    @Autowired
    ZyfxObjectApplyService zyfxObjectApplyService;
    @Autowired
    IGbpmTbFlowService gbpmTbFlowService;
    @Autowired
    private GbpmProcessService gbpmProcessService;
    @Autowired
    private GbpmTaskService gbpmTaskService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Value(value="${share.flow.enabled:false}")
    private Boolean flowEnabled;
    @Value(value="${share.flow.serviceFlowId:}")
    private String serviceFlowId;
    @Value(value="${share.flow.dataFlowId:}")
    private String dataFlowId;
    @Value(value="${share.flow.toolFlowId:}")
    private String toolFlowId;
    @Resource
    private ZyfxObjectApplyService applyService;
    @Autowired
    private IGbpmTbTaskCommentService gbpmTbTaskCommentService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    UserClient userClient;
    @Autowired
    private RoleClient roleClient;

    public Boolean checkFlowInfo(Short grouptype) {
        FlowType flowType = this.convertGrouptypeToFlowType(grouptype);
        String flowId = this.getFlowIdByType(flowType);
        if (!this.flowEnabled.booleanValue()) {
            return false;
        }
        if (this.flowEnabled.booleanValue() && StringUtils.isEmpty((CharSequence)flowId)) {
            return false;
        }
        return true;
    }

    @Transactional
    public BatchFlowResult startFlow(String zyfxApplyOrderId, Boolean isAutoSubmit) {
        if (!this.flowEnabled.booleanValue()) {
            throw new RuntimeException("\u6d41\u7a0b\u529f\u80fd\u672a\u542f\u7528\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e share.flow.enabled");
        }
        ZyfxApplyOrder order = this.applyService.findOrderDetailById(zyfxApplyOrderId);
        if (order == null) {
            throw new RuntimeException("\u8ba2\u5355\u4e0d\u5b58\u5728: " + zyfxApplyOrderId);
        }
        List<ZyfxObjectApply> applyObjects = order.getDetails();
        if (applyObjects == null || applyObjects.isEmpty()) {
            throw new RuntimeException("\u8ba2\u5355\u4e2d\u6ca1\u6709\u7533\u8bf7\u9879: " + zyfxApplyOrderId);
        }
        Short grouptype = order.getGrouptype();
        if (grouptype == null) {
            throw new RuntimeException("\u8ba2\u5355\u7684 grouptype \u4e3a\u7a7a: " + zyfxApplyOrderId);
        }
        FlowType flowType = this.convertGrouptypeToFlowType(grouptype);
        BatchFlowResult result = new BatchFlowResult();
        result.setOrderId(order.getId());
        result.setTotalCount(applyObjects.size());
        log.info("\u5f00\u59cb\u6279\u91cf\u542f\u52a8\u6d41\u7a0b - \u8ba2\u5355ID: {}, \u6d41\u7a0b\u7c7b\u578b: {}, \u7533\u8bf7\u9879\u6570\u91cf: {}", new Object[]{zyfxApplyOrderId, flowType.getDescription(), applyObjects.size()});
        for (ZyfxObjectApply apply : applyObjects) {
            try {
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.put("orderId", order.getId());
                variables.put("orderCode", order.getCode());
                variables.put("orderName", order.getName());
                variables.put("grouptype", grouptype);
                variables.put("applyId", apply.getId());
                variables.put("applyName", apply.getObjectname());
                variables.put("objectId", apply.getObjectid());
                variables.put("objectName", apply.getObjectname());
                variables.put("userId", apply.getUserid());
                variables.put("userName", apply.getUsername());
                variables.put("tel", apply.getTel());
                variables.put("email", apply.getEmail());
                variables.put("dwmc", apply.getDwmc());
                variables.put("purpose", apply.getPurpose());
                variables.put("bz", apply.getBz());
                String title = String.format("%s\u7533\u8bf7-%s", flowType.getDescription(), apply.getObjectname());
                String processInstanceId = this.startFlow(flowType, title, apply.getId(), order.getUserid(), order.getUsername(), variables, isAutoSubmit);
                result.addSuccess(apply.getId(), apply.getObjectname(), apply.getObjectid(), processInstanceId);
                log.info("\u6d41\u7a0b\u542f\u52a8\u6210\u529f - \u7533\u8bf7\u9879ID: {}, \u7533\u8bf7\u9879\u540d\u79f0: {}, \u6d41\u7a0b\u5b9e\u4f8bID: {}", new Object[]{apply.getId(), apply.getObjectname(), processInstanceId});
            }
            catch (Exception e) {
                String errorMsg = e.getMessage();
                result.addFailure(apply.getId(), apply.getObjectname(), apply.getObjectid(), errorMsg);
                log.error("\u6d41\u7a0b\u542f\u52a8\u5931\u8d25 - \u7533\u8bf7\u9879ID: {}, \u7533\u8bf7\u9879\u540d\u79f0: {}, \u9519\u8bef: {}", new Object[]{apply.getId(), apply.getObjectname(), errorMsg, e});
            }
        }
        result.calculate();
        log.info("\u6279\u91cf\u542f\u52a8\u6d41\u7a0b\u5b8c\u6210 - \u8ba2\u5355ID: {}, \u603b\u6570: {}, \u6210\u529f: {}, \u5931\u8d25: {}", new Object[]{zyfxApplyOrderId, result.getTotalCount(), result.getSuccessCount(), result.getFailureCount()});
        return result;
    }

    @Transactional
    public String startFlow(FlowType flowType, String title, String businessKey, String userId, String userName, Map<String, Object> variables, Boolean isAutoSubmit) {
        if (!this.flowEnabled.booleanValue()) {
            throw new RuntimeException("\u6d41\u7a0b\u529f\u80fd\u672a\u542f\u7528\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e share.flow.enabled");
        }
        String flowId = this.getFlowIdByType(flowType);
        if (flowId == null || flowId.isEmpty()) {
            throw new RuntimeException("\u6d41\u7a0bID\u672a\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e share.flow." + flowType.getConfigKey());
        }
        try {
            HashMap<String, Object> processVariables = new HashMap<String, Object>();
            if (variables != null) {
                processVariables.putAll(variables);
            }
            processVariables.put("initiator", userId);
            processVariables.put("initiatorName", userName);
            processVariables.put("businessKey", businessKey);
            processVariables.put("flowType", flowType.name());
            processVariables.put("startTime", new Date());
            ProcessInstance processInstance = null;
            if (isAutoSubmit.booleanValue()) {
                GbpmTbFlowPublish flowPublish;
                GbpmTbFlow flow = (GbpmTbFlow)this.gbpmTbFlowService.getById((Serializable)((Object)flowId));
                if (flow != null && 1 == flow.getStatus() && (flowPublish = this.gbpmTbFlowService.getFlowPublishById(flow.getMainPublishId())) != null) {
                    processInstance = this.gbpmProcessService.startByProcDefId(title, flowPublish.getProcDefId(), (Object)businessKey, userId, processVariables);
                    List firstTasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getId())).active().list();
                    if (!firstTasks.isEmpty()) {
                        Task firstTask = (Task)firstTasks.get(0);
                        List<NextNodeAssignee> nextAssignees = this.getNextNodeAssignees(processInstance.getId());
                        if (!nextAssignees.isEmpty()) {
                            NextNodeAssignee nextAssignee = nextAssignees.get(0);
                            if ("USER".equals(nextAssignee.getAssignmentType()) && StringUtils.isNotEmpty((CharSequence)nextAssignee.getAssigneeUserId())) {
                                processVariables.put("nextAssignee", nextAssignee.getAssigneeUserId());
                                log.info("\u8bbe\u7f6e\u4e0b\u4e00\u8282\u70b9\u6267\u884c\u4eba - \u7528\u6237ID: {}, \u7528\u6237\u540d: {}", (Object)nextAssignee.getAssigneeUserId(), (Object)nextAssignee.getAssigneeUserName());
                            } else if ("CANDIDATE_USERS".equals(nextAssignee.getAssignmentType()) && nextAssignee.getCandidateUserIds() != null && !nextAssignee.getCandidateUserIds().isEmpty()) {
                                String selectedUser = nextAssignee.getCandidateUserIds().get(0);
                                processVariables.put("nextAssignee", selectedUser);
                                log.info("\u8bbe\u7f6e\u4e0b\u4e00\u8282\u70b9\u6267\u884c\u4eba\uff08\u5019\u9009\u7528\u6237\uff09 - \u7528\u6237ID: {}", (Object)selectedUser);
                            } else if ("CANDIDATE_GROUPS".equals(nextAssignee.getAssignmentType()) && nextAssignee.getCandidateUserIds() != null && !nextAssignee.getCandidateUserIds().isEmpty()) {
                                String selectedUser = nextAssignee.getCandidateUserIds().get(0);
                                processVariables.put("nextAssignee", selectedUser);
                                log.info("\u8bbe\u7f6e\u4e0b\u4e00\u8282\u70b9\u6267\u884c\u4eba\uff08\u5019\u9009\u7ec4\uff09 - \u7528\u6237ID: {}", (Object)selectedUser);
                            }
                        }
                        JSONObject completeVariables = new JSONObject(processVariables);
                        completeVariables.put((Object)"autoSubmit", (Object)true);
                        completeVariables.put((Object)"submitTime", (Object)new Date());
                        this.gbpmTaskService.completeProcessActiveTask(firstTask, "\u81ea\u52a8\u63d0\u4ea4", userId, userName, null, "agree", (Map)completeVariables, null);
                        log.info("{}\u6d41\u7a0b\u542f\u52a8\u5e76\u81ea\u52a8\u63d0\u4ea4\u6210\u529f - \u6d41\u7a0bID: {}, \u6d41\u7a0b\u5b9e\u4f8bID: {}, \u4e1a\u52a1Key: {}, \u53d1\u8d77\u4eba: {}, \u4e0b\u4e00\u8282\u70b9\u6267\u884c\u4eba\u5df2\u8bbe\u7f6e", new Object[]{flowType.getDescription(), flowId, processInstance.getId(), businessKey, userName});
                    }
                }
            } else {
                processInstance = this.gbpmProcessService.startByFlowId(flowId, title, (Object)businessKey, userId, processVariables);
                log.info("{}\u6d41\u7a0b\u542f\u52a8\u6210\u529f - \u6d41\u7a0bID: {}, \u6d41\u7a0b\u5b9e\u4f8bID: {}, \u4e1a\u52a1Key: {}, \u53d1\u8d77\u4eba: {}", new Object[]{flowType.getDescription(), flowId, processInstance.getId(), businessKey, userName});
            }
            return processInstance.getId();
        }
        catch (Exception e) {
            log.error("\u542f\u52a8{}\u6d41\u7a0b\u5931\u8d25 - \u6d41\u7a0bID: {}, \u4e1a\u52a1Key: {}", new Object[]{flowType.getDescription(), flowId, businessKey, e});
            throw new RuntimeException("\u542f\u52a8" + flowType.getDescription() + "\u6d41\u7a0b\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Transactional
    public void completeTask(String taskId, String userId, String userName, String areaCode, boolean approved, String comment, Map<String, Object> variables, String nextAssignees) {
        try {
            Task task = this.gbpmTaskService.getRuntimeTask(taskId);
            if (task == null) {
                throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5904\u7406");
            }
            this.gbpmTaskService.claimTask(task, "");
            JSONObject processVariables = new JSONObject();
            if (variables != null) {
                processVariables.putAll(variables);
            }
            processVariables.put((Object)"approved", (Object)approved);
            processVariables.put((Object)"comment", (Object)comment);
            processVariables.put((Object)"approver", (Object)userId);
            processVariables.put((Object)"approverName", (Object)userName);
            processVariables.put((Object)"approveTime", (Object)new Date());
            String approvalType = approved ? "agree" : "refuse";
            this.gbpmTaskService.completeProcessActiveTask(task, comment, userId, userName, areaCode, approvalType, (Map)processVariables, nextAssignees);
            log.info("\u4efb\u52a1\u5b8c\u6210 - \u4efb\u52a1ID: {}, \u5904\u7406\u4eba: {}, \u5ba1\u6279\u7ed3\u679c: {}, \u6d41\u7a0b\u5b9e\u4f8bID: {}", new Object[]{taskId, userName, approved ? "\u540c\u610f" : "\u62d2\u7edd", task.getProcessInstanceId()});
        }
        catch (Exception e) {
            log.error("\u5b8c\u6210\u4efb\u52a1\u5931\u8d25 - \u4efb\u52a1ID: {}", (Object)taskId, (Object)e);
            throw new RuntimeException("\u5b8c\u6210\u4efb\u52a1\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public void approveTask(String taskId, String userId, String userName, String areaCode, String comment, Map<String, Object> variables, String nextAssignees) {
        this.completeTask(taskId, userId, userName, areaCode, true, comment, variables, nextAssignees);
    }

    public void rejectTask(String taskId, String userId, String userName, String areaCode, String comment, Map<String, Object> variables) {
        this.completeTask(taskId, userId, userName, areaCode, false, comment, variables, null);
    }

    @Transactional
    public CallResult stopProcess(String processInstanceId, String userId, String reason) {
        try {
            CallResult result = this.gbpmProcessService.stopProcessInstance(processInstanceId, userId, reason);
            if (result.isSuccess()) {
                log.info("\u6d41\u7a0b\u7ec8\u6b62\u6210\u529f - \u6d41\u7a0b\u5b9e\u4f8bID: {}, \u64cd\u4f5c\u4eba: {}, \u539f\u56e0: {}", new Object[]{processInstanceId, userId, reason});
            } else {
                log.warn("\u6d41\u7a0b\u7ec8\u6b62\u5931\u8d25 - \u6d41\u7a0b\u5b9e\u4f8bID: {}, \u9519\u8bef\u4fe1\u606f: {}", (Object)processInstanceId, (Object)result.getErrorMessage());
            }
            return result;
        }
        catch (Exception e) {
            log.error("\u7ec8\u6b62\u6d41\u7a0b\u5f02\u5e38 - \u6d41\u7a0b\u5b9e\u4f8bID: {}", (Object)processInstanceId, (Object)e);
            throw new RuntimeException("\u7ec8\u6b62\u6d41\u7a0b\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Transactional
    public void deleteProcess(String processInstanceId, String deleteReason, boolean cascade) {
        try {
            this.gbpmProcessService.deleteProcessInstance(processInstanceId, deleteReason, cascade);
            log.info("\u6d41\u7a0b\u5b9e\u4f8b\u5220\u9664\u6210\u529f - \u6d41\u7a0b\u5b9e\u4f8bID: {}, \u7ea7\u8054\u5220\u9664: {}, \u539f\u56e0: {}", new Object[]{processInstanceId, cascade, deleteReason});
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b\u5931\u8d25 - \u6d41\u7a0b\u5b9e\u4f8bID: {}", (Object)processInstanceId, (Object)e);
            throw new RuntimeException("\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public List<Task> queryTaskListByBusinessKey(String businessKey) {
        TaskQuery query = this.taskService.createTaskQuery().active();
        if (StrUtil.isNotBlank((CharSequence)businessKey)) {
            query.processInstanceBusinessKey(businessKey);
        }
        return query.list();
    }

    public MyPageData<Task> queryMyTodo(String userId) {
        MyPageParam myPageParam = new MyPageParam();
        myPageParam.setPageSize(Integer.valueOf(100));
        MyPageData tasks = this.gbpmTaskService.getTaskListByUserName(userId, null, null, null, myPageParam);
        return tasks;
    }

    public List<GbpmTbTaskComment> getProcessAuditRecords(String businessKey) {
        try {
            if (StringUtils.isEmpty((CharSequence)businessKey)) {
                log.warn("\u4e1a\u52a1Key\u4e3a\u7a7a");
                return new ArrayList<GbpmTbTaskComment>();
            }
            String processInstanceId = null;
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
            if (historicProcessInstance == null) {
                log.warn("\u672a\u627e\u5230\u4e1a\u52a1Key\u5bf9\u5e94\u7684\u6d41\u7a0b\u5b9e\u4f8b - businessKey: {}", (Object)businessKey);
                return new ArrayList<GbpmTbTaskComment>();
            }
            processInstanceId = historicProcessInstance.getId();
            log.debug("\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b - businessKey: {}, processInstanceId: {}, \u662f\u5426\u5df2\u5b8c\u6210: {}", new Object[]{businessKey, processInstanceId, historicProcessInstance.getEndTime() != null});
            List comments = this.gbpmTbTaskCommentService.getFlowTaskCommentList(processInstanceId);
            log.debug("\u83b7\u53d6\u5230\u5ba1\u6279\u8bb0\u5f55\u6570\u91cf: {} - businessKey: {}, processInstanceId: {}", new Object[]{comments != null ? comments.size() : 0, businessKey, processInstanceId});
            return comments != null ? comments : new ArrayList();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5ba1\u6279\u8bb0\u5f55\u5931\u8d25 - businessKey: {}", (Object)businessKey, (Object)e);
            throw new RuntimeException("\u83b7\u53d6\u5ba1\u6279\u8bb0\u5f55\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public IPage<ZyfxObjectApply> queryMyTodoOrdersWithFlow(String userId, ZyfxApplyFilterDTO filterDTO) {
        MyPageParam myPageParam = new MyPageParam();
        myPageParam.setPageSize(filterDTO.getSize());
        myPageParam.setPageNum(filterDTO.getPage());
        MyPageData tasks = this.gbpmTaskService.getTaskListByUserName(userId, null, null, null, myPageParam);
        if (tasks == null) {
            return new Page((long)filterDTO.getPage().intValue(), (long)filterDTO.getSize().intValue());
        }
        Page resultPage = new Page();
        resultPage.setTotal(tasks.getTotalCount().longValue());
        resultPage.setCurrent((long)filterDTO.getPage().intValue());
        ArrayList<ZyfxObjectApply> list = new ArrayList<ZyfxObjectApply>();
        for (Task task : tasks.getDataList()) {
            HistoricProcessInstance hpi = this.gbpmProcessService.getHistoricProcessInstance(task.getProcessInstanceId());
            String businessKey = hpi.getBusinessKey();
            ZyfxObjectApply apply = (ZyfxObjectApply)this.zyfxObjectApplyService.getById((Serializable)((Object)businessKey));
            if (apply == null || apply.getOrderid() == null) continue;
            apply.setCurrentTaskId(task.getId());
            apply.setCurrentTaskName(task.getName());
            apply.setTaskCreateTime(task.getCreateTime());
            apply.setProcessInstanceId(task.getProcessInstanceId());
            apply.setFlowEnabled(true);
            list.add(apply);
        }
        resultPage.setRecords(list);
        resultPage.setSize((long)list.size());
        return resultPage;
    }

    public NextNodeAssignee getCurrentNodeAssignees(Task currentTask) {
        try {
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(currentTask.getProcessDefinitionId()).singleResult();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
            Process process = (Process)bpmnModel.getProcesses().get(0);
            FlowElement currentElement = process.getFlowElement(currentTask.getTaskDefinitionKey());
            if (currentElement instanceof UserTask) {
                UserTask nextUserTask = (UserTask)currentElement;
                NextNodeAssignee assignee = this.parseUserTaskAssignee(nextUserTask, currentTask.getProcessInstanceId());
                return assignee;
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u6267\u884c\u4eba\u5931\u8d25\uff0c\u6d41\u7a0b\u5b9e\u4f8bID: {}", (Object)currentTask.getProcessInstanceId(), (Object)e);
        }
        return null;
    }

    public List<NextNodeAssignee> getNextNodeAssigneesByBusinessKey(String businessKey) {
        List<NextNodeAssignee> result = new ArrayList<NextNodeAssignee>();
        try {
            List<Task> currentTasks = this.queryTaskListByBusinessKey(businessKey);
            if (currentTasks.isEmpty()) {
                log.warn("\u672a\u627e\u5230\u6d3b\u52a8\u4efb\u52a1\uff0c\u4e1a\u52a1key: {}", (Object)businessKey);
                return result;
            }
            Task currentTask = currentTasks.get(0);
            result = this.getNextNodeAssignees(currentTask);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u6267\u884c\u4eba\u5931\u8d25\uff0c\u4e1a\u52a1key: {}", (Object)businessKey, (Object)e);
        }
        return result;
    }

    public List<NextNodeAssignee> getNextNodeAssignees(String processInstanceId) {
        List<NextNodeAssignee> result = new ArrayList<NextNodeAssignee>();
        try {
            List currentTasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).active().list();
            if (currentTasks.isEmpty()) {
                log.warn("\u672a\u627e\u5230\u6d3b\u52a8\u4efb\u52a1\uff0c\u6d41\u7a0b\u5b9e\u4f8bID: {}", (Object)processInstanceId);
                return result;
            }
            Task currentTask = (Task)currentTasks.get(0);
            result = this.getNextNodeAssignees(currentTask);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u6267\u884c\u4eba\u5931\u8d25\uff0c\u6d41\u7a0b\u5b9e\u4f8bID: {}", (Object)processInstanceId, (Object)e);
        }
        return result;
    }

    public List<NextNodeAssignee> getNextNodeAssignees(Task currentTask) {
        ArrayList<NextNodeAssignee> result = new ArrayList<NextNodeAssignee>();
        try {
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(currentTask.getProcessDefinitionId()).singleResult();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
            Process process = (Process)bpmnModel.getProcesses().get(0);
            FlowElement currentElement = process.getFlowElement(currentTask.getTaskDefinitionKey());
            if (currentElement instanceof UserTask) {
                UserTask currentUserTask = (UserTask)currentElement;
                HashSet<String> visited = new HashSet<String>();
                this.findNextUserTasks((FlowElement)currentUserTask, currentTask.getProcessInstanceId(), result, visited);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u6267\u884c\u4eba\u5931\u8d25\uff0c\u6d41\u7a0b\u5b9e\u4f8bID: {}", (Object)currentTask.getProcessInstanceId(), (Object)e);
        }
        return result;
    }

    private void findNextUserTasks(FlowElement currentElement, String processInstanceId, List<NextNodeAssignee> result, Set<String> visited) {
        if (visited.contains(currentElement.getId())) {
            return;
        }
        visited.add(currentElement.getId());
        if (currentElement instanceof FlowNode) {
            FlowNode flowNode = (FlowNode)currentElement;
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                FlowElement targetElement = sequenceFlow.getTargetFlowElement();
                if (targetElement instanceof UserTask) {
                    UserTask nextUserTask = (UserTask)targetElement;
                    NextNodeAssignee assignee = this.parseUserTaskAssignee(nextUserTask, processInstanceId);
                    result.add(assignee);
                    continue;
                }
                if (targetElement instanceof Gateway) {
                    this.findNextUserTasks(targetElement, processInstanceId, result, visited);
                    continue;
                }
                if (!(targetElement instanceof FlowNode)) continue;
                this.findNextUserTasks(targetElement, processInstanceId, result, visited);
            }
        }
    }

    private NextNodeAssignee parseUserTaskAssignee(UserTask userTask, String processInstanceId) {
        List candidateGroups;
        List candidateUsers;
        NextNodeAssignee assignee = new NextNodeAssignee();
        assignee.setTaskDefinitionKey(userTask.getId());
        assignee.setTaskName(userTask.getName());
        String assigneeExpression = userTask.getAssignee();
        if (StringUtils.isNotEmpty((CharSequence)assigneeExpression)) {
            assignee.setAssignmentType("USER");
            assignee.setAssigneeExpression(assigneeExpression);
            String userId = this.resolveExpression(assigneeExpression, processInstanceId);
            if (StringUtils.isNotEmpty((CharSequence)userId)) {
                assignee.setAssigneeUserId(userId);
                assignee.setAssigneeUserName(this.getUserName(userId));
            }
        }
        if ((candidateUsers = userTask.getCandidateUsers()) != null && !candidateUsers.isEmpty()) {
            assignee.setAssignmentType("CANDIDATE_USERS");
            assignee.setCandidateUsers(candidateUsers);
            ArrayList<String> userIds = new ArrayList<String>();
            for (String userExpr : candidateUsers) {
                String userId = this.resolveExpression(userExpr, processInstanceId);
                if (!StringUtils.isNotEmpty((CharSequence)userId)) continue;
                userIds.add(userId);
            }
            assignee.setCandidateUserIds(userIds);
        }
        if ((candidateGroups = userTask.getCandidateGroups()) != null && !candidateGroups.isEmpty()) {
            assignee.setAssignmentType("CANDIDATE_GROUPS");
            assignee.setCandidateGroupIds(candidateGroups);
            ArrayList<RpcSysRole> roleList = new ArrayList<RpcSysRole>();
            Map<String, String> roleIdNameMap = this.extractRoleNamesFromUserTask(userTask);
            for (String groupExpr : candidateGroups) {
                String groupId = this.resolveExpression(groupExpr, processInstanceId);
                if (!StringUtils.isNotEmpty((CharSequence)groupId)) continue;
                RpcSysRole role = new RpcSysRole();
                role.setId(groupId);
                String roleName = roleIdNameMap.get(groupId);
                if (StringUtils.isNotEmpty((CharSequence)roleName)) {
                    role.setName(roleName);
                } else {
                    role.setName(groupId);
                }
                roleList.add(role);
            }
            assignee.setCandidateGroups(roleList);
        }
        return assignee;
    }

    private Map<String, String> extractRoleNamesFromUserTask(UserTask userTask) {
        HashMap<String, String> roleIdNameMap = new HashMap<String, String>();
        try {
            Map extensionElements = userTask.getExtensionElements();
            if (extensionElements != null && extensionElements.containsKey("variableList")) {
                List variableLists = (List)extensionElements.get("variableList");
                block2: for (ExtensionElement variableList : variableLists) {
                    Map childElements = variableList.getChildElements();
                    if (childElements == null || !childElements.containsKey("formVariable")) continue;
                    List formVariables = (List)childElements.get("formVariable");
                    Iterator iterator = formVariables.iterator();
                    while (iterator.hasNext()) {
                        ExtensionElement formVar = (ExtensionElement)iterator.next();
                        String id = formVar.getAttributeValue(null, "id");
                        String value = formVar.getAttributeValue(null, "value");
                        if (!"groups".equals(id) || !StringUtils.isNotEmpty((CharSequence)value)) continue;
                        List candidateGroups = userTask.getCandidateGroups();
                        String[] roleNames = value.split(",");
                        if (candidateGroups != null && candidateGroups.size() == roleNames.length) {
                            for (int i = 0; i < candidateGroups.size(); ++i) {
                                String roleId = ((String)candidateGroups.get(i)).trim();
                                String roleName = roleNames[i].trim();
                                roleIdNameMap.put(roleId, roleName);
                            }
                            log.debug("\u4ece variableList \u4e2d\u63d0\u53d6\u5230 {} \u4e2a\u89d2\u8272\u6620\u5c04", (Object)roleIdNameMap.size());
                            continue block2;
                        }
                        log.warn("\u89d2\u8272ID\u6570\u91cf({})\u4e0e\u89d2\u8272\u540d\u79f0\u6570\u91cf({})\u4e0d\u5339\u914d\uff0cUserTask: {}", new Object[]{candidateGroups != null ? candidateGroups.size() : 0, roleNames.length, userTask.getId()});
                        continue block2;
                    }
                }
            }
            if (roleIdNameMap.isEmpty()) {
                String documentation;
                if (extensionElements != null && extensionElements.containsKey("properties")) {
                    List properties = (List)extensionElements.get("properties");
                    for (ExtensionElement property : properties) {
                        List propertyElements = (List)property.getChildElements().get("property");
                        if (propertyElements == null) continue;
                        for (ExtensionElement prop : propertyElements) {
                            String name = prop.getAttributeValue(null, "name");
                            String value = prop.getAttributeValue(null, "value");
                            if (name == null || !name.endsWith("_name") || value == null) continue;
                            String roleId = name.substring(0, name.length() - 5);
                            roleIdNameMap.put(roleId, value);
                        }
                    }
                }
                if (extensionElements != null && extensionElements.containsKey("roleInfo")) {
                    List roleInfos = (List)extensionElements.get("roleInfo");
                    for (ExtensionElement roleInfo : roleInfos) {
                        String roleId = roleInfo.getAttributeValue(null, "id");
                        String roleName = roleInfo.getAttributeValue(null, "name");
                        if (roleId == null || roleName == null) continue;
                        roleIdNameMap.put(roleId, roleName);
                    }
                }
                if (userTask.getDocumentation() != null && !userTask.getDocumentation().isEmpty() && (documentation = userTask.getDocumentation()).contains("ROLE_MAPPING:")) {
                    String[] mappings;
                    String mappingStr = documentation.substring(documentation.indexOf("ROLE_MAPPING:") + 13).trim();
                    for (String mapping : mappings = mappingStr.split(",")) {
                        String[] parts = mapping.split("=");
                        if (parts.length != 2) continue;
                        roleIdNameMap.put(parts[0].trim(), parts[1].trim());
                    }
                }
            }
            log.debug("\u4ece UserTask [{}] \u4e2d\u63d0\u53d6\u5230\u89d2\u8272\u540d\u79f0\u6620\u5c04: {}", (Object)userTask.getId(), roleIdNameMap);
        }
        catch (Exception e) {
            log.error("\u4ece UserTask \u63d0\u53d6\u89d2\u8272\u540d\u79f0\u5931\u8d25\uff0c\u4efb\u52a1ID: {}", (Object)userTask.getId(), (Object)e);
        }
        return roleIdNameMap;
    }

    private List<String> getUsersByRole(String roleId) {
        try {
            List users = this.roleClient.queryRoleUsers(roleId);
            return users.stream().map(RpcSysUser::getId).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u89d2\u8272\u7528\u6237\u5931\u8d25\uff0c\u89d2\u8272ID: {}", (Object)roleId, (Object)e);
            return new ArrayList<String>();
        }
    }

    private String getUserName(String userId) {
        try {
            RpcSysUser user = this.userClient.getUserInfo(userId);
            return user != null ? user.getAname() : userId;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u540d\u79f0\u5931\u8d25\uff0c\u7528\u6237ID: {}", (Object)userId, (Object)e);
            return userId;
        }
    }

    private String resolveExpression(String expression, String processInstanceId) {
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return null;
        }
        if (expression.startsWith("${") && expression.endsWith("}")) {
            String variableName = expression.substring(2, expression.length() - 1);
            Object value = null;
            try {
                value = this.runtimeService.getVariable(processInstanceId, variableName);
            }
            catch (Exception e) {
                try {
                    value = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId).variableName(variableName).singleResult();
                    if (value != null) {
                        value = ((HistoricVariableInstance)value).getValue();
                    }
                }
                catch (Exception ex) {
                    log.debug("\u65e0\u6cd5\u83b7\u53d6\u6d41\u7a0b\u53d8\u91cf - processInstanceId: {}, variableName: {}", (Object)processInstanceId, (Object)variableName);
                }
            }
            return value != null ? value.toString() : null;
        }
        return expression;
    }

    private String getFlowIdByType(FlowType flowType) {
        switch (flowType) {
            case SERVICE: {
                return this.serviceFlowId;
            }
            case DATA: {
                return this.dataFlowId;
            }
            case TOOL: {
                return this.toolFlowId;
            }
        }
        return null;
    }

    public FlowType convertGrouptypeToFlowType(Short grouptype) {
        if (grouptype == null) {
            throw new IllegalArgumentException("grouptype \u4e0d\u80fd\u4e3a\u7a7a");
        }
        switch (grouptype) {
            case 1: {
                return FlowType.DATA;
            }
            case 2: {
                return FlowType.SERVICE;
            }
            case 3: {
                return FlowType.TOOL;
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684 grouptype: " + grouptype);
    }

    public boolean checkAndHandleProcessComplete(String businessKey) {
        try {
            List<Task> activeTasks = this.queryTaskListByBusinessKey(businessKey);
            if (!activeTasks.isEmpty()) {
                log.debug("\u6d41\u7a0b\u8fdb\u884c\u4e2d - \u4e1a\u52a1Key: {}, \u5f53\u524d\u4efb\u52a1\u6570: {}", (Object)businessKey, (Object)activeTasks.size());
                return false;
            }
            HistoricProcessInstance historicProcess = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
            if (historicProcess == null) {
                log.warn("\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b - \u4e1a\u52a1Key: {}", (Object)businessKey);
                return false;
            }
            if (historicProcess.getEndTime() == null) {
                log.debug("\u6d41\u7a0b\u672a\u7ed3\u675f - \u4e1a\u52a1Key: {}", (Object)businessKey);
                return false;
            }
            log.info("\u6d41\u7a0b\u5df2\u5b8c\u6210 - \u4e1a\u52a1Key: {}, \u6d41\u7a0b\u5b9e\u4f8bID: {}, \u7ed3\u675f\u65f6\u95f4: {}", new Object[]{businessKey, historicProcess.getId(), historicProcess.getEndTime()});
            this.handleProcessCompleteCallback(businessKey, historicProcess);
            return true;
        }
        catch (Exception e) {
            log.error("\u68c0\u67e5\u6d41\u7a0b\u5b8c\u6210\u72b6\u6001\u5931\u8d25 - \u4e1a\u52a1Key: {}", (Object)businessKey, (Object)e);
            return false;
        }
    }

    private void handleProcessCompleteCallback(String businessKey, HistoricProcessInstance historicProcess) {
        try {
            ProxyObjectLimit proxyObjectLimit = this.restoreProxyObjectLimit(historicProcess.getId());
            ZyfxObjectApply apply = (ZyfxObjectApply)this.applyService.getById((Serializable)((Object)businessKey));
            if (apply != null) {
                apply.setCheckstatus(2);
                this.applyService.updateById(apply);
                log.info("\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7\uff08\u56de\u8c03\uff09 - \u7533\u8bf7ID: {}, \u7533\u8bf7\u540d\u79f0: {}, ProxyObjectLimit: {}", new Object[]{apply.getId(), apply.getObjectname(), proxyObjectLimit != null ? "\u5df2\u8fd8\u539f" : "\u672a\u8bbe\u7f6e"});
                this.executePostApprovalBusiness(apply, historicProcess, proxyObjectLimit);
            }
        }
        catch (Exception e) {
            log.error("\u6d41\u7a0b\u5b8c\u6210\u56de\u8c03\u5904\u7406\u5931\u8d25 - \u4e1a\u52a1Key: {}", (Object)businessKey, (Object)e);
        }
    }

    private ProxyObjectLimit restoreProxyObjectLimit(String processInstanceId) {
        try {
            Map<String, Object> variables = new HashMap();
            try {
                variables = this.runtimeService.getVariables(processInstanceId);
            }
            catch (Exception e) {
                List historicVariables = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId).list();
                for (HistoricVariableInstance var : historicVariables) {
                    variables.put(var.getVariableName(), var.getValue());
                }
                log.debug("\u4ece\u5386\u53f2\u53d8\u91cf\u4e2d\u83b7\u53d6\u5230 {} \u4e2a\u53d8\u91cf - \u6d41\u7a0b\u5b9e\u4f8bID: {}", (Object)variables.size(), (Object)processInstanceId);
            }
            Object proxyLimitObj = variables.get("proxyObjectLimit");
            if (proxyLimitObj != null && proxyLimitObj instanceof Map) {
                Map proxyLimitMap = (Map)proxyLimitObj;
                return ObjectUtils.mapToObject(proxyLimitMap, ProxyObjectLimit.class);
            }
            String ipScope = (String)variables.get("ipScope");
            Object expiretimeObj = variables.get("expiretime");
            String frequency = (String)variables.get("frequency");
            String extension = (String)variables.get("extension");
            String xzqlimit = (String)variables.get("xzqlimit");
            if (ipScope != null || expiretimeObj != null || frequency != null || extension != null || xzqlimit != null) {
                ProxyObjectLimit limit = ProxyObjectLimit.builder().ipScope(ipScope).expiretime(expiretimeObj != null ? (Date)expiretimeObj : null).frequency(frequency).extension(extension).xzqlimit(xzqlimit).build();
                log.info("\u4ece\u6d41\u7a0b\u53d8\u91cf\u8fd8\u539f ProxyObjectLimit - \u6d41\u7a0b\u5b9e\u4f8bID: {}", (Object)processInstanceId);
                return limit;
            }
            log.debug("\u6d41\u7a0b\u53d8\u91cf\u4e2d\u672a\u627e\u5230 ProxyObjectLimit \u76f8\u5173\u6570\u636e - \u6d41\u7a0b\u5b9e\u4f8bID: {}", (Object)processInstanceId);
            return null;
        }
        catch (Exception e) {
            log.error("\u8fd8\u539f ProxyObjectLimit \u5931\u8d25 - \u6d41\u7a0b\u5b9e\u4f8bID: {}", (Object)processInstanceId, (Object)e);
            return null;
        }
    }

    protected void executePostApprovalBusiness(ZyfxObjectApply apply, HistoricProcessInstance historicProcess, ProxyObjectLimit proxyObjectLimit) {
        log.info("\u6267\u884c\u5ba1\u6838\u901a\u8fc7\u540e\u7684\u4e1a\u52a1\u5904\u7406 - \u7533\u8bf7ID: {}, \u6d41\u7a0b\u5b9e\u4f8bID: {}, ProxyObjectLimit: {}", new Object[]{apply.getId(), historicProcess.getId(), proxyObjectLimit != null ? "\u5df2\u914d\u7f6e" : "\u672a\u914d\u7f6e"});
    }

    public boolean isFlowEnabled() {
        return this.flowEnabled != null && this.flowEnabled != false;
    }

    public String getServiceFlowId() {
        return this.serviceFlowId;
    }

    public String getDataFlowId() {
        return this.dataFlowId;
    }

    public String getToolFlowId() {
        return this.toolFlowId;
    }

    public static class NextNodeAssignee {
        private String taskDefinitionKey;
        private String taskName;
        private String assignmentType;
        private String assigneeExpression;
        private String assigneeUserId;
        private String assigneeUserName;
        private List<String> candidateUsers;
        private List<String> candidateUserIds;
        private List<RpcSysRole> candidateGroups;
        private List<String> candidateGroupIds;

        public String getTaskDefinitionKey() {
            return this.taskDefinitionKey;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public String getAssignmentType() {
            return this.assignmentType;
        }

        public String getAssigneeExpression() {
            return this.assigneeExpression;
        }

        public String getAssigneeUserId() {
            return this.assigneeUserId;
        }

        public String getAssigneeUserName() {
            return this.assigneeUserName;
        }

        public List<String> getCandidateUsers() {
            return this.candidateUsers;
        }

        public List<String> getCandidateUserIds() {
            return this.candidateUserIds;
        }

        public List<RpcSysRole> getCandidateGroups() {
            return this.candidateGroups;
        }

        public List<String> getCandidateGroupIds() {
            return this.candidateGroupIds;
        }

        public void setTaskDefinitionKey(String taskDefinitionKey) {
            this.taskDefinitionKey = taskDefinitionKey;
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public void setAssignmentType(String assignmentType) {
            this.assignmentType = assignmentType;
        }

        public void setAssigneeExpression(String assigneeExpression) {
            this.assigneeExpression = assigneeExpression;
        }

        public void setAssigneeUserId(String assigneeUserId) {
            this.assigneeUserId = assigneeUserId;
        }

        public void setAssigneeUserName(String assigneeUserName) {
            this.assigneeUserName = assigneeUserName;
        }

        public void setCandidateUsers(List<String> candidateUsers) {
            this.candidateUsers = candidateUsers;
        }

        public void setCandidateUserIds(List<String> candidateUserIds) {
            this.candidateUserIds = candidateUserIds;
        }

        public void setCandidateGroups(List<RpcSysRole> candidateGroups) {
            this.candidateGroups = candidateGroups;
        }

        public void setCandidateGroupIds(List<String> candidateGroupIds) {
            this.candidateGroupIds = candidateGroupIds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NextNodeAssignee)) {
                return false;
            }
            NextNodeAssignee other = (NextNodeAssignee)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$taskDefinitionKey = this.getTaskDefinitionKey();
            String other$taskDefinitionKey = other.getTaskDefinitionKey();
            if (this$taskDefinitionKey == null ? other$taskDefinitionKey != null : !this$taskDefinitionKey.equals(other$taskDefinitionKey)) {
                return false;
            }
            String this$taskName = this.getTaskName();
            String other$taskName = other.getTaskName();
            if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
                return false;
            }
            String this$assignmentType = this.getAssignmentType();
            String other$assignmentType = other.getAssignmentType();
            if (this$assignmentType == null ? other$assignmentType != null : !this$assignmentType.equals(other$assignmentType)) {
                return false;
            }
            String this$assigneeExpression = this.getAssigneeExpression();
            String other$assigneeExpression = other.getAssigneeExpression();
            if (this$assigneeExpression == null ? other$assigneeExpression != null : !this$assigneeExpression.equals(other$assigneeExpression)) {
                return false;
            }
            String this$assigneeUserId = this.getAssigneeUserId();
            String other$assigneeUserId = other.getAssigneeUserId();
            if (this$assigneeUserId == null ? other$assigneeUserId != null : !this$assigneeUserId.equals(other$assigneeUserId)) {
                return false;
            }
            String this$assigneeUserName = this.getAssigneeUserName();
            String other$assigneeUserName = other.getAssigneeUserName();
            if (this$assigneeUserName == null ? other$assigneeUserName != null : !this$assigneeUserName.equals(other$assigneeUserName)) {
                return false;
            }
            List<String> this$candidateUsers = this.getCandidateUsers();
            List<String> other$candidateUsers = other.getCandidateUsers();
            if (this$candidateUsers == null ? other$candidateUsers != null : !((Object)this$candidateUsers).equals(other$candidateUsers)) {
                return false;
            }
            List<String> this$candidateUserIds = this.getCandidateUserIds();
            List<String> other$candidateUserIds = other.getCandidateUserIds();
            if (this$candidateUserIds == null ? other$candidateUserIds != null : !((Object)this$candidateUserIds).equals(other$candidateUserIds)) {
                return false;
            }
            List<RpcSysRole> this$candidateGroups = this.getCandidateGroups();
            List<RpcSysRole> other$candidateGroups = other.getCandidateGroups();
            if (this$candidateGroups == null ? other$candidateGroups != null : !((Object)this$candidateGroups).equals(other$candidateGroups)) {
                return false;
            }
            List<String> this$candidateGroupIds = this.getCandidateGroupIds();
            List<String> other$candidateGroupIds = other.getCandidateGroupIds();
            return !(this$candidateGroupIds == null ? other$candidateGroupIds != null : !((Object)this$candidateGroupIds).equals(other$candidateGroupIds));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NextNodeAssignee;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $taskDefinitionKey = this.getTaskDefinitionKey();
            result = result * 59 + ($taskDefinitionKey == null ? 43 : $taskDefinitionKey.hashCode());
            String $taskName = this.getTaskName();
            result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
            String $assignmentType = this.getAssignmentType();
            result = result * 59 + ($assignmentType == null ? 43 : $assignmentType.hashCode());
            String $assigneeExpression = this.getAssigneeExpression();
            result = result * 59 + ($assigneeExpression == null ? 43 : $assigneeExpression.hashCode());
            String $assigneeUserId = this.getAssigneeUserId();
            result = result * 59 + ($assigneeUserId == null ? 43 : $assigneeUserId.hashCode());
            String $assigneeUserName = this.getAssigneeUserName();
            result = result * 59 + ($assigneeUserName == null ? 43 : $assigneeUserName.hashCode());
            List<String> $candidateUsers = this.getCandidateUsers();
            result = result * 59 + ($candidateUsers == null ? 43 : ((Object)$candidateUsers).hashCode());
            List<String> $candidateUserIds = this.getCandidateUserIds();
            result = result * 59 + ($candidateUserIds == null ? 43 : ((Object)$candidateUserIds).hashCode());
            List<RpcSysRole> $candidateGroups = this.getCandidateGroups();
            result = result * 59 + ($candidateGroups == null ? 43 : ((Object)$candidateGroups).hashCode());
            List<String> $candidateGroupIds = this.getCandidateGroupIds();
            result = result * 59 + ($candidateGroupIds == null ? 43 : ((Object)$candidateGroupIds).hashCode());
            return result;
        }

        public String toString() {
            return "ShareFlowService.NextNodeAssignee(taskDefinitionKey=" + this.getTaskDefinitionKey() + ", taskName=" + this.getTaskName() + ", assignmentType=" + this.getAssignmentType() + ", assigneeExpression=" + this.getAssigneeExpression() + ", assigneeUserId=" + this.getAssigneeUserId() + ", assigneeUserName=" + this.getAssigneeUserName() + ", candidateUsers=" + this.getCandidateUsers() + ", candidateUserIds=" + this.getCandidateUserIds() + ", candidateGroups=" + this.getCandidateGroups() + ", candidateGroupIds=" + this.getCandidateGroupIds() + ")";
        }
    }

    public static enum FlowType {
        SERVICE("\u670d\u52a1\u5ba1\u6279", "serviceFlowId"),
        DATA("\u6570\u636e\u5ba1\u6279", "dataFlowId"),
        TOOL("\u5de5\u5177\u5ba1\u6279", "toolFlowId");

        private final String description;
        private final String configKey;

        private FlowType(String description, String configKey) {
            this.description = description;
            this.configKey = configKey;
        }

        public String getDescription() {
            return this.description;
        }

        public String getConfigKey() {
            return this.configKey;
        }
    }
}

