/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.sys.dto.FileDownloadMeta;
import com.geoway.ns.sys.dto.FileServerResponse;
import com.geoway.ns.sys.dto.FileStructureDTO;
import com.geoway.ns.sys.dto.FileUploadResponse;
import com.geoway.ns.sys.service.FileServerService;
import com.geoway.ns.sys.utils.BaseTreeUtil;
import com.geoway.ns.sys.utils.FileUploadUtil;
import com.geoway.ns.zyfx.domain.ConcurrentTemplates;
import com.geoway.ns.zyfx.mapper.ConcurrentTemplatesMapper;
import com.geoway.ns.zyfx.service.ConcurrentTemplatesService;
import com.geoway.ns.zyfx.utils.RarUtil;
import com.geoway.ns.zyfx.utils.Z7zUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ConcurrentTemplatesServiceImpl
extends ServiceImpl<ConcurrentTemplatesMapper, ConcurrentTemplates>
implements ConcurrentTemplatesService {
    private final TreeNodeConfig treeNodeConfig = new TreeNodeConfig().setParentIdKey("pid").setWeightKey("createTime").setIdKey("id");
    @Autowired
    FileServerService fileServerService;
    @Autowired
    FileUploadUtil fileUploadUtil;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addConcurrentTemplates(ConcurrentTemplates concurrentTemplates) throws Exception {
        this.judgeSameName(concurrentTemplates);
        this.save(concurrentTemplates);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteConcurrentTemplates(ConcurrentTemplates concurrentTemplates) throws Exception {
        if (StrUtil.isBlank((CharSequence)concurrentTemplates.getId())) {
            throw new Exception("\u6c47\u4ea4\u6a21\u677fid\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
        List<String> idList = Arrays.asList(concurrentTemplates.getId().split(","));
        this.removeByIds(idList);
        List concurrentTemplatesList = this.listByIds(idList);
        for (ConcurrentTemplates templates : concurrentTemplatesList) {
            FileUploadResponse fileUploadResponse = FileUploadResponse.builder().absolutePath(templates.getTemplatesUploadUrl()).build();
            this.fileServerService.deleteFile(fileUploadResponse.getAbsolutePath());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateConcurrentTemplates(ConcurrentTemplates concurrentTemplates) throws Exception {
        this.judgeSameName(concurrentTemplates);
        concurrentTemplates.setUpdateTime(new Date());
        this.saveOrUpdate(concurrentTemplates);
    }

    @Override
    public IPage<ConcurrentTemplates> queryConcurrentTemplatesPage(ConcurrentTemplates concurrentTemplates) throws Exception {
        if (ObjectUtil.isEmpty((Object)concurrentTemplates.getRows()) || ObjectUtil.isEmpty((Object)concurrentTemplates.getPage())) {
            throw new Exception("\u5206\u9875\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        Page concurrentTemplatesPage = new Page((long)concurrentTemplates.getPage().intValue(), (long)concurrentTemplates.getRows().intValue());
        return ((ConcurrentTemplatesMapper)this.baseMapper).queryConcurrentTemplatesList((Page<ConcurrentTemplates>)concurrentTemplatesPage, concurrentTemplates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileServerResponse uploadFile(MultipartFile multipartFile) {
        FileServerResponse fileUploadResponse;
        block23: {
            ArrayList fileStructureDTOList = new ArrayList();
            fileUploadResponse = new FileServerResponse();
            File file = null;
            File unzip = null;
            try {
                fileUploadResponse = this.fileServerService.sendFileToServer(multipartFile, null, false);
                file = this.fileUploadUtil.multipartFile2File(multipartFile);
                if (!file.exists()) {
                    throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728");
                }
                if (file.getName().endsWith(".zip")) {
                    try {
                        unzip = ZipUtil.unzip((File)file, (Charset)CharsetUtil.CHARSET_GBK);
                    }
                    catch (Exception e) {
                        unzip = ZipUtil.unzip((File)file, (Charset)CharsetUtil.CHARSET_UTF_8);
                    }
                    if (!unzip.exists()) {
                        throw new FileNotFoundException("\u89e3\u538b\u6587\u4ef6\u4e0d\u5b58\u5728");
                    }
                } else if (file.getName().endsWith(".7z")) {
                    try {
                        unzip = Z7zUtil.unzip7z(file);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        FileServerResponse fileServerResponse = null;
                        FileUtil.del((File)file);
                        FileUtil.del((File)unzip);
                        return fileServerResponse;
                    }
                    if (!unzip.exists()) {
                        throw new FileNotFoundException("\u89e3\u538b\u6587\u4ef6\u4e0d\u5b58\u5728");
                    }
                } else if (file.getName().endsWith(".rar")) {
                    try {
                        unzip = RarUtil.unrar(file);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        FileServerResponse fileServerResponse = null;
                        FileUtil.del((File)file);
                        FileUtil.del((File)unzip);
                        return fileServerResponse;
                    }
                    if (!unzip.exists()) {
                        throw new FileNotFoundException("\u89e3\u538b\u6587\u4ef6\u4e0d\u5b58\u5728");
                    }
                } else {
                    unzip = file;
                }
                String unzipPath = unzip.getAbsolutePath();
                this.fileUploadUtil.readFile(unzipPath, fileStructureDTOList, "-1", Integer.valueOf(1));
                fileUploadResponse.setTreeList(BaseTreeUtil.listBuildTree(fileStructureDTOList, FileStructureDTO.class, (TreeNodeConfig)this.treeNodeConfig));
                FileUtil.del((File)file);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block23;
            }
            finally {
                FileUtil.del(file);
                FileUtil.del(unzip);
            }
            FileUtil.del((File)unzip);
        }
        fileUploadResponse.setUploadId(null);
        fileUploadResponse.setServerURL(null);
        return fileUploadResponse;
    }

    @Override
    public void downloadFileById(String id, HttpServletResponse response) throws Exception {
        String fileName;
        ConcurrentTemplates concurrentTemplates = (ConcurrentTemplates)this.getById((Serializable)((Object)id));
        String[] strings = concurrentTemplates.getTemplatesUploadUrl().split("@");
        String string = fileName = strings.length == 2 ? strings[1] : strings[0];
        if (fileName.indexOf("/") > -1) {
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        }
        FileDownloadMeta fileDownloadMeta = this.fileServerService.queryDownLoadMeta(concurrentTemplates.getTemplatesUploadUrl());
        if (!fileName.contains(".")) {
            fileName = fileName + concurrentTemplates.getTemplatesUploadUrl().substring(concurrentTemplates.getTemplatesUploadUrl().lastIndexOf("."));
        }
        long fileSize = fileDownloadMeta.getFileSize();
        this.fileUploadUtil.downloadInputStream2Browser(response, fileDownloadMeta.getInputStream(), fileName, fileSize);
    }

    public void judgeSameName(ConcurrentTemplates concurrentTemplates) throws Exception {
        long countRule;
        QueryWrapper concurrentTemplatesQueryWrapper = new QueryWrapper();
        concurrentTemplatesQueryWrapper.lambda().eq(ConcurrentTemplates::getName, (Object)concurrentTemplates.getName());
        if (StrUtil.isNotBlank((CharSequence)concurrentTemplates.getId())) {
            concurrentTemplatesQueryWrapper.lambda().ne(ConcurrentTemplates::getId, (Object)concurrentTemplates.getId());
        }
        if ((countRule = this.count((Wrapper)concurrentTemplatesQueryWrapper)) > 0L) {
            throw new Exception("\u65b0\u5efa\u5931\u8d25\uff1a\u5b58\u5728\u540c\u540d\u6570\u636e\u6c47\u4ea4\u6a21\u677f\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
    }
}

