/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.adf.dms.catalog.dto.CatalogNodeDTO;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogNodeDTO;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogNodeDTO;
import com.geoway.adf.dms.catalog.service.AppCatalogNodeService;
import com.geoway.adf.dms.catalog.service.ResCatalogNodeService;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.dataset.ServiceDatasetDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.ns.base.exception.BizException;
import com.geoway.ns.zyfx.domain.ZyfxCatalog;
import com.geoway.ns.zyfx.domain.ZyfxCatalogScheme;
import com.geoway.ns.zyfx.domain.ZyfxDataset;
import com.geoway.ns.zyfx.domain.ZyfxObject;
import com.geoway.ns.zyfx.domain.ZyfxServiceset;
import com.geoway.ns.zyfx.mapper.ZyfxDatasetMapper;
import com.geoway.ns.zyfx.mapper.ZyfxServicesetMapper;
import com.geoway.ns.zyfx.service.SyncRsCatalogService;
import com.geoway.ns.zyfx.service.ZyfxCatalogSchemeService;
import com.geoway.ns.zyfx.service.ZyfxCatalogService;
import com.geoway.ns.zyfx.service.ZyfxObjectService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SyncRsCatalogServiceImpl
implements SyncRsCatalogService {
    @Resource
    AppCatalogNodeService appCatalogNodeService;
    @Autowired
    ZyfxCatalogService zyfxCatalogService;
    @Autowired
    ZyfxCatalogSchemeService zyfxCatalogSchemeService;
    @Autowired
    ZyfxDatasetMapper zyfxDatasetMapper;
    @Autowired
    ZyfxObjectService zyfxObjectService;
    @Autowired
    ZyfxServicesetMapper zyfxServicesetMapper;
    @Autowired
    ResCatalogNodeService resCatalogNodeService;
    @Resource
    private DataSourceService dataSourceService;

    @Override
    public void syncRscatalog(String catalogId, String schemeId, Integer groupType) throws Exception {
        String datasetTypes = null;
        ZyfxCatalogScheme catalogScheme = (ZyfxCatalogScheme)this.zyfxCatalogSchemeService.getById((Serializable)((Object)schemeId));
        if (catalogScheme == null) {
            throw new BizException("\u76ee\u5f55\u65b9\u6848\u4e0d\u5b58\u5728");
        }
        ResCatalogNodeDTO resCatalogNodeDTO = this.resCatalogNodeService.getCatalogTree(null, null, datasetTypes, Boolean.valueOf(false), Boolean.valueOf(false));
        List appCatalogNodeDTOS = resCatalogNodeDTO.getChildren();
        this.syncRsCatalog2ZyfxCatalog(schemeId, catalogScheme.getKey(), appCatalogNodeDTOS, groupType);
    }

    @Override
    public void syncAppCatalog(String catalogId, String schemeId, Integer groupType) throws Exception {
        String datasetTypes = null;
        ZyfxCatalogScheme catalogScheme = (ZyfxCatalogScheme)this.zyfxCatalogSchemeService.getById((Serializable)((Object)schemeId));
        if (catalogScheme == null) {
            throw new BizException("\u76ee\u5f55\u65b9\u6848\u4e0d\u5b58\u5728");
        }
        String schemeKey = catalogScheme.getKey();
        AppCatalogNodeDTO appCatalogNodeDTO = this.appCatalogNodeService.getCatalogTree(catalogId, null, null, datasetTypes, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        List appCatalogNodeDTOS = appCatalogNodeDTO.getChildren();
        this.syncAppCatalog2ZyfxCatalog(schemeId, schemeKey, appCatalogNodeDTOS, groupType);
    }

    private void syncRsCatalog2ZyfxCatalog(String schemeId, String schemeKey, List<ResCatalogNodeDTO> appCatalogNodeDTOS, Integer groupType) throws Exception {
        for (ResCatalogNodeDTO appCatalogNodeDTO : appCatalogNodeDTOS) {
            if (appCatalogNodeDTO.getNodeType() == 0) {
                this.syncOneZyfxCatalog(schemeId, schemeKey, (CatalogNodeDTO)appCatalogNodeDTO, groupType);
            } else if (appCatalogNodeDTO.getNodeType() == 1) {
                String pCatalogId;
                ZyfxCatalog pCatalog;
                Serializable zyfxDataset;
                ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)appCatalogNodeDTO;
                if (groupType == 1 && resCatalogDataNodeDTO.getDatasetType() != 30) {
                    zyfxDataset = this.syncOneZyfxDataset((CatalogNodeDTO)resCatalogDataNodeDTO);
                    if (StrUtil.isNotBlank((CharSequence)appCatalogNodeDTO.getFatherId()) && (pCatalog = (ZyfxCatalog)this.zyfxCatalogService.getById((Serializable)((Object)(pCatalogId = schemeKey + "-" + appCatalogNodeDTO.getFatherId())))) != null) {
                        this.zyfxCatalogService.regObjectSets(pCatalogId, ((ZyfxDataset)zyfxDataset).getId(), groupType);
                    }
                } else if (groupType == 2 && resCatalogDataNodeDTO.getDatasetType() == 30) {
                    zyfxDataset = this.syncOneZyfxServiceset((CatalogNodeDTO)resCatalogDataNodeDTO);
                    if (StrUtil.isNotBlank((CharSequence)appCatalogNodeDTO.getFatherId()) && (pCatalog = (ZyfxCatalog)this.zyfxCatalogService.getById((Serializable)((Object)(pCatalogId = schemeKey + "-" + appCatalogNodeDTO.getFatherId())))) != null) {
                        this.zyfxCatalogService.regObjectSets(pCatalogId, ((ZyfxServiceset)zyfxDataset).getId(), groupType);
                    }
                }
            }
            if (appCatalogNodeDTO.getChildren() == null) continue;
            this.syncRsCatalog2ZyfxCatalog(schemeId, schemeKey, appCatalogNodeDTO.getChildren(), groupType);
        }
    }

    private void syncAppCatalog2ZyfxCatalog(String schemeId, String schemeKey, List<AppCatalogNodeDTO> appCatalogNodeDTOS, Integer groupType) throws Exception {
        for (AppCatalogNodeDTO appCatalogNodeDTO : appCatalogNodeDTOS) {
            if (appCatalogNodeDTO.getNodeType() == 0) {
                this.syncOneZyfxCatalog(schemeId, schemeKey, (CatalogNodeDTO)appCatalogNodeDTO, groupType);
            } else if (appCatalogNodeDTO.getNodeType() == 1) {
                String pCatalogId;
                ZyfxCatalog pCatalog;
                Serializable zyfxDataset;
                AppCatalogDataNodeDTO appCatalogDataNodeDTO = (AppCatalogDataNodeDTO)appCatalogNodeDTO;
                if (groupType == 1 && appCatalogDataNodeDTO.getDatasetType() != 30) {
                    zyfxDataset = this.syncOneZyfxDataset((CatalogNodeDTO)appCatalogDataNodeDTO);
                    if (StrUtil.isNotBlank((CharSequence)appCatalogNodeDTO.getFatherId()) && (pCatalog = (ZyfxCatalog)this.zyfxCatalogService.getById((Serializable)((Object)(pCatalogId = schemeKey + "-" + appCatalogNodeDTO.getFatherId())))) != null) {
                        this.zyfxCatalogService.regObjectSets(pCatalogId, ((ZyfxDataset)zyfxDataset).getId(), groupType);
                    }
                } else if (groupType == 2 && appCatalogDataNodeDTO.getDatasetType() == 30) {
                    zyfxDataset = this.syncOneZyfxServiceset((CatalogNodeDTO)appCatalogDataNodeDTO);
                    if (StrUtil.isNotBlank((CharSequence)appCatalogNodeDTO.getFatherId()) && (pCatalog = (ZyfxCatalog)this.zyfxCatalogService.getById((Serializable)((Object)(pCatalogId = schemeKey + "-" + appCatalogNodeDTO.getFatherId())))) != null) {
                        this.zyfxCatalogService.regObjectSets(pCatalogId, ((ZyfxServiceset)zyfxDataset).getId(), groupType);
                    }
                }
            }
            if (appCatalogNodeDTO.getChildren() == null) continue;
            this.syncAppCatalog2ZyfxCatalog(schemeId, schemeKey, appCatalogNodeDTO.getChildren(), groupType);
        }
    }

    private void syncOneZyfxCatalog(String schemeId, String schemeKey, CatalogNodeDTO catalogNodeDTO, Integer groupType) throws Exception {
        String catalogId = String.format("%s-%s", schemeKey, catalogNodeDTO.getNodeId());
        ZyfxCatalog catalog = (ZyfxCatalog)this.zyfxCatalogService.getById((Serializable)((Object)catalogId));
        if (catalog == null) {
            catalog = new ZyfxCatalog();
            catalog.setId(catalogId);
            catalog.setName(catalogNodeDTO.getNodeName());
            catalog.setOid(catalogNodeDTO.getNodeId());
            if (catalogNodeDTO.getFatherId().equals("-1")) {
                catalog.setPid("-1");
            } else {
                catalog.setPid(schemeKey + "-" + catalogNodeDTO.getFatherId());
            }
            catalog.setSchemeid(schemeId);
            catalog.setNodetype(0);
            catalog.setGrouptype(groupType);
            try {
                this.zyfxCatalogService.saveCatalogNode(catalog, null, null, null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private ZyfxCatalog queryFatherCatalog(String schemeKey, String fatherId) {
        if (fatherId == null || fatherId.equals("-1")) {
            return null;
        }
        return (ZyfxCatalog)this.zyfxCatalogService.getById((Serializable)((Object)(schemeKey + "-" + fatherId)));
    }

    private ZyfxCatalog getZyfxCatalogFromOid(String oid) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxCatalog::getOid, (Object)oid);
        queryWrapper.last(" limit 1");
        return (ZyfxCatalog)this.zyfxCatalogService.getOne((Wrapper)queryWrapper);
    }

    private ZyfxServiceset syncOneZyfxServiceset(CatalogNodeDTO catalogNodeDTO) throws Exception {
        DatasetRenderDTO render;
        ZyfxServiceset zyfxServiceset = null;
        if (catalogNodeDTO instanceof AppCatalogDataNodeDTO) {
            zyfxServiceset = this.finddZyfxServicesetExists(((AppCatalogDataNodeDTO)catalogNodeDTO).getDatasetId());
        } else if (catalogNodeDTO instanceof ResCatalogDataNodeDTO) {
            zyfxServiceset = this.finddZyfxServicesetExists(((ResCatalogDataNodeDTO)catalogNodeDTO).getDatasetId());
        }
        ZyfxObject zyfxObject = null;
        if (zyfxServiceset == null) {
            zyfxServiceset = new ZyfxServiceset();
            zyfxObject = new ZyfxObject();
        } else {
            zyfxObject = this.zyfxObjectService.findOneNoDelete(zyfxServiceset.getId());
            if (zyfxObject == null) {
                zyfxObject = new ZyfxObject();
            }
        }
        zyfxObject.setTbsj(new Date());
        zyfxObject.setFbsj(new Date());
        zyfxObject.setName(catalogNodeDTO.getNodeName());
        zyfxObject.setGrouptype(2);
        zyfxObject.setAlias(catalogNodeDTO.getNodeName());
        zyfxObject.setShortname(catalogNodeDTO.getNodeName());
        zyfxObject.setStatus(1);
        zyfxObject.setAbstractZ(catalogNodeDTO.getDescribe());
        ServiceDatasetDTO datasetDTO = null;
        if (catalogNodeDTO instanceof AppCatalogDataNodeDTO) {
            datasetDTO = (ServiceDatasetDTO)this.dataSourceService.getDatasetDetailWithoutPwd(((AppCatalogDataNodeDTO)catalogNodeDTO).getDatasetId());
            AppCatalogDataNodeDTO appCatalogDataNodeDTO = (AppCatalogDataNodeDTO)catalogNodeDTO;
            zyfxServiceset.setTableid(appCatalogDataNodeDTO.getDatasetId());
            zyfxObject.setLb("mapservice");
            zyfxObject.setLb("analysisservice");
        } else if (catalogNodeDTO instanceof ResCatalogDataNodeDTO) {
            datasetDTO = (ServiceDatasetDTO)this.dataSourceService.getDatasetDetailWithoutPwd(((ResCatalogDataNodeDTO)catalogNodeDTO).getDatasetId());
            ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)catalogNodeDTO;
            zyfxServiceset.setTableid(resCatalogDataNodeDTO.getDatasetId());
            zyfxObject.setLb("mapservice");
            zyfxObject.setLb("analysisservice");
        }
        zyfxServiceset.setUrl(datasetDTO.getServiceUrl());
        zyfxServiceset.setVirtualUrl(datasetDTO.getServiceUrl());
        zyfxServiceset.setDatabaseid(datasetDTO.getDataSource().getKey());
        DatasetRenderDTO datasetRenderDTO = render = datasetDTO.getRender() != null ? datasetDTO.getRender() : null;
        if (render != null) {
            zyfxObject.setXmin(render.getXmin());
            zyfxObject.setYmin(render.getYmin());
            zyfxObject.setXmax(render.getXmax());
            zyfxObject.setYmax(render.getYmax());
        }
        JSONObject inputparams = new JSONObject();
        inputparams.put("defaultstyle", (Object)datasetDTO.getStyleId());
        inputparams.put("serviceName", (Object)datasetDTO.getRender().getServiceName());
        inputparams.put("server", (Object)datasetDTO.getMapServerUrl());
        inputparams.put("urls", (Object)datasetDTO.getServiceCapabilities());
        zyfxServiceset.setInputparams(inputparams.toJSONString());
        zyfxObject.setKeyword(catalogNodeDTO.getNodeName());
        zyfxObject.setAbstractZ(catalogNodeDTO.getNodeName());
        zyfxObject.setHqfs("\u7ebf\u4e0a\u83b7\u53d6");
        zyfxObject.setGxlx(2);
        zyfxObject.setFgfw(3);
        zyfxObject.setAqjb("3");
        zyfxObject.setKflx(2);
        zyfxObject.setLylx("\u5e73\u53f0\u81ea\u6709");
        zyfxObject.setStatus(1);
        this.zyfxObjectService.saveOneServiceSet(zyfxObject, zyfxServiceset, null);
        return zyfxServiceset;
    }

    private ZyfxDataset syncOneZyfxDataset(CatalogNodeDTO catalogNodeDTO) throws Exception {
        ZyfxDataset zyfxDataset = null;
        if (catalogNodeDTO instanceof AppCatalogDataNodeDTO) {
            AppCatalogDataNodeDTO appCatalogDataNodeDTO = (AppCatalogDataNodeDTO)catalogNodeDTO;
            zyfxDataset = this.finddZyfxDatasetExists(appCatalogDataNodeDTO.getDatasetId());
        } else if (catalogNodeDTO instanceof ResCatalogDataNodeDTO) {
            ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)catalogNodeDTO;
            zyfxDataset = this.finddZyfxDatasetExists(resCatalogDataNodeDTO.getDatasetId());
        }
        ZyfxObject zyfxObject = null;
        if (zyfxDataset == null) {
            zyfxDataset = new ZyfxDataset();
            zyfxObject = new ZyfxObject();
        } else {
            zyfxObject = this.zyfxObjectService.findOneNoDelete(zyfxDataset.getId());
            if (zyfxObject == null) {
                zyfxObject = new ZyfxObject();
            }
        }
        zyfxObject.setTbsj(new Date());
        zyfxObject.setFbsj(new Date());
        zyfxObject.setName(catalogNodeDTO.getNodeName());
        zyfxObject.setGrouptype(1);
        zyfxObject.setAlias(catalogNodeDTO.getNodeName());
        zyfxObject.setShortname(catalogNodeDTO.getNodeName());
        zyfxObject.setStatus(1);
        zyfxObject.setAbstractZ(catalogNodeDTO.getDescribe());
        if (catalogNodeDTO instanceof AppCatalogDataNodeDTO) {
            DatasetRenderDTO render;
            AppCatalogDataNodeDTO appCatalogDataNodeDTO = (AppCatalogDataNodeDTO)catalogNodeDTO;
            zyfxDataset.setDataid(appCatalogDataNodeDTO.getDatasetId());
            zyfxObject.setGs(DatasetTypeEnum.getByValue((Integer)appCatalogDataNodeDTO.getDatasetType()).name());
            zyfxObject.setVersion(appCatalogDataNodeDTO.getNodePhase());
            DatasetRenderDTO datasetRenderDTO = render = appCatalogDataNodeDTO.getHasRender() != false ? appCatalogDataNodeDTO.getRender() : null;
            if (render != null) {
                zyfxObject.setXmin(render.getXmin());
                zyfxObject.setYmin(render.getYmin());
                zyfxObject.setXmax(render.getXmax());
                zyfxObject.setYmax(render.getYmax());
            }
        } else if (catalogNodeDTO instanceof ResCatalogDataNodeDTO) {
            DatasetRenderDTO render;
            ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)catalogNodeDTO;
            zyfxDataset.setDataid(resCatalogDataNodeDTO.getDatasetId());
            zyfxObject.setGs(DatasetTypeEnum.getByValue((Integer)resCatalogDataNodeDTO.getDatasetType()).name());
            zyfxObject.setVersion(resCatalogDataNodeDTO.getNodePhase());
            DatasetRenderDTO datasetRenderDTO = render = resCatalogDataNodeDTO.getHasRender() != false ? resCatalogDataNodeDTO.getRender() : null;
            if (render != null) {
                zyfxObject.setXmin(render.getXmin());
                zyfxObject.setYmin(render.getYmin());
                zyfxObject.setXmax(render.getXmax());
                zyfxObject.setYmax(render.getYmax());
            }
        }
        zyfxObject.setKeyword(catalogNodeDTO.getNodeName());
        zyfxObject.setAbstractZ(catalogNodeDTO.getNodeName());
        zyfxObject.setHqfs("\u7ebf\u4e0a\u83b7\u53d6");
        zyfxObject.setGxlx(2);
        zyfxObject.setFgfw(3);
        zyfxObject.setAqjb("3");
        zyfxObject.setKflx(2);
        zyfxObject.setLb("dbtalbe");
        zyfxObject.setLylx("\u5e73\u53f0\u81ea\u6709");
        zyfxObject.setStatus(1);
        this.zyfxObjectService.saveOneDataSet(zyfxObject, zyfxDataset, null);
        return zyfxDataset;
    }

    private ZyfxDataset finddZyfxDatasetExists(String oid) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxDataset::getDataid, (Object)oid);
        queryWrapper.last(" limit 1");
        return (ZyfxDataset)this.zyfxDatasetMapper.selectOne((Wrapper)queryWrapper);
    }

    private ZyfxServiceset finddZyfxServicesetExists(String oid) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxServiceset::getTableid, (Object)oid);
        queryWrapper.last(" limit 1");
        return (ZyfxServiceset)this.zyfxServicesetMapper.selectOne((Wrapper)queryWrapper);
    }
}

