/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl;

import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.catalog.dao.AppCatalogDao;
import com.geoway.adf.dms.catalog.entity.AppCatalog;
import com.geoway.ns.base.exception.BizException;
import com.geoway.ns.sys.support.query.MPJQueryMapperUtil;
import com.geoway.ns.sys.utils.BaseTreeUtil;
import com.geoway.ns.zyfx.domain.ZyfxAccess;
import com.geoway.ns.zyfx.domain.ZyfxCatalog;
import com.geoway.ns.zyfx.domain.ZyfxCatalogObject;
import com.geoway.ns.zyfx.domain.ZyfxCatalogScheme;
import com.geoway.ns.zyfx.domain.ZyfxDataset;
import com.geoway.ns.zyfx.domain.ZyfxFavorite;
import com.geoway.ns.zyfx.domain.ZyfxFiles;
import com.geoway.ns.zyfx.domain.ZyfxImage;
import com.geoway.ns.zyfx.domain.ZyfxObject;
import com.geoway.ns.zyfx.domain.ZyfxObjectApply;
import com.geoway.ns.zyfx.domain.ZyfxServiceset;
import com.geoway.ns.zyfx.domain.ZyfxToolset;
import com.geoway.ns.zyfx.dto.ZyfxCatalogDetail;
import com.geoway.ns.zyfx.mapper.ZyfxAccessMapper;
import com.geoway.ns.zyfx.mapper.ZyfxCatalogMapper;
import com.geoway.ns.zyfx.mapper.ZyfxCatalogObjectMapper;
import com.geoway.ns.zyfx.mapper.ZyfxCatalogSchemeMapper;
import com.geoway.ns.zyfx.mapper.ZyfxFavoriteMapper;
import com.geoway.ns.zyfx.mapper.ZyfxObjectApplyMapper;
import com.geoway.ns.zyfx.service.ZyfxCatalogObjectService;
import com.geoway.ns.zyfx.service.ZyfxCatalogService;
import com.geoway.ns.zyfx.service.ZyfxFilesService;
import com.geoway.ns.zyfx.service.ZyfxImageService;
import com.geoway.ns.zyfx.service.ZyfxObjectService;
import com.github.yulichang.wrapper.JoinAbstractLambdaWrapper;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class ZyfxCatalogServiceImpl
extends ServiceImpl<ZyfxCatalogMapper, ZyfxCatalog>
implements ZyfxCatalogService {
    private final TreeNodeConfig treeNodeConfig = new TreeNodeConfig().setParentIdKey("pid").setWeightKey("createTime").setIdKey("id");
    @Autowired
    ZyfxCatalogObjectService zyfxCatalogObjectService;
    @Autowired
    ZyfxImageService zyfxImageService;
    @Autowired
    ZyfxCatalogSchemeMapper zyfxCatalogSchemeMapper;
    @Autowired
    ZyfxAccessMapper zyfxAccessMapper;
    @Autowired
    ZyfxCatalogObjectMapper zyfxCatalogObjectMapper;
    @Autowired
    ZyfxFavoriteMapper zyfxFavoriteMapper;
    @Autowired
    ZyfxObjectApplyMapper zyfxObjectApplyMapper;
    @Autowired
    ZyfxFilesService zyfxFilesService;
    @Autowired
    ZyfxObjectService zyfxObjectService;
    @Resource
    private AppCatalogDao appCatalogDao;

    @Override
    public List<ZyfxCatalog> queryTree(String filterParam, String sortParam, int groupType, String schemeId, Integer isApplication, boolean needDataNode, String keyword) throws Exception {
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, sortParam, ZyfxCatalog.class);
        if (groupType > 0) {
            queryWrapper.eq(ZyfxCatalog::getGrouptype, (Object)groupType);
        }
        queryWrapper.eq(ZyfxCatalog::getSchemeid, (Object)schemeId);
        if (needDataNode) {
            queryWrapper.selectAll(ZyfxCatalog.class);
            if (groupType == 3 && isApplication != null) {
                String subSql = "EXISTS (SELECT 1 FROM tb_zyfx_toolset ts WHERE ts.f_id = t2.f_id and (ts.f_isapplication = {0} or ts.f_isapplication IS NULL))";
                ((MPJLambdaWrapper)((MPJLambdaWrapper)queryWrapper.selectCollection(ZyfxObject.class, ZyfxCatalog::getCatalogObjects)).leftJoin(ZyfxCatalogObject.class, "zo", ZyfxCatalogObject::getCatalogid, ZyfxCatalog::getId)).leftJoin(ZyfxObject.class, "t2", on -> (JoinAbstractLambdaWrapper)((JoinAbstractLambdaWrapper)on.eq(ZyfxObject::getId, ZyfxCatalogObject::getObjectid)).apply(subSql, new Object[]{isApplication}));
            } else {
                ((MPJLambdaWrapper)((MPJLambdaWrapper)queryWrapper.selectCollection(ZyfxObject.class, ZyfxCatalog::getCatalogObjects)).leftJoin(ZyfxCatalogObject.class, "zo", ZyfxCatalogObject::getCatalogid, ZyfxCatalog::getId)).leftJoin(ZyfxObject.class, ZyfxObject::getId, ZyfxCatalogObject::getObjectid);
            }
        }
        List catalogNodes = this.list((Wrapper)queryWrapper);
        MPJLambdaWrapper wrapper = new MPJLambdaWrapper();
        wrapper.eq(ZyfxCatalogObject::getSchemeid, (Object)schemeId);
        if (groupType == 3 && isApplication != null) {
            wrapper.leftJoin(ZyfxToolset.class, "zt", ZyfxToolset::getId, ZyfxCatalogObject::getObjectid);
            wrapper.eq(ZyfxToolset::getIsapplication, (Object)isApplication);
        }
        if (groupType > 0) {
            wrapper.eq(ZyfxCatalogObject::getGrouptype, (Object)groupType);
        }
        wrapper.leftJoin(ZyfxObject.class, ZyfxObject::getId, ZyfxCatalogObject::getObjectid);
        wrapper.ne(ZyfxObject::getIsDel, (Object)1);
        String nodeCodeFld = "nodecode";
        String pidFld = "pid";
        String countFld = "icount";
        wrapper.selectAs(ZyfxCatalogObject::getCatalogcode, nodeCodeFld);
        wrapper.select(new SFunction[]{ZyfxCatalogObject::getObjectid});
        wrapper.select(new SFunction[]{ZyfxCatalogObject::getSort});
        wrapper.leftJoin(ZyfxCatalog.class, ZyfxCatalog::getCode, ZyfxCatalogObject::getCatalogcode);
        wrapper.selectAs(ZyfxCatalog::getPid, pidFld);
        List mapCounts = this.zyfxCatalogObjectService.listMaps((Wrapper)wrapper);
        for (ZyfxCatalog zyfxCatalog : catalogNodes) {
            String autoCode = zyfxCatalog.getCode();
            if (mapCounts == null || mapCounts.size() <= 0) continue;
            long icount = 0L;
            for (Map mapCount : mapCounts) {
                if (!mapCount.get(nodeCodeFld).toString().startsWith(autoCode) && !mapCount.get(pidFld).equals(zyfxCatalog.getId())) continue;
                ++icount;
                if (!mapCount.get(nodeCodeFld).toString().equals(autoCode) || zyfxCatalog.getCatalogObjects() == null) continue;
                zyfxCatalog.getCatalogObjects().forEach(p -> {
                    if (p.getId().equals(mapCount.get("f_objectid"))) {
                        p.setSort(Integer.parseInt(mapCount.get("f_sort").toString()));
                    }
                });
            }
            zyfxCatalog.setObjectCount(icount);
        }
        String pid = "-1";
        List catalogTrees = BaseTreeUtil.listToTree((List)catalogNodes, (TreeNodeConfig)this.treeNodeConfig, (String)pid);
        if (needDataNode) {
            this.mountObjectSets(catalogTrees, keyword);
        }
        return catalogTrees;
    }

    private void mountObjectSets(List<ZyfxCatalog> catalogTrees, String keyword) {
        for (ZyfxCatalog zyfxCatalog : catalogTrees) {
            if (zyfxCatalog.getChildren() != null) {
                this.mountObjectSets(zyfxCatalog.getChildren(), keyword);
            }
            if (zyfxCatalog.getNodetype() == 1) continue;
            List<ZyfxObject> catalogObjects = zyfxCatalog.getCatalogObjects();
            Collections.sort(catalogObjects, Comparator.comparing(ZyfxObject::getSort));
            if (catalogObjects == null || catalogObjects.size() <= 0) continue;
            List<ZyfxCatalog> subCatalogs = this.convertZyfxObjects2ZyfxCatalog(zyfxCatalog, catalogObjects, keyword);
            if (zyfxCatalog.getChildren() == null) {
                zyfxCatalog.setChildren(new ArrayList<ZyfxCatalog>());
            }
            zyfxCatalog.getChildren().addAll(subCatalogs);
            zyfxCatalog.setCatalogObjects(null);
        }
    }

    private List<ZyfxCatalog> convertZyfxObjects2ZyfxCatalog(ZyfxCatalog pCatalog, List<ZyfxObject> catalogObjects, String keyword) {
        ArrayList<ZyfxCatalog> catalogs = new ArrayList<ZyfxCatalog>();
        boolean i = false;
        for (ZyfxObject zObject : catalogObjects) {
            if (zObject.getIsDel() == 1 || !zObject.getName().contains(keyword)) continue;
            ZyfxCatalog catalog = new ZyfxCatalog();
            catalog.setNodetype(1);
            catalog.setSchemeid(pCatalog.getSchemeid());
            catalog.setGrouptype(zObject.getGrouptype());
            catalog.setId(zObject.getId());
            catalog.setOid(zObject.getId());
            catalog.setPid(pCatalog.getId());
            catalog.setSort(zObject.getSort());
            catalog.setName(zObject.getName());
            catalog.setBz(zObject.getAbstractZ());
            catalog.setGs(zObject.getGs());
            catalog.setVersion(zObject.getVersion());
            catalog.setLb(zObject.getLb());
            catalog.setKflx(zObject.getKflx());
            catalog.setGxlx(zObject.getGxlx());
            catalog.setHjdwid(zObject.getHjdwid());
            catalogs.add(catalog);
        }
        return catalogs;
    }

    @Override
    public void deleteNode(String id) throws BizException {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxCatalog::getPid, (Object)id);
        long icount = this.count((Wrapper)queryWrapper);
        if (icount > 0L) {
            throw new BizException("\u5b58\u5728\u5b50\u8282\u70b9\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        ZyfxCatalog catalog = (ZyfxCatalog)this.getById((Serializable)((Object)id));
        LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.likeRight(ZyfxCatalogObject::getCatalogcode, (Object)catalog.getCode());
        icount = this.zyfxCatalogObjectService.count((Wrapper)queryWrapper2);
        if (icount > 0L) {
            throw new BizException("\u8282\u70b9\u4e0b\u6709\u5173\u8054\u5bf9\u8c61\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.removeById((Serializable)((Object)id));
    }

    @Override
    public void updateName(String id, String name) {
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.set(ZyfxCatalog::getName, (Object)name);
        updateWrapper.eq(ZyfxCatalog::getId, (Object)id);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public void saveCatalogNode(ZyfxCatalog catalogNode, MultipartFile imgFile, MultipartFile logoFile, MultipartFile[] otherfiles) throws Exception {
        ZyfxImage zyfxImage;
        String iconId;
        long icount;
        boolean isNew;
        String pid = catalogNode.getPid();
        if (StrUtil.isEmpty((CharSequence)pid)) {
            pid = "-1";
            catalogNode.setPid("-1");
        }
        if (isNew = StrUtil.isBlank((CharSequence)catalogNode.getId())) {
            Long id = IdUtil.getSnowflakeNextId();
            catalogNode.setId(id.toString());
        }
        boolean isUpdate = false;
        if (!isNew) {
            ZyfxCatalog oldCatalog = (ZyfxCatalog)this.getById((Serializable)((Object)catalogNode.getId()));
            isUpdate = oldCatalog != null;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxCatalog::getName, (Object)catalogNode.getName());
        queryWrapper.eq(ZyfxCatalog::getPid, (Object)catalogNode.getPid());
        if (catalogNode.getGrouptype() != null) {
            queryWrapper.eq(ZyfxCatalog::getGrouptype, (Object)catalogNode.getGrouptype());
        }
        if (isUpdate) {
            queryWrapper.ne(ZyfxCatalog::getId, (Object)catalogNode.getId());
        }
        if ((icount = this.count((Wrapper)queryWrapper)) > 0L) {
            throw new BizException("\u540c\u4e00\u7ea7\u522b\u4e0b\u8282\u70b9\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (StrUtil.isNotBlank((CharSequence)catalogNode.getBm())) {
            queryWrapper.clear();
            queryWrapper.eq(ZyfxCatalog::getBm, (Object)catalogNode.getBm());
            queryWrapper.eq(ZyfxCatalog::getPid, (Object)catalogNode.getPid());
            if (catalogNode.getGrouptype() != null) {
                queryWrapper.eq(ZyfxCatalog::getGrouptype, (Object)catalogNode.getGrouptype());
            }
            if (isUpdate) {
                queryWrapper.ne(ZyfxCatalog::getId, (Object)catalogNode.getId());
            }
            if ((icount = this.count((Wrapper)queryWrapper)) > 0L) {
                throw new BizException("\u540c\u4e00\u7ea7\u522b\u4e0b\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
            }
        }
        if (isUpdate) {
            ZyfxCatalog updateCatalog = (ZyfxCatalog)this.getById((Serializable)((Object)catalogNode.getId()));
            catalogNode.setSort(updateCatalog.getSort());
            catalogNode.setCode(updateCatalog.getCode());
            if ("-1".equals(catalogNode.getImgid()) && StrUtil.isNotBlank((CharSequence)updateCatalog.getImgid())) {
                this.zyfxImageService.removeById((Serializable)((Object)updateCatalog.getImgid()));
            }
            if ("-1".equals(catalogNode.getLogoid()) && StrUtil.isNotBlank((CharSequence)updateCatalog.getLogoid())) {
                this.zyfxImageService.removeById((Serializable)((Object)updateCatalog.getLogoid()));
            }
        } else {
            String maxNodeCode = this.queryMaxNodeCode(pid, catalogNode.getSchemeid());
            String nodeCode = null;
            int level = 0;
            if (StrUtil.isNotEmpty((CharSequence)maxNodeCode)) {
                int start = maxNodeCode.lastIndexOf("-");
                String addCode = maxNodeCode.substring(start + 1);
                String pNodeCode = maxNodeCode.substring(0, start == -1 ? maxNodeCode.length() : start);
                int iCode = Integer.parseInt(addCode);
                nodeCode = String.format("%s-%d", pNodeCode, iCode + 1);
            } else {
                ZyfxCatalog pCatalogNode = (ZyfxCatalog)this.getById((Serializable)((Object)pid));
                if (pCatalogNode == null) {
                    level = 1;
                    ZyfxCatalogScheme scheme = (ZyfxCatalogScheme)this.zyfxCatalogSchemeMapper.selectById((Serializable)((Object)catalogNode.getSchemeid()));
                    if (scheme == null) {
                        throw new BizException("\u76ee\u5f55\u65b9\u6848\u4e0d\u5b58\u5728");
                    }
                    nodeCode = String.format("%s%s-%d", scheme.getKey(), pid, 10000);
                } else {
                    nodeCode = String.format("%s-%d", pCatalogNode.getCode(), 10000);
                    if (pCatalogNode.getLevel() != null) {
                        level = pCatalogNode.getLevel() + 1;
                    }
                }
            }
            catalogNode.setCode(nodeCode);
            catalogNode.setLevel(level);
            long order = this.queryMaxSort(pid, catalogNode.getSchemeid()) + 1L;
            catalogNode.setSort((int)order);
        }
        if (imgFile != null && imgFile.getInputStream() != null) {
            iconId = catalogNode.getImgid();
            zyfxImage = this.zyfxImageService.updateZyfxImage(iconId, imgFile.getInputStream(), "catalog");
            catalogNode.setImgid(zyfxImage.getId());
        }
        if (logoFile != null && logoFile.getInputStream() != null) {
            iconId = catalogNode.getLogoid();
            zyfxImage = this.zyfxImageService.updateZyfxImage(iconId, logoFile.getInputStream(), "catalog");
            catalogNode.setLogoid(zyfxImage.getId());
        }
        this.saveOrUpdate(catalogNode);
        if (otherfiles != null) {
            this.zyfxFilesService.saveFiles(otherfiles, catalogNode.getId(), "catalog", false, false);
        }
    }

    @Override
    public void regObjectSets(String nodeId, String objectIds, int groupType) {
        String[] objectIdArr;
        ZyfxCatalog catalog = (ZyfxCatalog)this.getById((Serializable)((Object)nodeId));
        if (catalog == null) {
            return;
        }
        for (String objectId : objectIdArr = objectIds.split(",")) {
            this.zyfxCatalogObjectService.saveIfNotExists(catalog.getSchemeid(), nodeId, objectId, catalog.getCode(), groupType);
        }
    }

    @Override
    public JSONObject serviceFiltering(String token, String url, String type) throws Exception {
        String id;
        JSONObject obj;
        int i;
        JSONArray resultsArray;
        JSONArray filteredArray;
        List<String> oids;
        String responseStr = ((HttpRequest)((HttpRequest)HttpRequest.get((String)url).header("access-token", "Geoway")).header("access_token", token)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject resJson = JSON.parseObject((String)responseStr);
        if (type.equals("analy") && resJson.getString("Message").equals("success")) {
            oids = this.zyfxObjectService.findOids();
            filteredArray = new JSONArray();
            resultsArray = resJson.getJSONArray("Results");
            for (i = 0; i < resultsArray.size(); ++i) {
                obj = resultsArray.getJSONObject(i);
                if (!obj.containsKey((Object)"id") || oids.contains(id = obj.getString("id"))) continue;
                filteredArray.add((Object)obj);
            }
            resJson.put("Results", (Object)filteredArray);
        }
        if (type.equals("ime") && resJson.getString("status").equals("ok")) {
            oids = this.zyfxObjectService.findOids();
            filteredArray = new JSONArray();
            resultsArray = resJson.getJSONArray("results");
            for (i = 0; i < resultsArray.size(); ++i) {
                obj = resultsArray.getJSONObject(i);
                if (!obj.containsKey((Object)"id") || oids.contains(id = obj.getString("id"))) continue;
                filteredArray.add((Object)obj);
            }
            resJson.put("Results", (Object)filteredArray);
        }
        return resJson;
    }

    @Override
    public void regServerBatch(String serverJson, Integer groupType) throws Exception {
        JSONArray jsonArray = JSONArray.parseArray((String)serverJson);
        for (int i = 0; i < jsonArray.size(); ++i) {
            ZyfxObject zyfxObject;
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String nodeId = jsonObject.getString("nodeId");
            if (groupType == 1) {
                zyfxObject = (ZyfxObject)jsonObject.toJavaObject(ZyfxObject.class);
                zyfxObject.setGrouptype(groupType);
                ZyfxDataset zyfxDataset = (ZyfxDataset)jsonObject.toJavaObject(ZyfxDataset.class);
                this.regServer(nodeId, zyfxObject, zyfxDataset);
                continue;
            }
            if (groupType != 2) continue;
            zyfxObject = (ZyfxObject)jsonObject.toJavaObject(ZyfxObject.class);
            zyfxObject.setGrouptype(groupType);
            ZyfxServiceset zyfxServiceset = (ZyfxServiceset)jsonObject.toJavaObject(ZyfxServiceset.class);
            this.regServer(nodeId, zyfxObject, zyfxServiceset);
        }
    }

    public void regServer(String nodeId, ZyfxObject zyfxObject, Object detailObject) throws Exception {
        String oid = zyfxObject.getOid();
        int groupType = zyfxObject.getGrouptype();
        if (this.zyfxObjectService.existsByOidAndLb(oid, zyfxObject.getLb())) {
            throw new RuntimeException("\u5bf9\u8c61\u5df2\u7ecf\u6ce8\u518c\uff01");
        }
        String objectId = null;
        zyfxObject.setOid(oid);
        if (zyfxObject.getGrouptype() == 1) {
            ZyfxDataset zyfxDataset = (ZyfxDataset)detailObject;
            objectId = this.zyfxObjectService.saveOneDataSet(zyfxObject, zyfxDataset, null);
        } else if (zyfxObject.getGrouptype() == 2) {
            ZyfxServiceset zyfxServiceset = (ZyfxServiceset)detailObject;
            objectId = this.zyfxObjectService.saveOneServiceSet(zyfxObject, zyfxServiceset, null);
        } else if (zyfxObject.getGrouptype() == 3) {
            ZyfxToolset zyfxToolset = (ZyfxToolset)detailObject;
            objectId = this.zyfxObjectService.saveOneToolSet(zyfxObject, zyfxToolset, null);
        }
        ZyfxCatalog catalogNode = (ZyfxCatalog)this.getById((Serializable)((Object)nodeId));
        if (catalogNode == null) {
            return;
        }
        this.zyfxCatalogObjectService.saveIfNotExists(catalogNode.getSchemeid(), nodeId, objectId, catalogNode.getCode(), groupType);
    }

    @Override
    public void unRegObjectSets(String nodeId, String objectIds, int groupType) {
        String[] setIdArr;
        for (String setId : setIdArr = objectIds.split(",")) {
            this.zyfxCatalogObjectService.remove(nodeId, setId);
        }
    }

    @Override
    public ZyfxCatalogDetail queryCatalogDetail(String id) {
        ZyfxCatalog catalog = (ZyfxCatalog)this.getById((Serializable)((Object)id));
        if (catalog == null) {
            return null;
        }
        ZyfxCatalogDetail catalogDetail = new ZyfxCatalogDetail();
        BeanUtils.copyProperties((Object)catalog, (Object)catalogDetail);
        MPJLambdaWrapper queryWrapper = new MPJLambdaWrapper();
        queryWrapper.leftJoin(ZyfxObject.class, ZyfxObject::getId, ZyfxAccess::getObjectid);
        queryWrapper.leftJoin(ZyfxCatalogObject.class, ZyfxCatalogObject::getObjectid, ZyfxObject::getId);
        queryWrapper.leftJoin(ZyfxCatalog.class, ZyfxCatalog::getId, ZyfxCatalogObject::getCatalogid);
        queryWrapper.ne(ZyfxObject::getIsDel, (Object)1);
        queryWrapper.likeRight(ZyfxCatalogObject::getCatalogcode, (Object)catalogDetail.getCode());
        queryWrapper.eq(ZyfxCatalogObject::getSchemeid, (Object)catalogDetail.getSchemeid());
        queryWrapper.selectSum(ZyfxAccess::getAccesscount, "allCount");
        List results = this.zyfxAccessMapper.selectObjs((Wrapper)queryWrapper);
        if (results != null && results.size() > 0) {
            Object objectCount = results.get(0);
            long accessCount = objectCount == null ? 0L : (Long)objectCount;
            catalogDetail.setAccessCount(accessCount);
        }
        MPJLambdaWrapper queryWrapper2 = new MPJLambdaWrapper();
        queryWrapper2.leftJoin(ZyfxObject.class, ZyfxObject::getId, ZyfxCatalogObject::getObjectid);
        queryWrapper2.likeRight(ZyfxCatalogObject::getCatalogcode, (Object)catalogDetail.getCode());
        queryWrapper2.ne(ZyfxObject::getIsDel, (Object)1);
        queryWrapper2.eq(ZyfxCatalogObject::getGrouptype, (Object)1);
        queryWrapper2.eq(ZyfxCatalogObject::getSchemeid, (Object)catalogDetail.getSchemeid());
        long datasetCount = this.zyfxCatalogObjectMapper.selectCount((Wrapper)queryWrapper2);
        catalogDetail.setDatasetCount(datasetCount);
        queryWrapper2.clear();
        queryWrapper2.leftJoin(ZyfxObject.class, ZyfxObject::getId, ZyfxCatalogObject::getObjectid);
        queryWrapper2.likeRight(ZyfxCatalogObject::getCatalogcode, (Object)catalogDetail.getCode());
        queryWrapper2.ne(ZyfxObject::getIsDel, (Object)1);
        queryWrapper2.eq(ZyfxCatalogObject::getGrouptype, (Object)2);
        queryWrapper2.eq(ZyfxCatalogObject::getSchemeid, (Object)catalogDetail.getSchemeid());
        long serviceCount = this.zyfxCatalogObjectMapper.selectCount((Wrapper)queryWrapper2);
        catalogDetail.setServicesetCount(serviceCount);
        queryWrapper2.clear();
        queryWrapper2.leftJoin(ZyfxObject.class, ZyfxObject::getId, ZyfxCatalogObject::getObjectid);
        queryWrapper2.likeRight(ZyfxCatalogObject::getCatalogcode, (Object)catalogDetail.getCode());
        queryWrapper2.ne(ZyfxObject::getIsDel, (Object)1);
        queryWrapper2.eq(ZyfxCatalogObject::getGrouptype, (Object)3);
        queryWrapper2.eq(ZyfxCatalogObject::getSchemeid, (Object)catalogDetail.getSchemeid());
        long toolCount = this.zyfxCatalogObjectMapper.selectCount((Wrapper)queryWrapper2);
        catalogDetail.setToolsetCount(toolCount);
        MPJLambdaWrapper queryWrapper3 = new MPJLambdaWrapper();
        queryWrapper3.leftJoin(ZyfxObject.class, ZyfxObject::getId, ZyfxFavorite::getObjectid);
        queryWrapper3.leftJoin(ZyfxCatalogObject.class, ZyfxCatalogObject::getObjectid, ZyfxFavorite::getObjectid);
        queryWrapper3.leftJoin(ZyfxCatalog.class, ZyfxCatalog::getId, ZyfxCatalogObject::getCatalogid);
        queryWrapper3.ne(ZyfxObject::getIsDel, (Object)1);
        queryWrapper3.likeRight(ZyfxCatalogObject::getCatalogcode, (Object)catalogDetail.getCode());
        queryWrapper3.eq(ZyfxCatalogObject::getSchemeid, (Object)catalogDetail.getSchemeid());
        long favoriteCount = this.zyfxFavoriteMapper.selectCount((Wrapper)queryWrapper3);
        catalogDetail.setFavoriteCount(favoriteCount);
        MPJLambdaWrapper queryWrapper4 = new MPJLambdaWrapper();
        queryWrapper4.leftJoin(ZyfxObject.class, ZyfxObject::getId, ZyfxObjectApply::getObjectid);
        queryWrapper4.leftJoin(ZyfxCatalogObject.class, ZyfxCatalogObject::getObjectid, ZyfxObjectApply::getObjectid);
        queryWrapper4.leftJoin(ZyfxCatalog.class, ZyfxCatalog::getId, ZyfxCatalogObject::getCatalogid);
        queryWrapper4.ne(ZyfxObject::getIsDel, (Object)1);
        queryWrapper4.likeRight(ZyfxCatalogObject::getCatalogcode, (Object)catalogDetail.getCode());
        queryWrapper4.eq(ZyfxCatalogObject::getSchemeid, (Object)catalogDetail.getSchemeid());
        long applyCount = this.zyfxObjectApplyMapper.selectCount((Wrapper)queryWrapper4);
        catalogDetail.setApplyCount(applyCount);
        List<ZyfxFiles> zyfxFiles = this.zyfxFilesService.queryZyfxFilesByObjectId(id, "catalog");
        catalogDetail.setFiles(zyfxFiles);
        return catalogDetail;
    }

    @Override
    public void batchDeleteNodes(String nodeIds) {
    }

    @Override
    public void bindMetadata() {
        ((ZyfxCatalogMapper)this.getBaseMapper()).bindMetadata();
    }

    @Override
    public void sortCatalog(String id, int sortType) {
        int tempSort;
        boolean isBottom;
        ZyfxCatalog catalog = (ZyfxCatalog)this.getById((Serializable)((Object)id));
        if (catalog == null) {
            return;
        }
        boolean isTop = sortType == 1;
        boolean isUp = sortType == 2;
        boolean isDown = sortType == 3;
        boolean bl = isBottom = sortType == 4;
        if (!(isTop || isUp || isDown || isBottom)) {
            return;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxCatalog::getPid, (Object)catalog.getPid());
        queryWrapper.eq(ZyfxCatalog::getSchemeid, (Object)catalog.getSchemeid());
        queryWrapper.orderByAsc(ZyfxCatalog::getSort);
        List allCatalogs = this.list((Wrapper)queryWrapper);
        if (allCatalogs == null || allCatalogs.size() <= 1) {
            return;
        }
        int currentIndex = allCatalogs.indexOf(catalog);
        if (currentIndex == -1) {
            return;
        }
        if (isUp) {
            if (currentIndex <= 0) {
                return;
            }
            ZyfxCatalog prevCatalog = (ZyfxCatalog)allCatalogs.get(currentIndex - 1);
            tempSort = catalog.getSort();
            catalog.setSort(prevCatalog.getSort());
            prevCatalog.setSort(tempSort);
        } else if (isDown) {
            if (currentIndex >= allCatalogs.size() - 1) {
                return;
            }
            ZyfxCatalog nextCatalog = (ZyfxCatalog)allCatalogs.get(currentIndex + 1);
            tempSort = catalog.getSort();
            catalog.setSort(nextCatalog.getSort());
            nextCatalog.setSort(tempSort);
        } else if (isTop) {
            if (currentIndex == 0) {
                return;
            }
            allCatalogs.remove(currentIndex);
            allCatalogs.add(0, catalog);
            for (int i = 0; i < allCatalogs.size(); ++i) {
                ((ZyfxCatalog)allCatalogs.get(i)).setSort(i + 1);
            }
        } else if (isBottom) {
            if (currentIndex == allCatalogs.size() - 1) {
                return;
            }
            allCatalogs.remove(currentIndex);
            allCatalogs.add(catalog);
            for (int i = 0; i < allCatalogs.size(); ++i) {
                ((ZyfxCatalog)allCatalogs.get(i)).setSort(i + 1);
            }
        }
        for (ZyfxCatalog cat : allCatalogs) {
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.set(ZyfxCatalog::getSort, (Object)cat.getSort());
            updateWrapper.eq(ZyfxCatalog::getId, (Object)cat.getId());
            this.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public void sortData(String id, int sortType, String dataId) {
        boolean idDn;
        ZyfxCatalog catalog = (ZyfxCatalog)this.getById((Serializable)((Object)id));
        if (catalog == null) {
            return;
        }
        boolean isUp = sortType == 1 || sortType == 2;
        boolean bl = idDn = sortType == 3 || sortType == 4;
        if (!isUp && !idDn) {
            return;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxCatalogObject::getCatalogcode, (Object)catalog.getCode());
        if (isUp) {
            queryWrapper.orderByAsc(ZyfxCatalogObject::getSort);
        } else {
            queryWrapper.orderByDesc(ZyfxCatalogObject::getSort);
        }
        List sortCatalogs = this.zyfxCatalogObjectMapper.selectList((Wrapper)queryWrapper);
        if (null == sortCatalogs) {
            return;
        }
        ZyfxCatalogObject catalogObject = sortCatalogs.stream().filter(f -> f.getObjectid().equals(dataId)).findFirst().orElse(null);
        int index = sortCatalogs.indexOf(catalogObject);
        if (index <= 0) {
            return;
        }
        int size = sortCatalogs.size();
        int icount = isUp ? 1 : size;
        for (ZyfxCatalogObject sortCatalog : sortCatalogs) {
            sortCatalog.setSort(icount);
            if (isUp) {
                ++icount;
                continue;
            }
            --icount;
        }
        int exchangeIndex = 0;
        if (sortType == 2 || sortType == 3) {
            exchangeIndex = index - 1;
        }
        ZyfxCatalogObject exchangeCatalog = (ZyfxCatalogObject)sortCatalogs.get(exchangeIndex);
        ZyfxCatalogObject sortCatalog = (ZyfxCatalogObject)sortCatalogs.get(index);
        int exchangeSort = exchangeCatalog.getSort();
        exchangeCatalog.setSort(sortCatalog.getSort());
        sortCatalog.setSort(exchangeSort);
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        for (ZyfxCatalogObject sortCatalg : sortCatalogs) {
            updateWrapper.clear();
            updateWrapper.set(ZyfxCatalogObject::getSort, (Object)sortCatalg.getSort());
            updateWrapper.eq(ZyfxCatalogObject::getId, (Object)sortCatalg.getId());
            this.zyfxCatalogObjectMapper.update(null, (Wrapper)updateWrapper);
        }
    }

    private String queryMaxNodeCode(String pid, String schemeId) {
        String aliasname = "maxcode";
        MPJLambdaWrapper queryWrapper = new MPJLambdaWrapper();
        ((MPJLambdaWrapper)((MPJLambdaWrapper)queryWrapper.selectMax(ZyfxCatalog::getCode, aliasname)).eq(ZyfxCatalog::getPid, (Object)pid)).eq(ZyfxCatalog::getSchemeid, (Object)schemeId);
        Map mapResult = this.getMap((Wrapper)queryWrapper);
        String maxNodeCode = "";
        if (mapResult != null && mapResult.containsKey(aliasname)) {
            maxNodeCode = mapResult.get(aliasname) == null ? "" : mapResult.get(aliasname).toString();
        }
        return maxNodeCode;
    }

    private long queryMaxSort(String pid, String schemeId) {
        String aliasname = "maxsort";
        MPJLambdaWrapper queryWrapper = new MPJLambdaWrapper();
        ((MPJLambdaWrapper)((MPJLambdaWrapper)queryWrapper.selectMax(ZyfxCatalog::getSort, aliasname)).eq(ZyfxCatalog::getPid, (Object)pid)).eq(ZyfxCatalog::getSchemeid, (Object)schemeId);
        Map mapResult = this.getMap((Wrapper)queryWrapper);
        long maxSort = 0L;
        if (mapResult != null && mapResult.containsKey(aliasname)) {
            maxSort = mapResult.get(aliasname) == null ? 0L : (Long)mapResult.get(aliasname);
        }
        return maxSort;
    }

    @Override
    public Map<String, Object> appCatalogExport() {
        List appCatalogList = this.appCatalogDao.selectAll();
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (AppCatalog appcatalog : appCatalogList) {
            results.put(appcatalog.getName(), ((ZyfxCatalogMapper)this.getBaseMapper()).appCatalogExport(appcatalog.getId()));
        }
        return results;
    }
}

