/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl;

import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.base.exception.BizException;
import com.geoway.ns.sys.support.query.MPJQueryMapperUtil;
import com.geoway.ns.sys.utils.BaseTreeUtil;
import com.geoway.ns.zyfx.domain.ZyfxOrganization;
import com.geoway.ns.zyfx.mapper.ZyfxOrganizationMapper;
import com.geoway.ns.zyfx.service.ZyfxOrganizationService;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class ZyfxOrganizationServiceImpl
extends ServiceImpl<ZyfxOrganizationMapper, ZyfxOrganization>
implements ZyfxOrganizationService {
    private final TreeNodeConfig treeNodeConfig = new TreeNodeConfig().setParentIdKey("pid").setWeightKey("sort").setIdKey("id");

    @Override
    public void saveOrganization(ZyfxOrganization organization) throws BizException {
        long icount;
        ZyfxOrganization oldOrg;
        String pid = organization.getPid();
        if (StrUtil.isEmpty((CharSequence)pid)) {
            pid = "-1";
            organization.setPid("-1");
        }
        boolean isNew = (oldOrg = (ZyfxOrganization)this.getById((Serializable)((Object)organization.getId()))) == null;
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxOrganization::getName, (Object)organization.getName());
        queryWrapper.eq(ZyfxOrganization::getPid, (Object)organization.getPid());
        if (!isNew) {
            queryWrapper.ne(ZyfxOrganization::getId, (Object)organization.getId());
        }
        if ((icount = this.count((Wrapper)queryWrapper)) > 0L) {
            throw new BizException("\u540c\u4e00\u7ea7\u522b\u4e0b\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (isNew) {
            ZyfxOrganization pOrg;
            int level = 1;
            if (StrUtil.isNotBlank((CharSequence)organization.getId()) && !organization.getId().equals("-1") && (pOrg = (ZyfxOrganization)this.getById((Serializable)((Object)organization.getPid()))) != null) {
                level = pOrg.getLevel() + 1;
            }
            organization.setLevel(level);
            String maxNodeCode = this.queryMaxNodeCode(pid);
            String nodeCode = null;
            if (StrUtil.isNotEmpty((CharSequence)maxNodeCode)) {
                String pNodeCode = "";
                int start = maxNodeCode.length() - 4;
                String addCode = maxNodeCode.substring(start);
                if (maxNodeCode.length() > 4) {
                    pNodeCode = maxNodeCode.substring(0, start);
                }
                int iCode = Integer.parseInt(addCode);
                nodeCode = String.format("%s%d", pNodeCode, iCode + 1);
            } else if ("-1".equals(pid)) {
                nodeCode = "1000";
            } else {
                ZyfxOrganization pOrg2 = (ZyfxOrganization)this.getById((Serializable)((Object)pid));
                nodeCode = String.format("%s%d", pOrg2.getNodecode(), 1000);
            }
            organization.setNodecode(nodeCode);
            int maxOrder = this.queryMaxSort(pid);
            int order = maxOrder++;
            organization.setSort(order);
        } else {
            organization.setNodecode(oldOrg.getNodecode());
            organization.setSort(oldOrg.getSort());
            organization.setLevel(oldOrg.getLevel());
        }
        this.saveOrUpdate(organization);
    }

    @Override
    public List<ZyfxOrganization> queryTree(String filterParam, String sortParam) throws Exception {
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, sortParam, ZyfxOrganization.class);
        List orgs = this.list((Wrapper)queryWrapper);
        return BaseTreeUtil.listToTree((List)orgs, (TreeNodeConfig)this.treeNodeConfig, (String)"-1");
    }

    private String queryMaxNodeCode(String pid) {
        String aliasname = "maxcode";
        MPJLambdaWrapper queryWrapper = new MPJLambdaWrapper();
        ((MPJLambdaWrapper)queryWrapper.selectMax(ZyfxOrganization::getNodecode, aliasname)).eq(ZyfxOrganization::getPid, (Object)pid);
        Map mapResult = this.getMap((Wrapper)queryWrapper);
        String maxNodeCode = "";
        if (mapResult.containsKey(aliasname)) {
            maxNodeCode = mapResult.get(aliasname).toString();
        }
        return maxNodeCode;
    }

    private int queryMaxSort(String pid) {
        String aliasname = "maxsort";
        MPJLambdaWrapper queryWrapper = new MPJLambdaWrapper();
        ((MPJLambdaWrapper)queryWrapper.selectMax(ZyfxOrganization::getSort, aliasname)).eq(ZyfxOrganization::getPid, (Object)pid);
        Map mapResult = this.getMap((Wrapper)queryWrapper);
        int maxSort = 0;
        if (mapResult.containsKey(aliasname)) {
            maxSort = Integer.parseInt(mapResult.get(aliasname).toString());
        }
        return maxSort;
    }
}

