/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sx.biz.dzzh.config;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.sx.biz.dzzh.mo.ApiResult;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@ConfigurationProperties(prefix="sx.disaster.camera")
public class DisasterCameraConfig {
    private static final Logger log = LoggerFactory.getLogger(DisasterCameraConfig.class);
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    public String url = "https://spjk.sxdzhj.com.cn:10010";
    public String username = "user01";
    public String password = "987258c98074e96a7b69c89d22f0aab0";
    protected String tokenKey = "disaster-camera-token";

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public DisasterCameraConfig() {
    }

    public DisasterCameraConfig(String url, String username, String password) {
        this.url = url;
    }

    public ApiResult get(String uri, Map<String, String> params) {
        String url;
        String string = url = uri.startsWith("http:") ? uri : this.getUrl() + uri;
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put("token", this.getToken());
        HttpResponse response = HttpRequest.get((String)url).body(JSON.toJSONString(params)).execute();
        String resString = response.body();
        log.info("get\u8c03\u7528\u63a5\u53e3:{},status:{},\u8fd4\u56de\u7ed3\u679c:{}", new Object[]{url, response.getStatus(), resString});
        if (response.getStatus() == 401 && resString.indexOf("Unauthorized") != -1) {
            this.redisTemplate.delete((Object)this.tokenKey);
            params.put("token", this.getToken());
            response = HttpRequest.get((String)url).body(JSON.toJSONString(params)).execute();
            resString = response.body();
            log.info("get\u8c03\u7528\u63a5\u53e3:{},status:{},\u8fd4\u56de\u7ed3\u679c:{}", new Object[]{url, response.getStatus(), resString});
        }
        ApiResult result = new ApiResult();
        result.setStatus(response.getStatus());
        result.setBody(response.body());
        result.setSuccess(response.isOk());
        return result;
    }

    public ApiResult post(String uri, Map<String, Object> params) {
        String url;
        String string = url = uri.startsWith("http:") ? uri : this.getUrl() + uri;
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.put("token", this.getToken());
        HttpResponse response = HttpRequest.post((String)url).form(params).execute();
        String resString = response.body();
        log.info("post\u8c03\u7528\u63a5\u53e3:{},status:{},\u8fd4\u56de\u7ed3\u679c:{}", new Object[]{url, response.getStatus(), resString});
        ApiResult result = new ApiResult();
        result.setStatus(response.getStatus());
        result.setBody(response.body());
        result.setSuccess(response.isOk());
        return result;
    }

    public String getToken() {
        String token = (String)this.redisTemplate.opsForValue().get((Object)this.tokenKey);
        if (token == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("username", this.username);
            hashMap.put("password", this.password);
            String resStr = HttpRequest.get((String)(this.getUrl() + "/api/v1/login")).body(JSON.toJSONString(hashMap)).execute().body();
            JSONObject jsonObj = JSONObject.parseObject((String)resStr);
            token = jsonObj.getString("URLToken");
            this.redisTemplate.opsForValue().set((Object)this.tokenKey, (Object)token, jsonObj.getLongValue("TokenTimeout") * 1000L);
        }
        return token;
    }
}

