/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sx.biz.dzzh.controller;

import cn.hutool.core.util.StrUtil;
import com.geoway.ns.sx.biz.dzzh.enums.SersorOnlineStatusEnum;
import com.geoway.ns.sx.biz.dzzh.mapper.SensorPoMapper;
import com.geoway.ns.sx.biz.dzzh.mo.StreamDeviceMo;
import com.geoway.ns.sx.biz.dzzh.seo.StreamDeviceSeo;
import com.geoway.ns.sx.biz.dzzh.service.CameraDeviceService;
import com.geoway.ns.sx.biz.dzzh.vo.CamCameraControlVo;
import com.geoway.ns.sx.biz.dzzh.vo.StreamVo;
import com.geoway.ns.sys.dto.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/camera/opt"})
@Api(tags={"\u5730\u707e\u89c6\u9891\u8bbe\u5907\u64cd\u4f5c"})
public class CameraOptController {
    @Autowired
    private CameraDeviceService cameraDeviceService;
    @Autowired
    private SensorPoMapper sensorPoMapper;

    @ApiOperation(value="\u4e91\u53f0\u63a7\u5236")
    @RequestMapping(value={"/controlPtz"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult<?> controlPtz(@Validated CamCameraControlVo controlVo) throws Exception {
        if (StrUtil.isBlank((CharSequence)controlVo.getCameraId())) {
            throw new Exception("\u6444\u50cf\u5934ID\u5fc5\u4f20");
        }
        boolean cuss = this.cameraDeviceService.controlPtz(controlVo.getCameraId(), controlVo.getCommand(), controlVo.getSpeed(), null, null);
        if (cuss) {
            return RestResult.success((Object)"\u6210\u529f");
        }
        return RestResult.error((String)"\u4e91\u53f0\u64cd\u4f5c\u5931\u8d25");
    }

    @ApiOperation(value="\u53d6\u64ad\u653e\u6d41")
    @RequestMapping(value={"/live"}, method={RequestMethod.GET})
    @ResponseBody
    public RestResult<StreamVo> live(@ApiParam(value="\u6444\u50cf\u5934ID") @RequestParam(value="cameraId") String cameraId) throws Exception {
        StreamDeviceSeo seo = new StreamDeviceSeo();
        seo.setSerial(cameraId);
        StreamDeviceMo streamMo = this.cameraDeviceService.getStreamDevice(seo);
        if (streamMo.isOffline()) {
            this.sensorPoMapper.updateVideoSensorOnlineStatus(cameraId, SersorOnlineStatusEnum.\u79bb\u7ebf);
        } else {
            this.sensorPoMapper.updateVideoSensorOnlineStatus(cameraId, SersorOnlineStatusEnum.\u5728\u7ebf);
        }
        StreamVo res = new StreamVo();
        BeanUtils.copyProperties((Object)streamMo, (Object)res);
        return RestResult.success((Object)res);
    }
}

