/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sx.biz.dzzh.controller;

import com.geoway.ns.sx.biz.dzzh.mo.HiddenTypeCountMo;
import com.geoway.ns.sx.biz.dzzh.mo.MonitorTypeCountMo;
import com.geoway.ns.sx.biz.dzzh.service.CamDeviceRegionService;
import com.geoway.ns.sx.biz.dzzh.service.WarningEventService;
import com.geoway.ns.sx.biz.dzzh.vo.MonitorTypeCountVo;
import com.geoway.ns.sys.dto.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/dzzh/statistics"})
@Api(tags={"\u5730\u707e\u76d1\u6d4b\u7edf\u8ba1"})
public class DzzhStatisticsController {
    @Autowired
    private WarningEventService warningEventService;
    @Autowired
    private CamDeviceRegionService camDeviceRegionService;

    @RequestMapping(value={"/monitorPointType"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u76d1\u6d4b\u70b9\u7c7b\u578b\u7edf\u8ba1")
    public RestResult<?> monitorPointTypeMoList(@RequestParam(required=true, value="areaCode") String areaCode) throws Exception {
        String codeFormat = this.camDeviceRegionService.areaCodeFormat(areaCode);
        List<MonitorTypeCountMo> monitorPointTypeMoMoList = this.warningEventService.getMonitorPointType(codeFormat);
        return RestResult.success(monitorPointTypeMoMoList);
    }

    @RequestMapping(value={"/hiddenPointType"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u9690\u60a3\u70b9\u7c7b\u578b\u7edf\u8ba1")
    public RestResult<?> hiddenPointTypeMoList(@RequestParam(required=true, value="areaCode") String areaCode) throws Exception {
        String codeFormat = this.camDeviceRegionService.areaCodeFormat(areaCode);
        List<HiddenTypeCountMo> monitorPointTypeMoMoList = this.warningEventService.getHiddenPointType(codeFormat);
        return RestResult.success(monitorPointTypeMoMoList);
    }

    @RequestMapping(value={"/getDeviceSensorOnline"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u7edf\u8ba1\u8bbe\u5907\u4f20\u611f\u5668\u5728\u7ebf\u6570\u91cf")
    public RestResult<MonitorTypeCountVo> deviceSensorOnlineList(@RequestParam(value="areaCode") String areaCode) throws Exception {
        String codeFormat = this.camDeviceRegionService.areaCodeFormat(areaCode);
        List<MonitorTypeCountMo> monitorPointTypeMoMoList = this.warningEventService.getDeviceSensorOnline(codeFormat);
        MonitorTypeCountVo vo = new MonitorTypeCountVo();
        for (MonitorTypeCountMo mo : monitorPointTypeMoMoList) {
            if (StringUtils.equalsIgnoreCase((CharSequence)mo.getTypeCode(), (CharSequence)"onlineDevice")) {
                vo.setDeviceOnlineCount(mo.getCount() == null ? 0L : mo.getCount());
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)mo.getTypeCode(), (CharSequence)"offlineDevice")) {
                vo.setDeviceOffLineCount(mo.getCount() == null ? 0L : mo.getCount());
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)mo.getTypeCode(), (CharSequence)"onlineSensor")) {
                vo.setSensorOnlineCount(mo.getCount() == null ? 0L : mo.getCount());
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)mo.getTypeCode(), (CharSequence)"offlineSensor")) continue;
            vo.setSensorOffLineCount(mo.getCount() == null ? 0L : mo.getCount());
        }
        vo.fitRate();
        return RestResult.success((Object)vo);
    }
}

