/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sx.biz.dzzh.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.datasource.service.DistrictService;
import com.geoway.ns.sx.biz.dzzh.config.DisasterDZZHConfig;
import com.geoway.ns.sx.biz.dzzh.entity.DataUpInfo;
import com.geoway.ns.sx.biz.dzzh.entity.DeviceRecord;
import com.geoway.ns.sx.biz.dzzh.entity.SensorRecord;
import com.geoway.ns.sx.biz.dzzh.mapper.DataUpInfoMapper;
import com.geoway.ns.sx.biz.dzzh.mapper.DeviceRecordMapper;
import com.geoway.ns.sx.biz.dzzh.mapper.SensorRecordMapper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class DzzhQueryService {
    private final DisasterDZZHConfig dzConfig;
    @Autowired
    DataUpInfoMapper dataUpInfoMapper;
    @Autowired
    DeviceRecordMapper deviceRecordMapper;
    @Autowired
    SensorRecordMapper sensorRecordMapper;
    @Autowired
    DistrictService districtService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    ExecutorService executorService = Executors.newFixedThreadPool(4);

    public DzzhQueryService(DisasterDZZHConfig config) {
        this.dzConfig = config;
    }

    public Long getJcsbCount() throws Exception {
        Long num = 0L;
        final String url = "/devices";
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("currentPage", 1);
        param.put("pageSize", 0);
        String resStr = this.dzConfig.postJson(url, param);
        JSONObject jsonObject = JSONObject.parseObject((String)resStr);
        JSONObject dataObj = jsonObject.getJSONObject("data");
        num = dataObj.get((Object)"total") != null ? Long.valueOf(dataObj.get((Object)"total").toString()) : 0L;
        if (num > 0L) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date now = new Date();
            final String nowStr = sdf.format(now);
            String sql = "select * from tb_data_upinfo where f_type='device-info' order by f_time desc";
            List items = this.jdbcTemplate.queryForList(sql);
            if (items.size() == 0 || items.size() > 0 && !((Map)items.get(0)).get("f_time").toString().equalsIgnoreCase(nowStr)) {
                final Integer xh = Integer.valueOf(num.toString()) / 500 + 1;
                final Long totalCount = num;
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        DataUpInfo daupN = new DataUpInfo();
                        String crId = UUID.randomUUID().toString();
                        daupN.setId(crId);
                        daupN.setType("device-info");
                        daupN.setTime(nowStr);
                        daupN.setCount(totalCount);
                        daupN.setState(0);
                        DzzhQueryService.this.dataUpInfoMapper.insert(daupN);
                        try {
                            for (int k = 0; k < xh; ++k) {
                                try {
                                    HashMap<String, Integer> newParam = new HashMap<String, Integer>();
                                    newParam.put("currentPage", k + 1);
                                    newParam.put("pageSize", 500);
                                    String listStr = DzzhQueryService.this.dzConfig.postJson(url, newParam);
                                    JSONObject resObject = JSONObject.parseObject((String)listStr);
                                    JSONObject dataObj = resObject.getJSONObject("data");
                                    if (dataObj == null) continue;
                                    JSONArray records = dataObj.getJSONArray("records");
                                    String lsSql = "";
                                    for (int i = 0; i < records.size(); ++i) {
                                        try {
                                            String sbid = records.getJSONObject(i).getString("id");
                                            lsSql = "select * from device_record where deviceid='" + sbid + "'";
                                            List sbInfos = DzzhQueryService.this.jdbcTemplate.queryForList(lsSql);
                                            if (sbInfos.size() > 0) continue;
                                            String areaCode = records.getJSONObject(i).getString("areaCode");
                                            String city = records.getJSONObject(i).get((Object)"city") != null ? records.getJSONObject(i).getString("city") : "";
                                            String country = records.getJSONObject(i).get((Object)"county") != null ? records.getJSONObject(i).getString("county") : "";
                                            Double lon = Double.valueOf(records.getJSONObject(i).getString("lon"));
                                            Double lat = Double.valueOf(records.getJSONObject(i).getString("lat"));
                                            DeviceRecord dRecord = new DeviceRecord();
                                            dRecord.setId(UUID.randomUUID().toString());
                                            dRecord.setAreacode(areaCode);
                                            dRecord.setCity(city);
                                            dRecord.setCountry(country);
                                            dRecord.setLat(lat);
                                            dRecord.setLon(lon);
                                            dRecord.setDetails(records.getJSONObject(i).toJSONString());
                                            dRecord.setUptime(nowStr);
                                            dRecord.setDeviceid(sbid);
                                            DzzhQueryService.this.deviceRecordMapper.insert(dRecord);
                                        }
                                        catch (Exception ex) {
                                            System.out.println(ex.getMessage());
                                        }
                                        JSONObject jSONObject = records.getJSONObject(i);
                                    }
                                    continue;
                                }
                                catch (Exception eex) {
                                    System.out.println(eex.getMessage());
                                }
                            }
                        }
                        catch (Exception lsEx) {
                            System.out.println(lsEx.getMessage());
                        }
                        DzzhQueryService.this.dataUpInfoMapper.updateState(1, crId);
                    }
                });
            }
        }
        return num;
    }

    public Long getCgqCount() throws Exception {
        Long num = 0L;
        final String url = "/sensor/page";
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("currentPage", 1);
        param.put("pageSize", 0);
        String resStr = this.dzConfig.postJson(url, param);
        JSONObject jsonObject = JSONObject.parseObject((String)resStr);
        JSONObject dataObj = jsonObject.getJSONObject("data");
        num = dataObj.get((Object)"total") != null ? Long.valueOf(dataObj.get((Object)"total").toString()) : 0L;
        if (num > 0L) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date now = new Date();
            final String nowStr = sdf.format(now);
            String sql = "select * from tb_data_upinfo where f_type='sensor-info' order by f_time desc";
            List items = this.jdbcTemplate.queryForList(sql);
            if (items.size() == 0 || items.size() > 0 && !((Map)items.get(0)).get("f_time").toString().equalsIgnoreCase(nowStr)) {
                final Integer xh = Integer.valueOf(num.toString()) / 500 + 1;
                final Long totalCount = num;
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        DataUpInfo daupN = new DataUpInfo();
                        String crId = UUID.randomUUID().toString();
                        daupN.setId(crId);
                        daupN.setType("sensor-info");
                        daupN.setTime(nowStr);
                        daupN.setCount(totalCount);
                        daupN.setState(0);
                        DzzhQueryService.this.dataUpInfoMapper.insert(daupN);
                        try {
                            for (int k = 0; k < xh; ++k) {
                                try {
                                    HashMap<String, Integer> newParam = new HashMap<String, Integer>();
                                    newParam.put("currentPage", k + 1);
                                    newParam.put("pageSize", 500);
                                    String listStr = DzzhQueryService.this.dzConfig.postJson(url, newParam);
                                    JSONObject resObject = JSONObject.parseObject((String)listStr);
                                    JSONObject dataObj = resObject.getJSONObject("data");
                                    if (dataObj == null) continue;
                                    JSONArray records = dataObj.getJSONArray("records");
                                    String lsSql = "";
                                    for (int i = 0; i < records.size(); ++i) {
                                        try {
                                            String sbid = records.getJSONObject(i).getString("id");
                                            lsSql = "select * from sensor_record where deviceid='" + sbid + "'";
                                            List sbInfos = DzzhQueryService.this.jdbcTemplate.queryForList(lsSql);
                                            if (sbInfos.size() > 0) continue;
                                            String areaCode = records.getJSONObject(i).getString("areaCode");
                                            String city = records.getJSONObject(i).get((Object)"city") != null ? records.getJSONObject(i).getString("city") : "";
                                            String country = records.getJSONObject(i).get((Object)"county") != null ? records.getJSONObject(i).getString("county") : "";
                                            Double lon = Double.valueOf(records.getJSONObject(i).getString("lon"));
                                            Double lat = Double.valueOf(records.getJSONObject(i).getString("lat"));
                                            SensorRecord dRecord = new SensorRecord();
                                            dRecord.setId(UUID.randomUUID().toString());
                                            dRecord.setAreacode(areaCode);
                                            dRecord.setCity(city);
                                            dRecord.setCountry(country);
                                            dRecord.setLat(lat);
                                            dRecord.setLon(lon);
                                            dRecord.setDetails(records.getJSONObject(i).toJSONString());
                                            dRecord.setUptime(nowStr);
                                            dRecord.setDeviceid(sbid);
                                            DzzhQueryService.this.sensorRecordMapper.insert(dRecord);
                                            continue;
                                        }
                                        catch (Exception ex) {
                                            System.out.println(ex.getMessage());
                                        }
                                    }
                                    continue;
                                }
                                catch (Exception eex) {
                                    System.out.println(eex.getMessage());
                                }
                            }
                        }
                        catch (Exception lsEx) {
                            System.out.println(lsEx.getMessage());
                        }
                        DzzhQueryService.this.dataUpInfoMapper.updateState(1, crId);
                    }
                });
            }
        }
        return num;
    }

    public List<Map<String, Object>> queryAllJcsbs() {
        String lsDm1;
        ArrayList<Map<String, Object>> results = new ArrayList();
        String sql = "select f_id,f_code as xzqdm,f_name as xzqmc,f_centerx as x,f_centery as y,f_pid from tbdm_districtitem where f_code like '14%' and f_levelindex=2 order by xzqdm";
        List shiXzqs = this.jdbcTemplate.queryForList(sql);
        sql = "select substr(areacode,0,5)||'00' as xzqdm,count(1) from device_record group by substr(areacode,0,5) order by xzqdm";
        List shiTjs = this.jdbcTemplate.queryForList(sql);
        sql = "select f_id,f_code as xzqdm,f_name as xzqmc,f_centerx as x,f_centery as y,f_pid from tbdm_districtitem where f_code like '14%' and f_levelindex=3 order by xzqdm";
        List xianXzqs = this.jdbcTemplate.queryForList(sql);
        sql = "select areacode as xzqdm,count(1) from device_record group by areacode order by xzqdm";
        List xianTjs = this.jdbcTemplate.queryForList(sql);
        sql = "select areacode,deviceid,lon,lat,details from device_record";
        List allDetails = this.jdbcTemplate.queryForList(sql);
        for (Map xianXzq : xianXzqs) {
            String lsDm2;
            lsDm1 = xianXzq.get("xzqdm").toString();
            ArrayList<Map> details = new ArrayList<Map>();
            Object count = "0";
            for (Map xianTj : xianTjs) {
                lsDm2 = xianTj.get("xzqdm").toString();
                if (!lsDm1.equalsIgnoreCase(lsDm2)) continue;
                count = xianTj.get("count").toString();
                break;
            }
            xianXzq.put("count", count);
            for (Map allDetail : allDetails) {
                lsDm2 = allDetail.get("areacode").toString();
                if (!lsDm1.equalsIgnoreCase(lsDm2)) continue;
                details.add(allDetail);
            }
            xianXzq.put("details", details);
        }
        for (Map shiXzq : shiXzqs) {
            lsDm1 = shiXzq.get("xzqdm").toString();
            String count = "0";
            for (Map shiTj : shiTjs) {
                String lsDm2 = shiTj.get("xzqdm").toString();
                if (!lsDm1.equalsIgnoreCase(lsDm2)) continue;
                count = shiTj.get("count").toString();
                break;
            }
            shiXzq.put("count", count);
            ArrayList<Map> childrens = new ArrayList<Map>();
            String shiXzqId = shiXzq.get("f_id").toString();
            for (Map xianXzq : xianXzqs) {
                String lsDm2 = xianXzq.get("f_pid").toString();
                if (!shiXzqId.equalsIgnoreCase(lsDm2)) continue;
                childrens.add(xianXzq);
            }
            shiXzq.put("children", childrens);
        }
        results = shiXzqs;
        return results;
    }

    public List<Map<String, Object>> queryAllCgqs() {
        String lsDm1;
        ArrayList<Map<String, Object>> results = new ArrayList();
        String sql = "select f_id,f_code as xzqdm,f_name as xzqmc,f_centerx as x,f_centery as y from tbdm_districtitem where f_code like '14%' and f_levelindex=2 order by xzqdm";
        List shiXzqs = this.jdbcTemplate.queryForList(sql);
        sql = "select substr(areacode,0,5)||'00' as xzqdm,count(1) from sensor_record group by substr(areacode,0,5) order by xzqdm";
        List shiTjs = this.jdbcTemplate.queryForList(sql);
        sql = "select f_id,f_code as xzqdm,f_name as xzqmc,f_centerx as x,f_centery as y,f_pid from tbdm_districtitem where f_code like '14%' and f_levelindex=3 order by xzqdm";
        List xianXzqs = this.jdbcTemplate.queryForList(sql);
        sql = "select areacode as xzqdm,count(1) from sensor_record group by areacode order by xzqdm";
        List xianTjs = this.jdbcTemplate.queryForList(sql);
        sql = "select areacode,deviceid,lon,lat,details from sensor_record";
        List allDetails = this.jdbcTemplate.queryForList(sql);
        for (Map xianXzq : xianXzqs) {
            String lsDm2;
            lsDm1 = xianXzq.get("xzqdm").toString();
            ArrayList<Map> details = new ArrayList<Map>();
            Object count = "0";
            for (Map xianTj : xianTjs) {
                lsDm2 = xianTj.get("xzqdm").toString();
                if (!lsDm1.equalsIgnoreCase(lsDm2)) continue;
                count = xianTj.get("count").toString();
                break;
            }
            xianXzq.put("count", count);
            for (Map allDetail : allDetails) {
                lsDm2 = allDetail.get("areacode").toString();
                if (!lsDm1.equalsIgnoreCase(lsDm2)) continue;
                details.add(allDetail);
            }
            xianXzq.put("details", details);
        }
        for (Map shiXzq : shiXzqs) {
            lsDm1 = shiXzq.get("xzqdm").toString();
            String count = "0";
            for (Map shiTj : shiTjs) {
                String lsDm2 = shiTj.get("xzqdm").toString();
                if (!lsDm1.equalsIgnoreCase(lsDm2)) continue;
                count = shiTj.get("count").toString();
                break;
            }
            shiXzq.put("count", count);
            ArrayList<Map> childrens = new ArrayList<Map>();
            String shiXzqId = shiXzq.get("f_id").toString();
            for (Map xianXzq : xianXzqs) {
                String lsDm2 = xianXzq.get("f_pid").toString();
                if (!lsDm1.equalsIgnoreCase(lsDm2)) continue;
                childrens.add(xianXzq);
            }
            shiXzq.put("children", childrens);
        }
        results = shiXzqs;
        return results;
    }

    public Map<String, Object> getDetailById(String id, String type) {
        String sql = "";
        if (type.equalsIgnoreCase("1")) {
            sql = "select lat,lon,details from device_record where deviceid='" + id + "'";
        }
        Map item = this.jdbcTemplate.queryForMap(sql);
        return item;
    }

    public Map<String, Object> hiddenPointListNew(String xzqdm) {
        String queryDm = xzqdm;
        if (xzqdm.length() == 6) {
            if (xzqdm.endsWith("0000")) {
                queryDm = xzqdm.substring(0, 2);
            } else if (xzqdm.endsWith("00")) {
                queryDm = xzqdm.substring(0, 4);
            }
        }
        String sql = "";
        sql = "select f_id, f_code as xzqdm,f_name as name,f_centerx as lon,f_centery as lat,f_pid from tbdm_districtitem where f_code like '" + queryDm + "%' and f_levelindex=3 order by xzqdm";
        List xianXzqs = this.jdbcTemplate.queryForList(sql);
        sql = "select xzqh as areaCode,null as cancelReason,null as cancelTime,null as city,null as county,zhdwybh as hiddenPoint,zhdmc as hiddenPointName,zhlx as hiddenPointType,null as hiddenPointUid,null as isCancel,wd as lat,jd as lon,dlwz as position,wxrk as threatPopulation,wxcc as threatProperty,xqdj,xqdjdic,mqwdcd,jhbhqs,jcywdw,yfys,wxrk,wxcc,zhlx,zhlxdic,gmdj,gmdjdic from yhd_record";
        List allDetails = this.jdbcTemplate.queryForList(sql);
        for (Object xianXzq : xianXzqs) {
            String lsDm1 = xianXzq.get("xzqdm").toString();
            ArrayList<Map> details = new ArrayList<Map>();
            for (Map allDetail : allDetails) {
                String lsDm2 = allDetail.get("areacode").toString();
                if (lsDm2.indexOf(lsDm1) <= -1) continue;
                details.add(allDetail);
            }
            xianXzq.put("hiddenPoints", details);
        }
        sql = "select f_id,f_code as xzqdm,f_name as name,f_centerx as lon,f_centery as lat from tbdm_districtitem where f_code like '" + queryDm + "%' and f_levelindex=2 order by xzqdm";
        List shiXzqs = this.jdbcTemplate.queryForList(sql);
        for (Map shiXzq : shiXzqs) {
            String lsDm1 = shiXzq.get("f_id").toString();
            ArrayList<Map> childrens = new ArrayList<Map>();
            for (Map xianXzq : xianXzqs) {
                String lsDm2 = xianXzq.get("f_pid").toString();
                if (!lsDm1.equalsIgnoreCase(lsDm2)) continue;
                childrens.add(xianXzq);
            }
            shiXzq.put("counties", childrens);
        }
        HashMap<String, Object> shengObj = new HashMap<String, Object>();
        shengObj.put("name", "\u5c71\u897f\u7701");
        shengObj.put("lon", "112.29213");
        shengObj.put("lat", "37.57437");
        shengObj.put("cities", shiXzqs);
        return shengObj;
    }

    public Map<String, Object> hiddenPointTypeNew(String xzqdm) {
        String queryDm = xzqdm;
        if (xzqdm.length() == 6) {
            if (xzqdm.endsWith("0000")) {
                queryDm = xzqdm.substring(0, 2);
            } else if (xzqdm.endsWith("00")) {
                queryDm = xzqdm.substring(0, 4);
            }
        }
        Map<String, Object> result = new HashMap();
        String sql = "select count(1) as num,sum(wxrk)/10000 as wxrk,sum(wxcc)/10000 as wxcc from yhd_record where xzqh like '" + queryDm + "%'";
        result = this.jdbcTemplate.queryForMap(sql);
        sql = "select zhlxdic as type,count(1) from yhd_record where zhlxdic is not null and zhlxdic!='' and xzqh like '" + queryDm + "%' group by zhlxdic";
        List lxItems = this.jdbcTemplate.queryForList(sql);
        result.put("lx", lxItems);
        sql = "select gmdjdic as type,count(1) from yhd_record where gmdjdic is not null and gmdjdic!='' and xzqh like '" + queryDm + "%' group by gmdjdic";
        List gmItems = this.jdbcTemplate.queryForList(sql);
        result.put("gm", gmItems);
        sql = "select xqdjdic as type,count(1) from yhd_record where xqdjdic is not null and xqdjdic!='' and xzqh like '" + queryDm + "%' group by xqdjdic";
        List xqItems = this.jdbcTemplate.queryForList(sql);
        result.put("xq", xqItems);
        return result;
    }
}

