/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sx.biz.dzzh.service.impl;

import com.geoway.ns.sx.biz.dzzh.entity.CamDevicePo;
import com.geoway.ns.sx.biz.dzzh.enums.CamDeviceOnlineEnum;
import com.geoway.ns.sx.biz.dzzh.mapper.CamDevicePoMapper;
import com.geoway.ns.sx.biz.dzzh.mo.VideoCountMo;
import com.geoway.ns.sx.biz.dzzh.service.CamDeviceService;
import java.io.Serializable;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class CamDeviceServiceImpl
implements CamDeviceService {
    @Autowired
    private CamDevicePoMapper camDevicePoMapper;

    @Override
    public void saveCamDevice(CamDevicePo addRecord) {
        this.camDevicePoMapper.insert(addRecord);
    }

    @Override
    public void updateCamDeviceById(CamDevicePo updateRecord) {
        this.camDevicePoMapper.updateById(updateRecord);
    }

    @Override
    public void delCamDeviceById(String id) {
        this.camDevicePoMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    public VideoCountMo getVideoCount(String spService, String statusValid) {
        VideoCountMo videoCountMo = new VideoCountMo();
        int totalCount = this.camDevicePoMapper.getTotalCount(spService, statusValid);
        videoCountMo.setTotalCount(totalCount);
        int onlineCount = this.camDevicePoMapper.getOnlineStatus(CamDeviceOnlineEnum.\u5728\u7ebf.value(), spService, statusValid);
        int offLineCount = this.camDevicePoMapper.getOnlineStatus(CamDeviceOnlineEnum.\u79bb\u7ebf.value(), spService, statusValid);
        videoCountMo.setOnlineCount(onlineCount);
        videoCountMo.setOffLineCount(offLineCount);
        BigDecimal result = new BigDecimal(onlineCount * 100).divide(new BigDecimal(totalCount), 2, 4);
        videoCountMo.setOnlineRate(result.doubleValue());
        return videoCountMo;
    }
}

