/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sx.biz.dzzh.service.impl;

import com.alibaba.fastjson.JSON;
import com.geoway.ns.sx.biz.dzzh.config.DisasterCameraConfig;
import com.geoway.ns.sx.biz.dzzh.mo.ApiResult;
import com.geoway.ns.sx.biz.dzzh.mo.StreamDeviceMo;
import com.geoway.ns.sx.biz.dzzh.seo.StreamDeviceSeo;
import com.geoway.ns.sx.biz.dzzh.service.CameraDeviceService;
import java.util.HashMap;
import org.geotools.ows.ServiceException;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CameraDeviceServiceImpl
implements CameraDeviceService {
    private final DisasterCameraConfig smsConfig;

    public CameraDeviceServiceImpl(DisasterCameraConfig config) {
        this.smsConfig = config;
    }

    @Override
    public boolean controlPtz(String serial, String command, Integer speed, String code, Integer channel) throws Exception {
        String url = "/api/v1/control/ptz";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("serial", serial);
        params.put("command", command);
        if (speed != null) {
            params.put("speed", speed.toString());
        }
        if (code != null) {
            params.put("code", code);
        }
        if (channel != null) {
            params.put("channel", channel.toString());
        }
        try {
            ApiResult apiResult = this.smsConfig.get(url, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public StreamDeviceMo getStreamDevice(StreamDeviceSeo seo) throws Exception {
        ApiResult result;
        String url = "/api/v1/stream/start";
        HashMap<String, String> params = new HashMap<String, String>();
        if (seo == null || !StringUtils.hasText((String)seo.getSerial())) {
            throw new ServiceException("\u8bf7\u4f20\u5165\u8bbe\u5907\u7f16\u53f7");
        }
        params.put("serial", seo.getSerial());
        if (seo.getChannel() != null) {
            params.put("channel", seo.getChannel().toString());
        }
        if (StringUtils.hasText((String)seo.getCode())) {
            params.put("code", seo.getCode());
        }
        if (seo.getCheckChannelStatus() != null) {
            params.put("checkChannelStatus", seo.getCheckChannelStatus().toString());
        }
        if (StringUtils.hasText((String)seo.getSmsId())) {
            params.put("sms_id", seo.getSmsId());
        }
        if (StringUtils.hasText((String)seo.getSmsGroupId())) {
            params.put("sms_group_id", seo.getSmsGroupId());
        }
        if (StringUtils.hasText((String)seo.getCdn())) {
            params.put("cdn", seo.getCdn());
        }
        if (StringUtils.hasText((String)seo.getAudio())) {
            if (!("config".equals(seo.getAudio()) || "true".equals(seo.getAudio()) || "false".equals(seo.getAudio()))) {
                throw new ServiceException("audio\u53ea\u5141\u8bb8\u4f20\u5165:config,true,false");
            }
            params.put("audio", seo.getAudio());
        }
        if (StringUtils.hasText((String)seo.getTransport())) {
            if (!("config".equals(seo.getAudio()) || "TCP".equals(seo.getAudio()) || "UDP".equals(seo.getAudio()))) {
                throw new ServiceException("transport\u53ea\u5141\u8bb8\u4f20\u5165:config,TCP,UDP");
            }
            params.put("transport", seo.getTransport());
        }
        if (StringUtils.hasText((String)seo.getTransportMode())) {
            if (!"active".equals(seo.getAudio()) && !"passive".equals(seo.getAudio())) {
                throw new ServiceException("transportMode\u53ea\u5141\u8bb8\u4f20\u5165:active,passive");
            }
            params.put("transport_mode", seo.getTransportMode());
        }
        if (seo.getTimeout() != null) {
            params.put("timeout", seo.getTimeout().toString());
        }
        if ((result = this.smsConfig.get(url, params)).isSuccess()) {
            try {
                return (StreamDeviceMo)JSON.parseObject((String)result.getBody(), StreamDeviceMo.class);
            }
            catch (Exception e) {
                throw new Exception("\u89e3\u6790\u62c9\u6d41\u8fd4\u56de\u6570\u636e\u5f02\u5e38\uff0c\u8fd4\u56de\u503c\u4e3a\uff1a" + result);
            }
        }
        if (result.getStatus() == 400 && result.getBody().indexOf("offline") != 1) {
            StreamDeviceMo res = new StreamDeviceMo();
            res.setDeviceID(seo.getSerial());
            res.setOffline(true);
            return res;
        }
        throw new Exception("\u83b7\u53d6\u62c9\u6d41\u6570\u636e\u5f02\u5e38");
    }
}

