/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sx.biz.dzzh.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.ns.sx.biz.dzzh.config.MeteorologicalConfig;
import com.geoway.ns.sx.biz.dzzh.mo.GeometryMo;
import com.geoway.ns.sx.biz.dzzh.mo.MeteorologicalMo;
import com.geoway.ns.sx.biz.dzzh.mo.MeteorologicalPropertiesMo;
import com.geoway.ns.sx.biz.dzzh.seo.MeteorologicalSeo;
import com.geoway.ns.sx.biz.dzzh.service.MeteorologicalService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
public class MeteorologicalServiceImpl
implements MeteorologicalService {
    private final MeteorologicalConfig meteorologicalConfig;

    public MeteorologicalServiceImpl(MeteorologicalConfig meteorologicalConfig) {
        this.meteorologicalConfig = meteorologicalConfig;
    }

    @Override
    public List<MeteorologicalMo> getMeteorologicalLocationInfoByRegionId(MeteorologicalSeo seo) {
        String resStrr = this.getResponse(seo);
        JSONObject json = JSON.parseObject((String)resStrr);
        ArrayList<MeteorologicalMo> meteorologicalList = new ArrayList<MeteorologicalMo>();
        JSONArray dataArray = json.getJSONArray("features");
        if (null != dataArray) {
            for (int i = 0; i < dataArray.size(); ++i) {
                JSONObject feature = dataArray.getJSONObject(i);
                JSONObject properties = feature.getJSONObject("properties");
                GeometryMo geometryMo = new GeometryMo();
                MeteorologicalMo meteorologicalMo = new MeteorologicalMo();
                if (null != properties) {
                    MeteorologicalPropertiesMo monitorTypeMo = (MeteorologicalPropertiesMo)JSONObject.toJavaObject((JSON)properties, MeteorologicalPropertiesMo.class);
                    meteorologicalMo.setMeteorPropertiesMo(monitorTypeMo);
                }
                JSONObject geometry = feature.getJSONObject("geometry");
                String type = geometry.getString("type");
                JSONArray coordinatesArray = geometry.getJSONArray("coordinates");
                List coordinates = (List)JSON.parseObject((String)coordinatesArray.getString(0), (TypeReference)new TypeReference<List<List<Double>>>(){}, (Feature[])new Feature[0]);
                geometryMo.setCoordinatesData(coordinates);
                geometryMo.setType(type);
                meteorologicalMo.setGeometry(geometryMo);
                meteorologicalList.add(meteorologicalMo);
            }
        }
        return meteorologicalList;
    }

    @Nullable
    public String getResponse(MeteorologicalSeo seo) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", this.meteorologicalConfig.id);
        params.put("no", this.meteorologicalConfig.no);
        params.put("grade1", this.meteorologicalConfig.grade1);
        params.put("grade2", this.meteorologicalConfig.grade2);
        params.put("grade3", this.meteorologicalConfig.grade3);
        params.put("grade4", this.meteorologicalConfig.grade4);
        params.put("regionid", seo.getRegionId());
        if (null != seo.getGrade1() && seo.getGrade1().booleanValue()) {
            params.put("grade1", seo.getGrade1());
        }
        if (null != seo.getGrade2() && seo.getGrade2().booleanValue()) {
            params.put("grade2", seo.getGrade2());
        }
        if (null != seo.getGrade3() && seo.getGrade3().booleanValue()) {
            params.put("grade3", seo.getGrade3());
        }
        if (null != seo.getGrade4() && seo.getGrade4().booleanValue()) {
            params.put("grade4", seo.getGrade4());
        }
        String resStrr = null;
        try {
            resStrr = this.meteorologicalConfig.getMeteorologicalJson(params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resStrr;
    }

    @Override
    public Long getMeteorologicalByRegionId(MeteorologicalSeo seo) {
        String resStrr = this.getResponse(seo);
        JSONObject json = JSON.parseObject((String)resStrr);
        JSONArray dataArray = json.getJSONArray("features");
        Long size = dataArray.size();
        return size;
    }
}

