/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sx.biz.dzzh.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemDTO;
import com.geoway.adf.dms.datasource.service.DistrictService;
import com.geoway.ns.sx.biz.dzzh.config.DisasterDZZHConfig;
import com.geoway.ns.sx.biz.dzzh.entity.MonitorRecord;
import com.geoway.ns.sx.biz.dzzh.entity.WarningRecord;
import com.geoway.ns.sx.biz.dzzh.entity.YhdRecord;
import com.geoway.ns.sx.biz.dzzh.mapper.MonitorRecordMapper;
import com.geoway.ns.sx.biz.dzzh.mapper.WarningRecordMapper;
import com.geoway.ns.sx.biz.dzzh.mapper.YhdRecordMapper;
import com.geoway.ns.sx.biz.dzzh.mo.AreaWarningHandleCountMo;
import com.geoway.ns.sx.biz.dzzh.mo.DeviceAndSenorMo;
import com.geoway.ns.sx.biz.dzzh.mo.HiddenPointMo;
import com.geoway.ns.sx.biz.dzzh.mo.HiddenTypeCountMo;
import com.geoway.ns.sx.biz.dzzh.mo.MonitorTypeCountMo;
import com.geoway.ns.sx.biz.dzzh.mo.PageMo;
import com.geoway.ns.sx.biz.dzzh.mo.SensorMo;
import com.geoway.ns.sx.biz.dzzh.mo.WarningEventMo;
import com.geoway.ns.sx.biz.dzzh.mo.XzZQGMo;
import com.geoway.ns.sx.biz.dzzh.seo.HiddenPointSeo;
import com.geoway.ns.sx.biz.dzzh.seo.WarningEventMoSeo;
import com.geoway.ns.sx.biz.dzzh.seo.YhdRecordSeo;
import com.geoway.ns.sx.biz.dzzh.service.WarningEventService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WarningEventServiceImpl
implements WarningEventService {
    private final DisasterDZZHConfig dzConfig;
    @Autowired
    private MonitorRecordMapper monitorRecordMapper;
    @Autowired
    private WarningRecordMapper warningRecordMapper;
    @Autowired
    private YhdRecordMapper yhdRecordMapper;
    @Autowired
    private DistrictService districtService;
    ExecutorService executorService = Executors.newFixedThreadPool(4);

    public WarningEventServiceImpl(DisasterDZZHConfig config) {
        this.dzConfig = config;
    }

    @Override
    public IPage<WarningEventMo> getNewestWarningEvents(WarningEventMoSeo seo, int currentPage, int pageSize) throws Exception {
        HashMap<String, Serializable> param = new HashMap<String, Serializable>();
        param.put("currentPage", Integer.valueOf(currentPage));
        param.put("pageSize", Integer.valueOf(pageSize));
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (seo.getAreaCode() != null) {
            params.put("areaCode", seo.getAreaCode());
        }
        if (seo.getHiddenName() != null) {
            params.put("hiddenName", seo.getHiddenName());
        }
        if (seo.getHiddenPoint() != null) {
            params.put("hiddenPoint", seo.getHiddenPoint());
        }
        if (seo.getIsRain() != null) {
            params.put("isRain", seo.getIsRain());
        }
        if (seo.getIsRain() == null) {
            params.put("isRain", 0);
        }
        if (seo.getSensorId() != null) {
            params.put("sensorId", seo.getSensorId());
        }
        if (seo.getStartTime() != null) {
            params.put("startTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(seo.getStartTime()));
        }
        if (seo.getEndTime() != null) {
            params.put("endTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(seo.getEndTime()));
        }
        if (seo.getWarningCode() != null) {
            params.put("warningCode", seo.getWarningCode());
        }
        if (null == seo.getWarningCode()) {
            params.put("warningCode", "C1,C2,C3,C4");
        }
        if (seo.getWarningStatus() != null) {
            params.put("warningStatus", seo.getWarningStatus());
        }
        if (seo.getWarningStatus() == null) {
            params.put("warningStatus", "0");
        }
        if (seo.getOrderField() != null) {
            HashMap<String, String> paramsOrder = new HashMap<String, String>();
            if (null == seo.getOrderField() && null == seo.getOrder()) {
                paramsOrder.put("warningTime", "DESC");
            } else {
                paramsOrder.put(seo.getOrderField(), seo.getOrder());
            }
            params.put("order", paramsOrder);
        }
        param.put("queryParams", params);
        String paramInfo = JSON.toJSONString(params);
        String url = "/warningEvent/warningEvents";
        try {
            String resStr = this.dzConfig.postJson(url, param);
            JSONObject json = JSON.parseObject((String)resStr);
            JSONObject dataObj = json.getJSONObject("data");
            long total = dataObj.getLongValue("total");
            int pages = dataObj.getIntValue("pages");
            List warningEventMoList = (List)JSON.parseObject((String)dataObj.getString("records"), (TypeReference)new TypeReference<List<WarningEventMo>>(){}, (Feature[])new Feature[0]);
            List list = (List)JSON.parseObject((String)dataObj.getString("records"), (TypeReference)new TypeReference<List<WarningRecord>>(){}, (Feature[])new Feature[0]);
            this.executorService.execute(() -> {
                String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                for (WarningRecord item : list) {
                    item.setId(item.getWarningEventId());
                    item.setUpTime(time);
                    if (this.warningRecordMapper.selectById((Serializable)((Object)item.getId())) != null) continue;
                    this.warningRecordMapper.insert(item);
                }
            });
            Page page = Page.of((long)currentPage, (long)pageSize, (long)total);
            page.setRecords(warningEventMoList);
            return page;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public List<HiddenTypeCountMo> getHiddenPointType(String areaCode) throws Exception {
        String url = "/stat/hiddenPointType";
        HashMap<String, String[]> param = new HashMap<String, String[]>();
        param.put("areaCode", new String[]{areaCode});
        String resStr = this.dzConfig.postJson(url, param);
        JSONObject jsonObject = JSONObject.parseObject((String)resStr);
        JSONArray dataArray = jsonObject.getJSONArray("data");
        ArrayList<HiddenTypeCountMo> hiddenTypeMoList = new ArrayList<HiddenTypeCountMo>();
        for (Object obj : dataArray) {
            HiddenTypeCountMo hiddenTypeMo = (HiddenTypeCountMo)JSONObject.toJavaObject((JSON)((JSONObject)obj), HiddenTypeCountMo.class);
            hiddenTypeMoList.add(hiddenTypeMo);
        }
        return hiddenTypeMoList;
    }

    @Override
    public List<MonitorTypeCountMo> getMonitorPointType(String areaCode) throws Exception {
        String url = "/stat/monitorPointType";
        HashMap<String, String[]> param = new HashMap<String, String[]>();
        param.put("areaCode", new String[]{areaCode});
        String resStr = this.dzConfig.postJson(url, param);
        JSONObject jsonObject = JSONObject.parseObject((String)resStr);
        JSONArray dataArray = jsonObject.getJSONArray("data");
        ArrayList<MonitorTypeCountMo> monitorTypeMoList = new ArrayList<MonitorTypeCountMo>();
        for (Object obj : dataArray) {
            MonitorTypeCountMo monitorTypeMo = (MonitorTypeCountMo)JSONObject.toJavaObject((JSON)((JSONObject)obj), MonitorTypeCountMo.class);
            monitorTypeMoList.add(monitorTypeMo);
        }
        return monitorTypeMoList;
    }

    @Override
    public List<MonitorTypeCountMo> getDeviceSensorOnline(String areaCode) throws Exception {
        String url = "/stat/deviceSensorOnline";
        HashMap<String, String[]> param = new HashMap<String, String[]>();
        param.put("areaCode", new String[]{areaCode});
        String resStr = this.dzConfig.postJson(url, param);
        JSONObject jsonObject = JSONObject.parseObject((String)resStr);
        JSONArray dataArray = jsonObject.getJSONArray("data");
        ArrayList<MonitorTypeCountMo> monitorTypeMoList = new ArrayList<MonitorTypeCountMo>();
        for (Object obj : dataArray) {
            MonitorTypeCountMo monitorTypeMo = (MonitorTypeCountMo)JSONObject.toJavaObject((JSON)((JSONObject)obj), MonitorTypeCountMo.class);
            monitorTypeMoList.add(monitorTypeMo);
        }
        return monitorTypeMoList;
    }

    @Override
    public XzZQGMo getXzZQGMoTree(String xzqhCode) throws Exception {
        String url = "";
        url = null != xzqhCode ? this.dzConfig.url + "/xzqh/tree/" + xzqhCode : this.dzConfig.url + "/xzqh/tree";
        HashMap param = new HashMap();
        String resStr = this.dzConfig.postJson(url, param);
        JSONObject jsonObject = JSONObject.parseObject((String)resStr);
        JSONObject json = JSON.parseObject((String)resStr);
        JSONObject dataObject = json.getJSONObject("data");
        JSONArray recordsArray = dataObject.getJSONArray("records");
        return null;
    }

    @Override
    public DeviceAndSenorMo getSensorDetails(String sensorId) throws Exception {
        String url = "/device/generalInfo/" + sensorId;
        String resStrr = this.dzConfig.getJson(url, null);
        JSONObject json = JSON.parseObject((String)resStrr);
        JSONObject dataJson = json.getJSONObject("data");
        DeviceAndSenorMo dataStreamInfoMo = (DeviceAndSenorMo)JSON.parseObject((String)dataJson.toJSONString(), DeviceAndSenorMo.class);
        dataStreamInfoMo.setJsonData(resStrr);
        return dataStreamInfoMo;
    }

    @Override
    public List<AreaWarningHandleCountMo> getWarningCount(String codeFormat) {
        String url = "/stat/todayWarning";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("areaCode", new String[]{codeFormat});
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("isRainHandle", 1);
        param.put("queryParams", params);
        String resStr = null;
        try {
            resStr = this.dzConfig.postJson(url, param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject jsonObject = JSONObject.parseObject((String)resStr);
        JSONArray dataArray = jsonObject.getJSONArray("data");
        ArrayList<AreaWarningHandleCountMo> areaWarningHandleCountMoList = new ArrayList<AreaWarningHandleCountMo>();
        for (Object obj : dataArray) {
            AreaWarningHandleCountMo areaWarningHandleCountMo = (AreaWarningHandleCountMo)JSONObject.toJavaObject((JSON)((JSONObject)obj), AreaWarningHandleCountMo.class);
            areaWarningHandleCountMoList.add(areaWarningHandleCountMo);
        }
        return areaWarningHandleCountMoList;
    }

    @Override
    public PageMo<HiddenPointMo> getHiddenPointList(HiddenPointSeo seo, int currentPage, int pageSize) {
        HashMap<String, Serializable> param = new HashMap<String, Serializable>();
        param.put("currentPage", Integer.valueOf(currentPage));
        param.put("pageSize", Integer.valueOf(pageSize));
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (seo.getAreaCode() != null) {
            params.put("areaCodes", new String[]{seo.getAreaCode()});
        }
        if (seo.getHiddenPoint() != null) {
            params.put("hiddenPoint", seo.getHiddenPoint());
        }
        if (seo.getHiddenPointName() != null) {
            params.put("hiddenPointName", seo.getHiddenPointName());
        }
        if (seo.getHiddenPointType() != null) {
            params.put("hiddenPointType", seo.getHiddenPointType());
        }
        param.put("queryParams", params);
        String url = "/projects/bd/point";
        try {
            String resStr = this.dzConfig.postJson(url, param);
            JSONObject json = JSON.parseObject((String)resStr);
            JSONObject dataObj = json.getJSONObject("data");
            long total = dataObj.getLongValue("total");
            int pages = dataObj.getIntValue("pages");
            List hiddenPointMos = (List)JSON.parseObject((String)dataObj.getString("records"), (TypeReference)new TypeReference<List<HiddenPointMo>>(){}, (Feature[])new Feature[0]);
            PageMo<HiddenPointMo> res = new PageMo<HiddenPointMo>();
            res.setRows(hiddenPointMos);
            res.setTotal(total);
            res.setPages(pages);
            return res;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<HiddenPointMo> getHiddenPointList(HiddenPointSeo seo) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (seo.getAreaCode() != null) {
            params.put("areaCodes", new String[]{seo.getAreaCode()});
        }
        if (seo.getHiddenPoint() != null) {
            params.put("hiddenPoint", seo.getHiddenPoint());
        }
        if (seo.getHiddenPointName() != null) {
            params.put("hiddenPointName", seo.getHiddenPointName());
        }
        if (seo.getHiddenPointType() != null) {
            params.put("hiddenPointType", seo.getHiddenPointType());
        }
        String url = "/projects/bd/point/list";
        try {
            String resStr = this.dzConfig.postJson(url, params);
            JSONObject json = JSON.parseObject((String)resStr);
            List list = (List)JSON.parseObject((String)json.getString("data"), (TypeReference)new TypeReference<List<MonitorRecord>>(){}, (Feature[])new Feature[0]);
            this.executorService.execute(() -> {
                String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                for (MonitorRecord item : list) {
                    item.setId(item.getHiddenPoint());
                    item.setUpTime(time);
                    if (this.monitorRecordMapper.selectById((Serializable)((Object)item.getId())) != null) continue;
                    this.monitorRecordMapper.insert(item);
                }
            });
            return (List)JSON.parseObject((String)json.getString("data"), (TypeReference)new TypeReference<List<HiddenPointMo>>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public IPage<YhdRecord> yhdRecordPage(YhdRecordSeo yhdRecordSeo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (ObjectUtils.isNotEmpty((Object)yhdRecordSeo.getXzqh())) {
            queryWrapper.eq((Object)"xzqh", (Object)yhdRecordSeo.getXzqh());
        }
        if (ObjectUtils.isNotEmpty((Object)yhdRecordSeo.getZhdwybh())) {
            queryWrapper.eq((Object)"zhdwybh", (Object)yhdRecordSeo.getZhdwybh());
        }
        if (ObjectUtils.isNotEmpty((Object)yhdRecordSeo.getGmdjdic())) {
            queryWrapper.eq((Object)"gmdjdic", (Object)yhdRecordSeo.getGmdjdic());
        }
        if (ObjectUtils.isNotEmpty((Object)yhdRecordSeo.getZhlxdic())) {
            queryWrapper.eq((Object)"zhlxdic", (Object)yhdRecordSeo.getZhlxdic());
        }
        if (ObjectUtils.isNotEmpty((Object)yhdRecordSeo.getXqdjdic())) {
            queryWrapper.eq((Object)"xqdjdic", (Object)yhdRecordSeo.getXqdjdic());
        }
        if (ObjectUtils.isNotEmpty((Object)yhdRecordSeo.getZhdmc())) {
            queryWrapper.like((Object)"zhdmc", (Object)yhdRecordSeo.getZhdmc());
        }
        IPage yhdRecordGiPager = this.yhdRecordMapper.selectPage((IPage)Page.of((long)yhdRecordSeo.getPageNum().intValue(), (long)yhdRecordSeo.getPageSize().intValue()), (Wrapper)queryWrapper);
        for (YhdRecord yhdRecord : yhdRecordGiPager.getRecords()) {
            DistrictItemDTO districtItemDTO;
            if (yhdRecord.getXzqh() == null || yhdRecord.getXzqh().length() <= 5 || !ObjectUtils.isNotEmpty((Object)(districtItemDTO = this.districtService.getDistrictItemDetail(null, yhdRecord.getXzqh().substring(0, 6))))) continue;
            yhdRecord.setXzqhmc(districtItemDTO.getName());
        }
        return yhdRecordGiPager;
    }

    @Override
    public List<AreaWarningHandleCountMo> getMonitoringWarning(String areaCode) {
        String startTime = DateUtil.beginOfDay((Date)new Date()).toString("yyyy-MM-dd HH:mm:ss");
        String endTime = DateUtil.endOfDay((Date)new Date()).toString("yyyy-MM-dd HH:mm:ss");
        String url = "/warningEvent/areaWarningHandleCount";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("areaCode", areaCode);
        param.put("isLowerLevel", "0");
        param.put("warningStartTime", startTime);
        param.put("warningEndTime", endTime);
        try {
            String resStr = this.dzConfig.postJson(url, param);
            JSONObject jsonObject = JSONObject.parseObject((String)resStr);
            JSONArray dataArray = jsonObject.getJSONArray("data");
            ArrayList<AreaWarningHandleCountMo> areaWarningHandleCountMoList = new ArrayList<AreaWarningHandleCountMo>();
            for (Object obj : dataArray) {
                AreaWarningHandleCountMo monitorTypeMo = (AreaWarningHandleCountMo)JSONObject.toJavaObject((JSON)((JSONObject)obj), AreaWarningHandleCountMo.class);
                areaWarningHandleCountMoList.add(monitorTypeMo);
            }
            return areaWarningHandleCountMoList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public PageMo<SensorMo> getSensorList(int currentPage, Integer pageSize, Boolean isVideo) {
        String url = "/sensors";
        HashMap<String, Serializable> param = new HashMap<String, Serializable>();
        param.put("currentPage", Integer.valueOf(currentPage));
        param.put("pageSize", Integer.valueOf(pageSize == null ? 10 : pageSize));
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        if (isVideo != null && isVideo.booleanValue()) {
            params.put("sensorType", new String[]{"L4SP", "Sp"});
        }
        param.put("queryParams", params);
        try {
            String resStr = this.dzConfig.postJson(url, param);
            JSONObject json = JSON.parseObject((String)resStr);
            JSONObject dataObj = json.getJSONObject("data");
            long total = dataObj.getLongValue("total");
            int pages = dataObj.getIntValue("pages");
            List warningEventMoList = (List)JSON.parseObject((String)dataObj.getString("records"), (TypeReference)new TypeReference<List<SensorMo>>(){}, (Feature[])new Feature[0]);
            PageMo<SensorMo> res = new PageMo<SensorMo>();
            res.setRows(warningEventMoList);
            res.setTotal(total);
            res.setPages(pages);
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

