/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sx.biz.gzt.scheduler;

import com.geoway.ns.sx.biz.gzt.entity.GztNews;
import com.geoway.ns.sx.biz.gzt.entity.GztNotice;
import com.geoway.ns.sx.biz.gzt.service.GztNewsService;
import com.geoway.ns.sx.biz.gzt.service.GztNoticeService;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class GztScheduler {
    private static final Logger log = LoggerFactory.getLogger(GztScheduler.class);
    @Autowired
    private GztNewsService gztNewsService;
    @Autowired
    private GztNoticeService gztNoticeService;
    @Value(value="${gzt.sync.enable:false}")
    private Boolean enable;
    @Value(value="${gzt.sync.news:http://zrzyt.shanxi.gov.cn/xw/chnl88}")
    private String newsUrl;
    @Value(value="${gzt.sync.notice:http://zrzyt.shanxi.gov.cn/zwgk/tzgg}")
    private String noticeUrl;

    @Scheduled(cron="${gzt.sync.cron:1 1 9 * * ?}")
    public void pollingTask() {
        if (this.enable.booleanValue()) {
            this.syncNews();
            this.syncNotice();
        }
    }

    private void syncNews() {
        try {
            log.info("\u65b0\u95fb\u6570\u636e\u5f00\u59cb\u540c\u6b65\uff01" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            Document doc = Jsoup.connect((String)this.newsUrl).get();
            Elements uls = doc.select("ul.zwgk_right_content");
            ArrayList<GztNews> list = new ArrayList<GztNews>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date newDate = this.gztNewsService.maxTime();
            block2: for (Element ul : uls) {
                Elements lis = ul.select("li");
                for (Element li : lis) {
                    String time = li.select("span").text();
                    Date date = sdf.parse(time);
                    String title = li.select("a").text();
                    String href = li.select("a").attr("href");
                    href = href.substring(1);
                    if (newDate != null && date.getTime() <= newDate.getTime()) continue block2;
                    list.add(GztNews.builder().title(title).url(this.newsUrl + href).time(date).build());
                }
            }
            if (!list.isEmpty()) {
                this.gztNewsService.saveBatch(list);
            }
            log.info("\u65b0\u95fb\u6570\u636e\u5b8c\u6210\u540c\u6b65\uff01" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        }
        catch (Exception e) {
            log.error("\u65b0\u95fb\u6570\u636e\u540c\u6b65\u5931\u8d25\uff1a" + e.getMessage());
            e.printStackTrace();
        }
    }

    private void syncNotice() {
        try {
            log.info("\u901a\u77e5\u516c\u544a\u5f00\u59cb\u540c\u6b65\uff01" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            Document doc = Jsoup.connect((String)this.noticeUrl).get();
            Elements uls = doc.select("ul.zwgk_right_content");
            ArrayList<GztNotice> list = new ArrayList<GztNotice>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date newDate = this.gztNoticeService.maxTime();
            block2: for (Element ul : uls) {
                Elements lis = ul.select("li");
                for (Element li : lis) {
                    String time = li.select("span").text();
                    Date date = sdf.parse(time);
                    String title = li.select("a").text();
                    String href = li.select("a").attr("href");
                    href = href.substring(1);
                    if (newDate != null && date.getTime() <= newDate.getTime()) continue block2;
                    list.add(GztNotice.builder().title(title).url(this.noticeUrl + href).time(date).build());
                }
            }
            if (!list.isEmpty()) {
                this.gztNoticeService.saveBatch(list);
            }
            log.info("\u901a\u77e5\u516c\u544a\u5b8c\u6210\u540c\u6b65\uff01" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        }
        catch (Exception e) {
            log.error("\u901a\u77e5\u516c\u544a\u540c\u6b65\u5931\u8d25\uff1a" + e.getMessage());
            e.printStackTrace();
        }
    }
}

