/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sx.biz.sys.config;

import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@Primary
public class Sys4SxFlywayConfig {
    private static final String BASE_SQL_LOCATION = "/db/sxsys";
    private static final String ENCODING = "UTF-8";
    private static final Logger log = LoggerFactory.getLogger(Sys4SxFlywayConfig.class);
    @Autowired
    protected ApplicationContext applicationContext;
    @Value(value="${spring.flyway.enabled}")
    private Boolean enabled;

    @Bean
    public void sys4SxMigrate() {
        if (!this.enabled.booleanValue()) {
            return;
        }
        try {
            DataSource dataSource = (DataSource)this.applicationContext.getBean(DataSource.class);
            Flyway flyway = Flyway.configure().dataSource(dataSource).locations(new String[]{BASE_SQL_LOCATION}).encoding(ENCODING).baselineOnMigrate(true).table("t_sys4_sx_history").cleanDisabled(true).load();
            flyway.migrate();
        }
        catch (Exception exception) {
            log.error("\u4e1a\u52a1\u5e93\u66f4\u65b0\u5931\u8d25", (Throwable)exception);
        }
    }
}

