/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sx.biz.wgcx.dto;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.HttpMethod;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.GroupGrantee;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.Permission;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;

public class Tcs3Client {
    public AmazonS3 s3client = null;
    private String server_url = "";
    private String access_key = "";
    private String secret_key = "";
    private String protocol = "HTTP";
    private int connectionTimeout = 3000;

    public Tcs3Client() {
    }

    public Tcs3Client(String Tserver_url, String Taccess_key, String Tsecret_key) {
        this.server_url = Tserver_url;
        this.access_key = Taccess_key;
        this.secret_key = Tsecret_key;
        this.build();
    }

    public void setServer_url(String Tserver_url) {
        this.server_url = Tserver_url;
    }

    public void setAccess_key(String Taccess_key) {
        this.access_key = Taccess_key;
    }

    public void setSecret_key(String Tsecret_key) {
        this.secret_key = Tsecret_key;
    }

    public void setConnectionTimeOut(int TconnectionTimeout) {
        this.connectionTimeout = TconnectionTimeout;
    }

    public AmazonS3 getAmazonS3() {
        return this.s3client;
    }

    public void setProtocol(String Tprotocol) {
        if (!(Tprotocol.equals("HTTPS") || Tprotocol.equals("HTTP") || Tprotocol.equals("http") || Tprotocol.equals("https"))) {
            System.out.print("????:setProtocol????????HTTP??HTTPS");
        } else {
            this.protocol = Tprotocol;
        }
    }

    public Tcs3Client build() {
        BasicAWSCredentials credentials = null;
        credentials = new BasicAWSCredentials(this.access_key, this.secret_key);
        ClientConfiguration config = new ClientConfiguration();
        if (!this.protocol.equals("HTTPS") && !this.protocol.equals("https")) {
            config.setProtocol(Protocol.HTTP);
        } else {
            config.setProtocol(Protocol.HTTPS);
        }
        config.setConnectionTimeout(this.connectionTimeout);
        config.setUseExpectContinue(true);
        AwsClientBuilder.EndpointConfiguration end_point = null;
        end_point = new AwsClientBuilder.EndpointConfiguration(this.server_url, "");
        this.s3client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).withClientConfiguration(config)).withEndpointConfiguration(end_point)).withPathStyleAccessEnabled(Boolean.valueOf(true))).build();
        return this;
    }

    public List<Bucket> listBuckets() {
        return this.s3client.listBuckets();
    }

    public void createBucket(String bucketName) {
        this.s3client.createBucket(bucketName);
    }

    public void putObject(String bucketName, String objectName, String file_path) {
        this.s3client.putObject(bucketName, objectName, new File(file_path));
    }

    public void putObject(String bucketName, String objectName, File file) {
        this.s3client.putObject(bucketName, objectName, file);
    }

    public void putObjectByIn(String bucketName, String objectName, InputStream inputStream, ObjectMetadata metadata) {
        this.s3client.putObject(bucketName, objectName, inputStream, metadata);
    }

    public List<S3ObjectSummary> getOjects(String bucket_name) {
        ListObjectsV2Result result = this.s3client.listObjectsV2(bucket_name);
        List objects = result.getObjectSummaries();
        return objects;
    }

    public void uploadAppenderFile(String bucketName, String keyName, String filePath) throws Exception {
        TransferManager tm = TransferManagerBuilder.standard().withS3Client(this.s3client).build();
        Upload upload = tm.upload(bucketName, keyName, new File(filePath));
        upload.waitForCompletion();
    }

    public String getPublicUrl(String bucketName, String objectName) {
        String urlString = this.server_url + "/" + bucketName + "/" + objectName;
        return urlString;
    }

    public URL generatePresignedUrl(String bucketName, String objectName, Date expiration) throws Exception {
        GeneratePresignedUrlRequest generatePresignedUrlRequest = new GeneratePresignedUrlRequest(bucketName, objectName).withMethod(HttpMethod.GET).withExpiration(expiration);
        URL url = this.s3client.generatePresignedUrl(generatePresignedUrlRequest);
        return url;
    }

    public void setObjectAcl(String bucketName, String objectName, AccessControlList acl) {
        this.s3client.setObjectAcl(bucketName, objectName, acl);
    }

    public UploadPartResult uploadPart(UploadPartRequest request) {
        return this.s3client.uploadPart(request);
    }

    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest request) {
        return this.s3client.completeMultipartUpload(request);
    }

    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest request) {
        return this.s3client.initiateMultipartUpload(request);
    }

    public ObjectMetadata getObjectMetadata(String bucketName, String objectKey) throws Exception {
        return this.s3client.getObjectMetadata(bucketName, objectKey);
    }

    public CopyObjectResult copyObject(String sourceBucketName, String sourceObjectKey, String destBucketName, String destObjectKey) throws Exception {
        return this.s3client.copyObject(new CopyObjectRequest(sourceBucketName, sourceObjectKey, destBucketName, destObjectKey));
    }

    public S3Object getObject(String bucketName, String objectKey) {
        return this.s3client.getObject(bucketName, objectKey);
    }

    public void setObjectPublicRead(String bucketName, String objectName) {
        AccessControlList acl = new AccessControlList();
        Owner owner = new Owner();
        String id = "";
        owner.setId(id);
        acl.setOwner(owner);
        acl.grantPermission((Grantee)GroupGrantee.AllUsers, Permission.Read);
        this.s3client.setObjectAcl(bucketName, objectName, acl);
    }

    public void shutdown() {
        this.s3client.shutdown();
    }
}

