/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.nsapp.common.core.base.domain;

import com.geoway.nsapp.common.core.constants.Constants;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.postgis.Geometry;
import org.postgis.PGgeometry;

@MappedTypes(value={String.class})
@MappedJdbcTypes(value={JdbcType.OTHER})
public class GeometryTypeHandler
extends BaseTypeHandler<String> {
    public void setNonNullParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        PGgeometry pGgeometry = new PGgeometry(parameter);
        Geometry geometry = pGgeometry.getGeometry();
        geometry.setSrid(Constants.GEOMETRY_SRID.intValue());
        ps.setObject(i, pGgeometry);
    }

    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String string = rs.getString(columnName);
        return StringUtils.isBlank((CharSequence)string) ? "" : this.getResult(string);
    }

    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String string = rs.getString(columnIndex);
        return StringUtils.isBlank((CharSequence)string) ? "" : this.getResult(string);
    }

    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String string = cs.getString(columnIndex);
        return StringUtils.isBlank((CharSequence)string) ? "" : this.getResult(string);
    }

    private String getResult(String string) throws SQLException {
        PGgeometry pGgeometry = new PGgeometry(string);
        String s = pGgeometry.toString();
        return s.replace("SRID=4490;", "");
    }
}

