/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.nsapp.common.core.base.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.geoway.nsapp.common.core.enums.ResultCodeEnum;
import com.geoway.nsapp.common.core.exception.ServiceException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(value="\u7edf\u4e00\u8fd4\u56de\u7ed3\u6784")
public class RestResult<T>
implements Serializable {
    @ApiModelProperty(value="\u8bf7\u6c42\u72b6\u6001\u7801", example="200")
    private Integer code;
    @ApiModelProperty(value="\u8fd4\u56de\u6570\u636e")
    private T data;
    protected String status;
    protected String message;
    protected Long total;

    public static <T> RestResult<T> error(RestResult<?> result) {
        return RestResult.error(result.getCode(), result.getMessage());
    }

    public static <T> RestResult<T> error(Integer code, String message) {
        RestResult<T> result = new RestResult<T>();
        result.code = code;
        result.message = message;
        result.status = "FAILURE";
        return result;
    }

    public static <T> RestResult<T> error(ResultCodeEnum resultCodeEnum) {
        return RestResult.error(resultCodeEnum.getCode(), resultCodeEnum.getMessage());
    }

    public static <T> RestResult<T> error(String msg) {
        return RestResult.error(ResultCodeEnum.UNKNOWN_ERROR.getCode(), msg);
    }

    public static <T> RestResult<T> success(T data) {
        RestResult<T> result = new RestResult<T>();
        result.code = ResultCodeEnum.SUCCESS.getCode();
        result.data = data;
        result.message = "\u64cd\u4f5c\u6210\u529f\uff01";
        result.status = "OK";
        return result;
    }

    public static <T> RestResult<T> success(T data, String msg) {
        RestResult<T> result = new RestResult<T>();
        result.code = ResultCodeEnum.SUCCESS.getCode();
        result.data = data;
        result.message = msg;
        result.status = "OK";
        return result;
    }

    public static boolean isSuccess(Integer code) {
        return Objects.equals(code, ResultCodeEnum.SUCCESS.getCode());
    }

    public static <T> RestResult<T> error(ServiceException serviceException) {
        return RestResult.error(serviceException.getCode(), serviceException.getMessage());
    }

    @JsonIgnore
    public boolean isSuccess() {
        return RestResult.isSuccess(this.code);
    }

    @JsonIgnore
    public boolean isError() {
        return !this.isSuccess();
    }

    public void checkError() throws ServiceException {
        if (this.isSuccess()) {
            return;
        }
        throw new ServiceException(this.message, this.code);
    }

    public static <T> RestResult<T> buildResponseSuccess(T data) {
        RestResult<T> result = new RestResult<T>();
        result.status = "OK";
        result.message = "";
        result.data = data;
        return result;
    }

    public static <T> RestResult<T> buildEasyUIResponseFailure(String message) {
        RestResult<T> result = new RestResult<T>();
        result.status = "FAILURE";
        result.message = message;
        result.total = 0L;
        return result;
    }

    public static <T> RestResult<T> build200ResponseFailure(String message) {
        RestResult<T> result = new RestResult<T>();
        result.code = ResultCodeEnum.SUCCESS.getCode();
        result.status = "FAILURE";
        result.message = message;
        result.total = 0L;
        return result;
    }

    public Integer getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public String getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public Long getTotal() {
        return this.total;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestResult)) {
            return false;
        }
        RestResult other = (RestResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "RestResult(code=" + this.getCode() + ", data=" + this.getData() + ", status=" + this.getStatus() + ", message=" + this.getMessage() + ", total=" + this.getTotal() + ")";
    }
}

