/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.nsapp.common.core.exception;

import com.dtflys.forest.exceptions.ForestNetworkException;
import com.geoway.nsapp.common.core.base.domain.RestResult;
import com.geoway.nsapp.common.core.enums.ResultCodeEnum;
import com.geoway.nsapp.common.core.exception.FileException;
import com.geoway.nsapp.common.core.exception.ServiceException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.security.auth.login.AccountException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    public static Logger log = LogManager.getLogger(GlobalExceptionHandler.class);
    private static final String ERROR_MSG = "\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";

    @ExceptionHandler(value={DataAccessException.class})
    @ResponseBody
    public RestResult<ResultCodeEnum> error(DataAccessException e) {
        e.printStackTrace();
        log.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7\uff1a" + e);
        return RestResult.error(ResultCodeEnum.SQL_ERROR);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public RestResult<ResultCodeEnum> error(Exception e) {
        e.printStackTrace();
        log.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7\uff1a" + e);
        return RestResult.error(ResultCodeEnum.UNKNOWN_ERROR.getCode(), e.getMessage());
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseBody
    public RestResult<ResultCodeEnum> error(ServiceException e) {
        e.printStackTrace();
        log.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7\uff1a" + e);
        return RestResult.error(ResultCodeEnum.CUSTOM_ERROR.getCode(), e.getMessage());
    }

    @ExceptionHandler(value={NullPointerException.class})
    @ResponseBody
    public RestResult<ResultCodeEnum> error(NullPointerException e) {
        e.printStackTrace();
        log.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7\uff1a" + e);
        return RestResult.error(ResultCodeEnum.NULL_POINT);
    }

    @ExceptionHandler(value={IndexOutOfBoundsException.class})
    @ResponseBody
    public RestResult<ResultCodeEnum> error(IndexOutOfBoundsException e) {
        e.printStackTrace();
        log.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7\uff1a" + e);
        return RestResult.error(ResultCodeEnum.INDEX_OUT_OF_BOUNDS);
    }

    @ExceptionHandler(value={SQLException.class})
    @ResponseBody
    public RestResult<ResultCodeEnum> error(SQLException e) {
        e.printStackTrace();
        log.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7\uff1a" + e);
        return RestResult.error(ResultCodeEnum.SQL_ERROR);
    }

    @ExceptionHandler(value={FileException.class})
    @ResponseBody
    public RestResult<ResultCodeEnum> error(FileException e) {
        e.printStackTrace();
        log.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7\uff1a" + e);
        return RestResult.error(ResultCodeEnum.FILE_ERROR);
    }

    @ExceptionHandler(value={IOException.class})
    @ResponseBody
    public RestResult<ResultCodeEnum> error(IOException e) {
        e.printStackTrace();
        log.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7\uff1a" + e);
        return RestResult.error(ResultCodeEnum.IO_ERROR.getCode(), e.getMessage());
    }

    @ExceptionHandler(value={AccountException.class})
    @ResponseBody
    public RestResult<ResultCodeEnum> error(AccountException e) {
        e.printStackTrace();
        log.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7\uff1a" + e);
        return RestResult.error(ResultCodeEnum.NOT_LOGIN_ERROR);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public RestResult<ResultCodeEnum> handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        log.error(e.getMessage());
        BindingResult result = e.getBindingResult();
        StringBuilder errorMsg = new StringBuilder();
        if (result.hasErrors()) {
            List fieldErrors = result.getFieldErrors();
            fieldErrors.forEach(error -> errorMsg.append("field\uff1a").append(error.getField()).append(", msg\uff1a").append(error.getDefaultMessage()).append("\uff1b"));
        }
        return RestResult.error(ResultCodeEnum.PARAM_ERROR);
    }

    @ExceptionHandler(value={ForestNetworkException.class})
    @ResponseBody
    public RestResult<ResultCodeEnum> error(ForestNetworkException exception) {
        exception.printStackTrace();
        log.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7\uff1a" + exception);
        return RestResult.error(ResultCodeEnum.REQUEST_ERROR);
    }
}

