/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.nsapp.common.core.util;

import cn.hutool.core.bean.BeanUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class ChineseToPinyinUtil {
    private static Map<String, List<String>> pinyinMap = new HashMap<String, List<String>>();

    public static String toPinyin(String str) {
        if (BeanUtil.isEmpty(pinyinMap, (String[])new String[0])) {
            ChineseToPinyinUtil.initPinyin("/duoyinzi_dic.txt");
        }
        String py = ChineseToPinyinUtil.convertChineseToPinyin(str);
        return py;
    }

    private static String convertInitialToUpperCase(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        char[] arr = str.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            if (i == 0) {
                sb.append(String.valueOf(ch).toUpperCase());
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static String convertChineseToPinyin(String chinese) {
        StringBuffer pinyin = new StringBuffer();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        char[] arr = chinese.toCharArray();
        block2: for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            if (ch > '\u0080') {
                try {
                    String py;
                    int x;
                    String[] results = PinyinHelper.toHanyuPinyinStringArray((char)ch, (HanyuPinyinOutputFormat)defaultFormat);
                    if (results == null) {
                        return "";
                    }
                    int len = results.length;
                    if (len == 1) {
                        String py2 = results[0];
                        if (py2.contains("u:")) {
                            py2 = py2.replace("u:", "v");
                        }
                        pinyin.append(ChineseToPinyinUtil.convertInitialToUpperCase(py2));
                        continue;
                    }
                    if (results[0].equals(results[1])) {
                        pinyin.append(ChineseToPinyinUtil.convertInitialToUpperCase(results[0]));
                        continue;
                    }
                    int length = chinese.length();
                    boolean flag = false;
                    String s = null;
                    List<String> keyList = null;
                    for (x = 0; x < len; ++x) {
                        py = results[x];
                        if (py.contains("u:")) {
                            py = py.replace("u:", "v");
                        }
                        keyList = pinyinMap.get(py);
                        if (i + 3 <= length) {
                            s = chinese.substring(i, i + 3);
                            if (keyList != null && keyList.contains(s)) {
                                pinyin.append(ChineseToPinyinUtil.convertInitialToUpperCase(py));
                                flag = true;
                                break;
                            }
                        }
                        if (i + 2 <= length) {
                            s = chinese.substring(i, i + 2);
                            if (keyList != null && keyList.contains(s)) {
                                pinyin.append(ChineseToPinyinUtil.convertInitialToUpperCase(py));
                                flag = true;
                                break;
                            }
                        }
                        if (i - 2 >= 0 && i + 1 <= length) {
                            s = chinese.substring(i - 2, i + 1);
                            if (keyList != null && keyList.contains(s)) {
                                pinyin.append(ChineseToPinyinUtil.convertInitialToUpperCase(py));
                                flag = true;
                                break;
                            }
                        }
                        if (i - 1 >= 0 && i + 1 <= length) {
                            s = chinese.substring(i - 1, i + 1);
                            if (keyList != null && keyList.contains(s)) {
                                pinyin.append(ChineseToPinyinUtil.convertInitialToUpperCase(py));
                                flag = true;
                                break;
                            }
                        }
                        if (i - 1 < 0 || i + 2 > length) continue;
                        s = chinese.substring(i - 1, i + 2);
                        if (keyList == null || !keyList.contains(s)) continue;
                        pinyin.append(ChineseToPinyinUtil.convertInitialToUpperCase(py));
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    s = String.valueOf(ch);
                    for (x = 0; x < len; ++x) {
                        py = results[x];
                        if (py.contains("u:")) {
                            py = py.replace("u:", "v");
                        }
                        if ((keyList = pinyinMap.get(py)) == null || !keyList.contains(s)) continue;
                        pinyin.append(ChineseToPinyinUtil.convertInitialToUpperCase(py));
                        continue block2;
                    }
                    continue;
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                    continue;
                }
            }
            pinyin.append(arr[i]);
        }
        return ChineseToPinyinUtil.convertInitialToUpperCase(pinyin.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPinyin(String fileName) {
        InputStream file = PinyinHelper.class.getResourceAsStream(fileName);
        BufferedReader br = new BufferedReader(new InputStreamReader(file));
        String s = null;
        try {
            while ((s = br.readLine()) != null) {
                if (s == null) continue;
                String[] arr = s.split("#");
                String pinyin = arr[0];
                String chinese = arr[1];
                if (chinese == null) continue;
                String[] strs = chinese.split(" ");
                List<String> list = Arrays.asList(strs);
                pinyinMap.put(pinyin, list);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

