/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.nsapp.common.core.util;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.nsapp.common.core.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.boot.system.ApplicationHome;

public class FileUtil {
    public static String getFileNameWithoutExtention(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length()) {
            return filename.substring(0, dot);
        }
        return filename;
    }

    public static String readFileContent(File file) throws Exception {
        String encoding = "UTF-8";
        Long filelength = file.length();
        byte[] filecontent = new byte[filelength.intValue()];
        try {
            FileInputStream in = null;
            int openCount = 0;
            while (openCount < 6000 && in == null) {
                try {
                    in = new FileInputStream(file);
                }
                catch (Exception ex) {
                    ++openCount;
                    in = null;
                    Thread.sleep(10L);
                }
            }
            in.read(filecontent);
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            return new String(filecontent, encoding);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("The OS does not support " + encoding);
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileContent(File file, String newstr) throws IOException {
        String charsetName = "UTF-8";
        Boolean bool = false;
        String filein = newstr;
        String temp = "";
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        FileOutputStream fos = null;
        PrintWriter pw = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            fis = new FileInputStream(file);
            isr = new InputStreamReader((InputStream)fis, charsetName);
            br = new BufferedReader(isr);
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while ((temp = br.readLine()) != null) {
                buffer.append(temp);
                buffer = buffer.append(System.getProperty("line.separator"));
                ++i;
            }
            buffer.append(filein);
            fos = new FileOutputStream(file);
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)fos, charsetName)));
            pw.write(buffer.toString().toCharArray());
            pw.flush();
            bool = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return bool;
    }

    public static File findFiles(File baseDir, String targetFileName) {
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            System.out.println("\u6587\u4ef6\u67e5\u627e\u5931\u8d25\uff1a" + baseDir.getAbsolutePath() + "\u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55\uff01");
        }
        File targetFile = null;
        File[] files = baseDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File tempFile = files[i];
            if (tempFile.isFile()) {
                if (!targetFileName.equals(tempFile.getName())) continue;
                targetFile = tempFile;
                break;
            }
            if (tempFile.isDirectory() && (targetFile = FileUtil.findFiles(tempFile, targetFileName)) != null) break;
        }
        return targetFile;
    }

    public static void findFiles(File baseDir, String targetFileName, List fileList) {
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            System.out.println("\u6587\u4ef6\u67e5\u627e\u5931\u8d25\uff1a" + baseDir.getName() + "\u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55\uff01");
        }
        String tempName = null;
        File[] files = baseDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File tempFile = files[i];
            if (tempFile.isDirectory()) {
                FileUtil.findFiles(tempFile, targetFileName, fileList);
                continue;
            }
            if (!tempFile.isFile() || !FileUtil.wildcardMatch(targetFileName, tempName = tempFile.getName())) continue;
            fileList.add(tempFile.getAbsoluteFile());
        }
    }

    private static boolean wildcardMatch(String pattern, String str) {
        int patternLength = pattern.length();
        int strLength = str.length();
        int strIndex = 0;
        for (int patternIndex = 0; patternIndex < patternLength; ++patternIndex) {
            char ch = pattern.charAt(patternIndex);
            if (ch == '*') {
                while (strIndex < strLength) {
                    if (FileUtil.wildcardMatch(pattern.substring(patternIndex + 1), str.substring(strIndex))) {
                        return true;
                    }
                    ++strIndex;
                }
                continue;
            }
            if (ch == '?') {
                if (++strIndex <= strLength) continue;
                return false;
            }
            if (strIndex >= strLength || ch != str.charAt(strIndex)) {
                return false;
            }
            ++strIndex;
        }
        return strIndex == strLength;
    }

    public static String getSystemPath(Class<?> tar) {
        ApplicationHome h = new ApplicationHome(tar);
        return h.getSource().getParentFile().toString();
    }

    public static File seachFileBySuffix(File dir, String suffix) {
        File[] subFiles;
        File foundFile = null;
        for (File subFile : subFiles = dir.listFiles()) {
            if (subFile.isFile()) {
                if (!subFile.getName().endsWith(suffix)) continue;
                foundFile = subFile;
                break;
            }
            foundFile = FileUtil.seachFileBySuffix(subFile, suffix);
            if (foundFile != null) break;
        }
        return foundFile;
    }

    public static void deleteFile(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return;
        }
        for (File f : files = file.listFiles()) {
            if (f.isDirectory()) {
                FileUtil.deleteFile(f);
                continue;
            }
            f.delete();
        }
        file.delete();
    }

    public static String getContentType(String fileName) {
        if (fileName == null) {
            return "application/octet-stream";
        }
        String lowerCaseName = fileName.toLowerCase();
        if (lowerCaseName.endsWith(".jpg") || lowerCaseName.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (lowerCaseName.endsWith(".png")) {
            return "image/png";
        }
        if (lowerCaseName.endsWith(".gif")) {
            return "image/gif";
        }
        if (lowerCaseName.endsWith(".pdf")) {
            return "application/pdf";
        }
        if (lowerCaseName.endsWith(".doc")) {
            return "application/msword";
        }
        if (lowerCaseName.endsWith(".docx")) {
            return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
        }
        if (lowerCaseName.endsWith(".xls")) {
            return "application/vnd.ms-excel";
        }
        if (lowerCaseName.endsWith(".xlsx")) {
            return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        }
        if (lowerCaseName.endsWith(".ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (lowerCaseName.endsWith(".pptx")) {
            return "application/vnd.openxmlformats-officedocument.presentationml.presentation";
        }
        if (lowerCaseName.endsWith(".mp4")) {
            return "video/mp4";
        }
        if (lowerCaseName.endsWith(".mp3")) {
            return "audio/mpeg";
        }
        if (lowerCaseName.endsWith(".txt")) {
            return "text/plain";
        }
        if (lowerCaseName.endsWith(".json")) {
            return "application/json";
        }
        if (lowerCaseName.endsWith(".xml")) {
            return "application/xml";
        }
        if (lowerCaseName.endsWith(".html")) {
            return "text/html";
        }
        if (lowerCaseName.endsWith(".css")) {
            return "text/css";
        }
        if (lowerCaseName.endsWith(".js")) {
            return "application/javascript";
        }
        if (lowerCaseName.endsWith(".zip")) {
            return "application/zip";
        }
        if (lowerCaseName.endsWith(".rar")) {
            return "application/x-rar-compressed";
        }
        if (lowerCaseName.endsWith(".7z")) {
            return "application/x-7z-compressed";
        }
        return "application/octet-stream";
    }

    public static void main(String[] args) {
        ArrayList list = new ArrayList();
        System.out.println(StringUtils.join(list, (String)","));
        System.out.println(StrUtil.join((CharSequence)",", (Object[])new Object[]{list}));
        String filePath = "D:\\upload\\234";
        String a = null;
        JSONObject jo = JSON.parseObject(a);
        JSONArray arr = JSON.parseArray(a);
        boolean t = false;
        HashSet<String> set = new HashSet<String>();
        set.add("a");
        if (set.contains("a")) {
            System.out.println("contains!");
        }
    }
}

